#!/bin/bash

# Directory containing the configuration files
CONFIG_DIR="./configs"

# Iterate over the configuration files excluding those with "1" as xxx
for CONFIG_FILE in ${CONFIG_DIR}/exp_90degree_ANS_NAVMESH_MAP_5000STEPS_*.yaml; do
    # Extract the part after the last underscore to check for "1"
    BASENAME=$(basename "$CONFIG_FILE")
    XXX=${BASENAME##*_}
    XXX=${XXX%.yaml} # Remove the .yaml extension
    
    # Skip if xxx is exactly "1"
    if [ "$XXX" == "1" ]; then
        echo "Skipping config: $CONFIG_FILE (xxx is 1)"
        continue
    fi

    echo "Running command with config: $BASENAME"
    python main_eval_sg.py --config="$BASENAME"
done
