import os
import numpy as np

filelog = 'output/visualize_grid_traj'
nums = []
all_steps = []
files = [x for x in os.listdir(filelog) if x.endswith('.npy')]
for file in files:
    file_path = os.path.join(filelog, file)
    print("file: ", file)
    result = np.load(file_path, allow_pickle=True).item()
    percent = result[0]['percent']
    steps = result[0]['steps']

    nums.append(percent)
    all_steps.append(steps)

print(f"mean coverage: {np.mean(nums)}, mean steps: {np.mean(all_steps)}")
