from openai import OpenAI
import json
from tqdm import tqdm

client = OpenAI(api_key="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")

def generate_navigation_steps(instruction):
    prompt = f"""
    You are given a scene graph representing an entire house, including floors, rooms, and objects.
    I will provide a language instruction, and you need to break it down into a sequence of navigation steps in the following format:
    
    Step X: Target Type, Target Name, Target Description
    
    Guidelines:
    - Focus only on navigation steps—do not include actions related to manipulating objects.
    - Identify floors, rooms, and objects sequentially as needed to reach the final target.
    - If a target is described relative to another feature (e.g., "next to the bathroom"), reflect that relationship in the description.
    - The target description should provide enough information to uniquely identify the target.

    Examples:
    Example 1:
    Instruction: "Go to the bathroom closest to the kitchen and open up the cabinet."
    Output:
    Step 0, Room, kitchen, None
    Step 1, Room, bathroom, closest to the kitchen
    Step 2, Object, cabinet, None
    
    Example 2:
    Instruction: "Go to the hallway next to the bathroom on Level 4 and look at the flower picture."
    Output:
    Step 0, Floor, Level 4, None
    Step 1, Room, bathroom, None
    Step 2, Room, hallway, next to the bathroom
    Step 3, Object, flower picture, None
    
    Now process the following instruction:
    Instruction: "{instruction}"
    Output:
    """
    
    completion = client.chat.completions.create(
        model="gpt-4o",
        messages=[
            {"role": "system", "content": "You are an expert in parsing natural language instructions into structured navigation steps."},
            {"role": "user", "content": prompt}
        ],
        temperature=0.0,
    )
    
    return completion.choices[0].message

# Example usage
with open("gTV8FGcVJC9_enc.json", "r") as f:
    data = json.load(f)

new_data = []
for item in tqdm(data):
    item['parsed_instructions'] = []
    for inst in item["instructions"]:
        output = generate_navigation_steps(inst).content
        item['parsed_instructions'].append(output)
    
    new_data.append(item)

with open("parsed_gTV8FGcVJC9_enc.json", "w") as f:
    json.dump(new_data, f, indent=4)
        
