import os
import json
from collections import defaultdict

with open("parsed_gTV8FGcVJC9_enc.json", "r") as f:
    data = json.load(f)

stat = defaultdict(list)
for item in data:
    parsed_instructions = item['parsed_instructions']
    for inst in parsed_instructions:
        steps = inst.split("\n")
        for step in steps:
            if "Step" not in step:
                continue
            try:
                step_num, ttype, tname, tdesc = step.split(", ")
            except:
                print(inst)
                exit(0)
            if 'None' not in tdesc:
                stat[ttype].append(tdesc)
            
            if 'Floor' in step:
                stat[ttype].append(tname)
            

with open("parsed_gTV8FGcVJC9_enc_stat.json", "w") as f:
    json.dump(stat, f, indent=4)