import os
import json
import numpy as np

scan = "8WUmhLawc2A"
with open(f"object_coords_{scan}.json", "r") as f:
    object_coords = json.load(f)

with open(f"query_results_Nav3DSG_{scan}.json", "r") as f:
    query_results = json.load(f)

top1_acc = 0
top5_acc = 0
for ins_id, result in query_results.items():
    instr = result["query"]
    obj_id = ins_id.split("_")[1]
    target_position = result["target_position"]
    target_pos = [target_position[0], target_position[2]]

    gt_coords = [object_coords[obj_id]['px'], object_coords[obj_id]['pz']]
    obj_name = object_coords[obj_id]['category']


    pred_dist = np.linalg.norm(np.array(gt_coords) - np.array(target_pos))

    if pred_dist <= 3:
        # print(f"Correctly predicted object {obj_name} for instruction: {instr}")
        top1_acc += 1
    
print(f"Top 1 accuracy: {top1_acc/len(query_results)}")
