import os
import json
import numpy as np

# scan = "8WUmhLawc2A"
scan = "gTV8FGcVJC9"
with open(f"object_coords_{scan}.json", "r") as f:
    object_coords = json.load(f)

with open(f"query_results_{scan}.json", "r") as f:
    query_results = json.load(f)


top1_acc = 0
cnt = 0
dists = []
for ins_id, result in query_results.items():
    instr = result["query"]
    cnt += 1
    obj_id = ins_id.split("_")[1]
    object_centers = result["object_centers"]
    object_centers = [[oc[0], oc[2]] for oc in object_centers]

    gt_coords = [object_coords[obj_id]['px'], object_coords[obj_id]['pz']]
    obj_name = object_coords[obj_id]['category']


    pred_dist = [np.linalg.norm(np.array(gt_coords) - np.array(oc)) for oc in object_centers]
    if len(pred_dist) == 0:
        print(f"No objects found for instruction: {ins_id}")
        continue

    if pred_dist[0] <= 3:
        top1_acc += 1
    dists.append(pred_dist[0])
    
print(f"Total instructions: {cnt}")
print(f"Top 1 accuracy: {top1_acc/len(query_results)}")
print(f"Average distance: {np.mean(dists)}")
