import json
from tqdm import tqdm
from copy import deepcopy

from hovsg.graph.graph import Graph
import hydra
import open3d as o3d
from omegaconf import DictConfig

# pylint: disable=all


@hydra.main(version_base=None, config_path="../config", config_name="visualize_query_graph")
def main(params: DictConfig):
    # Load graph
    hovsg = Graph(params)
    hovsg.load_graph(params.main.graph_path)

    with open("REVERIE_Navigation/mp3d_room_types.txt", "r") as f:
        room_types = f.readlines()
    room_types = [r.strip() for r in room_types]

    # generate room names
    hovsg.generate_room_names(
            generate_method="view_embedding",
            default_room_types=room_types)
    
    scan = "8WUmhLawc2A"
    with open(f"REVERIE_Navigation/{scan}_enc.json", "r") as f:
        nav_data = json.load(f)
    
    results = {}
    for item in tqdm(nav_data):
        item_id = item['id']
        for idx, inst in enumerate(item['instructions']):
            query = inst
            print(query)
            floor, room, obj = hovsg.query_hierarchy(query, top_k=5)
            for o in obj:
                print(o.pcd)
                print(o.pcd.get_center())
            # visualize the query
            # print(floor.floor_id, [(r.room_id, r.name) for r in room], [o.object_id for o in obj])
            # # use open3d to visualize room.pcd and color the points where obj.pcd is
            # for i in range(len(obj)):
            #     obj_pcd = obj[i].pcd.paint_uniform_color([0, 1, 0])
            #     room_pcd = room[i].pcd
            #     obj_pcd = deepcopy(obj[i].pcd)
            #     room_pcd = deepcopy(room[i].pcd)
            #     print(obj_pcd.get_center())
            #     o3d.visualization.draw_geometries([room_pcd, obj_pcd])
            inst_id = f"{item_id}_{idx}"
            results[inst_id] = {
                "query": query,
                "floor_id": floor.floor_id if floor else None,
                "rooms": [(r.room_id, r.name) for r in room],
                "objects": [o.object_id for o in obj],
                "object_centers": [o.pcd.get_center().tolist() for o in obj]
            }
    
        with open(f"REVERIE_Navigation/query_results_{scan}.json", "w") as f:
            json.dump(results, f, indent=4)


if __name__ == "__main__":
    main()
