"""Label file for different datasets."""

CLIP_DIM = {
    "ViT-L-14": 768,
    "ViT-H-14": 1024,
}

SCANNET_LABELS_20 = (
    "wall",
    "floor",
    "cabinet",
    "bed",
    "chair",
    "sofa",
    "table",
    "door",
    "window",
    "bookshelf",
    "picture",
    "counter",
    "desk",
    "curtain",
    "refrigerator",
    "shower curtain",
    "toilet",
    "sink",
    "bathtub",
    "furniture",
    "background",
)

SCANNET_LABELS_20_CF = (
    "cabinet",
    "bed",
    "chair",
    "sofa",
    "table",
    "bookshelf",
    "picture",
    "counter",
    "desk",
    "curtain",
    "refrigerator",
    "shower curtain",
    "toilet",
    "sink",
    "bathtub",
    "furniture",
)


MATTERPORT_LABELS_21 = (
    "wall",
    "floor",
    "cabinet",
    "bed",
    "chair",
    "sofa",
    "table",
    "door",
    "window",
    "bookshelf",
    "picture",
    "counter",
    "desk",
    "curtain",
    "refrigerator",
    "shower curtain",
    "toilet",
    "sink",
    "bathtub",
    "other",
    "ceiling",
)

MATTERPORT_LABELS_40 = (
    "wall",
    "door",
    "ceiling",
    "floor",
    "picture",
    "window",
    "chair",
    "pillow",
    "lamp",
    "cabinet",
    "curtain",
    "table",
    "plant",
    "mirror",
    "towel",
    "sink",
    "shelves",
    "sofa",
    "bed",
    "night stand",
    "toilet",
    "column",
    "banister",
    "stairs",
    "stool",
    "vase",
    "television",
    "pot",
    "desk",
    "box",
    "coffee table",
    "counter",
    "bench",
    "garbage bin",
    "fireplace",
    "clothes",
    "bathtub",
    "book",
    "air vent",
    "faucet",
)

MATTERPORT_LABELS_80 = (
    "wall",
    "door",
    "ceiling",
    "floor",
    "picture",
    "window",
    "chair",
    "pillow",
    "lamp",
    "cabinet",
    "curtain",
    "table",
    "plant",
    "mirror",
    "towel",
    "sink",
    "shelves",
    "sofa",
    "bed",
    "night stand",
    "toilet",
    "column",
    "banister",
    "stairs",
    "stool",
    "vase",
    "television",
    "pot",
    "desk",
    "box",
    "coffee table",
    "counter",
    "bench",
    "garbage bin",
    "fireplace",
    "clothes",
    "bathtub",
    "book",
    "air vent",
    "faucet",
    "photo",
    "toilet paper",
    "fan",
    "railing",
    "sculpture",
    "dresser",
    "rug",
    "ottoman",
    "bottle",
    "refridgerator",
    "bookshelf",
    "wardrobe",
    "pipe",
    "monitor",
    "stand",
    "drawer",
    "container",
    "light switch",
    "purse",
    "door way",
    "basket",
    "chandelier",
    "oven",
    "clock",
    "stove",
    "washing machine",
    "shower curtain",
    "fire alarm",
    "bin",
    "chest",
    "microwave",
    "blinds",
    "bowl",
    "tissue box",
    "plate",
    "tv stand",
    "shoe",
    "heater",
    "headboard",
    "bucket",
)

MATTERPORT_LABELS_160 = (
    "wall",
    "door",
    "ceiling",
    "floor",
    "picture",
    "window",
    "chair",
    "pillow",
    "lamp",
    "cabinet",
    "curtain",
    "table",
    "plant",
    "mirror",
    "towel",
    "sink",
    "shelves",
    "sofa",
    "bed",
    "night stand",
    "toilet",
    "column",
    "banister",
    "stairs",
    "stool",
    "vase",
    "television",
    "pot",
    "desk",
    "box",
    "coffee table",
    "counter",
    "bench",
    "garbage bin",
    "fireplace",
    "clothes",
    "bathtub",
    "book",
    "air vent",
    "faucet",
    "photo",
    "toilet paper",
    "fan",
    "railing",
    "sculpture",
    "dresser",
    "rug",
    "ottoman",
    "bottle",
    "refridgerator",
    "bookshelf",
    "wardrobe",
    "pipe",
    "monitor",
    "stand",
    "drawer",
    "container",
    "light switch",
    "purse",
    "door way",
    "basket",
    "chandelier",
    "oven",
    "clock",
    "stove",
    "washing machine",
    "shower curtain",
    "fire alarm",
    "bin",
    "chest",
    "microwave",
    "blinds",
    "bowl",
    "tissue box",
    "plate",
    "tv stand",
    "shoe",
    "heater",
    "headboard",
    "bucket",
    "candle",
    "flower pot",
    "speaker",
    "furniture",
    "sign",
    "air conditioner",
    "fire extinguisher",
    "curtain rod",
    "floor mat",
    "printer",
    "telephone",
    "blanket",
    "handle",
    "shower head",
    "soap",
    "keyboard",
    "thermostat",
    "radiator",
    "kitchen island",
    "paper towel",
    "sheet",
    "glass",
    "dishwasher",
    "cup",
    "ladder",
    "garage door",
    "hat",
    "exit sign",
    "piano",
    "board",
    "rope",
    "ball",
    "excercise equipment",
    "hanger",
    "candlestick",
    "light",
    "scale",
    "bag",
    "laptop",
    "treadmill",
    "guitar",
    "display case",
    "toilet paper holder",
    "bar",
    "tray",
    "urn",
    "decorative plate",
    "pool table",
    "jacket",
    "bottle of soap",
    "water cooler",
    "utensil",
    "tea pot",
    "stuffed animal",
    "paper towel dispenser",
    "lamp shade",
    "car",
    "toilet brush",
    "doll",
    "drum",
    "whiteboard",
    "range hood",
    "candelabra",
    "toy",
    "foot rest",
    "soap dish",
    "placemat",
    "cleaner",
    "computer",
    "knob",
    "paper",
    "projector",
    "coat hanger",
    "case",
    "pan",
    "luggage",
    "trinket",
    "chimney",
    "person",
    "alarm",
)

NUSCENES_LABELS_16 = (
    "barrier",
    "bicycle",
    "bus",
    "car",
    "construction vehicle",
    "motorcycle",
    "person",
    "traffic cone",
    "trailer",
    "truck",
    "drivable surface",
    "other flat",
    "sidewalk",
    "terrain",
    "manmade",
    "vegetation",
)


NUSCENES_LABELS_DETAILS = (
    "barrier",
    "barricade",
    "bicycle",
    "bus",
    "car",
    "bulldozer",
    "excavator",
    "concrete mixer",
    "crane",
    "dump truck",
    "motorcycle",
    "person",
    "pedestrian",
    "traffic cone",
    "trailer",
    "semi trailer",
    "cargo container",
    "shipping container",
    "freight container",
    "truck",
    "road",
    "curb",
    "traffic island",
    "traffic median",
    "sidewalk",
    "grass",
    "grassland",
    "lawn",
    "meadow",
    "turf",
    "sod",
    "building",
    "wall",
    "pole",
    "awning",
    "tree",
    "trunk",
    "tree trunk",
    "bush",
    "shrub",
    "plant",
    "flower",
    "woods",
)


raw_category_to_nyu20_dict = {
    "wall": ["wall"],
    "floor": ["floor", "carpet"],
    "cabinet": ["cabinet", "kitchen cabinet", "kitchen cabinets", "cabinets"],
    "bed": ["bed", "loft bed", "bunk bed", "bedframe"],
    "chair": ["chair", "office chair", "armchair"],
    "sofa": ["sofa", "couch", "sofa chair", "sofa bed", "sofa chair"],
    "table": ["table", "desk", "coffee table", "end table", "dining table"],
    "door": ["door", "doorframe", "doors", "closet doors", "bathroom stall door", "sliding door"],
    "window": ["window", "windowsill", "glass doors"],
    "bookshelf": ["bookshelf", "bookshelves"],
    "picture": ["picture"],
    "counter": ["counter"],
    "desk": ["desk", "desk lamp"],
    "curtain": ["curtain", "shower curtain", "shower curtain rod"],
    "refrigerator": ["refrigerator"],
    "shower curtain": ["shower curtain"],
    "toilet": ["toilet"],
    "sink": ["sink"],
    "bathtub": ["bathtub"],
    "otherfurniture": [
        "object",
        "trash can",
        "pillow",
        "ceiling",
        "box",
        "monitor",
        "shelf",
        "towel",
        "backpack",
        "lamp",
        "mirror",
        "plant",
        "whiteboard",
        "radiator",
        "book",
        "toilet paper",
        "armchair",
        "shoes",
        "bag",
        "clothes",
        "keyboard",
        "bottle",
        "recycling bin",
        "nightstand",
        "stool",
        "tv",
        "file cabinet",
        "dresser",
        "computer tower",
        "clothing",
        "telephone",
        "cup",
        "microwave",
        "paper towel dispenser",
        "bathroom vanity",
        "suitcase",
        "laptop",
        "ottoman",
        "printer",
        "board",
        "soap dispenser",
        "light",
        "closet wall",
        "mini fridge",
        "fan",
        "tissue box",
        "blanket",
        "bathroom stall",
        "copier",
        "bench",
        "bar",
        "soap dish",
        "laundry hamper",
        "storage bin",
        "light switch",
        "coffee maker",
        "tv stand",
        "decoration",
        "ceiling light",
        "range hood",
        "blackboard",
        "clock",
        "wardrobe closet",
        "rail",
        "bulletin board",
        "mat",
        "trash bin",
        "ledge",
        "seat",
        "mouse",
        "basket",
        "dumbbell",
        "paper",
        "person",
        "bucket",
        "sign",
        "speaker",
        "container",
        "stair rail",
        "tube",
        "papers",
        "storage container",
        "paper bag",
        "paper towel roll",
        "ball",
        "laundry basket",
        "cart",
        "dish rack",
        "stairs",
        "stack of chairs",
        "purse",
        "bicycle",
        "tray",
        "plunger",
        "paper cutter",
        "boxes",
        "bin",
        "guitar",
        "mailboxes",
        "handicap bar",
        "fire extinguisher",
        "ladder",
        "column",
        "pipe",
        "vacuum cleaner",
        "plate",
        "piano",
        "water cooler",
        "cd case",
        "bowl",
        "closet rod",
        "bathroom counter",
        "oven",
        "stand",
        "scale",
        "washing machine",
        "broom",
        "hat",
        "guitar case",
        "rack",
        "water pitcher",
        "laundry detergent",
        "hair dryer",
        "pillar",
        "divider",
        "power outlet",
        "shower wall",
        "shower control valve",
        "exercise machine",
        "compost bin",
        "shorts",
        "tire",
        "teddy bear",
        "bathrobe",
        "handrail",
        "faucet",
        "thermos",
        "rug",
        "couch cushions",
        "tripod",
        "mailbox",
        "tupperware",
        "shoe rack",
        "towels",
        "beer bottles",
        "treadmill",
        "salt",
        "chest",
        "dispenser",
        "mirror doors",
        "remote",
        "folded ladder",
        "cushion",
        "carton",
        "step",
        "drying rack",
        "slippers",
        "pool table",
        "soda stream",
        "toilet brush",
        "cooking pot",
        "heater",
        "messenger bag",
        "stapler",
        "scanner",
        "elliptical machine",
        "kettle",
        "metronome",
        "dumbell",
        "music book",
        "rice cooker",
        "dart board",
        "sewing machine",
        "grab bar",
        "flowerpot",
        "painting",
        "railing",
        "stair",
        "toolbox",
        "nerf gun",
        "binders",
        "quadcopter",
        "pitcher",
        "hanging",
        "mail",
        "closet ceiling",
        "hoverboard",
        "beanbag chair",
        "water heater",
        "spray bottle",
        "rope",
        "plastic container",
        "soap bottle",
        "ikea bag",
        "sleeping bag",
        "duffel bag",
        "frying pan",
        "oven mitt",
        "pot",
        "hand dryer",
        "dollhouse",
        "shampoo bottle",
        "hair brush",
        "tennis racket",
        "display case",
        "ping pong table",
        "boiler",
        "bag of coffee beans",
        "bananas",
        "carseat",
        "helmet",
        "umbrella",
        "coffee box",
        "envelope",
        "wet floor sign",
        "clothing rack",
        "controller",
        "bath walls",
        "podium",
        "storage box",
        "dolly",
        "shampoo",
        "paper tray",
        "changing station",
        "poster printer",
        "screen",
        "soap bar",
        "crutches",
    ],
}

MAPPING_NUSCENES_DETAILS = (
    0,
    0,
    1,
    2,
    3,
    4,
    4,
    4,
    4,
    4,
    5,
    6,
    6,
    7,
    8,
    8,
    8,
    8,
    8,
    9,
    10,
    11,
    11,
    11,
    12,
    13,
    13,
    13,
    13,
    13,
    13,
    14,
    14,
    14,
    14,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
)


NUSCENES16_COLORMAP = {
    1: (220, 220, 0),  # barrier
    2: (119, 11, 32),  # bicycle
    3: (0, 60, 100),  # bus
    4: (0, 0, 250),  # car
    5: (230, 230, 250),  # construction vehicle
    6: (0, 0, 230),  # motorcycle
    7: (220, 20, 60),  # person
    8: (250, 170, 30),  # traffic cone
    9: (200, 150, 0),  # trailer
    10: (0, 0, 110),  # truck
    11: (128, 64, 128),  # road
    12: (0, 250, 250),  # other flat
    13: (244, 35, 232),  # sidewalk
    14: (152, 251, 152),  # terrain
    15: (70, 70, 70),  # manmade
    16: (107, 142, 35),  # vegetation
    17: (0, 0, 0),  # unknown
}

SCANNET_COLOR_MAP_20 = {
    0: (174.0, 199.0, 232.0),
    1: (152.0, 223.0, 138.0),
    2: (31.0, 119.0, 180.0),
    3: (255.0, 187.0, 120.0),
    4: (188.0, 189.0, 34.0),
    5: (140.0, 86.0, 75.0),
    6: (255.0, 152.0, 150.0),
    7: (214.0, 39.0, 40.0),
    8: (197.0, 176.0, 213.0),
    9: (148.0, 103.0, 189.0),
    10: (196.0, 156.0, 148.0),
    11: (23.0, 190.0, 207.0),
    12: (247.0, 182.0, 210.0),
    13: (219.0, 219.0, 141.0),
    14: (255.0, 127.0, 14.0),
    15: (158.0, 218.0, 229.0),
    16: (44.0, 160.0, 44.0),
    17: (112.0, 128.0, 144.0),
    18: (227.0, 119.0, 194.0),
    19: (82.0, 84.0, 163.0),
    20: (0.0, 0.0, 0.0),  # unlabel/unknown
}

SCANNET_COLOR_MAP_20_CF = {
    0: (31.0, 119.0, 180.0),
    1: (255.0, 187.0, 120.0),
    2: (188.0, 189.0, 34.0),
    3: (140.0, 86.0, 75.0),
    4: (255.0, 152.0, 150.0),
    5: (148.0, 103.0, 189.0),
    6: (196.0, 156.0, 148.0),
    7: (23.0, 190.0, 207.0),
    8: (247.0, 182.0, 210.0),
    9: (219.0, 219.0, 141.0),
    10: (255.0, 127.0, 14.0),
    11: (158.0, 218.0, 229.0),
    12: (44.0, 160.0, 44.0),
    13: (112.0, 128.0, 144.0),
    14: (227.0, 119.0, 194.0),
    15: (82.0, 84.0, 163.0),
    16: (0.0, 0.0, 0.0),  # unlabel/unknown
}

MATTERPORT_GT_COLOR_MAP = {
    0: (255, 255, 255),
    1: (174, 199, 232),
    2: (112, 128, 144),
    3: (152, 223, 138),
    4: (197, 176, 213),
    5: (255, 127, 14),
    6: (214, 39, 40),
    7: (31, 119, 180),
    8: (188, 189, 34),
    9: (255, 152, 150),
    10: (44, 160, 44),
    11: (227, 119, 194),
    12: (222, 158, 214),
    13: (148, 103, 189),
    14: (140, 162, 82),
    15: (132, 60, 57),
    16: (158, 218, 229),
    17: (156, 158, 222),
    18: (231, 150, 156),
    19: (99, 121, 57),
    20: (140, 86, 75),
    21: (219, 219, 141),
    22: (214, 97, 107),
    23: (206, 219, 156),
    24: (231, 186, 82),
    25: (57, 59, 121),
    26: (165, 81, 148),
    27: (173, 73, 74),
    28: (181, 207, 107),
    29: (82, 84, 163),
    30: (189, 158, 57),
    31: (196, 156, 148),
    32: (247, 182, 210),
    33: (107, 110, 207),
    34: (255, 187, 120),
    35: (199, 199, 199),
    36: (140, 109, 49),
    37: (231, 203, 148),
    38: (206, 109, 189),
    39: (23, 190, 207),
    40: (127, 127, 127),
    41: (0, 0, 0),
}


MATTERPORT_GT_COLOR_MAP_HEX = {
    0: "#ffffff",
    1: "#aec7e8",
    2: "#708090",
    3: "#98df8a",
    4: "#c5b0d5",
    5: "#ff7f0e",
    6: "#d62728",
    7: "#1f77b4",
    8: "#bcbd22",
    9: "#ff9896",
    10: "#2ca02c",
    11: "#e377c2",
    12: "#de9ed6",
    13: "#9467bd",
    14: "#8ca252",
    15: "#843c39",
    16: "#9edae5",
    17: "#9c9ede",
    18: "#e7969c",
    19: "#637939",
    20: "#8c564b",
    21: "#dbdb8d",
    22: "#d6616b",
    23: "#cedb9c",
    24: "#e7ba52",
    25: "#393b79",
    26: "#a55194",
    27: "#ad494a",
    28: "#b5cf6b",
    29: "#5254a3",
    30: "#bd9e39",
    31: "#c49c94",
    32: "#f7b6d2",
    33: "#6b6ecf",
    34: "#ffbb78",
    35: "#c7c7c7",
    36: "#8c6d31",
    37: "#e7cb94",
    38: "#ce6dbd",
    39: "#17becf",
    40: "#7f7f7f",
    41: "#000000",
}


OPENVOCAB_MATTERPORT_LABELS = {
    "void": ["void"],
    "wall": ["wall", "baseboard", "paneling"],
    "floor": ["floor", "rug", "mat", "bath_mat", "landing", "floor_mat"],
    "chair": ["chair", "beanbag"],
    "door": ["door", "doorframe", "doorway", "doorknob", "archway"],
    "table": ["table", "dressing", "desk"],
    "picture": ["picture", "photograph", "picture_frame"],
    "cabinet": ["cabinet", "cupboard"],
    "cushion": ["cushion", "pillow"],
    "window": ["window", "windowsill", "window_frame", "windowpane", "window_screen"],
    "sofa": ["sofa"],
    "bed": ["bed", "bedpost", "bedstead", "headboard", "footboard", "bedspread", "mattress", "sheet"],
    "curtain": ["curtain", "shower_curtain"],
    "chest_of_drawers": ["chest_of_drawers", "drawer", "dresser", "night_stand"],
    "plant": ["plant"],
    "sink": ["sink"],
    "stairs": ["step", "stairway", "stairwell"],
    "ceiling": ["ceiling", "roof"],
    "toilet": ["toilet", "bidet"],
    "stool": ["stool"],
    "towel": ["towel"],
    "mirror": ["mirror"],
    "tv_monitor": ["tv_monitor", "display", "television"],
    "shower": ["shower", "showerhead"],
    "column": ["column", "post"],
    "bathtub": ["bathtub"],
    "counter": ["countertop", "counter", "kitchen_island"],
    "fireplace": ["fireplace", "mantel"],
    "lighting": ["lighting", "lamp", "lampshade", "light", "chandelier", "spotlight"],
    "beam": ["beam"],
    "railing": ["railing", "bannister"],
    "shelving": ["shelving", "bookshelf", "shelf", "rack", "shelves"],
    "blinds": ["blinds", "window_blind"],
    "gym_equipment": ["gym_equipment", "sports_equipment", "treadmill", "exercise_bike"],
    "seating": ["seating", "bench", "seat"],
    "board_panel": ["board_panel", "panel", "whiteboard"],
    "furniture": ["furniture", "otherfurniture"],
    "appliances": ["appliances", "home_appliance", "stove", "dryer", "refridgerator"],
    "clothes": ["clothes", "clothing"],
    "objects": ["physical_object", "material", "books", "paper", "box", "bag", "otherprop"],
    "misc": ["misc", "person", "otherstructure"],
    "unlabeled": ["unlabeled", "unknown"],
}


MATTERPORT_GT_LABELS = {
    0: "void",
    1: "wall",
    2: "floor",
    3: "chair",
    4: "door",
    5: "table",
    6: "picture",
    7: "cabinet",
    8: "cushion",
    9: "window",
    10: "sofa",
    11: "bed",
    12: "curtain",
    13: "chest_of_drawers",
    14: "plant",
    15: "sink",
    16: "stairs",
    17: "ceiling",
    18: "toilet",
    19: "stool",
    20: "towel",
    21: "mirror",
    22: "tv_monitor",
    23: "shower",
    24: "column",
    25: "bathtub",
    26: "counter",
    27: "fireplace",
    28: "lighting",
    29: "beam",
    30: "railing",
    31: "shelving",
    32: "blinds",
    33: "gym_equipment",
    34: "seating",
    35: "board_panel",
    36: "furniture",
    37: "appliances",
    38: "clothes",
    39: "objects",
    40: "misc",
    41: "unlabeled",
}
MATTERPORT_GT_LABELS_INV = {v: k for k, v in MATTERPORT_GT_LABELS.items()}


MATTERPORT_COLOR_MAP_21 = {
    1: (174.0, 199.0, 232.0),  # wall
    2: (152.0, 223.0, 138.0),  # floor
    3: (31.0, 119.0, 180.0),  # cabinet
    4: (255.0, 187.0, 120.0),  # bed
    5: (188.0, 189.0, 34.0),  # chair
    6: (140.0, 86.0, 75.0),  # sofa
    7: (255.0, 152.0, 150.0),  # table
    8: (214.0, 39.0, 40.0),  # door
    9: (197.0, 176.0, 213.0),  # window
    10: (148.0, 103.0, 189.0),  # bookshelf
    11: (196.0, 156.0, 148.0),  # picture
    12: (23.0, 190.0, 207.0),  # counter
    14: (247.0, 182.0, 210.0),  # desk
    16: (219.0, 219.0, 141.0),  # curtain
    24: (255.0, 127.0, 14.0),  # refrigerator
    28: (158.0, 218.0, 229.0),  # shower curtain
    33: (44.0, 160.0, 44.0),  # toilet
    34: (112.0, 128.0, 144.0),  # sink
    36: (227.0, 119.0, 194.0),  # bathtub
    39: (82.0, 84.0, 163.0),  # other
    # 41: (186., 197., 62.), # ceiling
    41: (58.0, 98.0, 26.0),  # ceiling
    0: (0.0, 0.0, 0.0),  # unlabel/unknown
}

MATTERPORT_LABELS_40 = (
    "wall",
    "door",
    "ceiling",
    "floor",
    "picture",
    "window",
    "chair",
    "pillow",
    "lamp",
    "cabinet",
    "curtain",
    "table",
    "plant",
    "mirror",
    "towel",
    "sink",
    "shelves",
    "sofa",
    "bed",
    "night stand",
    "toilet",
    "column",
    "banister",
    "stairs",
    "stool",
    "vase",
    "television",
    "pot",
    "desk",
    "box",
    "coffee table",
    "counter",
    "bench",
    "garbage bin",
    "fireplace",
    "clothes",
    "bathtub",
    "book",
    "air vent",
    "faucet",
)

MATTERPORT_COLOR_MAP_160 = {
    1: (174.0, 199.0, 232.0),  # wall
    2: (214.0, 39.0, 40.0),  # door
    3: (186.0, 197.0, 62.0),  # ceiling
    4: (152.0, 223.0, 138.0),  # floor
    5: (196.0, 156.0, 148.0),  # picture
    6: (197.0, 176.0, 213.0),  # window
    7: (188.0, 189.0, 34.0),  # chair
    8: (141.0, 91.0, 229.0),  # pillow
    9: (237.0, 204.0, 37.0),  # lamp
    10: (31.0, 119.0, 180.0),  # cabinet
    11: (219.0, 219.0, 141.0),  # curtain
    12: (255.0, 152.0, 150.0),  # table
    13: (150.0, 53.0, 56.0),  # plant
    14: (162.0, 62.0, 60.0),  # mirror
    15: (62.0, 143.0, 148.0),  # towel
    16: (112.0, 128.0, 144.0),  # sink
    17: (229.0, 91.0, 104.0),  # shelves
    18: (140.0, 86.0, 75.0),  # sofa
    19: (255.0, 187.0, 120.0),  # bed
    20: (137.0, 63.0, 14.0),  # night stand
    21: (44.0, 160.0, 44.0),  # toilet
    22: (39.0, 19.0, 208.0),  # column
    23: (64.0, 158.0, 70.0),  # banister
    24: (208.0, 49.0, 84.0),  # stairs
    25: (90.0, 119.0, 201.0),  # stool
    26: (118.0, 174.0, 76.0),  # vase
    27: (143.0, 45.0, 115.0),  # television
    28: (153.0, 108.0, 234.0),  # pot
    29: (247.0, 182.0, 210.0),  # desk
    30: (177.0, 82.0, 239.0),  # box
    31: (58.0, 98.0, 137.0),  # coffee table
    32: (23.0, 190.0, 207.0),  # counter
    33: (17.0, 242.0, 171.0),  # bench
    34: (79.0, 55.0, 137.0),  # garbage bin
    35: (127.0, 63.0, 52.0),  # fireplace
    36: (34.0, 14.0, 130.0),  # clothes
    37: (227.0, 119.0, 194.0),  # bathtub
    38: (192.0, 229.0, 91.0),  # book
    39: (49.0, 206.0, 87.0),  # air vent
    40: (250.0, 253.0, 26.0),  # faucet
    41: (0.0, 0.0, 0.0),  # unlabel/unknown
    80: (82.0, 75.0, 227.0),
    82: (253.0, 59.0, 222.0),
    84: (240.0, 130.0, 89.0),
    86: (123.0, 172.0, 47.0),
    87: (71.0, 194.0, 133.0),
    88: (24.0, 94.0, 205.0),
    89: (134.0, 16.0, 179.0),
    90: (159.0, 32.0, 52.0),
    93: (213.0, 208.0, 88.0),
    95: (64.0, 158.0, 70.0),
    96: (18.0, 163.0, 194.0),
    97: (65.0, 29.0, 153.0),
    98: (177.0, 10.0, 109.0),
    99: (152.0, 83.0, 7.0),
    100: (83.0, 175.0, 30.0),
    101: (18.0, 199.0, 153.0),
    102: (61.0, 81.0, 208.0),
    103: (213.0, 85.0, 216.0),
    104: (170.0, 53.0, 42.0),
    105: (161.0, 192.0, 38.0),
    106: (23.0, 241.0, 91.0),
    107: (12.0, 103.0, 170.0),
    110: (151.0, 41.0, 245.0),
    112: (133.0, 51.0, 80.0),
    115: (184.0, 162.0, 91.0),
    116: (50.0, 138.0, 38.0),
    118: (31.0, 237.0, 236.0),
    120: (39.0, 19.0, 208.0),
    121: (223.0, 27.0, 180.0),
    122: (254.0, 141.0, 85.0),
    125: (97.0, 144.0, 39.0),
    128: (106.0, 231.0, 176.0),
    130: (12.0, 61.0, 162.0),
    131: (124.0, 66.0, 140.0),
    132: (137.0, 66.0, 73.0),
    134: (250.0, 253.0, 26.0),
    136: (55.0, 191.0, 73.0),
    138: (60.0, 126.0, 146.0),
    139: (153.0, 108.0, 234.0),
    140: (184.0, 58.0, 125.0),
    141: (135.0, 84.0, 14.0),
    145: (139.0, 248.0, 91.0),
    148: (53.0, 200.0, 172.0),
    154: (63.0, 69.0, 134.0),
    155: (190.0, 75.0, 186.0),
    156: (127.0, 63.0, 52.0),
    157: (141.0, 182.0, 25.0),
    159: (56.0, 144.0, 89.0),
    161: (64.0, 160.0, 250.0),
    163: (182.0, 86.0, 245.0),
    165: (139.0, 18.0, 53.0),
    166: (134.0, 120.0, 54.0),
    168: (49.0, 165.0, 42.0),
    169: (51.0, 128.0, 133.0),
    170: (44.0, 21.0, 163.0),
    177: (232.0, 93.0, 193.0),
    180: (176.0, 102.0, 54.0),
    185: (116.0, 217.0, 17.0),
    188: (54.0, 209.0, 150.0),
    191: (60.0, 99.0, 204.0),
    193: (129.0, 43.0, 144.0),
    195: (252.0, 100.0, 106.0),
    202: (187.0, 196.0, 73.0),
    208: (13.0, 158.0, 40.0),
    213: (52.0, 122.0, 152.0),
    214: (128.0, 76.0, 202.0),
    221: (187.0, 50.0, 115.0),
    229: (180.0, 141.0, 71.0),
    230: (77.0, 208.0, 35.0),
    232: (72.0, 183.0, 168.0),
    233: (97.0, 99.0, 203.0),
    242: (172.0, 22.0, 158.0),
    250: (155.0, 64.0, 40.0),
    261: (118.0, 159.0, 30.0),
    264: (69.0, 252.0, 148.0),
    276: (45.0, 103.0, 173.0),
    283: (111.0, 38.0, 149.0),
    286: (184.0, 9.0, 49.0),
    300: (188.0, 174.0, 67.0),
    304: (53.0, 206.0, 53.0),
    312: (97.0, 235.0, 252.0),
    323: (66.0, 32.0, 182.0),
    325: (236.0, 114.0, 195.0),
    331: (241.0, 154.0, 83.0),
    342: (133.0, 240.0, 52.0),
    356: (16.0, 205.0, 144.0),
    370: (75.0, 101.0, 198.0),
    392: (237.0, 95.0, 251.0),
    395: (191.0, 52.0, 49.0),
    399: (227.0, 254.0, 54.0),
    408: (49.0, 206.0, 87.0),
    417: (48.0, 113.0, 150.0),
    488: (125.0, 73.0, 182.0),
    540: (229.0, 32.0, 114.0),
    562: (158.0, 119.0, 28.0),
    570: (60.0, 205.0, 27.0),
    572: (18.0, 215.0, 201.0),
    581: (79.0, 76.0, 153.0),
    609: (134.0, 13.0, 116.0),
    748: (192.0, 97.0, 63.0),
    776: (108.0, 163.0, 18.0),
    1156: (95.0, 220.0, 156.0),
    1163: (98.0, 141.0, 208.0),
    1164: (144.0, 19.0, 193.0),
    1165: (166.0, 36.0, 57.0),
    1166: (212.0, 202.0, 34.0),
    1167: (23.0, 206.0, 34.0),
    1168: (91.0, 211.0, 236.0),
    1169: (79.0, 55.0, 137.0),
    1170: (182.0, 19.0, 117.0),
    1171: (134.0, 76.0, 14.0),
    1172: (87.0, 185.0, 28.0),
    1173: (82.0, 224.0, 187.0),
    1174: (92.0, 110.0, 214.0),
    1175: (168.0, 80.0, 171.0),
    1176: (197.0, 63.0, 51.0),
    1178: (175.0, 199.0, 77.0),
    1179: (62.0, 180.0, 98.0),
    1180: (8.0, 91.0, 150.0),
    1181: (77.0, 15.0, 130.0),
    1182: (154.0, 65.0, 96.0),
    1183: (197.0, 152.0, 11.0),
    1184: (59.0, 155.0, 45.0),
    1185: (12.0, 147.0, 145.0),
    1186: (54.0, 35.0, 219.0),
    1187: (210.0, 73.0, 181.0),
    1188: (221.0, 124.0, 77.0),
    1189: (149.0, 214.0, 66.0),
    1190: (72.0, 185.0, 134.0),
    1191: (42.0, 94.0, 198.0),
    1200: (0, 0, 0),
}

# Listed in the Matterport3D paper: https://ieeexplore.ieee.org/stamp/stamp.jsp?tp=&arnumber=8374622
MATTERPORT_ROOM_CATEGORIES = [
    "office",
    "lounge",
    "familyroom",
    "entryway",
    "dining room",
    "living room",
    "stairs",
    "kitchen",
    "porch",
    "bathroom",
    "bedroom",
    "hallway",
]

HM3DSEM_ROOM_CATEGORIES = [
    "living room",
    "dining room",
    "kitchen",
    "bathroom",
    "bedroom",
    "dressing room",
    "combined kitchen and living room",
    "entryway",
    "basement",
    "laundry room",
    "office",
    "empty room",
    "hallway",
    "closet",
]

COCO_STUFF_CLASSES = {
    0: "unlabeled",
    1: "person",
    2: "bicycle",
    3: "car",
    4: "motorcycle",
    5: "airplane",
    6: "bus",
    7: "train",
    8: "truck",
    9: "boat",
    10: "traffic light",
    11: "fire hydrant",
    12: "street sign",
    13: "stop sign",
    14: "parking meter",
    15: "bench",
    16: "bird",
    17: "cat",
    18: "dog",
    19: "horse",
    20: "sheep",
    21: "cow",
    22: "elephant",
    23: "bear",
    24: "zebra",
    25: "giraffe",
    26: "hat",
    27: "backpack",
    28: "umbrella",
    29: "shoe",
    30: "eye glasses",
    31: "handbag",
    32: "tie",
    33: "suitcase",
    34: "frisbee",
    35: "skis",
    36: "snowboard",
    37: "sports ball",
    38: "kite",
    39: "baseball bat",
    40: "baseball glove",
    41: "skateboard",
    42: "surfboard",
    43: "tennis racket",
    44: "bottle",
    45: "plate",
    46: "wine glass",
    47: "cup",
    48: "fork",
    49: "knife",
    50: "spoon",
    51: "bowl",
    52: "banana",
    53: "apple",
    54: "sandwich",
    55: "orange",
    56: "broccoli",
    57: "carrot",
    58: "hot dog",
    59: "pizza",
    60: "donut",
    61: "cake",
    62: "chair",
    63: "couch",
    64: "potted plant",
    65: "bed",
    66: "mirror",
    67: "dining table",
    68: "window",
    69: "desk",
    70: "toilet",
    71: "door",
    72: "tv",
    73: "laptop",
    74: "mouse",
    75: "remote",
    76: "keyboard",
    77: "cell phone",
    78: "microwave",
    79: "oven",
    80: "toaster",
    81: "sink",
    82: "refrigerator",
    83: "blender",
    84: "book",
    85: "clock",
    86: "vase",
    87: "scissors",
    88: "teddy bear",
    89: "hair drier",
    90: "toothbrush",
    91: "hair brush",
    92: "banner",
    93: "blanket",
    94: "branch",
    95: "bridge",
    96: "building-other",
    97: "bush",
    98: "cabinet",
    99: "cage",
    100: "cardboard",
    101: "carpet",
    102: "ceiling-other",
    103: "ceiling-tile",
    104: "cloth",
    105: "clothes",
    106: "clouds",
    107: "counter",
    108: "cupboard",
    109: "curtain",
    110: "desk-stuff",
    111: "dirt",
    112: "door-stuff",
    113: "fence",
    114: "floor-marble",
    115: "floor-other",
    116: "floor-stone",
    117: "floor-tile",
    118: "floor-wood",
    119: "flower",
    120: "fog",
    121: "food-other",
    122: "fruit",
    123: "furniture-other",
    124: "grass",
    125: "gravel",
    126: "ground-other",
    127: "hill",
    128: "house",
    129: "leaves",
    130: "light",
    131: "mat",
    132: "metal",
    133: "mirror-stuff",
    134: "moss",
    135: "mountain",
    136: "mud",
    137: "napkin",
    138: "net",
    139: "paper",
    140: "pavement",
    141: "pillow",
    142: "plant-other",
    143: "plastic",
    144: "platform",
    145: "playingfield",
    146: "railing",
    147: "railroad",
    148: "river",
    149: "road",
    150: "rock",
    151: "roof",
    152: "rug",
    153: "salad",
    154: "sand",
    155: "sea",
    156: "shelf",
    157: "sky-other",
    158: "skyscraper",
    159: "snow",
    160: "solid-other",
    161: "stairs",
    162: "stone",
    163: "straw",
    164: "structural-other",
    165: "table",
    166: "tent",
    167: "textile-other",
    168: "towel",
    169: "tree",
    170: "vegetable",
    171: "wall-brick",
    172: "wall-concrete",
    173: "wall-other",
    174: "wall-panel",
    175: "wall-stone",
    176: "wall-tile",
    177: "wall-wood",
    178: "water-other",
    179: "waterdrops",
    180: "window-blind",
    181: "window-other",
    182: "wood",
}

HM3DSEM_FREQUENT_CATEGORIES = [
    "picture",
    "pillow",
    "door",
    "lamp",
    "cabinet",
    "book",
    "chair",
    "table",
    "towel",
    "plant",
    "sink",
    "stairs",
    "bed",
    "toilet",
    "tv",
    "desk",
    "couch",
    "flowerpot",
    "nightstand",
    "faucet",
]

HM3DSEM_FREQUENT_COLORMAP = {
    0: (174.0, 199.0, 232.0),
    1: (152.0, 223.0, 138.0),
    2: (31.0, 119.0, 180.0),
    3: (255.0, 187.0, 120.0),
    4: (188.0, 189.0, 34.0),
    5: (140.0, 86.0, 75.0),
    6: (255.0, 152.0, 150.0),
    7: (214.0, 39.0, 40.0),
    8: (197.0, 176.0, 213.0),
    9: (148.0, 103.0, 189.0),
    10: (196.0, 156.0, 148.0),
    11: (23.0, 190.0, 207.0),
    12: (247.0, 182.0, 210.0),
    13: (219.0, 219.0, 141.0),
    14: (255.0, 127.0, 14.0),
    15: (158.0, 218.0, 229.0),
    16: (44.0, 160.0, 44.0),
    17: (112.0, 128.0, 144.0),
    18: (227.0, 119.0, 194.0),
    19: (82.0, 84.0, 163.0),
    20: (0.0, 0.0, 0.0),  # unlabel/unknown
}
