import imageio
import os
import numpy as np
from tqdm import tqdm

# File path
# file_dir = "../HOV-SG/data/mp3d_walks/val/EU6Fwq7SyZv/depth"
file_dir = "../LLaVA-3D/demo/scannet/posed_images/scene0356_00/scene0356_00"
all_max = 0
files = [x for x in os.listdir(file_dir) if x.endswith('.png')]
for file in tqdm(files):
    file_path = os.path.join(file_dir, file)

    # Load image
    depth_img = imageio.imread(file_path)

    # Get min and max values
    depth_min = np.min(depth_img)
    depth_max = np.max(depth_img)

    all_max = max(all_max, depth_max)
print(all_max)
