import os
import json
import open3d as o3d

path = f"viewpoint_base_hovsg/mp3d_vps/8WUmhLawc2A"
ply_files = [x for x in os.listdir(path) if x.endswith(".ply")]

for ply_file in ply_files:
    print(f"Loading {ply_file}")
    vp_json = ply_file.replace(".ply", ".json")
    with open(os.path.join(path, vp_json), "r") as json_file:
        metadata = json.load(json_file)
    objs = metadata["objects"]

    print(f"Objects in the viewpoint: {objs}")
    # pcd = o3d.io.read_point_cloud(os.path.join(path, ply_file))
    pcd = o3d.geometry.PointCloud()
    # o3d.visualization.draw_geometries([pcd])
    for obj in objs:
        obj_pcd = o3d.io.read_point_cloud(f"../HOV-SG/data/scene_graphs/hm3dsem/8WUmhLawc2A_nearfar/graph/objects/{obj}.ply")
        # o3d.visualization.draw_geometries([pcd, obj_pcd])
        pcd += obj_pcd
    
    o3d.visualization.draw_geometries([pcd])

