# Online-Optimized RAG for Tool Use and Function Calling

## 0. Setup

We provide the conda env file as `py311.txt`. Please use `conda create --name <env_name> --file py311.txt` to create the environment. 

## 1. Prepare the data

For anonymous purposes, we cannot easily share the data link, as it exceeds the size limit of most of common anonymous data sharing platforms. And the huge size also makes it impossible to package the data in this supplementary material. However, we did provide the code to prepare the data. Please set the environment variable `OPENAI_API_KEY` and `DASHSCOPE_API_KEY` for OpenAI / Qwen based embedding. Then, run any of the `embed_*.py` files to generate the data. Each of the script is self-contained and should be able to run without any modification. Please refer to the script and our paper appendix for more details.

## 2. Reproduce the experiment

The `embed_trainer` folder contains the code to reproduce the experiment. To run any of the paper experiments, use the universal CLI interface: `python -m embed_trainer.general_trainer --config embed_trainer/exp_configs/<YOUR_INTERESTED_CONFIG.json>`. Please refer to the `exp_configs` folder for all the available configs. Use `--help` flag to see all the available options to override the config.

## 3. Evaluation

The `baseline` folder contains the code to evaluate the performance of baseline methods in our paper. Our method is directly evaluated during the training, with adjustable parameters in the config.
