"""
Universal Trainer for Contextual Bandit Experiments.

This package provides a flexible framework for running contextual bandit
experiments on different datasets with configurable parameters.
"""

from .universal_bandit_optimizer import (
    NormConstraintType,
    UniversalBanditOptimizer,
    create_unit_sphere_optimizer,
    create_unit_vector_optimizer,
    create_unconstrained_optimizer,
)

from .universal_contextual_bandit import UniversalContextualBandit

from .universal_data_loader import (
    QueryArmMapper,
    ToolRetQueryArmMapper,
    UltraToolQueryArmMapper,
    UniversalBanditDataLoader,
    create_toolret_data_loader,
    create_ultratool_data_loader,
)

from .universal_experiment_manager import (
    UniversalBanditConfig,
    ParameterTracker,
    TrainingTracker,
    UniversalBanditExperiment,
    run_universal_bandit_experiment,
)

__version__ = "1.0.0"
__author__ = "Augment Agent"
__description__ = "Universal trainer for contextual bandit experiments"

__all__ = [
    # Optimizer
    "NormConstraintType",
    "UniversalBanditOptimizer", 
    "create_unit_sphere_optimizer",
    "create_unit_vector_optimizer",
    "create_unconstrained_optimizer",
    
    # Bandit algorithm
    "UniversalContextualBandit",
    
    # Data loading
    "QueryArmMapper",
    "ToolRetQueryArmMapper",
    "UltraToolQueryArmMapper", 
    "UniversalBanditDataLoader",
    "create_toolret_data_loader",
    "create_ultratool_data_loader",
    
    # Experiment management
    "UniversalBanditConfig",
    "ParameterTracker",
    "TrainingTracker",
    "UniversalBanditExperiment",
    "run_universal_bandit_experiment",
]
