n_examples=${1}   # <-- number of examples to train on
hidden_size=${2}  # <-- hidden size of trained model
data_dimension=${3}   # <-- generated boolean data dimension

total_layers=${4}      # <-- number of layers in residual network
learning_rate=${5}     # <-- learning rate
seed=${6}              # <-- training seed

raptr_layers=${7}      # <-- raptr probabilities (separated by '_')
raptr_stages=${8}      # <-- raptr start boundaries for each stage  (separated by '_')
layerdrop=${10}        # <-- raptr start boundaries for each stage  (separated by '_')
subset_size=${11}      # <-- average drop rate for layerdrop, if set raptr's parameters ar ignored 
num_components=${12}   # <-- number of components per degree in boolean data
fig_name=${9}          # <-- file name to store data 
max_degree=${13}       # <-- max degree of polynomial underlying label distribution

python train_boolean.py ${n_examples} ${hidden_size} ${data_dimension} ${total_layers} ${learning_rate} ${seed} ${raptr_layers} ${raptr_stages} ${layerdrop}  ${fig_name} ${subset_size} ${num_components} ${max_degree} #<-- gets a trained checkpoint
python eval_boolean_analysis.py ${n_examples} ${hidden_size} ${data_dimension} ${total_layers} ${learning_rate} ${seed} ${raptr_layers} ${raptr_stages} ${layerdrop}  ${fig_name} ${subset_size} ${num_components} ${max_degree} #<-- gets the correlation plots from each checkpoint
