# evaluate phase 2 or 3

export CUDA_VISIBLE_DEVICES=0

ckpt=$1 # epoch or update

src_lang=en
tgt_lang=de

path_to_data=
path_to_ckpt=

DATA_DIR=${path_to_data}/${src_lang}-${tgt_lang}

adapter=league

# phase 2
SAVE_DIR=${path_to_ckpt}/checkpoints/dcm_zs_${src_lang}_asr_for_${tgt_lang}_${adapter}_shrink_ot10

# phase 3
SAVE_DIR=${path_to_ckpt}/checkpoints/dcm_zs_${src_lang}_asr_for_${tgt_lang}_${adapter}_shirnk_ot10_st

if [ "$ckpt" = "best" ]; then
  CHECKPOINT_FILENAME=checkpoint_${ckpt}.pt
else
  CHECKPOINT_FILENAME=avg_last_10_${ckpt}_checkpoint.pt
fi
model=${SAVE_DIR}/${CHECKPOINT_FILENAME}

if [ ! -f ${model} ];then
  python scripts/average_checkpoints.py --inputs ${SAVE_DIR} --num-${ckpt}-checkpoints 10 --output ${model}
fi

infer_results=${SAVE_DIR}/infer_results/${ckpt}

config=config_text.yaml

testsets=debug2_st

for testset in $(echo ${testsets} | tr "," "\n")
do
  python fairseq_cli/generate.py \
        ${MANIFEST_ROOT} \
        --task dcm \
        --max-tokens 50000 \
        --nbest 1 \
        --results-path ${infer_results} \
        --path ${model} \
        --gen-subset ${testset} \
        --config-yaml ${config} \
        --scoring sacrebleu \
        --beam 5 \
        --user-dir examples/dcm \
        --load-speech-only #\
        #--model-overrides "{'load_pretrained_acoustic_encoder_from': '', 'load_pretrained_text_encoder_from': '', 'load_pretrained_decoder_from': None}" 
done

