# WSI-GT



## step 1, prepare env and data 
Create env:
```conda env create -n deephisto -f environment.yml```

### download psimage package to work with whole slide images (https://github.com/xubiker/psimage?tab=readme-ov-file)

## step 2, extract data for evaluation and test
Extract Twice , one for evaluation and one for test with different parameters 
python extract_testset.py \
--dataset_path /home/data_repository/PATH-DT-MSU_dev/WSS2 \ 
--region_intersection 0.5 \
--version _v2 \
--patches_from_one_region 1 \
--region_area_influence 0.5 \
--layer 2

## step 3, train baseline model (ResNet50)
CUDA_VISIBLE_DEVICES=0 python main_train.py \
--resnet50 \
--model NOGNN \
--runs_name resnet \
--lr 1e-4 --smoothing 0.1 \
--train_data_path /home/data_repository/PATH-DT-MSU_dev/WSS2 \
--test_output_path test_set_saved/WSS2_layer:2_region_area_influence:0_patches_from_one_region:1_region_intersection:0.8 

## Optional : Inference on Test 
```inference/run_predict_annotated_rnd_cnns.sh```
## step 3, train model WSI-GT 

CUDA_VISIBLE_DEVICES=0 python main_train.py \
--resnet50 --runs_name graph-hnet-pseudo_with_another_resnet \
--model graph-hnet-pseudo \
--finetune /home/z.sun/graph-wsi/pretrained_encoder/resnet-50-best-7.pth \
--lr 1e-5 \
--train_data_path /home/data_repository/PATH-DT-MSU_dev/WSS2 \
--test_output_path test_set_saved/WSS2_layer:2_region_area_influence:0_patches_from_one_region:1_region_intersection:0.8 

## Optional : Inference on Test 
```inference/predict_annotated_rnd_gnns.py```

## step 4, inference for WSI 

Change inference/run_predict_full_rnd_gnns.sh and run it 
```./inference/run_predict_full_rnd_gnns.sh```
