(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     29564,        855]
NotebookOptionsPosition[     25757,        784]
NotebookOutlinePosition[     26192,        801]
CellTagsIndexPosition[     26149,        798]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Lower bounds", "Title",
 CellChangeTimes->{{3.8420703610634336`*^9, 
  3.842070365004519*^9}},ExpressionUUID->"0b21bd69-ca26-4f5b-b79e-\
d14c06890092"],

Cell[BoxData["Quit"], "Input",
 CellChangeTimes->{{3.8419761856180964`*^9, 3.841976186130603*^9}},
 CellLabel->"In[37]:=",ExpressionUUID->"d37797a8-0712-4fae-aa59-d5a8173afe92"],

Cell["\<\
Define the problem and functions for computing associated properties:\
\>", "Text",
 CellChangeTimes->{{3.841981583886159*^9, 
  3.841981603918765*^9}},ExpressionUUID->"06beab3b-4460-4475-bb21-\
f5fbab34ca68"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"getF", "[", "L_", "]"}], ":=", 
   RowBox[{"Evaluate", "@", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"L", "[", 
         RowBox[{"x", ",", "y"}], "]"}], ",", "x"}], "]"}], ",", 
      RowBox[{"-", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"L", "[", 
          RowBox[{"x", ",", "y"}], "]"}], ",", "y"}], "]"}]}]}], "}"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"x_", ",", "y_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"a", "*", "x", "*", "y"}], "+", 
    RowBox[{
     RowBox[{"b", "/", "2"}], "*", 
     RowBox[{"x", "^", "2"}]}], "-", 
    RowBox[{
     RowBox[{"b", "/", "2"}], "*", 
     RowBox[{"y", "^", "2"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"F", "[", 
   RowBox[{"x_", ",", "y_"}], "]"}], ":=", 
  RowBox[{"Evaluate", "@", 
   RowBox[{"getF", "[", "f", "]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"star", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"weakMVIcondition", "[", 
    RowBox[{"x_", ",", "y_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"F", "[", 
       RowBox[{"x", ",", "y"}], "]"}], ")"}], ".", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x", ",", "y"}], "}"}], "-", "star"}], ")"}]}], "/", 
    RowBox[{
     RowBox[{"Norm", "[", 
      RowBox[{"F", "[", 
       RowBox[{"x", ",", "y"}], "]"}], "]"}], "^", "2"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"J", "[", 
    RowBox[{"x_", ",", "y_"}], "]"}], ":=", 
   RowBox[{"Evaluate", "@", 
    RowBox[{"(", 
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{"F", "[", 
        RowBox[{"x", ",", "y"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"x", ",", "y"}], "}"}], "}"}]}], "]"}], ")"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"LocalLips", "[", 
    RowBox[{"x_", ",", "y_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"SingularValueList", "[", 
     RowBox[{
      RowBox[{"J", "[", 
       RowBox[{"x", ",", "y"}], "]"}], ",", "1"}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.841976199174181*^9, 3.841976208426649*^9}, {
  3.841976563194046*^9, 3.841976692956122*^9}, {3.9212080515776167`*^9, 
  3.9212080629096537`*^9}, {3.921208140655943*^9, 3.9212081407899*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"3e197fc1-bca3-4cac-bd73-c3e209dd26d3"],

Cell["Compute L and \[Rho]  and the relaxed PPA update:", "Text",
 CellChangeTimes->{{3.841981618947003*^9, 3.841981641171012*^9}, {
  3.92539410363028*^9, 
  3.925394109036028*^9}},ExpressionUUID->"20532a89-c2a6-4b92-b625-\
23438372a206"],

Cell[CellGroupData[{

Cell["relaxed PPA", "Chapter",
 CellChangeTimes->{{3.9212082237460403`*^9, 
  3.921208229535796*^9}},ExpressionUUID->"df81827c-eecc-475c-b205-\
cb0b02453250"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Clear", "[", 
   RowBox[{
   "a", ",", "b", ",", "c", ",", "\[Alpha]", ",", "\[Rho]", ",", "L"}], "]"}],
   ";"}]], "Input",
 CellChangeTimes->{{3.921217666878726*^9, 3.921217671434722*^9}},
 CellLabel->"In[8]:=",ExpressionUUID->"04d74495-58c7-44ec-898c-afdca72faa7a"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"$Assumptions", "=", 
   RowBox[{
    RowBox[{"a", "\[Element]", "PositiveReals"}], "&&", 
    RowBox[{"b", "\[Element]", "NegativeReals"}], "&&", 
    RowBox[{"x", "\[Element]", "Reals"}], "&&", 
    RowBox[{"y", "\[Element]", "Reals"}], "&&", 
    RowBox[{"\[Alpha]", "\[Element]", "PositiveReals"}], "&&", 
    RowBox[{"\[Alpha]", "<", "1"}], "&&", 
    RowBox[{"c", "\[Element]", "PositiveReals"}], "&&", 
    RowBox[{"\[Gamma]", "\[Element]", "PositiveReals"}], "&&", 
    RowBox[{"L", "\[Element]", "PositiveReals"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"\[Rho]", "=", 
  RowBox[{
   RowBox[{"weakMVIcondition", "[", 
    RowBox[{"x", ",", "y"}], "]"}], "//", 
   "Simplify"}]}], "\[IndentingNewLine]", 
 RowBox[{"L", "=", 
  RowBox[{
   RowBox[{"LocalLips", "[", 
    RowBox[{"x", ",", "y"}], "]"}], "//", 
   "Simplify"}]}], "\[IndentingNewLine]", 
 RowBox[{"F", "[", 
  RowBox[{"x", ",", "y"}], "]"}]}], "Input",
 CellChangeTimes->{{3.921208439222179*^9, 3.921208439401276*^9}, {
  3.921217662651105*^9, 3.921217663426775*^9}, {3.9212181602893*^9, 
  3.921218171502694*^9}, {3.9212195162112617`*^9, 3.92121952418996*^9}},
 CellLabel->"In[9]:=",ExpressionUUID->"dee4e71d-9f1a-4e7f-ac8f-beea44118f0f"],

Cell[BoxData[
 FractionBox["b", 
  RowBox[{
   SuperscriptBox["a", "2"], "+", 
   SuperscriptBox["b", "2"]}]]], "Output",
 CellChangeTimes->{
  3.9212084478509903`*^9, 3.921218022137685*^9, 3.9212180933163967`*^9, {
   3.921218172024679*^9, 3.9212181804583797`*^9}, 3.921218826594727*^9, {
   3.9212195246332483`*^9, 3.921219532201281*^9}},
 CellLabel->"Out[10]=",ExpressionUUID->"111c2859-667d-4407-9167-5eb51b9aa835"],

Cell[BoxData[
 SqrtBox[
  RowBox[{
   SuperscriptBox["a", "2"], "+", 
   SuperscriptBox["b", "2"]}]]], "Output",
 CellChangeTimes->{
  3.9212084478509903`*^9, 3.921218022137685*^9, 3.9212180933163967`*^9, {
   3.921218172024679*^9, 3.9212181804583797`*^9}, 3.921218826594727*^9, {
   3.9212195246332483`*^9, 3.9212195322227163`*^9}},
 CellLabel->"Out[11]=",ExpressionUUID->"cac8067e-f0cb-431d-b29c-5b731832742c"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"b", " ", "x"}], "+", 
    RowBox[{"a", " ", "y"}]}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "a"}], " ", "x"}], "+", 
    RowBox[{"b", " ", "y"}]}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.9212084478509903`*^9, 3.921218022137685*^9, 3.9212180933163967`*^9, {
   3.921218172024679*^9, 3.9212181804583797`*^9}, 3.921218826594727*^9, {
   3.9212195246332483`*^9, 3.9212195322239227`*^9}},
 CellLabel->"Out[12]=",ExpressionUUID->"1246a379-6e04-4749-8317-b8c2d3d72d2a"]
}, Open  ]],

Cell["Construct the (linear) prox operator:", "Text",
 CellChangeTimes->{{3.921209636814417*^9, 
  3.921209656888139*^9}},ExpressionUUID->"3b052a37-c351-4453-a659-\
aeb2b22106a0"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"id", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"A", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"b", ",", "a"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "a"}], ",", "b"}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"A", ".", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "\[Equal]", 
  RowBox[{"F", "[", 
   RowBox[{"x", ",", "y"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.9212085656626453`*^9, 3.9212085719606533`*^9}},
 CellLabel->"In[13]:=",ExpressionUUID->"67384028-4b32-4426-98c1-e7aa1f41ec48"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.9212085722895947`*^9, 3.9212180238643227`*^9, 
  3.9212180968631697`*^9, 3.921218182766176*^9, 3.9212188277133636`*^9, 
  3.9212195332978897`*^9},
 CellLabel->"Out[15]=",ExpressionUUID->"aad6b46b-fa0d-43a8-beff-4f9612f58c25"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Prox", "=", 
  RowBox[{"Inverse", "[", 
   RowBox[{"id", "+", 
    RowBox[{"\[Gamma]", "*", "A"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.9212083795372877`*^9, 3.921208562067334*^9}, {
  3.9212085969497147`*^9, 3.9212085982123537`*^9}, {3.9212086400284777`*^9, 
  3.9212086545356293`*^9}},
 CellLabel->"In[16]:=",ExpressionUUID->"9cea0f04-e206-4d47-877e-b65db4d5edd6"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{"1", "+", 
       RowBox[{"b", " ", "\[Gamma]"}]}], 
      RowBox[{"1", "+", 
       RowBox[{"2", " ", "b", " ", "\[Gamma]"}], "+", 
       RowBox[{
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox["\[Gamma]", "2"]}], "+", 
       RowBox[{
        SuperscriptBox["b", "2"], " ", 
        SuperscriptBox["\[Gamma]", "2"]}]}]], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"a", " ", "\[Gamma]"}], 
       RowBox[{"1", "+", 
        RowBox[{"2", " ", "b", " ", "\[Gamma]"}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["\[Gamma]", "2"]}], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["\[Gamma]", "2"]}]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{"a", " ", "\[Gamma]"}], 
      RowBox[{"1", "+", 
       RowBox[{"2", " ", "b", " ", "\[Gamma]"}], "+", 
       RowBox[{
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox["\[Gamma]", "2"]}], "+", 
       RowBox[{
        SuperscriptBox["b", "2"], " ", 
        SuperscriptBox["\[Gamma]", "2"]}]}]], ",", 
     FractionBox[
      RowBox[{"1", "+", 
       RowBox[{"b", " ", "\[Gamma]"}]}], 
      RowBox[{"1", "+", 
       RowBox[{"2", " ", "b", " ", "\[Gamma]"}], "+", 
       RowBox[{
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox["\[Gamma]", "2"]}], "+", 
       RowBox[{
        SuperscriptBox["b", "2"], " ", 
        SuperscriptBox["\[Gamma]", "2"]}]}]]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.92120841180215*^9, 3.921208427742157*^9}, {
   3.921208494354195*^9, 3.921208517293782*^9}, 3.921208550354623*^9, {
   3.92120858087383*^9, 3.921208598881338*^9}, {3.921208641854309*^9, 
   3.921208655391086*^9}, 3.921218024819158*^9, 3.921218099515895*^9, 
   3.921218183548545*^9, 3.921218828508843*^9, 3.92121953456394*^9},
 CellLabel->"Out[16]=",ExpressionUUID->"b4c8a553-c2c1-4099-bd56-aace2c95ab8b"]
}, Open  ]],

Cell["Compute the Jacobian of the update rule rPPA:", "Text",
 CellChangeTimes->{{3.921209663551544*^9, 
  3.921209683118245*^9}},ExpressionUUID->"04b52e1b-7d34-4719-b252-\
601f1da41681"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"rPPA", "[", 
   RowBox[{"x", ",", "y"}], "]"}], ":=", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "-", "\[Alpha]"}], ")"}], 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], "+", 
   RowBox[{"\[Alpha]", "*", 
    RowBox[{"Prox", ".", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}]}]}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"update", "=", 
   RowBox[{
    RowBox[{"rPPA", "[", 
     RowBox[{"x", ",", "y"}], "]"}], "//", "Simplify"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"T", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"D", "[", 
         RowBox[{"update", ",", "x"}], "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}], ",", 
       RowBox[{
        RowBox[{"D", "[", 
         RowBox[{"update", ",", "y"}], "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}]}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"D", "[", 
         RowBox[{"update", ",", "x"}], "]"}], "[", 
        RowBox[{"[", "2", "]"}], "]"}], ",", 
       RowBox[{
        RowBox[{"D", "[", 
         RowBox[{"update", ",", "y"}], "]"}], "[", 
        RowBox[{"[", "2", "]"}], "]"}]}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"T", "//", "MatrixForm"}]}], "Input",
 CellChangeTimes->{{3.92120860356544*^9, 3.9212086817360992`*^9}},
 CellLabel->"In[17]:=",ExpressionUUID->"34388704-11d9-45c4-9d32-2b9165f1e157"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      FractionBox[
       RowBox[{
        RowBox[{"\[Alpha]", " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"b", " ", "\[Gamma]"}]}], ")"}]}], "-", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", "\[Alpha]"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"2", " ", "b", " ", "\[Gamma]"}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["\[Gamma]", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["\[Gamma]", "2"]}]}], ")"}]}]}], 
       RowBox[{"1", "+", 
        RowBox[{"2", " ", "b", " ", "\[Gamma]"}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["\[Gamma]", "2"]}], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["\[Gamma]", "2"]}]}]], 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"a", " ", "\[Alpha]", " ", "\[Gamma]"}], 
        RowBox[{"1", "+", 
         RowBox[{"2", " ", "b", " ", "\[Gamma]"}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["\[Gamma]", "2"]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["\[Gamma]", "2"]}]}]]}]},
     {
      FractionBox[
       RowBox[{"a", " ", "\[Alpha]", " ", "\[Gamma]"}], 
       RowBox[{"1", "+", 
        RowBox[{"2", " ", "b", " ", "\[Gamma]"}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["\[Gamma]", "2"]}], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["\[Gamma]", "2"]}]}]], 
      RowBox[{"1", "-", "\[Alpha]", "+", 
       FractionBox[
        RowBox[{"\[Alpha]", " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"b", " ", "\[Gamma]"}]}], ")"}]}], 
        RowBox[{"1", "+", 
         RowBox[{"2", " ", "b", " ", "\[Gamma]"}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["\[Gamma]", "2"]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["\[Gamma]", "2"]}]}]]}]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{3.921208683641047*^9, 3.9212180307765017`*^9, 
  3.921218106343364*^9, 3.921218185876034*^9, 3.9212188304107533`*^9, 
  3.921219535978676*^9},
 CellLabel->
  "Out[20]//MatrixForm=",ExpressionUUID->"5b433fc3-d79c-44a3-81a3-\
778c67576cc4"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"spectralrad", "=", 
  RowBox[{
   RowBox[{"Max", "[", 
    RowBox[{"Abs", "[", 
     RowBox[{"Eigenvalues", "[", "T", "]"}], "]"}], "]"}], "//", 
   "FullSimplify"}]}]], "Input",
 CellChangeTimes->{{3.9212082304646673`*^9, 3.9212082318130007`*^9}, 
   3.9212087052325706`*^9, {3.921208843915905*^9, 3.921208863266447*^9}, 
   3.921218312007244*^9, {3.9212186861528397`*^9, 3.9212186961455708`*^9}, {
   3.9212188173622303`*^9, 3.9212188175284557`*^9}},
 CellLabel->"In[21]:=",ExpressionUUID->"d07bd51a-fd9a-4733-b73e-a08326bee20e"],

Cell[BoxData[
 FractionBox[
  SqrtBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["\[Gamma]", "2"]}], "+", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"b", " ", "\[Gamma]"}]}], ")"}], "2"]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "\[Alpha]"}], ")"}], " ", "\[Gamma]", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", "b"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["a", "2"], "+", 
            SuperscriptBox["b", "2"]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "\[Alpha]"}], ")"}], " ", "\[Gamma]"}]}],
         ")"}]}]}], ")"}]}]], 
  RowBox[{"1", "+", 
   RowBox[{"2", " ", "b", " ", "\[Gamma]"}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["a", "2"], "+", 
      SuperscriptBox["b", "2"]}], ")"}], " ", 
    SuperscriptBox["\[Gamma]", "2"]}]}]]], "Output",
 CellChangeTimes->{
  3.921208706560133*^9, {3.9212088483466473`*^9, 3.921208863710702*^9}, 
   3.921218039166277*^9, 3.9212181889019823`*^9, 3.9212183136560297`*^9, 
   3.921218699678216*^9, 3.921218833733905*^9, 3.921219538092972*^9},
 CellLabel->"Out[21]=",ExpressionUUID->"6754ed03-32ed-4f17-9b39-8c9afe9852b4"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Simplifying the constants:", "Subsection",
 CellChangeTimes->{{3.9212178860154133`*^9, 
  3.921217889291728*^9}},ExpressionUUID->"4059a79e-539a-4df3-897b-\
3ab9127a039b"],

Cell[BoxData[
 RowBox[{"Clear", "[", 
  RowBox[{"a", ",", "b", ",", "L", ",", "\[Rho]"}], "]"}]], "Input",
 CellChangeTimes->{{3.921218070446516*^9, 3.921218073634042*^9}, {
  3.921218666242694*^9, 3.921218666590467*^9}},
 CellLabel->"In[22]:=",ExpressionUUID->"a18416eb-145f-430c-83d2-f0e264b9d896"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\[Rho]", "==", 
      FractionBox["b", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        SuperscriptBox["b", "2"]}]]}], ",", 
     RowBox[{"L", "==", 
      SqrtBox[
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        SuperscriptBox["b", "2"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.9212185795462112`*^9, 3.921218628626401*^9}, {
  3.9212186624911757`*^9, 3.9212186641580553`*^9}},
 CellLabel->"In[23]:=",ExpressionUUID->"f82ba156-aacb-4efd-b4be-6a4c0da103fb"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "\[Rule]", 
      RowBox[{"-", 
       SqrtBox[
        RowBox[{
         SuperscriptBox["L", "2"], "-", 
         RowBox[{
          SuperscriptBox["L", "4"], " ", 
          SuperscriptBox["\[Rho]", "2"]}]}]]}]}], ",", 
     RowBox[{"b", "\[Rule]", 
      RowBox[{
       SuperscriptBox["L", "2"], " ", "\[Rho]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "\[Rule]", 
      SqrtBox[
       RowBox[{
        SuperscriptBox["L", "2"], "-", 
        RowBox[{
         SuperscriptBox["L", "4"], " ", 
         SuperscriptBox["\[Rho]", "2"]}]}]]}], ",", 
     RowBox[{"b", "\[Rule]", 
      RowBox[{
       SuperscriptBox["L", "2"], " ", "\[Rho]"}]}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.921218610168283*^9, 3.921218628937653*^9}, 
   3.9212186680551243`*^9, 3.921218842744185*^9, 3.9212195400295343`*^9},
 CellLabel->"Out[23]=",ExpressionUUID->"f33586ac-b53a-4e4d-8bc1-21cc019552d6"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"a", "=", 
   SqrtBox[
    RowBox[{
     SuperscriptBox["L", "2"], "-", 
     RowBox[{
      SuperscriptBox["L", "4"], " ", 
      SuperscriptBox["\[Rho]", "2"]}]}]]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"b", "=", 
   RowBox[{
    SuperscriptBox["L", "2"], " ", "\[Rho]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.921217632011283*^9, 3.921217646916689*^9}, {
  3.9212186721906557`*^9, 3.921218672836602*^9}},
 CellLabel->"In[24]:=",ExpressionUUID->"65db4224-ecde-465c-be08-c338505bcffb"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"T", "//", "Simplify"}], "//", "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.921217683229577*^9, 3.9212177020362997`*^9}},
 CellLabel->"In[26]:=",ExpressionUUID->"8410ab02-3822-4f65-b29b-53f97ac17fb8"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      FractionBox[
       RowBox[{"1", "+", 
        RowBox[{
         SuperscriptBox["L", "2"], " ", "\[Gamma]", " ", 
         RowBox[{"(", 
          RowBox[{"\[Gamma]", "-", 
           RowBox[{"\[Alpha]", " ", "\[Gamma]"}], "-", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "2"}], "+", "\[Alpha]"}], ")"}], " ", "\[Rho]"}]}],
           ")"}]}]}], 
       RowBox[{"1", "+", 
        RowBox[{
         SuperscriptBox["L", "2"], " ", "\[Gamma]", " ", 
         RowBox[{"(", 
          RowBox[{"\[Gamma]", "+", 
           RowBox[{"2", " ", "\[Rho]"}]}], ")"}]}]}]], 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"L", " ", "\[Alpha]", " ", "\[Gamma]", " ", 
         SqrtBox[
          RowBox[{"1", "-", 
           RowBox[{
            SuperscriptBox["L", "2"], " ", 
            SuperscriptBox["\[Rho]", "2"]}]}]]}], 
        RowBox[{"1", "+", 
         RowBox[{
          SuperscriptBox["L", "2"], " ", "\[Gamma]", " ", 
          RowBox[{"(", 
           RowBox[{"\[Gamma]", "+", 
            RowBox[{"2", " ", "\[Rho]"}]}], ")"}]}]}]]}]},
     {
      FractionBox[
       RowBox[{"L", " ", "\[Alpha]", " ", "\[Gamma]", " ", 
        SqrtBox[
         RowBox[{"1", "-", 
          RowBox[{
           SuperscriptBox["L", "2"], " ", 
           SuperscriptBox["\[Rho]", "2"]}]}]]}], 
       RowBox[{"1", "+", 
        RowBox[{
         SuperscriptBox["L", "2"], " ", "\[Gamma]", " ", 
         RowBox[{"(", 
          RowBox[{"\[Gamma]", "+", 
           RowBox[{"2", " ", "\[Rho]"}]}], ")"}]}]}]], 
      FractionBox[
       RowBox[{"1", "+", 
        RowBox[{
         SuperscriptBox["L", "2"], " ", "\[Gamma]", " ", 
         RowBox[{"(", 
          RowBox[{"\[Gamma]", "-", 
           RowBox[{"\[Alpha]", " ", "\[Gamma]"}], "-", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "2"}], "+", "\[Alpha]"}], ")"}], " ", "\[Rho]"}]}],
           ")"}]}]}], 
       RowBox[{"1", "+", 
        RowBox[{
         SuperscriptBox["L", "2"], " ", "\[Gamma]", " ", 
         RowBox[{"(", 
          RowBox[{"\[Gamma]", "+", 
           RowBox[{"2", " ", "\[Rho]"}]}], ")"}]}]}]]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{{3.921217686265023*^9, 3.921217702439371*^9}, 
   3.921218076192836*^9, 3.921218113988068*^9, 3.921218337068921*^9, 
   3.921218675809635*^9, 3.921218715391467*^9, 3.921218846704219*^9, 
   3.9212195424246798`*^9},
 CellLabel->
  "Out[26]//MatrixForm=",ExpressionUUID->"526a1639-77f5-4d9b-a07b-\
0b9105157343"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"spectralrad", "//", "Simplify"}]], "Input",
 CellChangeTimes->{{3.921217922591497*^9, 3.921217924005427*^9}},
 CellLabel->"In[27]:=",ExpressionUUID->"164967aa-3fc5-4366-a545-02895c680187"],

Cell[BoxData[
 SqrtBox[
  FractionBox[
   RowBox[{"1", "+", 
    RowBox[{
     SuperscriptBox["L", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "\[Alpha]"}], ")"}], " ", "\[Gamma]", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "\[Alpha]"}], ")"}], " ", "\[Gamma]"}], 
       "-", 
       RowBox[{"2", " ", "\[Rho]"}]}], ")"}]}]}], 
   RowBox[{"1", "+", 
    RowBox[{
     SuperscriptBox["L", "2"], " ", "\[Gamma]", " ", 
     RowBox[{"(", 
      RowBox[{"\[Gamma]", "+", 
       RowBox[{"2", " ", "\[Rho]"}]}], ")"}]}]}]]]], "Output",
 CellChangeTimes->{3.921217924799141*^9, 3.921218340089658*^9, 
  3.921218718871212*^9, 3.921218848200982*^9, 3.9212195446578693`*^9},
 CellLabel->"Out[27]=",ExpressionUUID->"349a7c84-069c-42ec-8725-08be08a002db"]
}, Open  ]],

Cell["Solving for the \[Rho] requirement:", "Text",
 CellChangeTimes->{{3.9212193854874496`*^9, 
  3.921219416686219*^9}},ExpressionUUID->"b223e824-8a89-4cfb-b24e-\
a1e11bed1091"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Reduce", "[", 
   RowBox[{
    RowBox[{"spectralrad", "<", "1"}], ",", 
    RowBox[{"{", "\[Gamma]", "}"}]}], "]"}], "//", "FullSimplify"}]], "Input",\

 CellChangeTimes->{{3.9212197300776157`*^9, 3.921219730228829*^9}},
 CellLabel->"In[30]:=",ExpressionUUID->"844b827b-1c93-42b9-9dd6-0d164bb17767"],

Cell[BoxData[
 RowBox[{
  RowBox[{"2", " ", "\[Rho]"}], ">", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "2"}], "+", "\[Alpha]"}], ")"}], " ", 
   "\[Gamma]"}]}]], "Output",
 CellChangeTimes->{{3.921219728479518*^9, 3.921219735079994*^9}},
 CellLabel->"Out[30]=",ExpressionUUID->"f2af5502-d74f-4889-82da-5f78e2a2f5cd"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{808, 897},
WindowMargins->{{Automatic, 448}, {Automatic, 198}},
TaggingRules->{"TryRealOnly" -> False},
FrontEndVersion->"12.1 for Mac OS X x86 (64-bit) (June 19, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"2a7fffdb-be7d-4ca3-b611-37f001d84466"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 157, 3, 98, "Title",ExpressionUUID->"0b21bd69-ca26-4f5b-b79e-d14c06890092"],
Cell[740, 27, 177, 2, 30, "Input",ExpressionUUID->"d37797a8-0712-4fae-aa59-d5a8173afe92"],
Cell[920, 31, 219, 5, 35, "Text",ExpressionUUID->"06beab3b-4460-4475-bb21-f5fbab34ca68"],
Cell[1142, 38, 2607, 83, 157, "Input",ExpressionUUID->"3e197fc1-bca3-4cac-bd73-c3e209dd26d3"],
Cell[3752, 123, 239, 4, 35, "Text",ExpressionUUID->"20532a89-c2a6-4b92-b625-23438372a206"],
Cell[CellGroupData[{
Cell[4016, 131, 158, 3, 69, "Chapter",ExpressionUUID->"df81827c-eecc-475c-b205-cb0b02453250"],
Cell[4177, 136, 303, 7, 30, "Input",ExpressionUUID->"04d74495-58c7-44ec-898c-afdca72faa7a"],
Cell[CellGroupData[{
Cell[4505, 147, 1254, 29, 115, "Input",ExpressionUUID->"dee4e71d-9f1a-4e7f-ac8f-beea44118f0f"],
Cell[5762, 178, 419, 9, 53, "Output",ExpressionUUID->"111c2859-667d-4407-9167-5eb51b9aa835"],
Cell[6184, 189, 412, 9, 36, "Output",ExpressionUUID->"cac8067e-f0cb-431d-b29c-5b731832742c"],
Cell[6599, 200, 542, 14, 34, "Output",ExpressionUUID->"1246a379-6e04-4749-8317-b8c2d3d72d2a"]
}, Open  ]],
Cell[7156, 217, 179, 3, 35, "Text",ExpressionUUID->"3b052a37-c351-4453-a659-aeb2b22106a0"],
Cell[CellGroupData[{
Cell[7360, 224, 804, 26, 73, "Input",ExpressionUUID->"67384028-4b32-4426-98c1-e7aa1f41ec48"],
Cell[8167, 252, 278, 4, 34, "Output",ExpressionUUID->"aad6b46b-fa0d-43a8-beff-4f9612f58c25"]
}, Open  ]],
Cell[CellGroupData[{
Cell[8482, 261, 396, 8, 30, "Input",ExpressionUUID->"9cea0f04-e206-4d47-877e-b65db4d5edd6"],
Cell[8881, 271, 2046, 55, 98, "Output",ExpressionUUID->"b4c8a553-c2c1-4099-bd56-aace2c95ab8b"]
}, Open  ]],
Cell[10942, 329, 187, 3, 35, "Text",ExpressionUUID->"04b52e1b-7d34-4719-b252-601f1da41681"],
Cell[CellGroupData[{
Cell[11154, 336, 1516, 47, 115, "Input",ExpressionUUID->"34388704-11d9-45c4-9d32-2b9165f1e157"],
Cell[12673, 385, 2957, 83, 92, "Output",ExpressionUUID->"5b433fc3-d79c-44a3-81a3-778c67576cc4"]
}, Open  ]],
Cell[CellGroupData[{
Cell[15667, 473, 555, 11, 30, "Input",ExpressionUUID->"d07bd51a-fd9a-4733-b73e-a08326bee20e"],
Cell[16225, 486, 1485, 44, 65, "Output",ExpressionUUID->"6754ed03-32ed-4f17-9b39-8c9afe9852b4"]
}, Open  ]],
Cell[CellGroupData[{
Cell[17747, 535, 176, 3, 54, "Subsection",ExpressionUUID->"4059a79e-539a-4df3-897b-3ab9127a039b"],
Cell[17926, 540, 300, 5, 30, "Input",ExpressionUUID->"a18416eb-145f-430c-83d2-f0e264b9d896"],
Cell[CellGroupData[{
Cell[18251, 549, 655, 19, 50, "Input",ExpressionUUID->"f82ba156-aacb-4efd-b4be-6a4c0da103fb"],
Cell[18909, 570, 1011, 31, 42, "Output",ExpressionUUID->"f33586ac-b53a-4e4d-8bc1-21cc019552d6"]
}, Open  ]],
Cell[19935, 604, 523, 15, 57, "Input",ExpressionUUID->"65db4224-ecde-465c-be08-c338505bcffb"],
Cell[CellGroupData[{
Cell[20483, 623, 237, 4, 30, "Input",ExpressionUUID->"8410ab02-3822-4f65-b29b-53f97ac17fb8"],
Cell[20723, 629, 2973, 85, 96, "Output",ExpressionUUID->"526a1639-77f5-4d9b-a07b-0b9105157343"]
}, Open  ]],
Cell[CellGroupData[{
Cell[23733, 719, 212, 3, 30, "Input",ExpressionUUID->"164967aa-3fc5-4366-a545-02895c680187"],
Cell[23948, 724, 867, 25, 63, "Output",ExpressionUUID->"349a7c84-069c-42ec-8725-08be08a002db"]
}, Open  ]],
Cell[24830, 752, 179, 3, 35, "Text",ExpressionUUID->"b223e824-8a89-4cfb-b24e-a1e11bed1091"],
Cell[CellGroupData[{
Cell[25034, 759, 334, 8, 30, "Input",ExpressionUUID->"844b827b-1c93-42b9-9dd6-0d164bb17767"],
Cell[25371, 769, 334, 9, 34, "Output",ExpressionUUID->"f2af5502-d74f-4889-82da-5f78e2a2f5cd"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

