## Requirements

For our paper we used Python version 3.6.6.

To install requirements:

```setup
pip install -r requirements.txt
```

## Training

The training config files are located in configs/train/{dataset}.

To train the model(s) in the paper using l_infty perturbations, run this command:

```train_l_infty
python train.py -c configs/train/{dataset}/{config_name}.json
```

To train the model(s) in the paper using spatial transformations, run this command:

```train_discrete
python3 train_discrete.py -c "configs/train/cifar10/{config_name}.json"
```

## Evaluation

The evaluation config files are located in configs/eval/{dataset}.

Be sure to replace "checkpoint_filename" in the json file with the location of the model checkpoint you wish to evaluate.

To evaluate a model trained on l_infty perturbations on {dataset}, run:

```eval_l_infty
python train.py -c configs/eval/{dataset}/{config_name}.json
```

After training a model using the spatial transform (discrete) json files, checkpoints for trained models will be named "checkpoint_49.pth" for standard training or "checkpoint_199.pth" for random sampling training. 
If using the pre-trained models, the checkpoints are named after the type of training (i.e. "standard.pth"). 
To evaluate a model(s) in the paper using spatial transformations, run this command:

```eval_discrete
python3 eval_discrete.py --checkpoint 'experiments/cifar10/{train_method}/checkpoints/{trained_model}.pth'
```

## Pre-trained Models

You can download pretrained model weights here:

- [Model weights](https://drive.google.com/drive/folders/1IJ8g89nDpQV7u4z26Wq9u9HZvTXI5gEU?usp=sharing) trained on CIFAR10 and MNIST.
