#!/bin/bash
exp_id=SWAMP
n=4
imp=0.8

for s in 1
do
   for l in {0..13}
   do
      CUDA_VISIBLE_DEVICES=0 python3 main.py --start ${l} --soup-id 1 \
                              --dataset cifar10 --model vgg13-bn --dense-classifier \
                              --experiment swamp --num-models ${n} --verbose \
                              --imp-ratio ${imp} --imp-type weight --pruner mag --imp-iter 20 \
                              --matching-epochs 5 --pre-epochs 150 --post-epochs 150 --seed ${s}1 \
                              --ckpt-dir Results-VGG13-C10/ckpt-mag/s${s} \
                              --soup-dir Results-VGG13-C10/${exp_id}/s${s} \
                              --result-dir Results-VGG13-C10/${exp_id}/s${s}/P1_i${l}_s${s} &
      CUDA_VISIBLE_DEVICES=1 python3 main.py --start ${l} --soup-id 2 \
                              --dataset cifar10 --model vgg13-bn --dense-classifier \
                              --experiment swamp --num-models ${n} --verbose \
                              --imp-ratio ${imp} --imp-type weight --pruner mag --imp-iter 20 \
                              --matching-epochs 5 --pre-epochs 150 --post-epochs 150 --seed ${s}2 \
                              --ckpt-dir Results-VGG13-C10/ckpt-mag/s${s} \
                              --soup-dir Results-VGG13-C10/${exp_id}/s${s} \
                              --result-dir Results-VGG13-C10/${exp_id}/s${s}/P2_i${l}_s${s} &
      CUDA_VISIBLE_DEVICES=2 python3 main.py --start ${l} --soup-id 3 \
                              --dataset cifar10 --model vgg13-bn --dense-classifier \
                              --experiment swamp --num-models ${n} --verbose \
                              --imp-ratio ${imp} --imp-type weight --pruner mag --imp-iter 20 \
                              --matching-epochs 5 --pre-epochs 150 --post-epochs 150 --seed ${s}3 \
                              --ckpt-dir Results-VGG13-C10/ckpt-mag/s${s} \
                              --soup-dir Results-VGG13-C10/${exp_id}/s${s} \
                              --result-dir Results-VGG13-C10/${exp_id}/s${s}/P3_i${l}_s${s} &
      CUDA_VISIBLE_DEVICES=3 python3 main.py --start ${l} --soup-id 4 \
                              --dataset cifar10 --model vgg13-bn --dense-classifier \
                              --experiment swamp --num-models ${n} --verbose \
                              --imp-ratio ${imp} --imp-type weight --pruner mag --imp-iter 20 \
                              --matching-epochs 5 --pre-epochs 150 --post-epochs 150 --seed ${s}4 \
                              --ckpt-dir Results-VGG13-C10/ckpt-mag/s${s} \
                              --soup-dir Results-VGG13-C10/${exp_id}/s${s} \
                              --result-dir Results-VGG13-C10/${exp_id}/s${s}/P4_i${l}_s${s} &
      
      wait
      echo "done all"
      
      CUDA_VISIBLE_DEVICES=0 python3 main.py --soup-collect --start ${l} \
                              --dataset cifar10 --model vgg13-bn --dense-classifier \
                              --experiment swamp --num-models ${n} --verbose \
                              --imp-ratio ${imp} --imp-type weight --pruner mag --imp-iter 20 \
                              --matching-epochs 5 --pre-epochs 150 --post-epochs 150 --seed ${s} \
                              --ckpt-dir Results-VGG13-C10/ckpt-mag/s${s} \
                              --soup-dir Results-VGG13-C10/${exp_id}/s${s} \
                              --result-dir Results-VGG13-C10/${exp_id}/s${s}/P0_i${l}_s${s}
   done
done