#!/bin/bash

seed=${1}
agg=${2}
attack=${3}
n=${4}
f=${5}
dataset=${6}

if [ "$dataset" == "cifar10" ]
then
  echo "cifar10"
  COMMON_OPTIONS="exp_CNN_CIFAR10.py --use-cuda --grad_clip 5 --nlpsize 1"
else
  echo "mnist"
  COMMON_OPTIONS="exp_CNN_MNIST.py --use-cuda --grad_clip 2 --nlpsize 1"
fi

for alpha in "0.1" "1.0" "10.0"
do
#      DIR="outputs/images_cifar10/${agg}_${attack}_niid${alpha}_n15_f${f}_m0.0_nlpsize1_nlpobj1.0_mixFalse_clip5.0_s0_seed${seed}"
#      if [ -d "$DIR" ] && [ "$(ls -A $DIR)" ]; then
#        echo "$DIR exists and is not empty, skip"
#      else
#        echo "$DIR executing"
#        python3 $COMMON_OPTIONS -n $n -f $f --seed $seed --agg $agg --attack $attack --dirichlet $alpha
#      fi
#
#      DIR="outputs/images_cifar10/${agg}_${attack}_niid${alpha}_n15_f${f}_m0.9_nlpsize1_nlpobj1.0_mixFalse_clip5.0_s0_seed${seed}"
#      if [ -d "$DIR" ] && [ "$(ls -A $DIR)" ]; then
#        echo "$DIR exists and is not empty, skip"
#      else
#        echo "$DIR executing"
#        python3 $COMMON_OPTIONS -n $n -f $f --seed $seed --agg $agg --attack $attack --momentum 0.9 --dirichlet $alpha
#      fi

  if [ "$dataset" == "cifar10" ]
  then
    DIR="outputs/images_cifar10/${agg}_${attack}_niid${alpha}_n${n}_f${f}_m0.0_nlpsize1_nlpobj1.0_mixTrue_clip5.0_s0_seed${seed}"
  else
    DIR="outputs/images/${agg}_${attack}_niid${alpha}_n${n}_f${f}_m0.0_nlpsize1_nlpobj1.0_mixTrue_s0_seed${seed}"
  fi
  if [ -d "$DIR" ] && [ "$(ls -A $DIR)" ]; then
    echo "$DIR exists and is not empty, skip"
  else
    echo "$DIR executing"
    python3 $COMMON_OPTIONS -n "$n" -f "$f" --seed "$seed" --agg "$agg" --attack "$attack" --dirichlet "$alpha" --mixing
  fi

  if [ "$dataset" == "cifar10" ]
  then
    DIR="outputs/images_cifar10/${agg}_${attack}_niid${alpha}_n${n}_f${f}_m0.9_nlpsize1_nlpobj1.0_mixTrue_clip5.0_s0_seed${seed}"
  else
    DIR="outputs/images/${agg}_${attack}_niid${alpha}_n${n}_f${f}_m0.9_nlpsize1_nlpobj1.0_mixTrue_s0_seed${seed}"
  fi
  if [ -d "$DIR" ] && [ "$(ls -A $DIR)" ]; then
    echo "$DIR exists and is not empty, skip"
  else
    echo "$DIR executing"
    python3 $COMMON_OPTIONS -n "$n" -f "$f" --seed "$seed" --agg "$agg" --attack "$attack" --momentum 0.9 --dirichlet "$alpha" --mixing
  fi

  if [ "$dataset" == "cifar10" ]
  then
    DIR="outputs/images_cifar10/${agg}_${attack}_niid${alpha}_n${n}_f${f}_m0.99_nlpsize1_nlpobj1.0_mixTrue_clip5.0_s0_seed${seed}"
    if [ -d "$DIR" ] && [ "$(ls -A $DIR)" ]; then
      echo "$DIR exists and is not empty, skip"
    else
      echo "$DIR executing"
      python3 $COMMON_OPTIONS -n "$n" -f "$f" --seed "$seed" --agg "$agg" --attack "$attack" --momentum 0.99 --dirichlet "$alpha" --mixing
    fi
  fi
done
