#!/bin/bash

seed=${1}
agg=${2}
attack=${3}
n=${4}
f=${5}
dataset=${6}

for nlpsize in "1" "4" "16" "32"
do
  if [ "$dataset" == "cifar10" ]
  then
    echo "cifar10"
    COMMON_OPTIONS="exp_CNN_CIFAR10.py --use-cuda --grad_clip 5 --nlpsize ${nlpsize}"
  else
    echo "mnist"
    COMMON_OPTIONS="exp_LR_MNIST.py --use-cuda --grad_clip 2 --nlpsize ${nlpsize}"
  fi

  for alpha in "0.1"
  do
  #      DIR="outputs/images_cifar10/${agg}_${attack}_niid${alpha}_n15_f${f}_m0.0_nlpsize1_nlpobj1.0_mixFalse_clip5.0_s0_seed${seed}"
  #      if [ -d "$DIR" ] && [ "$(ls -A $DIR)" ]; then
  #        echo "$DIR exists and is not empty, skip"
  #      else
  #        echo "$DIR executing"
  #        python3 $COMMON_OPTIONS -n $n -f $f --seed $seed --agg $agg --attack $attack --dirichlet $alpha
  #      fi
  #
  #      DIR="outputs/images_cifar10/${agg}_${attack}_niid${alpha}_n15_f${f}_m0.9_nlpsize1_nlpobj1.0_mixFalse_clip5.0_s0_seed${seed}"
  #      if [ -d "$DIR" ] && [ "$(ls -A $DIR)" ]; then
  #        echo "$DIR exists and is not empty, skip"
  #      else
  #        echo "$DIR executing"
  #        python3 $COMMON_OPTIONS -n $n -f $f --seed $seed --agg $agg --attack $attack --momentum 0.9 --dirichlet $alpha
  #      fi


    if [ "$dataset" == "cifar10" ]
    then
      DIR="outputs/images_cifar10/${agg}_${attack}_niid${alpha}_n${n}_f${f}_m0.0_nlpsize${nlpsize}_nlpobj1.0_mixTrue_clip5.0_s0_seed${seed}"
    else
      DIR="outputs/images_LR/${agg}_${attack}_niid${alpha}_n${n}_f${f}_m0.0_nlpsize${nlpsize}_nlpobj1.0_mixTrue_s0_seed${seed}"
    fi
    if [ -d "$DIR" ] && [ "$(ls -A $DIR)" ]; then
      echo "$DIR exists and is not empty, skip"
    else
      echo "$DIR executing"
      python3 $COMMON_OPTIONS -n "$n" -f "$f" --seed "$seed" --agg "$agg" --attack "$attack" --dirichlet "$alpha" --mixing
    fi

    if [ "$dataset" == "cifar10" ]
    then
      DIR="outputs/images_cifar10/${agg}_${attack}_niid${alpha}_n${n}_f${f}_m0.9_nlpsize${nlpsize}_nlpobj1.0_mixTrue_clip5.0_s0_seed${seed}"
    else
      DIR="outputs/images_LR/${agg}_${attack}_niid${alpha}_n${n}_f${f}_m0.9_nlpsize${nlpsize}_nlpobj1.0_mixTrue_s0_seed${seed}"
    fi
    if [ -d "$DIR" ] && [ "$(ls -A $DIR)" ]; then
      echo "$DIR exists and is not empty, skip"
    else
      echo "$DIR executing"
      python3 $COMMON_OPTIONS -n "$n" -f "$f" --seed "$seed" --agg "$agg" --attack "$attack" --momentum 0.9 --dirichlet "$alpha" --mixing
    fi

  #  if [ "$dataset" == "cifar10" ]
  #  then
  #    DIR="outputs/images_cifar10/${agg}_${attack}_niid${alpha}_n${n}_f${f}_m0.99_nlpsize1_nlpobj1.0_mixTrue_clip5.0_s0_seed${seed}"
  #    if [ -d "$DIR" ] && [ "$(ls -A $DIR)" ]; then
  #      echo "$DIR exists and is not empty, skip"
  #    else
  #      echo "$DIR executing"
  #      python3 $COMMON_OPTIONS -n "$n" -f "$f" --seed "$seed" --agg "$agg" --attack "$attack" --momentum 0.99 --dirichlet "$alpha" --mixing
  #    fi
  #  fi
  done
done
