# Stress Testing Byzantine Robustness in Distributed Learning
Code for the paper "Stress Testing Byzantine Robustness in Distributed Learning".

## Requirements
Use `pip install -r requirements.txt` to download dependencies. Or mannually download only necessary libs:
```
torch==2.0.1
torchaudio==2.0.2
torchvision==0.15.2
numpy==1.24.3
scipy==1.10.1
matplotlib==3.7.1
seaborn==0.12.2
pandas==2.0.2
```

## MNIST and CIFAR-10 Experiments
Usage: to run all MNIST and CIFAR-10 Experiments, use `./run.sh $seed $attack $dataset` to conduct $attack ("SSNLP" or "ALIE" "LF"" "BF" "IPM" "mimic" "MinMax" "MinSum") (as we mentioned, `Jump` in classification tasks is also named `SSNLP`) against all aggregations ("cm" "rfa" "krum" and "tm") with $seed on $dataset ('mnist' or 'cifar10'), and generates results saving in `outputs/`.
For example, `./run.sh 1 SSNLP mnist`.

If you just want to test a unit experiment, you can run the following command for MNIST logistic regression task.
```
python3 exp_LR_MNIST.py --grad_clip 2 --nlpsize 1 -n 15 -f 3 --seed 1 --agg rfa --momentum 0.9 --attack SSNLP --dirichlet 0.1 --mixing
```
or the following command for MNIST CNN task.
```
python3 exp_CNN_MNIST.py --grad_clip 2 --nlpsize 1 -n 15 -f 3 --seed 1 --agg rfa --momentum 0.9 --attack SSNLP --dirichlet 0.1 --mixing
```
or the following command for CIFAR-10 CNN task.
```
python3 exp_CNN_CIFAR10.py --grad_clip 5 --nlpsize 1 -n 15 -f 3 --seed 1 --agg rfa --momentum 0.99 --attack SSNLP --dirichlet 0.1 --mixing
```

## 2D Non-convex Landscape Examples
Usage: First, modify [datasets/toydata.txt](datasets%2Ftoydata.txt) to set the position and features of minima on landscape. For example, this is the toydata of Twominima landscape (`n=2, f=0`):
```
0.8 0 -1 0
1.2 0 1 0
```
Please note that our 2d non-convex landscapes are mainly constituded by Radial Basis Function (RBF, here we use Gaussian Function), so each row is the parameters of a Gaussian function: `Amplitude, Sigma, mu_x, mu_y` (if you use twominima, Sigma is unchangeable so you can set it to any value). In our Twominima landscape, there are 2 gaussian functions.

However, if you want to add a Byzantine worker, you have to add one row of `0` to the end of [toydata.txt](datasets%2Ftoydata.txt) to fill the position of the Byzantine worker. Namely, the number of rows should be exactly `n`. For example, when `n=3, f=1`, [toydata.txt](datasets%2Ftoydata.txt) should be:
```
0.8 0 -1 0
1.2 0 1 0
0 0 0 0
```

The base toydata needed by TwoMinima are already contained in [datasets/twominimum.txt](datasets%2Ftwominimum.txt), you can just copy/paste them to [toydata.txt](datasets%2Ftoydata.txt) and modify it as you want.

After you finish setting [toydata.txt](datasets%2Ftoydata.txt), you can execute this command in your terminal:
```
python3 toy_plot.py --loss $loss_func -n $n -f $f --agg $agg --attack $attack --momentum $m --EPOCH $num_itr --LR $lr --initp $x $y --nlpsize $tau
```

- $loss_func [type: str] : "two" (two-minimum landscape) or "gaussian" (combined gaussian)
- $n [type: int]
- $f [type: int]
- $agg [type: str] : "cm" "rfa" "krum" or "tm"
- $m [type: float] : local momentum
- $attack [type: str] : "NLP" "NOBLE" or "ALIE" "BF" "IPM" "mimic" "MinMax" "MinSum" (`NLP` is the implementation of `Solve(P)` and `NOBLE` is the implementation of `Jump-tau`)
- $num_itr [type: int] : number of iterations
- $lr [type: float] : learning rate
- $x [type: float] : x of initial point
- $y [type: float] : y of initial point
- $tau [type: int] : length of each segment (tau, shoud be an integer factor of $num_itr)

For example: 
```
python3 toy_plot.py --loss two -n 3 -f 1 --agg tm --momentum 0.0 --attack NOBLE --nlpsize 1 --nlpobj 1 --EPOCH 100 --LR 1.2 --initp 1.75 -0.2
```

Wait the job done and a plot will show automatically. And you can also find the plots in [images_2dnonconvex](outputs%2Fimages_2dnonconvex). Please note that NLP attack takes a while to finish, especially when the segment length is big.

If you want to adjust the size or other features of the plot, please modify function `plot_function_and_trajectory` in [toy_plot.py](toy_plot.py).

If you want to run all 2D experiments, use following commands:
```
./plot_two_minima.sh 1.75 -0.2 100 1.2 cm
./plot_two_minima.sh 1.75 -0.2 100 1.2 tm
./plot_two_minima.sh 1.75 -0.2 100 1.2 rfa
./plot_two_minima.sh 1.75 -0.2 100 1.2 krum
```

## Implementation of `Jump` attack
Please refer to [codes/attacks_toy/nonlinear.py](codes%2Fattacks_toy%2Fnonlinear.py) for `Jump` attack implemented on 2D
non-convex landscape task and [codes/attacks/nonlinear.py](codes%2Fattacks%2Fnonlinear.py) for `Jump` attack implemented 
on MNIST and CIFAR-10 classification tasks. Note that the class name of `Jump` attack in 
[codes/attacks_toy/nonlinear.py](codes%2Fattacks_toy%2Fnonlinear.py) is `NOBLEAttack` but in  
[codes/attacks/nonlinear.py](codes%2Fattacks%2Fnonlinear.py) it's `SSNLPAttack`.
Also, the class name of `Solve(P)` attack in [codes/attacks_toy/nonlinear.py](codes%2Fattacks_toy%2Fnonlinear.py) is 
`NLPAttack`.

## References
In the current codebase, we draw upon references [1], [2], [3], and [4]. The Byzantine Learning framework and ALIE, IPM, LF, and mimic attacks are adaptations from [2]. Additionally, the MinMax and MinSum attacks are based on [3] and are further modified from [4].


[1]: Karimireddy, Sai Praneeth, Lie He, and Martin Jaggi. "Byzantine-robust learning on heterogeneous datasets via bucketing." arXiv preprint arXiv:2006.09365 (2020).

[2]: Karimireddy, Sai Praneeth, Lie He, and Martin Jaggi. "Byzantine-Robust Learning on Heterogeneous Datasets via Bucketing." https://github.com/epfml/byzantine-robust-noniid-optimizer.

[3]: Shejwalkar, Virat, and Amir Houmansadr. "Manipulating the byzantine: Optimizing model poisoning attacks and defenses for federated learning." NDSS. 2021.

[4]: Shejwalkar, Virat, and Amir Houmansadr. "A General Framework to Evaluate Robustness of Aggregation Algorithms in Federated Learning." https://github.com/vrt1shjwlkr/NDSS21-Model-Poisoning.
