
import pandas as pd
from genpaths import *

def load(path_list, idx, load_model_names=False):
    path = path_list[idx]
    df = pd.read_json(path, lines=True)
    if load_model_names:
        text = df["model_name"].tolist()
    else:
        text = df[path_list[-1]].tolist()
    if isinstance(text[0], list):
        text = [t[0] for t in text]
    return text

import random; random.seed(43)
for dataset_idx in range(3):
    machine = load(MACHINE, dataset_idx)
    machine_name = load(MACHINE, dataset_idx, True)
    llmopt = load(LLMOPT, dataset_idx)
    ours = load(OURS, dataset_idx)

    for _ in range(3):
        randidx = random.randint(0, len(machine)-1)
        print("{} & {} \\\\".format(machine_name[randidx], machine[randidx]))
        print("{} & {} \\\\".format("Mistral-7B-DPO-FastDetectGPT", llmopt[randidx]))
        print("{} & {} \\\\".format("Ours", ours[randidx]))

    input("Continue?")