      }(List}(
List.disjoint}(definition_nameh
source_urldhttps://leanprover-community.github.io/mathlib4_docs/Archive/Examples/IfNormalization/Statement.htmltype_signatureQdef List.disjoint {α : Type u_1} [DecidableEq α] :
List α → List α → Booldescription9A helper function to specify that two lists are disjoint.uList.toAssocList}(hhhRhttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/AssocList.htmlhddef List.toAssocList {α : Type u_1} {β : Type u_2} :
List (α × β) → Batteries.AssocList α βh
TConverts a list into an AssocList. This is the inverse function to AssocList.toList.uList.toList_toAssocList}(hhhRhttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/AssocList.htmlhptheorem List.toList_toAssocList {α : Type u_1} {β : Type u_2} (l : List (α × β)) :
l.toAssocList.toList = lh
 uList.length_toAssocList}(hhhRhttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/AssocList.htmlhwtheorem List.length_toAssocList {α : Type u_1} {β : Type u_2} (l : List (α × β)) :
l.toAssocList.length = l.lengthh
huList.mem_finRange}(hList.mem_finRangehThttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/FinRange.htmlhBtheorem List.mem_finRange {n : ℕ} (a : Fin n) :
a ∈ finRange nh
huList.toArrayMap}(hhhVhttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/ArrayMap.htmlhXdef List.toArrayMap {α : Type u} {β : Type v} (l : List α) (f : α → β) :
Array βh
This function is provided as a more efficient runtime alternative to (l.map f).toArray. (It avoids the intermediate memory allocation of creating an intermediate list first.) For verification purposes, we immediately simplify it to that form.uList.toArrayMap_toList}(hh$hVhttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/ArrayMap.htmlh|theorem List.toArrayMap_toList {α : Type u} {β : Type v} (l : List α) (f : α → β) :
(l.toArrayMap f).toList = map f lh
huList.toArrayMap_eq_toArray_map}(hh(hVhttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/ArrayMap.htmlhtheorem List.toArrayMap_eq_toArray_map {α : Type u} {β : Type v} (l : List α) (f : α → β) :
l.toArrayMap f = (map f l).toArrayh
hu
List.bagInter}(hh,hShttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Basic.htmlhLdef List.bagInter {α : Type u_1} [BEq α] :
List α → List α → List αh
Computes the "bag intersection" of l₁ and l₂, that is, the collection of elements of l₁ which are also in l₂. As each element is identified, it is removed from l₂, so elements are counted with multiplicity.u	List.diff}(hh1hShttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Basic.htmlhHdef List.diff {α : Type u_1} [BEq α] :
List α → List α → List αh
UComputes the difference of l₁ and l₂, by removing each element in l₂ from l₁.u
List.next?}(hh6hShttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Basic.htmlhCdef List.next? {α : Type u_1} :
List α → Option (α × List α)h
3Get the head and tail of a list, if it is nonempty.u
List.after}(hh;hShttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Basic.htmlhFdef List.after {α : Type u_1} (p : α → Bool) :
List α → List αh
dafter p xs is the suffix of xs after the first element that satisfies p, not including that element.u
List.replaceF}(hh@hShttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Basic.htmlhNdef List.replaceF {α : Type u_1} (f : α → Option α) :
List α → List αh
XReplaces the first element of the list for which f returns some with the returned value.uList.replaceFTR}(hhEhShttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Basic.htmlhRdef List.replaceFTR {α : Type u_1} (f : α → Option α) (l : List α) :
List αh
#Tail-recursive version of replaceF.uList.replaceF_eq_replaceFTR}(hhJhShttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Basic.htmlh=theorem List.replaceF_eq_replaceFTR :
@replaceF = @replaceFTRh
hu
List.union}(hhNhShttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Basic.htmlhGdef List.union {α : Type u_1} [BEq α] (l₁ l₂ : List α) :
List αh
Constructs the union of two lists, by inserting the elements of l₁ in reverse order to l₂. As a result, l₂ will always be a suffix, but only the last occurrence of each element in l₁ will be retained (but order will otherwise be preserved).uList.instUnionOfBEq_batteries}(hhShShttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Basic.htmlhQinstance List.instUnionOfBEq_batteries {α : Type u_1} [BEq α] :
Union (List α)h
hu
List.inter}(hhWhShttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Basic.htmlhGdef List.inter {α : Type u_1} [BEq α] (l₁ l₂ : List α) :
List αh
Constructs the intersection of two lists, by filtering the elements of l₁ that are in l₂. Unlike bagInter this does not preserve multiplicity: [1, 1].inter [1] is [1, 1].uList.instInterOfBEq_batteries}(hh\hShttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Basic.htmlhQinstance List.instInterOfBEq_batteries {α : Type u_1} [BEq α] :
Inter (List α)h
hu
List.splitAtD}(hh`hShttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Basic.htmlhZdef List.splitAtD {α : Type u_1} (n : Nat) (l : List α) (dflt : α) :
List α × List αh
Split a list at an index. Ensures the left list always has the specified length by right padding with the provided default element.u
List.splitOnP}(hhehShttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Basic.htmlhRdef List.splitOnP {α : Type u_1} (P : α → Bool) (l : List α) :
List (List α)h
[Split a list at every element satisfying a predicate. The separators are not in the result.uList.splitOnPTR}(hhjhShttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Basic.htmlhTdef List.splitOnPTR {α : Type u_1} (P : α → Bool) (l : List α) :
List (List α)h
#Tail recursive version of splitOnP.uList.splitOnP_eq_splitOnPTR}(hhohShttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Basic.htmlh=theorem List.splitOnP_eq_splitOnPTR :
@splitOnP = @splitOnPTRh
huList.splitOn}(hhshShttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Basic.htmlhRdef List.splitOn {α : Type u_1} [BEq α] (a : α) (as : List α) :
List (List α)h
^Split a list at every occurrence of a separator element. The separators are not in the result.uList.modifyLast}(hhxhShttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Basic.htmlhKdef List.modifyLast {α : Type u_1} (f : α → α) (l : List α) :
List αh
/Apply f to the last element of l, if it exists.uList.headD_eq_head?}(hh}hShttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Basic.htmlh_theorem List.headD_eq_head? {α : Type u_1} (l : List α) (a : α) :
l.headD a = l.head?.getD ah
hu
List.takeD}(hhhShttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Basic.htmlhCdef List.takeD {α : Type u_1} :
Nat → List α → α → List αh
]Take n elements from a list l. If l has less than n elements, append n - length l elements x.uList.takeD_zero}(hhhShttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Basic.htmlhQtheorem List.takeD_zero {α : Type u_1} (l : List α) (a : α) :
takeD 0 l a = []h
huList.takeD_succ}(hhhShttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Basic.htmlhtheorem List.takeD_succ {α : Type u_1} {n : Nat} (l : List α) (a : α) :
takeD (n + 1) l a = l.head?.getD a :: takeD n l.tail ah
huList.takeD_nil}(hhhShttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Basic.htmlhXtheorem List.takeD_nil {α : Type u_1} (n : Nat) (a : α) :
takeD n [] a = replicate n ah
huList.takeDTR}(hhhShttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Basic.htmlhNdef List.takeDTR {α : Type u_1} (n : Nat) (l : List α) (dflt : α) :
List αh
 Tail-recursive version of takeD.uList.takeDTR_go_eq}(hhhShttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Basic.htmlhtheorem List.takeDTR_go_eq {α✝ : Type u_1} {dflt : α✝} {acc : Array α✝} (n : Nat) (l : List α✝) :
takeDTR.go dflt n l acc = acc.toList ++ takeD n l dflth
huList.takeD_eq_takeDTR}(hhhShttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Basic.htmlh1theorem List.takeD_eq_takeDTR :
@takeD = @takeDTRh
hu
List.scanl}(hhhShttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Basic.htmlhddef List.scanl {α : Type u_1} {β : Type u_2} (f : α → β → α) (a : α) :
List β → List αh
UFold a function f over the list from the left, returning the list of partial results.uList.scanlTR}(hhhShttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Basic.htmlhhdef List.scanlTR {α : Type u_1} {β : Type u_2} (f : α → β → α) (a : α) (l : List β) :
List αh
 Tail-recursive version of scanl.uList.scanlTR_go_eq}(hhhShttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Basic.htmlhtheorem List.scanlTR_go_eq {α✝ : Type u_1} {α✝¹ : Type u_2} {f : α✝ → α✝¹ → α✝} {a : α✝} {acc : Array α✝} (l : List α✝¹) :
scanlTR.go f l a acc = acc.toList ++ scanl f a lh
huList.scanl_eq_scanlTR}(hhhShttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Basic.htmlh1theorem List.scanl_eq_scanlTR :
@scanl = @scanlTRh
hu
List.scanr}(hhhShttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Basic.htmlhfdef List.scanr {α : Type u_1} {β : Type u_2} (f : α → β → β) (b : β) (l : List α) :
List βh
VFold a function f over the list from the right, returning the list of partial results.u
List.foldlIdx}(hhhShttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Basic.htmlhdef List.foldlIdx {α : Sort u_1} {β : Type u_2} (f : Nat → α → β → α) (init : α) :
List β → (start : optParam Nat 0) → αh
lFold a list from left to right as with foldl, but the combining function also receives each element's index.u
List.foldrIdx}(hhhShttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Basic.htmlhdef List.foldrIdx {α : Type u_1} {β : Sort u_2} (f : Nat → α → β → β) (init : β) (l : List α) (start : Nat := 0) :
βh
lFold a list from right to left as with foldr, but the combining function also receives each element's index.u
List.findIdxs}(hhhShttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Basic.htmlhLdef List.findIdxs {α : Type u_1} (p : α → Bool) (l : List α) :
List Nath
DfindIdxs p l is the list of indexes of elements of l that satisfy p.uList.indexesValues}(hhhShttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Basic.htmlhYdef List.indexesValues {α : Type u_1} (p : α → Bool) (l : List α) :
List (Nat × α)h
qReturns the elements of l that satisfy p together with their indexes in l. The returned list is ordered by index.uList.indexesOf}(hhhShttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Basic.htmlhKdef List.indexesOf {α : Type u_1} [BEq α] (a : α) :
List α → List Nath
@indexesOf a l is the list of all indexes of a in l. For example:uList.lookmap}(hhhShttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Basic.htmlhOdef List.lookmap {α : Type u_1} (f : α → Option α) (l : List α) :
List αh
lookmap is a combination of lookup and filterMap. lookmap f l will apply f : α → Option α to each element of the list, replacing a → b at the first value a in the list such that f a = some b.u
List.inits}(hhhShttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Basic.htmlh;def List.inits {α : Type u_1} :
List α → List (List α)h
-inits l is the list of initial segments of l.uList.initsTR}(hhhShttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Basic.htmlh?def List.initsTR {α : Type u_1} (l : List α) :
List (List α)h
 Tail-recursive version of inits.uList.inits_eq_initsTR}(hhhShttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Basic.htmlh1theorem List.inits_eq_initsTR :
@inits = @initsTRh
hu
List.tails}(hhhShttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Basic.htmlh;def List.tails {α : Type u_1} :
List α → List (List α)h
.tails l is the list of terminal segments of l.uList.tailsTR}(hhhShttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Basic.htmlh?def List.tailsTR {α : Type u_1} (l : List α) :
List (List α)h
 Tail-recursive version of tails.uList.tails_eq_tailsTR}(hhhShttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Basic.htmlh1theorem List.tails_eq_tailsTR :
@tails = @tailsTRh
huList.sublists'}(hhhShttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Basic.htmlhAdef List.sublists' {α : Type u_1} (l : List α) :
List (List α)h
sublists' l is the list of all (non-contiguous) sublists of l. It differs from sublists only in the order of appearance of the sublists; sublists' uses the first element of the list as the MSB, sublists uses the first element of the list as the LSB.u
List.sublists}(hhhShttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Basic.htmlh@def List.sublists {α : Type u_1} (l : List α) :
List (List α)h
esublists l is the list of all (non-contiguous) sublists of l; cf. sublists' for a different ordering.uList.sublistsFast}(hhhShttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Basic.htmlhDdef List.sublistsFast {α : Type u_1} (l : List α) :
List (List α)h
[A version of List.sublists that has faster runtime performance but worse kernel performanceuList.Forall₂}(hhhShttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Basic.htmlhpinductive List.Forall₂ {α : Type u_1} {β : Type u_2} (R : α → β → Prop) :
List α → List β → Proph
X?  Forall₂ R l₁ l₂ means that l₁ and l₂ have the same length, and whenever a is the nth element of l₁, and b is the nth element of l₂, then R a b is satisfied.
Two nil lists are Forall₂-related
Two cons lists are related by Forall₂ R if the heads are related by R and the tails are related by Forall₂ RuList.forall₂_cons}(hj  hShttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Basic.htmlhtheorem List.forall₂_cons {α : Type u_1} {β : Type u_2} {R : α → β → Prop} {a : α} {b : β} {l₁ : List α} {l₂ : List β} :
Forall₂ R (a :: l₁) (b :: l₂) ↔ R a b ∧ Forall₂ R l₁ l₂h
huList.all₂}(hj  hShttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Basic.htmlhgdef List.all₂ {α : Type u_1} {β : Type u_2} (r : α → β → Bool) :
List α → List β → Boolh
|Check for all elements a, b, where a and b are the nth element of the first and second List respectively, that r a b = true.uList.all₂_eq_true}(hj
  hShttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Basic.htmlhtheorem List.all₂_eq_true {α : Type u_1} {β : Type u_2} {r : α → β → Bool} (l₁ : List α) (l₂ : List β) :
all₂ r l₁ l₂ = true ↔ Forall₂ (fun (x1 : α) (x2 : β) => r x1 x2 = true) l₁ l₂h
huList.instDecidableForall₂}(hj  hShttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Basic.htmlhinstance List.instDecidableForall₂ {α : Type u_1} {β : Type u_2} {R : α → β → Prop} [(a : α) → (b : β) → Decidable (R a b)] (l₁ : List α) (l₂ : List β) :
Decidable (Forall₂ R l₁ l₂)h
huList.transpose}(hj  hShttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Basic.htmlhHdef List.transpose {α : Type u_1} (l : List (List α)) :
List (List α)h
2Transpose of a list of lists, treated as a matrix.u
List.sections}(hj  hShttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Basic.htmlhEdef List.sections {α : Type u_1} :
List (List α) → List (List α)h
List of all sections through a list of lists. A section of [L₁, L₂, ..., Lₙ] is a list whose first element comes from L₁, whose second element comes from L₂, and so on.uList.sectionsTR}(hj  hShttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Basic.htmlhIdef List.sectionsTR {α : Type u_1} (L : List (List α)) :
List (List α)h
Optimized version of sections.uList.sections_eq_nil_of_isEmpty}(hj$  hShttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Basic.htmlhwtheorem List.sections_eq_nil_of_isEmpty {α : Type u_1} {L : List (List α)} :
L.any isEmpty = true → L.sections = []h
huList.sections_eq_sectionsTR}(hj(  hShttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Basic.htmlh=theorem List.sections_eq_sectionsTR :
@sections = @sectionsTRh
hu
List.extractP}(hj,  hShttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Basic.htmlhXdef List.extractP {α : Type u_1} (p : α → Bool) (l : List α) :
Option α × List αh
extractP p l returns a pair of an element a of l satisfying the predicate p, and l, with a removed. If there is no such element a it returns (none, l).uList.revzip}(hj1  hShttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Basic.htmlh?def List.revzip {α : Type u_1} (l : List α) :
List (α × α)h
erevzip l returns a list of pairs of the elements of l paired with the elements of l in reverse order.uList.product}(hj6  hShttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Basic.htmlhddef List.product {α : Type u_1} {β : Type u_2} (l₁ : List α) (l₂ : List β) :
List (α × β)h
Nproduct l₁ l₂ is the list of pairs (a, b) where a ∈ l₁ and b ∈ l₂.uList.productTR}(hj;  hShttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Basic.htmlhfdef List.productTR {α : Type u_1} {β : Type u_2} (l₁ : List α) (l₂ : List β) :
List (α × β)h
Optimized version of product.uList.product_eq_productTR}(hj@  hShttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Basic.htmlh9theorem List.product_eq_productTR :
@product = @productTRh
hu
List.sigma}(hjD  hShttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Basic.htmlhdef List.sigma {α : Type u_1} {σ : α → Type u_2} (l₁ : List α) (l₂ : (a : α) → List (σ a)) :
List ((a : α) × σ a)h
Xsigma l₁ l₂ is the list of dependent pairs (a, b) where a ∈ l₁ and b ∈ l₂ a.uList.sigmaTR}(hjI  hShttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Basic.htmlhdef List.sigmaTR {α : Type u_1} {σ : α → Type u_2} (l₁ : List α) (l₂ : (a : α) → List (σ a)) :
List ((a : α) × σ a)h
Optimized version of sigma.uList.sigma_eq_sigmaTR}(hjN  hShttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Basic.htmlh6theorem List.sigma_eq_sigmaTR :
@List.sigma = @sigmaTRh
huList.ofFnNthVal}(hjR  hShttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Basic.htmlhVdef List.ofFnNthVal {α : Type u_1} {n : Nat} (f : Fin n → α) (i : Nat) :
Option αh
>ofFnNthVal f i returns some (f i) if i < n and none otherwise.u
List.Disjoint}(hjW  hShttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Basic.htmlh>def List.Disjoint {α : Type u_1} (l₁ l₂ : List α) :
Proph
GDisjoint l₁ l₂ means that l₁ and l₂ have no elements in common.uList.takeWhile₂}(hj\  hShttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Basic.htmlh{def List.takeWhile₂ {α : Type u_1} {β : Type u_2} (R : α → β → Bool) :
List α → List β → List α × List βh
YReturns the longest initial prefix of two lists such that they are pairwise related by R.uList.takeWhile₂TR}(hja  hShttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Basic.htmlhdef List.takeWhile₂TR {α : Type u_1} {β : Type u_2} (R : α → β → Bool) (as : List α) (bs : List β) :
List α × List βh
'Tail-recursive version of takeWhile₂.u#List.takeWhile₂_eq_takeWhile₂TR}(hjf  hShttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Basic.htmlhMtheorem List.takeWhile₂_eq_takeWhile₂TR :
@takeWhile₂ = @takeWhile₂TRh
hu
List.pwFilter}(hjj  hShttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Basic.htmlhcdef List.pwFilter {α : Type u_1} (R : α → α → Prop) [DecidableRel R] (l : List α) :
List αh
pwFilter R l is a maximal sublist of l which is Pairwise R. pwFilter (·≠·) is the erase duplicates function (cf. eraseDup), and pwFilter (·<·) finds a maximal increasing subsequence in l. For example,u
List.Chain}(hjo  hShttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Basic.htmlhWinductive List.Chain {α : Type u_1} (R : α → α → Prop) :
α → List α → Proph
Chain R a l means that R holds between adjacent elements of a::l.
A chain of length 1 is trivially a chain.
If a relates to b and b::l is a chain, then a :: b :: l is also a chain.uList.Chain'}(hjt  hShttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Basic.htmlhKdef List.Chain' {α : Type u_1} (R : α → α → Prop) :
List α → Proph
=Chain' R l means that R holds between adjacent elements of l.u
List.eraseDup}(hjy  hShttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Basic.htmlh@def List.eraseDup {α : Type u_1} [BEq α] :
List α → List αh
ceraseDup l removes duplicates from l (taking only the first occurrence). Defined as pwFilter (≠).uList.rotate}(hj~  hShttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Basic.htmlhAdef List.rotate {α : Type u_1} (l : List α) (n : Nat) :
List αh
5rotate l n rotates the elements of l to the left by nuList.rotate'}(hj  hShttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Basic.htmlh>def List.rotate' {α : Type u_1} :
List α → Nat → List αh
Grotate' is the same as rotate, but slower. Used for proofs about rotateu
List.mapDiagM}(hj  hShttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Basic.htmlhdef List.mapDiagM {m : Type u_1 → Type u_2} {α : Type u_3} {β : Type u_1} [Monad m] (f : α → α → m β) (l : List α) :
m (List β)h
mapDiagM f l calls f on all elements in the upper triangular part of l × l. That is, for each e ∈ l, it will run f e e and then f e e' for each e' that appears after e in l.u
List.forDiagM}(hj  hShttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Basic.htmlhydef List.forDiagM {m : Type u_1 → Type u_2} {α : Type u_3} [Monad m] (f : α → α → m PUnit) :
List α → m PUnith
forDiagM f l calls f on all elements in the upper triangular part of l × l. That is, for each e ∈ l, it will run f e e and then f e e' for each e' that appears after e in l.uList.getRest}(hj  hShttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Basic.htmlh\def List.getRest {α : Type u_1} [DecidableEq α] :
List α → List α → Option (List α)h
`getRest l l₁ returns some l₂ if l = l₁ ++ l₂. If l₁ is not a prefix of l, returns noneuList.dropSlice}(hj  hShttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Basic.htmlhHdef List.dropSlice {α : Type u_1} :
Nat → Nat → List α → List αh
HList.dropSlice n m xs removes a slice of length m at index n in list xs.uList.dropSliceTR}(hj  hShttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Basic.htmlhHdef List.dropSliceTR {α : Type u_1} (n m : Nat) (l : List α) :
List αh
Optimized version of dropSlice.uList.dropSlice_zero₂}(hj  hShttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Basic.htmlh\theorem List.dropSlice_zero₂ {α : Type u_1} (n : Nat) (l : List α) :
dropSlice n 0 l = lh
huList.dropSlice_eq_dropSliceTR}(hj  hShttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Basic.htmlhAtheorem List.dropSlice_eq_dropSliceTR :
@dropSlice = @dropSliceTRh
huList.zipWithLeft'}(hj  hShttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Basic.htmlhdef List.zipWithLeft' {α : Type u_1} {β : Type u_2} {γ : Type u_3} (f : α → Option β → γ) :
List α → List β → List γ × List βh
X   Left-biased version of List.zipWith. zipWithLeft' f as bs applies f to each pair of elements aᵢ ∈ as and bᵢ ∈ bs. If bs is shorter than as, f is applied to none for the remaining aᵢ. Returns the results of the f applications and the remaining bs.uList.zipWithLeft'TR}(hj  hShttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Basic.htmlhdef List.zipWithLeft'TR {α : Type u_1} {β : Type u_2} {γ : Type u_3} (f : α → Option β → γ) (as : List α) (bs : List β) :
List γ × List βh
'Tail-recursive version of zipWithLeft'.u#List.zipWithLeft'_eq_zipWithLeft'TR}(hj  hShttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Basic.htmlhMtheorem List.zipWithLeft'_eq_zipWithLeft'TR :
@zipWithLeft' = @zipWithLeft'TRh
huList.zipWithRight'}(hj  hShttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Basic.htmlhdef List.zipWithRight' {α : Type u_1} {β : Type u_2} {γ : Type u_3} (f : Option α → β → γ) (as : List α) (bs : List β) :
List γ × List αh
X  Right-biased version of List.zipWith. zipWithRight' f as bs applies f to each pair of elements aᵢ ∈ as and bᵢ ∈ bs. If as is shorter than bs, f is applied to none for the remaining bᵢ. Returns the results of the f applications and the remaining as.u
List.zipLeft'}(hj  hShttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Basic.htmlhmdef List.zipLeft' {α : Type u_1} {β : Type u_2} :
List α → List β → List (α × Option β) × List βh
Left-biased version of List.zip. zipLeft' as bs returns the list of pairs (aᵢ, bᵢ) for aᵢ ∈ as and bᵢ ∈ bs. If bs is shorter than as, the remaining aᵢ are paired with none. Also returns the remaining bs.uList.zipRight'}(hj  hShttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Basic.htmlhndef List.zipRight' {α : Type u_1} {β : Type u_2} :
List α → List β → List (Option α × β) × List αh
Right-biased version of List.zip. zipRight' as bs returns the list of pairs (aᵢ, bᵢ) for aᵢ ∈ as and bᵢ ∈ bs. If as is shorter than bs, the remaining bᵢ are paired with none. Also returns the remaining as.uList.zipWithLeft}(hj  hShttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Basic.htmlhdef List.zipWithLeft {α : Type u_1} {β : Type u_2} {γ : Type u_3} (f : α → Option β → γ) :
List α → List β → List γh
Left-biased version of List.zipWith. zipWithLeft f as bs applies f to each pair aᵢ ∈ as and bᵢ ‌∈ bs‌∈ bs. If bs is shorter than as, f is applied to none for the remaining aᵢ.uList.zipWithLeftTR}(hj  hShttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Basic.htmlhdef List.zipWithLeftTR {α : Type u_1} {β : Type u_2} {γ : Type u_3} (f : α → Option β → γ) (as : List α) (bs : List β) :
List γh
&Tail-recursive version of zipWithLeft.u!List.zipWithLeft_eq_zipWithLeftTR}(hj  hShttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Basic.htmlhItheorem List.zipWithLeft_eq_zipWithLeftTR :
@zipWithLeft = @zipWithLeftTRh
huList.zipWithRight}(hj  hShttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Basic.htmlhdef List.zipWithRight {α : Type u_1} {β : Type u_2} {γ : Type u_3} (f : Option α → β → γ) (as : List α) (bs : List β) :
List γh
Right-biased version of List.zipWith. zipWithRight f as bs applies f to each pair aᵢ ∈ as and bᵢ ‌∈ bs‌∈ bs. If as is shorter than bs, f is applied to none for the remaining bᵢ.uList.zipLeft}(hj  hShttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Basic.htmlhadef List.zipLeft {α : Type u_1} {β : Type u_2} :
List α → List β → List (α × Option β)h
Left-biased version of List.zip. zipLeft as bs returns the list of pairs (aᵢ, bᵢ) for aᵢ ∈ as and bᵢ ∈ bs. If bs is shorter than as, the remaining aᵢ are paired with none.u
List.zipRight}(hj  hShttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Basic.htmlhbdef List.zipRight {α : Type u_1} {β : Type u_2} :
List α → List β → List (Option α × β)h
Right-biased version of List.zip. zipRight as bs returns the list of pairs (aᵢ, bᵢ) for aᵢ ∈ as and bᵢ ∈ bs. If as is shorter than bs, the remaining bᵢ are paired with none.uList.allSome}(hj  hShttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Basic.htmlhJdef List.allSome {α : Type u_1} (l : List (Option α)) :
Option (List α)h
\If all elements of xs are some xᵢ, allSome xs returns the xᵢ. Otherwise it returns none.uList.fillNones}(hj  hShttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Basic.htmlhMdef List.fillNones {α : Type u_1} :
List (Option α) → List α → List αh
fillNones xs ys replaces the nones in xs with elements of ys. If there are not enough ys to replace all the nones, the remaining nones are dropped from xs.u
List.takeList}(hj  hShttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Basic.htmlhVdef List.takeList {α : Type u_1} :
List α → List Nat → List (List α) × List αh
Xx  takeList as ns extracts successive sublists from as. For ns = n₁ ... nₘ, it first takes the n₁ initial elements from as, then the next n₂ ones, etc. It returns the sublists of as -- one for each nᵢ -- and the remaining elements of as. If as does not have at least as many elements as the sum of the nᵢ, the corresponding sublists will have less than nᵢ elements.uList.takeListTR}(hj  hShttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Basic.htmlh^def List.takeListTR {α : Type u_1} (xs : List α) (ns : List Nat) :
List (List α) × List αh
#Tail-recursive version of takeList.uList.takeList_eq_takeListTR}(hj  hShttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Basic.htmlh=theorem List.takeList_eq_takeListTR :
@takeList = @takeListTRh
huList.toChunksAux}(hj  hShttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Basic.htmlh^def List.toChunksAux {α : Type u_1} (n : Nat) :
List α → Nat → List α × List (List α)h
Auxliary definition used to define toChunks. toChunksAux n xs i returns (xs.take i, (xs.drop i).toChunks (n+1)), that is, the first i elements of xs, and the remaining elements chunked into sublists of length n+1.u
List.toChunks}(hj   hShttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Basic.htmlhFdef List.toChunks {α : Type u_1} :
Nat → List α → List (List α)h
cxs.toChunks n splits the list into sublists of size at most n, such that (xs.toChunks n).join = xs.uList.zipWith₃}(hj  hShttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Basic.htmlhdef List.zipWith₃ {α : Type u_1} {β : Type u_2} {γ : Type u_3} {δ : Type u_4} (f : α → β → γ → δ) :
List α → List β → List γ → List δh
 Ternary version of List.zipWith.uList.zipWith₄}(hj
  hShttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Basic.htmlhdef List.zipWith₄ {α : Type u_1} {β : Type u_2} {γ : Type u_3} {δ : Type u_4} {ε : Type u_5} (f : α → β → γ → δ → ε) :
List α → List β → List γ → List δ → List εh
#Quaternary version of List.zipWith.uList.zipWith₅}(hj  hShttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Basic.htmlhdef List.zipWith₅ {α : Type u_1} {β : Type u_2} {γ : Type u_3} {δ : Type u_4} {ε : Type u_5} {ζ : Type u_6} (f : α → β → γ → δ → ε → ζ) :
List α → List β → List γ → List δ → List ε → List ζh
 Quinary version of List.zipWith.uList.mapWithPrefixSuffixAux}(hj  hShttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Basic.htmlhdef List.mapWithPrefixSuffixAux {α : Type u_1} {β : Type u_2} (f : List α → α → List α → β) :
List α → List α → List βh
3An auxiliary function for List.mapWithPrefixSuffix.uList.mapWithPrefixSuffix}(hj  hShttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Basic.htmlh|def List.mapWithPrefixSuffix {α : Type u_1} {β : Type u_2} (f : List α → α → List α → β) (l : List α) :
List βh
X  List.mapWithPrefixSuffix f l maps f across a list l. For each a ∈ l with l = pref ++ [a] ++ suff, a is mapped to f pref a suff. Example: if f : list Nat → Nat → list Nat → β, List.mapWithPrefixSuffix f [1, 2, 3] will produce the list [f [] 1 [2, 3], f [1] 2 [3], f [1, 2] 3 []].uList.mapWithComplement}(hj  hShttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Basic.htmlhldef List.mapWithComplement {α : Type u_1} {β : Type u_2} (f : α → List α → β) :
List α → List βh
Xi  List.mapWithComplement f l is a variant of List.mapWithPrefixSuffix that maps f across a list l. For each a ∈ l with l = pref ++ [a] ++ suff, a is mapped to f a (pref ++ suff), i.e., the list input to f is l with a removed. Example: if f : Nat → list Nat → β, List.mapWithComplement f [1, 2, 3] will produce the list [f 1 [2, 3], f 2 [1, 3], f 3 [1, 2]].u
List.traverse}(hj#  hShttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Basic.htmlhdef List.traverse {F : Type u_1 → Type u_2} {α : Type u_3} {β : Type u_1} [Applicative F] (f : α → F β) :
List α → F (List β)h
bMap each element of a List to an action, evaluate these actions in order, and collect the results.uList.Subperm}(hj(  hShttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Basic.htmlh=def List.Subperm {α : Type u_1} (l₁ l₂ : List α) :
Proph
Subperm l₁ l₂, denoted l₁ <+~ l₂, means that l₁ is a sublist of a permutation of l₂. This is an analogue of l₁ ⊆ l₂ which respects multiplicities of elements, and is used for the ≤ relation on multisets.uList.«term_<+~_»}(hj-  hShttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Basic.htmlh1def List.«term_<+~_» :
Lean.TrailingParserDescrh
Subperm l₁ l₂, denoted l₁ <+~ l₂, means that l₁ is a sublist of a permutation of l₂. This is an analogue of l₁ ⊆ l₂ which respects multiplicities of elements, and is used for the ≤ relation on multisets.uList.isSubperm}(hj2  hShttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Basic.htmlhHdef List.isSubperm {α : Type u_1} [BEq α] (l₁ l₂ : List α) :
Boolh
O(|l₁| * (|l₁| + |l₂|)). Computes whether l₁ is a sublist of a permutation of l₂. See isSubperm_iff for a characterization in terms of List.Subperm.uList.insertP}(hj7  hShttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Basic.htmlhSdef List.insertP {α : Type u_1} (p : α → Bool) (a : α) (l : List α) :
List αh
|O(|l|). Inserts a in l right before the first element such that p is true, or at the end of the list if p always false on l.uList.dropPrefix?}(hj<  hShttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Basic.htmlhXdef List.dropPrefix? {α : Type u_1} [BEq α] :
List α → List α → Option (List α)h
gdropPrefix? l p returns some r if l = p' ++ r for some p' which is paiwise == to p, and none otherwise.uList.dropSuffix?}(hjA  hShttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Basic.htmlhPdef List.dropSuffix? {α : Type u_1} [BEq α] (l s : List α) :
Option (List α)h
gdropSuffix? l s returns some r if l = r ++ s' for some s' which is paiwise == to s, and none otherwise.uList.dropInfix?}(hjF  hShttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Basic.htmlhZdef List.dropInfix? {α : Type u_1} [BEq α] (l i : List α) :
Option (List α × List α)h
X*  dropInfix? l i returns some (p, s) if l = p ++ i' ++ s for some i' which is paiwise == to i, and none otherwise.
Note that this is an inefficient implementation, and if computation time is a concern you should be using the Knuth-Morris-Pratt algorithm as implemented in Batteries.Data.List.Matcher.uList.count_singleton'}(hjK  hShttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Count.htmlhptheorem List.count_singleton' {α : Type u_1} [DecidableEq α] (a b : α) :
count a [b] = if b = a then 1 else 0h
huList.count_concat}(hjO  hShttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Count.htmlh{theorem List.count_concat {α : Type u_1} [DecidableEq α] (a : α) (l : List α) :
count a (l.concat a) = (count a l).succh
huList.getElem_mk}(hjS  hThttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Lemmas.htmlhrtheorem List.getElem_mk {α : Type u_1} {xs : List α} {i : Nat} (h : i < xs.length) :
{ toList := xs }[i] = xs[i]h
huList.next?_nil}(hjW  hThttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Lemmas.htmlh8theorem List.next?_nil {α : Type u_1} :
[].next? = noneh
huList.next?_cons}(hj[  hThttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Lemmas.htmlh]theorem List.next?_cons {α : Type u_1} (a : α) (l : List α) :
(a :: l).next? = some (a, l)h
huList.dropLast_eq_eraseIdx}(hj_  hThttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Lemmas.htmlhtheorem List.dropLast_eq_eraseIdx {α : Type u_1} {xs : List α} {i : Nat} (last_idx : i + 1 = xs.length) :
xs.dropLast = xs.eraseIdx ih
huList.set_eq_modify}(hjc  hThttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Lemmas.htmlhvtheorem List.set_eq_modify {α : Type u_1} (a : α) (n : Nat) (l : List α) :
l.set n a = l.modify n fun (x : α) => ah
huList.set_eq_take_cons_drop}(hjg  hThttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Lemmas.htmlhtheorem List.set_eq_take_cons_drop {α : Type u_1} (a : α) {n : Nat} {l : List α} (h : n < l.length) :
l.set n a = take n l ++ a :: drop (n + 1) lh
huList.modify_eq_set_getElem?}(hjk  hThttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Lemmas.htmlhtheorem List.modify_eq_set_getElem? {α : Type u_1} (f : α → α) (n : Nat) (l : List α) :
l.modify n f = ((fun (a : α) => l.set n (f a)) <$> l[n]?).getD lh
huList.modify_eq_set_get?}(hjo  hThttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Lemmas.htmlhtheorem List.modify_eq_set_get? {α : Type u_1} (f : α → α) (n : Nat) (l : List α) :
l.modify n f = ((fun (a : α) => l.set n (f a)) <$> l[n]?).getD lh
%Alias of List.modify_eq_set_getElem?.uList.modify_eq_set_get}(hjt  hThttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Lemmas.htmlhtheorem List.modify_eq_set_get {α : Type u_1} (f : α → α) {n : Nat} {l : List α} (h : n < l.length) :
l.modify n f = l.set n (f (l.get ⟨n, h⟩))h
huList.getElem?_set_eq_of_lt}(hjx  hThttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Lemmas.htmlhtheorem List.getElem?_set_eq_of_lt {α : Type u_1} (a : α) {n : Nat} {l : List α} (h : n < l.length) :
(l.set n a)[n]? = some ah
huList.getElem?_set_of_lt}(hj|  hThttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Lemmas.htmlhtheorem List.getElem?_set_of_lt {α : Type u_1} (a : α) {m n : Nat} (l : List α) (h : n < l.length) :
(l.set m a)[n]? = if m = n then some a else l[n]?h
huList.get?_set_of_lt}(hj  hThttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Lemmas.htmlhtheorem List.get?_set_of_lt {α : Type u_1} (a : α) {m n : Nat} (l : List α) (h : n < l.length) :
(l.set m a)[n]? = if m = n then some a else l[n]?h
!Alias of List.getElem?_set_of_lt.uList.getElem?_set_of_lt'}(hj  hThttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Lemmas.htmlhtheorem List.getElem?_set_of_lt' {α : Type u_1} (a : α) {m n : Nat} (l : List α) (h : m < l.length) :
(l.set m a)[n]? = if m = n then some a else l[n]?h
huList.get?_set_of_lt'}(hj  hThttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Lemmas.htmlhtheorem List.get?_set_of_lt' {α : Type u_1} (a : α) {m n : Nat} (l : List α) (h : m < l.length) :
(l.set m a)[n]? = if m = n then some a else l[n]?h
"Alias of List.getElem?_set_of_lt'.uList.length_tail_add_one}(hj  hThttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Lemmas.htmlhptheorem List.length_tail_add_one {α : Type u_1} (l : List α) (h : 0 < l.length) :
l.tail.length + 1 = l.lengthh
huList.extractP_eq_find?_eraseP}(hj  hThttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Lemmas.htmlh~theorem List.extractP_eq_find?_eraseP {α : Type u_1} {p : α → Bool} (l : List α) :
extractP p l = (find? p l, eraseP p l)h
hu!List.erase_eq_self_iff_forall_bne}(hj  hThttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Lemmas.htmlhtheorem List.erase_eq_self_iff_forall_bne {α : Type u_1} [BEq α] (a : α) (xs : List α) :
xs.erase a = xs ↔ ∀ (x : α), x ∈ xs → ¬(x == a) = trueh
huList.findIdx_eq_findIdx?}(hj  hThttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Lemmas.htmlhtheorem List.findIdx_eq_findIdx? {α : Type u_1} (p : α → Bool) (l : List α) :
findIdx p l = match findIdx? p l with
  | some i => i
  | none => l.lengthh
huList.replaceF_nil}(hj  hThttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Lemmas.htmlh^theorem List.replaceF_nil {α✝ : Type u_1} {p : α✝ → Option α✝} :
replaceF p [] = []h
huList.replaceF_cons}(hj  hThttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Lemmas.htmlhtheorem List.replaceF_cons {α : Type u_1} {p : α → Option α} (a : α) (l : List α) :
replaceF p (a :: l) = match p a with
  | none => a :: replaceF p l
  | some a' => a' :: lh
huList.replaceF_cons_of_some}(hj  hThttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Lemmas.htmlhtheorem List.replaceF_cons_of_some {α : Type u_1} {a' a : α} {l : List α} (p : α → Option α) (h : p a = some a') :
replaceF p (a :: l) = a' :: lh
huList.replaceF_cons_of_none}(hj  hThttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Lemmas.htmlhtheorem List.replaceF_cons_of_none {α : Type u_1} {a : α} {l : List α} (p : α → Option α) (h : p a = none) :
replaceF p (a :: l) = a :: replaceF p lh
huList.replaceF_of_forall_none}(hj  hThttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Lemmas.htmlhtheorem List.replaceF_of_forall_none {α : Type u_1} {p : α → Option α} {l : List α} (h : ∀ (a : α), a ∈ l → p a = none) :
replaceF p l = lh
huList.exists_of_replaceF}(hj  hThttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Lemmas.htmlhXo  theorem List.exists_of_replaceF {α : Type u_1} {p : α → Option α} {l : List α} {a a' : α} :
a ∈ l →
  p a = some a' →
    ∃ (a : α),       ∃ (a' : α),         ∃ (l₁ : List α),           ∃ (l₂ : List α),             (∀ (b : α), b ∈ l₁ → p b = none) ∧ p a = some a' ∧ l = l₁ ++ a :: l₂ ∧ replaceF p l = l₁ ++ a' :: l₂h
hu"List.exists_or_eq_self_of_replaceF}(hj  hThttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Lemmas.htmlhX;  theorem List.exists_or_eq_self_of_replaceF {α : Type u_1} (p : α → Option α) (l : List α) :
replaceF p l = l ∨ ∃ (a : α), ∃ (a' : α), ∃ (l₁ : List α), ∃ (l₂ : List α), (∀ (b : α), b ∈ l₁ → p b = none) ∧ p a = some a' ∧ l = l₁ ++ a :: l₂ ∧ replaceF p l = l₁ ++ a' :: l₂h
huList.length_replaceF}(hj  hThttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Lemmas.htmlhtheorem List.length_replaceF {α✝ : Type u_1} {f : α✝ → Option α✝} {l : List α✝} :
(replaceF f l).length = l.lengthh
huList.disjoint_symm}(hj  hThttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Lemmas.htmlhttheorem List.disjoint_symm {α✝ : Type u_1} {l₁ l₂ : List α✝} (d : l₁.Disjoint l₂) :
l₂.Disjoint l₁h
huList.disjoint_comm}(hj  hThttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Lemmas.htmlhrtheorem List.disjoint_comm {α✝ : Type u_1} {l₁ l₂ : List α✝} :
l₁.Disjoint l₂ ↔ l₂.Disjoint l₁h
huList.disjoint_left}(hj  hThttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Lemmas.htmlhtheorem List.disjoint_left {α✝ : Type u_1} {l₁ l₂ : List α✝} :
l₁.Disjoint l₂ ↔ ∀ ⦃a : α✝⦄, a ∈ l₁ → ¬a ∈ l₂h
huList.disjoint_right}(hj  hThttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Lemmas.htmlhtheorem List.disjoint_right {α✝ : Type u_1} {l₁ l₂ : List α✝} :
l₁.Disjoint l₂ ↔ ∀ ⦃a : α✝⦄, a ∈ l₂ → ¬a ∈ l₁h
huList.disjoint_iff_ne}(hj  hThttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Lemmas.htmlhtheorem List.disjoint_iff_ne {α✝ : Type u_1} {l₁ l₂ : List α✝} :
l₁.Disjoint l₂ ↔ ∀ (a : α✝), a ∈ l₁ → ∀ (b : α✝), b ∈ l₂ → a ≠ bh
huList.disjoint_of_subset_left}(hj  hThttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Lemmas.htmlhtheorem List.disjoint_of_subset_left {α✝ : Type u_1} {l₁ l l₂ : List α✝} (ss : l₁ ⊆ l) (d : l.Disjoint l₂) :
l₁.Disjoint l₂h
huList.disjoint_of_subset_right}(hj  hThttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Lemmas.htmlhtheorem List.disjoint_of_subset_right {α✝ : Type u_1} {l₂ l l₁ : List α✝} (ss : l₂ ⊆ l) (d : l₁.Disjoint l) :
l₁.Disjoint l₂h
hu#List.disjoint_of_disjoint_cons_left}(hj  hThttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Lemmas.htmlhtheorem List.disjoint_of_disjoint_cons_left {α✝ : Type u_1} {a : α✝} {l₁ l₂ : List α✝} :
(a :: l₁).Disjoint l₂ → l₁.Disjoint l₂h
hu$List.disjoint_of_disjoint_cons_right}(hj  hThttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Lemmas.htmlhtheorem List.disjoint_of_disjoint_cons_right {α✝ : Type u_1} {a : α✝} {l₁ l₂ : List α✝} :
l₁.Disjoint (a :: l₂) → l₁.Disjoint l₂h
huList.disjoint_nil_left}(hj  hThttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Lemmas.htmlhLtheorem List.disjoint_nil_left {α : Type u_1} (l : List α) :
[].Disjoint lh
huList.disjoint_nil_right}(hj  hThttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Lemmas.htmlhMtheorem List.disjoint_nil_right {α : Type u_1} (l : List α) :
l.Disjoint []h
huList.singleton_disjoint}(hj  hThttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Lemmas.htmlhntheorem List.singleton_disjoint {α✝ : Type u_1} {a : α✝} {l : List α✝} :
[a].Disjoint l ↔ ¬a ∈ lh
huList.disjoint_singleton}(hj  hThttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Lemmas.htmlhntheorem List.disjoint_singleton {α✝ : Type u_1} {l : List α✝} {a : α✝} :
l.Disjoint [a] ↔ ¬a ∈ lh
huList.disjoint_append_left}(hj  hThttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Lemmas.htmlhtheorem List.disjoint_append_left {α✝ : Type u_1} {l₁ l₂ l : List α✝} :
(l₁ ++ l₂).Disjoint l ↔ l₁.Disjoint l ∧ l₂.Disjoint lh
huList.disjoint_append_right}(hj  hThttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Lemmas.htmlhtheorem List.disjoint_append_right {α✝ : Type u_1} {l l₁ l₂ : List α✝} :
l.Disjoint (l₁ ++ l₂) ↔ l.Disjoint l₁ ∧ l.Disjoint l₂h
huList.disjoint_cons_left}(hj  hThttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Lemmas.htmlhtheorem List.disjoint_cons_left {α✝ : Type u_1} {a : α✝} {l₁ l₂ : List α✝} :
(a :: l₁).Disjoint l₂ ↔ ¬a ∈ l₂ ∧ l₁.Disjoint l₂h
huList.disjoint_cons_right}(hj  hThttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Lemmas.htmlhtheorem List.disjoint_cons_right {α✝ : Type u_1} {l₁ : List α✝} {a : α✝} {l₂ : List α✝} :
l₁.Disjoint (a :: l₂) ↔ ¬a ∈ l₁ ∧ l₁.Disjoint l₂h
hu*List.disjoint_of_disjoint_append_left_left}(hj  hThttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Lemmas.htmlhtheorem List.disjoint_of_disjoint_append_left_left {α✝ : Type u_1} {l₁ l₂ l : List α✝} (d : (l₁ ++ l₂).Disjoint l) :
l₁.Disjoint lh
hu+List.disjoint_of_disjoint_append_left_right}(hj  hThttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Lemmas.htmlhtheorem List.disjoint_of_disjoint_append_left_right {α✝ : Type u_1} {l₁ l₂ l : List α✝} (d : (l₁ ++ l₂).Disjoint l) :
l₂.Disjoint lh
hu+List.disjoint_of_disjoint_append_right_left}(hj
  hThttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Lemmas.htmlhtheorem List.disjoint_of_disjoint_append_right_left {α✝ : Type u_1} {l l₁ l₂ : List α✝} (d : l.Disjoint (l₁ ++ l₂)) :
l.Disjoint l₁h
hu,List.disjoint_of_disjoint_append_right_right}(hj  hThttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Lemmas.htmlhtheorem List.disjoint_of_disjoint_append_right_right {α✝ : Type u_1} {l l₁ l₂ : List α✝} (d : l.Disjoint (l₁ ++ l₂)) :
l.Disjoint l₂h
huList.union_def}(hj  hThttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Lemmas.htmlhstheorem List.union_def {α : Type u_1} [BEq α] (l₁ l₂ : List α) :
l₁ ∪ l₂ = foldr List.insert l₂ l₁h
huList.nil_union}(hj  hThttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Lemmas.htmlhLtheorem List.nil_union {α : Type u_1} [BEq α] (l : List α) :
[] ∪ l = lh
huList.cons_union}(hj  hThttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Lemmas.htmlhtheorem List.cons_union {α : Type u_1} [BEq α] (a : α) (l₁ l₂ : List α) :
a :: l₁ ∪ l₂ = List.insert a (l₁ ∪ l₂)h
huList.mem_union_iff}(hj  hThttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Lemmas.htmlhtheorem List.mem_union_iff {α : Type u_1} [BEq α] [LawfulBEq α] {x : α} {l₁ l₂ : List α} :
x ∈ l₁ ∪ l₂ ↔ x ∈ l₁ ∨ x ∈ l₂h
huList.inter_def}(hj"  hThttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Lemmas.htmlhtheorem List.inter_def {α : Type u_1} [BEq α] (l₁ l₂ : List α) :
l₁ ∩ l₂ = filter (fun (x : α) => elem x l₂) l₁h
huList.mem_inter_iff}(hj&  hThttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Lemmas.htmlhtheorem List.mem_inter_iff {α : Type u_1} [BEq α] [LawfulBEq α] {x : α} {l₁ l₂ : List α} :
x ∈ l₁ ∩ l₂ ↔ x ∈ l₁ ∧ x ∈ l₂h
huList.pair_mem_product}(hj*  hThttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Lemmas.htmlhtheorem List.pair_mem_product {α : Type u_1} {β : Type u_2} {xs : List α} {ys : List β} {x : α} {y : β} :
(x, y) ∈ xs.product ys ↔ x ∈ xs ∧ y ∈ ysh
BList.prod satisfies a specification of cartesian product on lists.uList.forIn_eq_bindList}(hj/  hThttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Lemmas.htmlhX  theorem List.forIn_eq_bindList {m : Type u_1 → Type u_2} {α : Type u_3} {β : Type u_1} [Monad m] [LawfulMonad m] (f : α → β → m (ForInStep β)) (l : List α) (init : β) :
forIn l init f = ForInStep.run <$> ForInStep.bindList f l (ForInStep.yield init)h
hu
List.diff_nil}(hj3  hThttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Lemmas.htmlhLtheorem List.diff_nil {α : Type u_1} [BEq α] (l : List α) :
l.diff [] = lh
huList.diff_cons}(hj7  hThttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Lemmas.htmlhtheorem List.diff_cons {α : Type u_1} [BEq α] [LawfulBEq α] (l₁ l₂ : List α) (a : α) :
l₁.diff (a :: l₂) = (l₁.erase a).diff l₂h
huList.diff_cons_right}(hj;  hThttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Lemmas.htmlhtheorem List.diff_cons_right {α : Type u_1} [BEq α] [LawfulBEq α] (l₁ l₂ : List α) (a : α) :
l₁.diff (a :: l₂) = (l₁.diff l₂).erase ah
huList.diff_erase}(hj?  hThttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Lemmas.htmlhtheorem List.diff_erase {α : Type u_1} [BEq α] [LawfulBEq α] (l₁ l₂ : List α) (a : α) :
(l₁.diff l₂).erase a = (l₁.erase a).diff l₂h
hu
List.nil_diff}(hjC  hThttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Lemmas.htmlh\theorem List.nil_diff {α : Type u_1} [BEq α] [LawfulBEq α] (l : List α) :
[].diff l = []h
huList.cons_diff}(hjG  hThttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Lemmas.htmlhtheorem List.cons_diff {α : Type u_1} [BEq α] [LawfulBEq α] (a : α) (l₁ l₂ : List α) :
(a :: l₁).diff l₂ = if a ∈ l₂ then l₁.diff (l₂.erase a) else a :: l₁.diff l₂h
huList.cons_diff_of_mem}(hjK  hThttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Lemmas.htmlhtheorem List.cons_diff_of_mem {α : Type u_1} [BEq α] [LawfulBEq α] {a : α} {l₂ : List α} (h : a ∈ l₂) (l₁ : List α) :
(a :: l₁).diff l₂ = l₁.diff (l₂.erase a)h
huList.cons_diff_of_not_mem}(hjO  hThttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Lemmas.htmlhtheorem List.cons_diff_of_not_mem {α : Type u_1} [BEq α] [LawfulBEq α] {a : α} {l₂ : List α} (h : ¬a ∈ l₂) (l₁ : List α) :
(a :: l₁).diff l₂ = a :: l₁.diff l₂h
huList.diff_eq_foldl}(hjS  hThttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Lemmas.htmlhtheorem List.diff_eq_foldl {α : Type u_1} [BEq α] [LawfulBEq α] (l₁ l₂ : List α) :
l₁.diff l₂ = foldl List.erase l₁ l₂h
huList.diff_append}(hjW  hThttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Lemmas.htmlhtheorem List.diff_append {α : Type u_1} [BEq α] [LawfulBEq α] (l₁ l₂ l₃ : List α) :
l₁.diff (l₂ ++ l₃) = (l₁.diff l₂).diff l₃h
huList.diff_sublist}(hj[  hThttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Lemmas.htmlhwtheorem List.diff_sublist {α : Type u_1} [BEq α] [LawfulBEq α] (l₁ l₂ : List α) :
(l₁.diff l₂).Sublist l₁h
huList.diff_subset}(hj_  hThttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Lemmas.htmlhptheorem List.diff_subset {α : Type u_1} [BEq α] [LawfulBEq α] (l₁ l₂ : List α) :
l₁.diff l₂ ⊆ l₁h
huList.mem_diff_of_mem}(hjc  hThttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Lemmas.htmlhtheorem List.mem_diff_of_mem {α : Type u_1} [BEq α] [LawfulBEq α] {a : α} {l₁ l₂ : List α} :
a ∈ l₁ → ¬a ∈ l₂ → a ∈ l₁.diff l₂h
huList.disjoint_take_drop}(hjg  hThttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Lemmas.htmlhtheorem List.disjoint_take_drop {α : Type u_1} {m n : Nat} {l : List α} :
l.Nodup → m ≤ n → (take m l).Disjoint (drop n l)h
huList.chain_cons}(hjk  hThttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Lemmas.htmlhtheorem List.chain_cons {α : Type u_1} {R : α → α → Prop} {a b : α} {l : List α} :
Chain R a (b :: l) ↔ R a b ∧ Chain R b lh
huList.rel_of_chain_cons}(hjo  hThttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Lemmas.htmlhtheorem List.rel_of_chain_cons {α : Type u_1} {R : α → α → Prop} {a b : α} {l : List α} (p : Chain R a (b :: l)) :
R a bh
huList.chain_of_chain_cons}(hjs  hThttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Lemmas.htmlhtheorem List.chain_of_chain_cons {α : Type u_1} {R : α → α → Prop} {a b : α} {l : List α} (p : Chain R a (b :: l)) :
Chain R b lh
huList.chain_succ_range'}(hjw  hThttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Lemmas.htmlhvtheorem List.chain_succ_range' (s n step : Nat) :
Chain (fun (a b : Nat) => b = a + step) s (range' (s + step) n step)h
huList.chain_lt_range'}(hj{  hThttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Lemmas.htmlhtheorem List.chain_lt_range' (s n : Nat) {step : Nat} (h : 0 < step) :
Chain (fun (x1 x2 : Nat) => x1 < x2) s (range' (s + step) n step)h
huList.foldrIdx_start}(hj  hThttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Lemmas.htmlhtheorem List.foldrIdx_start {α : Type u_1} {xs : List α} {α✝ : Sort u_2} {f : Nat → α → α✝ → α✝} {i : α✝} {s : Nat} :
foldrIdx f i xs s = foldrIdx (fun (i : Nat) => f (i + s)) i xsh
huList.foldrIdx_cons}(hj  hThttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Lemmas.htmlhtheorem List.foldrIdx_cons {α : Type u_1} {x : α} {xs : List α} {α✝ : Sort u_2} {f : Nat → α → α✝ → α✝} {i : α✝} {s : Nat} :
foldrIdx f i (x :: xs) s = f s x (foldrIdx f i xs (s + 1))h
huList.findIdxs_cons_aux}(hj  hThttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Lemmas.htmlhXF  theorem List.findIdxs_cons_aux {α : Type u_1} {xs : List α} {s : Nat} (p : α → Bool) :
foldrIdx (fun (i : Nat) (a : α) (is : List Nat) => if p a = true then (i + 1) :: is else is) [] xs s = map (fun (x : Nat) => x + 1)
    (foldrIdx (fun (i : Nat) (a : α) (is : List Nat) => if p a = true then i :: is else is) [] xs s)h
huList.findIdxs_cons}(hj  hThttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Lemmas.htmlhtheorem List.findIdxs_cons {α : Type u_1} {x : α} {xs : List α} {p : α → Bool} :
findIdxs p (x :: xs) = bif p x then 0 :: map (fun (x : Nat) => x + 1) (findIdxs p xs) else map (fun (x : Nat) => x + 1) (findIdxs p xs)h
huList.indexesOf_nil}(hj  hThttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Lemmas.htmlhRtheorem List.indexesOf_nil {α : Type u_1} {x : α} [BEq α] :
indexesOf x [] = []h
huList.indexesOf_cons}(hj  hThttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Lemmas.htmlhtheorem List.indexesOf_cons {α : Type u_1} {x : α} {xs : List α} {y : α} [BEq α] :
indexesOf y (x :: xs) = bif x == y then 0 :: map (fun (x : Nat) => x + 1) (indexesOf y xs) else map (fun (x : Nat) => x + 1) (indexesOf y xs)h
huList.eraseIdx_idxOf_eq_erase}(hj  hThttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Lemmas.htmlhytheorem List.eraseIdx_idxOf_eq_erase {α : Type u_1} [BEq α] (a : α) (l : List α) :
l.eraseIdx (idxOf a l) = l.erase ah
huList.idxOf_mem_indexesOf}(hj  hThttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Lemmas.htmlhtheorem List.idxOf_mem_indexesOf {α : Type u_1} {x : α} [BEq α] [LawfulBEq α] {xs : List α} (m : x ∈ xs) :
idxOf x xs ∈ indexesOf x xsh
huList.idxOf_eq_idxOf?}(hj  hThttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Lemmas.htmlhtheorem List.idxOf_eq_idxOf? {α : Type u_1} [BEq α] (a : α) (l : List α) :
idxOf a l = match idxOf? a l with
  | some i => i
  | none => l.lengthh
huList.insertP_loop}(hj  hThttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Lemmas.htmlhtheorem List.insertP_loop {α : Type u_1} {p : α → Bool} (a : α) (l r : List α) :
insertP.loop p a l r = r.reverseAux (insertP p a l)h
huList.insertP_nil}(hj  hThttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Lemmas.htmlhZtheorem List.insertP_nil {α : Type u_1} (p : α → Bool) (a : α) :
insertP p a [] = [a]h
huList.insertP_cons_pos}(hj  hThttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Lemmas.htmlhtheorem List.insertP_cons_pos {α : Type u_1} (p : α → Bool) (a b : α) (l : List α) (h : p b = true) :
insertP p a (b :: l) = a :: b :: lh
huList.insertP_cons_neg}(hj  hThttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Lemmas.htmlhtheorem List.insertP_cons_neg {α : Type u_1} (p : α → Bool) (a b : α) (l : List α) (h : ¬p b = true) :
insertP p a (b :: l) = b :: insertP p a lh
huList.length_insertP}(hj  hThttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Lemmas.htmlh|theorem List.length_insertP {α : Type u_1} (p : α → Bool) (a : α) (l : List α) :
(insertP p a l).length = l.length + 1h
huList.mem_insertP}(hj  hThttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Lemmas.htmlhgtheorem List.mem_insertP {α : Type u_1} (p : α → Bool) (a : α) (l : List α) :
a ∈ insertP p a lh
huList.dropPrefix?_nil}(hj  hThttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Lemmas.htmlh_theorem List.dropPrefix?_nil {α : Type u_1} [BEq α] {p : List α} :
p.dropPrefix? [] = some ph
huList.dropPrefix?_eq_some_iff}(hj  hThttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Lemmas.htmlhtheorem List.dropPrefix?_eq_some_iff {α : Type u_1} [BEq α] {l p s : List α} :
l.dropPrefix? p = some s ↔ ∃ (p' : List α), l = p' ++ s ∧ (p' == p) = trueh
huList.dropPrefix?_append_of_beq}(hj  hThttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Lemmas.htmlhtheorem List.dropPrefix?_append_of_beq {α : Type u_1} [BEq α] {l₁ l₂ : List α} (p : List α) (h : (l₁ == l₂) = true) :
(l₁ ++ p).dropPrefix? l₂ = some ph
huList.dropSuffix?_eq_some_iff}(hj  hThttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Lemmas.htmlhtheorem List.dropSuffix?_eq_some_iff {α : Type u_1} [BEq α] {l p s : List α} :
l.dropSuffix? s = some p ↔ ∃ (s' : List α), l = p ++ s' ∧ (s' == s) = trueh
huList.dropSuffix?_nil}(hj  hThttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Lemmas.htmlh_theorem List.dropSuffix?_nil {α : Type u_1} [BEq α] {s : List α} :
s.dropSuffix? [] = some sh
huList.dropInfix?_go_eq_some_iff}(hj  hThttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Lemmas.htmlhXV  theorem List.dropInfix?_go_eq_some_iff {α : Type u_1} [BEq α] {i l acc p s : List α} :
dropInfix?.go i l acc = some (p, s) ↔ ∃ (p' : List α), p = acc.reverse ++ p' ∧ (∃ (i' : List α), l = p' ++ i' ++ s ∧ (i' == i) = true) ∧ ∀ (p'' i'' s'' : List α), l = p'' ++ i'' ++ s'' → (i'' == i) = true → p''.length ≥ p'.length      h
huList.dropInfix?_eq_some_iff}(hj  hThttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Lemmas.htmlhX  theorem List.dropInfix?_eq_some_iff {α : Type u_1} [BEq α] {l i p s : List α} :
l.dropInfix? i = some (p, s) ↔ (∃ (i' : List α), l = p ++ i' ++ s ∧ (i' == i) = true) ∧ ∀ (p' i' s' : List α), l = p' ++ i' ++ s' → (i' == i) = true → p'.length ≥ p.lengthh
huList.dropInfix?_nil}(hj  hThttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Lemmas.htmlhctheorem List.dropInfix?_nil {α : Type u_1} [BEq α] {s : List α} :
s.dropInfix? [] = some ([], s)h
hu%List.isSome_isPrefixOf?_eq_isPrefixOf}(hj  hThttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Lemmas.htmlhtheorem List.isSome_isPrefixOf?_eq_isPrefixOf {α : Type u_1} [BEq α] (xs ys : List α) :
(xs.isPrefixOf? ys).isSome = xs.isPrefixOf ysh
hu&List.isPrefixOf?_eq_some_iff_append_eq}(hj  hThttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Lemmas.htmlhtheorem List.isPrefixOf?_eq_some_iff_append_eq {α : Type u_1} [BEq α] [LawfulBEq α] {xs ys zs : List α} :
xs.isPrefixOf? ys = some zs ↔ xs ++ zs = ysh
hu%List.append_eq_of_isPrefixOf?_eq_some}(hj  hThttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Lemmas.htmlhtheorem List.append_eq_of_isPrefixOf?_eq_some {α : Type u_1} [BEq α] [LawfulBEq α] {xs ys zs : List α} (h : xs.isPrefixOf? ys = some zs) :
xs ++ zs = ysh
hu%List.isSome_isSuffixOf?_eq_isSuffixOf}(hj  hThttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Lemmas.htmlhtheorem List.isSome_isSuffixOf?_eq_isSuffixOf {α : Type u_1} [BEq α] (xs ys : List α) :
(xs.isSuffixOf? ys).isSome = xs.isSuffixOf ysh
hu&List.isSuffixOf?_eq_some_iff_append_eq}(hj  hThttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Lemmas.htmlhtheorem List.isSuffixOf?_eq_some_iff_append_eq {α : Type u_1} [BEq α] [LawfulBEq α] {xs ys zs : List α} :
xs.isSuffixOf? ys = some zs ↔ zs ++ xs = ysh
hu%List.append_eq_of_isSuffixOf?_eq_some}(hj  hThttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Lemmas.htmlhtheorem List.append_eq_of_isSuffixOf?_eq_some {α : Type u_1} [BEq α] [LawfulBEq α] {xs ys zs : List α} (h : xs.isSuffixOf? ys = some zs) :
zs ++ xs = ysh
huList.Matcher}(hj  hUhttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Matcher.htmlhJstructure List.Matcher (α : Type u_1) extends Array.Matcher α :
Type u_1h
X4  Knuth-Morris-Pratt matcher type
This type is used to keep data for running the Knuth-Morris-Pratt (KMP) list matching algorithm. KMP is a linear time algorithm to locate all contiguous sublists of a list that match a given pattern. Generating the algorithm data is also linear in the length of the pattern but the data can be re-used to match the same pattern over multiple lists.
The KMP data for a pattern can be generated using Matcher.ofList. Then Matcher.find? and Matcher.findAll can be used to run the algorithm on an input list.
The pattern for the matcheru List.instStreamProdNat_batteries}(hj  hUhttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Matcher.htmlhQdef List.instStreamProdNat_batteries (α : Type u_1) :
Stream (List α × Nat) αh
+List stream that keeps count of items read.uList.findAllInfix}(hj  hUhttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Matcher.htmlhYdef List.findAllInfix {α : Type u_1} [BEq α] (l pattern : List α) :
Array (Nat × Nat)h
zReturns all the start and end positions of all infix sublists of of l that match pattern. The sublists may be overlapping.uList.findInfix?}(hj  hUhttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Matcher.htmlhXdef List.findInfix? {α : Type u_1} [BEq α] (l pattern : List α) :
Option (Nat × Nat)h
~Returns the start and end positions of the first infix sublist of l that matches pattern, or none if there is no such sublist.uList.containsInfix}(hj  hUhttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Matcher.htmlhLdef List.containsInfix {α : Type u_1} [BEq α] (l pattern : List α) :
Boolh
9Returns true iff pattern occurs as an infix sublist of l.uList.satisfiesM_foldlM}(hj  hUhttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Monadic.htmlhXH  theorem List.satisfiesM_foldlM {m : Type u_1 → Type u_2} {β : Type u_1} {α : Type u_3} {motive : β → Prop} {l : List α} {b : β} [Monad m] [LawfulMonad m] {f : β → α → m β} (h₀ : motive b) (h₁ : ∀ (b : β), motive b → ∀ (a : α), a ∈ l → SatisfiesM motive (f b a)) :
SatisfiesM motive (foldlM f b l)h
huList.satisfiesM_foldrM}(hj  hUhttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Monadic.htmlhXH  theorem List.satisfiesM_foldrM {m : Type u_1 → Type u_2} {α : Type u_3} {β : Type u_1} {motive : β → Prop} {l : List α} {b : β} [Monad m] [LawfulMonad m] {f : α → β → m β} (h₀ : motive b) (h₁ : ∀ (a : α), a ∈ l → ∀ (b : β), motive b → SatisfiesM motive (f a b)) :
SatisfiesM motive (foldrM f b l)h
huList.pairwise_iff_get}(hj  hVhttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Pairwise.htmlhtheorem List.pairwise_iff_get {α✝ : Type u_1} {R : α✝ → α✝ → Prop} {l : List α✝} :
Pairwise R l ↔ ∀ (i j : Fin l.length), i < j → R (l.get i) (l.get j)h
huList.pwFilter_nil}(hj  hVhttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Pairwise.htmlhqtheorem List.pwFilter_nil {α✝ : Type u_1} {R : α✝ → α✝ → Prop} [DecidableRel R] :
pwFilter R [] = []h
huList.pwFilter_cons_of_pos}(hj  hVhttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Pairwise.htmlhtheorem List.pwFilter_cons_of_pos {α : Type u_1} {R : α → α → Prop} [DecidableRel R] {a : α} {l : List α} (h : ∀ (b : α), b ∈ pwFilter R l → R a b) :
pwFilter R (a :: l) = a :: pwFilter R lh
huList.pwFilter_cons_of_neg}(hj   hVhttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Pairwise.htmlhtheorem List.pwFilter_cons_of_neg {α : Type u_1} {R : α → α → Prop} [DecidableRel R] {a : α} {l : List α} (h : ¬∀ (b : α), b ∈ pwFilter R l → R a b) :
pwFilter R (a :: l) = pwFilter R lh
huList.pwFilter_map}(hj$  hVhttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Pairwise.htmlhtheorem List.pwFilter_map {α : Type u_1} {R : α → α → Prop} {β : Type u_2} [DecidableRel R] (f : β → α) (l : List β) :
pwFilter R (map f l) = map f (pwFilter (fun (x y : β) => R (f x) (f y)) l)h
huList.pwFilter_sublist}(hj(  hVhttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Pairwise.htmlhtheorem List.pwFilter_sublist {α : Type u_1} {R : α → α → Prop} [DecidableRel R] (l : List α) :
(pwFilter R l).Sublist lh
huList.pwFilter_subset}(hj,  hVhttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Pairwise.htmlhytheorem List.pwFilter_subset {α : Type u_1} {R : α → α → Prop} [DecidableRel R] (l : List α) :
pwFilter R l ⊆ lh
huList.pairwise_pwFilter}(hj0  hVhttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Pairwise.htmlhtheorem List.pairwise_pwFilter {α : Type u_1} {R : α → α → Prop} [DecidableRel R] (l : List α) :
Pairwise R (pwFilter R l)h
huList.pwFilter_eq_self}(hj4  hVhttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Pairwise.htmlhtheorem List.pwFilter_eq_self {α : Type u_1} {R : α → α → Prop} [DecidableRel R] {l : List α} :
pwFilter R l = l ↔ Pairwise R lh
huList.pwFilter_idem}(hj8  hVhttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Pairwise.htmlhtheorem List.pwFilter_idem {α : Type u_1} {R : α → α → Prop} {l : List α} [DecidableRel R] :
pwFilter R (pwFilter R l) = pwFilter R lh
huList.forall_mem_pwFilter}(hj<  hVhttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Pairwise.htmlhtheorem List.forall_mem_pwFilter {α : Type u_1} {R : α → α → Prop} [DecidableRel R] (neg_trans : ∀ {x y z : α}, R x z → R x y ∨ R y z) (a : α) (l : List α) :
(∀ (b : α), b ∈ pwFilter R l → R a b) ↔ ∀ (b : α), b ∈ l → R a bh
huList.nil_subperm}(hj@  hRhttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Perm.htmlhEtheorem List.nil_subperm {α : Type u_1} {l : List α} :
[].Subperm lh
huList.subperm_nil}(hjD  hRhttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Perm.htmlhVtheorem List.subperm_nil {α✝ : Type u_1} {l : List α✝} :
l.Subperm [] ↔ l = []h
huList.singleton_subperm_iff}(hjH  hRhttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Perm.htmlhetheorem List.singleton_subperm_iff {α : Type u_1} {l : List α} {a : α} :
[a].Subperm l ↔ a ∈ lh
huList.subperm_cons}(hjL  hRhttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Perm.htmlhtheorem List.subperm_cons {α : Type u_1} (a : α) {l₁ l₂ : List α} :
(a :: l₁).Subperm (a :: l₂) ↔ l₁.Subperm l₂h
hu#List.cons_subperm_of_not_mem_of_mem}(hjP  hRhttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Perm.htmlhtheorem List.cons_subperm_of_not_mem_of_mem {α : Type u_1} {a : α} {l₁ l₂ : List α} (h₁ : ¬a ∈ l₁) (h₂ : a ∈ l₂) (s : l₁.Subperm l₂) :
(a :: l₁).Subperm l₂h
#Weaker version of Subperm.cons_leftuList.subperm_append_left}(hjU  hRhttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Perm.htmlhtheorem List.subperm_append_left {α : Type u_1} {l₁ l₂ : List α} (l : List α) :
(l ++ l₁).Subperm (l ++ l₂) ↔ l₁.Subperm l₂h
huList.subperm_append_right}(hjY  hRhttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Perm.htmlhtheorem List.subperm_append_right {α : Type u_1} {l₁ l₂ : List α} (l : List α) :
(l₁ ++ l).Subperm (l₂ ++ l) ↔ l₁.Subperm l₂h
huList.subperm_of_subset}(hj]  hRhttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Perm.htmlhtheorem List.subperm_of_subset {α✝ : Type u_1} {l₁ l₂ : List α✝} (d : l₁.Nodup) (H : l₁ ⊆ l₂) :
l₁.Subperm l₂h
huList.perm_ext_iff_of_nodup}(hja  hRhttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Perm.htmlhtheorem List.perm_ext_iff_of_nodup {α : Type u_1} {l₁ l₂ : List α} (d₁ : l₁.Nodup) (d₂ : l₂.Nodup) :
l₁.Perm l₂ ↔ ∀ (a : α), a ∈ l₁ ↔ a ∈ l₂h
huList.subperm_cons_erase}(hje  hRhttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Perm.htmlhttheorem List.subperm_cons_erase {α : Type u_1} [DecidableEq α] (a : α) (l : List α) :
l.Subperm (a :: l.erase a)h
huList.erase_subperm}(hji  hRhttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Perm.htmlhjtheorem List.erase_subperm {α : Type u_1} [DecidableEq α] (a : α) (l : List α) :
(l.erase a).Subperm lh
hu"List.erase_cons_subperm_cons_erase}(hjm  hRhttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Perm.htmlhtheorem List.erase_cons_subperm_cons_erase {α : Type u_1} [DecidableEq α] (a b : α) (l : List α) :
((a :: l).erase b).Subperm (a :: l.erase b)h
huList.subperm_cons_diff}(hjq  hRhttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Perm.htmlhtheorem List.subperm_cons_diff {α : Type u_1} [DecidableEq α] {a : α} {l₁ l₂ : List α} :
((a :: l₁).diff l₂).Subperm (a :: l₁.diff l₂)h
huList.subset_cons_diff}(hju  hRhttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Perm.htmlhtheorem List.subset_cons_diff {α : Type u_1} [DecidableEq α] {a : α} {l₁ l₂ : List α} :
(a :: l₁).diff l₂ ⊆ a :: l₁.diff l₂h
hu)List.subperm_append_diff_self_of_count_le}(hjy  hRhttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Perm.htmlhtheorem List.subperm_append_diff_self_of_count_le {α : Type u_1} [DecidableEq α] {l₁ l₂ : List α} (h : ∀ (x : α), x ∈ l₁ → count x l₁ ≤ count x l₂) :
(l₁ ++ l₂.diff l₁).Perm l₂h
8The list version of add_tsub_cancel_of_le for multisets.uList.subperm_ext_iff}(hj~  hRhttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Perm.htmlhtheorem List.subperm_ext_iff {α : Type u_1} [DecidableEq α] {l₁ l₂ : List α} :
l₁.Subperm l₂ ↔ ∀ (x : α), x ∈ l₁ → count x l₁ ≤ count x l₂h
*The list version of Multiset.le_iff_count.uList.isSubperm_iff}(hj  hRhttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Perm.htmlhtheorem List.isSubperm_iff {α : Type u_1} [DecidableEq α] {l₁ l₂ : List α} :
l₁.isSubperm l₂ = true ↔ l₁.Subperm l₂h
huList.decidableSubperm}(hj  hRhttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Perm.htmlhuinstance List.decidableSubperm {α : Type u_1} [DecidableEq α] :
DecidableRel fun (x1 x2 : List α) => x1.Subperm x2h
huList.perm_insertP}(hj  hRhttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/List/Perm.htmlhrtheorem List.perm_insertP {α : Type u_1} (p : α → Bool) (a : α) (l : List α) :
(insertP p a l).Perm (a :: l)h
huList.toRBMap}(hj  hThttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/RBMap/Basic.htmlhabbrev List.toRBMap {α : Type u_1} {β : Type u_2} (l : List (α × β)) (cmp : α → α → Ordering) :
Batteries.RBMap α β cmph
OO(n log n). Build a tree from an unsorted list by inserting them one at a time.uList.stream_drop_eq_drop}(hj  hOhttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/Stream.htmlhetheorem List.stream_drop_eq_drop {α : Type u_1} {n : Nat} (l : List α) :
Stream.drop l n = drop n lh
huList.stream_take_eq_take_drop}(hj  hOhttps://leanprover-community.github.io/mathlib4_docs/Batteries/Data/Stream.htmlhvtheorem List.stream_take_eq_take_drop {α : Type u_1} {n : Nat} (l : List α) :
Stream.take l n = (take n l, drop n l)h
huList.waitAll}(hj  hRhttps://leanprover-community.github.io/mathlib4_docs/Batteries/Lean/System/IO.htmlhJdef List.waitAll {α : Type u_1} (tasks : List (Task α)) :
Task (List α)h
ZGiven a list of tasks, create the task returning the list of results, by waiting for each.uList.attachWith_toArray}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/Array/Attach.htmlhtheorem List.attachWith_toArray {α : Type u_1} {l : List α} {P : α → Prop} {H : ∀ (x : α), x ∈ l.toArray → P x} :
l.toArray.attachWith P H = (l.attachWith P ⋯).toArrayh
huList.attach_toArray}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/Array/Attach.htmlhtheorem List.attach_toArray {α : Type u_1} {l : List α} :
l.toArray.attach = (l.attachWith (fun (x : α) => x ∈ l.toArray) ⋯).toArrayh
huList.pmap_toArray}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/Array/Attach.htmlhtheorem List.pmap_toArray {α : Type u_1} {β : Type u_2} {l : List α} {P : α → Prop} {f : (a : α) → P a → β} {H : ∀ (a : α), a ∈ l.toArray → P a} :
Array.pmap f l.toArray H = (pmap f l ⋯).toArrayh
huList.attachWith_mem_toArray}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/Array/Attach.htmlhtheorem List.attachWith_mem_toArray {α : Type u_1} {l : List α} :
l.attachWith (fun (x : α) => x ∈ l.toArray) ⋯ = map
    (fun (x : { x : α // x ∈ l }) =>
      match x with
      | ⟨x, h⟩ => ⟨x, ⋯⟩)
    l.attachh
huList.unattach_toArray}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/Array/Attach.htmlhtheorem List.unattach_toArray {α : Type u_1} {p : α → Prop} {xs : List { x : α // p x }} :
xs.toArray.unattach = xs.unattach.toArrayh
huList.toArray_toList}(hj  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/Array/Basic.htmlhSabbrev List.toArray_toList {α : Type u_1} {xs : Array α} :
xs.toList.toArray = xsh
huList.toList_toArray}(hj  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/Array/Basic.htmlhQtheorem List.toList_toArray {α : Type u} {as : List α} :
as.toArray.toList = ash
huList.size_toArray}(hj  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/Array/Basic.htmlhTtheorem List.size_toArray {α : Type u} {as : List α} :
as.toArray.size = as.lengthh
huList.getElem_toArray}(hj  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/Array/Basic.htmlhutheorem List.getElem_toArray {α : Type u} {xs : List α} {i : Nat} (h : i < xs.toArray.size) :
xs.toArray[i] = xs[i]h
huList.getElem?_toArray}(hj  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/Array/Basic.htmlh^theorem List.getElem?_toArray {α : Type u} {xs : List α} {i : Nat} :
xs.toArray[i]? = xs[i]?h
huList.getElem!_toArray}(hj  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/Array/Basic.htmlhmtheorem List.getElem!_toArray {α : Type u} [Inhabited α] {xs : List α} {i : Nat} :
xs.toArray[i]! = xs[i]!h
huList.toArray_eq_toArray_eq}(hj  hRhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/Array/BasicAux.htmlhltheorem List.toArray_eq_toArray_eq {α : Type u_1} {as bs : List α} :
(as.toArray = bs.toArray) = (as = bs)h
huList.countP_toArray}(hj  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/Array/Count.htmlhstheorem List.countP_toArray {α : Type u_1} {p : α → Bool} {l : List α} :
Array.countP p l.toArray = countP p lh
huList.count_toArray}(hj  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/Array/Count.htmlhptheorem List.count_toArray {α : Type u_1} [BEq α] {l : List α} {a : α} :
Array.count a l.toArray = count a lh
huList.isEqv_toArray}(hj  hUhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/Array/DecidableEq.htmlhtheorem List.isEqv_toArray {α : Type u_1} {r : α → α → Bool} [BEq α] (as bs : List α) :
as.toArray.isEqv bs.toArray r = as.isEqv bs rh
huList.beq_toArray}(hj  hUhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/Array/DecidableEq.htmlhmtheorem List.beq_toArray {α : Type u_1} [BEq α] (as bs : List α) :
(as.toArray == bs.toArray) = (as == bs)h
huList.anyM_toArray'}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/Array/Lemmas.htmlhtheorem List.anyM_toArray' {m : Type → Type u_1} {α : Type u_2} [Monad m] [LawfulMonad m] {p : α → m Bool} {l : List α} {stop : Nat} (h : stop = l.toArray.size) :
Array.anyM p l.toArray 0 stop = anyM p lh
6Variant of anyM_toArray with a side condition on stop.uList.any_toArray'}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/Array/Lemmas.htmlhtheorem List.any_toArray' {α : Type u_1} {p : α → Bool} {l : List α} {stop : Nat} (h : stop = l.toArray.size) :
l.toArray.any p 0 stop = l.any ph
5Variant of any_toArray with a side condition on stop.uList.allM_toArray'}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/Array/Lemmas.htmlhtheorem List.allM_toArray' {m : Type → Type u_1} {α : Type u_2} [Monad m] [LawfulMonad m] {p : α → m Bool} {l : List α} {stop : Nat} (h : stop = l.toArray.size) :
Array.allM p l.toArray 0 stop = allM p lh
6Variant of allM_toArray with a side condition on stop.uList.all_toArray'}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/Array/Lemmas.htmlhtheorem List.all_toArray' {α : Type u_1} {p : α → Bool} {l : List α} {stop : Nat} (h : stop = l.toArray.size) :
l.toArray.all p 0 stop = l.all ph
5Variant of all_toArray with a side condition on stop.uList.anyM_toArray}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/Array/Lemmas.htmlhtheorem List.anyM_toArray {m : Type → Type u_1} {α : Type u_2} [Monad m] [LawfulMonad m] {p : α → m Bool} {l : List α} :
Array.anyM p l.toArray = anyM p lh
huList.any_toArray}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/Array/Lemmas.htmlhdtheorem List.any_toArray {α : Type u_1} {p : α → Bool} {l : List α} :
l.toArray.any p = l.any ph
huList.allM_toArray}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/Array/Lemmas.htmlhtheorem List.allM_toArray {m : Type → Type u_1} {α : Type u_2} [Monad m] [LawfulMonad m] {p : α → m Bool} {l : List α} :
Array.allM p l.toArray = allM p lh
huList.all_toArray}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/Array/Lemmas.htmlhdtheorem List.all_toArray {α : Type u_1} {p : α → Bool} {l : List α} :
l.toArray.all p = l.all ph
huList.contains_toArray}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/Array/Lemmas.htmlhstheorem List.contains_toArray {α : Type u_1} [BEq α] {l : List α} {a : α} :
l.toArray.contains a = l.contains ah
huList.elem_toArray}(hj	  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/Array/Lemmas.htmlhmtheorem List.elem_toArray {α : Type u_1} [BEq α] {l : List α} {a : α} :
Array.elem a l.toArray = elem a lh
huList.map_toArray}(hj
  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/Array/Lemmas.htmlhtheorem List.map_toArray {α : Type u_1} {β : Type u_2} {f : α → β} {l : List α} :
Array.map f l.toArray = (map f l).toArrayh
huList.filter_toArray'}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/Array/Lemmas.htmlhtheorem List.filter_toArray' {α : Type u_1} {p : α → Bool} {l : List α} {stop : Nat} (h : stop = l.length) :
Array.filter p l.toArray 0 stop = (filter p l).toArrayh
huList.filter_toArray}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/Array/Lemmas.htmlh}theorem List.filter_toArray {α : Type u_1} {p : α → Bool} {l : List α} :
Array.filter p l.toArray = (filter p l).toArrayh
huList.filterMap_toArray'}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/Array/Lemmas.htmlhtheorem List.filterMap_toArray' {α : Type u_1} {β : Type u_2} {f : α → Option β} {l : List α} {stop : Nat} (h : stop = l.length) :
Array.filterMap f l.toArray 0 stop = (filterMap f l).toArrayh
huList.filterMap_toArray}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/Array/Lemmas.htmlhtheorem List.filterMap_toArray {α : Type u_1} {β : Type u_2} {f : α → Option β} {l : List α} :
Array.filterMap f l.toArray = (filterMap f l).toArrayh
huList.reverse_toArray}(hj!  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/Array/Lemmas.htmlhbtheorem List.reverse_toArray {α : Type u_1} {l : List α} :
l.toArray.reverse = l.reverse.toArrayh
huList.extract_toArray}(hj%  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/Array/Lemmas.htmlhtheorem List.extract_toArray {α : Type u_1} {l : List α} {start stop : Nat} :
l.toArray.extract start stop = (l.extract start stop).toArrayh
huList.toArray_drop}(hj)  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/Array/Lemmas.htmlhltheorem List.toArray_drop {α : Type u_1} {l : List α} {k : Nat} :
(drop k l).toArray = l.toArray.extract kh
huList.foldrM_push_eq_append}(hj-  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/Array/Lemmas.htmlhX3  theorem List.foldrM_push_eq_append {m : Type u_1 → Type u_2} {α : Type u_3} {β : Type u_1} [Monad m] [LawfulMonad m] {l : List α} {f : α → m β} {xs : Array β} :
foldrM (fun (x : α) (xs : Array β) => xs.push <$> f x) xs l = do
  let __do_lift ← mapM f l.reverse
  pure (xs ++ __do_lift.toArray)h
huList.foldlM_push_eq_append}(hj1  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/Array/Lemmas.htmlhX+  theorem List.foldlM_push_eq_append {m : Type u_1 → Type u_2} {α : Type u_3} {β : Type u_1} [Monad m] [LawfulMonad m] {l : List α} {f : α → m β} {xs : Array β} :
foldlM (fun (xs : Array β) (x : α) => xs.push <$> f x) xs l = do
  let __do_lift ← mapM f l
  pure (xs ++ __do_lift.toArray)h
huList.foldr_push_eq_append}(hj5  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/Array/Lemmas.htmlhtheorem List.foldr_push_eq_append {α : Type u_1} {β : Type u_2} {l : List α} {f : α → β} {xs : Array β} :
foldr (fun (x : α) (xs : Array β) => xs.push (f x)) xs l = xs ++ (map f l.reverse).toArrayh
huList.foldr_push_eq_append'}(hj9  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/Array/Lemmas.htmlhtheorem List.foldr_push_eq_append' {α : Type u_1} {l : List α} {xs : Array α} :
foldr (fun (x : α) (xs : Array α) => xs.push x) xs l = xs ++ l.reverse.toArrayh
;Variant of List.foldr_push_eq_append specialized to f = id.uList.foldl_push_eq_append}(hj>  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/Array/Lemmas.htmlhtheorem List.foldl_push_eq_append {α : Type u_1} {β : Type u_2} {l : List α} {f : α → β} {xs : Array β} :
foldl (fun (xs : Array β) (x : α) => xs.push (f x)) xs l = xs ++ (map f l).toArrayh
huList.foldl_push_eq_append'}(hjB  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/Array/Lemmas.htmlhtheorem List.foldl_push_eq_append' {α : Type u_1} {l : List α} {xs : Array α} :
foldl (fun (xs : Array α) (x : α) => xs.push x) xs l = xs ++ l.toArrayh
;Variant of List.foldl_push_eq_append specialized to f = id.uList.foldl_push}(hjG  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/Array/Lemmas.htmlhotheorem List.foldl_push {α : Type u_1} {l : List α} {as : Array α} :
foldl Array.push as l = as ++ l.toArrayh
huList.foldr_push}(hjK  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/Array/Lemmas.htmlhtheorem List.foldr_push {α : Type u_1} {l : List α} {as : Array α} :
foldr (fun (a : α) (bs : Array α) => bs.push a) as l = as ++ l.reverse.toArrayh
huList.toArray_range'}(hjO  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/Array/Lemmas.htmlhutheorem List.toArray_range' {start size step : Nat} :
(range' start size step).toArray = Array.range' start size steph
huList.toArray_range}(hjS  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/Array/Lemmas.htmlhHtheorem List.toArray_range {n : Nat} :
(range n).toArray = Array.range nh
huList.toListRev_toArray}(hjW  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/Array/Lemmas.htmlh^theorem List.toListRev_toArray {α : Type u_1} {l : List α} :
l.toArray.toListRev = l.reverseh
huList.take_toArray}(hj[  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/Array/Lemmas.htmlhitheorem List.take_toArray {α : Type u_1} {l : List α} {i : Nat} :
l.toArray.take i = (take i l).toArrayh
huList.mapM_toArray}(hj_  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/Array/Lemmas.htmlhtheorem List.mapM_toArray {m : Type u_1 → Type u_2} {α : Type u_3} {β : Type u_1} [Monad m] [LawfulMonad m] {f : α → m β} {l : List α} :
Array.mapM f l.toArray = toArray <$> mapM f lh
huList.uset_toArray}(hjc  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/Array/Lemmas.htmlhtheorem List.uset_toArray {α : Type u_1} {l : List α} {i : USize} {a : α} {h : i.toNat < l.toArray.size} :
l.toArray.uset i a h = (l.set i.toNat a).toArrayh
huList.modify_toArray}(hjg  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/Array/Lemmas.htmlhtheorem List.modify_toArray {α : Type u_1} {f : α → α} {l : List α} {i : Nat} :
l.toArray.modify i f = (l.modify i f).toArrayh
huList.flatten_toArray}(hjk  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/Array/Lemmas.htmlh}theorem List.flatten_toArray {α : Type u_1} {L : List (List α)} :
(Array.map toArray L.toArray).flatten = L.flatten.toArrayh
huList.unzip_toArray}(hjo  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/Array/Lemmas.htmlhtheorem List.unzip_toArray {α : Type u_1} {β : Type u_2} {as : List (α × β)} :
as.toArray.unzip = Prod.map toArray toArray as.unziph
huList.firstM_toArray}(hjs  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/Array/Lemmas.htmlhtheorem List.firstM_toArray {m : Type u_1 → Type u_2} {α : Type u_3} {β : Type u_1} [Alternative m] {as : List α} {f : α → m β} :
Array.firstM f as.toArray = firstM f ash
huList.lt_toArray}(hjw  hThttps://leanprover-community.github.io/mathlib4_docs/Init/Data/Array/Lex/Lemmas.htmlhstheorem List.lt_toArray {α : Type u_1} [LT α] {l₁ l₂ : List α} :
l₁.toArray < l₂.toArray ↔ l₁ < l₂h
huList.le_toArray}(hj{  hThttps://leanprover-community.github.io/mathlib4_docs/Init/Data/Array/Lex/Lemmas.htmlhwtheorem List.le_toArray {α : Type u_1} [LT α] {l₁ l₂ : List α} :
l₁.toArray ≤ l₂.toArray ↔ l₁ ≤ l₂h
huList.lex_toArray}(hj  hThttps://leanprover-community.github.io/mathlib4_docs/Init/Data/Array/Lex/Lemmas.htmlhtheorem List.lex_toArray {α : Type u_1} [BEq α] {lt : α → α → Bool} {l₁ l₂ : List α} :
l₁.toArray.lex l₂.toArray lt = l₁.lex l₂ lth
huList.mapFinIdx_toArray}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/Array/MapIdx.htmlhtheorem List.mapFinIdx_toArray {α : Type u_1} {β : Type u_2} {l : List α} {f : (i : Nat) → α → i < l.length → β} :
l.toArray.mapFinIdx f = (l.mapFinIdx f).toArrayh
huList.mapIdx_toArray}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/Array/MapIdx.htmlhtheorem List.mapIdx_toArray {α : Type u_1} {β : Type u_2} {f : Nat → α → β} {l : List α} :
Array.mapIdx f l.toArray = (mapIdx f l).toArrayh
huList.mapFinIdxM_toArray}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/Array/MapIdx.htmlhtheorem List.mapFinIdxM_toArray {m : Type u_1 → Type u_2} {α : Type u_3} {β : Type u_1} [Monad m] [LawfulMonad m] {l : List α} {f : (i : Nat) → α → i < l.length → m β} :
l.toArray.mapFinIdxM f = toArray <$> l.mapFinIdxM fh
huList.mapIdxM_toArray}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/Array/MapIdx.htmlhtheorem List.mapIdxM_toArray {m : Type u_1 → Type u_2} {α : Type u_3} {β : Type u_1} [Monad m] [LawfulMonad m] {l : List α} {f : Nat → α → m β} :
Array.mapIdxM f l.toArray = toArray <$> mapIdxM f lh
huList.filterM_toArray}(hj  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/Array/Monadic.htmlhtheorem List.filterM_toArray {m : Type → Type u_1} {α : Type} [Monad m] [LawfulMonad m] {l : List α} {p : α → m Bool} :
Array.filterM p l.toArray = toArray <$> filterM p lh
huList.filterM_toArray'}(hj  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/Array/Monadic.htmlhtheorem List.filterM_toArray' {m : Type → Type u_1} {α : Type} {stop : Nat} [Monad m] [LawfulMonad m] {l : List α} {p : α → m Bool} (w : stop = l.length) :
Array.filterM p l.toArray 0 stop = toArray <$> filterM p lh
GVariant of filterM_toArray with a side condition for the stop position.uList.filterRevM_toArray}(hj  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/Array/Monadic.htmlhtheorem List.filterRevM_toArray {m : Type → Type u_1} {α : Type} [Monad m] [LawfulMonad m] {l : List α} {p : α → m Bool} :
Array.filterRevM p l.toArray = toArray <$> filterRevM p lh
huList.filterRevM_toArray'}(hj  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/Array/Monadic.htmlhtheorem List.filterRevM_toArray' {m : Type → Type u_1} {α : Type} {start : Nat} [Monad m] [LawfulMonad m] {l : List α} {p : α → m Bool} (w : start = l.length) :
Array.filterRevM p l.toArray start = toArray <$> filterRevM p lh
KVariant of filterRevM_toArray with a side condition for the start position.uList.filterMapM_toArray}(hj  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/Array/Monadic.htmlhtheorem List.filterMapM_toArray {m : Type u_1 → Type u_2} {α : Type u_3} {β : Type u_1} [Monad m] [LawfulMonad m] {l : List α} {f : α → m (Option β)} :
Array.filterMapM f l.toArray = toArray <$> filterMapM f lh
huList.filterMapM_toArray'}(hj  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/Array/Monadic.htmlhX  theorem List.filterMapM_toArray' {m : Type u_1 → Type u_2} {α : Type u_3} {β : Type u_1} {stop : Nat} [Monad m] [LawfulMonad m] {l : List α} {f : α → m (Option β)} (w : stop = l.length) :
Array.filterMapM f l.toArray 0 stop = toArray <$> filterMapM f lh
JVariant of filterMapM_toArray with a side condition for the stop position.uList.flatMapM_toArray}(hj  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/Array/Monadic.htmlhtheorem List.flatMapM_toArray {m : Type u_1 → Type u_2} {α : Type u_3} {β : Type u_1} [Monad m] [LawfulMonad m] {l : List α} {f : α → m (Array β)} :
Array.flatMapM f l.toArray = toArray <$> flatMapM (fun (a : α) => Array.toList <$> f a) lh
huList.toArray_ofFn}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/Array/OfFn.htmlhhtheorem List.toArray_ofFn {n : Nat} {α : Type u_1} {f : Fin n → α} :
(ofFn f).toArray = Array.ofFn fh
huList.perm_iff_toArray_perm}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/Array/Perm.htmlhptheorem List.perm_iff_toArray_perm {α : Type u_1} {as bs : List α} :
as.Perm bs ↔ as.toArray.Perm bs.toArrayh
huList.exists_of_set}(hj  hRhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/Array/TakeDrop.htmlhtheorem List.exists_of_set {α : Type u_1} {i : Nat} {a' : α} {l : List α} (h : i < l.length) :
∃ (l₁ : List α), ∃ (l₂ : List α), l = l₁ ++ l[i] :: l₂ ∧ l₁.length = i ∧ l.set i a' = l₁ ++ a' :: l₂h
huList.toByteArray}(hj  hShttps://leanprover-community.github.io/mathlib4_docs/Init/Data/ByteArray/Basic.htmlh2def List.toByteArray (bs : List UInt8) :
ByteArrayh
*Converts a list of bytes into a ByteArray.uList.toFloatArray}(hj  hThttps://leanprover-community.github.io/mathlib4_docs/Init/Data/FloatArray/Basic.htmlh4def List.toFloatArray (ds : List Float) :
FloatArrayh
,Converts a list of floats into a FloatArray.uList.format}(hj  hThttps://leanprover-community.github.io/mathlib4_docs/Init/Data/Format/Instances.htmlhJdef List.format {α : Type u_1} [Std.ToFormat α] :
List α → Std.Formath
hu
List.finRange}(hj  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/FinRange.htmlh*def List.finRange (n : Nat) :
List (Fin n)h
>Lists all elements of Fin n in order, starting at 0.
Examples:uList.length_finRange}(hj  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/FinRange.htmlh@theorem List.length_finRange {n : Nat} :
(finRange n).length = nh
huList.getElem_finRange}(hj  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/FinRange.htmlhstheorem List.getElem_finRange {n i : Nat} (h : i < (finRange n).length) :
(finRange n)[i] = Fin.cast ⋯ ⟨i, h⟩h
huList.finRange_zero}(hj  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/FinRange.htmlh,theorem List.finRange_zero :
finRange 0 = []h
huList.finRange_succ}(hj  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/FinRange.htmlhXtheorem List.finRange_succ {n : Nat} :
finRange (n + 1) = 0 :: map Fin.succ (finRange n)h
huList.finRange_succ_last}(hj  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/FinRange.htmlhltheorem List.finRange_succ_last {n : Nat} :
finRange (n + 1) = map Fin.castSucc (finRange n) ++ [Fin.last n]h
huList.finRange_reverse}(hj  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/FinRange.htmlhYtheorem List.finRange_reverse {n : Nat} :
(finRange n).reverse = map Fin.rev (finRange n)h
huList.ofFnM_succ}(hj  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/FinRange.htmlhtheorem List.ofFnM_succ {m : Type u_1 → Type u_2} {α : Type u_1} {n : Nat} [Monad m] [LawfulMonad m] {f : Fin (n + 1) → m α} :
ofFnM f = do
  let a ← f 0
  let as ← ofFnM fun (i : Fin n) => f i.succ
  pure (a :: as)h
hu	List.get?}(hj  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/BasicAux.htmlhBdef List.get? {α : Type u_1} (as : List α) (i : Nat) :
Option αh
Returns the i-th element in the list (zero-based).
If the index is out of bounds (i ≥ as.length), this function returns none. Also see get, getD and get!.u
List.get?_nil}(hj  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/BasicAux.htmlhBtheorem List.get?_nil {α : Type u_1} {n : Nat} :
[].get? n = noneh
huList.get?_cons_zero}(hj  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/BasicAux.htmlh]theorem List.get?_cons_zero {α : Type u_1} {a : α} {l : List α} :
(a :: l).get? 0 = some ah
huList.get?_cons_succ}(hj  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/BasicAux.htmlhotheorem List.get?_cons_succ {α : Type u_1} {a : α} {l : List α} {n : Nat} :
(a :: l).get? (n + 1) = l.get? nh
hu
List.ext_get?}(hj  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/BasicAux.htmlhxtheorem List.ext_get? {α : Type u_1} {l₁ l₂ : List α} :
(∀ (n : Nat), l₁.get? n = l₂.get? n) → l₁ = l₂h
hu	List.get!}(hj  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/BasicAux.htmlhJdef List.get! {α : Type u_1} [Inhabited α] (as : List α) (i : Nat) :
αh
Returns the i-th element in the list (zero-based).
If the index is out of bounds (i ≥ as.length), this function panics when executed, and returns default. See get? and getD for safer alternatives.u
List.get!_nil}(hj  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/BasicAux.htmlhTtheorem List.get!_nil {α : Type u_1} [Inhabited α] (n : Nat) :
[].get! n = defaulth
huList.get!_cons_succ}(hj  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/BasicAux.htmlh~theorem List.get!_cons_succ {α : Type u_1} [Inhabited α] (l : List α) (a : α) (n : Nat) :
(a :: l).get! (n + 1) = l.get! nh
huList.get!_cons_zero}(hj  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/BasicAux.htmlhgtheorem List.get!_cons_zero {α : Type u_1} [Inhabited α] (l : List α) (a : α) :
(a :: l).get! 0 = ah
hu	List.getD}(hj  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/BasicAux.htmlhKdef List.getD {α : Type u_1} (as : List α) (i : Nat) (fallback : α) :
αh
Returns the element at the provided index, counting from 0. Returns fallback if the index is out of bounds.
To return an Option depending on whether the index is in bounds, use as[i]?. To panic if the index is out of bounds, use as[i]!.
Examples:u
List.getD_nil}(hj  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/BasicAux.htmlhPtheorem List.getD_nil {n : Nat} {α✝ : Type u_1} {d : α✝} :
[].getD n d = dh
hu
List.getLast!}(hj  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/BasicAux.htmlhAdef List.getLast! {α : Type u_1} [Inhabited α] :
List α → αh
|Returns the last element in the list. Panics and returns default if the list is empty.
Safer alternatives include:
Examples:u
List.head!}(hj!  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/BasicAux.htmlh>def List.head! {α : Type u_1} [Inhabited α] :
List α → αh
tReturns the first element in the list. If the list is empty, panics and returns default.
Safer alternatives include:u
List.tail!}(hj&  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/BasicAux.htmlh4def List.tail! {α : Type u_1} :
List α → List αh
Drops the first element of a nonempty list, returning the tail. If the list is empty, this function panics when executed and returns the empty list.
Safer alternatives include
Examples:uList.tail!_cons}(hj+  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/BasicAux.htmlhStheorem List.tail!_cons {α : Type u_1} {a : α} {l : List α} :
(a :: l).tail! = lh
huList.partitionM}(hj/  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/BasicAux.htmlh|def List.partitionM {m : Type → Type u_1} {α : Type} [Monad m] (p : α → m Bool) (l : List α) :
m (List α × List α)h
XJ  Returns a pair of lists that together contain all the elements of as. The first list contains those elements for which the monadic predicate p returns true, and the second contains those for which p returns false. The list's elements are examined in order, from left to right.
This is a monadic version of List.partition.
Example:uList.partitionMap}(hj4  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/BasicAux.htmlhdef List.partitionMap {α : Type u_1} {β : Type u_2} {γ : Type u_3} (f : α → β ⊕ γ) (l : List α) :
List β × List γh
Applies a function that returns a disjoint union to each element of a list, collecting the Sum.inl and Sum.inr results into separate lists.
Examples:u
List.mapMonoM}(hj9  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/BasicAux.htmlhvdef List.mapMonoM {m : Type u_1 → Type u_2} {α : Type u_1} [Monad m] (as : List α) (f : α → m α) :
m (List α)h
X>  Applies a monadic function to each element of a list, returning the list of results. The function is monomorphic: it is required to return a value of the same type. The internal implementation uses pointer equality, and does not allocate a new list if the result of each function call is pointer-equal to its argument.uList.mapMono}(hj>  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/BasicAux.htmlhIdef List.mapMono {α : Type u_1} (as : List α) (f : α → α) :
List αh
Xj  Applies a function to each element of a list, returning the list of results. The function is monomorphic: it is required to return a value of the same type. The internal implementation uses pointer equality, and does not allocate a new list if the result of each function call is pointer-equal to its argument.
For verification purposes, List.mapMono = List.map.uList.getElem_append_left}(hjC  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/BasicAux.htmlhtheorem List.getElem_append_left {α : Type u_1} {i : Nat} {as bs : List α} (h : i < as.length) {h' : i < (as ++ bs).length} :
(as ++ bs)[i] = as[i]h
huList.getElem_append_right}(hjG  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/BasicAux.htmlhtheorem List.getElem_append_right {α : Type u_1} {as bs : List α} {i : Nat} (h₁ : as.length ≤ i) {h₂ : i < (as ++ bs).length} :
(as ++ bs)[i] = bs[i - as.length]h
hu
List.get_last}(hjK  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/BasicAux.htmlhtheorem List.get_last {α : Type u_1} {a : α} {as : List α} {i : Fin (as ++ [a]).length} (h : ¬↑i < as.length) :
(as ++ [a]).get i = ah
huList.sizeOf_lt_of_mem}(hjO  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/BasicAux.htmlhwtheorem List.sizeOf_lt_of_mem {α : Type u_1} {a : α} [SizeOf α] {as : List α} (h : a ∈ as) :
sizeOf a < sizeOf ash
huList.tacticSizeOf_list_dec}(hjS  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/BasicAux.htmlh1def List.tacticSizeOf_list_dec :
Lean.ParserDescrh
This tactic, added to the decreasing_trivial toolbox, proves that sizeOf a < sizeOf as when a ∈ as, which is useful for well founded recursions over a nested inductive like inductive T | mk : List T → T.uList.append_cancel_left}(hjX  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/BasicAux.htmlhhtheorem List.append_cancel_left {α : Type u_1} {as bs cs : List α} (h : as ++ bs = as ++ cs) :
bs = csh
huList.append_cancel_right}(hj\  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/BasicAux.htmlhitheorem List.append_cancel_right {α : Type u_1} {as bs cs : List α} (h : as ++ bs = cs ++ bs) :
as = csh
huList.append_cancel_left_eq}(hj`  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/BasicAux.htmlhktheorem List.append_cancel_left_eq {α : Type u_1} (as bs cs : List α) :
(as ++ bs = as ++ cs) = (bs = cs)h
huList.append_cancel_right_eq}(hjd  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/BasicAux.htmlhltheorem List.append_cancel_right_eq {α : Type u_1} (as bs cs : List α) :
(as ++ bs = cs ++ bs) = (as = cs)h
huList.sizeOf_get}(hjh  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/BasicAux.htmlhvtheorem List.sizeOf_get {α : Type u_1} [SizeOf α] (as : List α) (i : Fin as.length) :
sizeOf (as.get i) < sizeOf ash
huList.not_lex_antisymm}(hjl  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/BasicAux.htmlhtheorem List.not_lex_antisymm {α : Type u_1} [DecidableEq α] {r : α → α → Prop} [DecidableRel r] (antisymm : ∀ (x y : α), ¬r x y → ¬r y x → x = y) {as bs : List α} (h₁ : ¬Lex r bs as) (h₂ : ¬Lex r as bs) :
as = bsh
huList.le_antisymm}(hjp  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/BasicAux.htmlhtheorem List.le_antisymm {α : Type u_1} [LT α] [i : Std.Antisymm fun (x1 x2 : α) => ¬x1 < x2] {as bs : List α} (h₁ : as ≤ bs) (h₂ : bs ≤ as) :
as = bsh
huList.instAntisymmLeOfNotLt}(hjt  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/BasicAux.htmlhinstance List.instAntisymmLeOfNotLt {α : Type u_1} [LT α] [s : Std.Antisymm fun (x1 x2 : α) => ¬x1 < x2] :
Std.Antisymm fun (x1 x2 : List α) => x1 ≤ x2h
hu	List.mapM}(hjx  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Control.htmlhzdef List.mapM {m : Type u → Type v} [Monad m] {α : Type w} {β : Type u} (f : α → m β) (as : List α) :
m (List β)h
XX  Applies the monadic action f to every element in the list, left-to-right, and returns the list of results.
This implementation is tail recursive. List.mapM' is a a non-tail-recursive variant that may be more convenient to reason about. List.forM is the variant that discards the results and List.mapA is the variant that works with Applicative.u	List.mapA}(hj}  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Control.htmlh}def List.mapA {m : Type u → Type v} [Applicative m] {α : Type w} {β : Type u} (f : α → m β) :
List α → m (List β)h
Xr  Applies the applicative action f on every element in the list, left-to-right, and returns the list of results.
If m is also a Monad, then using mapM can be more efficient.
See List.forA for the variant that discards the results. See List.mapM for the variant that works with Monad.
This function is not tail-recursive, so it may fail with a stack overflow on long lists.u	List.forM}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Control.htmlhkdef List.forM {m : Type u → Type v} [Monad m] {α : Type w} (as : List α) (f : α → m PUnit) :
m PUnith
Applies the monadic action f to every element in the list, in order.
List.mapM is a variant that collects results. List.forA is a variant that works on any Applicative.u	List.forA}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Control.htmlhqdef List.forA {m : Type u → Type v} [Applicative m] {α : Type w} (as : List α) (f : α → m PUnit) :
m PUnith
Applies the applicative action f to every element in the list, in order.
If m is also a Monad, then using List.forM can be more efficient.
List.mapA is a variant that collects results.u
List.zipWithM}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Control.htmlhdef List.zipWithM {m : Type u → Type v} [Monad m] {α : Type w} {β : Type x} {γ : Type u} (f : α → β → m γ) (as : List α) (bs : List β) :
m (List γ)h
X]  Applies the monadic action f to the corresponding elements of two lists, left-to-right, stopping at the end of the shorter list. zipWithM f as bs is equivalent to mapM id (zipWith f as bs) for lawful Monad instances.
This implementation is tail recursive. List.zipWithM' is a a non-tail-recursive variant that may be more convenient to reason about.uList.filterAuxM}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Control.htmlhydef List.filterAuxM {m : Type → Type v} [Monad m] {α : Type} (f : α → m Bool) :
List α → List α → m (List α)h
huList.filterM}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Control.htmlhmdef List.filterM {m : Type → Type v} [Monad m] {α : Type} (p : α → m Bool) (as : List α) :
m (List α)h
Applies the monadic predicate p to every element in the list, in order from left to right, and returns the list of elements for which p returns true.
O(|l|).
Example:uList.filterRevM}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Control.htmlhpdef List.filterRevM {m : Type → Type v} [Monad m] {α : Type} (p : α → m Bool) (as : List α) :
m (List α)h
Applies the monadic predicate p on every element in the list in reverse order, from right to left, and returns those elements for which p returns true. The elements of the returned list are in the same order as in the input list.
Example:uList.filterMapM}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Control.htmlhdef List.filterMapM {m : Type u → Type v} [Monad m] {α : Type w} {β : Type u} (f : α → m (Option β)) (as : List α) :
m (List β)h
}Applies a monadic function that returns an Option to each element of a list, collecting the non-none values.
O(|l|).
Example:u
List.flatMapM}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Control.htmlhdef List.flatMapM {m : Type u → Type v} [Monad m] {α : Type w} {β : Type u} (f : α → m (List β)) (as : List α) :
m (List β)h
Applies a monadic function that returns a list to each element of a list, from left to right, and concatenates the resulting lists.uList.foldlM}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Control.htmlhdef List.foldlM {m : Type u → Type v} [Monad m] {s : Type u} {α : Type w} (f : s → α → m s) (init : s) :
List α → m sh
Folds a monadic function over a list from the left, accumulating a value starting with init. The accumulated value is combined with the each element of the list in order, using f.
Example:uList.foldlM_nil}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Control.htmlhtheorem List.foldlM_nil {m : Type u_1 → Type u_2} {β : Type u_1} {α : Type u_3} [Monad m] {f : β → α → m β} {b : β} :
foldlM f b [] = pure bh
huList.foldlM_cons}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Control.htmlhtheorem List.foldlM_cons {m : Type u_1 → Type u_2} {β : Type u_1} {α : Type u_3} [Monad m] {f : β → α → m β} {b : β} {a : α} {l : List α} :
foldlM f b (a :: l) = do
  let init ← f b a
  foldlM f init lh
huList.foldrM}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Control.htmlhdef List.foldrM {m : Type u → Type v} [Monad m] {s : Type u} {α : Type w} (f : α → s → m s) (init : s) (l : List α) :
m sh
Folds a monadic function over a list from the right, accumulating a value starting with init. The accumulated value is combined with the each element of the list in reverse order, using f.
Example:uList.foldrM_nil}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Control.htmlhtheorem List.foldrM_nil {m : Type u_1 → Type u_2} {α : Type u_3} {β : Type u_1} [Monad m] {f : α → β → m β} {b : β} :
foldrM f b [] = pure bh
huList.firstM}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Control.htmlhxdef List.firstM {m : Type u → Type v} [Alternative m] {α : Type w} {β : Type u} (f : α → m β) :
List α → m βh
pMaps f over the list and collects the results with <|>. The result for the end of the list is failure.
Examples:u	List.anyM}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Control.htmlhfdef List.anyM {m : Type → Type u} [Monad m] {α : Type v} (p : α → m Bool) (l : List α) :
m Boolh
Returns true if the monadic predicate p returns true for any element of l.
O(|l|). Short-circuits upon encountering the first true. The elements in l are examined in order from left to right.u	List.allM}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Control.htmlhfdef List.allM {m : Type → Type u} [Monad m] {α : Type v} (p : α → m Bool) (l : List α) :
m Boolh
Returns true if the monadic predicate p returns true for every element of l.
O(|l|). Short-circuits upon encountering the first false. The elements in l are examined in order from left to right.uList.findM?}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Control.htmlhkdef List.findM? {m : Type → Type u} [Monad m] {α : Type} (p : α → m Bool) :
List α → m (Option α)h
Returns the first element of the list for which the monadic predicate p returns true, or none if no such element is found. Elements of the list are checked in order.
O(|l|).
Example:uList.findM?_pure}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Control.htmlhtheorem List.findM?_pure {α : Type} {m : Type → Type u_1} [Monad m] [LawfulMonad m] (p : α → Bool) (as : List α) :
findM? (fun (x : α) => pure (p x)) as = pure (find? p as)h
huList.idRun_findM?}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Control.htmlhtheorem List.idRun_findM? {α : Type} (p : α → Id Bool) (as : List α) :
(findM? p as).run = find? (fun (x : α) => (p x).run) ash
huList.findM?_id}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Control.htmlhatheorem List.findM?_id {α : Type} (p : α → Id Bool) (as : List α) :
findM? p as = find? p ash
huList.findSomeM?}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Control.htmlhdef List.findSomeM? {m : Type u → Type v} [Monad m] {α : Type w} {β : Type u} (f : α → m (Option β)) :
List α → m (Option β)h
Returns the first non-none result of applying the monadic function f to each element of the list, in order. Returns none if f returns none for all elements.
O(|l|).
Example:uList.findSomeM?_pure}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Control.htmlhtheorem List.findSomeM?_pure {m : Type u_1 → Type u_2} {α : Type u_3} {β : Type u_1} [Monad m] [LawfulMonad m] {f : α → Option β} {as : List α} :
findSomeM? (fun (x : α) => pure (f x)) as = pure (findSome? f as)h
huList.idRun_findSomeM?}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Control.htmlhtheorem List.idRun_findSomeM? {α : Type u_1} {β : Type u_2} (f : α → Id (Option β)) (as : List α) :
(findSomeM? f as).run = findSome? (fun (x : α) => (f x).run) ash
huList.findSomeM?_id}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Control.htmlhtheorem List.findSomeM?_id {α : Type u_1} {β : Type u_2} (f : α → Id (Option β)) (as : List α) :
findSomeM? f as = findSome? f ash
huList.findM?_eq_findSomeM?}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Control.htmlhX  theorem List.findM?_eq_findSomeM? {m : Type → Type u_1} {α : Type} [Monad m] [LawfulMonad m] {p : α → m Bool} {as : List α} :
findM? p as = findSomeM?
    (fun (a : α) => do
      let __do_lift ← p a
      pure (if __do_lift = true then some a else none))
    ash
huList.forIn'}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Control.htmlhdef List.forIn' {α : Type u} {β : Type v} {m : Type v → Type w} [Monad m] (as : List α) (init : β) (f : (a : α) → a ∈ as → β → m (ForInStep β)) :
m βh
hu&List.instForIn'InferInstanceMembership}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Control.htmlhinstance List.instForIn'InferInstanceMembership {m : Type u_1 → Type u_2} {α : Type u_3} :
ForIn' m (List α) α inferInstanceh
huList.forIn'_eq_forIn'}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Control.htmlhztheorem List.forIn'_eq_forIn' {m : Type u_1 → Type u_2} {α : Type u_3} {β : Type u_1} [Monad m] :
List.forIn' = forIn'h
huList.forIn'_nil}(hj   hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Control.htmlhtheorem List.forIn'_nil {m : Type u_1 → Type u_2} {α : Type u_3} {β : Type u_1} [Monad m] {f : (a : α) → a ∈ [] → β → m (ForInStep β)} {b : β} :
forIn' [] b f = pure bh
huList.forIn_nil}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Control.htmlhtheorem List.forIn_nil {m : Type u_1 → Type u_2} {α : Type u_3} {β : Type u_1} [Monad m] {f : α → β → m (ForInStep β)} {b : β} :
forIn [] b f = pure bh
hu
List.instForM}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Control.htmlhXinstance List.instForM {m : Type u_1 → Type u_2} {α : Type u_3} :
ForM m (List α) αh
huList.forM_eq_forM}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Control.htmlhbtheorem List.forM_eq_forM {m : Type u_1 → Type u_2} {α : Type u_3} [Monad m] :
List.forM = forMh
hu
List.forM_nil}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Control.htmlh~theorem List.forM_nil {m : Type u_1 → Type u_2} {α : Type u_3} [Monad m] {f : α → m PUnit} :
forM [] f = pure PUnit.unith
huList.forM_cons}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Control.htmlhtheorem List.forM_cons {m : Type u_1 → Type u_2} {α : Type u_3} [Monad m] {f : α → m PUnit} {a : α} {as : List α} :
forM (a :: as) f = do
  f a
  forM as fh
huList.instFunctor}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Control.htmlh(instance List.instFunctor :
Functor Listh
huList.countP_nil}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Count.htmlhKtheorem List.countP_nil {α : Type u_1} {p : α → Bool} :
countP p [] = 0h
huList.countP_go_eq_add}(hj   hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Count.htmlhtheorem List.countP_go_eq_add {α : Type u_1} {p : α → Bool} {n : Nat} {l : List α} :
countP.go p l n = n + countP.go p l 0h
huList.countP_cons_of_pos}(hj$  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Count.htmlhtheorem List.countP_cons_of_pos {α : Type u_1} {p : α → Bool} {a : α} {l : List α} (pa : p a = true) :
countP p (a :: l) = countP p l + 1h
huList.countP_cons_of_neg}(hj(  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Count.htmlhtheorem List.countP_cons_of_neg {α : Type u_1} {p : α → Bool} {a : α} {l : List α} (pa : ¬p a = true) :
countP p (a :: l) = countP p lh
huList.countP_cons}(hj,  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Count.htmlhtheorem List.countP_cons {α : Type u_1} {p : α → Bool} {a : α} {l : List α} :
countP p (a :: l) = countP p l + if p a = true then 1 else 0h
huList.countP_singleton}(hj0  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Count.htmlhutheorem List.countP_singleton {α : Type u_1} {p : α → Bool} {a : α} :
countP p [a] = if p a = true then 1 else 0h
hu List.length_eq_countP_add_countP}(hj4  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Count.htmlhtheorem List.length_eq_countP_add_countP {α : Type u_1} (p : α → Bool) {l : List α} :
l.length = countP p l + countP (fun (a : α) => decide ¬p a = true) lh
huList.countP_eq_length_filter}(hj8  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Count.htmlhwtheorem List.countP_eq_length_filter {α : Type u_1} {p : α → Bool} {l : List α} :
countP p l = (filter p l).lengthh
huList.countP_eq_length_filter'}(hj<  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Count.htmlhhtheorem List.countP_eq_length_filter' {α : Type u_1} {p : α → Bool} :
countP p = length ∘ filter ph
huList.countP_le_length}(hj@  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Count.htmlhgtheorem List.countP_le_length {α : Type u_1} {p : α → Bool} {l : List α} :
countP p l ≤ l.lengthh
huList.countP_append}(hjD  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Count.htmlhtheorem List.countP_append {α : Type u_1} {p : α → Bool} {l₁ l₂ : List α} :
countP p (l₁ ++ l₂) = countP p l₁ + countP p l₂h
huList.countP_pos_iff}(hjH  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Count.htmlhtheorem List.countP_pos_iff {α✝ : Type u_1} {l : List α✝} {p : α✝ → Bool} :
0 < countP p l ↔ ∃ (a : α✝), a ∈ l ∧ p a = trueh
huList.one_le_countP_iff}(hjL  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Count.htmlhtheorem List.one_le_countP_iff {α✝ : Type u_1} {l : List α✝} {p : α✝ → Bool} :
1 ≤ countP p l ↔ ∃ (a : α✝), a ∈ l ∧ p a = trueh
huList.countP_eq_zero}(hjP  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Count.htmlhtheorem List.countP_eq_zero {α✝ : Type u_1} {l : List α✝} {p : α✝ → Bool} :
countP p l = 0 ↔ ∀ (a : α✝), a ∈ l → ¬p a = trueh
huList.countP_eq_length}(hjT  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Count.htmlhtheorem List.countP_eq_length {α✝ : Type u_1} {l : List α✝} {p : α✝ → Bool} :
countP p l = l.length ↔ ∀ (a : α✝), a ∈ l → p a = trueh
huList.countP_replicate}(hjX  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Count.htmlhtheorem List.countP_replicate {α : Type u_1} {p : α → Bool} {a : α} {n : Nat} :
countP p (replicate n a) = if p a = true then n else 0h
huList.boole_getElem_le_countP}(hj\  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Count.htmlhtheorem List.boole_getElem_le_countP {α : Type u_1} {p : α → Bool} {l : List α} {i : Nat} (h : i < l.length) :
(if p l[i] = true then 1 else 0) ≤ countP p lh
huList.countP_tail_le}(hj`  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Count.htmlhltheorem List.countP_tail_le {α : Type u_1} {p : α → Bool} (l : List α) :
countP p l.tail ≤ countP p lh
huList.countP_filter}(hjd  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Count.htmlhtheorem List.countP_filter {α : Type u_1} {p q : α → Bool} {l : List α} :
countP p (filter q l) = countP (fun (a : α) => p a && q a) lh
huList.countP_true}(hjh  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Count.htmlhQtheorem List.countP_true {α : Type u_1} :
(countP fun (x : α) => true) = lengthn      h
huList.countP_false}(hjl  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Count.htmlhgtheorem List.countP_false {α : Type u_1} :
(countP fun (x : α) => false) = Function.const (List α) 0h
huList.countP_map}(hjp  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Count.htmlhtheorem List.countP_map {α : Type u_2} {β : Type u_1} {p : β → Bool} {f : α → β} {l : List α} :
countP p (map f l) = countP (p ∘ f) lh
huList.length_filterMap_eq_countP}(hjt  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Count.htmlhtheorem List.length_filterMap_eq_countP {α : Type u_2} {β : Type u_1} {f : α → Option β} {l : List α} :
(filterMap f l).length = countP (fun (a : α) => (f a).isSome) lh
huList.countP_filterMap}(hjx  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Count.htmlhtheorem List.countP_filterMap {α : Type u_2} {β : Type u_1} {p : β → Bool} {f : α → Option β} {l : List α} :
countP p (filterMap f l) = countP (fun (a : α) => (Option.map p (f a)).getD false) lh
huList.countP_flatten}(hj|  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Count.htmlhtheorem List.countP_flatten {α : Type u_1} {p : α → Bool} {l : List (List α)} :
countP p l.flatten = (map (countP p) l).sumh
huList.countP_flatMap}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Count.htmlhtheorem List.countP_flatMap {α : Type u_2} {β : Type u_1} {p : β → Bool} {l : List α} {f : α → List β} :
countP p (flatMap f l) = (map (countP p ∘ f) l).sumh
huList.countP_reverse}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Count.htmlhmtheorem List.countP_reverse {α : Type u_1} {p : α → Bool} {l : List α} :
countP p l.reverse = countP p lh
huList.countP_mono_left}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Count.htmlhtheorem List.countP_mono_left {α : Type u_1} {p q : α → Bool} {l : List α} (h : ∀ (x : α), x ∈ l → p x = true → q x = true) :
countP p l ≤ countP q lh
huList.countP_congr}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Count.htmlhtheorem List.countP_congr {α : Type u_1} {p q : α → Bool} {l : List α} (h : ∀ (x : α), x ∈ l → (p x = true ↔ q x = true)) :
countP p l = countP q lh
huList.count_nil}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Count.htmlhItheorem List.count_nil {α : Type u_1} [BEq α] {a : α} :
count a [] = 0h
huList.count_cons}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Count.htmlhtheorem List.count_cons {α : Type u_1} [BEq α] {a b : α} {l : List α} :
count a (b :: l) = count a l + if (b == a) = true then 1 else 0h
huList.count_eq_countP}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Count.htmlh|theorem List.count_eq_countP {α : Type u_1} [BEq α] {a : α} {l : List α} :
count a l = countP (fun (x : α) => x == a) lh
huList.count_eq_countP'}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Count.htmlhitheorem List.count_eq_countP' {α : Type u_1} [BEq α] {a : α} :
count a = countP fun (x : α) => x == ah
huList.count_eq_length_filter}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Count.htmlhtheorem List.count_eq_length_filter {α : Type u_1} [BEq α] {a : α} {l : List α} :
count a l = (filter (fun (x : α) => x == a) l).lengthh
huList.count_tail}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Count.htmlhtheorem List.count_tail {α : Type u_1} [BEq α] {l : List α} {a : α} :
count a l.tail = count a l - if (l.head? == some a) = true then 1 else 0h
huList.count_le_length}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Count.htmlhetheorem List.count_le_length {α : Type u_1} [BEq α] {a : α} {l : List α} :
count a l ≤ l.lengthh
huList.count_tail_le}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Count.htmlhitheorem List.count_tail_le {α : Type u_1} [BEq α] {a : α} {l : List α} :
count a l.tail ≤ count a lh
huList.count_le_count_cons}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Count.htmlhstheorem List.count_le_count_cons {α : Type u_1} [BEq α] {a b : α} {l : List α} :
count a l ≤ count a (b :: l)h
huList.count_singleton}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Count.htmlhqtheorem List.count_singleton {α : Type u_1} [BEq α] {a b : α} :
count a [b] = if (b == a) = true then 1 else 0h
huList.count_append}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Count.htmlhtheorem List.count_append {α : Type u_1} [BEq α] {a : α} {l₁ l₂ : List α} :
count a (l₁ ++ l₂) = count a l₁ + count a l₂h
huList.count_flatten}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Count.htmlh}theorem List.count_flatten {α : Type u_1} [BEq α] {a : α} {l : List (List α)} :
count a l.flatten = (map (count a) l).sumh
huList.count_reverse}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Count.htmlhjtheorem List.count_reverse {α : Type u_1} [BEq α] {a : α} {l : List α} :
count a l.reverse = count a lh
huList.boole_getElem_le_count}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Count.htmlhtheorem List.boole_getElem_le_count {α : Type u_1} [BEq α] {a : α} {l : List α} {i : Nat} (h : i < l.length) :
(if (l[i] == a) = true then 1 else 0) ≤ count a lh
huList.count_cons_self}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Count.htmlh~theorem List.count_cons_self {α : Type u_1} [BEq α] [LawfulBEq α] {a : α} {l : List α} :
count a (a :: l) = count a l + 1h
huList.count_cons_of_ne}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Count.htmlhtheorem List.count_cons_of_ne {α : Type u_1} [BEq α] [LawfulBEq α] {b a : α} (h : b ≠ a) {l : List α} :
count a (b :: l) = count a lh
huList.count_singleton_self}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Count.htmlhdtheorem List.count_singleton_self {α : Type u_1} [BEq α] [LawfulBEq α] {a : α} :
count a [a] = 1h
huList.count_concat_self}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Count.htmlhtheorem List.count_concat_self {α : Type u_1} [BEq α] [LawfulBEq α] {a : α} {l : List α} :
count a (l.concat a) = count a l + 1h
huList.count_pos_iff}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Count.htmlhutheorem List.count_pos_iff {α : Type u_1} [BEq α] [LawfulBEq α] {a : α} {l : List α} :
0 < count a l ↔ a ∈ lh
huList.one_le_count_iff}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Count.htmlhztheorem List.one_le_count_iff {α : Type u_1} [BEq α] [LawfulBEq α] {a : α} {l : List α} :
1 ≤ count a l ↔ a ∈ lh
huList.count_eq_zero_of_not_mem}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Count.htmlhtheorem List.count_eq_zero_of_not_mem {α : Type u_1} [BEq α] [LawfulBEq α] {a : α} {l : List α} (h : ¬a ∈ l) :
count a l = 0h
huList.not_mem_of_count_eq_zero}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Count.htmlhtheorem List.not_mem_of_count_eq_zero {α : Type u_1} [BEq α] [LawfulBEq α] {a : α} {l : List α} (h : count a l = 0) :
¬a ∈ lh
huList.count_eq_zero}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Count.htmlhwtheorem List.count_eq_zero {α : Type u_1} [BEq α] [LawfulBEq α] {a : α} {l : List α} :
count a l = 0 ↔ ¬a ∈ lh
huList.count_eq_length}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Count.htmlhtheorem List.count_eq_length {α : Type u_1} [BEq α] [LawfulBEq α] {a : α} {l : List α} :
count a l = l.length ↔ ∀ (b : α), b ∈ l → a = bh
huList.count_replicate_self}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Count.htmlhztheorem List.count_replicate_self {α : Type u_1} [BEq α] [LawfulBEq α] {a : α} {n : Nat} :
count a (replicate n a) = nh
huList.count_replicate}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Count.htmlhtheorem List.count_replicate {α : Type u_1} [BEq α] [LawfulBEq α] {a b : α} {n : Nat} :
count a (replicate n b) = if (b == a) = true then n else 0h
huList.filter_beq}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Count.htmlhtheorem List.filter_beq {α : Type u_1} [BEq α] [LawfulBEq α] {l : List α} (a : α) :
filter (fun (x : α) => x == a) l = replicate (count a l) ah
huList.filter_eq}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Count.htmlhtheorem List.filter_eq {α : Type u_1} [BEq α] [LawfulBEq α] [DecidableEq α] {l : List α} (a : α) :
filter (fun (x : α) => decide (x = a)) l = replicate (count a l) ah
huList.replicate_sublist_iff}(hj   hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Count.htmlhtheorem List.replicate_sublist_iff {α : Type u_1} [BEq α] [LawfulBEq α] {n : Nat} {a : α} {l : List α} :
(replicate n a).Sublist l ↔ n ≤ count a lh
hu#List.le_count_iff_replicate_sublist}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Count.htmlhtheorem List.le_count_iff_replicate_sublist {α : Type u_1} [BEq α] [LawfulBEq α] {n : Nat} {a : α} {l : List α} :
n ≤ count a l ↔ (replicate n a).Sublist lh
hu*List.replicate_count_eq_of_count_eq_length}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Count.htmlhtheorem List.replicate_count_eq_of_count_eq_length {α : Type u_1} [BEq α] [LawfulBEq α] {a : α} {l : List α} (h : count a l = l.length) :
replicate (count a l) a = lh
huList.count_filter}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Count.htmlhtheorem List.count_filter {α : Type u_1} [BEq α] [LawfulBEq α] {p : α → Bool} {a : α} {l : List α} (h : p a = true) :
count a (filter p l) = count a lh
huList.count_le_count_map}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Count.htmlhtheorem List.count_le_count_map {α : Type u_2} [BEq α] [LawfulBEq α] {β : Type u_1} [BEq β] [LawfulBEq β] {l : List α} {f : α → β} {x : α} :
count x l ≤ count (f x) (map f l)h
huList.count_filterMap}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Count.htmlhtheorem List.count_filterMap {β : Type u_1} {α : Type u_2} [BEq β] {b : β} {f : α → Option β} {l : List α} :
count b (filterMap f l) = countP (fun (a : α) => f a == some b) lh
huList.count_flatMap}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Count.htmlhtheorem List.count_flatMap {β : Type u_1} {α : Type u_2} [BEq β] {l : List α} {f : α → List β} {x : β} :
count x (flatMap f l) = (map (count x ∘ f) l).sumh
huList.count_erase}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Count.htmlhtheorem List.count_erase {α : Type u_1} [BEq α] [LawfulBEq α] {a b : α} {l : List α} :
count a (l.erase b) = count a l - if (b == a) = true then 1 else 0h
huList.count_erase_self}(hj   hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Count.htmlhtheorem List.count_erase_self {α : Type u_1} [BEq α] [LawfulBEq α] {a : α} {l : List α} :
count a (l.erase a) = count a l - 1h
huList.count_erase_of_ne}(hj$  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Count.htmlhtheorem List.count_erase_of_ne {α : Type u_1} [BEq α] [LawfulBEq α] {a b : α} (ab : a ≠ b) {l : List α} :
count a (l.erase b) = count a lh
huList.eraseP_nil}(hj(  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Erase.htmlhRtheorem List.eraseP_nil {α✝ : Type u_1} {p : α✝ → Bool} :
eraseP p [] = []h
huList.eraseP_cons}(hj,  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Erase.htmlhtheorem List.eraseP_cons {α : Type u_1} {p : α → Bool} {a : α} {l : List α} :
eraseP p (a :: l) = bif p a then l else a :: eraseP p lh
huList.eraseP_cons_of_pos}(hj0  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Erase.htmlhtheorem List.eraseP_cons_of_pos {α : Type u_1} {a : α} {l : List α} {p : α → Bool} (h : p a = true) :
eraseP p (a :: l) = lh
huList.eraseP_cons_of_neg}(hj4  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Erase.htmlhtheorem List.eraseP_cons_of_neg {α : Type u_1} {a : α} {l : List α} {p : α → Bool} (h : ¬p a = true) :
eraseP p (a :: l) = a :: eraseP p lh
huList.eraseP_of_forall_not}(hj8  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Erase.htmlhtheorem List.eraseP_of_forall_not {α : Type u_1} {p : α → Bool} {l : List α} (h : ∀ (a : α), a ∈ l → ¬p a = true) :
eraseP p l = lh
huList.eraseP_eq_nil_iff}(hj<  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Erase.htmlhtheorem List.eraseP_eq_nil_iff {α : Type u_1} {xs : List α} {p : α → Bool} :
eraseP p xs = [] ↔ xs = [] ∨ ∃ (x : α), p x = true ∧ xs = [x]h
huList.eraseP_ne_nil_iff}(hj@  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Erase.htmlhtheorem List.eraseP_ne_nil_iff {α : Type u_1} {xs : List α} {p : α → Bool} :
eraseP p xs ≠ [] ↔ xs ≠ [] ∧ ∀ (x : α), p x = true → xs ≠ [x]h
huList.exists_of_eraseP}(hjD  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Erase.htmlhX4  theorem List.exists_of_eraseP {α : Type u_1} {p : α → Bool} {l : List α} {a : α} :
a ∈ l →
  p a = true →
    ∃ (a : α),       ∃ (l₁ : List α),         ∃ (l₂ : List α), (∀ (b : α), b ∈ l₁ → ¬p b = true) ∧ p a = true ∧ l = l₁ ++ a :: l₂ ∧ eraseP p l = l₁ ++ l₂h
hu List.exists_or_eq_self_of_eraseP}(hjH  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Erase.htmlhX  theorem List.exists_or_eq_self_of_eraseP {α : Type u_1} (p : α → Bool) (l : List α) :
eraseP p l = l ∨ ∃ (a : α), ∃ (l₁ : List α), ∃ (l₂ : List α), (∀ (b : α), b ∈ l₁ → ¬p b = true) ∧ p a = true ∧ l = l₁ ++ a :: l₂ ∧ eraseP p l = l₁ ++ l₂h
huList.length_eraseP_of_mem}(hjL  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Erase.htmlhtheorem List.length_eraseP_of_mem {α✝ : Type u_1} {l : List α✝} {a : α✝} {p : α✝ → Bool} (al : a ∈ l) (pa : p a = true) :
(eraseP p l).length = l.length - 1h
huList.length_eraseP}(hjP  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Erase.htmlhtheorem List.length_eraseP {α : Type u_1} {p : α → Bool} {l : List α} :
(eraseP p l).length = if l.any p = true then l.length - 1 else l.lengthh
huList.eraseP_sublist}(hjT  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Erase.htmlhdtheorem List.eraseP_sublist {α : Type u_1} {p : α → Bool} {l : List α} :
(eraseP p l).Sublist lh
huList.eraseP_subset}(hjX  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Erase.htmlh]theorem List.eraseP_subset {α : Type u_1} {p : α → Bool} {l : List α} :
eraseP p l ⊆ lh
huList.length_eraseP_le}(hj\  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Erase.htmlhptheorem List.length_eraseP_le {α : Type u_1} {p : α → Bool} {l : List α} :
(eraseP p l).length ≤ l.lengthh
huList.le_length_eraseP}(hj`  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Erase.htmlhttheorem List.le_length_eraseP {α : Type u_1} {p : α → Bool} {l : List α} :
l.length - 1 ≤ (eraseP p l).lengthh
huList.mem_of_mem_eraseP}(hjd  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Erase.htmlhvtheorem List.mem_of_mem_eraseP {α : Type u_1} {p : α → Bool} {a : α} {l : List α} :
a ∈ eraseP p l → a ∈ lh
huList.mem_eraseP_of_neg}(hjh  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Erase.htmlhtheorem List.mem_eraseP_of_neg {α : Type u_1} {p : α → Bool} {a : α} {l : List α} (pa : ¬p a = true) :
a ∈ eraseP p l ↔ a ∈ lh
huList.eraseP_eq_self_iff}(hjl  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Erase.htmlhtheorem List.eraseP_eq_self_iff {α : Type u_1} {p : α → Bool} {l : List α} :
eraseP p l = l ↔ ∀ (a : α), a ∈ l → ¬p a = trueh
huList.eraseP_map}(hjp  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Erase.htmlhtheorem List.eraseP_map {β : Type u_1} {α : Type u_2} {p : α → Bool} {f : β → α} {l : List β} :
eraseP p (map f l) = map f (eraseP (p ∘ f) l)h
huList.eraseP_filterMap}(hjt  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Erase.htmlhX  theorem List.eraseP_filterMap {α : Type u_1} {β : Type u_2} {p : β → Bool} {f : α → Option β} {l : List α} :
eraseP p (filterMap f l) = filterMap f
    (eraseP
      (fun (x : α) =>
        match f x with
        | some y => p y
        | none => false)
      l)h
huList.eraseP_filter}(hjx  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Erase.htmlhtheorem List.eraseP_filter {α : Type u_1} {p f : α → Bool} {l : List α} :
eraseP p (filter f l) = filter f (eraseP (fun (x : α) => p x && f x) l)h
huList.eraseP_append_left}(hj|  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Erase.htmlhtheorem List.eraseP_append_left {α : Type u_1} {p : α → Bool} {a : α} (pa : p a = true) {l₁ : List α} (l₂ : List α) :
a ∈ l₁ → eraseP p (l₁ ++ l₂) = eraseP p l₁ ++ l₂h
huList.eraseP_append_right}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Erase.htmlhtheorem List.eraseP_append_right {α : Type u_1} {p : α → Bool} {l₁ : List α} (l₂ : List α) :
(∀ (b : α), b ∈ l₁ → ¬p b = true) → eraseP p (l₁ ++ l₂) = l₁ ++ eraseP p l₂h
huList.eraseP_append}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Erase.htmlhtheorem List.eraseP_append {α : Type u_1} {p : α → Bool} {l₁ l₂ : List α} :
eraseP p (l₁ ++ l₂) = if l₁.any p = true then eraseP p l₁ ++ l₂ else l₁ ++ eraseP p l₂h
huList.eraseP_replicate}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Erase.htmlhtheorem List.eraseP_replicate {α : Type u_1} {n : Nat} {a : α} {p : α → Bool} :
eraseP p (replicate n a) = if p a = true then replicate (n - 1) a else replicate n ah
huList.eraseP_replicate_of_pos}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Erase.htmlhtheorem List.eraseP_replicate_of_pos {α : Type u_1} {p : α → Bool} {n : Nat} {a : α} (h : p a = true) :
eraseP p (replicate n a) = replicate (n - 1) ah
huList.eraseP_replicate_of_neg}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Erase.htmlhtheorem List.eraseP_replicate_of_neg {α : Type u_1} {p : α → Bool} {n : Nat} {a : α} (h : ¬p a = true) :
eraseP p (replicate n a) = replicate n ah
huList.eraseP_eq_iff}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Erase.htmlhXL  theorem List.eraseP_eq_iff {α : Type u_1} {l' : List α} {p : α → Bool} {l : List α} :
eraseP p l = l' ↔ (∀ (a : α), a ∈ l → ¬p a = true) ∧ l = l' ∨ ∃ (a : α), ∃ (l₁ : List α), ∃ (l₂ : List α), (∀ (b : α), b ∈ l₁ → ¬p b = true) ∧ p a = true ∧ l = l₁ ++ a :: l₂ ∧ l' = l₁ ++ l₂h
huList.eraseP_comm}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Erase.htmlhtheorem List.eraseP_comm {α : Type u_1} {p q : α → Bool} {l : List α} (h : ∀ (a : α), a ∈ l → ¬p a = true ∨ ¬q a = true) :
eraseP q (eraseP p l) = eraseP p (eraseP q l)h
huList.head_eraseP_mem}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Erase.htmlhtheorem List.head_eraseP_mem {α : Type u_1} {xs : List α} {p : α → Bool} (h : eraseP p xs ≠ []) :
(eraseP p xs).head h ∈ xsh
huList.getLast_eraseP_mem}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Erase.htmlhtheorem List.getLast_eraseP_mem {α : Type u_1} {xs : List α} {p : α → Bool} (h : eraseP p xs ≠ []) :
(eraseP p xs).getLast h ∈ xsh
huList.eraseP_eq_eraseIdx}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Erase.htmlhtheorem List.eraseP_eq_eraseIdx {α : Type u_1} {xs : List α} {p : α → Bool} :
eraseP p xs = match findIdx? p xs with
  | none => xs
  | some i => xs.eraseIdx ih
huList.erase_cons_head}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Erase.htmlhrtheorem List.erase_cons_head {α : Type u_1} [BEq α] [LawfulBEq α] (a : α) (l : List α) :
(a :: l).erase a = lh
huList.erase_cons_tail}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Erase.htmlhtheorem List.erase_cons_tail {α : Type u_1} [BEq α] {a b : α} {l : List α} (h : ¬(b == a) = true) :
(b :: l).erase a = b :: l.erase ah
huList.erase_of_not_mem}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Erase.htmlhztheorem List.erase_of_not_mem {α : Type u_1} [BEq α] [LawfulBEq α] {a : α} {l : List α} :
¬a ∈ l → l.erase a = lh
huList.erase_eq_eraseP'}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Erase.htmlh}theorem List.erase_eq_eraseP' {α : Type u_1} [BEq α] (a : α) (l : List α) :
l.erase a = eraseP (fun (x : α) => x == a) lh
huList.erase_eq_eraseP}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Erase.htmlhtheorem List.erase_eq_eraseP {α : Type u_1} [BEq α] [LawfulBEq α] (a : α) (l : List α) :
l.erase a = eraseP (fun (x : α) => a == x) lh
huList.erase_eq_nil_iff}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Erase.htmlhtheorem List.erase_eq_nil_iff {α : Type u_1} [BEq α] [LawfulBEq α] {xs : List α} {a : α} :
xs.erase a = [] ↔ xs = [] ∨ xs = [a]h
huList.erase_ne_nil_iff}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Erase.htmlhtheorem List.erase_ne_nil_iff {α : Type u_1} [BEq α] [LawfulBEq α] {xs : List α} {a : α} :
xs.erase a ≠ [] ↔ xs ≠ [] ∧ xs ≠ [a]h
huList.exists_erase_eq}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Erase.htmlhtheorem List.exists_erase_eq {α : Type u_1} [BEq α] [LawfulBEq α] {a : α} {l : List α} (h : a ∈ l) :
∃ (l₁ : List α), ∃ (l₂ : List α), ¬a ∈ l₁ ∧ l = l₁ ++ a :: l₂ ∧ l.erase a = l₁ ++ l₂h
huList.length_erase_of_mem}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Erase.htmlhtheorem List.length_erase_of_mem {α : Type u_1} [BEq α] [LawfulBEq α] {a : α} {l : List α} (h : a ∈ l) :
(l.erase a).length = l.length - 1h
huList.length_erase}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Erase.htmlhtheorem List.length_erase {α : Type u_1} [BEq α] [LawfulBEq α] {a : α} {l : List α} :
(l.erase a).length = if a ∈ l then l.length - 1 else l.lengthh
huList.erase_sublist}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Erase.htmlhbtheorem List.erase_sublist {α : Type u_1} [BEq α] {a : α} {l : List α} :
(l.erase a).Sublist lh
huList.erase_subset}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Erase.htmlh[theorem List.erase_subset {α : Type u_1} [BEq α] {a : α} {l : List α} :
l.erase a ⊆ lh
huList.length_erase_le}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Erase.htmlhntheorem List.length_erase_le {α : Type u_1} [BEq α] {a : α} {l : List α} :
(l.erase a).length ≤ l.lengthh
huList.le_length_erase}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Erase.htmlhtheorem List.le_length_erase {α : Type u_1} [BEq α] [LawfulBEq α] {a : α} {l : List α} :
l.length - 1 ≤ (l.erase a).lengthh
huList.mem_of_mem_erase}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Erase.htmlhotheorem List.mem_of_mem_erase {α : Type u_1} [BEq α] {a b : α} {l : List α} (h : a ∈ l.erase b) :
a ∈ lh
huList.mem_erase_of_ne}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Erase.htmlhtheorem List.mem_erase_of_ne {α : Type u_1} [BEq α] [LawfulBEq α] {a b : α} {l : List α} (ab : a ≠ b) :
a ∈ l.erase b ↔ a ∈ lh
huList.erase_eq_self_iff}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Erase.htmlh{theorem List.erase_eq_self_iff {α : Type u_1} [BEq α] {a : α} [LawfulBEq α] {l : List α} :
l.erase a = l ↔ ¬a ∈ lh
huList.erase_filter}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Erase.htmlhtheorem List.erase_filter {α : Type u_1} [BEq α] {a : α} [LawfulBEq α] {f : α → Bool} {l : List α} :
(filter f l).erase a = filter f (l.erase a)h
huList.erase_append_left}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Erase.htmlhtheorem List.erase_append_left {α : Type u_1} [BEq α] {a : α} [LawfulBEq α] {l₁ : List α} (l₂ : List α) (h : a ∈ l₁) :
(l₁ ++ l₂).erase a = l₁.erase a ++ l₂h
huList.erase_append_right}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Erase.htmlhtheorem List.erase_append_right {α : Type u_1} [BEq α] [LawfulBEq α] {a : α} {l₁ : List α} (l₂ : List α) (h : ¬a ∈ l₁) :
(l₁ ++ l₂).erase a = l₁ ++ l₂.erase ah
huList.erase_append}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Erase.htmlhtheorem List.erase_append {α : Type u_1} [BEq α] [LawfulBEq α] {a : α} {l₁ l₂ : List α} :
(l₁ ++ l₂).erase a = if a ∈ l₁ then l₁.erase a ++ l₂ else l₁ ++ l₂.erase ah
huList.erase_replicate}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Erase.htmlhtheorem List.erase_replicate {α : Type u_1} [BEq α] [LawfulBEq α] {n : Nat} {a b : α} :
(replicate n a).erase b = if (b == a) = true then replicate (n - 1) a else replicate n ah
huList.erase_comm}(hj 	  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Erase.htmlhtheorem List.erase_comm {α : Type u_1} [BEq α] [LawfulBEq α] (a b : α) {l : List α} :
(l.erase a).erase b = (l.erase b).erase ah
huList.erase_eq_iff}(hj	  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Erase.htmlhtheorem List.erase_eq_iff {α : Type u_1} [BEq α] {l' : List α} [LawfulBEq α] {a : α} {l : List α} :
l.erase a = l' ↔ ¬a ∈ l ∧ l = l' ∨ ∃ (l₁ : List α), ∃ (l₂ : List α), ¬a ∈ l₁ ∧ l = l₁ ++ a :: l₂ ∧ l' = l₁ ++ l₂h
huList.erase_replicate_self}(hj	  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Erase.htmlhtheorem List.erase_replicate_self {α : Type u_1} [BEq α] {n : Nat} [LawfulBEq α] {a : α} :
(replicate n a).erase a = replicate (n - 1) ah
huList.erase_replicate_ne}(hj	  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Erase.htmlhtheorem List.erase_replicate_ne {α : Type u_1} [BEq α] {n : Nat} [LawfulBEq α] {a b : α} (h : (!b == a) = true) :
(replicate n a).erase b = replicate n ah
huList.head_erase_mem}(hj	  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Erase.htmlhtheorem List.head_erase_mem {α : Type u_1} [BEq α] (xs : List α) (a : α) (h : xs.erase a ≠ []) :
(xs.erase a).head h ∈ xsh
huList.getLast_erase_mem}(hj	  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Erase.htmlhtheorem List.getLast_erase_mem {α : Type u_1} [BEq α] (xs : List α) (a : α) (h : xs.erase a ≠ []) :
(xs.erase a).getLast h ∈ xsh
huList.erase_eq_eraseIdx}(hj	  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Erase.htmlhtheorem List.erase_eq_eraseIdx {α : Type u_1} [BEq α] (l : List α) (a : α) :
l.erase a = match idxOf? a l with
  | none => l
  | some i => l.eraseIdx ih
huList.length_eraseIdx}(hj	  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Erase.htmlhtheorem List.length_eraseIdx {α : Type u_1} {l : List α} {i : Nat} :
(l.eraseIdx i).length = if i < l.length then l.length - 1 else l.lengthh
huList.length_eraseIdx_of_lt}(hj 	  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Erase.htmlhtheorem List.length_eraseIdx_of_lt {α : Type u_1} {l : List α} {i : Nat} (h : i < l.length) :
(l.eraseIdx i).length = l.length - 1h
huList.eraseIdx_zero}(hj$	  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Erase.htmlhPtheorem List.eraseIdx_zero {α : Type u_1} {l : List α} :
l.eraseIdx 0 = l.tailh
huList.eraseIdx_eq_take_drop_succ}(hj(	  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Erase.htmlh{theorem List.eraseIdx_eq_take_drop_succ {α : Type u_1} (l : List α) (i : Nat) :
l.eraseIdx i = take i l ++ drop (i + 1) lh
huList.eraseIdx_eq_nil_iff}(hj,	  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Erase.htmlhtheorem List.eraseIdx_eq_nil_iff {α : Type u_1} {l : List α} {i : Nat} :
l.eraseIdx i = [] ↔ l = [] ∨ l.length = 1 ∧ i = 0h
huList.eraseIdx_ne_nil_iff}(hj0	  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Erase.htmlhtheorem List.eraseIdx_ne_nil_iff {α : Type u_1} {l : List α} {i : Nat} :
l.eraseIdx i ≠ [] ↔ 2 ≤ l.length ∨ l.length = 1 ∧ i ≠ 0h
huList.eraseIdx_sublist}(hj4	  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Erase.htmlh`theorem List.eraseIdx_sublist {α : Type u_1} (l : List α) (k : Nat) :
(l.eraseIdx k).Sublist lh
huList.mem_of_mem_eraseIdx}(hj8	  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Erase.htmlhttheorem List.mem_of_mem_eraseIdx {α : Type u_1} {l : List α} {i : Nat} {a : α} (h : a ∈ l.eraseIdx i) :
a ∈ lh
huList.eraseIdx_subset}(hj<	  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Erase.htmlhYtheorem List.eraseIdx_subset {α : Type u_1} {l : List α} {k : Nat} :
l.eraseIdx k ⊆ lh
huList.eraseIdx_eq_self}(hj@	  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Erase.htmlhktheorem List.eraseIdx_eq_self {α : Type u_1} {l : List α} {k : Nat} :
l.eraseIdx k = l ↔ l.length ≤ kh
huList.eraseIdx_of_length_le}(hjD	  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Erase.htmlhrtheorem List.eraseIdx_of_length_le {α : Type u_1} {l : List α} {k : Nat} (h : l.length ≤ k) :
l.eraseIdx k = lh
huList.length_eraseIdx_le}(hjH	  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Erase.htmlhltheorem List.length_eraseIdx_le {α : Type u_1} (l : List α) (i : Nat) :
(l.eraseIdx i).length ≤ l.lengthh
huList.le_length_eraseIdx}(hjL	  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Erase.htmlhptheorem List.le_length_eraseIdx {α : Type u_1} (l : List α) (i : Nat) :
l.length - 1 ≤ (l.eraseIdx i).lengthh
hu!List.eraseIdx_append_of_lt_length}(hjP	  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Erase.htmlhtheorem List.eraseIdx_append_of_lt_length {α : Type u_1} {l : List α} {k : Nat} (hk : k < l.length) (l' : List α) :
(l ++ l').eraseIdx k = l.eraseIdx k ++ l'h
hu!List.eraseIdx_append_of_length_le}(hjT	  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Erase.htmlhtheorem List.eraseIdx_append_of_length_le {α : Type u_1} {l : List α} {k : Nat} (hk : l.length ≤ k) (l' : List α) :
(l ++ l').eraseIdx k = l ++ l'.eraseIdx (k - l.length)h
huList.eraseIdx_append}(hjX	  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Erase.htmlhtheorem List.eraseIdx_append {α✝ : Type u_1} {l l' : List α✝} {k : Nat} :
(l ++ l').eraseIdx k = if k < l.length then l.eraseIdx k ++ l' else l ++ l'.eraseIdx (k - l.length)h
huList.eraseIdx_replicate}(hj\	  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Erase.htmlhtheorem List.eraseIdx_replicate {α : Type u_1} {n : Nat} {a : α} {k : Nat} :
(replicate n a).eraseIdx k = if k < n then replicate (n - 1) a else replicate n ah
huList.erase_eq_eraseIdx_of_idxOf}(hj`	  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Erase.htmlhtheorem List.erase_eq_eraseIdx_of_idxOf {α : Type u_1} [BEq α] [LawfulBEq α] {l : List α} {a : α} {i : Nat} (w : idxOf a l = i) :
l.erase a = l.eraseIdx ih
hu
List.setTR}(hjd	  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Impl.htmlhIdef List.setTR {α : Type u_1} (l : List α) (n : Nat) (a : α) :
List αh
Replaces the value at (zero-based) index n in l with a. If the index is out of bounds, then the list is returned unmodified.
This is a tail-recursive version of List.set that's used at runtime.
Examples:uList.set_eq_setTR}(hji	  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Impl.htmlh)theorem List.set_eq_setTR :
@set = @setTRh
huList.filterMapTR}(hjm	  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Impl.htmlhcdef List.filterMapTR {α : Type u_1} {β : Type u_2} (f : α → Option β) (l : List α) :
List βh
Applies a function that returns an Option to each element of a list, collecting the non-none values.
O(|l|). This is a tail-recursive version of List.filterMap, used at runtime.
Example:uList.filterMap_eq_filterMapTR}(hjr	  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Impl.htmlhAtheorem List.filterMap_eq_filterMapTR :
@filterMap = @filterMapTRh
huList.foldrTR}(hjv	  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Impl.htmlhfdef List.foldrTR {α : Type u_1} {β : Type u_2} (f : α → β → β) (init : β) (l : List α) :
βh
X
  Folds a function over a list from the right, accumulating a value starting with init. The accumulated value is combined with the each element of the list in reverse order, using f.
O(|l|). This is the tail-recursive replacement for List.foldr in runtime code.
Examples:uList.foldr_eq_foldrTR}(hj{	  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Impl.htmlh1theorem List.foldr_eq_foldrTR :
@foldr = @foldrTRh
huList.flatMapTR}(hj	  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Impl.htmlh`def List.flatMapTR {α : Type u_1} {β : Type u_2} (f : α → List β) (as : List α) :
List βh
Applies a function that returns a list to each element of a list, and concatenates the resulting lists.
This is the tail-recursive version of List.flatMap that's used at runtime.
Examples:uList.flatMap_eq_flatMapTR}(hj	  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Impl.htmlh9theorem List.flatMap_eq_flatMapTR :
@flatMap = @flatMapTRh
huList.flattenTR}(hj	  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Impl.htmlhAdef List.flattenTR {α : Type u_1} (l : List (List α)) :
List αh
Concatenates a list of lists into a single list, preserving the order of the elements.
O(|flatten L|). This is a tail-recursive version of List.flatten, used in runtime code.
Examples:uList.flatten_eq_flattenTR}(hj	  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Impl.htmlh9theorem List.flatten_eq_flattenTR :
@flatten = @flattenTRh
huList.takeTR}(hj	  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Impl.htmlhAdef List.takeTR {α : Type u_1} (n : Nat) (l : List α) :
List αh
Extracts the first n elements of xs, or the whole list if n is greater than xs.length.
O(min n |xs|). This is a tail-recursive version of List.take, used at runtime.
Examples:uList.take_eq_takeTR}(hj	  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Impl.htmlh-theorem List.take_eq_takeTR :
@take = @takeTRh
huList.takeWhileTR}(hj	  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Impl.htmlhNdef List.takeWhileTR {α : Type u_1} (p : α → Bool) (l : List α) :
List αh
Returns the longest initial segment of xs for which p returns true.
O(|xs|). This is a tail-recursive version of List.take, used at runtime.
Examples:uList.takeWhile_eq_takeWhileTR}(hj	  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Impl.htmlhAtheorem List.takeWhile_eq_takeWhileTR :
@takeWhile = @takeWhileTRh
huList.dropLastTR}(hj	  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Impl.htmlh;def List.dropLastTR {α : Type u_1} (l : List α) :
List αh
Removes the last element of the list, if one exists.
This is a tail-recursive version of List.dropLast, used at runtime.
Examples:uList.dropLast_eq_dropLastTR}(hj	  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Impl.htmlh=theorem List.dropLast_eq_dropLastTR :
@dropLast = @dropLastTRh
huList.findRev?TR}(hj	  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Impl.htmlhOdef List.findRev?TR {α : Type u_1} (p : α → Bool) (l : List α) :
Option αh
HTail recursive implementation of findRev?. This is only used at runtime.uList.find?_singleton}(hj	  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Impl.htmlh{theorem List.find?_singleton {α : Type u_1} {p : α → Bool} {a : α} :
find? p [a] = if p a = true then some a else noneh
huList.find?_append}(hj	  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Impl.htmlhtheorem List.find?_append {α : Type u_1} {p : α → Bool} {xs ys : List α} :
find? p (xs ++ ys) = (find? p xs).or (find? p ys)h
huList.findRev?_eq_findRev?TR}(hj	  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Impl.htmlh=theorem List.findRev?_eq_findRev?TR :
@findRev? = @findRev?TRh
huList.findRev?_eq_find?_reverse}(hj	  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Impl.htmlhytheorem List.findRev?_eq_find?_reverse {α : Type u_1} {l : List α} {p : α → Bool} :
findRev? p l = find? p l.reverseh
huList.findSomeRev?TR}(hj	  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Impl.htmlhhdef List.findSomeRev?TR {α : Type u_1} {β : Type u_2} (f : α → Option β) (l : List α) :
Option βh
LTail recursive implementation of finSomedRev?. This is only used at runtime.uList.findSome?_singleton}(hj	  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Impl.htmlh~theorem List.findSome?_singleton {α : Type u_1} {α✝ : Type u_2} {f : α → Option α✝} {a : α} :
findSome? f [a] = f ah
huList.findSome?_append}(hj	  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Impl.htmlhtheorem List.findSome?_append {α : Type u_1} {α✝ : Type u_2} {f : α → Option α✝} {xs ys : List α} :
findSome? f (xs ++ ys) = (findSome? f xs).or (findSome? f ys)h
hu#List.findSomeRev?_eq_findSomeRev?TR}(hj	  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Impl.htmlhMtheorem List.findSomeRev?_eq_findSomeRev?TR :
@findSomeRev? = @findSomeRev?TRh
hu&List.findSomeRev?_eq_findSome?_reverse}(hj	  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Impl.htmlhtheorem List.findSomeRev?_eq_findSome?_reverse {α : Type u_1} {β : Type u_2} {l : List α} {f : α → Option β} :
findSomeRev? f l = findSome? f l.reverseh
huList.replaceTR}(hj	  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Impl.htmlhNdef List.replaceTR {α : Type u_1} [BEq α] (l : List α) (b c : α) :
List αh
Replaces the first element of the list l that is equal to a with b. If no element is equal to a, then the list is returned unchanged.
O(|l|). This is a tail-recursive version of List.replace that's used in runtime code.
Examples:uList.replace_eq_replaceTR}(hj	  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Impl.htmlh9theorem List.replace_eq_replaceTR :
@replace = @replaceTRh
hu
List.modifyTR}(hj	  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Impl.htmlhSdef List.modifyTR {α : Type u_1} (l : List α) (i : Nat) (f : α → α) :
List αh
Replaces the element at the given index, if it exists, with the result of applying f to it.
This is a tail-recursive version of List.modify.
Examples:uList.modify_eq_modifyTR}(hj	  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Impl.htmlh5theorem List.modify_eq_modifyTR :
@modify = @modifyTRh
huList.insertIdxTR}(hj	  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Impl.htmlhOdef List.insertIdxTR {α : Type u_1} (l : List α) (n : Nat) (a : α) :
List αh
X=  Inserts an element into a list at the specified index. If the index is greater than the length of the list, then the list is returned unmodified.
In other words, the new element is inserted into the list l after the first i elements of l.
This is a tail-recursive version of List.insertIdx, used at runtime.
Examples:uList.insertIdx_eq_insertIdxTR}(hj	  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Impl.htmlhAtheorem List.insertIdx_eq_insertIdxTR :
@insertIdx = @insertIdxTRh
huList.eraseTR}(hj	  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Impl.htmlhJdef List.eraseTR {α : Type u_1} [BEq α] (l : List α) (a : α) :
List αh
Removes the first occurrence of a from l. If a does not occur in l, the list is returned unmodified.
O(|l|).
This is a tail-recursive version of List.erase, used in runtime code.
Examples:uList.erase_eq_eraseTR}(hj	  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Impl.htmlh6theorem List.erase_eq_eraseTR :
@List.erase = @eraseTRh
hu
List.erasePTR}(hj	  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Impl.htmlhKdef List.erasePTR {α : Type u_1} (p : α → Bool) (l : List α) :
List αh
Removes the first element of a list for which p returns true. If no element satisfies p, then the list is returned unchanged.
This is a tail-recursive version of eraseP, used at runtime.
Examples:uList.eraseP_eq_erasePTR}(hj	  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Impl.htmlh5theorem List.eraseP_eq_erasePTR :
@eraseP = @erasePTRh
huList.eraseIdxTR}(hj
  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Impl.htmlhEdef List.eraseIdxTR {α : Type u_1} (l : List α) (n : Nat) :
List αh
Removes the element at the specified index. If the index is out of bounds, the list is returned unmodified.
O(i).
This is a tail-recursive version of List.eraseIdx, used at runtime.
Examples:uList.eraseIdx_eq_eraseIdxTR}(hj
  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Impl.htmlh=theorem List.eraseIdx_eq_eraseIdxTR :
@eraseIdx = @eraseIdxTRh
huList.zipWithTR}(hj
  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Impl.htmlhdef List.zipWithTR {α : Type u_1} {β : Type u_2} {γ : Type u_3} (f : α → β → γ) (as : List α) (bs : List β) :
List γh
Applies a function to the corresponding elements of two lists, stopping at the end of the shorter list.
O(min |xs| |ys|). This is a tail-recursive version of List.zipWith that's used at runtime.
Examples:uList.zipWith_eq_zipWithTR}(hj
  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Impl.htmlh9theorem List.zipWith_eq_zipWithTR :
@zipWith = @zipWithTRh
hu
List.zipIdxTR}(hj
  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Impl.htmlhQdef List.zipIdxTR {α : Type u_1} (l : List α) (n : Nat := 0) :
List (α × Nat)h
Pairs each element of a list with its index, optionally starting from an index other than 0.
O(|l|). This is a tail-recursive version of List.zipIdx that's used at runtime.
Examples:uList.zipIdx_eq_zipIdxTR}(hj
  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Impl.htmlh5theorem List.zipIdx_eq_zipIdxTR :
@zipIdx = @zipIdxTRh
huList.intercalateTR}(hj
  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Impl.htmlhVdef List.intercalateTR {α : Type u_1} (sep : List α) (xs : List (List α)) :
List αh
Alternates the lists in xs with the separator sep.
This is a tail-recursive version of List.intercalate used at runtime.
Examples:u!List.intercalate_eq_intercalateTR}(hj#
  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Impl.htmlhItheorem List.intercalate_eq_intercalateTR :
@intercalate = @intercalateTRh
huList.instLawfulOrderLTOfAsymmLt}(hj'
  hLhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lex.htmlhinstance List.instLawfulOrderLTOfAsymmLt {α : Type u_1} [LT α] [Std.Asymm fun (x1 x2 : List α) => x1 < x2] :
Std.LawfulOrderLT (List α)h
huList.lex_lt}(hj+
  hLhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lex.htmlhtheorem List.lex_lt {α : Type u_1} [LT α] {l₁ l₂ : List α} :
Lex (fun (x1 x2 : α) => x1 < x2) l₁ l₂ ↔ l₁ < l₂h
huList.not_lex_lt}(hj/
  hLhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lex.htmlhtheorem List.not_lex_lt {α : Type u_1} [LT α] {l₁ l₂ : List α} :
¬Lex (fun (x1 x2 : α) => x1 < x2) l₁ l₂ ↔ l₂ ≤ l₁h
huList.not_lt_iff_ge}(hj3
  hLhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lex.htmlhjtheorem List.not_lt_iff_ge {α : Type u_1} [LT α] {l₁ l₂ : List α} :
¬l₁ < l₂ ↔ l₂ ≤ l₁h
huList.not_le_iff_gt}(hj7
  hLhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lex.htmlhjtheorem List.not_le_iff_gt {α : Type u_1} [LT α] {l₁ l₂ : List α} :
¬l₁ ≤ l₂ ↔ l₂ < l₁h
huList.lex_irrefl}(hj;
  hLhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lex.htmlh}theorem List.lex_irrefl {α : Type u_1} {r : α → α → Prop} (irrefl : ∀ (x : α), ¬r x x) (l : List α) :
¬Lex r l lh
huList.lt_irrefl}(hj?
  hLhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lex.htmlhotheorem List.lt_irrefl {α : Type u_1} [LT α] [Std.Irrefl fun (x1 x2 : α) => x1 < x2] (l : List α) :
¬l < lh
hu
List.ltIrrefl}(hjC
  hLhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lex.htmlhinstance List.ltIrrefl {α : Type u_1} [LT α] [Std.Irrefl fun (x1 x2 : α) => x1 < x2] :
Std.Irrefl fun (x1 x2 : List α) => x1 < x2h
huList.not_lex_nil}(hjG
  hLhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lex.htmlhjtheorem List.not_lex_nil {α✝ : Type u_1} {r : α✝ → α✝ → Prop} {l : List α✝} :
¬Lex r l []h
huList.not_lt_nil}(hjK
  hLhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lex.htmlhHtheorem List.not_lt_nil {α : Type u_1} [LT α] (l : List α) :
¬l < []h
huList.nil_le}(hjO
  hLhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lex.htmlhDtheorem List.nil_le {α : Type u_1} [LT α] (l : List α) :
[] ≤ lh
huList.not_nil_lex_iff}(hjS
  hLhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lex.htmlhytheorem List.not_nil_lex_iff {α✝ : Type u_1} {r : α✝ → α✝ → Prop} {l : List α✝} :
¬Lex r [] l ↔ l = []h
huList.le_nil}(hjW
  hLhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lex.htmlhOtheorem List.le_nil {α : Type u_1} [LT α] {l : List α} :
l ≤ [] ↔ l = []h
huList.nil_lex_cons'}(hj[
  hLhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lex.htmlh}theorem List.nil_lex_cons' {α✝ : Type u_1} {r : α✝ → α✝ → Prop} {a : α✝} {l : List α✝} :
Lex r [] (a :: l)h
huList.nil_lt_cons}(hj_
  hLhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lex.htmlhUtheorem List.nil_lt_cons {α : Type u_1} [LT α] (a : α) (l : List α) :
[] < a :: lh
huList.cons_lex_cons_iff}(hjc
  hLhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lex.htmlhtheorem List.cons_lex_cons_iff {α✝ : Type u_1} {r : α✝ → α✝ → Prop} {a : α✝} {l₁ : List α✝} {b : α✝} {l₂ : List α✝} :
Lex r (a :: l₁) (b :: l₂) ↔ r a b ∨ a = b ∧ Lex r l₁ l₂h
huList.cons_lt_cons_iff}(hjg
  hLhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lex.htmlhtheorem List.cons_lt_cons_iff {α : Type u_1} [LT α] {a b : α} {l₁ l₂ : List α} :
a :: l₁ < b :: l₂ ↔ a < b ∨ a = b ∧ l₁ < l₂h
huList.cons_lt_cons_self}(hjk
  hLhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lex.htmlhtheorem List.cons_lt_cons_self {α : Type u_1} {a : α} [LT α] [i₀ : Std.Irrefl fun (x1 x2 : α) => x1 < x2] {l₁ l₂ : List α} :
a :: l₁ < a :: l₂ ↔ l₁ < l₂h
huList.not_cons_lex_cons_iff}(hjo
  hLhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lex.htmlhtheorem List.not_cons_lex_cons_iff {α : Type u_1} {r : α → α → Prop} [DecidableEq α] [DecidableRel r] {a b : α} {l₁ l₂ : List α} :
¬Lex r (a :: l₁) (b :: l₂) ↔ ¬r a b ∧ a ≠ b ∨ ¬r a b ∧ ¬Lex r l₁ l₂h
huList.cons_le_cons_iff}(hjs
  hLhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lex.htmlhtheorem List.cons_le_cons_iff {α : Type u_1} [LT α] [i₁ : Std.Asymm fun (x1 x2 : α) => x1 < x2] [i₂ : Std.Antisymm fun (x1 x2 : α) => ¬x1 < x2] {a b : α} {l₁ l₂ : List α} :
a :: l₁ ≤ b :: l₂ ↔ a < b ∨ a = b ∧ l₁ ≤ l₂h
huList.not_lt_of_cons_le_cons}(hjw
  hLhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lex.htmlhtheorem List.not_lt_of_cons_le_cons {α : Type u_1} [LT α] [i₁ : Std.Asymm fun (x1 x2 : α) => x1 < x2] [i₂ : Std.Antisymm fun (x1 x2 : α) => ¬x1 < x2] {a b : α} {l₁ l₂ : List α} (h : a :: l₁ ≤ b :: l₂) :
¬b < ah
hu!List.left_le_left_of_cons_le_cons}(hj{
  hLhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lex.htmlhtheorem List.left_le_left_of_cons_le_cons {α : Type u_1} [LT α] [LE α] [Std.IsLinearOrder α] [Std.LawfulOrderLT α] {a b : α} {l₁ l₂ : List α} (h : a :: l₁ ≤ b :: l₂) :
a ≤ bh
huList.le_of_cons_le_cons}(hj
  hLhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lex.htmlhX  theorem List.le_of_cons_le_cons {α : Type u_1} [LT α] [i₀ : Std.Irrefl fun (x1 x2 : α) => x1 < x2] [i₁ : Std.Asymm fun (x1 x2 : α) => x1 < x2] [i₂ : Std.Antisymm fun (x1 x2 : α) => ¬x1 < x2] {a : α} {l₁ l₂ : List α} (h : a :: l₁ ≤ a :: l₂) :
l₁ ≤ l₂h
huList.le_refl}(hj
  hLhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lex.htmlhttheorem List.le_refl {α : Type u_1} [LT α] [i₀ : Std.Irrefl fun (x1 x2 : α) => x1 < x2] (l : List α) :
l ≤ lh
huList.instReflLeOfIrreflLt}(hj
  hLhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lex.htmlhinstance List.instReflLeOfIrreflLt {α : Type u_1} [LT α] [Std.Irrefl fun (x1 x2 : α) => x1 < x2] :
Std.Refl fun (x1 x2 : List α) => x1 ≤ x2h
huList.lex_trans}(hj
  hLhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lex.htmlhtheorem List.lex_trans {α : Type u_1} {l₁ l₂ l₃ : List α} {r : α → α → Prop} (lt_trans : ∀ {x y z : α}, r x y → r y z → r x z) (h₁ : Lex r l₁ l₂) (h₂ : Lex r l₂ l₃) :
Lex r l₁ l₃h
hu
List.lt_trans}(hj
  hLhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lex.htmlhtheorem List.lt_trans {α : Type u_1} [LT α] [i₁ : Trans (fun (x1 x2 : α) => x1 < x2) (fun (x1 x2 : α) => x1 < x2) fun (x1 x2 : α) => x1 < x2] {l₁ l₂ l₃ : List α} (h₁ : l₁ < l₂) (h₂ : l₂ < l₃) :
l₁ < l₃h
huList.instTransLt}(hj
  hLhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lex.htmlhX   instance List.instTransLt {α : Type u_1} [LT α] [Trans (fun (x1 x2 : α) => x1 < x2) (fun (x1 x2 : α) => x1 < x2) fun (x1 x2 : α) => x1 < x2] :
Trans (fun (x1 x2 : List α) => x1 < x2) (fun (x1 x2 : List α) => x1 < x2) fun (x1 x2 : List α) => x1 < x2h
huList.lt_of_le_of_lt}(hj
  hLhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lex.htmlhtheorem List.lt_of_le_of_lt {α : Type u_1} [LT α] [LE α] [Std.IsLinearOrder α] [Std.LawfulOrderLT α] {l₁ l₂ l₃ : List α} (h₁ : l₁ ≤ l₂) (h₂ : l₂ < l₃) :
l₁ < l₃h
huList.lt_of_le_of_lt'}(hj
  hLhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lex.htmlhXD  theorem List.lt_of_le_of_lt' {α : Type u_1} [LT α] [Std.Asymm fun (x1 x2 : α) => x1 < x2] [Std.Antisymm fun (x1 x2 : α) => ¬x1 < x2] [Trans (fun (x1 x2 : α) => ¬x1 < x2) (fun (x1 x2 : α) => ¬x1 < x2) fun (x1 x2 : α) => ¬x1 < x2] {l₁ l₂ l₃ : List α} (h₁ : l₁ ≤ l₂) (h₂ : l₂ < l₃) :
l₁ < l₃h
hu
List.le_trans}(hj
  hLhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lex.htmlhtheorem List.le_trans {α : Type u_1} [LT α] [LE α] [Std.IsLinearOrder α] [Std.LawfulOrderLT α] {l₁ l₂ l₃ : List α} (h₁ : l₁ ≤ l₂) (h₂ : l₂ ≤ l₃) :
l₁ ≤ l₃h
huList.le_trans'}(hj
  hLhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lex.htmlhXB  theorem List.le_trans' {α : Type u_1} [LT α] [Std.Asymm fun (x1 x2 : α) => x1 < x2] [Std.Antisymm fun (x1 x2 : α) => ¬x1 < x2] [Trans (fun (x1 x2 : α) => ¬x1 < x2) (fun (x1 x2 : α) => ¬x1 < x2) fun (x1 x2 : α) => ¬x1 < x2] {l₁ l₂ l₃ : List α} (h₁ : l₁ ≤ l₂) (h₂ : l₂ ≤ l₃) :
l₁ ≤ l₃h
hu.List.instTransLeOfIsLinearOrderOfLawfulOrderLT}(hj
  hLhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lex.htmlhinstance List.instTransLeOfIsLinearOrderOfLawfulOrderLT {α : Type u_1} [LT α] [LE α] [Std.IsLinearOrder α] [Std.LawfulOrderLT α] :
Trans (fun (x1 x2 : List α) => x1 ≤ x2) (fun (x1 x2 : List α) => x1 ≤ x2) fun (x1 x2 : List α) => x1 ≤ x2h
huList.lex_asymm}(hj
  hLhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lex.htmlhtheorem List.lex_asymm {α : Type u_1} {r : α → α → Prop} (h : ∀ {x y : α}, r x y → ¬r y x) {l₁ l₂ : List α} :
Lex r l₁ l₂ → ¬Lex r l₂ l₁h
hu
List.lt_asymm}(hj
  hLhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lex.htmlhtheorem List.lt_asymm {α : Type u_1} [LT α] [i : Std.Asymm fun (x1 x2 : α) => x1 < x2] {l₁ l₂ : List α} (h : l₁ < l₂) :
¬l₂ < l₁h
huList.instAsymmLt}(hj
  hLhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lex.htmlhinstance List.instAsymmLt {α : Type u_1} [LT α] [Std.Asymm fun (x1 x2 : α) => x1 < x2] :
Std.Asymm fun (x1 x2 : List α) => x1 < x2h
huList.not_lex_total}(hj
  hLhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lex.htmlhtheorem List.not_lex_total {α : Type u_1} {r : α → α → Prop} (h : ∀ (x y : α), ¬r x y ∨ ¬r y x) (l₁ l₂ : List α) :
¬Lex r l₁ l₂ ∨ ¬Lex r l₂ l₁h
hu
List.le_total}(hj
  hLhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lex.htmlhtheorem List.le_total {α : Type u_1} [LT α] [i : Std.Asymm fun (x1 x2 : α) => x1 < x2] (l₁ l₂ : List α) :
l₁ ≤ l₂ ∨ l₂ ≤ l₁h
huList.le_total_of_asymm}(hj
  hLhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lex.htmlhtheorem List.le_total_of_asymm {α : Type u_1} [LT α] [i : Std.Asymm fun (x1 x2 : α) => x1 < x2] (l₁ l₂ : List α) :
l₁ ≤ l₂ ∨ l₂ ≤ l₁h
huList.instTotalLeOfAsymmLt}(hj
  hLhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lex.htmlhinstance List.instTotalLeOfAsymmLt {α : Type u_1} [LT α] [Std.Asymm fun (x1 x2 : α) => x1 < x2] :
Std.Total fun (x1 x2 : List α) => x1 ≤ x2h
huList.instIsLinearOrder}(hj
  hLhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lex.htmlhinstance List.instIsLinearOrder {α : Type u_1} [LT α] [LE α] [Std.IsLinearOrder α] [Std.LawfulOrderLT α] :
Std.IsLinearOrder (List α)h
huList.not_lt}(hj
  hLhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lex.htmlhctheorem List.not_lt {α : Type u_1} [LT α] {l₁ l₂ : List α} :
¬l₁ < l₂ ↔ l₂ ≤ l₁h
huList.not_le}(hj
  hLhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lex.htmlhctheorem List.not_le {α : Type u_1} [LT α] {l₁ l₂ : List α} :
¬l₂ ≤ l₁ ↔ l₁ < l₂h
hu
List.le_of_lt}(hj
  hLhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lex.htmlhtheorem List.le_of_lt {α : Type u_1} [LT α] [i : Std.Asymm fun (x1 x2 : α) => x1 < x2] {l₁ l₂ : List α} (h : l₁ < l₂) :
l₁ ≤ l₂h
huList.le_iff_lt_or_eq}(hj
  hLhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lex.htmlhtheorem List.le_iff_lt_or_eq {α : Type u_1} [LT α] [Std.Irrefl fun (x1 x2 : α) => x1 < x2] [Std.Antisymm fun (x1 x2 : α) => ¬x1 < x2] [Std.Asymm fun (x1 x2 : α) => x1 < x2] {l₁ l₂ : List α} :
l₁ ≤ l₂ ↔ l₁ < l₂ ∨ l₁ = l₂h
huList.lex_eq_decide_lex}(hj
  hLhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lex.htmlhtheorem List.lex_eq_decide_lex {α : Type u_1} {l₁ l₂ : List α} [BEq α] [LawfulBEq α] [DecidableEq α] (lt : α → α → Bool) :
l₁.lex l₂ lt = decide (Lex (fun (x y : α) => lt x y = true) l₁ l₂)h
huList.lex_eq_true_iff_lex}(hj
  hLhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lex.htmlhtheorem List.lex_eq_true_iff_lex {α : Type u_1} {l₁ l₂ : List α} [BEq α] [LawfulBEq α] (lt : α → α → Bool) :
l₁.lex l₂ lt = true ↔ Lex (fun (x y : α) => lt x y = true) l₁ l₂h
9Variant of lex_eq_true_iff using an arbitrary comparator.uList.lex_eq_false_iff_not_lex}(hj
  hLhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lex.htmlhtheorem List.lex_eq_false_iff_not_lex {α : Type u_1} {l₁ l₂ : List α} [BEq α] [LawfulBEq α] (lt : α → α → Bool) :
l₁.lex l₂ lt = false ↔ ¬Lex (fun (x y : α) => lt x y = true) l₁ l₂h
:Variant of lex_eq_false_iff using an arbitrary comparator.uList.lex_eq_true_iff_lt}(hj
  hLhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lex.htmlhtheorem List.lex_eq_true_iff_lt {α : Type u_1} [BEq α] [LawfulBEq α] [LT α] [DecidableLT α] {l₁ l₂ : List α} :
(l₁.lex l₂ fun (x1 x2 : α) => decide (x1 < x2)) = true ↔ l₁ < l₂h
huList.lex_eq_false_iff_ge}(hj
  hLhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lex.htmlhtheorem List.lex_eq_false_iff_ge {α : Type u_1} [BEq α] [LawfulBEq α] [LT α] [DecidableLT α] {l₁ l₂ : List α} :
(l₁.lex l₂ fun (x1 x2 : α) => decide (x1 < x2)) = false ↔ l₂ ≤ l₁h
huList.lex_eq_true_iff_exists}(hj
  hLhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lex.htmlhX  theorem List.lex_eq_true_iff_exists {α : Type u_1} {l₁ l₂ : List α} [BEq α] (lt : α → α → Bool) :
l₁.lex l₂ lt = true ↔ (l₁.isEqv (take l₁.length l₂) fun (x1 x2 : α) => x1 == x2) = true ∧ l₁.length < l₂.length ∨ ∃ (i : Nat), ∃ (h₁ : i < l₁.length), ∃ (h₂ : i < l₂.length), (∀ (j : Nat) (hj : j < i), (l₁[j] == l₂[j]) = true) ∧ lt l₁[i] l₂[i] = trueh
2l₁ is lexicographically less than l₂ if eitheruList.lex_eq_false_iff_exists}(hj
  hLhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lex.htmlhXf  theorem List.lex_eq_false_iff_exists {α : Type u_1} {l₁ l₂ : List α} [BEq α] [PartialEquivBEq α] (lt : α → α → Bool) (lt_irrefl : ∀ (x y : α), (x == y) = true → lt x y = false) (lt_asymm : ∀ (x y : α), lt x y = true → lt y x = false) (lt_antisymm : ∀ (x y : α), lt x y = false → lt y x = false → (x == y) = true) :
l₁.lex l₂ lt = false ↔ (l₂.isEqv (take l₂.length l₁) fun (x1 x2 : α) => x1 == x2) = true ∨ ∃ (i : Nat), ∃ (h₁ : i < l₁.length), ∃ (h₂ : i < l₂.length), (∀ (j : Nat) (hj : j < i), (l₁[j] == l₂[j]) = true) ∧ lt l₂[i] l₁[i] = trueh
l₁ is not lexicographically less than l₂ (which you might think of as "l₂ is lexicographically greater than or equal to l₁"") if either
This formulation requires that == and lt are compatible in the following senses:uList.lt_iff_exists}(hj
  hLhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lex.htmlhX*  theorem List.lt_iff_exists {α : Type u_1} [LT α] {l₁ l₂ : List α} :
l₁ < l₂ ↔ l₁ = take l₁.length l₂ ∧ l₁.length < l₂.length ∨ ∃ (i : Nat), ∃ (h₁ : i < l₁.length), ∃ (h₂ : i < l₂.length), (∀ (j : Nat) (hj : j < i), l₁[j] = l₂[j]) ∧ l₁[i] < l₂[i]h
huList.le_iff_exists}(hj
  hLhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lex.htmlhXc  theorem List.le_iff_exists {α : Type u_1} [LT α] [Std.Asymm fun (x1 x2 : α) => x1 < x2] [Std.Antisymm fun (x1 x2 : α) => ¬x1 < x2] {l₁ l₂ : List α} :
l₁ ≤ l₂ ↔ l₁ = take l₁.length l₂ ∨ ∃ (i : Nat), ∃ (h₁ : i < l₁.length), ∃ (h₂ : i < l₂.length), (∀ (j : Nat) (hj : j < i), l₁[j] = l₂[j]) ∧ l₁[i] < l₂[i]h
huList.append_left_lt}(hj  hLhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lex.htmlh~theorem List.append_left_lt {α : Type u_1} [LT α] {l₁ l₂ l₃ : List α} (h : l₂ < l₃) :
l₁ ++ l₂ < l₁ ++ l₃h
huList.append_left_le}(hj  hLhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lex.htmlhtheorem List.append_left_le {α : Type u_1} [LT α] [Std.Asymm fun (x1 x2 : α) => x1 < x2] [Std.Antisymm fun (x1 x2 : α) => ¬x1 < x2] {l₁ l₂ l₃ : List α} (h : l₂ ≤ l₃) :
l₁ ++ l₂ ≤ l₁ ++ l₃h
huList.le_append_left}(hj  hLhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lex.htmlhtheorem List.le_append_left {α : Type u_1} [LT α] [Std.Irrefl fun (x1 x2 : α) => x1 < x2] {l₁ l₂ : List α} :
l₁ ≤ l₁ ++ l₂h
huList.map_lt}(hj  hLhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lex.htmlhtheorem List.map_lt {α : Type u_1} {β : Type u_2} [LT α] [LT β] {l₁ l₂ : List α} {f : α → β} (w : ∀ (x y : α), x < y → f x < f y) (h : l₁ < l₂) :
map f l₁ < map f l₂h
huList.map_le}(hj  hLhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lex.htmlhXm  theorem List.map_le {α : Type u_1} {β : Type u_2} [LT α] [LT β] [Std.Asymm fun (x1 x2 : α) => x1 < x2] [Std.Antisymm fun (x1 x2 : α) => ¬x1 < x2] [Std.Asymm fun (x1 x2 : β) => x1 < x2] [Std.Antisymm fun (x1 x2 : β) => ¬x1 < x2] {l₁ l₂ : List α} {f : α → β} (w : ∀ (x y : α), x < y → f x < f y) (h : l₁ ≤ l₂) :
map f l₁ ≤ map f l₂      h
hu
List.min?_nil}(hj  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/MinMax.htmlh?theorem List.min?_nil {α : Type u_1} [Min α] :
[].min? = noneh
huList.min?_cons'}(hj  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/MinMax.htmlhqtheorem List.min?_cons' {α : Type u_1} {x : α} [Min α] {xs : List α} :
(x :: xs).min? = some (foldl min x xs)h
huList.min?_cons}(hj  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/MinMax.htmlhtheorem List.min?_cons {α : Type u_1} {x : α} [Min α] [Std.Associative min] {xs : List α} :
(x :: xs).min? = some (xs.min?.elim x (min x))h
huList.min?_eq_none_iff}(hj#  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/MinMax.htmlhbtheorem List.min?_eq_none_iff {α : Type u_1} {xs : List α} [Min α] :
xs.min? = none ↔ xs = []h
huList.isSome_min?_of_mem}(hj'  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/MinMax.htmlhttheorem List.isSome_min?_of_mem {α : Type u_1} {l : List α} [Min α] {a : α} (h : a ∈ l) :
l.min?.isSome = trueh
huList.min?_eq_head?}(hj+  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/MinMax.htmlhtheorem List.min?_eq_head? {α : Type u} [Min α] {l : List α} (h : Pairwise (fun (a b : α) => min a b = a) l) :
l.min? = l.head?h
hu
List.min?_mem}(hj/  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/MinMax.htmlhwtheorem List.min?_mem {α : Type u_1} {a : α} [Min α] [Std.MinEqOr α] {xs : List α} :
xs.min? = some a → a ∈ xsh
huList.le_min?_iff}(hj3  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/MinMax.htmlhtheorem List.le_min?_iff {α : Type u_1} {a : α} [Min α] [LE α] [Std.LawfulOrderInf α] {xs : List α} :
xs.min? = some a → ∀ {x : α}, x ≤ a ↔ ∀ (b : α), b ∈ xs → x ≤ bh
huList.min?_eq_some_iff}(hj7  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/MinMax.htmlhtheorem List.min?_eq_some_iff {α : Type u_1} {a : α} [Min α] [LE α] {xs : List α} [Std.IsLinearOrder α] [Std.LawfulOrderMin α] :
xs.min? = some a ↔ a ∈ xs ∧ ∀ (b : α), b ∈ xs → a ≤ bh
huList.min?_eq_min?_attach}(hj;  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/MinMax.htmlhtheorem List.min?_eq_min?_attach {α : Type u_1} [Min α] [Std.MinEqOr α] {xs : List α} :
xs.min? = Option.map Subtype.val xs.attach.min?h
huList.min?_eq_some_iff_subtype}(hj?  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/MinMax.htmlhX
  theorem List.min?_eq_some_iff_subtype {α : Type u_1} {a : α} [Min α] [LE α] {xs : List α} [Std.MinEqOr α] [Std.IsLinearOrder { x : α // x ∈ xs }] [Std.LawfulOrderMin { x : α // x ∈ xs }] :
xs.min? = some a ↔ a ∈ xs ∧ ∀ (b : α), b ∈ xs → a ≤ bh
huList.min?_replicate}(hjC  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/MinMax.htmlhtheorem List.min?_replicate {α : Type u_1} [Min α] [Std.IdempotentOp min] {n : Nat} {a : α} :
(replicate n a).min? = if n = 0 then none else some ah
huList.min?_replicate_of_pos}(hjG  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/MinMax.htmlhtheorem List.min?_replicate_of_pos {α : Type u_1} [Min α] [Std.MinEqOr α] {n : Nat} {a : α} (h : 0 < n) :
(replicate n a).min? = some ah
huList.foldl_min}(hjK  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/MinMax.htmlhtheorem List.foldl_min {α : Type u_1} [Min α] [Std.IdempotentOp min] [Std.Associative min] {l : List α} {a : α} :
foldl min a l = min a (l.min?.getD a)h
]Requirements are satisfied for [OrderData α] [Min α] [IsLinearOrder α] [LawfulOrderMin α]u
List.max?_nil}(hjP  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/MinMax.htmlh?theorem List.max?_nil {α : Type u_1} [Max α] :
[].max? = noneh
huList.max?_cons'}(hjT  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/MinMax.htmlhqtheorem List.max?_cons' {α : Type u_1} {x : α} [Max α] {xs : List α} :
(x :: xs).max? = some (foldl max x xs)h
huList.max?_cons}(hjX  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/MinMax.htmlhtheorem List.max?_cons {α : Type u_1} {x : α} [Max α] [Std.Associative max] {xs : List α} :
(x :: xs).max? = some (xs.max?.elim x (max x))h
huList.max?_eq_none_iff}(hj\  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/MinMax.htmlhbtheorem List.max?_eq_none_iff {α : Type u_1} {xs : List α} [Max α] :
xs.max? = none ↔ xs = []h
huList.isSome_max?_of_mem}(hj`  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/MinMax.htmlhttheorem List.isSome_max?_of_mem {α : Type u_1} {l : List α} [Max α] {a : α} (h : a ∈ l) :
l.max?.isSome = trueh
huList.max?_eq_head?}(hjd  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/MinMax.htmlhtheorem List.max?_eq_head? {α : Type u} [Max α] {l : List α} (h : Pairwise (fun (a b : α) => max a b = a) l) :
l.max? = l.head?h
hu
List.max?_mem}(hjh  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/MinMax.htmlhwtheorem List.max?_mem {α : Type u_1} {a : α} [Max α] [Std.MaxEqOr α] {xs : List α} :
xs.max? = some a → a ∈ xsh
huList.max?_le_iff}(hjl  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/MinMax.htmlhtheorem List.max?_le_iff {α : Type u_1} {a : α} [Max α] [LE α] [Std.LawfulOrderSup α] {xs : List α} :
xs.max? = some a → ∀ {x : α}, a ≤ x ↔ ∀ (b : α), b ∈ xs → b ≤ xh
huList.max?_eq_some_iff}(hjp  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/MinMax.htmlhtheorem List.max?_eq_some_iff {α : Type u_1} {a : α} [Max α] [LE α] {xs : List α} [Std.IsLinearOrder α] [Std.LawfulOrderMax α] :
xs.max? = some a ↔ a ∈ xs ∧ ∀ (b : α), b ∈ xs → b ≤ ah
huList.max?_eq_max?_attach}(hjt  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/MinMax.htmlhtheorem List.max?_eq_max?_attach {α : Type u_1} [Max α] [Std.MaxEqOr α] {xs : List α} :
xs.max? = Option.map Subtype.val xs.attach.max?h
huList.max?_eq_some_iff_subtype}(hjx  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/MinMax.htmlhX
  theorem List.max?_eq_some_iff_subtype {α : Type u_1} {a : α} [Max α] [LE α] {xs : List α} [Std.MaxEqOr α] [Std.IsLinearOrder { x : α // x ∈ xs }] [Std.LawfulOrderMax { x : α // x ∈ xs }] :
xs.max? = some a ↔ a ∈ xs ∧ ∀ (b : α), b ∈ xs → b ≤ ah
huList.max?_eq_some_iff_legacy}(hj|  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/MinMax.htmlhX{  theorem List.max?_eq_some_iff_legacy {α : Type u_1} {a : α} [Max α] [LE α] [anti : Std.Antisymm fun (x1 x2 : α) => x1 ≤ x2] (le_refl : ∀ (a : α), a ≤ a) (max_eq_or : ∀ (a b : α), max a b = a ∨ max a b = b) (max_le_iff : ∀ (a b c : α), max b c ≤ a ↔ b ≤ a ∧ c ≤ a) {xs : List α} :
xs.max? = some a ↔ a ∈ xs ∧ ∀ (b : α), b ∈ xs → b ≤ ah
huList.max?_replicate}(hj  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/MinMax.htmlhtheorem List.max?_replicate {α : Type u_1} [Max α] [Std.IdempotentOp max] {n : Nat} {a : α} :
(replicate n a).max? = if n = 0 then none else some ah
huList.max?_replicate_of_pos}(hj  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/MinMax.htmlhtheorem List.max?_replicate_of_pos {α : Type u_1} [Max α] [Std.MaxEqOr α] {n : Nat} {a : α} (h : 0 < n) :
(replicate n a).max? = some ah
huList.foldl_max}(hj  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/MinMax.htmlhtheorem List.foldl_max {α : Type u_1} [Max α] [Std.IdempotentOp max] [Std.Associative max] {l : List α} {a : α} :
foldl max a l = max a (l.max?.getD a)h
[Requirements are satisfied for [OrderData α] [Max α] [LinearOrder α] [LawfulOrderMax α]u	List.pmap}(hj  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Attach.htmlhdef List.pmap {α : Type u_1} {β : Type u_2} {P : α → Prop} (f : (a : α) → P a → β) (l : List α) (H : ∀ (a : α), a ∈ l → P a) :
List βh
X  Maps a partially defined function (defined on those terms of α that satisfy a predicate P) over a list l : List α, given a proof that every element of l in fact satisfies P.
O(|l|). List.pmap, named for “partial map,” is the equivalent of List.map for such partial functions.uList.attachWith}(hj  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Attach.htmlhdef List.attachWith {α : Type u_1} (l : List α) (P : α → Prop) (H : ∀ (x : α), x ∈ l → P x) :
List { x : α // P x }h
“Attaches” individual proofs to a list of values that satisfy a predicate P, returning a list of elements in the corresponding subtype { x // P x }.
O(1).uList.attach}(hj  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Attach.htmlhJdef List.attach {α : Type u_1} (l : List α) :
List { x : α // x ∈ l }h
X  “Attaches” the proof that the elements of l are in fact elements of l, producing a new list with the same elements but in the subtype { x // x ∈ l }.
O(1).
This function is primarily used to allow definitions by well-founded recursion that use higher-order functions (such as List.map) to prove that an value taken from a list is smaller than the list. This allows the well-founded recursion mechanism to prove that the function terminates.u
List.pmap_nil}(hj  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Attach.htmlhztheorem List.pmap_nil {α : Type u_1} {β : Type u_2} {P : α → Prop} {f : (a : α) → P a → β} :
pmap f [] ⋯ = []h
huList.pmap_cons}(hj  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Attach.htmlhtheorem List.pmap_cons {α : Type u_1} {β : Type u_2} {P : α → Prop} {f : (a : α) → P a → β} {a : α} {l : List α} (h : ∀ (b : α), b ∈ a :: l → P b) :
pmap f (a :: l) h = f a ⋯ :: pmap f l ⋯h
huList.attach_nil}(hj  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Attach.htmlh8theorem List.attach_nil {α : Type u_1} :
[].attach = []h
huList.attachWith_nil}(hj  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Attach.htmlh{theorem List.attachWith_nil {α : Type u_1} {P : α → Prop} {H : ∀ (x : α), x ∈ [] → P x} :
[].attachWith P H = []h
huList.pmap_eq_map}(hj  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Attach.htmlhtheorem List.pmap_eq_map {α : Type u_1} {β : Type u_2} {p : α → Prop} {f : α → β} {l : List α} (H : ∀ (a : α), a ∈ l → p a) :
pmap (fun (a : α) (x : p a) => f a) l H = map f lh
huList.pmap_congr_left}(hj  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Attach.htmlhX[  theorem List.pmap_congr_left {α : Type u_1} {β : Type u_2} {p q : α → Prop} {f : (a : α) → p a → β} {g : (a : α) → q a → β} (l : List α) {H₁ : ∀ (a : α), a ∈ l → p a} {H₂ : ∀ (a : α), a ∈ l → q a} (h : ∀ (a : α), a ∈ l → ∀ (h₁ : p a) (h₂ : q a), f a h₁ = g a h₂) :
pmap f l H₁ = pmap g l H₂h
hu
List.map_pmap}(hj  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Attach.htmlhtheorem List.map_pmap {α : Type u_1} {β : Type u_2} {γ : Type u_3} {p : α → Prop} {g : β → γ} {f : (a : α) → p a → β} {l : List α} (H : ∀ (a : α), a ∈ l → p a) :
map g (pmap f l H) = pmap (fun (a : α) (h : p a) => g (f a h)) l Hh
hu
List.pmap_map}(hj  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Attach.htmlhX	  theorem List.pmap_map {β : Type u_1} {γ : Type u_2} {α : Type u_3} {p : β → Prop} {g : (b : β) → p b → γ} {f : α → β} {l : List α} (H : ∀ (a : β), a ∈ map f l → p a) :
pmap g (map f l) H = pmap (fun (a : α) (h : p (f a)) => g (f a) h) l ⋯h
huList.attach_congr}(hj  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Attach.htmlhtheorem List.attach_congr {α : Type u_1} {l₁ l₂ : List α} (h : l₁ = l₂) :
l₁.attach = map (fun (x : { x : α // x ∈ l₂ }) => ⟨x.val, ⋯⟩) l₂.attachh
huList.attachWith_congr}(hj  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Attach.htmlhtheorem List.attachWith_congr {α : Type u_1} {l₁ l₂ : List α} (w : l₁ = l₂) {P : α → Prop} {H : ∀ (x : α), x ∈ l₁ → P x} :
l₁.attachWith P H = l₂.attachWith P ⋯h
huList.attach_cons}(hj  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Attach.htmlhtheorem List.attach_cons {α : Type u_1} {x : α} {xs : List α} :
(x :: xs).attach = ⟨x, ⋯⟩ :: map
      (fun (x_1 : { x : α // x ∈ xs }) =>
        match x_1 with
        | ⟨y, h⟩ => ⟨y, ⋯⟩)
      xs.attachh
huList.attachWith_cons}(hj  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Attach.htmlhtheorem List.attachWith_cons {α : Type u_1} {x : α} {xs : List α} {p : α → Prop} (h : ∀ (a : α), a ∈ x :: xs → p a) :
(x :: xs).attachWith p h = ⟨x, ⋯⟩ :: xs.attachWith p ⋯h
huList.pmap_eq_map_attach}(hj  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Attach.htmlhtheorem List.pmap_eq_map_attach {α : Type u_1} {β : Type u_2} {p : α → Prop} {f : (a : α) → p a → β} {l : List α} (H : ∀ (a : α), a ∈ l → p a) :
pmap f l H = map (fun (x : { x : α // x ∈ l }) => f x.val ⋯) l.attachh
huList.pmap_eq_attachWith}(hj  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Attach.htmlhtheorem List.pmap_eq_attachWith {α : Type u_1} {p q : α → Prop} {f : ∀ (a : α), p a → q a} {l : List α} (H : ∀ (a : α), a ∈ l → p a) :
pmap (fun (a : α) (h : p a) => ⟨a, ⋯⟩) l H = l.attachWith q ⋯h
huList.attach_map_val}(hj  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Attach.htmlhtheorem List.attach_map_val {α : Type u_1} {β : Type u_2} {l : List α} {f : α → β} :
map (fun (i : { i : α // i ∈ l }) => f i.val) l.attach = map f lh
huList.attach_map_coe}(hj  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Attach.htmlhabbrev List.attach_map_coe {α : Type u_1} {β : Type u_2} {l : List α} {f : α → β} :
map (fun (i : { i : α // i ∈ l }) => f i.val) l.attach = map f lh
huList.attach_map_subtype_val}(hj  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Attach.htmlh`theorem List.attach_map_subtype_val {α : Type u_1} (l : List α) :
map Subtype.val l.attach = lh
huList.attachWith_map_val}(hj  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Attach.htmlhtheorem List.attachWith_map_val {α : Type u_1} {β : Type u_2} {p : α → Prop} {f : α → β} {l : List α} (H : ∀ (a : α), a ∈ l → p a) :
map (fun (i : { i : α // p i }) => f i.val) (l.attachWith p H) = map f lh
huList.attachWith_map_coe}(hj  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Attach.htmlhabbrev List.attachWith_map_coe {α : Type u_1} {β : Type u_2} {p : α → Prop} {f : α → β} {l : List α} (H : ∀ (a : α), a ∈ l → p a) :
map (fun (i : { i : α // p i }) => f i.val) (l.attachWith p H) = map f lh
huList.attachWith_map_subtype_val}(hj  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Attach.htmlhtheorem List.attachWith_map_subtype_val {α : Type u_1} {p : α → Prop} {l : List α} (H : ∀ (a : α), a ∈ l → p a) :
map Subtype.val (l.attachWith p H) = lh
huList.mem_attach}(hj  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Attach.htmlhbtheorem List.mem_attach {α : Type u_1} (l : List α) (x : { x : α // x ∈ l }) :
x ∈ l.attachh
huList.mem_attachWith}(hj  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Attach.htmlhtheorem List.mem_attachWith {α : Type u_1} {l : List α} {q : α → Prop} (H : ∀ (x : α), x ∈ l → q x) (x : { x : α // q x }) :
x ∈ l.attachWith q H ↔ x.val ∈ lh
hu
List.mem_pmap}(hj  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Attach.htmlhtheorem List.mem_pmap {α : Type u_1} {β : Type u_2} {p : α → Prop} {f : (a : α) → p a → β} {l : List α} {H : ∀ (a : α), a ∈ l → p a} {b : β} :
b ∈ pmap f l H ↔ ∃ (a : α), ∃ (h : a ∈ l), f a ⋯ = bh
huList.mem_pmap_of_mem}(hj  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Attach.htmlhtheorem List.mem_pmap_of_mem {α : Type u_1} {β : Type u_2} {p : α → Prop} {f : (a : α) → p a → β} {l : List α} {H : ∀ (a : α), a ∈ l → p a} {a : α} (h : a ∈ l) :
f a ⋯ ∈ pmap f l Hh
huList.length_pmap}(hj  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Attach.htmlhtheorem List.length_pmap {α : Type u_1} {β : Type u_2} {p : α → Prop} {f : (a : α) → p a → β} {l : List α} {H : ∀ (a : α), a ∈ l → p a} :
(pmap f l H).length = l.lengthh
huList.length_attach}(hj   hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Attach.htmlhUtheorem List.length_attach {α : Type u_1} {l : List α} :
l.attach.length = l.lengthh
huList.length_attachWith}(hj  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Attach.htmlhtheorem List.length_attachWith {α : Type u_1} {p : α → Prop} {l : List α} {H : ∀ (x : α), x ∈ l → p x} :
(l.attachWith p H).length = l.lengthh
huList.pmap_eq_nil_iff}(hj  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Attach.htmlhtheorem List.pmap_eq_nil_iff {α : Type u_1} {β : Type u_2} {p : α → Prop} {f : (a : α) → p a → β} {l : List α} {H : ∀ (a : α), a ∈ l → p a} :
pmap f l H = [] ↔ l = []h
huList.pmap_ne_nil_iff}(hj  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Attach.htmlhtheorem List.pmap_ne_nil_iff {α : Type u_1} {β : Type u_2} {P : α → Prop} (f : (a : α) → P a → β) {xs : List α} (H : ∀ (a : α), a ∈ xs → P a) :
pmap f xs H ≠ [] ↔ xs ≠ []h
huList.pmap_eq_self}(hj  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Attach.htmlhtheorem List.pmap_eq_self {α : Type u_1} {l : List α} {p : α → Prop} {hp : ∀ (a : α), a ∈ l → p a} {f : (a : α) → p a → α} :
pmap f l hp = l ↔ ∀ (a : α) (h : a ∈ l), f a ⋯ = ah
huList.attach_eq_nil_iff}(hj  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Attach.htmlhWtheorem List.attach_eq_nil_iff {α : Type u_1} {l : List α} :
l.attach = [] ↔ l = []h
huList.attach_ne_nil_iff}(hj  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Attach.htmlh[theorem List.attach_ne_nil_iff {α : Type u_1} {l : List α} :
l.attach ≠ [] ↔ l ≠ []h
huList.attachWith_eq_nil_iff}(hj  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Attach.htmlhtheorem List.attachWith_eq_nil_iff {α : Type u_1} {l : List α} {P : α → Prop} {H : ∀ (a : α), a ∈ l → P a} :
l.attachWith P H = [] ↔ l = []h
huList.attachWith_ne_nil_iff}(hj   hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Attach.htmlhtheorem List.attachWith_ne_nil_iff {α : Type u_1} {l : List α} {P : α → Prop} {H : ∀ (a : α), a ∈ l → P a} :
l.attachWith P H ≠ [] ↔ l ≠ []h
huList.getElem?_pmap}(hj$  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Attach.htmlhtheorem List.getElem?_pmap {α : Type u_1} {β : Type u_2} {p : α → Prop} {f : (a : α) → p a → β} {l : List α} (h : ∀ (a : α), a ∈ l → p a) (i : Nat) :
(pmap f l h)[i]? = Option.pmap f l[i]? ⋯h
huList.get?_pmap}(hj(  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Attach.htmlhtheorem List.get?_pmap {α : Type u_1} {β : Type u_2} {p : α → Prop} (f : (a : α) → p a → β) {l : List α} (h : ∀ (a : α), a ∈ l → p a) (n : Nat) :
(pmap f l h).get? n = Option.pmap f (l.get? n) ⋯h
huList.getElem_pmap}(hj,  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Attach.htmlhtheorem List.getElem_pmap {α : Type u_1} {β : Type u_2} {p : α → Prop} (f : (a : α) → p a → β) {l : List α} (h : ∀ (a : α), a ∈ l → p a) {i : Nat} (hn : i < (pmap f l h).length) :
(pmap f l h)[i] = f l[i] ⋯h
hu
List.get_pmap}(hj0  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Attach.htmlhtheorem List.get_pmap {α : Type u_1} {β : Type u_2} {p : α → Prop} (f : (a : α) → p a → β) {l : List α} (h : ∀ (a : α), a ∈ l → p a) {n : Nat} (hn : n < (pmap f l h).length) :
(pmap f l h).get ⟨n, hn⟩ = f (l.get ⟨n, ⋯⟩) ⋯h
huList.getElem?_attachWith}(hj4  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Attach.htmlhtheorem List.getElem?_attachWith {α : Type u_1} {xs : List α} {i : Nat} {P : α → Prop} {H : ∀ (a : α), a ∈ xs → P a} :
(xs.attachWith P H)[i]? = Option.pmap Subtype.mk xs[i]? ⋯h
huList.getElem?_attach}(hj8  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Attach.htmlhytheorem List.getElem?_attach {α : Type u_1} {xs : List α} {i : Nat} :
xs.attach[i]? = Option.pmap Subtype.mk xs[i]? ⋯h
huList.getElem_attachWith}(hj<  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Attach.htmlhtheorem List.getElem_attachWith {α : Type u_1} {xs : List α} {P : α → Prop} {H : ∀ (a : α), a ∈ xs → P a} {i : Nat} (h : i < (xs.attachWith P H).length) :
(xs.attachWith P H)[i] = ⟨xs[i], ⋯⟩h
huList.getElem_attach}(hj@  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Attach.htmlhtheorem List.getElem_attach {α : Type u_1} {xs : List α} {i : Nat} (h : i < xs.attach.length) :
xs.attach[i] = ⟨xs[i], ⋯⟩h
huList.pmap_attach}(hjD  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Attach.htmlhXZ  theorem List.pmap_attach {α : Type u_1} {β : Type u_2} {l : List α} {p : { x : α // x ∈ l } → Prop} {f : (a : { x : α // x ∈ l }) → p a → β} (H : ∀ (a : { x : α // x ∈ l }), a ∈ l.attach → p a) :
pmap f l.attach H = pmap (fun (a : α) (h : (fun (a : α) => ∃ (h : a ∈ l), p ⟨a, h⟩) a) => f ⟨a, ⋯⟩ ⋯) l ⋯h
huList.pmap_attachWith}(hjH  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Attach.htmlhX  theorem List.pmap_attachWith {α : Type u_1} {q : α → Prop} {β : Type u_2} {l : List α} {p : { x : α // q x } → Prop} {f : (a : { x : α // q x }) → p a → β} (H₁ : ∀ (x : α), x ∈ l → q x) (H₂ : ∀ (a : { x : α // q x }), a ∈ l.attachWith q H₁ → p a) :
pmap f (l.attachWith q H₁) H₂ = pmap (fun (a : α) (h : (fun (a : α) => ∃ (h : q a), p ⟨a, h⟩) a) => f ⟨a, ⋯⟩ ⋯) l ⋯h
huList.head?_pmap}(hjL  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Attach.htmlhX-  theorem List.head?_pmap {α : Type u_1} {β : Type u_2} {P : α → Prop} {f : (a : α) → P a → β} {xs : List α} (H : ∀ (a : α), a ∈ xs → P a) :
(pmap f xs H).head? = Option.map
    (fun (x : { x : α // x ∈ xs }) =>
      match x with
      | ⟨a, m⟩ => f a ⋯)
    xs.attach.head?h
huList.head_pmap}(hjP  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Attach.htmlhtheorem List.head_pmap {α : Type u_1} {β : Type u_2} {P : α → Prop} {f : (a : α) → P a → β} {xs : List α} (H : ∀ (a : α), a ∈ xs → P a) (h : pmap f xs H ≠ []) :
(pmap f xs H).head h = f (xs.head ⋯) ⋯h
huList.head?_attachWith}(hjT  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Attach.htmlhtheorem List.head?_attachWith {α : Type u_1} {P : α → Prop} {xs : List α} (H : ∀ (a : α), a ∈ xs → P a) :
(xs.attachWith P H).head? = xs.head?.pbind fun (a : α) (h : xs.head? = some a) => some ⟨a, ⋯⟩h
huList.head_attachWith}(hjX  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Attach.htmlhtheorem List.head_attachWith {α : Type u_1} {P : α → Prop} {xs : List α} {H : ∀ (a : α), a ∈ xs → P a} (h : xs.attachWith P H ≠ []) :
(xs.attachWith P H).head h = ⟨xs.head ⋯, ⋯⟩h
huList.head?_attach}(hj\  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Attach.htmlhtheorem List.head?_attach {α : Type u_1} {xs : List α} :
xs.attach.head? = xs.head?.pbind fun (a : α) (h : xs.head? = some a) => some ⟨a, ⋯⟩h
huList.head_attach}(hj`  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Attach.htmlhztheorem List.head_attach {α : Type u_1} {xs : List α} (h : xs.attach ≠ []) :
xs.attach.head h = ⟨xs.head ⋯, ⋯⟩h
huList.tail_pmap}(hjd  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Attach.htmlhtheorem List.tail_pmap {α : Type u_1} {β : Type u_2} {P : α → Prop} {f : (a : α) → P a → β} {xs : List α} (H : ∀ (a : α), a ∈ xs → P a) :
(pmap f xs H).tail = pmap f xs.tail ⋯h
huList.tail_attachWith}(hjh  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Attach.htmlhtheorem List.tail_attachWith {α : Type u_1} {P : α → Prop} {xs : List α} {H : ∀ (a : α), a ∈ xs → P a} :
(xs.attachWith P H).tail = xs.tail.attachWith P ⋯h
huList.tail_attach}(hjl  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Attach.htmlhtheorem List.tail_attach {α : Type u_1} {xs : List α} :
xs.attach.tail = map
    (fun (x : { x : α // x ∈ xs.tail }) =>
      match x with
      | ⟨x, h⟩ => ⟨x, ⋯⟩)
    xs.tail.attachh
huList.foldl_pmap}(hjp  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Attach.htmlhX9  theorem List.foldl_pmap {α : Type u_1} {β : Type u_2} {γ : Type u_3} {l : List α} {P : α → Prop} {f : (a : α) → P a → β} (H : ∀ (a : α), a ∈ l → P a) (g : γ → β → γ) (x : γ) :
foldl g x (pmap f l H) = foldl (fun (acc : γ) (a : { x : α // x ∈ l }) => g acc (f a.val ⋯)) x l.attachh
huList.foldr_pmap}(hjt  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Attach.htmlhX9  theorem List.foldr_pmap {α : Type u_1} {β : Type u_2} {γ : Type u_3} {l : List α} {P : α → Prop} {f : (a : α) → P a → β} (H : ∀ (a : α), a ∈ l → P a) (g : β → γ → γ) (x : γ) :
foldr g x (pmap f l H) = foldr (fun (a : { x : α // x ∈ l }) (acc : γ) => g (f a.val ⋯) acc) x l.attachh
huList.foldl_attachWith}(hjx  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Attach.htmlhXR  theorem List.foldl_attachWith {α : Type u_1} {β : Type u_2} {l : List α} {q : α → Prop} (H : ∀ (a : α), a ∈ l → q a) {f : β → { x : α // q x } → β} {b : β} :
foldl f b (l.attachWith q H) = foldl
    (fun (b : β) (x : { x : α // x ∈ l }) =>
      match x with
      | ⟨a, h⟩ => f b ⟨a, ⋯⟩)
    b l.attachh
huList.foldr_attachWith}(hj|  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Attach.htmlhX)  theorem List.foldr_attachWith {α : Type u_1} {β : Type u_2} {l : List α} {q : α → Prop} (H : ∀ (a : α), a ∈ l → q a) {f : { x : α // q x } → β → β} {b : β} :
foldr f b (l.attachWith q H) = foldr (fun (a : { x : α // x ∈ l }) (acc : β) => f ⟨a.val, ⋯⟩ acc) b l.attachh
huList.foldl_attach}(hj  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Attach.htmlhtheorem List.foldl_attach {α : Type u_1} {β : Type u_2} {l : List α} {f : β → α → β} {b : β} :
foldl (fun (acc : β) (t : { x : α // x ∈ l }) => f acc t.val) b l.attach = foldl f b lh
X  If we fold over l.attach with a function that ignores the membership predicate, we get the same results as folding over l directly.
This is useful when we need to use attach to show termination.
Unfortunately this can't be applied by simp because of the higher order unification problem, and even when rewriting we need to specify the function explicitly. See however foldl_subtype below.uList.foldr_attach}(hj  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Attach.htmlhtheorem List.foldr_attach {α : Type u_1} {β : Type u_2} {l : List α} {f : α → β → β} {b : β} :
foldr (fun (t : { x : α // x ∈ l }) (acc : β) => f t.val acc) b l.attach = foldr f b lh
X  If we fold over l.attach with a function that ignores the membership predicate, we get the same results as folding over l directly.
This is useful when we need to use attach to show termination.
Unfortunately this can't be applied by simp because of the higher order unification problem, and even when rewriting we need to specify the function explicitly. See however foldr_subtype below.uList.attach_map}(hj  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Attach.htmlhtheorem List.attach_map {α : Type u_1} {β : Type u_2} {l : List α} {f : α → β} :
(map f l).attach = map
    (fun (x : { x : α // x ∈ l }) =>
      match x with
      | ⟨x, h⟩ => ⟨f x, ⋯⟩)
    l.attachh
huList.attachWith_map}(hj  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Attach.htmlhX:  theorem List.attachWith_map {α : Type u_1} {β : Type u_2} {l : List α} {f : α → β} {P : β → Prop} (H : ∀ (b : β), b ∈ map f l → P b) :
(map f l).attachWith P H = map
    (fun (x : { x : α // (P ∘ f) x }) =>
      match x with
      | ⟨x, h⟩ => ⟨f x, h⟩)
    (l.attachWith (P ∘ f) ⋯)h
huList.map_attachWith}(hj  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Attach.htmlhX-  theorem List.map_attachWith {α : Type u_1} {β : Type u_2} {l : List α} {P : α → Prop} {H : ∀ (a : α), a ∈ l → P a} {f : { x : α // P x } → β} :
map f (l.attachWith P H) = map
    (fun (x : { x : α // x ∈ l }) =>
      match x with
      | ⟨x, h⟩ => f ⟨x, ⋯⟩)
    l.attachh
huList.map_attachWith_eq_pmap}(hj  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Attach.htmlhX  theorem List.map_attachWith_eq_pmap {α : Type u_1} {β : Type u_2} {l : List α} {P : α → Prop} {H : ∀ (a : α), a ∈ l → P a} {f : { x : α // P x } → β} :
map f (l.attachWith P H) = pmap (fun (a : α) (h : a ∈ l ∧ P a) => f ⟨a, ⋯⟩) l ⋯h
huList.map_attach_eq_pmap}(hj  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Attach.htmlhtheorem List.map_attach_eq_pmap {α : Type u_1} {β : Type u_2} {l : List α} {f : { x : α // x ∈ l } → β} :
map f l.attach = pmap (fun (a : α) (h : a ∈ l) => f ⟨a, h⟩) l ⋯h
HSee also pmap_eq_map_attach for writing pmap in terms of map and attach.uList.map_attach}(hj  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Attach.htmlhabbrev List.map_attach {α : Type u_1} {β : Type u_2} {l : List α} {f : { x : α // x ∈ l } → β} :
map f l.attach = pmap (fun (a : α) (h : a ∈ l) => f ⟨a, h⟩) l ⋯h
huList.attach_filterMap}(hj  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Attach.htmlhX'  theorem List.attach_filterMap {α : Type u_1} {β : Type u_2} {l : List α} {f : α → Option β} :
(filterMap f l).attach = filterMap
    (fun (x : { x : α // x ∈ l }) =>
      match x with
      | ⟨x, h⟩ => (f x).pbind fun (b : β) (m : f x = some b) => some ⟨b, ⋯⟩)
    l.attachh
huList.attach_filter}(hj  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Attach.htmlhtheorem List.attach_filter {α : Type u_1} {l : List α} (p : α → Bool) :
(filter p l).attach = filterMap (fun (x : { x : α // x ∈ l }) => if w : p x.val = true then some ⟨x.val, ⋯⟩ else none) l.attachh
huList.filterMap_attachWith}(hj  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Attach.htmlhXF  theorem List.filterMap_attachWith {α : Type u_1} {β : Type u_2} {q : α → Prop} {l : List α} {f : { x : α // q x } → Option β} (H : ∀ (x : α), x ∈ l → q x) :
filterMap f (l.attachWith q H) = filterMap
    (fun (x : { x : α // x ∈ l }) =>
      match x with
      | ⟨x, h⟩ => f ⟨x, ⋯⟩)
    l.attachh
huList.filter_attachWith}(hj  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Attach.htmlhX  theorem List.filter_attachWith {α : Type u_1} {q : α → Prop} {l : List α} {p : { x : α // q x } → Bool} (H : ∀ (x : α), x ∈ l → q x) :
filter p (l.attachWith q H) = map
    (fun (x : { x : α // x ∈ l }) =>
      match x with
      | ⟨x, h⟩ => ⟨x, ⋯⟩)
    (filter
      (fun (x : { x : α // x ∈ l }) =>
        match x with
        | ⟨x, h⟩ => p ⟨x, ⋯⟩)
      l.attach)h
huList.pmap_pmap}(hj  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Attach.htmlhX  theorem List.pmap_pmap {α : Type u_1} {β : Type u_2} {γ : Type u_3} {p : α → Prop} {q : β → Prop} {g : (a : α) → p a → β} {f : (b : β) → q b → γ} {l : List α} (H₁ : ∀ (a : α), a ∈ l → p a) (H₂ : ∀ (a : β), a ∈ pmap g l H₁ → q a) :
pmap f (pmap g l H₁) H₂ = pmap (fun (a : { x : α // x ∈ l }) (h : p a.val) => f (g a.val h) ⋯) l.attach ⋯h
huList.pmap_append}(hj  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Attach.htmlhtheorem List.pmap_append {ι : Type u_1} {α : Type u_2} {p : ι → Prop} {f : (a : ι) → p a → α} {l₁ l₂ : List ι} (h : ∀ (a : ι), a ∈ l₁ ++ l₂ → p a) :
pmap f (l₁ ++ l₂) h = pmap f l₁ ⋯ ++ pmap f l₂ ⋯h
huList.pmap_append'}(hj  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Attach.htmlhX  theorem List.pmap_append' {α : Type u_1} {β : Type u_2} {p : α → Prop} {f : (a : α) → p a → β} {l₁ l₂ : List α} (h₁ : ∀ (a : α), a ∈ l₁ → p a) (h₂ : ∀ (a : α), a ∈ l₂ → p a) :
pmap f (l₁ ++ l₂) ⋯ = pmap f l₁ h₁ ++ pmap f l₂ h₂h
huList.attach_append}(hj  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Attach.htmlhXI  theorem List.attach_append {α : Type u_1} {xs ys : List α} :
(xs ++ ys).attach = map
      (fun (x : { x : α // x ∈ xs }) =>
        match x with
        | ⟨x, h⟩ => ⟨x, ⋯⟩)
      xs.attach ++ map
      (fun (x : { x : α // x ∈ ys }) =>
        match x with
        | ⟨x, h⟩ => ⟨x, ⋯⟩)
      ys.attachh
huList.attachWith_append}(hj  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Attach.htmlhtheorem List.attachWith_append {α : Type u_1} {P : α → Prop} {xs ys : List α} {H : ∀ (a : α), a ∈ xs ++ ys → P a} :
(xs ++ ys).attachWith P H = xs.attachWith P ⋯ ++ ys.attachWith P ⋯h
huList.pmap_reverse}(hj  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Attach.htmlhtheorem List.pmap_reverse {α : Type u_1} {β : Type u_2} {P : α → Prop} {f : (a : α) → P a → β} {xs : List α} (H : ∀ (a : α), a ∈ xs.reverse → P a) :
pmap f xs.reverse H = (pmap f xs ⋯).reverseh
huList.reverse_pmap}(hj  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Attach.htmlhtheorem List.reverse_pmap {α : Type u_1} {β : Type u_2} {P : α → Prop} {f : (a : α) → P a → β} {xs : List α} (H : ∀ (a : α), a ∈ xs → P a) :
(pmap f xs H).reverse = pmap f xs.reverse ⋯h
huList.attachWith_reverse}(hj  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Attach.htmlhtheorem List.attachWith_reverse {α : Type u_1} {P : α → Prop} {xs : List α} {H : ∀ (a : α), a ∈ xs.reverse → P a} :
xs.reverse.attachWith P H = (xs.attachWith P ⋯).reverseh
huList.reverse_attachWith}(hj  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Attach.htmlhtheorem List.reverse_attachWith {α : Type u_1} {P : α → Prop} {xs : List α} {H : ∀ (a : α), a ∈ xs → P a} :
(xs.attachWith P H).reverse = xs.reverse.attachWith P ⋯h
huList.attach_reverse}(hj  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Attach.htmlhtheorem List.attach_reverse {α : Type u_1} {xs : List α} :
xs.reverse.attach = map
    (fun (x : { x : α // x ∈ xs }) =>
      match x with
      | ⟨x, h⟩ => ⟨x, ⋯⟩)
    xs.attach.reverseh
huList.reverse_attach}(hj  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Attach.htmlhtheorem List.reverse_attach {α : Type u_1} {xs : List α} :
xs.attach.reverse = map
    (fun (x : { x : α // x ∈ xs.reverse }) =>
      match x with
      | ⟨x, h⟩ => ⟨x, ⋯⟩)
    xs.reverse.attachh
huList.getLast?_pmap}(hj  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Attach.htmlhX6  theorem List.getLast?_pmap {α : Type u_1} {β : Type u_2} {P : α → Prop} {f : (a : α) → P a → β} {xs : List α} (H : ∀ (a : α), a ∈ xs → P a) :
(pmap f xs H).getLast? = Option.map
    (fun (x : { x : α // x ∈ xs }) =>
      match x with
      | ⟨a, m⟩ => f a ⋯)
    xs.attach.getLast?h
huList.getLast_pmap}(hj  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Attach.htmlhtheorem List.getLast_pmap {α : Type u_1} {β : Type u_2} {P : α → Prop} {f : (a : α) → P a → β} {xs : List α} (H : ∀ (a : α), a ∈ xs → P a) (h : pmap f xs H ≠ []) :
(pmap f xs H).getLast h = f (xs.getLast ⋯) ⋯h
huList.getLast?_attachWith}(hj  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Attach.htmlhtheorem List.getLast?_attachWith {α : Type u_1} {P : α → Prop} {xs : List α} {H : ∀ (a : α), a ∈ xs → P a} :
(xs.attachWith P H).getLast? = xs.getLast?.pbind fun (a : α) (h : xs.getLast? = some a) => some ⟨a, ⋯⟩h
huList.getLast_attachWith}(hj  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Attach.htmlhtheorem List.getLast_attachWith {α : Type u_1} {P : α → Prop} {xs : List α} {H : ∀ (a : α), a ∈ xs → P a} (h : xs.attachWith P H ≠ []) :
(xs.attachWith P H).getLast h = ⟨xs.getLast ⋯, ⋯⟩h
huList.getLast?_attach}(hj  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Attach.htmlhtheorem List.getLast?_attach {α : Type u_1} {xs : List α} :
xs.attach.getLast? = xs.getLast?.pbind fun (a : α) (h : xs.getLast? = some a) => some ⟨a, ⋯⟩h
huList.getLast_attach}(hj  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Attach.htmlhtheorem List.getLast_attach {α : Type u_1} {xs : List α} (h : xs.attach ≠ []) :
xs.attach.getLast h = ⟨xs.getLast ⋯, ⋯⟩h
huList.countP_attach}(hj  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Attach.htmlhtheorem List.countP_attach {α : Type u_1} {l : List α} {p : α → Bool} :
countP (fun (a : { x : α // x ∈ l }) => p a.val) l.attach = countP p lh
huList.countP_attachWith}(hj  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Attach.htmlhtheorem List.countP_attachWith {α : Type u_1} {p : α → Prop} {q : α → Bool} {l : List α} (H : ∀ (a : α), a ∈ l → p a) :
countP (fun (a : { x : α // p x }) => q a.val) (l.attachWith p H) = countP q lh
huList.count_attach}(hj  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Attach.htmlhtheorem List.count_attach {α : Type u_1} [BEq α] {l : List α} {a : { x : α // x ∈ l }} :
count a l.attach = count a.val lh
huList.count_attachWith}(hj
  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Attach.htmlhtheorem List.count_attachWith {α : Type u_1} [BEq α] {p : α → Prop} {l : List α} (H : ∀ (a : α), a ∈ l → p a) {a : { x : α // p x }} :
count a (l.attachWith p H) = count a.val lh
huList.countP_pmap}(hj
  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Attach.htmlhX>  theorem List.countP_pmap {α : Type u_1} {β : Type u_2} {p : α → Prop} {g : (a : α) → p a → β} {f : β → Bool} {l : List α} (H₁ : ∀ (a : α), a ∈ l → p a) :
countP f (pmap g l H₁) = countP
    (fun (x : { x : α // x ∈ l }) =>
      match x with
      | ⟨a, m⟩ => f (g a ⋯))
    l.attachh
hu
List.unattach}(hj
  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Attach.htmlhZdef List.unattach {α : Type u_1} {p : α → Prop} (l : List { x : α // p x }) :
List αh
X  Maps a list of terms in a subtype to the corresponding terms in the type by forgetting that they satisfy the predicate.
This is the inverse of List.attachWith and a synonym for l.map (·.val).
Mostly this should not be needed by users. It is introduced as an intermediate step by lemmas such as map_subtype, and is ideally subsequently simplified away by unattach_attach.
This function is usually inserted automatically by Lean as an intermediate step while proving termination. It is rarely used explicitly in code. It is introduced as an intermediate step during the elaboration of definitions by well-founded recursion. If this function is encountered in a proof state, the right approach is usually the tactic simp [List.unattach, -List.map_subtype].uList.unattach_nil}(hj
  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Attach.htmlhNtheorem List.unattach_nil {α : Type u_1} {p : α → Prop} :
[].unattach = []h
huList.unattach_cons}(hj
  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Attach.htmlhtheorem List.unattach_cons {α : Type u_1} {p : α → Prop} {a : { x : α // p x }} {l : List { x : α // p x }} :
(a :: l).unattach = a.val :: l.unattachh
huList.mem_unattach}(hj
  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Attach.htmlhtheorem List.mem_unattach {α : Type u_1} {p : α → Prop} {l : List { x : α // p x }} {a : α} :
a ∈ l.unattach ↔ ∃ (h : p a), ⟨a, h⟩ ∈ lh
huList.length_unattach}(hj
  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Attach.htmlhztheorem List.length_unattach {α : Type u_1} {p : α → Prop} {l : List { x : α // p x }} :
l.unattach.length = l.lengthh
huList.unattach_attach}(hj 
  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Attach.htmlhRtheorem List.unattach_attach {α : Type u_1} {l : List α} :
l.attach.unattach = lh
huList.unattach_attachWith}(hj$
  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Attach.htmlhtheorem List.unattach_attachWith {α : Type u_1} {p : α → Prop} {l : List α} {H : ∀ (a : α), a ∈ l → p a} :
(l.attachWith p H).unattach = lh
huList.getElem?_unattach}(hj(
  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Attach.htmlhtheorem List.getElem?_unattach {α : Type u_1} {p : α → Prop} {l : List { x : α // p x }} (i : Nat) :
l.unattach[i]? = Option.map Subtype.val l[i]?h
huList.getElem_unattach}(hj,
  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Attach.htmlhtheorem List.getElem_unattach {α : Type u_1} {p : α → Prop} {l : List { x : α // p x }} (i : Nat) (h : i < l.unattach.length) :
l.unattach[i] = l[i].valh
huList.foldl_subtype}(hj0
  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Attach.htmlhX  theorem List.foldl_subtype {α : Type u_1} {β : Type u_2} {p : α → Prop} {l : List { x : α // p x }} {f : β → { x : α // p x } → β} {g : β → α → β} {x : β} (hf : ∀ (b : β) (x : α) (h : p x), f b ⟨x, h⟩ = g b x) :
foldl f x l = foldl g x l.unattachh
This lemma identifies folds over lists of subtypes, where the function only depends on the value, not the proposition, and simplifies these to the function directly taking the value.uList.foldr_subtype}(hj5
  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Attach.htmlhX  theorem List.foldr_subtype {α : Type u_1} {β : Type u_2} {p : α → Prop} {l : List { x : α // p x }} {f : { x : α // p x } → β → β} {g : α → β → β} {x : β} (hf : ∀ (x : α) (h : p x) (b : β), f ⟨x, h⟩ b = g x b) :
foldr f x l = foldr g x l.unattachh
This lemma identifies folds over lists of subtypes, where the function only depends on the value, not the proposition, and simplifies these to the function directly taking the value.uList.map_subtype}(hj:
  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Attach.htmlhtheorem List.map_subtype {α : Type u_1} {β : Type u_2} {p : α → Prop} {l : List { x : α // p x }} {f : { x : α // p x } → β} {g : α → β} (hf : ∀ (x : α) (h : p x), f ⟨x, h⟩ = g x) :
map f l = map g l.unattachh
This lemma identifies maps over lists of subtypes, where the function only depends on the value, not the proposition, and simplifies these to the function directly taking the value.uList.filterMap_subtype}(hj?
  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Attach.htmlhX  theorem List.filterMap_subtype {α : Type u_1} {β : Type u_2} {p : α → Prop} {l : List { x : α // p x }} {f : { x : α // p x } → Option β} {g : α → Option β} (hf : ∀ (x : α) (h : p x), f ⟨x, h⟩ = g x) :
filterMap f l = filterMap g l.unattachh
huList.flatMap_subtype}(hjC
  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Attach.htmlhtheorem List.flatMap_subtype {α : Type u_1} {β : Type u_2} {p : α → Prop} {l : List { x : α // p x }} {f : { x : α // p x } → List β} {g : α → List β} (hf : ∀ (x : α) (h : p x), f ⟨x, h⟩ = g x) :
flatMap f l = flatMap g l.unattachh
huList.findSome?_subtype}(hjG
  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Attach.htmlhX  theorem List.findSome?_subtype {α : Type u_1} {β : Type u_2} {p : α → Prop} {l : List { x : α // p x }} {f : { x : α // p x } → Option β} {g : α → Option β} (hf : ∀ (x : α) (h : p x), f ⟨x, h⟩ = g x) :
findSome? f l = findSome? g l.unattachh
huList.find?_subtype}(hjK
  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Attach.htmlhtheorem List.find?_subtype {α : Type u_1} {p : α → Prop} {l : List { x : α // p x }} {f : { x : α // p x } → Bool} {g : α → Bool} (hf : ∀ (x : α) (h : p x), f ⟨x, h⟩ = g x) :
Option.map Subtype.val (find? f l) = find? g l.unattachh
huList.all_subtype}(hjO
  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Attach.htmlhtheorem List.all_subtype {α : Type u_1} {p : α → Prop} {l : List { x : α // p x }} {f : { x : α // p x } → Bool} {g : α → Bool} (hf : ∀ (x : α) (h : p x), f ⟨x, h⟩ = g x) :
l.all f = l.unattach.all gh
huList.any_subtype}(hjS
  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Attach.htmlhtheorem List.any_subtype {α : Type u_1} {p : α → Prop} {l : List { x : α // p x }} {f : { x : α // p x } → Bool} {g : α → Bool} (hf : ∀ (x : α) (h : p x), f ⟨x, h⟩ = g x) :
l.any f = l.unattach.any gh
huList.unattach_filter}(hjW
  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Attach.htmlhtheorem List.unattach_filter {α : Type u_1} {p : α → Prop} {l : List { x : α // p x }} {f : { x : α // p x } → Bool} {g : α → Bool} {hf : ∀ (x : α) (h : p x), f ⟨x, h⟩ = g x} :
(filter f l).unattach = filter g l.unattachh
huList.unattach_reverse}(hj[
  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Attach.htmlhtheorem List.unattach_reverse {α : Type u_1} {p : α → Prop} {l : List { x : α // p x }} :
l.reverse.unattach = l.unattach.reverseh
huList.unattach_append}(hj_
  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Attach.htmlhtheorem List.unattach_append {α : Type u_1} {p : α → Prop} {l₁ l₂ : List { x : α // p x }} :
(l₁ ++ l₂).unattach = l₁.unattach ++ l₂.unattachh
huList.unattach_flatten}(hjc
  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Attach.htmlhtheorem List.unattach_flatten {α : Type u_1} {p : α → Prop} {l : List (List { x : α // p x })} :
l.flatten.unattach = (map unattach l).flattenh
huList.unattach_replicate}(hjg
  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Attach.htmlhtheorem List.unattach_replicate {α : Type u_1} {p : α → Prop} {n : Nat} {x : { x : α // p x }} :
(replicate n x).unattach = replicate n x.valh
huList.map_wfParam}(hjk
  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Attach.htmlhtheorem List.map_wfParam {α : Type u_1} {β : Type u_2} {xs : List α} {f : α → β} :
map f (wfParam xs) = map f xs.attach.unattachh
huList.map_unattach}(hjo
  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Attach.htmlhX  theorem List.map_unattach {α : Type u_1} {β : Type u_2} {P : α → Prop} {xs : List (Subtype P)} {f : α → β} :
map f xs.unattach = map
    (fun (x : Subtype P) =>
      match x with
      | ⟨x, h⟩ => binderNameHint x f (binderNameHint h () (f (wfParam x))))
    xsh
huList.foldl_wfParam}(hjs
  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Attach.htmlhtheorem List.foldl_wfParam {α : Type u_1} {β : Type u_2} {xs : List α} {f : β → α → β} {x : β} :
foldl f x (wfParam xs) = foldl f x xs.attach.unattachh
huList.foldl_unattach}(hjw
  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Attach.htmlhXQ  theorem List.foldl_unattach {α : Type u_1} {β : Type u_2} {P : α → Prop} {xs : List (Subtype P)} {f : β → α → β} {x : β} :
foldl f x xs.unattach = foldl
    (fun (s : β) (x : Subtype P) =>
      match x with
      | ⟨x, h⟩ => binderNameHint s f (binderNameHint x (f s) (binderNameHint h () (f s (wfParam x)))))
    x xsh
huList.foldr_wfParam}(hj{
  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Attach.htmlhtheorem List.foldr_wfParam {α : Type u_1} {β : Type u_2} {xs : List α} {f : α → β → β} {x : β} :
foldr f x (wfParam xs) = foldr f x xs.attach.unattachh
huList.foldr_unattach}(hj
  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Attach.htmlhXQ  theorem List.foldr_unattach {α : Type u_1} {β : Type u_2} {P : α → Prop} {xs : List (Subtype P)} {f : α → β → β} {x : β} :
foldr f x xs.unattach = foldr
    (fun (x : Subtype P) (s : β) =>
      match x with
      | ⟨x, h⟩ => binderNameHint x f (binderNameHint s (f x) (binderNameHint h () (f (wfParam x) s))))
    x xsh
huList.filter_wfParam}(hj
  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Attach.htmlhtheorem List.filter_wfParam {α : Type u_1} {xs : List α} {f : α → Bool} :
filter f (wfParam xs) = filter f xs.attach.unattachh
huList.filter_unattach}(hj
  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Attach.htmlhX!  theorem List.filter_unattach {α : Type u_1} {P : α → Prop} {xs : List (Subtype P)} {f : α → Bool} :
filter f xs.unattach = (filter
      (fun (x : Subtype P) =>
        match x with
        | ⟨x, h⟩ => binderNameHint x f (binderNameHint h () (f (wfParam x))))
      xs).unattachh
huList.reverse_wfParam}(hj
  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Attach.htmlhotheorem List.reverse_wfParam {α : Type u_1} {xs : List α} :
(wfParam xs).reverse = xs.attach.unattach.reverseh
huList.reverse_unattach}(hj
  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Attach.htmlhtheorem List.reverse_unattach {α : Type u_1} {P : α → Prop} {xs : List (Subtype P)} :
xs.unattach.reverse = xs.reverse.unattachh
huList.filterMap_wfParam}(hj
  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Attach.htmlhtheorem List.filterMap_wfParam {α : Type u_1} {β : Type u_2} {xs : List α} {f : α → Option β} :
filterMap f (wfParam xs) = filterMap f xs.attach.unattachh
huList.filterMap_unattach}(hj
  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Attach.htmlhX,  theorem List.filterMap_unattach {α : Type u_1} {β : Type u_2} {P : α → Prop} {xs : List (Subtype P)} {f : α → Option β} :
filterMap f xs.unattach = filterMap
    (fun (x : Subtype P) =>
      match x with
      | ⟨x, h⟩ => binderNameHint x f (binderNameHint h () (f (wfParam x))))
    xsh
huList.flatMap_wfParam}(hj
  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Attach.htmlhtheorem List.flatMap_wfParam {α : Type u_1} {β : Type u_2} {xs : List α} {f : α → List β} :
flatMap f (wfParam xs) = flatMap f xs.attach.unattachh
huList.flatMap_unattach}(hj
  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Attach.htmlhX$  theorem List.flatMap_unattach {α : Type u_1} {β : Type u_2} {P : α → Prop} {xs : List (Subtype P)} {f : α → List β} :
flatMap f xs.unattach = flatMap
    (fun (x : Subtype P) =>
      match x with
      | ⟨x, h⟩ => binderNameHint x f (binderNameHint h () (f (wfParam x))))
    xsh
huList.isEqv_eq_decide}(hj
  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/BEq.htmlhtheorem List.isEqv_eq_decide {α : Type u_1} {as bs : List α} {r : α → α → Bool} :
as.isEqv bs r = if h : as.length = bs.length then decide (∀ (i : Nat) (h' : i < as.length), r as[i] bs[i] = true) else falseh
huList.beq_eq_isEqv}(hj
  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/BEq.htmlh{theorem List.beq_eq_isEqv {α : Type u_1} [BEq α] {as bs : List α} :
as.beq bs = as.isEqv bs fun (x1 x2 : α) => x1 == x2h
huList.beq_eq_decide}(hj
  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/BEq.htmlhtheorem List.beq_eq_decide {α : Type u_1} [BEq α] {as bs : List α} :
(as == bs) = if h : as.length = bs.length then decide (∀ (i : Nat) (h' : i < as.length), (as[i] == bs[i]) = true) else falseh
huList.mapFinIdx}(hj
  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/MapIdx.htmlh{def List.mapFinIdx {α : Type u_1} {β : Type u_2} (as : List α) (f : (i : Nat) → α → i < as.length → β) :
List βh
XC  Applies a function to each element of the list along with the index at which that element is found, returning the list of results. In addition to the index, the function is also provided with a proof that the index is valid.
List.mapIdx is a variant that does not provide the function with evidence that the index is valid.uList.mapIdx}(hj
  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/MapIdx.htmlh`def List.mapIdx {α : Type u_1} {β : Type u_2} (f : Nat → α → β) (as : List α) :
List βh
Applies a function to each element of the list along with the index at which that element is found, returning the list of results.
List.mapFinIdx is a variant that additionally provides the function with a proof that the index is valid.uList.mapFinIdxM}(hj
  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/MapIdx.htmlhdef List.mapFinIdxM {m : Type u_1 → Type u_2} {α : Type u_3} {β : Type u_1} [Monad m] (as : List α) (f : (i : Nat) → α → i < as.length → m β) :
m (List β)h
XL  Applies a monadic function to each element of the list along with the index at which that element is found, returning the list of results. In addition to the index, the function is also provided with a proof that the index is valid.
List.mapIdxM is a variant that does not provide the function with evidence that the index is valid.uList.mapIdxM}(hj
  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/MapIdx.htmlhdef List.mapIdxM {m : Type u_1 → Type u_2} {α : Type u_3} {β : Type u_1} [Monad m] (f : Nat → α → m β) (as : List α) :
m (List β)h
Applies a monadic function to each element of the list along with the index at which that element is found, returning the list of results.
List.mapFinIdxM is a variant that additionally provides the function with a proof that the index is valid.uList.mapFinIdx_congr}(hj
  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/MapIdx.htmlhtheorem List.mapFinIdx_congr {α : Type u_1} {β : Type u_2} {xs ys : List α} (w : xs = ys) (f : (i : Nat) → α → i < xs.length → β) :
xs.mapFinIdx f = ys.mapFinIdx fun (i : Nat) (a : α) (h : i < ys.length) => f i a ⋯h
huList.mapFinIdx_nil}(hj
  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/MapIdx.htmlhxtheorem List.mapFinIdx_nil {α : Type u_1} {β : Type u_2} {f : (i : Nat) → α → i < 0 → β} :
[].mapFinIdx f = []h
huList.length_mapFinIdx_go}(hj
  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/MapIdx.htmlhX  theorem List.length_mapFinIdx_go {α✝ : Type u_1} {as : List α✝} {α✝¹ : Type u_2} {f : (i : Nat) → α✝ → i < as.length → α✝¹} {bs : List α✝} {acc : Array α✝¹} {h : bs.length + acc.size = as.length} :
(mapFinIdx.go as f bs acc h).length = as.lengthh
huList.length_mapFinIdx}(hj
  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/MapIdx.htmlhtheorem List.length_mapFinIdx {α : Type u_1} {β : Type u_2} {as : List α} {f : (i : Nat) → α → i < as.length → β} :
(as.mapFinIdx f).length = as.lengthh
huList.getElem_mapFinIdx_go}(hj
  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/MapIdx.htmlhXb  theorem List.getElem_mapFinIdx_go {α : Type u_1} {β : Type u_2} {bs : List α} {acc : Array β} {as : List α} {f : (i : Nat) → α → i < as.length → β} {i : Nat} {h : bs.length + acc.size = as.length} {w : i < (mapFinIdx.go as f bs acc h).length} :
(mapFinIdx.go as f bs acc h)[i] = if w' : i < acc.size then acc[i] else f i bs[i - acc.size] ⋯h
huList.getElem_mapFinIdx}(hj
  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/MapIdx.htmlhtheorem List.getElem_mapFinIdx {α : Type u_1} {β : Type u_2} {as : List α} {f : (i : Nat) → α → i < as.length → β} {i : Nat} {h : i < (as.mapFinIdx f).length} :
(as.mapFinIdx f)[i] = f i as[i] ⋯h
huList.mapFinIdx_eq_ofFn}(hj
  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/MapIdx.htmlhtheorem List.mapFinIdx_eq_ofFn {α : Type u_1} {β : Type u_2} {as : List α} {f : (i : Nat) → α → i < as.length → β} :
as.mapFinIdx f = ofFn fun (i : Fin as.length) => f (↑i) as[i] ⋯h
huList.getElem?_mapFinIdx}(hj
  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/MapIdx.htmlhtheorem List.getElem?_mapFinIdx {α : Type u_1} {β : Type u_2} {l : List α} {f : (i : Nat) → α → i < l.length → β} {i : Nat} :
(l.mapFinIdx f)[i]? = l[i]?.pbind fun (x : α) (m : l[i]? = some x) => some (f i x ⋯)h
huList.mapFinIdx_cons}(hj
  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/MapIdx.htmlhtheorem List.mapFinIdx_cons {α : Type u_1} {β : Type u_2} {l : List α} {a : α} {f : (i : Nat) → α → i < l.length + 1 → β} :
(a :: l).mapFinIdx f = f 0 a ⋯ :: l.mapFinIdx fun (i : Nat) (a : α) (h : i < l.length) => f (i + 1) a ⋯h
huList.mapFinIdx_append}(hj
  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/MapIdx.htmlhX?  theorem List.mapFinIdx_append {α : Type u_1} {β : Type u_2} {xs ys : List α} {f : (i : Nat) → α → i < (xs ++ ys).length → β} :
(xs ++ ys).mapFinIdx f = (xs.mapFinIdx fun (i : Nat) (a : α) (h : i < xs.length) => f i a ⋯) ++ ys.mapFinIdx fun (i : Nat) (a : α) (h : i < ys.length) => f (i + xs.length) a ⋯h
huList.mapFinIdx_concat}(hj
  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/MapIdx.htmlhX  theorem List.mapFinIdx_concat {α : Type u_1} {β : Type u_2} {l : List α} {e : α} {f : (i : Nat) → α → i < (l ++ [e]).length → β} :
(l ++ [e]).mapFinIdx f = (l.mapFinIdx fun (i : Nat) (a : α) (h : i < l.length) => f i a ⋯) ++ [f l.length e ⋯]h
huList.mapFinIdx_singleton}(hj
  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/MapIdx.htmlhtheorem List.mapFinIdx_singleton {α : Type u_1} {β : Type u_2} {a : α} {f : (i : Nat) → α → i < 1 → β} :
[a].mapFinIdx f = [f 0 a mapFinIdx_singleton._proof_1]h
huList.mapFinIdx_eq_zipIdx_map}(hj
  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/MapIdx.htmlhX  theorem List.mapFinIdx_eq_zipIdx_map {α : Type u_1} {β : Type u_2} {l : List α} {f : (i : Nat) → α → i < l.length → β} :
l.mapFinIdx f = map
    (fun (x : { x : α × Nat // x ∈ l.zipIdx }) =>
      match x with
      | ⟨(x, i), m⟩ => f i x ⋯)
    l.zipIdx.attachh
huList.mapFinIdx_eq_nil_iff}(hj
  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/MapIdx.htmlhtheorem List.mapFinIdx_eq_nil_iff {α : Type u_1} {β : Type u_2} {l : List α} {f : (i : Nat) → α → i < l.length → β} :
l.mapFinIdx f = [] ↔ l = []h
huList.mapFinIdx_ne_nil_iff}(hj
  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/MapIdx.htmlhtheorem List.mapFinIdx_ne_nil_iff {α : Type u_1} {β : Type u_2} {l : List α} {f : (i : Nat) → α → i < l.length → β} :
l.mapFinIdx f ≠ [] ↔ l ≠ []h
huList.exists_of_mem_mapFinIdx}(hj
  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/MapIdx.htmlhtheorem List.exists_of_mem_mapFinIdx {β : Type u_1} {α : Type u_2} {b : β} {l : List α} {f : (i : Nat) → α → i < l.length → β} (h : b ∈ l.mapFinIdx f) :
∃ (i : Nat), ∃ (h : i < l.length), f i l[i] h = bh
huList.mem_mapFinIdx}(hj  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/MapIdx.htmlhtheorem List.mem_mapFinIdx {β : Type u_1} {α : Type u_2} {b : β} {l : List α} {f : (i : Nat) → α → i < l.length → β} :
b ∈ l.mapFinIdx f ↔ ∃ (i : Nat), ∃ (h : i < l.length), f i l[i] h = bh
huList.mapFinIdx_eq_cons_iff}(hj  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/MapIdx.htmlhXd  theorem List.mapFinIdx_eq_cons_iff {α : Type u_1} {β : Type u_2} {l₂ : List β} {l : List α} {b : β} {f : (i : Nat) → α → i < l.length → β} :
l.mapFinIdx f = b :: l₂ ↔ ∃ (a : α), ∃ (l₁ : List α), ∃ (w : l = a :: l₁), f 0 a ⋯ = b ∧ (l₁.mapFinIdx fun (i : Nat) (a_1 : α) (h : i < l₁.length) => f (i + 1) a_1 ⋯) = l₂h
huList.mapFinIdx_eq_cons_iff'}(hj  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/MapIdx.htmlhX  theorem List.mapFinIdx_eq_cons_iff' {α : Type u_1} {β : Type u_2} {l₂ : List β} {l : List α} {b : β} {f : (i : Nat) → α → i < l.length → β} :
l.mapFinIdx f = b :: l₂ ↔ (l.head?.pbind fun (x : α) (m : l.head? = some x) => some (f 0 x ⋯)) = some b ∧ Option.map
        (fun (x : { x : List α // l.tail? = some x }) =>
          match x with
          | ⟨t, m⟩ => t.mapFinIdx fun (i : Nat) (a : α) (h : i < t.length) => f (i + 1) a ⋯)
        l.tail?.attach = some l₂h
huList.mapFinIdx_eq_iff}(hj  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/MapIdx.htmlhtheorem List.mapFinIdx_eq_iff {α : Type u_1} {β : Type u_2} {l' : List β} {l : List α} {f : (i : Nat) → α → i < l.length → β} :
l.mapFinIdx f = l' ↔ ∃ (h : l'.length = l.length), ∀ (i : Nat) (h_1 : i < l.length), l'[i] = f i l[i] h_1h
huList.mapFinIdx_eq_singleton_iff}(hj  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/MapIdx.htmlo      htheorem List.mapFinIdx_eq_singleton_iff {α : Type u_1} {β : Type u_2} {l : List α} {f : (i : Nat) → α → i < l.length → β} {b : β} :
l.mapFinIdx f = [b] ↔ ∃ (a : α), ∃ (w : l = [a]), f 0 a ⋯ = bh
huList.mapFinIdx_eq_append_iff}(hj  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/MapIdx.htmlhX  theorem List.mapFinIdx_eq_append_iff {α : Type u_1} {β : Type u_2} {l₁ l₂ : List β} {l : List α} {f : (i : Nat) → α → i < l.length → β} :
l.mapFinIdx f = l₁ ++ l₂ ↔ ∃ (l₁' : List α), ∃ (l₂' : List α), ∃ (w : l = l₁' ++ l₂'), (l₁'.mapFinIdx fun (i : Nat) (a : α) (h : i < l₁'.length) => f i a ⋯) = l₁ ∧ (l₂'.mapFinIdx fun (i : Nat) (a : α) (h : i < l₂'.length) => f (i + l₁'.length) a ⋯) = l₂h
huList.mapFinIdx_eq_mapFinIdx_iff}(hj  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/MapIdx.htmlhtheorem List.mapFinIdx_eq_mapFinIdx_iff {α : Type u_1} {β : Type u_2} {l : List α} {f g : (i : Nat) → α → i < l.length → β} :
l.mapFinIdx f = l.mapFinIdx g ↔ ∀ (i : Nat) (h : i < l.length), f i l[i] h = g i l[i] hh
huList.mapFinIdx_mapFinIdx}(hj  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/MapIdx.htmlhX5  theorem List.mapFinIdx_mapFinIdx {α : Type u_1} {β : Type u_2} {γ : Type u_3} {l : List α} {f : (i : Nat) → α → i < l.length → β} {g : (i : Nat) → β → i < (l.mapFinIdx f).length → γ} :
(l.mapFinIdx f).mapFinIdx g = l.mapFinIdx fun (i : Nat) (a : α) (h : i < l.length) => g i (f i a h) ⋯h
huList.mapFinIdx_eq_replicate_iff}(hj#  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/MapIdx.htmlhtheorem List.mapFinIdx_eq_replicate_iff {α : Type u_1} {β : Type u_2} {l : List α} {f : (i : Nat) → α → i < l.length → β} {b : β} :
l.mapFinIdx f = replicate l.length b ↔ ∀ (i : Nat) (h : i < l.length), f i l[i] h = bh
huList.mapFinIdx_reverse}(hj'  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/MapIdx.htmlhtheorem List.mapFinIdx_reverse {α : Type u_1} {β : Type u_2} {l : List α} {f : (i : Nat) → α → i < l.reverse.length → β} :
l.reverse.mapFinIdx f = (l.mapFinIdx fun (i : Nat) (a : α) (h : i < l.length) => f (l.length - 1 - i) a ⋯).reverseh
huList.mapIdx_nil}(hj+  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/MapIdx.htmlhbtheorem List.mapIdx_nil {α : Type u_1} {β : Type u_2} {f : Nat → α → β} :
mapIdx f [] = []h
huList.mapIdx_go_length}(hj/  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/MapIdx.htmlhtheorem List.mapIdx_go_length {β : Type u_1} {α✝ : Type u_2} {f : Nat → α✝ → β} {l : List α✝} {acc : Array β} :
(mapIdx.go f l acc).length = l.length + acc.sizeh
huList.length_mapIdx_go}(hj3  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/MapIdx.htmlhtheorem List.length_mapIdx_go {α : Type u_1} {β : Type u_2} {f : Nat → α → β} {l : List α} {acc : Array β} :
(mapIdx.go f l acc).length = l.length + acc.sizeh
huList.length_mapIdx}(hj7  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/MapIdx.htmlhtheorem List.length_mapIdx {α : Type u_1} {α✝ : Type u_2} {f : Nat → α → α✝} {l : List α} :
(mapIdx f l).length = l.lengthh
huList.getElem?_mapIdx_go}(hj;  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/MapIdx.htmlhtheorem List.getElem?_mapIdx_go {α : Type u_1} {β : Type u_2} {f : Nat → α → β} {l : List α} {acc : Array β} {i : Nat} :
(mapIdx.go f l acc)[i]? = if h : i < acc.size then some acc[i] else Option.map (f i) l[i - acc.size]?h
huList.getElem?_mapIdx}(hj?  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/MapIdx.htmlhtheorem List.getElem?_mapIdx {α : Type u_1} {α✝ : Type u_2} {f : Nat → α → α✝} {l : List α} {i : Nat} :
(mapIdx f l)[i]? = Option.map (f i) l[i]?h
huList.getElem_mapIdx}(hjC  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/MapIdx.htmlhtheorem List.getElem_mapIdx {α : Type u_1} {β : Type u_2} {l : List α} {f : Nat → α → β} {i : Nat} {h : i < (mapIdx f l).length} :
(mapIdx f l)[i] = f i l[i]h
huList.mapFinIdx_eq_mapIdx}(hjG  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/MapIdx.htmlhtheorem List.mapFinIdx_eq_mapIdx {α : Type u_1} {β : Type u_2} {l : List α} {f : (i : Nat) → α → i < l.length → β} {g : Nat → α → β} (h : ∀ (i : Nat) (h : i < l.length), f i l[i] h = g i l[i]) :
l.mapFinIdx f = mapIdx g lh
huList.mapIdx_eq_mapFinIdx}(hjK  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/MapIdx.htmlhtheorem List.mapIdx_eq_mapFinIdx {α : Type u_1} {β : Type u_2} {l : List α} {f : Nat → α → β} :
mapIdx f l = l.mapFinIdx fun (i : Nat) (a : α) (x : i < l.length) => f i ah
huList.mapIdx_eq_zipIdx_map}(hjO  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/MapIdx.htmlhtheorem List.mapIdx_eq_zipIdx_map {α : Type u_1} {β : Type u_2} {l : List α} {f : Nat → α → β} :
mapIdx f l = map
    (fun (x : α × Nat) =>
      match x with
      | (a, i) => f i a)
    l.zipIdxh
huList.mapIdx_cons}(hjS  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/MapIdx.htmlhtheorem List.mapIdx_cons {α : Type u_1} {α✝ : Type u_2} {f : Nat → α → α✝} {l : List α} {a : α} :
mapIdx f (a :: l) = f 0 a :: mapIdx (fun (i : Nat) => f (i + 1)) lh
huList.mapIdx_append}(hjW  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/MapIdx.htmlhtheorem List.mapIdx_append {α : Type u_1} {α✝ : Type u_2} {f : Nat → α → α✝} {xs ys : List α} :
mapIdx f (xs ++ ys) = mapIdx f xs ++ mapIdx (fun (i : Nat) => f (i + xs.length)) ysh
huList.mapIdx_concat}(hj[  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/MapIdx.htmlhtheorem List.mapIdx_concat {α : Type u_1} {α✝ : Type u_2} {f : Nat → α → α✝} {l : List α} {e : α} :
mapIdx f (l ++ [e]) = mapIdx f l ++ [f l.length e]h
huList.mapIdx_singleton}(hj_  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/MapIdx.htmlh}theorem List.mapIdx_singleton {α : Type u_1} {α✝ : Type u_2} {f : Nat → α → α✝} {a : α} :
mapIdx f [a] = [f 0 a]h
huList.mapIdx_eq_nil_iff}(hjc  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/MapIdx.htmlhtheorem List.mapIdx_eq_nil_iff {α : Type u_1} {α✝ : Type u_2} {f : Nat → α → α✝} {l : List α} :
mapIdx f l = [] ↔ l = []h
huList.mapIdx_ne_nil_iff}(hjg  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/MapIdx.htmlhtheorem List.mapIdx_ne_nil_iff {α : Type u_1} {α✝ : Type u_2} {f : Nat → α → α✝} {l : List α} :
mapIdx f l ≠ [] ↔ l ≠ []h
huList.exists_of_mem_mapIdx}(hjk  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/MapIdx.htmlhtheorem List.exists_of_mem_mapIdx {β : Type u_1} {α : Type u_2} {f : Nat → α → β} {b : β} {l : List α} (h : b ∈ mapIdx f l) :
∃ (i : Nat), ∃ (h : i < l.length), f i l[i] = bh
huList.mem_mapIdx}(hjo  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/MapIdx.htmlhtheorem List.mem_mapIdx {β : Type u_1} {α : Type u_2} {f : Nat → α → β} {b : β} {l : List α} :
b ∈ mapIdx f l ↔ ∃ (i : Nat), ∃ (h : i < l.length), f i l[i] = bh
huList.mapIdx_eq_cons_iff}(hjs  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/MapIdx.htmlhX  theorem List.mapIdx_eq_cons_iff {α : Type u_1} {β : Type u_2} {f : Nat → α → β} {l₂ : List β} {l : List α} {b : β} :
mapIdx f l = b :: l₂ ↔ ∃ (a : α), ∃ (l₁ : List α), l = a :: l₁ ∧ f 0 a = b ∧ mapIdx (fun (i : Nat) => f (i + 1)) l₁ = l₂h
huList.mapIdx_eq_cons_iff'}(hjw  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/MapIdx.htmlhX  theorem List.mapIdx_eq_cons_iff' {α : Type u_1} {β : Type u_2} {f : Nat → α → β} {l₂ : List β} {l : List α} {b : β} :
mapIdx f l = b :: l₂ ↔ Option.map (f 0) l.head? = some b ∧ Option.map (mapIdx fun (i : Nat) => f (i + 1)) l.tail? = some l₂h
huList.mapIdx_eq_singleton_iff}(hj{  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/MapIdx.htmlhtheorem List.mapIdx_eq_singleton_iff {α : Type u_1} {β : Type u_2} {l : List α} {f : Nat → α → β} {b : β} :
mapIdx f l = [b] ↔ ∃ (a : α), l = [a] ∧ f 0 a = bh
huList.mapIdx_eq_iff}(hj  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/MapIdx.htmlhtheorem List.mapIdx_eq_iff {α : Type u_1} {α✝ : Type u_2} {f : Nat → α → α✝} {l' : List α✝} {l : List α} :
mapIdx f l = l' ↔ ∀ (i : Nat), l'[i]? = Option.map (f i) l[i]?h
huList.mapIdx_eq_append_iff}(hj  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/MapIdx.htmlhXA  theorem List.mapIdx_eq_append_iff {α : Type u_1} {α✝ : Type u_2} {f : Nat → α → α✝} {l₁ l₂ : List α✝} {l : List α} :
mapIdx f l = l₁ ++ l₂ ↔ ∃ (l₁' : List α), ∃ (l₂' : List α), l = l₁' ++ l₂' ∧ mapIdx f l₁' = l₁ ∧ mapIdx (fun (i : Nat) => f (i + l₁'.length)) l₂' = l₂h
huList.mapIdx_eq_mapIdx_iff}(hj  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/MapIdx.htmlhtheorem List.mapIdx_eq_mapIdx_iff {α : Type u_1} {α✝ : Type u_2} {f g : Nat → α → α✝} {l : List α} :
mapIdx f l = mapIdx g l ↔ ∀ (i : Nat) (h : i < l.length), f i l[i] = g i l[i]h
huList.mapIdx_set}(hj  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/MapIdx.htmlhtheorem List.mapIdx_set {α : Type u_1} {α✝ : Type u_2} {f : Nat → α → α✝} {l : List α} {i : Nat} {a : α} :
mapIdx f (l.set i a) = (mapIdx f l).set i (f i a)h
huList.head_mapIdx}(hj  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/MapIdx.htmlhtheorem List.head_mapIdx {α : Type u_1} {β : Type u_2} {l : List α} {f : Nat → α → β} {w : mapIdx f l ≠ []} :
(mapIdx f l).head w = f 0 (l.head ⋯)h
huList.head?_mapIdx}(hj  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/MapIdx.htmlhtheorem List.head?_mapIdx {α : Type u_1} {β : Type u_2} {l : List α} {f : Nat → α → β} :
(mapIdx f l).head? = Option.map (f 0) l.head?h
huList.getLast_mapIdx}(hj  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/MapIdx.htmlhtheorem List.getLast_mapIdx {α : Type u_1} {β : Type u_2} {l : List α} {f : Nat → α → β} {h : mapIdx f l ≠ []} :
(mapIdx f l).getLast h = f (l.length - 1) (l.getLast ⋯)h
huList.getLast?_mapIdx}(hj  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/MapIdx.htmlhtheorem List.getLast?_mapIdx {α : Type u_1} {β : Type u_2} {l : List α} {f : Nat → α → β} :
(mapIdx f l).getLast? = Option.map (f (l.length - 1)) l.getLast?h
huList.mapIdx_mapIdx}(hj  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/MapIdx.htmlhtheorem List.mapIdx_mapIdx {α : Type u_1} {β : Type u_2} {γ : Type u_3} {l : List α} {f : Nat → α → β} {g : Nat → β → γ} :
mapIdx g (mapIdx f l) = mapIdx (fun (i : Nat) => g i ∘ f i) lh
huList.mapIdx_eq_replicate_iff}(hj  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/MapIdx.htmlhtheorem List.mapIdx_eq_replicate_iff {α : Type u_1} {β : Type u_2} {l : List α} {f : Nat → α → β} {b : β} :
mapIdx f l = replicate l.length b ↔ ∀ (i : Nat) (h : i < l.length), f i l[i] = bh
huList.mapIdx_reverse}(hj  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/MapIdx.htmlhtheorem List.mapIdx_reverse {α : Type u_1} {β : Type u_2} {l : List α} {f : Nat → α → β} :
mapIdx f l.reverse = (mapIdx (fun (i : Nat) => f (l.length - 1 - i)) l).reverseh
huList.countP_set}(hj  hRhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Count.htmlhtheorem List.countP_set {α : Type u_1} {p : α → Bool} {l : List α} {i : Nat} {a : α} (h : i < l.length) :
countP p (l.set i a) = (countP p l - if p l[i] = true then 1 else 0) + if p a = true then 1 else 0h
huList.count_set}(hj  hRhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Count.htmlhtheorem List.count_set {α : Type u_1} [BEq α] {a b : α} {l : List α} {i : Nat} (h : i < l.length) :
count b (l.set i a) = (count b l - if (l[i] == b) = true then 1 else 0) + if (a == b) = true then 1 else 0h
huList.countP_replace}(hj  hRhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Count.htmlhX   theorem List.countP_replace {α : Type u_1} [BEq α] [LawfulBEq α] {a b : α} {l : List α} {p : α → Bool} :
countP p (l.replace a b) = if l.contains a = true then (countP p l + if p b = true then 1 else 0) - if p a = true then 1 else 0 else countP p lh
huList.count_replace}(hj  hRhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Count.htmlhtheorem List.count_replace {α : Type u_1} [BEq α] [LawfulBEq α] {a b c : α} {l : List α} :
count c (l.replace a b) = if l.contains a = true then (count c l + if (b == c) = true then 1 else 0) - if (a == c) = true then 1 else 0 else count c lh
huList.count_insert}(hj  hRhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Count.htmlhtheorem List.count_insert {α : Type u_1} [BEq α] [LawfulBEq α] {a b : α} {l : List α} :
count a (List.insert b l) = max (count a l) (if (b == a) = true then 1 else 0)h
huList.le_countP_tail}(hj  hRhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Count.htmlhytheorem List.le_countP_tail {α✝ : Type u_1} {p : α✝ → Bool} {l : List α✝} :
countP p l - 1 ≤ countP p l.tailh
The number of elements satisfying a predicate in the tail of a list is at least one less than the number of elements satisfying the predicate in the list.uList.le_count_tail}(hj  hRhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Count.htmlhmtheorem List.le_count_tail {α : Type u_1} [BEq α] {a : α} {l : List α} :
count a l - 1 ≤ count a l.tailh
huList.find?_eq_some_iff_getElem}(hj  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Find.htmlhtheorem List.find?_eq_some_iff_getElem {α : Type u_1} {xs : List α} {p : α → Bool} {b : α} :
find? p xs = some b ↔ p b = true ∧ ∃ (i : Nat), ∃ (h : i < xs.length), xs[i] = b ∧ ∀ (j : Nat) (hj : j < i), (!p xs[j]) = trueh
hu,List.findIdx?_eq_some_le_of_findIdx?_eq_some}(hj  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Find.htmlhtheorem List.findIdx?_eq_some_le_of_findIdx?_eq_some {α : Type u_1} {xs : List α} {p q : α → Bool} (w : ∀ (x : α), x ∈ xs → p x = true → q x = true) {i : Nat} (h : findIdx? p xs = some i) :
∃ (j : Nat), j ≤ i ∧ findIdx? q xs = some jh
huList.tail_dropLast}(hj  hRhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Basic.htmlh\theorem List.tail_dropLast {α : Type u_1} {l : List α} :
l.dropLast.tail = l.tail.dropLasth
huList.dropLast_reverse}(hj  hRhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Basic.htmlhatheorem List.dropLast_reverse {α : Type u_1} {l : List α} :
l.reverse.dropLast = l.tail.reverseh
huList.length_filter_pos_iff}(hj  hRhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Basic.htmlhtheorem List.length_filter_pos_iff {α : Type u_1} {l : List α} {p : α → Bool} :
0 < (filter p l).length ↔ ∃ (x : α), x ∈ l ∧ p x = trueh
hu'List.length_filter_lt_length_iff_exists}(hj  hRhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Basic.htmlhtheorem List.length_filter_lt_length_iff_exists {α✝ : Type u_1} {p : α✝ → Bool} {l : List α✝} :
(filter p l).length < l.length ↔ ∃ (x : α✝), x ∈ l ∧ ¬p x = trueh
huList.length_filterMap_pos_iff}(hj  hRhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Basic.htmlhtheorem List.length_filterMap_pos_iff {α : Type u_1} {β : Type u_2} {xs : List α} {f : α → Option β} :
0 < (filterMap f xs).length ↔ ∃ (x : α), ∃ (x_1 : x ∈ xs), ∃ (b : β), f x = some bh
hu*List.length_filterMap_lt_length_iff_exists}(hj  hRhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Basic.htmlhtheorem List.length_filterMap_lt_length_iff_exists {α : Type u_1} {β : Type u_2} {xs : List α} {f : α → Option β} :
(filterMap f xs).length < xs.length ↔ ∃ (x : α), ∃ (x_1 : x ∈ xs), f x = noneh
huList.getElem_eq_getElem_reverse}(hj  hRhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Basic.htmlhtheorem List.getElem_eq_getElem_reverse {α : Type u_1} {l : List α} {i : Nat} (h : i < l.length) :
l[i] = l.reverse[l.length - 1 - i]h
huList.length_leftpad}(hj  hRhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Basic.htmlhvtheorem List.length_leftpad {α : Type u_1} {n : Nat} {a : α} {l : List α} :
(leftpad n a l).length = max n l.lengthh
^The length of the List returned by List.leftpad n a l is equal to the larger of n and l.lengthuList.leftpad_length}(hj  hRhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Basic.htmlhuabbrev List.leftpad_length {α : Type u_1} {n : Nat} {a : α} {l : List α} :
(leftpad n a l).length = max n l.lengthh
huList.length_rightpad}(hj  hRhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Basic.htmlhxtheorem List.length_rightpad {α : Type u_1} {n : Nat} {a : α} {l : List α} :
(rightpad n a l).length = max n l.lengthh
huList.length_intersperse}(hj  hRhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Basic.htmlhxtheorem List.length_intersperse {α : Type u_1} {l : List α} {sep : α} :
(intersperse sep l).length = 2 * l.length - 1h
hu!List.getElem?_intersperse_two_mul}(hj  hRhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Basic.htmlhtheorem List.getElem?_intersperse_two_mul {α : Type u_1} {l : List α} {sep : α} {i : Nat} :
(intersperse sep l)[2 * i]? = l[i]?h
hu)List.getElem?_intersperse_two_mul_add_one}(hj  hRhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Basic.htmlhtheorem List.getElem?_intersperse_two_mul_add_one {α : Type u_1} {l : List α} {sep : α} {i : Nat} (h : i + 1 < l.length) :
(intersperse sep l)[2 * i + 1]? = some seph
huList.getElem?_intersperse}(hj  hRhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Basic.htmlhtheorem List.getElem?_intersperse {α : Type u_1} {l : List α} {sep : α} {i : Nat} :
(intersperse sep l)[i]? = if i % 2 = 0 then l[i / 2]? else if i < 2 * l.length - 1 then some sep else noneh
hu List.getElem_intersperse_two_mul}(hj	  hRhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Basic.htmlhtheorem List.getElem_intersperse_two_mul {α : Type u_1} {l : List α} {sep : α} {i : Nat} (h : 2 * i < (intersperse sep l).length) :
(intersperse sep l)[2 * i] = l[i]h
hu(List.getElem_intersperse_two_mul_add_one}(hj
  hRhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Basic.htmlhtheorem List.getElem_intersperse_two_mul_add_one {α : Type u_1} {l : List α} {sep : α} {i : Nat} (h : 2 * i + 1 < (intersperse sep l).length) :
(intersperse sep l)[2 * i + 1] = seph
huList.getElem_intersperse}(hj  hRhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Basic.htmlhtheorem List.getElem_intersperse {α : Type u_1} {l : List α} {sep : α} {i : Nat} (h : i < (intersperse sep l).length) :
(intersperse sep l)[i] = if i % 2 = 0 then l[i / 2] else seph
hu+List.getElem_eq_getElem_intersperse_two_mul}(hj  hRhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Basic.htmlhtheorem List.getElem_eq_getElem_intersperse_two_mul {α : Type u_1} {l : List α} {sep : α} {i : Nat} (h : i < l.length) :
l[i] = (intersperse sep l)[2 * i]h
huList.mem_eraseIdx_iff_getElem}(hj  hRhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Basic.htmlhtheorem List.mem_eraseIdx_iff_getElem {α : Type u_1} {x : α} {l : List α} {k : Nat} :
x ∈ l.eraseIdx k ↔ ∃ (i : Nat), ∃ (h : i < l.length), i ≠ k ∧ l[i] = xh
huList.mem_eraseIdx_iff_getElem?}(hj  hRhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Basic.htmlhtheorem List.mem_eraseIdx_iff_getElem? {α : Type u_1} {x : α} {l : List α} {k : Nat} :
x ∈ l.eraseIdx k ↔ ∃ (i : Nat), i ≠ k ∧ l[i]? = some xh
huList.min?_eq_some_iff'}(hj!  hRhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Basic.htmlhtheorem List.min?_eq_some_iff' {a : Nat} {xs : List Nat} :
xs.min? = some a ↔ a ∈ xs ∧ ∀ (b : Nat), b ∈ xs → a ≤ bh
huList.min?_get_le_of_mem}(hj%  hRhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Basic.htmlh]theorem List.min?_get_le_of_mem {l : List Nat} {a : Nat} (h : a ∈ l) :
l.min?.get ⋯ ≤ ah
huList.min?_getD_le_of_mem}(hj)  hRhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Basic.htmlh_theorem List.min?_getD_le_of_mem {l : List Nat} {a k : Nat} (h : a ∈ l) :
l.min?.getD k ≤ ah
huList.max?_eq_some_iff'}(hj-  hRhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Basic.htmlhtheorem List.max?_eq_some_iff' {a : Nat} {xs : List Nat} :
xs.max? = some a ↔ a ∈ xs ∧ ∀ (b : Nat), b ∈ xs → b ≤ ah
huList.le_max?_get_of_mem}(hj1  hRhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Basic.htmlh]theorem List.le_max?_get_of_mem {l : List Nat} {a : Nat} (h : a ∈ l) :
a ≤ l.max?.get ⋯h
huList.le_max?_getD_of_mem}(hj5  hRhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Basic.htmlh_theorem List.le_max?_getD_of_mem {l : List Nat} {a k : Nat} (h : a ∈ l) :
a ≤ l.max?.getD kh
huList.getElem?_eraseIdx}(hj9  hRhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Erase.htmlhtheorem List.getElem?_eraseIdx {α : Type u_1} {l : List α} {i j : Nat} :
(l.eraseIdx i)[j]? = if j < i then l[j]? else l[j + 1]?h
huList.getElem?_eraseIdx_of_lt}(hj=  hRhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Erase.htmlhwtheorem List.getElem?_eraseIdx_of_lt {α : Type u_1} {l : List α} {i j : Nat} (h : j < i) :
(l.eraseIdx i)[j]? = l[j]?h
huList.getElem?_eraseIdx_of_ge}(hjA  hRhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Erase.htmlh}theorem List.getElem?_eraseIdx_of_ge {α : Type u_1} {l : List α} {i j : Nat} (h : i ≤ j) :
(l.eraseIdx i)[j]? = l[j + 1]?h
huList.getElem_eraseIdx}(hjE  hRhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Erase.htmlhtheorem List.getElem_eraseIdx {α : Type u_1} {l : List α} {i j : Nat} (h : j < (l.eraseIdx i).length) :
(l.eraseIdx i)[j] = if h' : j < i then l[j] else l[j + 1]h
huList.getElem_eraseIdx_of_lt}(hjI  hRhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Erase.htmlhtheorem List.getElem_eraseIdx_of_lt {α : Type u_1} {l : List α} {i j : Nat} (h : j < (l.eraseIdx i).length) (h' : j < i) :
(l.eraseIdx i)[j] = l[j]h
huList.getElem_eraseIdx_of_ge}(hjM  hRhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Erase.htmlhtheorem List.getElem_eraseIdx_of_ge {α : Type u_1} {l : List α} {i j : Nat} (h : j < (l.eraseIdx i).length) (h' : i ≤ j) :
(l.eraseIdx i)[j] = l[j + 1]h
huList.eraseIdx_eq_dropLast}(hjQ  hRhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Erase.htmlh|theorem List.eraseIdx_eq_dropLast {α : Type u_1} {l : List α} {i : Nat} (h : i + 1 = l.length) :
l.eraseIdx i = l.dropLasth
huList.eraseIdx_set_eq}(hjU  hRhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Erase.htmlhutheorem List.eraseIdx_set_eq {α : Type u_1} {l : List α} {i : Nat} {a : α} :
(l.set i a).eraseIdx i = l.eraseIdx ih
huList.eraseIdx_set_lt}(hjY  hRhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Erase.htmlhtheorem List.eraseIdx_set_lt {α : Type u_1} {l : List α} {i j : Nat} {a : α} (h : j < i) :
(l.set i a).eraseIdx j = (l.eraseIdx j).set (i - 1) ah
huList.eraseIdx_set_gt}(hj]  hRhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Erase.htmlhtheorem List.eraseIdx_set_gt {α : Type u_1} {l : List α} {i j : Nat} {a : α} (h : i < j) :
(l.set i a).eraseIdx j = (l.eraseIdx j).set i ah
huList.eraseIdx_set}(hja  hRhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Erase.htmlhtheorem List.eraseIdx_set {α : Type u_1} {xs : List α} {i : Nat} {a : α} {j : Nat} :
(xs.set i a).eraseIdx j = if j < i then (xs.eraseIdx j).set (i - 1) a else if j = i then xs.eraseIdx i else (xs.eraseIdx j).set i ah
huList.set_eraseIdx_le}(hje  hRhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Erase.htmlhtheorem List.set_eraseIdx_le {α : Type u_1} {xs : List α} {i j : Nat} {a : α} (h : i ≤ j) :
(xs.eraseIdx i).set j a = (xs.set (j + 1) a).eraseIdx ih
huList.set_eraseIdx_gt}(hji  hRhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Erase.htmlhtheorem List.set_eraseIdx_gt {α : Type u_1} {xs : List α} {i j : Nat} {a : α} (h : j < i) :
(xs.eraseIdx i).set j a = (xs.set j a).eraseIdx ih
huList.set_eraseIdx}(hjm  hRhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Erase.htmlhtheorem List.set_eraseIdx {α : Type u_1} {xs : List α} {i j : Nat} {a : α} :
(xs.eraseIdx i).set j a = if i ≤ j then (xs.set (j + 1) a).eraseIdx i else (xs.set j a).eraseIdx ih
hu#List.set_getElem_succ_eraseIdx_succ}(hjq  hRhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Erase.htmlhtheorem List.set_getElem_succ_eraseIdx_succ {α : Type u_1} {l : List α} {i : Nat} (h : i + 1 < l.length) :
(l.eraseIdx (i + 1)).set i l[i + 1] = l.eraseIdx ih
huList.eraseIdx_length_sub_one}(hju  hRhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Erase.htmlhktheorem List.eraseIdx_length_sub_one {α : Type u_1} {l : List α} :
l.eraseIdx (l.length - 1) = l.dropLasth
huList.findSome?_cons_of_isSome}(hjy  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Find.htmlhtheorem List.findSome?_cons_of_isSome {α✝ : Type u_1} {α✝¹ : Type u_2} {f : α✝ → Option α✝¹} {a : α✝} {l : List α✝} (h : (f a).isSome = true) :
findSome? f (a :: l) = f ah
huList.findSome?_cons_of_isNone}(hj}  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Find.htmlhtheorem List.findSome?_cons_of_isNone {α✝ : Type u_1} {α✝¹ : Type u_2} {f : α✝ → Option α✝¹} {a : α✝} {l : List α✝} (h : (f a).isNone = true) :
findSome? f (a :: l) = findSome? f lh
hu List.exists_of_findSome?_eq_some}(hj  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Find.htmlhtheorem List.exists_of_findSome?_eq_some {α : Type u_1} {β : Type u_2} {b : β} {l : List α} {f : α → Option β} (w : findSome? f l = some b) :
∃ (a : α), a ∈ l ∧ f a = some bh
huList.findSome?_eq_none_iff}(hj  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Find.htmlhtheorem List.findSome?_eq_none_iff {α✝ : Type u_1} {α✝¹ : Type u_2} {p : α✝ → Option α✝¹} {l : List α✝} :
findSome? p l = none ↔ ∀ (x : α✝), x ∈ l → p x = noneh
huList.findSome?_isSome_iff}(hj  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Find.htmlhtheorem List.findSome?_isSome_iff {α : Type u_1} {β : Type u_2} {f : α → Option β} {l : List α} :
(findSome? f l).isSome = true ↔ ∃ (x : α), x ∈ l ∧ (f x).isSome = trueh
huList.findSome?_eq_some_iff}(hj  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Find.htmlhX  theorem List.findSome?_eq_some_iff {α : Type u_1} {β : Type u_2} {f : α → Option β} {l : List α} {b : β} :
findSome? f l = some b ↔ ∃ (l₁ : List α), ∃ (a : α), ∃ (l₂ : List α), l = l₁ ++ a :: l₂ ∧ f a = some b ∧ ∀ (x : α), x ∈ l₁ → f x = noneh
huList.findSome?_guard}(hj  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Find.htmlhwtheorem List.findSome?_guard {α : Type u_1} {p : α → Bool} {l : List α} :
findSome? (Option.guard p) l = find? p lh
huList.find?_eq_findSome?_guard}(hj  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Find.htmlhtheorem List.find?_eq_findSome?_guard {α : Type u_1} {p : α → Bool} {l : List α} :
find? p l = findSome? (Option.guard p) lh
huList.head?_filterMap}(hj  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Find.htmlhtheorem List.head?_filterMap {α : Type u_1} {β : Type u_2} {f : α → Option β} {l : List α} :
(filterMap f l).head? = findSome? f lh
huList.head_filterMap}(hj  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Find.htmlhtheorem List.head_filterMap {α : Type u_1} {β : Type u_2} {f : α → Option β} {l : List α} (h : filterMap f l ≠ []) :
(filterMap f l).head h = (findSome? f l).get ⋯h
huList.getLast?_filterMap}(hj  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Find.htmlhtheorem List.getLast?_filterMap {α : Type u_1} {β : Type u_2} {f : α → Option β} {l : List α} :
(filterMap f l).getLast? = findSome? f l.reverseh
huList.getLast_filterMap}(hj  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Find.htmlhtheorem List.getLast_filterMap {α : Type u_1} {β : Type u_2} {f : α → Option β} {l : List α} (h : filterMap f l ≠ []) :
(filterMap f l).getLast h = (findSome? f l.reverse).get ⋯h
huList.map_findSome?}(hj  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Find.htmlhtheorem List.map_findSome? {α : Type u_1} {β : Type u_2} {γ : Type u_3} {f : α → Option β} {g : β → γ} {l : List α} :
Option.map g (findSome? f l) = findSome? (Option.map g ∘ f) lh
huList.findSome?_map}(hj  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Find.htmlhtheorem List.findSome?_map {β : Type u_1} {γ : Type u_2} {α✝ : Type u_3} {p : γ → Option α✝} {f : β → γ} {l : List β} :
findSome? p (map f l) = findSome? (p ∘ f) lh
huList.head_flatten}(hj  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Find.htmlhtheorem List.head_flatten {α : Type u_1} {L : List (List α)} (h : ∃ (l : List α), l ∈ L ∧ l ≠ []) :
L.flatten.head ⋯ = (findSome? head? L).get ⋯h
huList.getLast_flatten}(hj  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Find.htmlhtheorem List.getLast_flatten {α : Type u_1} {L : List (List α)} (h : ∃ (l : List α), l ∈ L ∧ l ≠ []) :
L.flatten.getLast ⋯ = (findSome? getLast? L.reverse).get ⋯h
huList.findSome?_replicate}(hj  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Find.htmlhtheorem List.findSome?_replicate {α✝ : Type u_1} {α✝¹ : Type u_2} {f : α✝ → Option α✝¹} {n : Nat} {a : α✝} :
findSome? f (replicate n a) = if n = 0 then none else f ah
huList.findSome?_replicate_of_pos}(hj  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Find.htmlhtheorem List.findSome?_replicate_of_pos {n : Nat} {α✝ : Type u_1} {α✝¹ : Type u_2} {f : α✝ → Option α✝¹} {a : α✝} (h : 0 < n) :
findSome? f (replicate n a) = f ah
hu"List.findSome?_replicate_of_isSome}(hj  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Find.htmlhtheorem List.findSome?_replicate_of_isSome {α✝ : Type u_1} {α✝¹ : Type u_2} {f : α✝ → Option α✝¹} {n : Nat} {a : α✝} :
(f a).isSome = true → findSome? f (replicate n a) = if n = 0 then none else f ah
hu"List.findSome?_replicate_of_isNone}(hj  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Find.htmlhtheorem List.findSome?_replicate_of_isNone {α✝ : Type u_1} {α✝¹ : Type u_2} {f : α✝ → Option α✝¹} {n : Nat} {a : α✝} (h : (f a).isNone = true) :
findSome? f (replicate n a) = noneh
huList.find?_cons_of_pos}(hj  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Find.htmlhtheorem List.find?_cons_of_pos {α✝ : Type u_1} {p : α✝ → Bool} {a : α✝} {l : List α✝} (h : p a = true) :
find? p (a :: l) = some ah
huList.find?_cons_of_neg}(hj  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Find.htmlhtheorem List.find?_cons_of_neg {α✝ : Type u_1} {p : α✝ → Bool} {a : α✝} {l : List α✝} (h : ¬p a = true) :
find? p (a :: l) = find? p lh
huList.find?_eq_none}(hj  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Find.htmlhtheorem List.find?_eq_none {α✝ : Type u_1} {p : α✝ → Bool} {l : List α✝} :
find? p l = none ↔ ∀ (x : α✝), x ∈ l → ¬p x = trueh
huList.find?_eq_some_iff_append}(hj  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Find.htmlhX  theorem List.find?_eq_some_iff_append {α✝ : Type u_1} {b : α✝} {p : α✝ → Bool} {xs : List α✝} :
find? p xs = some b ↔ p b = true ∧ ∃ (as : List α✝), ∃ (bs : List α✝), xs = as ++ b :: bs ∧ ∀ (a : α✝), a ∈ as → (!p a) = trueh
huList.find?_cons_eq_some}(hj  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Find.htmlhtheorem List.find?_cons_eq_some {α✝ : Type u_1} {a : α✝} {xs : List α✝} {p : α✝ → Bool} {b : α✝} :
find? p (a :: xs) = some b ↔ p a = true ∧ a = b ∨ (!p a) = true ∧ find? p xs = some bh
huList.find?_isSome}(hj  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Find.htmlhtheorem List.find?_isSome {α : Type u_1} {xs : List α} {p : α → Bool} :
(find? p xs).isSome = true ↔ ∃ (x : α), x ∈ xs ∧ p x = trueh
huList.find?_some}(hj  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Find.htmlhtheorem List.find?_some {α✝ : Type u_1} {p : α✝ → Bool} {a : α✝} {l : List α✝} :
find? p l = some a → p a = trueh
huList.mem_of_find?_eq_some}(hj  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Find.htmlhtheorem List.mem_of_find?_eq_some {α✝ : Type u_1} {p : α✝ → Bool} {a : α✝} {l : List α✝} :
find? p l = some a → a ∈ lh
huList.get_find?_mem}(hj  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Find.htmlhtheorem List.get_find?_mem {α : Type u_1} {xs : List α} {p : α → Bool} (h : (find? p xs).isSome = true) :
(find? p xs).get h ∈ xsh
huList.find?_filter}(hj  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Find.htmlhtheorem List.find?_filter {α : Type u_1} {xs : List α} {p q : α → Bool} :
find? q (filter p xs) = find? (fun (a : α) => decide (p a = true ∧ q a = true)) xsh
huList.head?_filter}(hj  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Find.htmlhjtheorem List.head?_filter {α : Type u_1} {p : α → Bool} {l : List α} :
(filter p l).head? = find? p lh
huList.head_filter}(hj  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Find.htmlhtheorem List.head_filter {α : Type u_1} {p : α → Bool} {l : List α} (h : filter p l ≠ []) :
(filter p l).head h = (find? p l).get ⋯h
huList.getLast?_filter}(hj  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Find.htmlhxtheorem List.getLast?_filter {α : Type u_1} {p : α → Bool} {l : List α} :
(filter p l).getLast? = find? p l.reverseh
huList.getLast_filter}(hj  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Find.htmlhtheorem List.getLast_filter {α : Type u_1} {p : α → Bool} {l : List α} (h : filter p l ≠ []) :
(filter p l).getLast h = (find? p l.reverse).get ⋯h
huList.find?_filterMap}(hj  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Find.htmlhtheorem List.find?_filterMap {α : Type u_1} {β : Type u_2} {xs : List α} {f : α → Option β} {p : β → Bool} :
find? p (filterMap f xs) = (find? (fun (a : α) => Option.any p (f a)) xs).bind fh
huList.find?_map}(hj  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Find.htmlhtheorem List.find?_map {β : Type u_1} {α : Type u_2} {p : α → Bool} {f : β → α} {l : List β} :
find? p (map f l) = Option.map f (find? (p ∘ f) l)h
huList.find?_flatten}(hj	  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Find.htmlhtheorem List.find?_flatten {α : Type u_1} {xss : List (List α)} {p : α → Bool} :
find? p xss.flatten = findSome? (find? p) xssh
huList.find?_flatten_eq_none_iff}(hj
  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Find.htmlhtheorem List.find?_flatten_eq_none_iff {α : Type u_1} {xs : List (List α)} {p : α → Bool} :
find? p xs.flatten = none ↔ ∀ (ys : List α), ys ∈ xs → ∀ (x : α), x ∈ ys → (!p x) = trueh
huList.find?_flatten_eq_none}(hj  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Find.htmlhabbrev List.find?_flatten_eq_none {α : Type u_1} {xs : List (List α)} {p : α → Bool} :
find? p xs.flatten = none ↔ ∀ (ys : List α), ys ∈ xs → ∀ (x : α), x ∈ ys → (!p x) = trueh
huList.find?_flatten_eq_some_iff}(hj  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Find.htmlhX  theorem List.find?_flatten_eq_some_iff {α : Type u_1} {xs : List (List α)} {p : α → Bool} {a : α} :
find? p xs.flatten = some a ↔ p a = true ∧ ∃ (as : List (List α)), ∃ (ys : List α), ∃ (zs : List α), ∃ (bs : List (List α)), xs = as ++ (ys ++ a :: zs) :: bs ∧ (∀ (l : List α), l ∈ as → ∀ (x : α), x ∈ l → (!p x) = true) ∧ ∀ (x : α), x ∈ ys → (!p x) = trueh
If find? p returns some a from xs.flatten, then p a holds, and some list in xs contains a, and no earlier element of that list satisfies p. Moreover, no earlier list in xs has an element satisfying p.uList.find?_flatten_eq_some}(hj  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Find.htmlhX  abbrev List.find?_flatten_eq_some {α : Type u_1} {xs : List (List α)} {p : α → Bool} {a : α} :
find? p xs.flatten = some a ↔ p a = true ∧ ∃ (as : List (List α)), ∃ (ys : List α), ∃ (zs : List α), ∃ (bs : List (List α)), xs = as ++ (ys ++ a :: zs) :: bs ∧ (∀ (l : List α), l ∈ as → ∀ (x : α), x ∈ l → (!p x) = true) ∧ ∀ (x : α), x ∈ ys → (!p x) = trueh
huList.find?_flatMap}(hj  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Find.htmlhtheorem List.find?_flatMap {α : Type u_1} {β : Type u_2} {xs : List α} {f : α → List β} {p : β → Bool} :
find? p (flatMap f xs) = findSome? (fun (x : α) => find? p (f x)) xsh
huList.find?_flatMap_eq_none_iff}(hj"  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Find.htmlhtheorem List.find?_flatMap_eq_none_iff {α : Type u_1} {β : Type u_2} {xs : List α} {f : α → List β} {p : β → Bool} :
find? p (flatMap f xs) = none ↔ ∀ (x : α), x ∈ xs → ∀ (y : β), y ∈ f x → (!p y) = trueh
huList.find?_replicate}(hj&  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Find.htmlhtheorem List.find?_replicate {α✝ : Type u_1} {p : α✝ → Bool} {n : Nat} {a : α✝} :
find? p (replicate n a) = if n = 0 then none else if p a = true then some a else noneh
hu"List.find?_replicate_of_length_pos}(hj*  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Find.htmlhtheorem List.find?_replicate_of_length_pos {n : Nat} {α✝ : Type u_1} {p : α✝ → Bool} {a : α✝} (h : 0 < n) :
find? p (replicate n a) = if p a = true then some a else noneh
huList.find?_replicate_of_pos}(hj.  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Find.htmlhtheorem List.find?_replicate_of_pos {α✝ : Type u_1} {p : α✝ → Bool} {n : Nat} {a : α✝} (h : p a = true) :
find? p (replicate n a) = if n = 0 then none else some ah
huList.find?_replicate_of_neg}(hj2  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Find.htmlhtheorem List.find?_replicate_of_neg {α✝ : Type u_1} {p : α✝ → Bool} {n : Nat} {a : α✝} (h : ¬p a = true) :
find? p (replicate n a) = noneh
hu List.find?_replicate_eq_none_iff}(hj6  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Find.htmlhtheorem List.find?_replicate_eq_none_iff {α : Type u_1} {n : Nat} {a : α} {p : α → Bool} :
find? p (replicate n a) = none ↔ n = 0 ∨ (!p a) = trueh
huList.find?_replicate_eq_none}(hj:  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Find.htmlhabbrev List.find?_replicate_eq_none {α : Type u_1} {n : Nat} {a : α} {p : α → Bool} :
find? p (replicate n a) = none ↔ n = 0 ∨ (!p a) = trueh
hu List.find?_replicate_eq_some_iff}(hj>  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Find.htmlhtheorem List.find?_replicate_eq_some_iff {α : Type u_1} {n : Nat} {a b : α} {p : α → Bool} :
find? p (replicate n a) = some b ↔ n ≠ 0 ∧ p a = true ∧ a = bh
huList.find?_replicate_eq_some}(hjB  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Find.htmlhabbrev List.find?_replicate_eq_some {α : Type u_1} {n : Nat} {a b : α} {p : α → Bool} :
find? p (replicate n a) = some b ↔ n ≠ 0 ∧ p a = true ∧ a = bh
huList.get_find?_replicate}(hjF  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Find.htmlhtheorem List.get_find?_replicate {α : Type u_1} {n : Nat} {a : α} {p : α → Bool} (h : (find? p (replicate n a)).isSome = true) :
(find? p (replicate n a)).get h = ah
huList.find?_pmap}(hjJ  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Find.htmlhX  theorem List.find?_pmap {α : Type u_1} {β : Type u_2} {P : α → Prop} {f : (a : α) → P a → β} {xs : List α} (H : ∀ (a : α), a ∈ xs → P a) {p : β → Bool} :
find? p (pmap f xs H) = Option.map
    (fun (x : { x : α // x ∈ xs }) =>
      match x with
      | ⟨a, m⟩ => f a ⋯)
    (find?
      (fun (x : { x : α // x ∈ xs }) =>
        match x with
        | ⟨a, m⟩ => p (f a ⋯))
      xs.attach)h
huList.findIdx?_nil}(hjN  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Find.htmlhRtheorem List.findIdx?_nil {α : Type u_1} {p : α → Bool} :
findIdx? p [] = noneh
huList.findIdx?_cons}(hjR  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Find.htmlhtheorem List.findIdx?_cons {α✝ : Type u_1} {x : α✝} {xs : List α✝} {p : α✝ → Bool} :
findIdx? p (x :: xs) = if p x = true then some 0 else Option.map (fun (i : Nat) => i + 1) (findIdx? p xs)h
huList.findIdx?_singleton}(hjV  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Find.htmlhtheorem List.findIdx?_singleton {α : Type u_1} {a : α} {p : α → Bool} :
findIdx? p [a] = if p a = true then some 0 else noneh
huList.findIdx_cons}(hjZ  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Find.htmlhtheorem List.findIdx_cons {α : Type u_1} {p : α → Bool} {b : α} {l : List α} :
findIdx p (b :: l) = bif p b then 0 else findIdx p l + 1h
huList.findIdx_singleton}(hj^  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Find.htmlhwtheorem List.findIdx_singleton {α : Type u_1} {a : α} {p : α → Bool} :
findIdx p [a] = if p a = true then 0 else 1h
huu( List.findIdx_of_getElem?_eq_some}(hjb  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Find.htmlhtheorem List.findIdx_of_getElem?_eq_some {α : Type u_1} {p : α → Bool} {y : α} {xs : List α} (w : xs[findIdx p xs]? = some y) :
p y = trueh
huList.findIdx_getElem}(hjf  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Find.htmlhtheorem List.findIdx_getElem {α : Type u_1} {p : α → Bool} {xs : List α} {w : findIdx p xs < xs.length} :
p xs[findIdx p xs] = trueh
hu List.findIdx_lt_length_of_exists}(hjj  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Find.htmlhtheorem List.findIdx_lt_length_of_exists {α : Type u_1} {p : α → Bool} {xs : List α} (h : ∃ (x : α), x ∈ xs ∧ p x = true) :
findIdx p xs < xs.lengthh
hu*List.findIdx_getElem?_eq_getElem_of_exists}(hjn  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Find.htmlhtheorem List.findIdx_getElem?_eq_getElem_of_exists {α : Type u_1} {p : α → Bool} {xs : List α} (h : ∃ (x : α), x ∈ xs ∧ p x = true) :
xs[findIdx p xs]? = some xs[findIdx p xs]h
huList.findIdx_eq_length}(hjr  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Find.htmlhtheorem List.findIdx_eq_length {α : Type u_1} {p : α → Bool} {xs : List α} :
findIdx p xs = xs.length ↔ ∀ (x : α), x ∈ xs → p x = falseh
huList.findIdx_eq_length_of_false}(hjv  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Find.htmlhtheorem List.findIdx_eq_length_of_false {α : Type u_1} {p : α → Bool} {xs : List α} (h : ∀ (x : α), x ∈ xs → p x = false) :
findIdx p xs = xs.lengthh
huList.findIdx_le_length}(hjz  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Find.htmlhltheorem List.findIdx_le_length {α : Type u_1} {p : α → Bool} {xs : List α} :
findIdx p xs ≤ xs.lengthh
huList.findIdx_lt_length}(hj~  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Find.htmlhtheorem List.findIdx_lt_length {α : Type u_1} {p : α → Bool} {xs : List α} :
findIdx p xs < xs.length ↔ ∃ (x : α), x ∈ xs ∧ p x = trueh
huList.not_of_lt_findIdx}(hj  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Find.htmlhtheorem List.not_of_lt_findIdx {α : Type u_1} {p : α → Bool} {xs : List α} {i : Nat} (h : i < findIdx p xs) :
p xs[i] = falseh
Ap does not hold for elements with indices less than xs.findIdx p.uList.le_findIdx_of_not}(hj  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Find.htmlhtheorem List.le_findIdx_of_not {α : Type u_1} {p : α → Bool} {xs : List α} {i : Nat} (h : i < xs.length) (h2 : ∀ (j : Nat) (hji : j < i), p xs[j] = false) :
i ≤ findIdx p xsh
5If ¬ p xs[j] for all j < i, then i ≤ xs.findIdx p.uList.lt_findIdx_of_not}(hj  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Find.htmlhtheorem List.lt_findIdx_of_not {α : Type u_1} {p : α → Bool} {xs : List α} {i : Nat} (h : i < xs.length) (h2 : ∀ (j : Nat) (hji : j ≤ i), ¬p xs[j] = true) :
i < findIdx p xsh
5If ¬ p xs[j] for all j ≤ i, then i < xs.findIdx p.uList.findIdx_eq}(hj  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Find.htmlhtheorem List.findIdx_eq {α : Type u_1} {p : α → Bool} {xs : List α} {i : Nat} (h : i < xs.length) :
findIdx p xs = i ↔ p xs[i] = true ∧ ∀ (j : Nat) (hji : j < i), p xs[j] = falseh
;xs.findIdx p = i iff p xs[i] and ¬ p xs [j] for all j < i.uList.findIdx_append}(hj  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Find.htmlhtheorem List.findIdx_append {α : Type u_1} {p : α → Bool} {l₁ l₂ : List α} :
findIdx p (l₁ ++ l₂) = if findIdx p l₁ < l₁.length then findIdx p l₁ else findIdx p l₂ + l₁.lengthh
huList.findIdx_le_findIdx}(hj  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Find.htmlhtheorem List.findIdx_le_findIdx {α : Type u_1} {l : List α} {p q : α → Bool} (h : ∀ (x : α), x ∈ l → p x = true → q x = true) :
findIdx q l ≤ findIdx p lh
huList.findIdx_subtype}(hj  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Find.htmlhtheorem List.findIdx_subtype {α : Type u_1} {p : α → Prop} {l : List { x : α // p x }} {f : { x : α // p x } → Bool} {g : α → Bool} (hf : ∀ (x : α) (h : p x), f ⟨x, h⟩ = g x) :
findIdx f l = findIdx g l.unattachh
huList.findIdx?_eq_none_iff}(hj  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Find.htmlhtheorem List.findIdx?_eq_none_iff {α : Type u_1} {xs : List α} {p : α → Bool} :
findIdx? p xs = none ↔ ∀ (x : α), x ∈ xs → p x = falseh
huList.findIdx?_isSome}(hj  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Find.htmlhqtheorem List.findIdx?_isSome {α : Type u_1} {xs : List α} {p : α → Bool} :
(findIdx? p xs).isSome = xs.any ph
huList.findIdx?_isNone}(hj  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Find.htmlhtheorem List.findIdx?_isNone {α : Type u_1} {xs : List α} {p : α → Bool} :
(findIdx? p xs).isNone = xs.all fun (x : α) => decide ¬p x = trueh
hu$List.findIdx?_eq_some_iff_findIdx_eq}(hj  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Find.htmlhtheorem List.findIdx?_eq_some_iff_findIdx_eq {α : Type u_1} {xs : List α} {p : α → Bool} {i : Nat} :
findIdx? p xs = some i ↔ i < xs.length ∧ findIdx p xs = ih
huList.findIdx?_eq_some_of_exists}(hj  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Find.htmlhtheorem List.findIdx?_eq_some_of_exists {α : Type u_1} {xs : List α} {p : α → Bool} (h : ∃ (x : α), x ∈ xs ∧ p x = true) :
findIdx? p xs = some (findIdx p xs)h
hu$List.findIdx?_eq_none_iff_findIdx_eq}(hj  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Find.htmlhtheorem List.findIdx?_eq_none_iff_findIdx_eq {α : Type u_1} {xs : List α} {p : α → Bool} :
findIdx? p xs = none ↔ findIdx p xs = xs.lengthh
hu!List.findIdx?_eq_guard_findIdx_lt}(hj  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Find.htmlhtheorem List.findIdx?_eq_guard_findIdx_lt {α : Type u_1} {xs : List α} {p : α → Bool} :
findIdx? p xs = Option.guard (fun (i : Nat) => decide (i < xs.length)) (findIdx p xs)h
hu!List.findIdx?_eq_some_iff_getElem}(hj  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Find.htmlhtheorem List.findIdx?_eq_some_iff_getElem {α : Type u_1} {xs : List α} {p : α → Bool} {i : Nat} :
findIdx? p xs = some i ↔ ∃ (h : i < xs.length), p xs[i] = true ∧ ∀ (j : Nat) (hji : j < i), ¬p xs[j] = trueh
huList.of_findIdx?_eq_some}(hj  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Find.htmlhtheorem List.of_findIdx?_eq_some {α : Type u_1} {i : Nat} {xs : List α} {p : α → Bool} (w : findIdx? p xs = some i) :
match xs[i]? with
| some a => p a = true
| none => false = trueh
huList.findIdx?_of_eq_some}(hj  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Find.htmlhabbrev List.findIdx?_of_eq_some {α : Type u_1} {i : Nat} {xs : List α} {p : α → Bool} (w : findIdx? p xs = some i) :
match xs[i]? with
| some a => p a = true
| none => false = trueh
huList.of_findIdx?_eq_none}(hj  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Find.htmlhtheorem List.of_findIdx?_eq_none {α : Type u_1} {xs : List α} {p : α → Bool} (w : findIdx? p xs = none) (i : Nat) :
match xs[i]? with
| some a => ¬p a = true
| none => true = trueh
huList.findIdx?_of_eq_none}(hj  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Find.htmlhabbrev List.findIdx?_of_eq_none {α : Type u_1} {xs : List α} {p : α → Bool} (w : findIdx? p xs = none) (i : Nat) :
match xs[i]? with
| some a => ¬p a = true
| none => true = trueh
huList.findIdx?_map}(hj  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Find.htmlhtheorem List.findIdx?_map {β : Type u_1} {α : Type u_2} {p : α → Bool} {f : β → α} {l : List β} :
findIdx? p (map f l) = findIdx? (p ∘ f) lh
huList.findIdx?_append}(hj  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Find.htmlhtheorem List.findIdx?_append {α : Type u_1} {xs ys : List α} {p : α → Bool} :
findIdx? p (xs ++ ys) = (findIdx? p xs).or (Option.map (fun (i : Nat) => i + xs.length) (findIdx? p ys))h
huList.findIdx?_flatten}(hj  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Find.htmlhX  theorem List.findIdx?_flatten {α : Type u_1} {l : List (List α)} {p : α → Bool} :
findIdx? p l.flatten = Option.map
    (fun (i : Nat) => (map length (take i l)).sum + (Option.map (fun (xs : List α) => findIdx p xs) l[i]?).getD 0)
    (findIdx? (fun (x : List α) => x.any p) l)h
huList.findIdx?_replicate}(hj  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Find.htmlhtheorem List.findIdx?_replicate {n : Nat} {α✝ : Type u_1} {a : α✝} {p : α✝ → Bool} :
findIdx? p (replicate n a) = if 0 < n ∧ p a = true then some 0 else noneh
hu!List.findIdx?_eq_findSome?_zipIdx}(hj  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Find.htmlhtheorem List.findIdx?_eq_findSome?_zipIdx {α : Type u_1} {xs : List α} {p : α → Bool} :
findIdx? p xs = findSome?
    (fun (x : α × Nat) =>
      match x with
      | (a, i) => if p a = true then some i else none)
    xs.zipIdxh
hu!List.findIdx?_eq_fst_find?_zipIdx}(hj  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Find.htmlhX   theorem List.findIdx?_eq_fst_find?_zipIdx {α : Type u_1} {xs : List α} {p : α → Bool} :
findIdx? p xs = Option.map (fun (x : α × Nat) => x.snd)
    (find?
      (fun (x : α × Nat) =>
        match x with
        | (x, snd) => p x)
      xs.zipIdx)h
hu)List.findIdx?_eq_none_of_findIdx?_eq_none}(hj  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Find.htmlhtheorem List.findIdx?_eq_none_of_findIdx?_eq_none {α : Type u_1} {xs : List α} {p q : α → Bool} (w : ∀ (x : α), x ∈ xs → p x = true → q x = true) :
findIdx? q xs = none → findIdx? p xs = noneh
huList.findIdx_eq_getD_findIdx?}(hj  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Find.htmlhtheorem List.findIdx_eq_getD_findIdx? {α : Type u_1} {xs : List α} {p : α → Bool} :
findIdx p xs = (findIdx? p xs).getD xs.lengthh
huList.findIdx?_subtype}(hj  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Find.htmlhtheorem List.findIdx?_subtype {α : Type u_1} {p : α → Prop} {l : List { x : α // p x }} {f : { x : α // p x } → Bool} {g : α → Bool} (hf : ∀ (x : α) (h : p x), f ⟨x, h⟩ = g x) :
findIdx? f l = findIdx? g l.unattachh
huList.findFinIdx?_nil}(hj  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Find.htmlhXtheorem List.findFinIdx?_nil {α : Type u_1} {p : α → Bool} :
findFinIdx? p [] = noneh
hu*List.findIdx?_go_eq_map_findFinIdx?_go_val}(hj  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Find.htmlhtheorem List.findIdx?_go_eq_map_findFinIdx?_go_val {α : Type u_1} {l xs : List α} {p : α → Bool} {i : Nat} {h : xs.length + i = l.length} :
findIdx?.go p xs i = Option.map (fun (x : Fin l.length) => ↑x) (findFinIdx?.go p l xs i h)h
hu$List.findIdx?_eq_map_findFinIdx?_val}(hj  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Find.htmlhtheorem List.findIdx?_eq_map_findFinIdx?_val {α : Type u_1} {xs : List α} {p : α → Bool} :
findIdx? p xs = Option.map (fun (x : Fin xs.length) => ↑x) (findFinIdx? p xs)h
hu!List.findFinIdx?_eq_pmap_findIdx?}(hj  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Find.htmlhtheorem List.findFinIdx?_eq_pmap_findIdx? {α : Type u_1} {xs : List α} {p : α → Bool} :
findFinIdx? p xs = Option.pmap (fun (i : Nat) (m : findIdx? p xs = some i) => ⟨i, ⋯⟩) (findIdx? p xs) ⋯h
huList.findFinIdx?_cons}(hj  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Find.htmlhtheorem List.findFinIdx?_cons {α : Type u_1} {p : α → Bool} {x : α} {xs : List α} :
findFinIdx? p (x :: xs) = if p x = true then some 0 else Option.map Fin.succ (findFinIdx? p xs)h
huList.findFinIdx?_append}(hj
  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Find.htmlhtheorem List.findFinIdx?_append {α : Type u_1} {xs ys : List α} {p : α → Bool} :
findFinIdx? p (xs ++ ys) = (Option.map (Fin.castLE ⋯) (findFinIdx? p xs)).or
    (Option.map (Fin.cast ⋯) (Option.map (Fin.natAdd xs.length) (findFinIdx? p ys)))h
huList.findFinIdx?_singleton}(hj  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Find.htmlhtheorem List.findFinIdx?_singleton {α : Type u_1} {a : α} {p : α → Bool} :
findFinIdx? p [a] = if p a = true then some ⟨0, findFinIdx?_singleton._proof_1⟩ else noneh
huList.findFinIdx?_eq_none_iff}(hj  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Find.htmlhtheorem List.findFinIdx?_eq_none_iff {α : Type u_1} {l : List α} {p : α → Bool} :
findFinIdx? p l = none ↔ ∀ (x : α), x ∈ l → ¬p x = trueh
huList.findFinIdx?_eq_some_iff}(hj  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Find.htmlhtheorem List.findFinIdx?_eq_some_iff {α : Type u_1} {xs : List α} {p : α → Bool} {i : Fin xs.length} :
findFinIdx? p xs = some i ↔ p xs[i] = true ∧ ∀ (j : Fin xs.length) (hji : j < i), ¬p xs[j] = trueh
huList.isSome_findFinIdx?}(hj  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Find.htmlhttheorem List.isSome_findFinIdx? {α : Type u_1} {l : List α} {p : α → Bool} :
(findFinIdx? p l).isSome = l.any ph
huList.isNone_findFinIdx?}(hj  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Find.htmlhtheorem List.isNone_findFinIdx? {α : Type u_1} {l : List α} {p : α → Bool} :
(findFinIdx? p l).isNone = l.all fun (x : α) => decide ¬p x = trueh
huList.findFinIdx?_subtype}(hj"  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Find.htmlhX2  theorem List.findFinIdx?_subtype {α : Type u_1} {p : α → Prop} {l : List { x : α // p x }} {f : { x : α // p x } → Bool} {g : α → Bool} (hf : ∀ (x : α) (h : p x), f ⟨x, h⟩ = g x) :
findFinIdx? f l = Option.map (fun (i : Fin l.unattach.length) => Fin.cast ⋯ i) (findFinIdx? g l.unattach)h
huList.idxOf_cons}(hj&  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Find.htmlhtheorem List.idxOf_cons {α : Type u_1} {x : α} {xs : List α} {y : α} [BEq α] :
idxOf y (x :: xs) = bif x == y then 0 else idxOf y xs + 1h
huList.idxOf_cons_self}(hj*  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Find.htmlhptheorem List.idxOf_cons_self {α : Type u_1} {a : α} [BEq α] [ReflBEq α] {l : List α} :
idxOf a (a :: l) = 0h
huList.idxOf_append}(hj.  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Find.htmlhtheorem List.idxOf_append {α : Type u_1} [BEq α] [LawfulBEq α] {l₁ l₂ : List α} {a : α} :
idxOf a (l₁ ++ l₂) = if a ∈ l₁ then idxOf a l₁ else idxOf a l₂ + l₁.lengthh
huList.idxOf_eq_length}(hj2  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Find.htmlhtheorem List.idxOf_eq_length {α : Type u_1} {a : α} [BEq α] [LawfulBEq α] {l : List α} (h : ¬a ∈ l) :
idxOf a l = l.lengthh
huList.idxOf_lt_length_of_mem}(hj6  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Find.htmlhtheorem List.idxOf_lt_length_of_mem {α : Type u_1} {a : α} [BEq α] [EquivBEq α] {l : List α} (h : a ∈ l) :
idxOf a l < l.lengthh
huList.idxOf_le_length}(hj:  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Find.htmlhttheorem List.idxOf_le_length {α : Type u_1} [BEq α] [LawfulBEq α] {l : List α} {a : α} :
idxOf a l ≤ l.lengthh
huList.idxOf_lt_length_iff}(hj>  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Find.htmlhtheorem List.idxOf_lt_length_iff {α : Type u_1} [BEq α] [LawfulBEq α] {l : List α} {a : α} :
idxOf a l < l.length ↔ a ∈ lh
hu List.idxOf?_eq_map_finIdxOf?_val}(hjB  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Find.htmlhtheorem List.idxOf?_eq_map_finIdxOf?_val {α : Type u_1} [BEq α] {xs : List α} {a : α} :
idxOf? a xs = Option.map (fun (x : Fin xs.length) => ↑x) (finIdxOf? a xs)h
huList.finIdxOf?_nil}(hjF  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Find.htmlhTtheorem List.finIdxOf?_nil {α : Type u_1} {a : α} [BEq α] :
finIdxOf? a [] = noneh
huList.finIdxOf?_cons}(hjJ  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Find.htmlhtheorem List.finIdxOf?_cons {α : Type u_1} {b : α} [BEq α] {a : α} {xs : List α} :
finIdxOf? b (a :: xs) = if (a == b) = true then some ⟨0, ⋯⟩ else Option.map (fun (x : Fin xs.length) => x.succ) (finIdxOf? b xs)h
huList.finIdxOf?_eq_none_iff}(hjN  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Find.htmlhtheorem List.finIdxOf?_eq_none_iff {α : Type u_1} [BEq α] [LawfulBEq α] {l : List α} {a : α} :
finIdxOf? a l = none ↔ ¬a ∈ lh
huList.finIdxOf?_eq_some_iff}(hjR  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Find.htmlhtheorem List.finIdxOf?_eq_some_iff {α : Type u_1} [BEq α] [LawfulBEq α] {l : List α} {a : α} {i : Fin l.length} :
finIdxOf? a l = some i ↔ l[i] = a ∧ ∀ (j : Fin l.length), j < i → ¬l[j] = ah
huList.isSome_finIdxOf?}(hjV  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Find.htmlhtheorem List.isSome_finIdxOf? {α : Type u_1} [BEq α] [PartialEquivBEq α] {l : List α} {a : α} :
(finIdxOf? a l).isSome = l.contains ah
huList.isNone_finIdxOf?}(hjZ  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Find.htmlhtheorem List.isNone_finIdxOf? {α : Type u_1} [BEq α] [PartialEquivBEq α] {l : List α} {a : α} :
(finIdxOf? a l).isNone = !l.contains ah
huList.idxOf?_nil}(hj^  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Find.htmlhNtheorem List.idxOf?_nil {α : Type u_1} {a : α} [BEq α] :
idxOf? a [] = noneh
huList.idxOf?_cons}(hjb  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Find.htmlhtheorem List.idxOf?_cons {α : Type u_1} [BEq α] {a : α} {xs : List α} {b : α} :
idxOf? b (a :: xs) = if (a == b) = true then some 0 else Option.map (fun (x : Nat) => x + 1) (idxOf? b xs)h
huList.idxOf?_singleton}(hjf  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Find.htmlh{theorem List.idxOf?_singleton {α : Type u_1} [BEq α] {a b : α} :
idxOf? b [a] = if (a == b) = true then some 0 else noneh
huList.idxOf?_eq_none_iff}(hjj  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Find.htmlhtheorem List.idxOf?_eq_none_iff {α : Type u_1} [BEq α] [LawfulBEq α] {l : List α} {a : α} :
idxOf? a l = none ↔ ¬a ∈ lh
huList.isSome_idxOf?}(hjn  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Find.htmlhtheorem List.isSome_idxOf? {α : Type u_1} [BEq α] [LawfulBEq α] {l : List α} {a : α} :
(idxOf? a l).isSome = true ↔ a ∈ l      h
huList.isNone_idxOf?}(hjr  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Find.htmlhtheorem List.isNone_idxOf? {α : Type u_1} [BEq α] [LawfulBEq α] {l : List α} {a : α} :
((idxOf? a l).isNone = true) = ¬a ∈ lh
huList.lookup_cons_self}(hjv  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Find.htmlhtheorem List.lookup_cons_self {α : Type u_2} [BEq α] [LawfulBEq α] {β✝ : Type u_1} {b : β✝} {es : List (α × β✝)} {k : α} :
lookup k ((k, b) :: es) = some bh
huList.lookup_singleton}(hjz  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Find.htmlhtheorem List.lookup_singleton {α : Type u_1} [BEq α] [LawfulBEq α] {c a b : α} :
lookup c [(a, b)] = if (c == a) = true then some b else noneh
huList.lookup_eq_findSome?}(hj~  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Find.htmlhtheorem List.lookup_eq_findSome? {α : Type u_2} [BEq α] [LawfulBEq α] {β : Type u_1} {l : List (α × β)} {k : α} :
lookup k l = findSome? (fun (p : α × β) => if (k == p.fst) = true then some p.snd else none) lh
huList.lookup_eq_none_iff}(hj  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Find.htmlhtheorem List.lookup_eq_none_iff {α : Type u_2} [BEq α] [LawfulBEq α] {β : Type u_1} {l : List (α × β)} {k : α} :
lookup k l = none ↔ ∀ (p : α × β), p ∈ l → (k != p.fst) = trueh
huList.lookup_isSome_iff}(hj  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Find.htmlhtheorem List.lookup_isSome_iff {α : Type u_2} [BEq α] [LawfulBEq α] {β : Type u_1} {l : List (α × β)} {k : α} :
(lookup k l).isSome = true ↔ ∃ (p : α × β), p ∈ l ∧ (k == p.fst) = trueh
huList.lookup_eq_some_iff}(hj  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Find.htmlhX+  theorem List.lookup_eq_some_iff {α : Type u_2} [BEq α] [LawfulBEq α] {β : Type u_1} {l : List (α × β)} {k : α} {b : β} :
lookup k l = some b ↔ ∃ (l₁ : List (α × β)), ∃ (l₂ : List (α × β)), l = l₁ ++ (k, b) :: l₂ ∧ ∀ (p : α × β), p ∈ l₁ → (k != p.fst) = trueh
huList.lookup_append}(hj  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Find.htmlhtheorem List.lookup_append {α : Type u_2} [BEq α] [LawfulBEq α] {β : Type u_1} {l₁ l₂ : List (α × β)} {k : α} :
lookup k (l₁ ++ l₂) = (lookup k l₁).or (lookup k l₂)h
huList.lookup_replicate}(hj  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Find.htmlhtheorem List.lookup_replicate {α : Type u_2} [BEq α] [LawfulBEq α] {n : Nat} {a : α} {α✝ : Type u_1} {b : α✝} {k : α} :
lookup k (replicate n (a, b)) = if n = 0 then none else if (k == a) = true then some b else noneh
huList.lookup_replicate_of_pos}(hj  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Find.htmlhtheorem List.lookup_replicate_of_pos {α : Type u_2} [BEq α] [LawfulBEq α] {n : Nat} {a : α} {α✝ : Type u_1} {b : α✝} {k : α} (h : 0 < n) :
lookup k (replicate n (a, b)) = if (k == a) = true then some b else noneh
huList.lookup_replicate_self}(hj  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Find.htmlhtheorem List.lookup_replicate_self {α : Type u_2} [BEq α] [LawfulBEq α] {n : Nat} {α✝ : Type u_1} {b : α✝} {a : α} :
lookup a (replicate n (a, b)) = if n = 0 then none else some bh
hu!List.lookup_replicate_self_of_pos}(hj  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Find.htmlhtheorem List.lookup_replicate_self_of_pos {α : Type u_2} [BEq α] [LawfulBEq α] {n : Nat} {α✝ : Type u_1} {b : α✝} {a : α} (h : 0 < n) :
lookup a (replicate n (a, b)) = some bh
huList.lookup_replicate_ne}(hj  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Find.htmlhtheorem List.lookup_replicate_ne {α : Type u_2} [BEq α] [LawfulBEq α] {a : α} {n : Nat} {α✝ : Type u_1} {b : α✝} {k : α} (h : (!k == a) = true) :
lookup k (replicate n (a, b)) = noneh
huList.map_getElem_sublist}(hj  hUhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Pairwise.htmlhtheorem List.map_getElem_sublist {α : Type u_1} {l : List α} {is : List (Fin l.length)} (h : Pairwise (fun (x1 x2 : Fin l.length) => x1 < x2) is) :
(map (fun (x : Fin l.length) => l[x]) is).Sublist lh
gGiven a list is of monotonically increasing indices into l, getting each index produces a sublist of l.uList.sublist_eq_map_getElem}(hj  hUhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Pairwise.htmlhtheorem List.sublist_eq_map_getElem {α : Type u_1} {l l' : List α} (h : l'.Sublist l) :
∃ (is : List (Fin l.length)), l' = map (fun (x : Fin l.length) => l[x]) is ∧ Pairwise (fun (x1 x2 : Fin l.length) => x1 < x2) ish
kGiven a sublist l' <+ l, there exists an increasing list of indices is such that l' = is.map fun i => l[i].uList.pairwise_iff_getElem}(hj  hUhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Pairwise.htmlhtheorem List.pairwise_iff_getElem {α : Type u_1} {R : α → α → Prop} {l : List α} :
Pairwise R l ↔ ∀ (i j : Nat) (_hi : i < l.length) (_hj : j < l.length), i < j → R l[i] l[j]h
huList.set_set_perm}(hj  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Perm.htmlhtheorem List.set_set_perm {α : Type u_1} {as : List α} {i j : Nat} (h₁ : i < as.length) (h₂ : j < as.length) :
((as.set i as[j]).set j as[i]).Perm ash
hu
List.mapM'}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Monadic.htmlhdef List.mapM' {m : Type u_1 → Type u_2} {α : Type u_3} {β : Type u_1} [Monad m] (f : α → m β) :
List α → m (List β)h
XN  Applies the monadic action f on every element in the list, left-to-right, and returns the list of results.
This is a non-tail-recursive variant of List.mapM that's easier to reason about. It cannot be used as the main definition and replaced by the tail-recursive version because they can only be proved equal when m is a LawfulMonad.uList.mapM'_nil}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Monadic.htmlhtheorem List.mapM'_nil {m : Type u_1 → Type u_2} {α : Type u_3} {β : Type u_1} [Monad m] {f : α → m β} :
mapM' f [] = pure []h
huList.mapM'_cons}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Monadic.htmlhtheorem List.mapM'_cons {m : Type u_1 → Type u_2} {α : Type u_3} {β : Type u_1} {a : α} {l : List α} [Monad m] {f : α → m β} :
mapM' f (a :: l) = do
  let __do_lift ← f a
  let __do_lift_1 ← mapM' f l
  pure (__do_lift :: __do_lift_1)h
huList.mapM'_eq_mapM}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Monadic.htmlhtheorem List.mapM'_eq_mapM {m : Type u_1 → Type u_2} {α : Type u_3} {β : Type u_1} [Monad m] [LawfulMonad m] {f : α → m β} {l : List α} :
mapM' f l = mapM f lh
hu
List.mapM_nil}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Monadic.htmlhtheorem List.mapM_nil {m : Type u_1 → Type u_2} {α : Type u_3} {β : Type u_1} [Monad m] {f : α → m β} :
mapM f [] = pure []h
huList.mapM_cons}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Monadic.htmlhX  theorem List.mapM_cons {m : Type u_1 → Type u_2} {α : Type u_3} {β : Type u_1} {a : α} {l : List α} [Monad m] [LawfulMonad m] {f : α → m β} :
mapM f (a :: l) = do
  let __do_lift ← f a
  let __do_lift_1 ← mapM f l
  pure (__do_lift :: __do_lift_1)h
huList.mapM_pure}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Monadic.htmlhtheorem List.mapM_pure {m : Type u_1 → Type u_2} {α : Type u_3} {β : Type u_1} [Monad m] [LawfulMonad m] {l : List α} {f : α → β} :
mapM (fun (x : α) => pure (f x)) l = pure (map f l)h
huList.idRun_mapM}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Monadic.htmlhtheorem List.idRun_mapM {α : Type u_1} {β : Type u_2} {l : List α} {f : α → Id β} :
(mapM f l).run = map (fun (x : α) => (f x).run) lh
huList.mapM_id}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Monadic.htmlhtheorem List.mapM_id {α : Type u_1} {β : Type u_2} {l : List α} {f : α → Id β} :
(mapM f l).run = map (fun (x : α) => (f x).run) lh
hu
List.mapM_map}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Monadic.htmlhtheorem List.mapM_map {m : Type u_1 → Type u_2} {α : Type u_3} {β : Type u_4} {γ : Type u_1} [Monad m] [LawfulMonad m] {f : α → β} {g : β → m γ} {l : List α} :
mapM g (map f l) = mapM (g ∘ f) lh
huList.mapM_append}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Monadic.htmlhX  theorem List.mapM_append {m : Type u_1 → Type u_2} {α : Type u_3} {β : Type u_1} [Monad m] [LawfulMonad m] {f : α → m β} {l₁ l₂ : List α} :
mapM f (l₁ ++ l₂) = do
  let __do_lift ← mapM f l₁
  let __do_lift_1 ← mapM f l₂
  pure (__do_lift ++ __do_lift_1)h
huList.foldlM_cons_eq_append}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Monadic.htmlhX  theorem List.foldlM_cons_eq_append {m : Type u_1 → Type u_2} {α : Type u_3} {β : Type u_1} [Monad m] [LawfulMonad m] {f : α → m β} {as : List α} {b : β} {bs : List β} :
foldlM (fun (acc : List β) (a : α) => (fun (x : β) => x :: acc) <$> f a) (b :: bs) as = (fun (x : List β) => x ++ b :: bs) <$> foldlM (fun (acc : List β) (a : α) => (fun (x : β) => x :: acc) <$> f a) [] ash
0Auxiliary lemma for mapM_eq_reverse_foldlM_cons.u List.mapM_eq_reverse_foldlM_cons}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Monadic.htmlhX  theorem List.mapM_eq_reverse_foldlM_cons {m : Type u_1 → Type u_2} {α : Type u_3} {β : Type u_1} [Monad m] [LawfulMonad m] {f : α → m β} {l : List α} :
mapM f l = reverse <$> foldlM (fun (acc : List β) (a : α) => (fun (x : β) => x :: acc) <$> f a) [] lh
huList.filterMapM_nil}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Monadic.htmlhtheorem List.filterMapM_nil {m : Type u_1 → Type u_2} {α : Type u_3} {β : Type u_1} [Monad m] {f : α → m (Option β)} :
filterMapM f [] = pure []h
huList.filterMapM_loop_eq}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Monadic.htmlhX
  theorem List.filterMapM_loop_eq {m : Type u_1 → Type u_2} {α : Type u_3} {β : Type u_1} [Monad m] [LawfulMonad m] {f : α → m (Option β)} {l : List α} {acc : List β} :
filterMapM.loop f l acc = (fun (x : List β) => acc.reverse ++ x) <$> filterMapM.loop f l []h
huList.filterMapM_cons}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Monadic.htmlhXc  theorem List.filterMapM_cons {m : Type u_1 → Type u_2} {α : Type u_3} {β : Type u_1} {a : α} {l : List α} [Monad m] [LawfulMonad m] {f : α → m (Option β)} :
filterMapM f (a :: l) = do
  let __do_lift ← f a
  match __do_lift with
    | none => filterMapM f l
    | some b => do
      let __do_lift ← filterMapM f l
      pure (b :: __do_lift)h
huList.zipWithM'}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Monadic.htmlhdef List.zipWithM' {m : Type u → Type v} [Monad m] {α : Type w} {β : Type x} {γ : Type u} (f : α → β → m γ) (xs : List α) (ys : List β) :
m (List γ)h
Applies the monadic action f to the corresponding elements of two lists, left-to-right, stopping at the end of the shorter list. zipWithM' f as bs is equivalent to mapM id (zipWith f as bs) for lawful Monad instances.uList.zipWithM'_nil_left}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Monadic.htmlhtheorem List.zipWithM'_nil_left {m : Type u_1 → Type u_2} {α : Type u_3} {β : Type u_4} {γ : Type u_1} {l : List β} [Monad m] {f : α → β → m γ} :
zipWithM' f [] l = pure []h
huList.zipWithM'_nil_right}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Monadic.htmlhtheorem List.zipWithM'_nil_right {m : Type u_1 → Type u_2} {α : Type u_3} {β : Type u_4} {γ : Type u_1} {l : List α} [Monad m] {f : α → β → m γ} :
zipWithM' f l [] = pure []h
huList.zipWithM'_cons_cons}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Monadic.htmlhXJ  theorem List.zipWithM'_cons_cons {m : Type u_1 → Type u_2} {α : Type u_3} {β : Type u_4} {γ : Type u_1} {a : α} {as : List α} {b : β} {bs : List β} [Monad m] {f : α → β → m γ} :
zipWithM' f (a :: as) (b :: bs) = do
  let __do_lift ← f a b
  let __do_lift_1 ← zipWithM' f as bs
  pure (__do_lift :: __do_lift_1)h
huList.zipWithM'_eq_zipWithM}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Monadic.htmlhtheorem List.zipWithM'_eq_zipWithM {m : Type u_1 → Type u_2} {α : Type u_3} {β : Type u_4} {γ : Type u_1} [Monad m] [LawfulMonad m] {f : α → β → m γ} {l : List α} {l' : List β} :
zipWithM' f l l' = zipWithM f l l'h
huList.zipWithM_nil_left}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Monadic.htmlhtheorem List.zipWithM_nil_left {m : Type u_1 → Type u_2} {α : Type u_3} {β : Type u_4} {γ : Type u_1} {l : List β} [Monad m] {f : α → β → m γ} :
zipWithM f [] l = pure []h
huList.zipWithM_nil_right}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Monadic.htmlhtheorem List.zipWithM_nil_right {m : Type u_1 → Type u_2} {α : Type u_3} {β : Type u_4} {γ : Type u_1} {l : List α} [Monad m] {f : α → β → m γ} :
zipWithM f l [] = pure []h
huList.zipWithM_cons_cons}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Monadic.htmlhXW  theorem List.zipWithM_cons_cons {m : Type u_1 → Type u_2} {α : Type u_3} {β : Type u_4} {γ : Type u_1} {a : α} {as : List α} {b : β} {bs : List β} [Monad m] [LawfulMonad m] {f : α → β → m γ} :
zipWithM f (a :: as) (b :: bs) = do
  let __do_lift ← f a b
  let __do_lift_1 ← zipWithM f as bs
  pure (__do_lift :: __do_lift_1)h
hu!List.zipWithM'_eq_mapM_id_zipWith}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Monadic.htmlhtheorem List.zipWithM'_eq_mapM_id_zipWith {α : Type u_1} {β : Type u_2} {γ : Type v} {m : Type v → Type w} [Monad m] [LawfulMonad m] {f : α → β → m γ} {as : List α} {bs : List β} :
zipWithM' f as bs = mapM id (zipWith f as bs)h
huList.flatMapM_nil}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Monadic.htmlhtheorem List.flatMapM_nil {m : Type u_1 → Type u_2} {α : Type u_3} {β : Type u_1} [Monad m] {f : α → m (List β)} :
flatMapM f [] = pure []h
huList.flatMapM_loop_eq}(hj#  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Monadic.htmlhX  theorem List.flatMapM_loop_eq {m : Type u_1 → Type u_2} {α : Type u_3} {β : Type u_1} [Monad m] [LawfulMonad m] {f : α → m (List β)} {l : List α} {acc : List (List β)} :
flatMapM.loop f l acc = (fun (x : List β) => acc.reverse.flatten ++ x) <$> flatMapM.loop f l []h
huList.flatMapM_cons}(hj'  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Monadic.htmlhX  theorem List.flatMapM_cons {m : Type u_1 → Type u_2} {α : Type u_3} {β : Type u_1} {a : α} {l : List α} [Monad m] [LawfulMonad m] {f : α → m (List β)} :
flatMapM f (a :: l) = do
  let bs ← f a
  let __do_lift ← flatMapM f l
  pure (bs ++ __do_lift)h
huList.foldlM_map}(hj+  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Monadic.htmlhX  theorem List.foldlM_map {m : Type u_1 → Type u_2} {β₁ : Type u_3} {β₂ : Type u_4} {α : Type u_1} [Monad m] {f : β₁ → β₂} {g : α → β₂ → m α} {l : List β₁} {init : α} :
foldlM g init (map f l) = foldlM (fun (x : α) (y : β₁) => g x (f y)) init lh
huList.foldrM_map}(hj/  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Monadic.htmlhX$  theorem List.foldrM_map {m : Type u_1 → Type u_2} {β₁ : Type u_3} {β₂ : Type u_4} {α : Type u_1} [Monad m] [LawfulMonad m] {f : β₁ → β₂} {g : β₂ → α → m α} {l : List β₁} {init : α} :
foldrM g init (map f l) = foldrM (fun (x : β₁) (y : α) => g (f x) y) init lh
huList.foldlM_filterMap}(hj3  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Monadic.htmlhXd  theorem List.foldlM_filterMap {m : Type u_1 → Type u_2} {α : Type u_3} {β : Type u_4} {γ : Type u_1} [Monad m] [LawfulMonad m] {f : α → Option β} {g : γ → β → m γ} {l : List α} {init : γ} :
foldlM g init (filterMap f l) = foldlM
    (fun (x : γ) (y : α) =>
      match f y with
      | some b => g x b
      | none => pure x)
    init lh
huList.foldrM_filterMap}(hj7  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Monadic.htmlhXd  theorem List.foldrM_filterMap {m : Type u_1 → Type u_2} {α : Type u_3} {β : Type u_4} {γ : Type u_1} [Monad m] [LawfulMonad m] {f : α → Option β} {g : β → γ → m γ} {l : List α} {init : γ} :
foldrM g init (filterMap f l) = foldrM
    (fun (x : α) (y : γ) =>
      match f x with
      | some b => g b y
      | none => pure y)
    init lh
huList.foldlM_filter}(hj;  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Monadic.htmlhX"  theorem List.foldlM_filter {m : Type u_1 → Type u_2} {α : Type u_3} {β : Type u_1} [Monad m] [LawfulMonad m] {p : α → Bool} {g : β → α → m β} {l : List α} {init : β} :
foldlM g init (filter p l) = foldlM (fun (x : β) (y : α) => if p y = true then g x y else pure x) init lh
huList.foldrM_filter}(hj?  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Monadic.htmlhX"  theorem List.foldrM_filter {m : Type u_1 → Type u_2} {α : Type u_3} {β : Type u_1} [Monad m] [LawfulMonad m] {p : α → Bool} {g : α → β → m β} {l : List α} {init : β} :
foldrM g init (filter p l) = foldrM (fun (x : α) (y : β) => if p x = true then g x y else pure y) init lh
huList.foldlM_attachWith}(hjC  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Monadic.htmlhX}  theorem List.foldlM_attachWith {m : Type u_1 → Type u_2} {α : Type u_3} {β : Type u_1} [Monad m] {l : List α} {q : α → Prop} (H : ∀ (a : α), a ∈ l → q a) {f : β → { x : α // q x } → m β} {b : β} :
foldlM f b (l.attachWith q H) = foldlM
    (fun (b : β) (x : { x : α // x ∈ l }) =>
      match x with
      | ⟨a, h⟩ => f b ⟨a, ⋯⟩)
    b l.attachh
huList.foldrM_attachWith}(hjG  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Monadic.htmlhXd  theorem List.foldrM_attachWith {m : Type u_1 → Type u_2} {α : Type u_3} {β : Type u_1} [Monad m] [LawfulMonad m] {l : List α} {q : α → Prop} (H : ∀ (a : α), a ∈ l → q a) {f : { x : α // q x } → β → m β} {b : β} :
foldrM f b (l.attachWith q H) = foldrM (fun (a : { x : α // x ∈ l }) (acc : β) => f ⟨a.val, ⋯⟩ acc) b l.attachh
huList.forM_append}(hjK  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Monadic.htmlhtheorem List.forM_append {m : Type u_1 → Type u_2} {α : Type u_3} [Monad m] [LawfulMonad m] {l₁ l₂ : List α} {f : α → m PUnit} :
forM (l₁ ++ l₂) f = do
  forM l₁ f
  forM l₂ fh
hu
List.forM_map}(hjO  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Monadic.htmlhtheorem List.forM_map {m : Type u_1 → Type u_2} {α : Type u_3} {β : Type u_4} [Monad m] [LawfulMonad m] {l : List α} {g : α → β} {f : β → m PUnit} :
forM (map g l) f = forM l fun (a : α) => f (g a)h
huList.forIn'_loop_congr}(hjS  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Monadic.htmlhX  theorem List.forIn'_loop_congr {m : Type u_1 → Type u_2} {α : Type u_3} {β : Type u_1} {xs : List α} [Monad m] {as bs : List α} {f : (a' : α) → a' ∈ as → β → m (ForInStep β)} {g : (a' : α) → a' ∈ bs → β → m (ForInStep β)} {b : β} (ha : ∃ (ys : List α), ys ++ xs = as) (hb : ∃ (ys : List α), ys ++ xs = bs) (h : ∀ (a : α) (m_1 : a ∈ as) (m' : a ∈ bs) (b : β), f a m_1 b = g a m' b) :
forIn'.loop as f xs b ha = forIn'.loop bs g xs b hbh
huList.forIn'_cons}(hjW  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Monadic.htmlhX|  theorem List.forIn'_cons {m : Type u_1 → Type u_2} {α : Type u_3} {β : Type u_1} [Monad m] {a : α} {as : List α} (f : (a' : α) → a' ∈ a :: as → β → m (ForInStep β)) (b : β) :
forIn' (a :: as) b f = do
  let x ← f a ⋯ b
  match x with
    | ForInStep.done b => pure b
    | ForInStep.yield b => forIn' as b fun (a' : α) (m : a' ∈ as) (b : β) => f a' ⋯ bh
huList.forIn_cons}(hj[  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Monadic.htmlhX(  theorem List.forIn_cons {m : Type u_1 → Type u_2} {α : Type u_3} {β : Type u_1} [Monad m] (f : α → β → m (ForInStep β)) (a : α) (as : List α) (b : β) :
forIn (a :: as) b f = do
  let x ← f a b
  match x with
    | ForInStep.done b => pure b
    | ForInStep.yield b => forIn as b fh
huList.forIn'_congr}(hj_  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Monadic.htmlhXr  theorem List.forIn'_congr {m : Type u_1 → Type u_2} {α : Type u_3} {β : Type u_1} [Monad m] {as bs : List α} (w : as = bs) {b b' : β} (hb : b = b') {f : (a' : α) → a' ∈ as → β → m (ForInStep β)} {g : (a' : α) → a' ∈ bs → β → m (ForInStep β)} (h : ∀ (a : α) (m_1 : a ∈ bs) (b : β), f a ⋯ b = g a m_1 b) :
forIn' as b f = forIn' bs b' gh
huList.forIn'_eq_foldlM}(hjc  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Monadic.htmlhX   theorem List.forIn'_eq_foldlM {m : Type u_1 → Type u_2} {α : Type u_3} {β : Type u_1} [Monad m] [LawfulMonad m] {l : List α} (f : (a : α) → a ∈ l → β → m (ForInStep β)) (init : β) :
forIn' l init f = ForInStep.value <$> foldlM
      (fun (b : ForInStep β) (x : { x : α // x ∈ l }) =>
        match x with
        | ⟨a, m_1⟩ =>
          match b with
          | ForInStep.yield b => f a m_1 b
          | ForInStep.done b => pure (ForInStep.done b))
      (ForInStep.yield init) l.attachh
We can express a for loop over a list as a fold, in which whenever we reach .done b we keep that value through the rest of the fold.uList.forIn'_yield_eq_foldlM}(hjh  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Monadic.htmlhX  theorem List.forIn'_yield_eq_foldlM {m : Type u_1 → Type u_2} {α : Type u_3} {β γ : Type u_1} [Monad m] [LawfulMonad m] {l : List α} (f : (a : α) → a ∈ l → β → m γ) (g : (a : α) → a ∈ l → β → γ → β) (init : β) :
(forIn' l init fun (a : α) (m_1 : a ∈ l) (b : β) => (fun (c : γ) => ForInStep.yield (g a m_1 b c)) <$> f a m_1 b) = foldlM
    (fun (b : β) (x : { x : α // x ∈ l }) =>
      match x with
      | ⟨a, m_1⟩ => g a m_1 b <$> f a m_1 b)
    init l.attachh
DWe can express a for loop over a list which always yields as a fold.uList.forIn'_pure_yield_eq_foldl}(hjm  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Monadic.htmlhX  theorem List.forIn'_pure_yield_eq_foldl {m : Type u_1 → Type u_2} {α : Type u_3} {β : Type u_1} [Monad m] [LawfulMonad m] {l : List α} (f : (a : α) → a ∈ l → β → β) (init : β) :
(forIn' l init fun (a : α) (m_1 : a ∈ l) (b : β) => pure (ForInStep.yield (f a m_1 b))) = pure
    (foldl
      (fun (b : β) (x : { x : α // x ∈ l }) =>
        match x with
        | ⟨a, h⟩ => f a h b)
      init l.attach)h
hu List.idRun_forIn'_yield_eq_foldl}(hjq  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Monadic.htmlhXj  theorem List.idRun_forIn'_yield_eq_foldl {α : Type u_1} {β : Type u_2} (l : List α) (f : (a : α) → a ∈ l → β → Id β) (init : β) :
(forIn' l init fun (a : α) (m : a ∈ l) (b : β) => ForInStep.yield <$> f a m b).run = foldl
    (fun (b : β) (x : { x : α // x ∈ l }) =>
      match x with
      | ⟨a, h⟩ => (f a h b).run)
    init l.attachh
huList.forIn'_yield_eq_foldl}(hju  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Monadic.htmlhXU  theorem List.forIn'_yield_eq_foldl {α : Type u_1} {β : Type u_2} {l : List α} (f : (a : α) → a ∈ l → β → β) (init : β) :
(forIn' l init fun (a : α) (m : a ∈ l) (b : β) => ForInStep.yield (f a m b)) = foldl
    (fun (b : β) (x : { x : α // x ∈ l }) =>
      match x with
      | ⟨a, h⟩ => f a h b)
    init l.attachh
huList.forIn'_map}(hjy  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Monadic.htmlhXC  theorem List.forIn'_map {m : Type u_1 → Type u_2} {α : Type u_3} {β : Type u_4} {γ : Type u_1} {init : γ} [Monad m] [LawfulMonad m] {l : List α} (g : α → β) (f : (b : β) → b ∈ map g l → γ → m (ForInStep γ)) :
forIn' (map g l) init f = forIn' l init fun (a : α) (h : a ∈ l) (y : γ) => f (g a) ⋯ yh
huList.forIn_eq_foldlM}(hj}  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Monadic.htmlhX  theorem List.forIn_eq_foldlM {m : Type u_1 → Type u_2} {α : Type u_3} {β : Type u_1} [Monad m] [LawfulMonad m] {l : List α} (f : α → β → m (ForInStep β)) (init : β) :
forIn l init f = ForInStep.value <$> foldlM
      (fun (b : ForInStep β) (a : α) =>
        match b with
        | ForInStep.yield b => f a b
        | ForInStep.done b => pure (ForInStep.done b))
      (ForInStep.yield init) lh
We can express a for loop over a list as a fold, in which whenever we reach .done b we keep that value through the rest of the fold.uList.forIn_yield_eq_foldlM}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Monadic.htmlhXg  theorem List.forIn_yield_eq_foldlM {m : Type u_1 → Type u_2} {α : Type u_3} {β γ : Type u_1} [Monad m] [LawfulMonad m] {l : List α} (f : α → β → m γ) (g : α → β → γ → β) (init : β) :
(forIn l init fun (a : α) (b : β) => (fun (c : γ) => ForInStep.yield (g a b c)) <$> f a b) = foldlM (fun (b : β) (a : α) => g a b <$> f a b) init lh
DWe can express a for loop over a list which always yields as a fold.uList.forIn_pure_yield_eq_foldl}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Monadic.htmlhX-  theorem List.forIn_pure_yield_eq_foldl {m : Type u_1 → Type u_2} {α : Type u_3} {β : Type u_1} [Monad m] [LawfulMonad m] {l : List α} (f : α → β → β) (init : β) :
(forIn l init fun (a : α) (b : β) => pure (ForInStep.yield (f a b))) = pure (foldl (fun (b : β) (a : α) => f a b) init l)h
huList.idRun_forIn_yield_eq_foldl}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Monadic.htmlhtheorem List.idRun_forIn_yield_eq_foldl {α : Type u_1} {β : Type u_2} (l : List α) (f : α → β → Id β) (init : β) :
(forIn l init fun (a : α) (b : β) => ForInStep.yield <$> f a b).run = foldl (fun (b : β) (a : α) => (f a b).run) init lh
huList.forIn_yield_eq_foldl}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Monadic.htmlhtheorem List.forIn_yield_eq_foldl {α : Type u_1} {β : Type u_2} {l : List α} (f : α → β → β) (init : β) :
(forIn l init fun (a : α) (b : β) => ForInStep.yield (f a b)) = foldl (fun (b : β) (a : α) => f a b) init lh
huList.forIn_map}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Monadic.htmlhX  theorem List.forIn_map {m : Type u_1 → Type u_2} {α : Type u_3} {β : Type u_4} {γ : Type u_1} {init : γ} [Monad m] [LawfulMonad m] {l : List α} {g : α → β} {f : β → γ → m (ForInStep γ)} :
forIn (map g l) init f = forIn l init fun (a : α) (y : γ) => f (g a) yh
huList.allM_eq_not_anyM_not}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Monadic.htmlhtheorem List.allM_eq_not_anyM_not {m : Type → Type u_1} {α : Type u_2} [Monad m] [LawfulMonad m] {p : α → m Bool} {as : List α} :
allM p as = (fun (x : Bool) => !x) <$> anyM (fun (x : α) => (fun (x : Bool) => !x) <$> p x) ash
huList.anyM_pure}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Monadic.htmlhtheorem List.anyM_pure {m : Type → Type u_1} {α : Type u_2} [Monad m] [LawfulMonad m] {p : α → Bool} {as : List α} :
anyM (fun (x : α) => pure (p x)) as = pure (as.any p)h
huList.allM_pure}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Monadic.htmlhtheorem List.allM_pure {m : Type → Type u_1} {α : Type u_2} [Monad m] [LawfulMonad m] {p : α → Bool} {as : List α} :
allM (fun (x : α) => pure (p x)) as = pure (as.all p)h
huList.foldlM_subtype}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Monadic.htmlhX@  theorem List.foldlM_subtype {m : Type u_1 → Type u_2} {α : Type u_3} {β : Type u_1} [Monad m] {p : α → Prop} {l : List { x : α // p x }} {f : β → { x : α // p x } → m β} {g : β → α → m β} {x : β} (hf : ∀ (b : β) (x : α) (h : p x), f b ⟨x, h⟩ = g b x) :
foldlM f x l = foldlM g x l.unattachh
This lemma identifies monadic folds over lists of subtypes, where the function only depends on the value, not the proposition, and simplifies these to the function directly taking the value.uList.foldlM_wfParam}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Monadic.htmlhtheorem List.foldlM_wfParam {m : Type u_1 → Type u_2} {α : Type u_3} {β : Type u_1} [Monad m] {xs : List α} {f : β → α → m β} {init : β} :
foldlM f init (wfParam xs) = foldlM f init xs.attach.unattachh
huList.foldlM_unattach}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Monadic.htmlhX  theorem List.foldlM_unattach {m : Type u_1 → Type u_2} {α : Type u_3} {β : Type u_1} [Monad m] {P : α → Prop} {xs : List (Subtype P)} {f : β → α → m β} {init : β} :
foldlM f init xs.unattach = foldlM
    (fun (b : β) (x : Subtype P) =>
      match x with
      | ⟨x, h⟩ => binderNameHint b f (binderNameHint x (f b) (binderNameHint h () (f b (wfParam x)))))
    init xsh
huList.foldrM_subtype}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Monadic.htmlhXP  theorem List.foldrM_subtype {m : Type u_1 → Type u_2} {α : Type u_3} {β : Type u_1} [Monad m] [LawfulMonad m] {p : α → Prop} {l : List { x : α // p x }} {f : { x : α // p x } → β → m β} {g : α → β → m β} {x : β} (hf : ∀ (x : α) (h : p x) (b : β), f ⟨x, h⟩ b = g x b) :
foldrM f x l = foldrM g x l.unattachh
This lemma identifies monadic folds over lists of subtypes, where the function only depends on the value, not the proposition, and simplifies these to the function directly taking the value.uList.foldrM_wfParam}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Monadic.htmlhtheorem List.foldrM_wfParam {m : Type u_1 → Type u_2} {α : Type u_3} {β : Type u_1} [Monad m] [LawfulMonad m] {xs : List α} {f : α → β → m β} {init : β} :
foldrM f init (wfParam xs) = foldrM f init xs.attach.unattachh
huList.foldrM_unattach}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Monadic.htmlhX  theorem List.foldrM_unattach {m : Type u_1 → Type u_2} {α : Type u_3} {β : Type u_1} [Monad m] [LawfulMonad m] {P : α → Prop} {xs : List (Subtype P)} {f : α → β → m β} {init : β} :
foldrM f init xs.unattach = foldrM
    (fun (x : Subtype P) (b : β) =>
      match x with
      | ⟨x, h⟩ => binderNameHint x f (binderNameHint h () (binderNameHint b (f x) (f (wfParam x) b))))
    init xsh
huList.mapM_subtype}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Monadic.htmlhX"  theorem List.mapM_subtype {m : Type u_1 → Type u_2} {α : Type u_3} {β : Type u_1} [Monad m] [LawfulMonad m] {p : α → Prop} {l : List { x : α // p x }} {f : { x : α // p x } → m β} {g : α → m β} (hf : ∀ (x : α) (h : p x), f ⟨x, h⟩ = g x) :
mapM f l = mapM g l.unattachh
This lemma identifies monadic maps over lists of subtypes, where the function only depends on the value, not the proposition, and simplifies these to the function directly taking the value.uList.mapM_wfParam}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Monadic.htmlhtheorem List.mapM_wfParam {m : Type u_1 → Type u_2} {α : Type u_3} {β : Type u_1} [Monad m] [LawfulMonad m] {xs : List α} {f : α → m β} :
mapM f (wfParam xs) = mapM f xs.attach.unattachh
huList.mapM_unattach}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Monadic.htmlhXN  theorem List.mapM_unattach {m : Type u_1 → Type u_2} {α : Type u_3} {β : Type u_1} [Monad m] [LawfulMonad m] {P : α → Prop} {xs : List (Subtype P)} {f : α → m β} :
mapM f xs.unattach = mapM
    (fun (x : Subtype P) =>
      match x with
      | ⟨x, h⟩ => binderNameHint x f (binderNameHint h () (f (wfParam x))))
    xsh
huList.filterMapM_subtype}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Monadic.htmlhXF  theorem List.filterMapM_subtype {m : Type u_1 → Type u_2} {α : Type u_3} {β : Type u_1} [Monad m] [LawfulMonad m] {p : α → Prop} {l : List { x : α // p x }} {f : { x : α // p x } → m (Option β)} {g : α → m (Option β)} (hf : ∀ (x : α) (h : p x), f ⟨x, h⟩ = g x) :
filterMapM f l = filterMapM g l.unattachh
huList.filterMapM_wfParam}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Monadic.htmlhtheorem List.filterMapM_wfParam {m : Type u_1 → Type u_2} {α : Type u_3} {β : Type u_1} [Monad m] [LawfulMonad m] {xs : List α} {f : α → m (Option β)} :
filterMapM f (wfParam xs) = filterMapM f xs.attach.unattachh
huList.filterMapM_unattach}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Monadic.htmlhXi  theorem List.filterMapM_unattach {m : Type u_1 → Type u_2} {α : Type u_3} {β : Type u_1} [Monad m] [LawfulMonad m] {P : α → Prop} {xs : List (Subtype P)} {f : α → m (Option β)} :
filterMapM f xs.unattach = filterMapM
    (fun (x : Subtype P) =>
      match x with
      | ⟨x, h⟩ => binderNameHint x f (binderNameHint h () (f (wfParam x))))
    xsh
huList.flatMapM_subtype}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Monadic.htmlhX<  theorem List.flatMapM_subtype {m : Type u_1 → Type u_2} {α : Type u_3} {β : Type u_1} [Monad m] [LawfulMonad m] {p : α → Prop} {l : List { x : α // p x }} {f : { x : α // p x } → m (List β)} {g : α → m (List β)} (hf : ∀ (x : α) (h : p x), f ⟨x, h⟩ = g x) :
flatMapM f l = flatMapM g l.unattachh
huList.flatMapM_wfParam}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Monadic.htmlhtheorem List.flatMapM_wfParam {m : Type u_1 → Type u_2} {α : Type u_3} {β : Type u_1} [Monad m] [LawfulMonad m] {xs : List α} {f : α → m (List β)} :
flatMapM f (wfParam xs) = flatMapM f xs.attach.unattachh
huList.flatMapM_unattach}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Monadic.htmlhXa  theorem List.flatMapM_unattach {m : Type u_1 → Type u_2} {α : Type u_3} {β : Type u_1} [Monad m] [LawfulMonad m] {P : α → Prop} {xs : List (Subtype P)} {f : α → m (List β)} :
flatMapM f xs.unattach = flatMapM
    (fun (x : Subtype P) =>
      match x with
      | ⟨x, h⟩ => binderNameHint x f (binderNameHint h () (f (wfParam x))))
    xsh
huList.insertIdx_zero}(hj  hVhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/InsertIdx.htmlh^theorem List.insertIdx_zero {α : Type u} {xs : List α} {x : α} :
xs.insertIdx 0 x = x :: xsh
huList.insertIdx_succ_nil}(hj  hVhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/InsertIdx.htmlh^theorem List.insertIdx_succ_nil {α : Type u} {n : Nat} {a : α} :
[].insertIdx (n + 1) a = []h
huList.insertIdx_succ_cons}(hj  hVhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/InsertIdx.htmlhtheorem List.insertIdx_succ_cons {α : Type u} {xs : List α} {hd x : α} {i : Nat} :
(hd :: xs).insertIdx (i + 1) x = hd :: xs.insertIdx i xh
huList.length_insertIdx}(hj  hVhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/InsertIdx.htmlhtheorem List.length_insertIdx {α : Type u} {a : α} {i : Nat} {as : List α} :
(as.insertIdx i a).length = if i ≤ as.length then as.length + 1 else as.lengthh
hu"List.length_insertIdx_of_le_length}(hj  hVhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/InsertIdx.htmlhtheorem List.length_insertIdx_of_le_length {α : Type u} {i : Nat} {as : List α} (h : i ≤ as.length) (a : α) :
(as.insertIdx i a).length = as.length + 1h
hu"List.length_insertIdx_of_length_lt}(hj  hVhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/InsertIdx.htmlhtheorem List.length_insertIdx_of_length_lt {α : Type u} {as : List α} {i : Nat} (h : as.length < i) (a : α) :
(as.insertIdx i a).length = as.lengthh
huList.insertIdx_eraseIdx_of_ge}(hj  hVhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/InsertIdx.htmlhtheorem List.insertIdx_eraseIdx_of_ge {α : Type u} {a : α} {i j : Nat} {as : List α} :
i < as.length → i ≤ j → (as.eraseIdx i).insertIdx j a = (as.insertIdx (j + 1) a).eraseIdx ih
huList.insertIdx_eraseIdx_of_le}(hj  hVhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/InsertIdx.htmlhtheorem List.insertIdx_eraseIdx_of_le {α : Type u} {a : α} {i j : Nat} {as : List α} :
i < as.length → j ≤ i → (as.eraseIdx i).insertIdx j a = (as.insertIdx j a).eraseIdx (i + 1)h
huList.insertIdx_eraseIdx}(hj  hVhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/InsertIdx.htmlhtheorem List.insertIdx_eraseIdx {α : Type u} {a : α} {i : Nat} {as : List α} {j : Nat} (h : i < as.length) :
(as.eraseIdx i).insertIdx j a = if i ≤ j then (as.insertIdx (j + 1) a).eraseIdx i else (as.insertIdx j a).eraseIdx (i + 1)h
huList.insertIdx_comm}(hj  hVhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/InsertIdx.htmlhtheorem List.insertIdx_comm {α : Type u} (a b : α) {i j : Nat} {l : List α} :
i ≤ j → j ≤ l.length → (l.insertIdx i a).insertIdx (j + 1) b = (l.insertIdx j b).insertIdx i ah
huList.mem_insertIdx}(hj
  hVhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/InsertIdx.htmlhtheorem List.mem_insertIdx {α : Type u} {a b : α} {i : Nat} {l : List α} :
i ≤ l.length → (a ∈ l.insertIdx i b ↔ a = b ∨ a ∈ l)h
huList.insertIdx_of_length_lt}(hj  hVhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/InsertIdx.htmlh{theorem List.insertIdx_of_length_lt {α : Type u} {l : List α} {x : α} {i : Nat} (h : l.length < i) :
l.insertIdx i x = lh
huList.eraseIdx_insertIdx_self}(hj  hVhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/InsertIdx.htmlhvtheorem List.eraseIdx_insertIdx_self {α : Type u} {i : Nat} {l : List α} (a : α) :
(l.insertIdx i a).eraseIdx i = lh
huList.eraseIdx_insertIdx}(hj  hVhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/InsertIdx.htmlhrabbrev List.eraseIdx_insertIdx {α : Type u_1} {i : Nat} {l : List α} (a : α) :
(l.insertIdx i a).eraseIdx i = lh
huList.insertIdx_length_self}(hj  hVhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/InsertIdx.htmlhktheorem List.insertIdx_length_self {α : Type u} {l : List α} {x : α} :
l.insertIdx l.length x = l ++ [x]h
huList.length_le_length_insertIdx}(hj  hVhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/InsertIdx.htmlh~theorem List.length_le_length_insertIdx {α : Type u} {l : List α} {x : α} {i : Nat} :
l.length ≤ (l.insertIdx i x).lengthh
huList.length_insertIdx_le_succ}(hj"  hVhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/InsertIdx.htmlhtheorem List.length_insertIdx_le_succ {α : Type u} {l : List α} {x : α} {i : Nat} :
(l.insertIdx i x).length ≤ l.length + 1h
huList.getElem_insertIdx_of_lt}(hj&  hVhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/InsertIdx.htmlhtheorem List.getElem_insertIdx_of_lt {α : Type u} {l : List α} {x : α} {i j : Nat} (hn : j < i) (hk : j < (l.insertIdx i x).length) :
(l.insertIdx i x)[j] = l[j]h
huList.getElem_insertIdx_self}(hj*  hVhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/InsertIdx.htmlhtheorem List.getElem_insertIdx_self {α : Type u} {l : List α} {x : α} {i : Nat} (hi : i < (l.insertIdx i x).length) :
(l.insertIdx i x)[i] = xh
huList.getElem_insertIdx_of_gt}(hj.  hVhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/InsertIdx.htmlhtheorem List.getElem_insertIdx_of_gt {α : Type u} {l : List α} {x : α} {i j : Nat} (hn : i < j) (hk : j < (l.insertIdx i x).length) :
(l.insertIdx i x)[j] = l[j - 1]h
huList.getElem_insertIdx_of_ge}(hj2  hVhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/InsertIdx.htmlhabbrev List.getElem_insertIdx_of_ge {α : Type u_1} {l : List α} {x : α} {i j : Nat} (hn : i < j) (hk : j < (l.insertIdx i x).length) :
(l.insertIdx i x)[j] = l[j - 1]h
huList.getElem_insertIdx}(hj6  hVhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/InsertIdx.htmlhtheorem List.getElem_insertIdx {α : Type u} {l : List α} {x : α} {i j : Nat} (h : j < (l.insertIdx i x).length) :
(l.insertIdx i x)[j] = if h₁ : j < i then l[j] else if h₂ : j = i then x else l[j - 1]h
huList.getElem?_insertIdx}(hj:  hVhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/InsertIdx.htmlhtheorem List.getElem?_insertIdx {α : Type u} {l : List α} {x : α} {i j : Nat} :
(l.insertIdx i x)[j]? = if j < i then l[j]? else if j = i then if j ≤ l.length then some x else none else l[j - 1]?h
huList.getElem?_insertIdx_of_lt}(hj>  hVhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/InsertIdx.htmlhtheorem List.getElem?_insertIdx_of_lt {α : Type u} {l : List α} {x : α} {i j : Nat} (h : j < i) :
(l.insertIdx i x)[j]? = l[j]?h
huList.getElem?_insertIdx_self}(hjB  hVhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/InsertIdx.htmlhtheorem List.getElem?_insertIdx_self {α : Type u} {l : List α} {x : α} {i : Nat} :
(l.insertIdx i x)[i]? = if i ≤ l.length then some x else noneh
huList.getElem?_insertIdx_of_gt}(hjF  hVhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/InsertIdx.htmlhtheorem List.getElem?_insertIdx_of_gt {α : Type u} {l : List α} {x : α} {i j : Nat} (h : i < j) :
(l.insertIdx i x)[j]? = l[j - 1]?h
huList.getElem?_insertIdx_of_ge}(hjJ  hVhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/InsertIdx.htmlhabbrev List.getElem?_insertIdx_of_ge {α : Type u_1} {l : List α} {x : α} {i j : Nat} (h : i < j) :
(l.insertIdx i x)[j]? = l[j - 1]?h
huList.suffix_iff_getElem?}(hjN  hThttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Sublist.htmlhtheorem List.suffix_iff_getElem? {α : Type u_1} {l₁ l₂ : List α} :
l₁ <:+ l₂ ↔ l₁.length ≤ l₂.length ∧ ∀ (i : Nat) (h : i < l₁.length), l₂[i + l₂.length - l₁.length]? = some l₁[i]h
huList.isSuffix_iff}(hjR  hThttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Sublist.htmlhabbrev List.isSuffix_iff {α : Type u_1} {l₁ l₂ : List α} :
l₁ <:+ l₂ ↔ l₁.length ≤ l₂.length ∧ ∀ (i : Nat) (h : i < l₁.length), l₂[i + l₂.length - l₁.length]? = some l₁[i]h
huList.suffix_iff_getElem}(hjV  hThttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Sublist.htmlhtheorem List.suffix_iff_getElem {α : Type u_1} {l₁ l₂ : List α} :
l₁ <:+ l₂ ↔ ∃ (x : l₁.length ≤ l₂.length), ∀ (i : Nat) (x_1 : i < l₁.length), l₂[i + l₂.length - l₁.length] = l₁[i]h
huList.infix_iff_getElem?}(hjZ  hThttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Sublist.htmlhtheorem List.infix_iff_getElem? {α : Type u_1} {l₁ l₂ : List α} :
l₁ <:+: l₂ ↔ ∃ (k : Nat), l₁.length + k ≤ l₂.length ∧ ∀ (i : Nat) (h : i < l₁.length), l₂[i + k]? = some l₁[i]h
huList.isInfix_iff}(hj^  hThttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Sublist.htmlhabbrev List.isInfix_iff {α : Type u_1} {l₁ l₂ : List α} :
l₁ <:+: l₂ ↔ ∃ (k : Nat), l₁.length + k ≤ l₂.length ∧ ∀ (i : Nat) (h : i < l₁.length), l₂[i + k]? = some l₁[i]h
huList.suffix_iff_eq_append}(hjb  hThttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Sublist.htmlhtheorem List.suffix_iff_eq_append {α✝ : Type u_1} {l₁ l₂ : List α✝} :
l₁ <:+ l₂ ↔ take (l₂.length - l₁.length) l₂ ++ l₁ = l₂h
huList.prefix_take_iff}(hjf  hThttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Sublist.htmlh}theorem List.prefix_take_iff {α : Type u_1} {xs ys : List α} {i : Nat} :
xs <+: take i ys ↔ xs <+: ys ∧ xs.length ≤ ih
huList.suffix_iff_eq_drop}(hjj  hThttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Sublist.htmlhtheorem List.suffix_iff_eq_drop {α✝ : Type u_1} {l₁ l₂ : List α✝} :
l₁ <:+ l₂ ↔ l₁ = drop (l₂.length - l₁.length) l₂h
huList.prefix_take_le_iff}(hjn  hThttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Sublist.htmlhtheorem List.prefix_take_le_iff {α : Type u_1} {i j : Nat} {xs : List α} (hm : i < xs.length) :
take i xs <+: take j xs ↔ i ≤ jh
huList.append_left_sublist_self}(hjr  hThttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Sublist.htmlhwtheorem List.append_left_sublist_self {α : Type u_1} {xs : List α} (ys : List α) :
(xs ++ ys).Sublist ys ↔ xs = []h
huList.append_right_sublist_self}(hjv  hThttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Sublist.htmlhxtheorem List.append_right_sublist_self {α : Type u_1} (xs : List α) {ys : List α} :
(xs ++ ys).Sublist xs ↔ ys = []h
hu#List.append_sublist_of_sublist_left}(hjz  hThttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Sublist.htmlhtheorem List.append_sublist_of_sublist_left {α : Type u_1} {xs ys zs : List α} (h : zs.Sublist xs) :
(xs ++ ys).Sublist zs ↔ ys = [] ∧ xs = zsh
hu$List.append_sublist_of_sublist_right}(hj~  hThttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Sublist.htmlhtheorem List.append_sublist_of_sublist_right {α : Type u_1} {xs ys zs : List α} (h : zs.Sublist ys) :
(xs ++ ys).Sublist zs ↔ xs = [] ∧ ys = zsh
huList.length_modifyHead}(hj  hShttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Modify.htmlhqtheorem List.length_modifyHead {α : Type u_1} {f : α → α} {l : List α} :
(modifyHead f l).length = l.lengthh
huList.modifyHead_eq_set}(hj  hShttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Modify.htmlhtheorem List.modifyHead_eq_set {α : Type u_1} [Inhabited α] (f : α → α) (l : List α) :
modifyHead f l = l.set 0 (f (l[0]?.getD default))h
huList.modifyHead_eq_nil_iff}(hj  hShttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Modify.htmlhqtheorem List.modifyHead_eq_nil_iff {α : Type u_1} {f : α → α} {l : List α} :
modifyHead f l = [] ↔ l = []h
huList.modifyHead_modifyHead}(hj  hShttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Modify.htmlhtheorem List.modifyHead_modifyHead {α : Type u_1} {l : List α} {f g : α → α} :
modifyHead g (modifyHead f l) = modifyHead (g ∘ f) lh
huList.getElem_modifyHead}(hj  hShttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Modify.htmlhtheorem List.getElem_modifyHead {α : Type u_1} {l : List α} {f : α → α} {i : Nat} (h : i < (modifyHead f l).length) :
(modifyHead f l)[i] = if h' : i = 0 then f l[0] else l[i]h
huList.getElem_modifyHead_zero}(hj  hShttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Modify.htmlhtheorem List.getElem_modifyHead_zero {α : Type u_1} {l : List α} {f : α → α} {h : 0 < (modifyHead f l).length} :
(modifyHead f l)[0] = f l[0]h
huList.getElem_modifyHead_succ}(hj  hShttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Modify.htmlhtheorem List.getElem_modifyHead_succ {α : Type u_1} {l : List α} {f : α → α} {n : Nat} (h : n + 1 < (modifyHead f l).length) :
(modifyHead f l)[n + 1] = l[n + 1]h
huList.getElem?_modifyHead}(hj  hShttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Modify.htmlhtheorem List.getElem?_modifyHead {α : Type u_1} {l : List α} {f : α → α} {i : Nat} :
(modifyHead f l)[i]? = if i = 0 then Option.map f l[i]? else l[i]?h
huList.getElem?_modifyHead_zero}(hj  hShttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Modify.htmlhtheorem List.getElem?_modifyHead_zero {α : Type u_1} {l : List α} {f : α → α} :
(modifyHead f l)[0]? = Option.map f l[0]?h
huList.getElem?_modifyHead_succ}(hj  hShttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Modify.htmlhtheorem List.getElem?_modifyHead_succ {α : Type u_1} {l : List α} {f : α → α} {n : Nat} :
(modifyHead f l)[n + 1]? = l[n + 1]?h
huList.head_modifyHead}(hj  hShttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Modify.htmlhtheorem List.head_modifyHead {α : Type u_1} (f : α → α) (l : List α) (h : modifyHead f l ≠ []) :
(modifyHead f l).head h = f (l.head ⋯)h
huList.head?_modifyHead}(hj  hShttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Modify.htmlh{theorem List.head?_modifyHead {α : Type u_1} {l : List α} {f : α → α} :
(modifyHead f l).head? = Option.map f l.head?h
huList.tail_modifyHead}(hj  hShttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Modify.htmlhktheorem List.tail_modifyHead {α : Type u_1} {f : α → α} {l : List α} :
(modifyHead f l).tail = l.tailh
huList.take_modifyHead}(hj  hShttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Modify.htmlhtheorem List.take_modifyHead {α : Type u_1} {f : α → α} {l : List α} {i : Nat} :
take i (modifyHead f l) = modifyHead f (take i l)h
huList.drop_modifyHead_of_pos}(hj  hShttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Modify.htmlhtheorem List.drop_modifyHead_of_pos {α : Type u_1} {f : α → α} {l : List α} {i : Nat} (h : 0 < i) :
drop i (modifyHead f l) = drop i lh
huList.eraseIdx_modifyHead_zero}(hj  hShttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Modify.htmlhtheorem List.eraseIdx_modifyHead_zero {α : Type u_1} {f : α → α} {l : List α} :
(modifyHead f l).eraseIdx 0 = l.eraseIdx 0h
huList.eraseIdx_modifyHead_of_pos}(hj  hShttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Modify.htmlhtheorem List.eraseIdx_modifyHead_of_pos {α : Type u_1} {f : α → α} {l : List α} {i : Nat} (h : 0 < i) :
(modifyHead f l).eraseIdx i = modifyHead f (l.eraseIdx i)h
huList.modifyHead_id}(hj  hShttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Modify.htmlh?theorem List.modifyHead_id {α : Type u_1} :
modifyHead id = idh
huList.modifyHead_dropLast}(hj  hShttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Modify.htmlhtheorem List.modifyHead_dropLast {α : Type u_1} {l : List α} {f : α → α} :
modifyHead f l.dropLast = (modifyHead f l).dropLasth
huList.modifyTailIdx_id}(hj  hShttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Modify.htmlh`theorem List.modifyTailIdx_id {α : Type u_1} (i : Nat) (l : List α) :
l.modifyTailIdx i id = lh
huList.eraseIdx_eq_modifyTailIdx}(hj  hShttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Modify.htmlhvtheorem List.eraseIdx_eq_modifyTailIdx {α : Type u_1} (i : Nat) (l : List α) :
l.eraseIdx i = l.modifyTailIdx i tailh
huList.length_modifyTailIdx}(hj  hShttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Modify.htmlhtheorem List.length_modifyTailIdx {α : Type u_1} (f : List α → List α) (H : ∀ (l : List α), (f l).length = l.length) (l : List α) (i : Nat) :
(l.modifyTailIdx i f).length = l.lengthh
huList.modifyTailIdx_add}(hj  hShttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Modify.htmlhtheorem List.modifyTailIdx_add {α : Type u_1} (f : List α → List α) (i : Nat) (l₁ l₂ : List α) :
(l₁ ++ l₂).modifyTailIdx (l₁.length + i) f = l₁ ++ l₂.modifyTailIdx i fh
huList.modifyTailIdx_eq_take_drop}(hj  hShttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Modify.htmlhtheorem List.modifyTailIdx_eq_take_drop {α : Type u_1} (f : List α → List α) (H : f [] = []) (l : List α) (i : Nat) :
l.modifyTailIdx i f = take i l ++ f (drop i l)h
huList.exists_of_modifyTailIdx}(hj  hShttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Modify.htmlhtheorem List.exists_of_modifyTailIdx {α : Type u_1} (f : List α → List α) {i : Nat} {l : List α} (h : i ≤ l.length) :
∃ (l₁ : List α), ∃ (l₂ : List α), l = l₁ ++ l₂ ∧ l₁.length = i ∧ l.modifyTailIdx i f = l₁ ++ f l₂h
hu List.modifyTailIdx_modifyTailIdx}(hj  hShttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Modify.htmlhtheorem List.modifyTailIdx_modifyTailIdx {α : Type u_1} {f g : List α → List α} (i j : Nat) (l : List α) :
(l.modifyTailIdx j f).modifyTailIdx (i + j) g = l.modifyTailIdx j fun (l : List α) => (f l).modifyTailIdx i gh
hu#List.modifyTailIdx_modifyTailIdx_le}(hj  hShttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Modify.htmlhtheorem List.modifyTailIdx_modifyTailIdx_le {α : Type u_1} {f g : List α → List α} (i j : Nat) (l : List α) (h : j ≤ i) :
(l.modifyTailIdx j f).modifyTailIdx i g = l.modifyTailIdx j fun (l : List α) => (f l).modifyTailIdx (i - j) gh
hu%List.modifyTailIdx_modifyTailIdx_self}(hj  hShttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Modify.htmlhtheorem List.modifyTailIdx_modifyTailIdx_self {α : Type u_1} {f g : List α → List α} (i : Nat) (l : List α) :
(l.modifyTailIdx i f).modifyTailIdx i g = l.modifyTailIdx i (g ∘ f)h
huList.modify_nil}(hj  hShttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Modify.htmlhVtheorem List.modify_nil {α : Type u_1} (f : α → α) (i : Nat) :
[].modify i f = []h
huList.modify_zero_cons}(hj  hShttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Modify.htmlhutheorem List.modify_zero_cons {α : Type u_1} (f : α → α) (a : α) (l : List α) :
(a :: l).modify 0 f = f a :: lh
huList.modify_succ_cons}(hj  hShttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Modify.htmlhtheorem List.modify_succ_cons {α : Type u_1} (f : α → α) (a : α) (l : List α) (i : Nat) :
(a :: l).modify (i + 1) f = a :: l.modify i fh
huList.modify_cons}(hj  hShttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Modify.htmlhtheorem List.modify_cons {α : Type u_1} {f : α → α} {a : α} {l : List α} {i : Nat} :
(a :: l).modify i f = if i = 0 then f a :: l else a :: l.modify (i - 1) fh
huList.modifyHead_eq_modify_zero}(hj  hShttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Modify.htmlhttheorem List.modifyHead_eq_modify_zero {α : Type u_1} (f : α → α) (l : List α) :
modifyHead f l = l.modify 0 fh
huList.modify_eq_nil_iff}(hj  hShttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Modify.htmlhutheorem List.modify_eq_nil_iff {α : Type u_1} {f : α → α} {i : Nat} {l : List α} :
l.modify i f = [] ↔ l = []h
huList.getElem?_modify}(hj
  hShttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Modify.htmlhtheorem List.getElem?_modify {α : Type u_1} (f : α → α) (i : Nat) (l : List α) (j : Nat) :
(l.modify i f)[j]? = (fun (a : α) => if i = j then f a else a) <$> l[j]?h
huList.length_modify}(hj  hShttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Modify.htmlhutheorem List.length_modify {α : Type u_1} (f : α → α) (l : List α) (i : Nat) :
(l.modify i f).length = l.lengthh
huList.getElem?_modify_eq}(hj  hShttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Modify.htmlhztheorem List.getElem?_modify_eq {α : Type u_1} (f : α → α) (i : Nat) (l : List α) :
(l.modify i f)[i]? = f <$> l[i]?h
huList.getElem?_modify_ne}(hj  hShttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Modify.htmlhtheorem List.getElem?_modify_ne {α : Type u_1} (f : α → α) {i j : Nat} (l : List α) (h : i ≠ j) :
(l.modify i f)[j]? = l[j]?h
huList.getElem_modify}(hj  hShttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Modify.htmlhtheorem List.getElem_modify {α : Type u_1} (f : α → α) (i : Nat) (l : List α) (j : Nat) (h : j < (l.modify i f).length) :
(l.modify i f)[j] = if i = j then f l[j] else l[j]h
huList.getElem_modify_eq}(hj  hShttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Modify.htmlhtheorem List.getElem_modify_eq {α : Type u_1} (f : α → α) (i : Nat) (l : List α) (h : i < (l.modify i f).length) :
(l.modify i f)[i] = f l[i]h
huList.getElem_modify_ne}(hj"  hShttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Modify.htmlhtheorem List.getElem_modify_ne {α : Type u_1} (f : α → α) {i j : Nat} (l : List α) (h : i ≠ j) (h' : j < (l.modify i f).length) :
(l.modify i f)[j] = l[j]h
huList.modify_eq_self}(hj&  hShttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Modify.htmlh{theorem List.modify_eq_self {α : Type u_1} {f : α → α} {i : Nat} {l : List α} (h : l.length ≤ i) :
l.modify i f = lh
huList.modify_modify_eq}(hj*  hShttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Modify.htmlhtheorem List.modify_modify_eq {α : Type u_1} (f g : α → α) (i : Nat) (l : List α) :
(l.modify i f).modify i g = l.modify i (g ∘ f)h
huList.modify_modify_ne}(hj.  hShttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Modify.htmlhtheorem List.modify_modify_ne {α : Type u_1} (f g : α → α) {i j : Nat} (l : List α) (h : i ≠ j) :
(l.modify i f).modify j g = (l.modify j g).modify i fh
huList.modify_eq_set}(hj2  hShttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Modify.htmlhtheorem List.modify_eq_set {α : Type u_1} [Inhabited α] (f : α → α) (i : Nat) (l : List α) :
l.modify i f = l.set i (f (l[i]?.getD default))h
huList.modify_eq_take_drop}(hj6  hShttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Modify.htmlhtheorem List.modify_eq_take_drop {α : Type u_1} (f : α → α) (l : List α) (i : Nat) :
l.modify i f = take i l ++ modifyHead f (drop i l)h
huList.modify_eq_take_cons_drop}(hj:  hShttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Modify.htmlhtheorem List.modify_eq_take_cons_drop {α : Type u_1} {f : α → α} {i : Nat} {l : List α} (h : i < l.length) :
l.modify i f = take i l ++ f l[i] :: drop (i + 1) lh
huList.exists_of_modify}(hj>  hShttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Modify.htmlhtheorem List.exists_of_modify {α : Type u_1} (f : α → α) {i : Nat} {l : List α} (h : i < l.length) :
∃ (l₁ : List α), ∃ (a : α), ∃ (l₂ : List α), l = l₁ ++ a :: l₂ ∧ l₁.length = i ∧ l.modify i f = l₁ ++ f a :: l₂h
huList.modify_id}(hjB  hShttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Modify.htmlhRtheorem List.modify_id {α : Type u_1} (i : Nat) (l : List α) :
l.modify i id = lh
huList.take_modify}(hjF  hShttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Modify.htmlhtheorem List.take_modify {α : Type u_1} (f : α → α) (i j : Nat) (l : List α) :
take j (l.modify i f) = (take j l).modify i fh
huList.drop_modify_of_lt}(hjJ  hShttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Modify.htmlhtheorem List.drop_modify_of_lt {α : Type u_1} (f : α → α) (i j : Nat) (l : List α) (h : i < j) :
drop j (l.modify i f) = drop j lh
huList.drop_modify_of_ge}(hjN  hShttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Modify.htmlhtheorem List.drop_modify_of_ge {α : Type u_1} (f : α → α) (i j : Nat) (l : List α) (h : i ≥ j) :
drop j (l.modify i f) = (drop j l).modify (i - j) fh
huList.eraseIdx_modify_of_eq}(hjR  hShttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Modify.htmlhtheorem List.eraseIdx_modify_of_eq {α : Type u_1} (f : α → α) (i : Nat) (l : List α) :
(l.modify i f).eraseIdx i = l.eraseIdx ih
huList.eraseIdx_modify_of_lt}(hjV  hShttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Modify.htmlhtheorem List.eraseIdx_modify_of_lt {α : Type u_1} (f : α → α) (i j : Nat) (l : List α) (h : j < i) :
(l.modify i f).eraseIdx j = (l.eraseIdx j).modify (i - 1) fh
huList.eraseIdx_modify_of_gt}(hjZ  hShttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Modify.htmlhtheorem List.eraseIdx_modify_of_gt {α : Type u_1} (f : α → α) (i j : Nat) (l : List α) (h : j > i) :
(l.modify i f).eraseIdx j = (l.eraseIdx j).modify i fh
huList.modify_eraseIdx_of_lt}(hj^  hShttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Modify.htmlhtheorem List.modify_eraseIdx_of_lt {α : Type u_1} (f : α → α) (i j : Nat) (l : List α) (h : j < i) :
(l.eraseIdx i).modify j f = (l.modify j f).eraseIdx ih
huList.modify_eraseIdx_of_ge}(hjb  hShttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Modify.htmlhtheorem List.modify_eraseIdx_of_ge {α : Type u_1} (f : α → α) (i j : Nat) (l : List α) (h : j ≥ i) :
(l.eraseIdx i).modify j f = (l.modify (j + 1) f).eraseIdx ih
hu	List.ofFn}(hjf  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/OfFn.htmlhDdef List.ofFn {α : Type u_1} {n : Nat} (f : Fin n → α) :
List αh
WCreates a list by applying f to each potential index in order, starting at 0.
Examples:u
List.ofFnM}(hjk  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/OfFn.htmlhqdef List.ofFnM {m : Type u_1 → Type u_2} {α : Type u_1} {n : Nat} [Monad m] (f : Fin n → m α) :
m (List α)h
Creates a list wrapped in a monad by applying the monadic function f : Fin n → m α to each potential index in order, starting at 0.uList.length_ofFn}(hjp  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/OfFn.htmlh[theorem List.length_ofFn {n : Nat} {α : Type u_1} {f : Fin n → α} :
(ofFn f).length = nh
huList.getElem_ofFn}(hjt  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/OfFn.html,      htheorem List.getElem_ofFn {n : Nat} {α : Type u_1} {i : Nat} {f : Fin n → α} (h : i < (ofFn f).length) :
(ofFn f)[i] = f ⟨i, ⋯⟩h
huList.getElem?_ofFn}(hjx  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/OfFn.htmlhtheorem List.getElem?_ofFn {n : Nat} {α : Type u_1} {i : Nat} {f : Fin n → α} :
(ofFn f)[i]? = if h : i < n then some (f ⟨i, h⟩) else noneh
huList.ofFn_zero}(hj|  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/OfFn.htmlhGtheorem List.ofFn_zero {α : Type u_1} {f : Fin 0 → α} :
ofFn f = []h
*ofFn on an empty domain is the empty list.uList.ofFn_succ}(hj  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/OfFn.htmlh|theorem List.ofFn_succ {α : Type u_1} {n : Nat} {f : Fin (n + 1) → α} :
ofFn f = f 0 :: ofFn fun (i : Fin n) => f i.succh
huList.ofFn_succ_last}(hj  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/OfFn.htmlhtheorem List.ofFn_succ_last {α : Type u_1} {n : Nat} {f : Fin (n + 1) → α} :
ofFn f = (ofFn fun (i : Fin n) => f i.castSucc) ++ [f (Fin.last n)]h
hu
List.ofFn_add}(hj  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/OfFn.htmlhtheorem List.ofFn_add {α : Type u_1} {n m : Nat} {f : Fin (n + m) → α} :
ofFn f = (ofFn fun (i : Fin n) => f (Fin.castLE ⋯ i)) ++ ofFn fun (i : Fin m) => f (Fin.natAdd n i)h
huList.ofFn_eq_nil_iff}(hj  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/OfFn.htmlhatheorem List.ofFn_eq_nil_iff {n : Nat} {α : Type u_1} {f : Fin n → α} :
ofFn f = [] ↔ n = 0h
hu
List.mem_ofFn}(hj  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/OfFn.htmlhwtheorem List.mem_ofFn {α : Type u_1} {n : Nat} {f : Fin n → α} {a : α} :
a ∈ ofFn f ↔ ∃ (i : Fin n), f i = ah
huList.head_ofFn}(hj  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/OfFn.htmlhztheorem List.head_ofFn {α : Type u_1} {n : Nat} {f : Fin n → α} (h : ofFn f ≠ []) :
(ofFn f).head h = f ⟨0, ⋯⟩h
huList.getLast_ofFn}(hj  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/OfFn.htmlhtheorem List.getLast_ofFn {α : Type u_1} {n : Nat} {f : Fin n → α} (h : ofFn f ≠ []) :
(ofFn f).getLast h = f ⟨n - 1, ⋯⟩h
huList.ofFnM_zero}(hj  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/OfFn.htmlhtheorem List.ofFnM_zero {m : Type u_1 → Type u_2} {α : Type u_1} [Monad m] [LawfulMonad m] {f : Fin 0 → m α} :
ofFnM f = pure []h
+ofFnM on an empty domain is the empty list.uList.ofFnM_succ_last}(hj  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/OfFn.htmlhtheorem List.ofFnM_succ_last {m : Type u_1 → Type u_2} {α : Type u_1} {n : Nat} [Monad m] [LawfulMonad m] {f : Fin (n + 1) → m α} :
ofFnM f = do
  let as ← ofFnM fun (i : Fin n) => f i.castSucc
  let a ← f (Fin.last n)
  pure (as ++ [a])h
huList.ofFnM_add}(hj  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/OfFn.htmlhX   theorem List.ofFnM_add {k : Nat} {α : Type u_1} {n : Nat} {m : Type u_1 → Type u_2} [Monad m] [LawfulMonad m] {f : Fin (n + k) → m α} :
ofFnM f = do
  let as ← ofFnM fun (i : Fin n) => f (Fin.castLE ⋯ i)
  let bs ← ofFnM fun (i : Fin k) => f (Fin.natAdd n i)
  pure (as ++ bs)h
huList.ofFnM_pure_comp}(hj  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/OfFn.htmlhtheorem List.ofFnM_pure_comp {m : Type u_1 → Type u_2} {α : Type u_1} [Monad m] [LawfulMonad m] {n : Nat} {f : Fin n → α} :
ofFnM (pure ∘ f) = pure (ofFn f)h
huList.ofFnM_pure}(hj  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/OfFn.htmlhtheorem List.ofFnM_pure {m : Type u_1 → Type u_2} {α : Type u_1} [Monad m] [LawfulMonad m] {n : Nat} {f : Fin n → α} :
(ofFnM fun (i : Fin n) => pure (f i)) = pure (ofFn f)h
huList.idRun_ofFnM}(hj  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/OfFn.htmlh|theorem List.idRun_ofFnM {n : Nat} {α : Type u_1} {f : Fin n → Id α} :
(ofFnM f).run = ofFn fun (i : Fin n) => (f i).runh
huList.mem_range'_1}(hj  hRhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Range.htmlhTtheorem List.mem_range'_1 {s n m : Nat} :
m ∈ range' s n ↔ s ≤ m ∧ m < s + nh
huList.getLast?_range'}(hj  hRhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Range.htmlhktheorem List.getLast?_range' {s n : Nat} :
(range' s n).getLast? = if n = 0 then none else some (s + n - 1)h
huList.getLast_range'}(hj  hRhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Range.htmlhdtheorem List.getLast_range' {s n : Nat} (h : range' s n ≠ []) :
(range' s n).getLast h = s + n - 1h
huList.pairwise_lt_range'}(hj  hRhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Range.htmlhtheorem List.pairwise_lt_range' {s n : Nat} (step : Nat := 1) (pos : 0 < step := by simp) :
Pairwise (fun (x1 x2 : Nat) => x1 < x2) (range' s n step)h
huList.pairwise_le_range'}(hj  hRhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Range.htmlh{theorem List.pairwise_le_range' {s n : Nat} (step : Nat := 1) :
Pairwise (fun (x1 x2 : Nat) => x1 ≤ x2) (range' s n step)h
huList.nodup_range'}(hj  hRhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Range.htmlhktheorem List.nodup_range' {s n : Nat} (step : Nat := 1) (h : 0 < step := by simp) :
(range' s n step).Noduph
huList.map_sub_range'}(hj  hRhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Range.htmlhtheorem List.map_sub_range' {step a s : Nat} (h : a ≤ s) (n : Nat) :
map (fun (x : Nat) => x - a) (range' s n step) = range' (s - a) n steph
huList.range'_eq_singleton_iff}(hj  hRhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Range.htmlhYtheorem List.range'_eq_singleton_iff {s n a : Nat} :
range' s n = [a] ↔ s = a ∧ n = 1h
huList.range'_eq_append_iff}(hj  hRhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Range.htmlhtheorem List.range'_eq_append_iff {s n step : Nat} {xs ys : List Nat} :
range' s n step = xs ++ ys ↔ ∃ (k : Nat), k ≤ n ∧ xs = range' s k step ∧ ys = range' (s + k * step) (n - k) steph
huList.find?_range'_eq_some}(hj  hRhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Range.htmlhtheorem List.find?_range'_eq_some {s n i : Nat} {p : Nat → Bool} :
find? p (range' s n) = some i ↔ p i = true ∧ i ∈ range' s n ∧ ∀ (j : Nat), s ≤ j → j < i → (!p j) = trueh
huList.find?_range'_eq_none}(hj  hRhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Range.htmlhtheorem List.find?_range'_eq_none {s n : Nat} {p : Nat → Bool} :
find? p (range' s n) = none ↔ ∀ (i : Nat), s ≤ i → i < s + n → (!p i) = trueh
huList.erase_range'}(hj  hRhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Range.htmlhtheorem List.erase_range' {s n i : Nat} :
(range' s n).erase i = range' s (min n (i - s)) ++ range' (max s (i + 1)) (min s (i + 1) + n - (i + 1))h
huList.count_range'}(hj  hRhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Range.htmlhtheorem List.count_range' {a s n step : Nat} (h : 0 < step := by simp) :
count a (range' s n step) = if ∃ (i : Nat), i < n ∧ a = s + step * i then 1 else 0h
huList.count_range_1'}(hj  hRhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Range.htmlhitheorem List.count_range_1' {a s n : Nat} :
count a (range' s n) = if s ≤ a ∧ a < s + n then 1 else 0h
huList.sum_range'}(hj  hRhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Range.htmlhmtheorem List.sum_range' {start n step : Nat} :
(range' start n step).sum = n * start + n * (n - 1) * step / 2h
huList.drop_range'}(hj  hRhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Range.htmlhwtheorem List.drop_range' {start n step k : Nat} :
drop k (range' start n step) = range' (start + k * step) (n - k) steph
huList.take_range'_of_length_le}(hj  hRhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Range.htmlhtheorem List.take_range'_of_length_le {n k start step : Nat} (h : n ≤ k) :
take k (range' start n step) = range' start n steph
huList.take_range'_of_length_ge}(hj  hRhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Range.htmlhtheorem List.take_range'_of_length_ge {n k start step : Nat} (h : n ≥ k) :
take k (range' start n step) = range' start k steph
huList.reverse_range'}(hj  hRhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Range.htmlhotheorem List.reverse_range' {s n : Nat} :
(range' s n).reverse = map (fun (x : Nat) => s + n - 1 - x) (range n)h
huList.mem_range}(hj  hRhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Range.htmlh<theorem List.mem_range {m n : Nat} :
m ∈ range n ↔ m < nh
huList.not_mem_range_self}(hj  hRhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Range.htmlh;theorem List.not_mem_range_self {n : Nat} :
¬n ∈ range nh
huList.self_mem_range_succ}(hj
  hRhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Range.htmlh@theorem List.self_mem_range_succ {n : Nat} :
n ∈ range (n + 1)h
huList.pairwise_lt_range}(hj  hRhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Range.htmlh\theorem List.pairwise_lt_range {n : Nat} :
Pairwise (fun (x1 x2 : Nat) => x1 < x2) (range n)h
huList.pairwise_le_range}(hj  hRhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Range.htmlh^theorem List.pairwise_le_range {n : Nat} :
Pairwise (fun (x1 x2 : Nat) => x1 ≤ x2) (range n)h
huList.take_range}(hj  hRhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Range.htmlhHtheorem List.take_range {i n : Nat} :
take i (range n) = range (min i n)h
huList.nodup_range}(hj  hRhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Range.htmlh4theorem List.nodup_range {n : Nat} :
(range n).Noduph
huList.find?_range_eq_some}(hj  hRhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Range.htmlhtheorem List.find?_range_eq_some {n i : Nat} {p : Nat → Bool} :
find? p (range n) = some i ↔ p i = true ∧ i ∈ range n ∧ ∀ (j : Nat), j < i → (!p j) = trueh
huList.find?_range_eq_none}(hj"  hRhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Range.htmlhtheorem List.find?_range_eq_none {n : Nat} {p : Nat → Bool} :
find? p (range n) = none ↔ ∀ (i : Nat), i < n → (!p i) = trueh
huList.erase_range}(hj&  hRhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Range.htmlhjtheorem List.erase_range {n i : Nat} :
(range n).erase i = range (min n i) ++ range' (i + 1) (n - (i + 1))h
huList.count_range}(hj*  hRhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Range.htmlhQtheorem List.count_range {a n : Nat} :
count a (range n) = if a < n then 1 else 0h
huList.zipIdx_singleton}(hj.  hRhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Range.htmlhZtheorem List.zipIdx_singleton {α : Type u_1} {x : α} {k : Nat} :
[x].zipIdx k = [(x, k)]h
huList.head?_zipIdx}(hj2  hRhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Range.htmlhtheorem List.head?_zipIdx {α : Type u_1} {l : List α} {k : Nat} :
(l.zipIdx k).head? = Option.map (fun (a : α) => (a, k)) l.head?h
huList.getLast?_zipIdx}(hj6  hRhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Range.htmlhtheorem List.getLast?_zipIdx {α : Type u_1} {l : List α} {k : Nat} :
(l.zipIdx k).getLast? = Option.map (fun (a : α) => (a, k + l.length - 1)) l.getLast?h
hu#List.mk_add_mem_zipIdx_iff_getElem?}(hj:  hRhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Range.htmlhtheorem List.mk_add_mem_zipIdx_iff_getElem? {α : Type u_1} {k i : Nat} {x : α} {l : List α} :
(x, k + i) ∈ l.zipIdx k ↔ l[i]? = some xh
hu*List.mk_mem_zipIdx_iff_le_and_getElem?_sub}(hj>  hRhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Range.htmlhtheorem List.mk_mem_zipIdx_iff_le_and_getElem?_sub {α : Type u_1} {k i : Nat} {x : α} {l : List α} :
(x, i) ∈ l.zipIdx k ↔ k ≤ i ∧ l[i - k]? = some xh
huList.mk_mem_zipIdx_iff_getElem?}(hjB  hRhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Range.htmlhtheorem List.mk_mem_zipIdx_iff_getElem? {α : Type u_1} {i : Nat} {x : α} {l : List α} :
(x, i) ∈ l.zipIdx ↔ l[i]? = some xh
sVariant of mk_mem_zipIdx_iff_le_and_getElem?_sub specialized at k = 0, to avoid the inequality and the subtraction.u'List.mem_zipIdx_iff_le_and_getElem?_sub}(hjG  hRhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Range.htmlhtheorem List.mem_zipIdx_iff_le_and_getElem?_sub {α : Type u_1} {x : α × Nat} {l : List α} {k : Nat} :
x ∈ l.zipIdx k ↔ k ≤ x.snd ∧ l[x.snd - k]? = some x.fsth
huList.mem_zipIdx_iff_getElem?}(hjK  hRhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Range.htmlh~theorem List.mem_zipIdx_iff_getElem? {α : Type u_1} {x : α × Nat} {l : List α} :
x ∈ l.zipIdx ↔ l[x.snd]? = some x.fsth
pVariant of mem_zipIdx_iff_le_and_getElem?_sub specialized at k = 0, to avoid the inequality and the subtraction.uList.le_snd_of_mem_zipIdx}(hjP  hRhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Range.htmlh~theorem List.le_snd_of_mem_zipIdx {α : Type u_1} {x : α × Nat} {k : Nat} {l : List α} (h : x ∈ l.zipIdx k) :
k ≤ x.sndh
huList.snd_lt_add_of_mem_zipIdx}(hjT  hRhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Range.htmlhtheorem List.snd_lt_add_of_mem_zipIdx {α : Type u_1} {x : α × Nat} {l : List α} {k : Nat} (h : x ∈ l.zipIdx k) :
x.snd < k + l.lengthh
huList.snd_lt_of_mem_zipIdx}(hjX  hRhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Range.htmlhtheorem List.snd_lt_of_mem_zipIdx {α : Type u_1} {x : α × Nat} {l : List α} {k : Nat} (h : x ∈ l.zipIdx k) :
x.snd < l.length + kh
huList.map_zipIdx}(hj\  hRhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Range.htmlhtheorem List.map_zipIdx {α : Type u_1} {β : Type u_2} {f : α → β} {l : List α} {k : Nat} :
map (Prod.map f id) (l.zipIdx k) = (map f l).zipIdx kh
huList.fst_mem_of_mem_zipIdx}(hj`  hRhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Range.htmlhtheorem List.fst_mem_of_mem_zipIdx {α : Type u_1} {x : α × Nat} {l : List α} {k : Nat} (h : x ∈ l.zipIdx k) :
x.fst ∈ lh
huList.fst_eq_of_mem_zipIdx}(hjd  hRhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Range.htmlhtheorem List.fst_eq_of_mem_zipIdx {α : Type u_1} {x : α × Nat} {l : List α} {k : Nat} (h : x ∈ l.zipIdx k) :
x.fst = l[x.snd - k]h
huList.mem_zipIdx}(hjh  hRhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Range.htmlhtheorem List.mem_zipIdx {α : Type u_1} {x : α} {i : Nat} {xs : List α} {k : Nat} (h : (x, i) ∈ xs.zipIdx k) :
k ≤ i ∧ i < k + xs.length ∧ x = xs[i - k]h
huList.mem_zipIdx'}(hjl  hRhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Range.htmlhtheorem List.mem_zipIdx' {α : Type u_1} {x : α} {i : Nat} {xs : List α} (h : (x, i) ∈ xs.zipIdx) :
i < xs.length ∧ x = xs[i]h
+Variant of mem_zipIdx specialized at k = 0.uList.zipIdx_map}(hjq  hRhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Range.htmlhtheorem List.zipIdx_map {α : Type u_1} {β : Type u_2} {l : List α} {k : Nat} {f : α → β} :
(map f l).zipIdx k = map (Prod.map f id) (l.zipIdx k)h
huList.zipIdx_append}(hju  hRhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Range.htmlhtheorem List.zipIdx_append {α : Type u_1} {xs ys : List α} {k : Nat} :
(xs ++ ys).zipIdx k = xs.zipIdx k ++ ys.zipIdx (k + xs.length)h
huList.zipIdx_eq_cons_iff}(hjy  hRhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Range.htmlhtheorem List.zipIdx_eq_cons_iff {α : Type u_1} {x : α × Nat} {l' : List (α × Nat)} {l : List α} {k : Nat} :
l.zipIdx k = x :: l' ↔ ∃ (a : α), ∃ (as : List α), l = a :: as ∧ x = (a, k) ∧ l' = as.zipIdx (k + 1)h
huList.zipIdx_eq_append_iff}(hj}  hRhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/Range.htmlhX  theorem List.zipIdx_eq_append_iff {α : Type u_1} {l₁ l₂ : List (α × Nat)} {l : List α} {k : Nat} :
l.zipIdx k = l₁ ++ l₂ ↔ ∃ (l₁' : List α), ∃ (l₂' : List α), l = l₁' ++ l₂' ∧ l₁ = l₁'.zipIdx k ∧ l₂ = l₂'.zipIdx (k + l₁'.length)h
hu
List.merge}(hj  hShttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sort/Basic.htmlhsdef List.merge {α : Type u_1} (xs ys : List α) (le : α → α → Bool := by exact fun a b => a ≤ b) :
List αh
XQ  Merges two lists, using le to select the first element of the resulting list if both are non-empty.
If both input lists are sorted according to le, then the resulting list is also sorted according to le. O(|xs| + |ys|).
This implementation is not tail-recursive, but it is replaced at runtime by a proven-equivalent tail-recursive merge.uList.nil_merge}(hj  hShttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sort/Basic.htmlhetheorem List.nil_merge {α : Type u_1} {le : α → α → Bool} (ys : List α) :
[].merge ys le = ysh
huList.merge_right}(hj  hShttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sort/Basic.htmlhgtheorem List.merge_right {α : Type u_1} {le : α → α → Bool} (xs : List α) :
xs.merge [] le = xsh
huList.mergeSort}(hj  hShttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sort/Basic.htmlhtdef List.mergeSort {α : Type u_1} (xs : List α) (le : α → α → Bool := by exact fun a b => a ≤ b) :
List αh
XN  A stable merge sort.
This function is a simplified implementation that's designed to be easy to reason about, rather than for efficiency. In particular, it uses the non-tail-recursive List.merge function and traverses lists unnecessarily.
It is replaced at runtime by an efficient implementation that has been proven to be equivalent.u
List.zipIdxLE}(hj  hShttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sort/Basic.htmlhTdef List.zipIdxLE {α : Type u_1} (le : α → α → Bool) (a b : α × Nat) :
Boolh
XZ  Given an ordering relation le : α → α → Bool, construct the lexicographic ordering on α × Nat. which first compares the first components using le, but if these are equivalent (in the sense le a.2 b.2 && le b.2 a.2) then compares the second components using ≤.
This function is only used in stating the stability properties of mergeSort.uList.rel_of_pairwise_cons}(hj  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Pairwise.htmlhtheorem List.rel_of_pairwise_cons {α✝ : Type u_1} {a : α✝} {l : List α✝} {R : α✝ → α✝ → Prop} (p : Pairwise R (a :: l)) {a' : α✝} :
a' ∈ l → R a a'h
huList.pairwise_and_iff}(hj  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Pairwise.htmlhtheorem List.pairwise_and_iff {α✝ : Type u_1} {R : α✝ → α✝ → Prop} {l : List α✝} {S : α✝ → α✝ → Prop} :
Pairwise (fun (a b : α✝) => R a b ∧ S a b) l ↔ Pairwise R l ∧ Pairwise S lh
huList.pairwise_of_forall}(hj  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Pairwise.htmlhtheorem List.pairwise_of_forall {α : Type u_1} {R : α → α → Prop} {l : List α} (H : ∀ (x y : α), R x y) :
Pairwise R lh
huList.pairwise_singleton}(hj  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Pairwise.htmlhbtheorem List.pairwise_singleton {α : Type u_1} (R : α → α → Prop) (a : α) :
Pairwise R [a]h
huList.pairwise_pair}(hj  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Pairwise.htmlhltheorem List.pairwise_pair {α : Type u_1} {R : α → α → Prop} {a b : α} :
Pairwise R [a, b] ↔ R a bh
huList.pairwise_map}(hj  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Pairwise.htmlhtheorem List.pairwise_map {α : Type u_1} {α✝ : Type u_2} {f : α → α✝} {R : α✝ → α✝ → Prop} {l : List α} :
Pairwise R (map f l) ↔ Pairwise (fun (a b : α) => R (f a) (f b)) lh
huList.pairwise_filterMap}(hj  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Pairwise.htmlhX  theorem List.pairwise_filterMap {β : Type u_1} {α : Type u_2} {R : α → α → Prop} {f : β → Option α} {l : List β} :
Pairwise R (filterMap f l) ↔ Pairwise (fun (a a' : β) => ∀ (b : α), f a = some b → ∀ (b' : α), f a' = some b' → R b b') lh
huList.pairwise_filter}(hj  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Pairwise.htmlhtheorem List.pairwise_filter {α : Type u_1} {R : α → α → Prop} {p : α → Bool} {l : List α} :
Pairwise R (filter p l) ↔ Pairwise (fun (x y : α) => p x = true → p y = true → R x y) lh
huList.pairwise_append}(hj  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Pairwise.htmlhtheorem List.pairwise_append {α : Type u_1} {R : α → α → Prop} {l₁ l₂ : List α} :
Pairwise R (l₁ ++ l₂) ↔ Pairwise R l₁ ∧ Pairwise R l₂ ∧ ∀ (a : α), a ∈ l₁ → ∀ (b : α), b ∈ l₂ → R a bh
huList.pairwise_append_comm}(hj  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Pairwise.htmlhtheorem List.pairwise_append_comm {α : Type u_1} {R : α → α → Prop} (s : ∀ {x y : α}, R x y → R y x) {l₁ l₂ : List α} :
Pairwise R (l₁ ++ l₂) ↔ Pairwise R (l₂ ++ l₁)h
huList.pairwise_middle}(hj  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Pairwise.htmlhtheorem List.pairwise_middle {α : Type u_1} {R : α → α → Prop} (s : ∀ {x y : α}, R x y → R y x) {a : α} {l₁ l₂ : List α} :
Pairwise R (l₁ ++ a :: l₂) ↔ Pairwise R (a :: (l₁ ++ l₂))h
huList.pairwise_flatten}(hj  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Pairwise.htmlhX  theorem List.pairwise_flatten {α : Type u_1} {R : α → α → Prop} {L : List (List α)} :
Pairwise R L.flatten ↔ (∀ (l : List α), l ∈ L → Pairwise R l) ∧ Pairwise (fun (l₁ l₂ : List α) => ∀ (x : α), x ∈ l₁ → ∀ (y : α), y ∈ l₂ → R x y) Lh
huList.pairwise_flatMap}(hj  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Pairwise.htmlhX2  theorem List.pairwise_flatMap {β : Type u_1} {α : Type u_2} {R : β → β → Prop} {l : List α} {f : α → List β} :
Pairwise R (flatMap f l) ↔ (∀ (a : α), a ∈ l → Pairwise R (f a)) ∧ Pairwise (fun (a₁ a₂ : α) => ∀ (x : β), x ∈ f a₁ → ∀ (y : β), y ∈ f a₂ → R x y) lh
huList.pairwise_reverse}(hj  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Pairwise.htmlhtheorem List.pairwise_reverse {α : Type u_1} {R : α → α → Prop} {l : List α} :
Pairwise R l.reverse ↔ Pairwise (fun (a b : α) => R b a) lh
huList.pairwise_replicate}(hj  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Pairwise.htmlhtheorem List.pairwise_replicate {α : Type u_1} {R : α → α → Prop} {n : Nat} {a : α} :
Pairwise R (replicate n a) ↔ n ≤ 1 ∨ R a ah
hu List.pairwise_iff_forall_sublist}(hj  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Pairwise.htmlhtheorem List.pairwise_iff_forall_sublist {α✝ : Type u_1} {l : List α✝} {R : α✝ → α✝ → Prop} :
Pairwise R l ↔ ∀ {a b : α✝}, [a, b].Sublist l → R a bh
huList.pairwise_of_forall_sublist}(hj  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Pairwise.htmlhtheorem List.pairwise_of_forall_sublist {α✝ : Type u_1} {l : List α✝} {R : α✝ → α✝ → Prop} (g : ∀ {a b : α✝}, [a, b].Sublist l → R a b) :
Pairwise R lh
hu List.pairwise_of_forall_mem_list}(hj  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Pairwise.htmlhtheorem List.pairwise_of_forall_mem_list {α : Type u_1} {l : List α} {r : α → α → Prop} (h : ∀ (a : α), a ∈ l → ∀ (b : α), b ∈ l → r a b) :
Pairwise r lh
huList.pairwise_pmap}(hj  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Pairwise.htmlhX;  theorem List.pairwise_pmap {β : Type u_1} {α : Type u_2} {R : α → α → Prop} {p : β → Prop} {f : (b : β) → p b → α} {l : List β} (h : ∀ (x : β), x ∈ l → p x) :
Pairwise R (pmap f l h) ↔ Pairwise (fun (b₁ b₂ : β) => ∀ (h₁ : p b₁) (h₂ : p b₂), R (f b₁ h₁) (f b₂ h₂)) lh
huList.nodup_iff_pairwise_ne}(hj  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Pairwise.htmlhtheorem List.nodup_iff_pairwise_ne {α✝ : Type u_1} {l : List α✝} :
l.Nodup ↔ Pairwise (fun (x1 x2 : α✝) => x1 ≠ x2) lh
huList.nodup_nil}(hj  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Pairwise.htmlh1theorem List.nodup_nil {α : Type u_1} :
[].Noduph
huList.nodup_cons}(hj  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Pairwise.htmlhitheorem List.nodup_cons {α : Type u_1} {a : α} {l : List α} :
(a :: l).Nodup ↔ ¬a ∈ l ∧ l.Noduph
huList.nodup_append}(hj  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Pairwise.htmlhtheorem List.nodup_append {α : Type u_1} {l₁ l₂ : List α} :
(l₁ ++ l₂).Nodup ↔ l₁.Nodup ∧ l₂.Nodup ∧ ∀ (a : α), a ∈ l₁ → ∀ (b : α), b ∈ l₂ → a ≠ bh
huList.getElem?_inj}(hj  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Pairwise.htmlhtheorem List.getElem?_inj {α : Type u_1} {i j : Nat} {xs : List α} (h₀ : i < xs.length) (h₁ : xs.Nodup) (h₂ : xs[i]? = xs[j]?) :
i = jh
huList.nodup_replicate}(hj  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Pairwise.htmlhctheorem List.nodup_replicate {α : Type u_1} {n : Nat} {a : α} :
(replicate n a).Nodup ↔ n ≤ 1h
huList.nodup_iff_count}(hj  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Pairwise.htmlh~theorem List.nodup_iff_count {α : Type u_1} [BEq α] [LawfulBEq α] {l : List α} :
l.Nodup ↔ ∀ (a : α), count a l ≤ 1h
huList.length_take}(hj   hUhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/TakeDrop.htmlhetheorem List.length_take {α : Type u_1} {i : Nat} {l : List α} :
(take i l).length = min i l.lengthh
huList.length_take_le}(hj  hUhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/TakeDrop.htmlh]theorem List.length_take_le {α : Type u_1} (i : Nat) (l : List α) :
(take i l).length ≤ ih
huList.length_take_le'}(hj  hUhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/TakeDrop.htmlhetheorem List.length_take_le' {α : Type u_1} (i : Nat) (l : List α) :
(take i l).length ≤ l.lengthh
huList.length_take_of_le}(hj  hUhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/TakeDrop.htmlhytheorem List.length_take_of_le {i : Nat} {α✝ : Type u_1} {l : List α✝} (h : i ≤ l.length) :
(take i l).length = ih
huList.getElem_take'}(hj  hUhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/TakeDrop.htmlhtheorem List.getElem_take' {α : Type u_1} {xs : List α} {i j : Nat} (hi : i < xs.length) (hj : i < j) :
xs[i] = (take j xs)[i]h
The i-th element of a list coincides with the i-th element of any of its prefixes of length > i. Version designed to rewrite from the big list to the small list.uList.getElem_take}(hj  hUhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/TakeDrop.htmlhztheorem List.getElem_take {α : Type u_1} {xs : List α} {j i : Nat} {h : i < (take j xs).length} :
(take j xs)[i] = xs[i]h
The i-th element of a list coincides with the i-th element of any of its prefixes of length > i. Version designed to rewrite from the small list to the big list.uList.getElem?_take_eq_none}(hj  hUhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/TakeDrop.htmlhrtheorem List.getElem?_take_eq_none {α : Type u_1} {l : List α} {i j : Nat} (h : i ≤ j) :
(take i l)[j]? = noneh
huList.getElem?_take}(hj  hUhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/TakeDrop.htmlhutheorem List.getElem?_take {α : Type u_1} {l : List α} {i j : Nat} :
(take i l)[j]? = if j < i then l[j]? else noneh
huList.head?_take}(hj"  hUhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/TakeDrop.htmlhttheorem List.head?_take {α : Type u_1} {l : List α} {i : Nat} :
(take i l).head? = if i = 0 then none else l.head?h
huList.head_take}(hj&  hUhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/TakeDrop.htmlhutheorem List.head_take {α : Type u_1} {l : List α} {i : Nat} (h : take i l ≠ []) :
(take i l).head h = l.head ⋯h
huList.getLast?_take}(hj*  hUhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/TakeDrop.htmlhtheorem List.getLast?_take {α : Type u_1} {i : Nat} {l : List α} :
(take i l).getLast? = if i = 0 then none else l[i - 1]?.or l.getLast?h
huList.getLast_take}(hj.  hUhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/TakeDrop.htmlhtheorem List.getLast_take {α : Type u_1} {i : Nat} {l : List α} (h : take i l ≠ []) :
(take i l).getLast h = l[i - 1]?.getD (l.getLast ⋯)h
huList.take_take}(hj2  hUhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/TakeDrop.htmlhgtheorem List.take_take {α : Type u_1} {i j : Nat} {l : List α} :
take i (take j l) = take (min i j) lh
huList.take_set_of_le}(hj6  hUhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/TakeDrop.htmlh|theorem List.take_set_of_le {α : Type u_1} {a : α} {i j : Nat} {l : List α} (h : j ≤ i) :
take j (l.set i a) = take j lh
huList.take_set_of_lt}(hj:  hUhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/TakeDrop.htmlh{abbrev List.take_set_of_lt {α : Type u_1} {a : α} {i j : Nat} {l : List α} (h : j ≤ i) :
take j (l.set i a) = take j lh
huList.take_replicate}(hj>  hUhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/TakeDrop.htmlhqtheorem List.take_replicate {α : Type u_1} {a : α} {i n : Nat} :
take i (replicate n a) = replicate (min i n) ah
huList.drop_replicate}(hjB  hUhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/TakeDrop.htmlhotheorem List.drop_replicate {α : Type u_1} {a : α} {i n : Nat} :
drop i (replicate n a) = replicate (n - i) ah
huList.take_append}(hjF  hUhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/TakeDrop.htmlhtheorem List.take_append {α : Type u_1} {l₁ l₂ : List α} {i : Nat} :
take i (l₁ ++ l₂) = take i l₁ ++ take (i - l₁.length) l₂h
Taking the first i elements in l₁ ++ l₂ is the same as appending the first i elements of l₁ to the first n - l₁.length elements of l₂.uList.take_append_eq_append_take}(hjK  hUhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/TakeDrop.htmlhabbrev List.take_append_eq_append_take {α : Type u_1} {l₁ l₂ : List α} {i : Nat} :
take i (l₁ ++ l₂) = take i l₁ ++ take (i - l₁.length) l₂h
huList.take_append_of_le_length}(hjO  hUhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/TakeDrop.htmlhtheorem List.take_append_of_le_length {α : Type u_1} {l₁ l₂ : List α} {i : Nat} (h : i ≤ l₁.length) :
take i (l₁ ++ l₂) = take i l₁h
huList.take_length_add_append}(hjS  hUhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/TakeDrop.htmlhtheorem List.take_length_add_append {α : Type u_1} {l₁ l₂ : List α} (i : Nat) :
take (l₁.length + i) (l₁ ++ l₂) = l₁ ++ take i l₂h
xTaking the first l₁.length + i elements in l₁ ++ l₂ is the same as appending the first i elements of l₂ to l₁.uList.take_eq_take_iff}(hjX  hUhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/TakeDrop.htmlhtheorem List.take_eq_take_iff {α : Type u_1} {l : List α} {i j : Nat} :
take i l = take j l ↔ min i l.length = min j l.lengthh
huList.take_eq_take}(hj\  hUhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/TakeDrop.htmlh|abbrev List.take_eq_take {α : Type u_1} {l : List α} {i j : Nat} :
take i l = take j l ↔ min i l.length = min j l.lengthh
hu
List.take_add}(hj`  hUhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/TakeDrop.htmlhptheorem List.take_add {α : Type u_1} {l : List α} {i j : Nat} :
take (i + j) l = take i l ++ take j (drop i l)h
hu
List.take_one}(hjd  hUhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/TakeDrop.htmlhOtheorem List.take_one {α : Type u_1} {l : List α} :
take 1 l = l.head?.toListh
hu"List.take_eq_append_getElem_of_pos}(hjh  hUhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/TakeDrop.htmlhtheorem List.take_eq_append_getElem_of_pos {α : Type u_1} {i : Nat} {l : List α} (h₁ : 0 < i) (h₂ : i < l.length) :
take i l = take (i - 1) l ++ [l[i - 1]]h
huList.dropLast_take}(hjl  hUhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/TakeDrop.htmlh|theorem List.dropLast_take {α : Type u_1} {i : Nat} {l : List α} (h : i < l.length) :
(take i l).dropLast = take (i - 1) lh
huList.take_eq_dropLast}(hjp  hUhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/TakeDrop.htmlhttheorem List.take_eq_dropLast {α : Type u_1} {l : List α} {i : Nat} (h : i + 1 = l.length) :
take i l = l.dropLasth
huList.take_prefix_take_left}(hjt  hUhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/TakeDrop.htmlhrtheorem List.take_prefix_take_left {α : Type u_1} {l : List α} {i j : Nat} (h : i ≤ j) :
take i l <+: take j lh
huList.take_sublist_take_left}(hjx  hUhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/TakeDrop.htmlh{theorem List.take_sublist_take_left {α : Type u_1} {l : List α} {i j : Nat} (h : i ≤ j) :
(take i l).Sublist (take j l)h
huList.take_subset_take_left}(hj|  hUhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/TakeDrop.htmlhrtheorem List.take_subset_take_left {α : Type u_1} (l : List α) {i j : Nat} (h : i ≤ j) :
take i l ⊆ take j lh
huList.lt_length_drop}(hj  hUhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/TakeDrop.htmlhwtheorem List.lt_length_drop {α : Type u_1} {xs : List α} {i j : Nat} (h : i + j < xs.length) :
j < (drop i xs).lengthh
huList.getElem_drop'}(hj  hUhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/TakeDrop.htmlhztheorem List.getElem_drop' {α : Type u_1} {xs : List α} {i j : Nat} (h : i + j < xs.length) :
xs[i + j] = (drop i xs)[j]h
The i + j-th element of a list coincides with the j-th element of the list obtained by dropping the first i elements. Version designed to rewrite from the big list to the small list.uList.getElem_drop}(hj  hUhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/TakeDrop.htmlh~theorem List.getElem_drop {α : Type u_1} {xs : List α} {i j : Nat} {h : j < (drop i xs).length} :
(drop i xs)[j] = xs[i + j]h
The i + j-th element of a list coincides with the j-th element of the list obtained by dropping the first i elements. Version designed to rewrite from the small list to the big list.uList.getElem?_drop}(hj  hUhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/TakeDrop.htmlhdtheorem List.getElem?_drop {α : Type u_1} {xs : List α} {i j : Nat} :
(drop i xs)[j]? = xs[i + j]?h
huList.mem_take_iff_getElem}(hj  hUhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/TakeDrop.htmlhtheorem List.mem_take_iff_getElem {α : Type u_1} {i : Nat} {l : List α} {a : α} :
a ∈ take i l ↔ ∃ (j : Nat), ∃ (hm : j < min i l.length), l[j] = ah
huList.mem_drop_iff_getElem}(hj  hUhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/TakeDrop.htmlhtheorem List.mem_drop_iff_getElem {α : Type u_1} {i : Nat} {l : List α} {a : α} :
a ∈ drop i l ↔ ∃ (j : Nat), ∃ (hm : j + i < l.length), l[i + j] = ah
huList.head?_drop}(hj  hUhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/TakeDrop.htmlhZtheorem List.head?_drop {α : Type u_1} {l : List α} {i : Nat} :
(drop i l).head? = l[i]?h
huList.head_drop}(hj  hUhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/TakeDrop.htmlhotheorem List.head_drop {α : Type u_1} {l : List α} {i : Nat} (h : drop i l ≠ []) :
(drop i l).head h = l[i]h
huList.getLast?_drop}(hj  hUhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/TakeDrop.htmlhtheorem List.getLast?_drop {α : Type u_1} {i : Nat} {l : List α} :
(drop i l).getLast? = if l.length ≤ i then none else l.getLast?h
huList.getLast_drop}(hj  hUhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/TakeDrop.htmlh~theorem List.getLast_drop {α : Type u_1} {i : Nat} {l : List α} (h : drop i l ≠ []) :
(drop i l).getLast h = l.getLast ⋯h
huList.drop_length_cons}(hj  hUhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/TakeDrop.htmlh|theorem List.drop_length_cons {α : Type u_1} {l : List α} (h : l ≠ []) (a : α) :
drop l.length (a :: l) = [l.getLast h]h
huList.drop_append}(hj  hUhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/TakeDrop.htmlhtheorem List.drop_append {α : Type u_1} {l₁ l₂ : List α} {i : Nat} :
drop i (l₁ ++ l₂) = drop i l₁ ++ drop (i - l₁.length) l₂h
Dropping the elements up to i in l₁ ++ l₂ is the same as dropping the elements up to i in l₁, dropping the elements up to i - l₁.length in l₂, and appending them.uList.drop_append_eq_append_drop}(hj  hUhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/TakeDrop.htmlhabbrev List.drop_append_eq_append_drop {α : Type u_1} {l₁ l₂ : List α} {i : Nat} :
drop i (l₁ ++ l₂) = drop i l₁ ++ drop (i - l₁.length) l₂h
huList.drop_append_of_le_length}(hj  hUhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/TakeDrop.htmlhtheorem List.drop_append_of_le_length {α : Type u_1} {l₁ l₂ : List α} {i : Nat} (h : i ≤ l₁.length) :
drop i (l₁ ++ l₂) = drop i l₁ ++ l₂h
huList.drop_length_add_append}(hj  hUhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/TakeDrop.htmlhtheorem List.drop_length_add_append {α : Type u_1} {l₁ l₂ : List α} (i : Nat) :
drop (l₁.length + i) (l₁ ++ l₂) = drop i l₂h
pDropping the elements up to l₁.length + i in l₁ + l₂ is the same as dropping the elements up to i in l₂.u!List.set_eq_take_append_cons_drop}(hj  hUhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/TakeDrop.htmlhtheorem List.set_eq_take_append_cons_drop {α : Type u_1} {l : List α} {i : Nat} {a : α} :
l.set i a = if i < l.length then take i l ++ a :: drop (i + 1) l else lh
huList.drop_set_of_lt}(hj  hUhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/TakeDrop.htmlh|theorem List.drop_set_of_lt {α : Type u_1} {a : α} {i j : Nat} {l : List α} (hnm : i < j) :
drop j (l.set i a) = drop j lh
huList.drop_take}(hj  hUhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/TakeDrop.htmlhntheorem List.drop_take {α : Type u_1} {i j : Nat} {l : List α} :
drop i (take j l) = take (j - i) (drop i l)h
huList.drop_take_self}(hj  hUhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/TakeDrop.htmlhbtheorem List.drop_take_self {i : Nat} {α✝ : Type u_1} {l : List α✝} :
drop i (take i l) = []h
huList.take_reverse}(hj  hUhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/TakeDrop.htmlhztheorem List.take_reverse {α : Type u_1} {xs : List α} {i : Nat} :
take i xs.reverse = (drop (xs.length - i) xs).reverseh
huList.drop_reverse}(hj  hUhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/TakeDrop.htmlhztheorem List.drop_reverse {α : Type u_1} {xs : List α} {i : Nat} :
drop i xs.reverse = (take (xs.length - i) xs).reverseh
huList.reverse_take}(hj  hUhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/TakeDrop.htmlhvtheorem List.reverse_take {α : Type u_1} {l : List α} {i : Nat} :
(take i l).reverse = drop (l.length - i) l.reverseh
huList.reverse_drop}(hj  hUhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/TakeDrop.htmlhvtheorem List.reverse_drop {α : Type u_1} {l : List α} {i : Nat} :
(drop i l).reverse = take (l.length - i) l.reverseh
huList.take_add_one}(hj  hUhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/TakeDrop.htmlhmtheorem List.take_add_one {α : Type u_1} {l : List α} {i : Nat} :
take (i + 1) l = take i l ++ l[i]?.toListh
hu#List.drop_eq_getElem?_toList_append}(hj  hUhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/TakeDrop.htmlhtheorem List.drop_eq_getElem?_toList_append {α : Type u_1} {l : List α} {i : Nat} :
drop i l = l[i]?.toList ++ drop (i + 1) lh
huList.drop_sub_one}(hj  hUhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/TakeDrop.htmlh}theorem List.drop_sub_one {α : Type u_1} {l : List α} {i : Nat} (h : 0 < i) :
drop (i - 1) l = l[i - 1]?.toList ++ drop i lh
huList.false_of_mem_take_findIdx}(hj  hUhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/TakeDrop.htmlhtheorem List.false_of_mem_take_findIdx {α : Type u_1} {x : α} {xs : List α} {p : α → Bool} (h : x ∈ take (findIdx p xs) xs) :
p x = falseh
huList.findIdx_take}(hj  hUhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/TakeDrop.htmlhtheorem List.findIdx_take {α : Type u_1} {xs : List α} {i : Nat} {p : α → Bool} :
findIdx p (take i xs) = min i (findIdx p xs)h
huList.min_findIdx_findIdx}(hj  hUhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/TakeDrop.htmlhtheorem List.min_findIdx_findIdx {α : Type u_1} {xs : List α} {p q : α → Bool} :
min (findIdx p xs) (findIdx q xs) = findIdx (fun (a : α) => p a || q a) xsh
huList.findIdx?_take}(hj  hUhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/TakeDrop.htmlhtheorem List.findIdx?_take {α : Type u_1} {xs : List α} {i : Nat} {p : α → Bool} :
findIdx? p (take i xs) = (findIdx? p xs).bind (Option.guard fun (j : Nat) => decide (j < i))h
hu"List.takeWhile_eq_take_findIdx_not}(hj  hUhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/TakeDrop.htmlhtheorem List.takeWhile_eq_take_findIdx_not {α : Type u_1} {xs : List α} {p : α → Bool} :
takeWhile p xs = take (findIdx (fun (a : α) => !p a) xs) xsh
hu"List.dropWhile_eq_drop_findIdx_not}(hj   hUhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/TakeDrop.htmlhtheorem List.dropWhile_eq_drop_findIdx_not {α : Type u_1} {xs : List α} {p : α → Bool} :
dropWhile p xs = drop (findIdx (fun (a : α) => !p a) xs) xsh
huList.rotateLeft_replicate}(hj  hUhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/TakeDrop.htmlhutheorem List.rotateLeft_replicate {α : Type u_1} {m n : Nat} {a : α} :
(replicate m a).rotateLeft n = replicate m ah
huList.rotateRight_replicate}(hj  hUhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/TakeDrop.htmlhwtheorem List.rotateRight_replicate {α : Type u_1} {m n : Nat} {a : α} :
(replicate m a).rotateRight n = replicate m ah
huList.length_zipWith}(hj  hUhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/TakeDrop.htmlhtheorem List.length_zipWith {α : Type u_1} {β : Type u_2} {γ : Type u_3} {f : α → β → γ} {l₁ : List α} {l₂ : List β} :
(zipWith f l₁ l₂).length = min l₁.length l₂.lengthh
huList.lt_length_left_of_zipWith}(hj  hUhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/TakeDrop.htmlhtheorem List.lt_length_left_of_zipWith {α : Type u_1} {β : Type u_2} {γ : Type u_3} {f : α → β → γ} {i : Nat} {l : List α} {l' : List β} (h : i < (zipWith f l l').length) :
i < l.lengthh
huList.lt_length_right_of_zipWith}(hj  hUhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/TakeDrop.htmlhtheorem List.lt_length_right_of_zipWith {α : Type u_1} {β : Type u_2} {γ : Type u_3} {f : α → β → γ} {i : Nat} {l : List α} {l' : List β} (h : i < (zipWith f l l').length) :
i < l'.lengthh
huList.getElem_zipWith}(hj  hUhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/TakeDrop.htmlhtheorem List.getElem_zipWith {α : Type u_1} {β : Type u_2} {γ : Type u_3} {f : α → β → γ} {l : List α} {l' : List β} {i : Nat} {h : i < (zipWith f l l').length} :
(zipWith f l l')[i] = f l[i] l'[i]h
hu List.zipWith_eq_zipWith_take_min}(hj  hUhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/TakeDrop.htmlhX
  theorem List.zipWith_eq_zipWith_take_min {α : Type u_1} {β : Type u_2} {α✝ : Type u_3} {f : α → β → α✝} {l₁ : List α} {l₂ : List β} :
zipWith f l₁ l₂ = zipWith f (take (min l₁.length l₂.length) l₁) (take (min l₁.length l₂.length) l₂)h
huList.reverse_zipWith}(hj   hUhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/TakeDrop.htmlhtheorem List.reverse_zipWith {α✝ : Type u_1} {α✝¹ : Type u_2} {α✝² : Type u_3} {f : α✝ → α✝¹ → α✝²} {l : List α✝} {l' : List α✝¹} (h : l.length = l'.length) :
(zipWith f l l').reverse = zipWith f l.reverse l'.reverseh
huList.zipWith_replicate}(hj$  hUhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/TakeDrop.htmlhtheorem List.zipWith_replicate {α : Type u_1} {β : Type u_2} {α✝ : Type u_3} {f : α → β → α✝} {a : α} {b : β} {m n : Nat} :
zipWith f (replicate m a) (replicate n b) = replicate (min m n) (f a b)h
huList.length_zip}(hj(  hUhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/TakeDrop.htmlhtheorem List.length_zip {α : Type u_1} {β : Type u_2} {l₁ : List α} {l₂ : List β} :
(l₁.zip l₂).length = min l₁.length l₂.lengthh
huList.lt_length_left_of_zip}(hj,  hUhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/TakeDrop.htmlhtheorem List.lt_length_left_of_zip {α : Type u_1} {β : Type u_2} {i : Nat} {l : List α} {l' : List β} (h : i < (l.zip l').length) :
i < l.lengthh
huList.lt_length_right_of_zip}(hj0  hUhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/TakeDrop.htmlhtheorem List.lt_length_right_of_zip {α : Type u_1} {β : Type u_2} {i : Nat} {l : List α} {l' : List β} (h : i < (l.zip l').length) :
i < l'.lengthh
huList.getElem_zip}(hj4  hUhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/TakeDrop.htmlhtheorem List.getElem_zip {α : Type u_1} {β : Type u_2} {l : List α} {l' : List β} {i : Nat} {h : i < (l.zip l').length} :
(l.zip l')[i] = (l[i], l'[i])h
huList.zip_eq_zip_take_min}(hj8  hUhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/TakeDrop.htmlhtheorem List.zip_eq_zip_take_min {α : Type u_1} {β : Type u_2} {l₁ : List α} {l₂ : List β} :
l₁.zip l₂ = (take (min l₁.length l₂.length) l₁).zip (take (min l₁.length l₂.length) l₂)h
huList.zip_replicate}(hj<  hUhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Nat/TakeDrop.htmlhtheorem List.zip_replicate {α : Type u_1} {β : Type u_2} {a : α} {b : β} {m n : Nat} :
(replicate m a).zip (replicate n b) = replicate (min m n) (a, b)h
huList.length_range'}(hj@  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Range.htmlhJtheorem List.length_range' {s step n : Nat} :
(range' s n step).length = nh
huList.range'_eq_nil_iff}(hjD  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Range.htmlhPtheorem List.range'_eq_nil_iff {s n step : Nat} :
range' s n step = [] ↔ n = 0h
huList.range'_ne_nil_iff}(hjH  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Range.htmlh\theorem List.range'_ne_nil_iff (s : Nat) {n step : Nat} :
range' s n step ≠ [] ↔ n ≠ 0h
huList.range'_eq_cons_iff}(hjL  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Range.htmlhtheorem List.range'_eq_cons_iff {s n step a : Nat} {xs : List Nat} :
range' s n step = a :: xs ↔ s = a ∧ 0 < n ∧ xs = range' (a + step) (n - 1) steph
huList.tail_range'}(hjP  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Range.htmlhctheorem List.tail_range' {s n step : Nat} :
(range' s n step).tail = range' (s + step) (n - 1) steph
huList.range'_inj}(hjT  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Range.htmlhgtheorem List.range'_inj {s n s' n' : Nat} :
range' s n = range' s' n' ↔ n = n' ∧ (n = 0 ∨ s = s')h
huList.mem_range'}(hjX  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Range.htmlhptheorem List.mem_range' {s step m n : Nat} :
m ∈ range' s n step ↔ ∃ (i : Nat), i < n ∧ m = s + step * ih
huList.getElem?_range'}(hj\  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Range.htmlhgtheorem List.getElem?_range' {s step i n : Nat} :
i < n → (range' s n step)[i]? = some (s + step * i)h
huList.getElem_range'}(hj`  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Range.htmlhwtheorem List.getElem_range' {n m step i : Nat} (H : i < (range' n m step).length) :
(range' n m step)[i] = n + step * ih
huList.head?_range'}(hjd  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Range.htmlh[theorem List.head?_range' {s n : Nat} :
(range' s n).head? = if n = 0 then none else some sh
huList.head_range'}(hjh  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Range.htmlhVtheorem List.head_range' {s n : Nat} (h : range' s n ≠ []) :
(range' s n).head h = sh
huList.map_add_range'}(hjl  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Range.htmlhtheorem List.map_add_range' {a : Nat} (s n step : Nat) :
map (fun (x : Nat) => a + x) (range' s n step) = range' (a + s) n steph
huList.range'_succ_left}(hjp  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Range.htmlhwtheorem List.range'_succ_left {s n step : Nat} :
range' (s + 1) n step = map (fun (x : Nat) => x + 1) (range' s n step)h
huList.range'_append}(hjt  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Range.htmlhwtheorem List.range'_append {s m n step : Nat} :
range' s m step ++ range' (s + step * m) n step = range' s (m + n) steph
huList.range'_append_1}(hjx  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Range.htmlh^theorem List.range'_append_1 {s m n : Nat} :
range' s m ++ range' (s + m) n = range' s (m + n)h
huList.range'_sublist_right}(hj|  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Range.htmlhntheorem List.range'_sublist_right {step s m n : Nat} :
(range' s m step).Sublist (range' s n step) ↔ m ≤ nh
huList.range'_subset_right}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Range.htmlhxtheorem List.range'_subset_right {step s m n : Nat} (step0 : 0 < step) :
range' s m step ⊆ range' s n step ↔ m ≤ nh
huList.range'_subset_right_1}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Range.htmlhXtheorem List.range'_subset_right_1 {s m n : Nat} :
range' s m ⊆ range' s n ↔ m ≤ nh
huList.range'_concat}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Range.htmlhgtheorem List.range'_concat {step s n : Nat} :
range' s (n + 1) step = range' s n step ++ [s + step * n]h
huList.range'_1_concat}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Range.htmlhStheorem List.range'_1_concat {s n : Nat} :
range' s (n + 1) = range' s n ++ [s + n]h
huList.range_one}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Range.htmlh&theorem List.range_one :
range 1 = [0]h
huList.range_loop_range'}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Range.htmlhYtheorem List.range_loop_range' (s n : Nat) :
range.loop s (range' s n) = range' 0 (n + s)h
huList.range_eq_range'}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Range.htmlh=theorem List.range_eq_range' {n : Nat} :
range n = range' 0 nh
huList.getElem?_range}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Range.htmlhLtheorem List.getElem?_range {i n : Nat} (h : i < n) :
(range n)[i]? = some ih
huList.getElem_range}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Range.htmlhTtheorem List.getElem_range {j n : Nat} (h : j < (range n).length) :
(range n)[j] = jh
huList.range_succ_eq_map}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Range.htmlhVtheorem List.range_succ_eq_map {n : Nat} :
range (n + 1) = 0 :: map Nat.succ (range n)h
huList.range'_eq_map_range}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Range.htmlhbtheorem List.range'_eq_map_range {s n : Nat} :
range' s n = map (fun (x : Nat) => s + x) (range n)h
huList.length_range}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Range.htmlh:theorem List.length_range {n : Nat} :
(range n).length = nh
huList.range_eq_nil}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Range.htmlh<theorem List.range_eq_nil {n : Nat} :
range n = [] ↔ n = 0h
huList.range_ne_nil}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Range.htmlh@theorem List.range_ne_nil {n : Nat} :
range n ≠ [] ↔ n ≠ 0h
huList.tail_range}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Range.htmlhEtheorem List.tail_range {n : Nat} :
(range n).tail = range' 1 (n - 1)h
huList.range_sublist}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Range.htmlhPtheorem List.range_sublist {m n : Nat} :
(range m).Sublist (range n) ↔ m ≤ nh
huList.range_subset}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Range.htmlhGtheorem List.range_subset {m n : Nat} :
range m ⊆ range n ↔ m ≤ nh
huList.range_succ}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Range.htmlhAtheorem List.range_succ {n : Nat} :
range n.succ = range n ++ [n]h
huList.range_add}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Range.htmlhftheorem List.range_add {n m : Nat} :
range (n + m) = range n ++ map (fun (x : Nat) => n + x) (range m)h
huList.head?_range}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Range.htmlhUtheorem List.head?_range {n : Nat} :
(range n).head? = if n = 0 then none else some 0h
huList.head_range}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Range.htmlhMtheorem List.head_range {n : Nat} (h : range n ≠ []) :
(range n).head h = 0h
huList.getLast?_range}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Range.htmlhatheorem List.getLast?_range {n : Nat} :
(range n).getLast? = if n = 0 then none else some (n - 1)h
huList.getLast_range}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Range.htmlhWtheorem List.getLast_range {n : Nat} (h : range n ≠ []) :
(range n).getLast h = n - 1h
huList.zipIdx_eq_nil_iff}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Range.htmlhctheorem List.zipIdx_eq_nil_iff {α : Type u_1} {l : List α} {i : Nat} :
l.zipIdx i = [] ↔ l = []h
huList.length_zipIdx}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Range.htmlhctheorem List.length_zipIdx {α : Type u_1} {l : List α} {i : Nat} :
(l.zipIdx i).length = l.lengthh
huList.getElem?_zipIdx}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Range.htmlhtheorem List.getElem?_zipIdx {α : Type u_1} {l : List α} {i j : Nat} :
(l.zipIdx i)[j]? = Option.map (fun (a : α) => (a, i + j)) l[j]?h
huList.getElem_zipIdx}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Range.htmlhtheorem List.getElem_zipIdx {α : Type u_1} {i j : Nat} {l : List α} (h : i < (l.zipIdx j).length) :
(l.zipIdx j)[i] = (l[i], j + i)h
huList.tail_zipIdx}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Range.htmlhltheorem List.tail_zipIdx {α : Type u_1} {l : List α} {i : Nat} :
(l.zipIdx i).tail = l.tail.zipIdx (i + 1)h
hu!List.map_snd_add_zipIdx_eq_zipIdx}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Range.htmlhtheorem List.map_snd_add_zipIdx_eq_zipIdx {α : Type u_1} {l : List α} {n k : Nat} :
map (Prod.map id fun (x : Nat) => x + n) (l.zipIdx k) = l.zipIdx (n + k)h
huList.zipIdx_cons'}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Range.htmlhtheorem List.zipIdx_cons' {α : Type u_1} {i : Nat} {x : α} {xs : List α} :
(x :: xs).zipIdx i = (x, i) :: map (Prod.map id fun (x : Nat) => x + 1) (xs.zipIdx i)h
huList.zipIdx_map_snd}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Range.htmlhstheorem List.zipIdx_map_snd {α : Type u_1} (i : Nat) (l : List α) :
map Prod.snd (l.zipIdx i) = range' i l.lengthh
huList.zipIdx_map_fst}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Range.htmlhctheorem List.zipIdx_map_fst {α : Type u_1} (i : Nat) (l : List α) :
map Prod.fst (l.zipIdx i) = lh
huList.zipIdx_eq_zip_range'}(hj   hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Range.htmlhrtheorem List.zipIdx_eq_zip_range' {α : Type u_1} {l : List α} {i : Nat} :
l.zipIdx i = l.zip (range' i l.length)h
huList.unzip_zipIdx_eq_prod}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Range.htmlhwtheorem List.unzip_zipIdx_eq_prod {α : Type u_1} {l : List α} {i : Nat} :
(l.zipIdx i).unzip = (l, range' i l.length)h
huList.zipIdx_succ}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Range.htmlhtheorem List.zipIdx_succ {α : Type u_1} {l : List α} {i : Nat} :
l.zipIdx (i + 1) = map
    (fun (x : α × Nat) =>
      match x with
      | (a, i) => (a, i + 1))
    (l.zipIdx i)h
vReplace zipIdx with a starting index n+1 with zipIdx starting from n, followed by a map increasing the indices by one.uList.zipIdx_eq_map_add}(hj
  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Range.htmlhtheorem List.zipIdx_eq_map_add {α : Type u_1} {l : List α} {i : Nat} :
l.zipIdx i = map
    (fun (x : α × Nat) =>
      match x with
      | (a, j) => (a, i + j))
    l.zipIdxh
kReplace zipIdx with a starting index with zipIdx starting from 0, followed by a map increasing the indices.uList.instTransPerm}(hj  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Perm.htmlhBinstance List.instTransPerm {α : Type u_1} :
Trans Perm Perm Permh
huList.perm_comm}(hj  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Perm.htmlh`theorem List.perm_comm {α : Type u_1} {l₁ l₂ : List α} :
l₁.Perm l₂ ↔ l₂.Perm l₁h
hu
List.isSetoid}(hj  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Perm.htmlh9instance List.isSetoid (α : Type u_1) :
Setoid (List α)h
huList.perm_middle}(hj  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Perm.htmlhxtheorem List.perm_middle {α : Type u_1} {a : α} {l₁ l₂ : List α} :
(l₁ ++ a :: l₂).Perm (a :: (l₁ ++ l₂))h
huList.perm_append_singleton}(hj"  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Perm.htmlhdtheorem List.perm_append_singleton {α : Type u_1} (a : α) (l : List α) :
(l ++ [a]).Perm (a :: l)h
huList.perm_append_comm}(hj&  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Perm.htmlhhtheorem List.perm_append_comm {α : Type u_1} {l₁ l₂ : List α} :
(l₁ ++ l₂).Perm (l₂ ++ l₁)h
huList.perm_append_comm_assoc}(hj*  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Perm.htmlhtheorem List.perm_append_comm_assoc {α : Type u_1} (l₁ l₂ l₃ : List α) :
(l₁ ++ (l₂ ++ l₃)).Perm (l₂ ++ (l₁ ++ l₃))h
huList.concat_perm}(hj.  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Perm.htmlh\theorem List.concat_perm {α : Type u_1} (l : List α) (a : α) :
(l.concat a).Perm (a :: l)h
hu
List.perm_nil}(hj2  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Perm.htmlhStheorem List.perm_nil {α : Type u_1} {l₁ : List α} :
l₁.Perm [] ↔ l₁ = []h
hu
List.nil_perm}(hj6  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Perm.htmlhStheorem List.nil_perm {α : Type u_1} {l₁ : List α} :
[].Perm l₁ ↔ l₁ = []h
huList.not_perm_nil_cons}(hj:  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Perm.htmlhZtheorem List.not_perm_nil_cons {α : Type u_1} (x : α) (l : List α) :
¬[].Perm (x :: l)h
huList.not_perm_cons_nil}(hj>  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Perm.htmlhZtheorem List.not_perm_cons_nil {α : Type u_1} {l : List α} {a : α} :
¬(a :: l).Perm []h
huList.reverse_perm}(hjB  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Perm.htmlhJtheorem List.reverse_perm {α : Type u_1} (l : List α) :
l.reverse.Perm lh
huList.perm_cons_append_cons}(hjF  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Perm.htmlhtheorem List.perm_cons_append_cons {α : Type u_1} {l l₁ l₂ : List α} (a : α) (p : l.Perm (l₁ ++ l₂)) :
(a :: l).Perm (l₁ ++ a :: l₂)h
huList.perm_replicate}(hjJ  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Perm.htmlh{theorem List.perm_replicate {α : Type u_1} {n : Nat} {a : α} {l : List α} :
l.Perm (replicate n a) ↔ l = replicate n ah
huList.replicate_perm}(hjN  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Perm.htmlV      h{theorem List.replicate_perm {α : Type u_1} {n : Nat} {a : α} {l : List α} :
(replicate n a).Perm l ↔ replicate n a = lh
huList.perm_singleton}(hjR  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Perm.htmlh[theorem List.perm_singleton {α : Type u_1} {a : α} {l : List α} :
l.Perm [a] ↔ l = [a]h
huList.singleton_perm}(hjV  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Perm.htmlh[theorem List.singleton_perm {α : Type u_1} {a : α} {l : List α} :
[a].Perm l ↔ [a] = lh
huList.singleton_perm_singleton}(hjZ  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Perm.htmlhYtheorem List.singleton_perm_singleton {α : Type u_1} {a b : α} :
[a].Perm [b] ↔ a = bh
huList.perm_cons_erase}(hj^  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Perm.htmlhtheorem List.perm_cons_erase {α : Type u_1} [BEq α] [LawfulBEq α] {a : α} {l : List α} (h : a ∈ l) :
l.Perm (a :: l.erase a)h
huList.filter_append_perm}(hjb  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Perm.htmlhtheorem List.filter_append_perm {α : Type u_1} (p : α → Bool) (l : List α) :
(filter p l ++ filter (fun (x : α) => !p x) l).Perm lh
huList.exists_perm_sublist}(hjf  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Perm.htmlhtheorem List.exists_perm_sublist {α : Type u_1} {l₁ l₂ l₂' : List α} (s : l₁.Sublist l₂) (p : l₂.Perm l₂') :
∃ (l₁' : List α), l₁'.Perm l₁ ∧ l₁'.Sublist l₂'h
hu List.countP_eq_countP_filter_add}(hjj  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Perm.htmlhtheorem List.countP_eq_countP_filter_add {α : Type u_1} (l : List α) (p q : α → Bool) :
countP p l = countP p (filter q l) + countP p (filter (fun (a : α) => !q a) l)h
huList.perm_inv_core}(hjn  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Perm.htmlhtheorem List.perm_inv_core {α : Type u_1} {a : α} {l₁ l₂ r₁ r₂ : List α} :
(l₁ ++ a :: r₁).Perm (l₂ ++ a :: r₂) → (l₁ ++ r₁).Perm (l₂ ++ r₂)h
0Lemma used to destruct perms element by element.uList.perm_cons}(hjs  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Perm.htmlhwtheorem List.perm_cons {α : Type u_1} (a : α) {l₁ l₂ : List α} :
(a :: l₁).Perm (a :: l₂) ↔ l₁.Perm l₂h
huList.perm_append_left_iff}(hjw  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Perm.htmlhtheorem List.perm_append_left_iff {α : Type u_1} {l₁ l₂ : List α} (l : List α) :
(l ++ l₁).Perm (l ++ l₂) ↔ l₁.Perm l₂h
huList.perm_append_right_iff}(hj{  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Perm.htmlhtheorem List.perm_append_right_iff {α : Type u_1} {l₁ l₂ : List α} (l : List α) :
(l₁ ++ l).Perm (l₂ ++ l) ↔ l₁.Perm l₂h
huList.cons_perm_iff_perm_erase}(hj  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Perm.htmlhtheorem List.cons_perm_iff_perm_erase {α : Type u_1} [BEq α] [LawfulBEq α] {a : α} {l₁ l₂ : List α} :
(a :: l₁).Perm l₂ ↔ a ∈ l₂ ∧ l₁.Perm (l₂.erase a)h
huList.perm_iff_count}(hj  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Perm.htmlhtheorem List.perm_iff_count {α : Type u_1} [BEq α] [LawfulBEq α] {l₁ l₂ : List α} :
l₁.Perm l₂ ↔ ∀ (a : α), count a l₁ = count a l₂h
huList.isPerm_iff}(hj  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Perm.htmlhtheorem List.isPerm_iff {α : Type u_1} [BEq α] [LawfulBEq α] {l₁ l₂ : List α} :
l₁.isPerm l₂ = true ↔ l₁.Perm l₂h
huList.decidablePerm}(hj  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Perm.htmlhoinstance List.decidablePerm {α : Type u_1} [DecidableEq α] (l₁ l₂ : List α) :
Decidable (l₁.Perm l₂)h
huList.perm_insert_swap}(hj  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Perm.htmlhtheorem List.perm_insert_swap {α : Type u_1} [BEq α] [LawfulBEq α] (x y : α) (l : List α) :
(List.insert x (List.insert y l)).Perm (List.insert y (List.insert x l))h
huList.cons_append_cons_perm}(hj  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Perm.htmlhtheorem List.cons_append_cons_perm {α : Type u_1} {a b : α} {as bs : List α} :
(a :: as ++ b :: bs).Perm (b :: as ++ a :: bs)h
huList.perm_insertIdx}(hj  hMhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Perm.htmlhtheorem List.perm_insertIdx {α : Type u_1} (x : α) (l : List α) {i : Nat} (h : i ≤ l.length) :
(l.insertIdx i x).Perm (x :: l)h
huList.toArrayAux}(hj  hThttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/ToArrayImpl.htmlhGdef List.toArrayAux {α : Type u_1} :
List α → Array α → Array αh
MAuxiliary definition for List.toArray. List.toArrayAux as r = r ++ as.toArrayuList.toArrayImpl}(hj  hThttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/ToArrayImpl.htmlh>def List.toArrayImpl {α : Type u_1} (xs : List α) :
Array αh
Converts a List α into an Array α by repeatedly pushing elements from the list onto an empty array. O(|xs|).
Use List.toArray instead of calling this function directly. At runtime, this operation implements both List.toArray and Array.mk.uList.zipIdxLE_trans}(hj  hThttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sort/Lemmas.htmlhtheorem List.zipIdxLE_trans {α : Type u_1} {le : α → α → Bool} (trans : ∀ (a b c : α), le a b = true → le b c = true → le a c = true) (a b c : α × Nat) :
zipIdxLE le a b = true → zipIdxLE le b c = true → zipIdxLE le a c = trueh
huList.zipIdxLE_total}(hj  hThttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sort/Lemmas.htmlhtheorem List.zipIdxLE_total {α : Type u_1} {le : α → α → Bool} (total : ∀ (a b : α), (le a b || le b a) = true) (a b : α × Nat) :
(zipIdxLE le a b || zipIdxLE le b a) = trueh
huList.cons_merge_cons}(hj  hThttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sort/Lemmas.htmlhtheorem List.cons_merge_cons {α : Type u_1} (s : α → α → Bool) (a b : α) (l r : List α) :
(a :: l).merge (b :: r) s = if s a b = true then a :: l.merge (b :: r) s else b :: (a :: l).merge r sh
huList.cons_merge_cons_pos}(hj  hThttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sort/Lemmas.htmlhtheorem List.cons_merge_cons_pos {α : Type u_1} {a b : α} (s : α → α → Bool) (l r : List α) (h : s a b = true) :
(a :: l).merge (b :: r) s = a :: l.merge (b :: r) sh
huList.cons_merge_cons_neg}(hj  hThttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sort/Lemmas.htmlhtheorem List.cons_merge_cons_neg {α : Type u_1} {a b : α} (s : α → α → Bool) (l r : List α) (h : ¬s a b = true) :
(a :: l).merge (b :: r) s = b :: (a :: l).merge r sh
huList.length_merge}(hj  hThttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sort/Lemmas.htmlhtheorem List.length_merge {α : Type u_1} (s : α → α → Bool) (l r : List α) :
(l.merge r s).length = l.length + r.lengthh
huList.mem_merge}(hj  hThttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sort/Lemmas.htmlhtheorem List.mem_merge {α : Type u_1} {le : α → α → Bool} {a : α} {xs ys : List α} :
a ∈ xs.merge ys le ↔ a ∈ xs ∨ a ∈ ysh
EThe elements of merge le xs ys are exactly the elements of xs and ys.uList.mem_merge_left}(hj  hThttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sort/Lemmas.htmlhtheorem List.mem_merge_left {α : Type u_1} {l : List α} {x : α} {r : List α} (s : α → α → Bool) (h : x ∈ l) :
x ∈ l.merge r sh
huList.mem_merge_right}(hj  hThttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sort/Lemmas.htmlhtheorem List.mem_merge_right {α : Type u_1} {r : List α} {x : α} {l : List α} (s : α → α → Bool) (h : x ∈ r) :
x ∈ l.merge r sh
huList.merge_stable}(hj  hThttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sort/Lemmas.htmlhXG  theorem List.merge_stable {α : Type u_1} {le : α → α → Bool} (xs ys : List (α × Nat)) :
(∀ (x y : α × Nat), x ∈ xs → y ∈ ys → x.snd ≤ y.snd) →
  map (fun (x : α × Nat) => x.fst) (xs.merge ys (zipIdxLE le)) =     (map (fun (x : α × Nat) => x.fst) xs).merge (map (fun (x : α × Nat) => x.fst) ys) leh
huList.sorted_merge}(hj  hThttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sort/Lemmas.htmlhX  theorem List.sorted_merge {α : Type u_1} {le : α → α → Bool} (trans : ∀ (a b c : α), le a b = true → le b c = true → le a c = true) (total : ∀ (a b : α), (le a b || le b a) = true) (l₁ l₂ : List α) (h₁ : Pairwise (fun (a b : α) => le a b = true) l₁) (h₂ : Pairwise (fun (a b : α) => le a b = true) l₂) :
Pairwise (fun (a b : α) => le a b = true) (l₁.merge l₂ le)h
If the ordering relation le is transitive and total (i.e. le a b || le b a for all a, b) then the merge of two sorted lists is sorted.uList.merge_of_le}(hj  hThttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sort/Lemmas.htmlhtheorem List.merge_of_le {α : Type u_1} {le : α → α → Bool} {xs ys : List α} :
(∀ (a b : α), a ∈ xs → b ∈ ys → le a b = true) → xs.merge ys le = xs ++ ysh
huList.merge_perm_append}(hj  hThttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sort/Lemmas.htmlh}theorem List.merge_perm_append {α : Type u_1} (le : α → α → Bool) {xs ys : List α} :
(xs.merge ys le).Perm (xs ++ ys)h
huList.mergeSort_nil}(hj  hThttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sort/Lemmas.htmlhbtheorem List.mergeSort_nil {α✝ : Type u_1} {r : α✝ → α✝ → Bool} :
[].mergeSort r = []h
huList.mergeSort_singleton}(hj  hThttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sort/Lemmas.htmlhjtheorem List.mergeSort_singleton {α : Type u_1} {r : α → α → Bool} (a : α) :
[a].mergeSort r = [a]h
huList.mergeSort_perm}(hj  hThttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sort/Lemmas.htmlhmtheorem List.mergeSort_perm {α : Type u_1} (l : List α) (le : α → α → Bool) :
(l.mergeSort le).Perm lh
huList.length_mergeSort}(hj  hThttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sort/Lemmas.htmlhztheorem List.length_mergeSort {α : Type u_1} {le : α → α → Bool} (l : List α) :
(l.mergeSort le).length = l.lengthh
huList.mem_mergeSort}(hj  hThttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sort/Lemmas.htmlh~theorem List.mem_mergeSort {α : Type u_1} {le : α → α → Bool} {a : α} {l : List α} :
a ∈ l.mergeSort le ↔ a ∈ lh
huList.sorted_mergeSort}(hj  hThttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sort/Lemmas.htmlhX  theorem List.sorted_mergeSort {α : Type u_1} {le : α → α → Bool} (trans : ∀ (a b c : α), le a b = true → le b c = true → le a c = true) (total : ∀ (a b : α), (le a b || le b a) = true) (l : List α) :
Pairwise (fun (a b : α) => le a b = true) (l.mergeSort le)h
X  The result of mergeSort is sorted, as long as the comparison function is transitive (le a b → le b c → le a c) and total in the sense that le a b || le b a.
The comparison function need not be irreflexive, i.e. le a b and le b a is allowed even when a ≠ b.uList.mergeSort_of_sorted}(hj  hThttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sort/Lemmas.htmlhtheorem List.mergeSort_of_sorted {α : Type u_1} {le : α → α → Bool} {l : List α} :
Pairwise (fun (a b : α) => le a b = true) l → l.mergeSort le = lh
MIf the input list is already sorted, then mergeSort does not change the list.uList.mergeSort_zipIdx}(hj  hThttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sort/Lemmas.htmlhtheorem List.mergeSort_zipIdx {α : Type u_1} {le : α → α → Bool} {l : List α} :
map (fun (x : α × Nat) => x.fst) (l.zipIdx.mergeSort (zipIdxLE le)) = l.mergeSort leh
X<  This merge sort algorithm is stable, in the sense that breaking ties in the ordering function using the position in the list has no effect on the output.
That is, elements which are equal with respect to the ordering function will remain in the same order in the output list as they were in the input list.
See also:uList.mergeSort_cons}(hj  hThttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sort/Lemmas.htmlhX  theorem List.mergeSort_cons {α : Type u_1} {le : α → α → Bool} (trans : ∀ (a b c : α), le a b = true → le b c = true → le a c = true) (total : ∀ (a b : α), (le a b || le b a) = true) (a : α) (l : List α) :
∃ (l₁ : List α), ∃ (l₂ : List α), (a :: l).mergeSort le = l₁ ++ a :: l₂ ∧ l.mergeSort le = l₁ ++ l₂ ∧ ∀ (b : α), b ∈ l₁ → (!le a b) = trueh
huList.sublist_mergeSort}(hj  hThttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sort/Lemmas.htmlhXK  theorem List.sublist_mergeSort {α : Type u_1} {le : α → α → Bool} {xs : List α} (trans : ∀ (a b c : α), le a b = true → le b c = true → le a c = true) (total : ∀ (a b : α), (le a b || le b a) = true) {ys : List α} :
Pairwise (fun (a b : α) => le a b = true) ys → ys.Sublist xs → ys.Sublist (xs.mergeSort le)h
yAnother statement of stability of merge sort. If c is a sorted sublist of l, then c is still a sublist of mergeSort le l.uList.pair_sublist_mergeSort}(hj  hThttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sort/Lemmas.htmlhX7  theorem List.pair_sublist_mergeSort {α : Type u_1} {le : α → α → Bool} {a b : α} {l : List α} (trans : ∀ (a b c : α), le a b = true → le b c = true → le a c = true) (total : ∀ (a b : α), (le a b || le b a) = true) (hab : le a b = true) (h : [a, b].Sublist l) :
[a, b].Sublist (l.mergeSort le)h
Another statement of stability of merge sort. If a pair [a, b] is a sublist of l and le a b, then [a, b] is still a sublist of mergeSort le l.uList.map_merge}(hj  hThttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sort/Lemmas.htmlhX  theorem List.map_merge {α : Type u_2} {β : Type u_1} {f : α → β} {r : α → α → Bool} {s : β → β → Bool} {l l' : List α} (hl : ∀ (a : α), a ∈ l → ∀ (b : α), b ∈ l' → r a b = s (f a) (f b)) :
map f (l.merge l' r) = (map f l).merge (map f l') sh
huList.map_mergeSort}(hj  hThttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sort/Lemmas.htmlhX  theorem List.map_mergeSort {α : Type u_2} {β : Type u_1} {r : α → α → Bool} {s : β → β → Bool} {f : α → β} {l : List α} (hl : ∀ (a : α), a ∈ l → ∀ (b : α), b ∈ l → r a b = s (f a) (f b)) :
map f (l.mergeSort r) = (map f l).mergeSort sh
huList.take_cons}(hj  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/TakeDrop.htmlh{theorem List.take_cons {α : Type u_1} {i : Nat} {a : α} {l : List α} (h : 0 < i) :
take i (a :: l) = a :: take (i - 1) lh
huList.drop_cons}(hj  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/TakeDrop.htmlhvtheorem List.drop_cons {α : Type u_1} {i : Nat} {a : α} {l : List α} (h : 0 < i) :
drop i (a :: l) = drop (i - 1) lh
hu
List.drop_one}(hj  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/TakeDrop.htmlhGtheorem List.drop_one {α : Type u_1} {l : List α} :
drop 1 l = l.tailh
huList.take_append_drop}(hj   hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/TakeDrop.htmlh`theorem List.take_append_drop {α : Type u_1} (i : Nat) (l : List α) :
take i l ++ drop i l = lh
huList.length_drop}(hj$  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/TakeDrop.htmlhctheorem List.length_drop {α : Type u_1} {i : Nat} {l : List α} :
(drop i l).length = l.length - ih
huList.drop_of_length_le}(hj(  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/TakeDrop.htmlhktheorem List.drop_of_length_le {α : Type u_1} {i : Nat} {l : List α} (h : l.length ≤ i) :
drop i l = []h
huList.length_lt_of_drop_ne_nil}(hj,  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/TakeDrop.htmlhrtheorem List.length_lt_of_drop_ne_nil {α : Type u_1} {l : List α} {i : Nat} (h : drop i l ≠ []) :
i < l.lengthh
huList.take_of_length_le}(hj0  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/TakeDrop.htmlhjtheorem List.take_of_length_le {α : Type u_1} {i : Nat} {l : List α} (h : l.length ≤ i) :
take i l = lh
huList.lt_length_of_take_ne_self}(hj4  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/TakeDrop.htmlhrtheorem List.lt_length_of_take_ne_self {α : Type u_1} {l : List α} {i : Nat} (h : take i l ≠ l) :
i < l.lengthh
huList.drop_length}(hj8  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/TakeDrop.htmlhMtheorem List.drop_length {α : Type u_1} {l : List α} :
drop l.length l = []h
huList.take_length}(hj<  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/TakeDrop.htmlhLtheorem List.take_length {α : Type u_1} {l : List α} :
take l.length l = lh
huList.getElem_cons_drop}(hj@  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/TakeDrop.htmlh}theorem List.getElem_cons_drop {α : Type u_1} {l : List α} {i : Nat} (h : i < l.length) :
l[i] :: drop (i + 1) l = drop i lh
huList.drop_eq_getElem_cons}(hjD  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/TakeDrop.htmlhtheorem List.drop_eq_getElem_cons {α : Type u_1} {i : Nat} {l : List α} (h : i < l.length) :
drop i l = l[i] :: drop (i + 1) lh
huList.getElem?_take_of_lt}(hjH  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/TakeDrop.htmlhotheorem List.getElem?_take_of_lt {α : Type u_1} {l : List α} {i j : Nat} (h : i < j) :
(take j l)[i]? = l[i]?h
huList.getElem?_take_of_succ}(hjL  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/TakeDrop.htmlhitheorem List.getElem?_take_of_succ {α : Type u_1} {l : List α} {i : Nat} :
(take (i + 1) l)[i]? = l[i]?h
huList.drop_drop}(hjP  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/TakeDrop.htmlhetheorem List.drop_drop {α : Type u_1} {i j : Nat} {l : List α} :
drop i (drop j l) = drop (j + i) lh
huList.drop_add_one_eq_tail_drop}(hjT  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/TakeDrop.htmlhqtheorem List.drop_add_one_eq_tail_drop {α : Type u_1} {i : Nat} {l : List α} :
drop (i + 1) l = (drop i l).tailh
huList.take_drop}(hjX  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/TakeDrop.htmlhntheorem List.take_drop {α : Type u_1} {i j : Nat} {l : List α} :
take i (drop j l) = drop j (take (j + i) l)h
huList.tail_drop}(hj\  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/TakeDrop.htmlhatheorem List.tail_drop {α : Type u_1} {l : List α} {i : Nat} :
(drop i l).tail = drop (i + 1) lh
huList.drop_tail}(hj`  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/TakeDrop.htmlh_theorem List.drop_tail {α : Type u_1} {l : List α} {i : Nat} :
drop i l.tail = drop (i + 1) lh
huList.drop_eq_nil_iff}(hjd  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/TakeDrop.htmlhgtheorem List.drop_eq_nil_iff {α : Type u_1} {l : List α} {i : Nat} :
drop i l = [] ↔ l.length ≤ ih
huList.take_eq_nil_iff}(hjh  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/TakeDrop.htmlhitheorem List.take_eq_nil_iff {α : Type u_1} {l : List α} {k : Nat} :
take k l = [] ↔ k = 0 ∨ l = []h
huList.drop_eq_nil_of_eq_nil}(hjl  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/TakeDrop.htmlhhtheorem List.drop_eq_nil_of_eq_nil {α : Type u_1} {as : List α} {i : Nat} :
as = [] → drop i as = []h
huList.ne_nil_of_drop_ne_nil}(hjp  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/TakeDrop.htmlhntheorem List.ne_nil_of_drop_ne_nil {α : Type u_1} {as : List α} {i : Nat} (h : drop i as ≠ []) :
as ≠ []h
huList.take_eq_nil_of_eq_nil}(hjt  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/TakeDrop.htmlhhtheorem List.take_eq_nil_of_eq_nil {α : Type u_1} {as : List α} {i : Nat} :
as = [] → take i as = []h
huList.ne_nil_of_take_ne_nil}(hjx  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/TakeDrop.htmlhntheorem List.ne_nil_of_take_ne_nil {α : Type u_1} {as : List α} {i : Nat} (h : take i as ≠ []) :
as ≠ []h
hu
List.take_set}(hj|  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/TakeDrop.htmlhrtheorem List.take_set {α : Type u_1} {l : List α} {i j : Nat} {a : α} :
take i (l.set j a) = (take i l).set j ah
hu
List.set_take}(hj  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/TakeDrop.htmlhqabbrev List.set_take {α : Type u_1} {l : List α} {i j : Nat} {a : α} :
take i (l.set j a) = (take i l).set j ah
hu
List.drop_set}(hj  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/TakeDrop.htmlhtheorem List.drop_set {α : Type u_1} {l : List α} {i j : Nat} {a : α} :
drop i (l.set j a) = if j < i then drop i l else (drop i l).set (j - i) ah
hu
List.set_drop}(hj  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/TakeDrop.htmlhxtheorem List.set_drop {α : Type u_1} {l : List α} {i j : Nat} {a : α} :
(drop i l).set j a = drop i (l.set (i + j) a)h
huList.take_concat_get}(hj  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/TakeDrop.htmlhtheorem List.take_concat_get {α : Type u_1} {l : List α} {i : Nat} (h : i < l.length) :
(take i l).concat l[i] = take (i + 1) lh
huList.take_append_getElem}(hj  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/TakeDrop.htmlhtheorem List.take_append_getElem {α : Type u_1} {l : List α} {i : Nat} (h : i < l.length) :
take i l ++ [l[i]] = take (i + 1) lh
hu List.take_succ_eq_append_getElem}(hj  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/TakeDrop.htmlhtheorem List.take_succ_eq_append_getElem {α : Type u_1} {i : Nat} {l : List α} (h : i < l.length) :
take (i + 1) l = take i l ++ [l[i]]h
huList.take_append_getLast}(hj  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/TakeDrop.htmlhztheorem List.take_append_getLast {α : Type u_1} (l : List α) (h : l ≠ []) :
take (l.length - 1) l ++ [l.getLast h] = lh
huList.take_append_getLast?}(hj  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/TakeDrop.htmlhptheorem List.take_append_getLast? {α : Type u_1} (l : List α) :
take (l.length - 1) l ++ l.getLast?.toList = lh
huList.drop_left}(hj  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/TakeDrop.htmlhetheorem List.drop_left {α : Type u_1} {l₁ l₂ : List α} :
drop l₁.length (l₁ ++ l₂) = l₂h
huList.drop_left'}(hj  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/TakeDrop.htmlh|theorem List.drop_left' {α : Type u_1} {l₁ l₂ : List α} {i : Nat} (h : l₁.length = i) :
drop i (l₁ ++ l₂) = l₂h
huList.take_left}(hj  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/TakeDrop.htmlhetheorem List.take_left {α : Type u_1} {l₁ l₂ : List α} :
take l₁.length (l₁ ++ l₂) = l₁h
huList.take_left'}(hj  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/TakeDrop.htmlh|theorem List.take_left' {α : Type u_1} {l₁ l₂ : List α} {i : Nat} (h : l₁.length = i) :
take i (l₁ ++ l₂) = l₁h
huList.take_succ}(hj  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/TakeDrop.htmlhjtheorem List.take_succ {α : Type u_1} {l : List α} {i : Nat} :
take (i + 1) l = take i l ++ l[i]?.toListh
huList.dropLast_eq_take}(hj  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/TakeDrop.htmlh`theorem List.dropLast_eq_take {α : Type u_1} {l : List α} :
l.dropLast = take (l.length - 1) lh
hu
List.map_take}(hj  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/TakeDrop.htmlhtheorem List.map_take {α : Type u_1} {β : Type u_2} {f : α → β} {l : List α} {i : Nat} :
map f (take i l) = take i (map f l)h
hu
List.map_drop}(hj  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/TakeDrop.htmlhtheorem List.map_drop {α : Type u_1} {β : Type u_2} {f : α → β} {l : List α} {i : Nat} :
map f (drop i l) = drop i (map f l)h
huList.drop_eq_extract}(hj  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/TakeDrop.htmlh]theorem List.drop_eq_extract {α : Type u_1} {l : List α} {k : Nat} :
drop k l = l.extract kh
huList.takeWhile_cons}(hj  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/TakeDrop.htmlhtheorem List.takeWhile_cons {α : Type u_1} {p : α → Bool} {a : α} {l : List α} :
takeWhile p (a :: l) = if p a = true then a :: takeWhile p l else []h
huList.takeWhile_cons_of_pos}(hj  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/TakeDrop.htmlhtheorem List.takeWhile_cons_of_pos {α : Type u_1} {p : α → Bool} {a : α} {l : List α} (h : p a = true) :
takeWhile p (a :: l) = a :: takeWhile p lh
huList.takeWhile_cons_of_neg}(hj  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/TakeDrop.htmlhtheorem List.takeWhile_cons_of_neg {α : Type u_1} {p : α → Bool} {a : α} {l : List α} (h : ¬p a = true) :
takeWhile p (a :: l) = []h
huList.dropWhile_cons}(hj  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/TakeDrop.htmlhtheorem List.dropWhile_cons {α : Type u_1} {x : α} {xs : List α} {p : α → Bool} :
dropWhile p (x :: xs) = if p x = true then dropWhile p xs else x :: xsh
huList.dropWhile_cons_of_pos}(hj  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/TakeDrop.htmlhtheorem List.dropWhile_cons_of_pos {α : Type u_1} {p : α → Bool} {a : α} {l : List α} (h : p a = true) :
dropWhile p (a :: l) = dropWhile p lh
huList.dropWhile_cons_of_neg}(hj  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/TakeDrop.htmlhtheorem List.dropWhile_cons_of_neg {α : Type u_1} {p : α → Bool} {a : α} {l : List α} (h : ¬p a = true) :
dropWhile p (a :: l) = a :: lh
huList.head?_takeWhile}(hj  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/TakeDrop.htmlh~theorem List.head?_takeWhile {α : Type u_1} {p : α → Bool} {l : List α} :
(takeWhile p l).head? = Option.filter p l.head?h
huList.head_takeWhile}(hj  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/TakeDrop.htmlhtheorem List.head_takeWhile {α : Type u_1} {p : α → Bool} {l : List α} (w : takeWhile p l ≠ []) :
(takeWhile p l).head w = l.head ⋯h
huList.head?_dropWhile_not}(hj  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/TakeDrop.htmlhtheorem List.head?_dropWhile_not {α : Type u_1} (p : α → Bool) (l : List α) :
match (dropWhile p l).head? with
| some x => p x = false
| none => Trueh
huList.head_dropWhile_not}(hj  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/TakeDrop.htmlhtheorem List.head_dropWhile_not {α : Type u_1} (p : α → Bool) {l : List α} (w : dropWhile p l ≠ []) :
p ((dropWhile p l).head w) = falseh
huList.takeWhile_map}(hj  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/TakeDrop.htmlhtheorem List.takeWhile_map {α : Type u_1} {β : Type u_2} {f : α → β} {p : β → Bool} {l : List α} :
takeWhile p (map f l) = map f (takeWhile (p ∘ f) l)h
huList.dropWhile_map}(hj  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/TakeDrop.htmlhtheorem List.dropWhile_map {α : Type u_1} {β : Type u_2} {f : α → β} {p : β → Bool} {l : List α} :
dropWhile p (map f l) = map f (dropWhile (p ∘ f) l)h
huList.takeWhile_filterMap}(hj  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/TakeDrop.htmlhtheorem List.takeWhile_filterMap {α : Type u_1} {β : Type u_2} {f : α → Option β} {p : β → Bool} {l : List α} :
takeWhile p (filterMap f l) = filterMap f (takeWhile (fun (a : α) => Option.all p (f a)) l)h
huList.dropWhile_filterMap}(hj  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/TakeDrop.htmlhtheorem List.dropWhile_filterMap {α : Type u_1} {β : Type u_2} {f : α → Option β} {p : β → Bool} {l : List α} :
dropWhile p (filterMap f l) = filterMap f (dropWhile (fun (a : α) => Option.all p (f a)) l)h
huList.takeWhile_filter}(hj  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/TakeDrop.htmlhtheorem List.takeWhile_filter {α : Type u_1} {p q : α → Bool} {l : List α} :
takeWhile q (filter p l) = filter p (takeWhile (fun (a : α) => !p a || q a) l)h
huList.dropWhile_filter}(hj   hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/TakeDrop.htmlhtheorem List.dropWhile_filter {α : Type u_1} {p q : α → Bool} {l : List α} :
dropWhile q (filter p l) = filter p (dropWhile (fun (a : α) => !p a || q a) l)h
huList.takeWhile_append_dropWhile}(hj  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/TakeDrop.htmlh|theorem List.takeWhile_append_dropWhile {α : Type u_1} {p : α → Bool} {l : List α} :
takeWhile p l ++ dropWhile p l = lh
huList.takeWhile_append}(hj  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/TakeDrop.htmlhtheorem List.takeWhile_append {α : Type u_1} {p : α → Bool} {xs ys : List α} :
takeWhile p (xs ++ ys) = if (takeWhile p xs).length = xs.length then xs ++ takeWhile p ys else takeWhile p xsh
huList.takeWhile_append_of_pos}(hj  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/TakeDrop.htmlhtheorem List.takeWhile_append_of_pos {α : Type u_1} {p : α → Bool} {l₁ l₂ : List α} (h : ∀ (a : α), a ∈ l₁ → p a = true) :
takeWhile p (l₁ ++ l₂) = l₁ ++ takeWhile p l₂h
huList.dropWhile_append}(hj  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/TakeDrop.htmlhtheorem List.dropWhile_append {α : Type u_1} {p : α → Bool} {xs ys : List α} :
dropWhile p (xs ++ ys) = if (dropWhile p xs).isEmpty = true then dropWhile p ys else dropWhile p xs ++ ysh
huList.dropWhile_append_of_pos}(hj  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/TakeDrop.htmlhtheorem List.dropWhile_append_of_pos {α : Type u_1} {p : α → Bool} {l₁ l₂ : List α} (h : ∀ (a : α), a ∈ l₁ → p a = true) :
dropWhile p (l₁ ++ l₂) = dropWhile p l₂h
hu"List.takeWhile_replicate_eq_filter}(hj  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/TakeDrop.htmlhtheorem List.takeWhile_replicate_eq_filter {α : Type u_1} {n : Nat} {a : α} {p : α → Bool} :
takeWhile p (replicate n a) = filter p (replicate n a)h
huList.takeWhile_replicate}(hj  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/TakeDrop.htmlhtheorem List.takeWhile_replicate {α : Type u_1} {n : Nat} {a : α} {p : α → Bool} :
takeWhile p (replicate n a) = if p a = true then replicate n a else []h
hu&List.dropWhile_replicate_eq_filter_not}(hj   hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/TakeDrop.htmlhtheorem List.dropWhile_replicate_eq_filter_not {α : Type u_1} {n : Nat} {a : α} {p : α → Bool} :
dropWhile p (replicate n a) = filter (fun (a : α) => !p a) (replicate n a)h
huList.dropWhile_replicate}(hj$  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/TakeDrop.htmlhtheorem List.dropWhile_replicate {α : Type u_1} {n : Nat} {a : α} {p : α → Bool} :
dropWhile p (replicate n a) = if p a = true then [] else replicate n ah
huList.take_takeWhile}(hj(  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/TakeDrop.htmlhtheorem List.take_takeWhile {α : Type u_1} {i : Nat} {l : List α} {p : α → Bool} :
take i (takeWhile p l) = takeWhile p (take i l)h
huList.all_takeWhile}(hj,  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/TakeDrop.htmlhitheorem List.all_takeWhile {α : Type u_1} {p : α → Bool} {l : List α} :
(takeWhile p l).all p = trueh
huList.any_dropWhile}(hj0  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/TakeDrop.htmlhtheorem List.any_dropWhile {α : Type u_1} {p : α → Bool} {l : List α} :
((dropWhile p l).any fun (x : α) => !p x) = !l.all ph
huList.replace_takeWhile}(hj4  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/TakeDrop.htmlhtheorem List.replace_takeWhile {α : Type u_1} {a b : α} [BEq α] [LawfulBEq α] {l : List α} {p : α → Bool} (h : p a = p b) :
(takeWhile p l).replace a b = takeWhile p (l.replace a b)h
huList.splitAt_eq}(hj8  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/TakeDrop.htmlhdtheorem List.splitAt_eq {α : Type u_1} {i : Nat} {l : List α} :
splitAt i l = (take i l, drop i l)h
huList.rotateLeft_zero}(hj<  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/TakeDrop.htmlhOtheorem List.rotateLeft_zero {α : Type u_1} {l : List α} :
l.rotateLeft 0 = lh
huList.rotateRight_zero}(hj@  hQhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/TakeDrop.htmlhQtheorem List.rotateRight_zero {α : Type u_1} {l : List α} :
l.rotateRight 0 = lh
huList.toArray_inj}(hjD  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/ToArray.htmlhbtheorem List.toArray_inj {α : Type u_1} {as bs : List α} (h : as.toArray = bs.toArray) :
as = bsh
huList.toArray_eq_iff}(hjH  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/ToArray.htmlhotheorem List.toArray_eq_iff {α : Type u_1} {as : List α} {bs : Array α} :
as.toArray = bs ↔ as = bs.toListh
huList.eq_toArray_iff}(hjL  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/ToArray.htmlhotheorem List.eq_toArray_iff {α : Type u_1} {as : Array α} {bs : List α} :
as = bs.toArray ↔ as.toList = bsh
huList.size_toArrayAux}(hjP  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/ToArray.htmlh{theorem List.size_toArrayAux {α : Type u_1} {as : List α} {xs : Array α} :
(as.toArrayAux xs).size = xs.size + as.lengthh
huList.toArray_cons}(hjT  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/ToArray.htmlhgtheorem List.toArray_cons {α : Type u_1} (a : α) (l : List α) :
(a :: l).toArray = #[a] ++ l.toArrayh
huList.push_toArray}(hjX  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/ToArray.htmlhhtheorem List.push_toArray {α : Type u_1} (l : List α) (a : α) :
l.toArray.push a = (l ++ [a]).toArrayh
huList.push_toArray_fun}(hj\  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/ToArray.htmlhqtheorem List.push_toArray_fun {α : Type u_1} (l : List α) :
l.toArray.push = fun (a : α) => (l ++ [a]).toArrayh
@Unapplied variant of push_toArray, useful for monadic reasoning.uList.isEmpty_toArray}(hja  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/ToArray.htmlhZtheorem List.isEmpty_toArray {α : Type u_1} (l : List α) :
l.toArray.isEmpty = l.isEmptyh
huList.toArray_singleton}(hje  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/ToArray.htmlhhtheorem List.toArray_singleton {α : Type u_1} (a : α) :
(List.singleton a).toArray = Array.singleton ah
huList.back!_toArray}(hji  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/ToArray.htmlhftheorem List.back!_toArray {α : Type u_1} [Inhabited α] (l : List α) :
l.toArray.back! = l.getLast!h
huList.back?_toArray}(hjm  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/ToArray.htmlhWtheorem List.back?_toArray {α : Type u_1} (l : List α) :
l.toArray.back? = l.getLast?h
huList.back_toArray}(hjq  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/ToArray.htmlhstheorem List.back_toArray {α : Type u_1} (l : List α) (h : 0 < l.toArray.size) :
l.toArray.back h = l.getLast ⋯h
huList.set_toArray}(hju  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/ToArray.htmlhtheorem List.set_toArray {α : Type u_1} (l : List α) (i : Nat) (a : α) (h : i < l.length) :
l.toArray.set i a h = (l.set i a).toArrayh
huList.forIn'_loop_toArray}(hjy  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/ToArray.htmlhXi  theorem List.forIn'_loop_toArray {m : Type u_1 → Type u_2} {α : Type u_3} {β : Type u_1} [Monad m] (l : List α) (f : (a : α) → a ∈ l.toArray → β → m (ForInStep β)) (i : Nat) (h : i ≤ l.length) (b : β) :
Array.forIn'.loop l.toArray f i h b = forIn' (drop (l.length - i) l) b fun (a : α) (m : a ∈ drop (l.length - i) l) (b : β) => f a ⋯ bh
huList.forIn'_toArray}(hj}  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/ToArray.htmlhX  theorem List.forIn'_toArray {m : Type u_1 → Type u_2} {α : Type u_3} {β : Type u_1} [Monad m] (l : List α) (b : β) (f : (a : α) → a ∈ l.toArray → β → m (ForInStep β)) :
forIn' l.toArray b f = forIn' l b fun (a : α) (m : a ∈ l) (b : β) => f a ⋯ bh
huList.forIn_toArray}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/ToArray.htmlhtheorem List.forIn_toArray {m : Type u_1 → Type u_2} {α : Type u_3} {β : Type u_1} [Monad m] (l : List α) (b : β) (f : α → β → m (ForInStep β)) :
forIn l.toArray b f = forIn l b fh
huList.foldrM_toArray}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/ToArray.htmlhtheorem List.foldrM_toArray {m : Type u_1 → Type u_2} {α : Type u_3} {β : Type u_1} [Monad m] (f : α → β → m β) (init : β) (l : List α) :
Array.foldrM f init l.toArray = foldrM f init lh
huList.foldlM_toArray}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/ToArray.htmlhtheorem List.foldlM_toArray {m : Type u_1 → Type u_2} {β : Type u_1} {α : Type u_3} [Monad m] (f : β → α → m β) (init : β) (l : List α) :
Array.foldlM f init l.toArray = foldlM f init lh
huList.foldr_toArray}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/ToArray.htmlhtheorem List.foldr_toArray {α : Type u_1} {β : Type u_2} (f : α → β → β) (init : β) (l : List α) :
Array.foldr f init l.toArray = foldr f init lh
huList.foldl_toArray}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/ToArray.htmlhtheorem List.foldl_toArray {β : Type u_1} {α : Type u_2} (f : β → α → β) (init : β) (l : List α) :
Array.foldl f init l.toArray = foldl f init lh
huList.foldrM_toArray'}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/ToArray.htmlhtheorem List.foldrM_toArray' {m : Type u_1 → Type u_2} {α : Type u_3} {β : Type u_1} {start : Nat} [Monad m] (f : α → β → m β) (init : β) (l : List α) (h : start = l.toArray.size) :
Array.foldrM f init l.toArray start = foldrM f init lh
GVariant of foldrM_toArray with a side condition for the start argument.uList.foldlM_toArray'}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/ToArray.htmlhtheorem List.foldlM_toArray' {m : Type u_1 → Type u_2} {β : Type u_1} {α : Type u_3} {stop : Nat} [Monad m] (f : β → α → m β) (init : β) (l : List α) (h : stop = l.toArray.size) :
Array.foldlM f init l.toArray 0 stop = foldlM f init lh
FVariant of foldlM_toArray with a side condition for the stop argument.uList.forM_toArray'}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/ToArray.htmlhtheorem List.forM_toArray' {m : Type u_1 → Type u_2} {α : Type u_3} {stop : Nat} [Monad m] (l : List α) (f : α → m PUnit) (h : stop = l.toArray.size) :
Array.forM f l.toArray 0 stop = l.forM fh
DVariant of forM_toArray with a side condition for the stop argument.uList.forM_toArray}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/ToArray.htmlhtheorem List.forM_toArray {m : Type u_1 → Type u_2} {α : Type u_3} [Monad m] (l : List α) (f : α → m PUnit) :
forM l.toArray f = l.forM fh
huList.foldr_toArray'}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/ToArray.htmlhtheorem List.foldr_toArray' {α : Type u_1} {β : Type u_2} {start : Nat} (f : α → β → β) (init : β) (l : List α) (h : start = l.toArray.size) :
Array.foldr f init l.toArray start = foldr f init lh
FVariant of foldr_toArray with a side condition for the start argument.uList.foldl_toArray'}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/ToArray.htmlhtheorem List.foldl_toArray' {β : Type u_1} {α : Type u_2} {stop : Nat} (f : β → α → β) (init : β) (l : List α) (h : stop = l.toArray.size) :
Array.foldl f init l.toArray 0 stop = foldl f init lh
EVariant of foldl_toArray with a side condition for the stop argument.uList.sum_toArray}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/ToArray.htmlhatheorem List.sum_toArray {α : Type u_1} [Add α] [Zero α] (l : List α) :
l.toArray.sum = l.sumh
huList.append_toArray}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/ToArray.htmlhytheorem List.append_toArray {α : Type u_1} (l₁ l₂ : List α) :
l₁.toArray ++ l₂.toArray = (l₁ ++ l₂).toArrayh
huList.push_append_toArray}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/ToArray.htmlhtheorem List.push_append_toArray {α : Type u_1} {as : Array α} {a : α} {bs : List α} :
as.push a ++ bs.toArray = as ++ (a :: bs).toArrayh
huList.findSomeM?_toArray}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/ToArray.htmlhtheorem List.findSomeM?_toArray {m : Type u_1 → Type u_2} {α : Type u_3} {β : Type u_1} [Monad m] [LawfulMonad m] (f : α → m (Option β)) (l : List α) :
Array.findSomeM? f l.toArray = findSomeM? f lh
huList.findSomeRevM?_toArray}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/ToArray.htmlhtheorem List.findSomeRevM?_toArray {m : Type u_1 → Type u_2} {α : Type u_3} {β : Type u_1} [Monad m] [LawfulMonad m] (f : α → m (Option β)) (l : List α) :
Array.findSomeRevM? f l.toArray = findSomeM? f l.reverseh
huList.findRevM?_toArray}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/ToArray.htmlhtheorem List.findRevM?_toArray {m : Type → Type u_1} {α : Type} [Monad m] [LawfulMonad m] (f : α → m Bool) (l : List α) :
Array.findRevM? f l.toArray = findM? f l.reverseh
huList.findM?_toArray}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/ToArray.htmlhtheorem List.findM?_toArray {m : Type → Type u_1} {α : Type} [Monad m] [LawfulMonad m] (f : α → m Bool) (l : List α) :
Array.findM? f l.toArray = findM? f lh
huList.findSome?_toArray}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/ToArray.htmlhtheorem List.findSome?_toArray {α : Type u_1} {β : Type u_2} (f : α → Option β) (l : List α) :
Array.findSome? f l.toArray = findSome? f lh
huList.find?_toArray}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/ToArray.htmlhptheorem List.find?_toArray {α : Type u_1} (f : α → Bool) (l : List α) :
Array.find? f l.toArray = find? f lh
huList.findFinIdx?_toArray}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/ToArray.htmlhtheorem List.findFinIdx?_toArray {α : Type u_1} (p : α → Bool) (l : List α) :
Array.findFinIdx? p l.toArray = findFinIdx? p lh
huList.findIdx?_toArray}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/ToArray.htmlhytheorem List.findIdx?_toArray {α : Type u_1} (p : α → Bool) (l : List α) :
Array.findIdx? p l.toArray = findIdx? p lh
huList.finIdxOf?_toArray}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/ToArray.htmlhvtheorem List.finIdxOf?_toArray {α : Type u_1} [BEq α] (a : α) (l : List α) :
l.toArray.finIdxOf? a = finIdxOf? a lh
huList.idxOf?_toArray}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/ToArray.htmlhmtheorem List.idxOf?_toArray {α : Type u_1} [BEq α] (a : α) (l : List α) :
l.toArray.idxOf? a = idxOf? a lh
huList.findIdx_toArray}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/ToArray.htmlhytheorem List.findIdx_toArray {α : Type u_1} {as : List α} {p : α → Bool} :
Array.findIdx p as.toArray = findIdx p ash
huList.idxOf_toArray}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/ToArray.htmlhstheorem List.idxOf_toArray {α : Type u_1} [BEq α] {as : List α} {a : α} :
Array.idxOf a as.toArray = idxOf a ash
huList.isPrefixOfAux_toArray_succ}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/ToArray.htmlhtheorem List.isPrefixOfAux_toArray_succ {α : Type u_1} [BEq α] (l₁ l₂ : List α) (hle : l₁.length ≤ l₂.length) (i : Nat) :
l₁.toArray.isPrefixOfAux l₂.toArray hle (i + 1) = l₁.tail.toArray.isPrefixOfAux l₂.tail.toArray ⋯ ih
hu List.isPrefixOfAux_toArray_succ'}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/ToArray.htmlhX	  theorem List.isPrefixOfAux_toArray_succ' {α : Type u_1} [BEq α] (l₁ l₂ : List α) (hle : l₁.length ≤ l₂.length) (i : Nat) :
l₁.toArray.isPrefixOfAux l₂.toArray hle (i + 1) = (drop (i + 1) l₁).toArray.isPrefixOfAux (drop (i + 1) l₂).toArray ⋯ 0h
huList.isPrefixOfAux_toArray_zero}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/ToArray.htmlhtheorem List.isPrefixOfAux_toArray_zero {α : Type u_1} [BEq α] (l₁ l₂ : List α) (hle : l₁.length ≤ l₂.length) :
l₁.toArray.isPrefixOfAux l₂.toArray hle 0 = l₁.isPrefixOf l₂h
huList.isPrefixOf_toArray}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/ToArray.htmlhtheorem List.isPrefixOf_toArray {α : Type u_1} [BEq α] (l₁ l₂ : List α) :
l₁.toArray.isPrefixOf l₂.toArray = l₁.isPrefixOf l₂h
huList.zipWithMAux_toArray_succ}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/ToArray.htmlhX,  theorem List.zipWithMAux_toArray_succ {α : Type u_1} {β : Type u_2} {γ : Type u} {m : Type u → Type v} [Monad m] (as : List α) (bs : List β) (f : α → β → m γ) (i : Nat) (xs : Array γ) :
as.toArray.zipWithMAux bs.toArray f (i + 1) xs = as.tail.toArray.zipWithMAux bs.tail.toArray f i xsh
huList.zipWithMAux_toArray_succ'}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/ToArray.htmlhXA  theorem List.zipWithMAux_toArray_succ' {α : Type u_1} {β : Type u_2} {γ : Type u} {m : Type u → Type v} [Monad m] (as : List α) (bs : List β) (f : α → β → m γ) (i : Nat) (xs : Array γ) :
as.toArray.zipWithMAux bs.toArray f (i + 1) xs = (drop (i + 1) as).toArray.zipWithMAux (drop (i + 1) bs).toArray f 0 xsh
huList.zipWithMAux_toArray_zero}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/ToArray.htmlhXB  theorem List.zipWithMAux_toArray_zero {α : Type u_1} {β : Type u_2} {γ : Type u} {m : Type u → Type v} [Monad m] [LawfulMonad m] (f : α → β → m γ) (as : List α) (bs : List β) (xs : Array γ) :
as.toArray.zipWithMAux bs.toArray f 0 xs = do
  let __do_lift ← zipWithM f as bs
  pure (xs ++ __do_lift.toArray)h
huList.zipWith_toArray}(hj
  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/ToArray.htmlhtheorem List.zipWith_toArray {α : Type u_1} {β : Type u_2} {γ : Type u_3} (as : List α) (bs : List β) (f : α → β → γ) :
Array.zipWith f as.toArray bs.toArray = (zipWith f as bs).toArrayh
huList.zip_toArray}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/ToArray.htmlhtheorem List.zip_toArray {α : Type u_1} {β : Type u_2} (as : List α) (bs : List β) :
as.toArray.zip bs.toArray = (as.zip bs).toArrayh
huList.zipWithAll_toArray}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/ToArray.htmlhtheorem List.zipWithAll_toArray {α : Type u_1} {β : Type u_2} {γ : Type u_3} (f : Option α → Option β → γ) (as : List α) (bs : List β) :
Array.zipWithAll f as.toArray bs.toArray = (zipWithAll f as bs).toArrayh
huList.zipWithM_toArray}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/ToArray.htmlhX   theorem List.zipWithM_toArray {α : Type u_1} {β : Type u_2} {γ : Type u} {m : Type u → Type v} [Monad m] [LawfulMonad m] (f : α → β → m γ) (as : List α) (bs : List β) :
Array.zipWithM f as.toArray bs.toArray = do
  let __do_lift ← zipWithM f as bs
  pure __do_lift.toArrayh
huList.toArray_appendList}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/ToArray.htmlhutheorem List.toArray_appendList {α : Type u_1} (l₁ l₂ : List α) :
l₁.toArray ++ l₂ = (l₁ ++ l₂).toArrayh
huList.pop_toArray}(hj  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/ToArray.htmlh[theorem List.pop_toArray {α : Type u_1} (l : List α) :
l.toArray.pop = l.dropLast.toArrayh
huList.takeWhile_toArray}(hj"  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/ToArray.htmlhtheorem List.takeWhile_toArray {α : Type u_1} (p : α → Bool) (l : List α) :
Array.takeWhile p l.toArray = (takeWhile p l).toArrayh
huList.popWhile_toArray}(hj&  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/ToArray.htmlhtheorem List.popWhile_toArray {α : Type u_1} (p : α → Bool) (l : List α) :
Array.popWhile p l.toArray = (dropWhile p l.reverse).reverse.toArrayh
huList.setIfInBounds_toArray}(hj*  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/ToArray.htmlhtheorem List.setIfInBounds_toArray {α : Type u_1} (l : List α) (i : Nat) (a : α) :
l.toArray.setIfInBounds i a = (l.set i a).toArrayh
huList.toArray_replicate}(hj.  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/ToArray.htmlhqtheorem List.toArray_replicate {α : Type u_1} (n : Nat) (v : α) :
(replicate n v).toArray = Array.replicate n vh
huList.flatMap_empty}(hj2  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/ToArray.htmlhltheorem List.flatMap_empty {α : Type u_1} {β : Type u_2} (f : α → Array β) :
Array.flatMap f #[] = #[]h
huList.flatMap_toArray_cons}(hj6  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/ToArray.htmlhtheorem List.flatMap_toArray_cons {α : Type u_1} {β : Type u_2} (f : α → Array β) (a : α) (as : List α) :
Array.flatMap f (a :: as).toArray = f a ++ Array.flatMap f as.toArrayh
huList.flatMap_toArray}(hj:  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/ToArray.htmlhtheorem List.flatMap_toArray {α : Type u_1} {β : Type u_2} (f : α → Array β) (as : List α) :
Array.flatMap f as.toArray = (flatMap (fun (a : α) => (f a).toList) as).toArrayh
huList.swap_toArray}(hj>  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/ToArray.htmlhtheorem List.swap_toArray {α : Type u_1} (l : List α) (i j : Nat) {hi : i < l.toArray.size} {hj : j < l.toArray.size} :
l.toArray.swap i j hi hj = ((l.set i l[j]).set j l[i]).toArrayh
huList.eraseIdx_toArray}(hjB  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/ToArray.htmlhtheorem List.eraseIdx_toArray {α : Type u_1} (l : List α) (i : Nat) (h : i < l.toArray.size) :
l.toArray.eraseIdx i h = (l.eraseIdx i).toArrayh
huList.eraseIdxIfInBounds_toArray}(hjF  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/ToArray.htmlhtheorem List.eraseIdxIfInBounds_toArray {α : Type u_1} (l : List α) (i : Nat) :
l.toArray.eraseIdxIfInBounds i = (l.eraseIdx i).toArrayh
huList.eraseP_toArray}(hjJ  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/ToArray.htmlhztheorem List.eraseP_toArray {α : Type u_1} {as : List α} {p : α → Bool} :
as.toArray.eraseP p = (eraseP p as).toArrayh
huList.erase_toArray}(hjN  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/ToArray.htmlhwtheorem List.erase_toArray {α : Type u_1} [BEq α] {as : List α} {a : α} :
as.toArray.erase a = (as.erase a).toArrayh
huList.insertIdx_toArray}(hjR  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/ToArray.htmlhtheorem List.insertIdx_toArray {α : Type u_1} (l : List α) (i : Nat) (a : α) (h : i ≤ l.toArray.size) :
l.toArray.insertIdx i a h = (l.insertIdx i a).toArrayh
hu List.insertIdxIfInBounds_toArray}(hjV  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/ToArray.htmlhtheorem List.insertIdxIfInBounds_toArray {α : Type u_1} (l : List α) (i : Nat) (a : α) :
l.toArray.insertIdxIfInBounds i a = (l.insertIdx i a).toArrayh
huList.replace_toArray}(hjZ  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/ToArray.htmlhtheorem List.replace_toArray {α : Type u_1} [BEq α] [LawfulBEq α] (l : List α) (a b : α) :
l.toArray.replace a b = (l.replace a b).toArrayh
huList.leftpad_toArray}(hj^  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/ToArray.htmlhtheorem List.leftpad_toArray {α : Type u_1} (n : Nat) (a : α) (l : List α) :
Array.leftpad n a l.toArray = (leftpad n a l).toArrayh
huList.rightpad_toArray}(hjb  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/ToArray.htmlhtheorem List.rightpad_toArray {α : Type u_1} (n : Nat) (a : α) (l : List α) :
Array.rightpad n a l.toArray = (rightpad n a l).toArrayh
huList.length_nil}(hjf  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlh5theorem List.length_nil {α : Type u} :
[].length = 0h
huList.length_singleton}(hjj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhEtheorem List.length_singleton {α : Type u} {a : α} :
[a].length = 1h
huList.length_cons}(hjn  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhatheorem List.length_cons {α : Type u} {a : α} {as : List α} :
(a :: as).length = as.length + 1h
huList.length_set}(hjr  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhitheorem List.length_set {α : Type u} {as : List α} {i : Nat} {a : α} :
(as.set i a).length = as.lengthh
huList.foldl_nil}(hjv  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlh{theorem List.foldl_nil {α✝ : Type u_1} {β✝ : Type u_2} {f : α✝ → β✝ → α✝} {b : α✝} :
foldl f b [] = bh
huList.foldl_cons}(hjz  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhtheorem List.foldl_cons {α : Type u} {β : Type v} {a : α} {l : List α} {f : β → α → β} {b : β} :
foldl f b (a :: l) = foldl f (f b a) lh
huList.length_concat}(hj~  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhgtheorem List.length_concat {α : Type u} {as : List α} {a : α} :
(as.concat a).length = as.length + 1h
huList.of_concat_eq_concat}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhtheorem List.of_concat_eq_concat {α : Type u} {as bs : List α} {a b : α} (h : as.concat a = bs.concat b) :
as = bs ∧ a = bh
huList.beq}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhBdef List.beq {α : Type u} [BEq α] :
List α → List α → Boolh
uChecks whether two lists have the same length and their elements are pairwise BEq. Normally used via the == operator.uList.beq_nil_nil}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhBtheorem List.beq_nil_nil {α : Type u} [BEq α] :
[].beq [] = trueh
huList.beq_cons_nil}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhctheorem List.beq_cons_nil {α : Type u} [BEq α] {a : α} {as : List α} :
(a :: as).beq [] = falseh
huList.beq_nil_cons}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhctheorem List.beq_nil_cons {α : Type u} [BEq α] {a : α} {as : List α} :
[].beq (a :: as) = falseh
huList.beq_cons₂}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlh~theorem List.beq_cons₂ {α : Type u} [BEq α] {a b : α} {as bs : List α} :
(a :: as).beq (b :: bs) = (a == b && as.beq bs)h
huList.instBEq}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlh<instance List.instBEq {α : Type u} [BEq α] :
BEq (List α)h
huList.instReflBEq}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhQinstance List.instReflBEq {α : Type u} [BEq α] [ReflBEq α] :
ReflBEq (List α)h
huList.instLawfulBEq}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhWinstance List.instLawfulBEq {α : Type u} [BEq α] [LawfulBEq α] :
LawfulBEq (List α)h
hu
List.isEqv}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhPdef List.isEqv {α : Type u} (as bs : List α) (eqv : α → α → Bool) :
Boolh
Returns true if as and bs have the same length and they are pairwise related by eqv.
O(min |as| |bs|). Short-circuits at the first non-related pair of elements.
Examples:uList.isEqv_nil_nil}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlh\theorem List.isEqv_nil_nil {α : Type u} {eqv : α → α → Bool} :
[].isEqv [] eqv = trueh
huList.isEqv_nil_cons}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlh}theorem List.isEqv_nil_cons {α : Type u} {a : α} {as : List α} {eqv : α → α → Bool} :
[].isEqv (a :: as) eqv = falseh
huList.isEqv_cons_nil}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlh}theorem List.isEqv_cons_nil {α : Type u} {a : α} {as : List α} {eqv : α → α → Bool} :
(a :: as).isEqv [] eqv = falseh
huList.isEqv_cons₂}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhtheorem List.isEqv_cons₂ {α✝ : Type u_1} {a : α✝} {as : List α✝} {b : α✝} {bs : List α✝} {eqv : α✝ → α✝ → Bool} :
(a :: as).isEqv (b :: bs) eqv = (eqv a b && as.isEqv bs eqv)h
huList.Lex}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhRinductive List.Lex {α : Type u} (r : α → α → Prop) (as bs : List α) :
Proph
XA  Lexicographic ordering for lists with respect to an ordering of elements.
as is lexicographically smaller than bs if
[] is the smallest element in the lexicographic order.
If the head of the first list is smaller than the head of the second, then the first list is lexicographically smaller than the second list.
If two lists have the same head, then their tails determine their lexicographic order. If the tail of the first list is lexicographically smaller than the tail of the second list, then the entire first list is lexicographically smaller than the entire second list.uList.decidableLex}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhinstance List.decidableLex {α : Type u} [DecidableEq α] (r : α → α → Prop) [h : DecidableRel r] (l₁ l₂ : List α) :
Decidable (Lex r l₁ l₂)h
huList.lt}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhCabbrev List.lt {α : Type u} [LT α] :
List α → List α → Proph
YLexicographic ordering of lists with respect to an ordering on their elements.
as < bs ifuList.instLT}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlh9instance List.instLT {α : Type u} [LT α] :
LT (List α)h
huList.decidableLT}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhinstance List.decidableLT {α : Type u} [DecidableEq α] [LT α] [DecidableLT α] (l₁ l₂ : List α) :
Decidable (l₁ < l₂)h
'Decidability of lexicographic ordering.uList.le}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlh:def List.le {α : Type u} [LT α] (as bs : List α) :
Proph
X  Non-strict ordering of lists with respect to a strict ordering of their elements.
as ≤ bs if ¬ bs < as.
This relation can be treated as a lexicographic order if the underlying LT α instance is well-behaved. In particular, it should be irreflexive, asymmetric, and antisymmetric. These requirements are precisely formulated in List.cons_le_cons_iff. If these hold, then as ≤ bs if and only if:uList.instLE}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlh9instance List.instLE {α : Type u} [LT α] :
LE (List α)h
huList.decidableLE}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhinstance List.decidableLE {α : Type u} [DecidableEq α] [LT α] [DecidableLT α] (l₁ l₂ : List α) :
Decidable (l₁ ≤ l₂)h
huList.lex}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhpdef List.lex {α : Type u} [BEq α] (l₁ l₂ : List α) (lt : α → α → Bool := by exact (· < ·)) :
Boolh
Compares lists lexicographically with respect to a comparison on their elements.
The lexicographic order with respect to lt is:uList.nil_lex_nil}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlh`theorem List.nil_lex_nil {α : Type u} {lt : α → α → Bool} [BEq α] :
[].lex [] lt = falseh
huList.nil_lex_cons}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhtheorem List.nil_lex_cons {α : Type u} {lt : α → α → Bool} [BEq α] {b : α} {bs : List α} :
[].lex (b :: bs) lt = trueh
huList.cons_lex_nil}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhtheorem List.cons_lex_nil {α : Type u} {lt : α → α → Bool} [BEq α] {a : α} {as : List α} :
(a :: as).lex [] lt = falseh
huList.cons_lex_cons}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhtheorem List.cons_lex_cons {α : Type u} {lt : α → α → Bool} [BEq α] {a b : α} {as bs : List α} :
(a :: as).lex (b :: bs) lt = (lt a b || a == b && as.lex bs lt)h
huList.lex_nil}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhktheorem List.lex_nil {α : Type u} {lt : α → α → Bool} [BEq α] {as : List α} :
as.lex [] lt = false      h
huList.lex_nil_nil}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlh`theorem List.lex_nil_nil {α : Type u} {lt : α → α → Bool} [BEq α] :
[].lex [] lt = falseh
huList.lex_nil_cons}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhtheorem List.lex_nil_cons {α : Type u} {lt : α → α → Bool} [BEq α] {b : α} {bs : List α} :
[].lex (b :: bs) lt = trueh
huList.lex_cons_nil}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhtheorem List.lex_cons_nil {α : Type u} {lt : α → α → Bool} [BEq α] {a : α} {as : List α} :
(a :: as).lex [] lt = falseh
huList.lex_cons_cons}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhtheorem List.lex_cons_cons {α : Type u} {lt : α → α → Bool} [BEq α] {a b : α} {as bs : List α} :
(a :: as).lex (b :: bs) lt = (lt a b || a == b && as.lex bs lt)h
huList.getLast}(hj	  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlh@def List.getLast {α : Type u} (as : List α) :
as ≠ [] → αh
7Returns the last element of a non-empty list.
Examples:u
List.getLast?}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlh7def List.getLast? {α : Type u} :
List α → Option αh
Returns the last element in the list, or none if the list is empty.
Alternatives include List.getLastD, which takes a fallback value for empty lists, and List.getLast!, which panics on empty lists.
Examples:uList.getLast?_nil}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlh<theorem List.getLast?_nil {α : Type u} :
[].getLast? = noneh
hu
List.getLastD}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhCdef List.getLastD {α : Type u} (as : List α) (fallback : α) :
αh
Returns the last element in the list, or fallback if the list is empty.
Alternatives include List.getLast?, which returns an Option, and List.getLast!, which panics on empty lists.
Examples:uList.getLastD_nil}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhDtheorem List.getLastD_nil {α : Type u} {a : α} :
[].getLastD a = ah
huList.getLastD_cons}(hj   hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhftheorem List.getLastD_cons {α : Type u} {a b : α} {l : List α} :
(b :: l).getLastD a = l.getLastD bh
hu	List.head}(hj$  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlh=def List.head {α : Type u} (as : List α) :
as ≠ [] → αh
.Returns the first element of a non-empty list.uList.head_cons}(hj)  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhetheorem List.head_cons {α : Type u} {a : α} {l : List α} {h : a :: l ≠ []} :
(a :: l).head h = ah
hu
List.head?}(hj-  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlh4def List.head? {α : Type u} :
List α → Option αh
Returns the first element in the list, if there is one. Returns none if the list is empty.
Use List.headD to provide a fallback value for empty lists, or List.head! to panic on empty lists.
Examples:uList.head?_nil}(hj2  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlh6theorem List.head?_nil {α : Type u} :
[].head? = noneh
huList.head?_cons}(hj6  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhVtheorem List.head?_cons {α : Type u} {a : α} {l : List α} :
(a :: l).head? = some ah
hu
List.headD}(hj:  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlh@def List.headD {α : Type u} (as : List α) (fallback : α) :
αh
Returns the first element in the list if there is one, or fallback if the list is empty.
Use List.head? to return an Option, and List.head! to panic on empty lists.
Examples:uList.headD_nil}(hj?  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlh>theorem List.headD_nil {α : Type u} {d : α} :
[].headD d = dh
huList.headD_cons}(hjC  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlh\theorem List.headD_cons {α : Type u} {a : α} {l : List α} {d : α} :
(a :: l).headD d = ah
hu	List.tail}(hjG  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlh1def List.tail {α : Type u} :
List α → List αh
pDrops the first element of a nonempty list, returning the tail. Returns [] when the argument is empty.
Examples:u
List.tail_nil}(hjL  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlh2theorem List.tail_nil {α : Type u} :
[].tail = []h
huList.tail_cons}(hjP  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhRtheorem List.tail_cons {α : Type u} {a : α} {as : List α} :
(a :: as).tail = ash
hu
List.tail?}(hjT  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlh;def List.tail? {α : Type u} :
List α → Option (List α)h
X!  Drops the first element of a nonempty list, returning the tail. Returns none when the argument is empty.
Alternatives include List.tail, which returns the empty list on failure, List.tailD, which returns an explicit fallback value, and List.tail!, which panics on the empty list.
Examples:uList.tail?_nil}(hjY  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlh6theorem List.tail?_nil {α : Type u} :
[].tail? = noneh
huList.tail?_cons}(hj]  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhVtheorem List.tail?_cons {α : Type u} {a : α} {l : List α} :
(a :: l).tail? = some lh
hu
List.tailD}(hja  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlh=def List.tailD {α : Type u} (l fallback : List α) :
List αh
X  Drops the first element of a nonempty list, returning the tail. Returns none when the argument is empty.
Alternatives include List.tail, which returns the empty list on failure, List.tail?, which returns an Option, and List.tail!, which panics on the empty list.
Examples:uList.tailD_nil}(hjf  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhFtheorem List.tailD_nil {α : Type u} {l' : List α} :
[].tailD l' = l'h
huList.tailD_cons}(hjj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhWtheorem List.tailD_cons {α : Type u} {a : α} {l l' : List α} :
(a :: l).tailD l' = lh
huList.map}(hjn  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhPdef List.map {α : Type u} {β : Type v} (f : α → β) (l : List α) :
List βh
iApplies a function to each element of the list, returning the resulting list of values.
O(|l|).
Examples:uList.map_nil}(hjs  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhPtheorem List.map_nil {α : Type u} {β : Type v} {f : α → β} :
map f [] = []h
hu
List.map_cons}(hjw  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhztheorem List.map_cons {α : Type u} {β : Type v} {f : α → β} {a : α} {l : List α} :
map f (a :: l) = f a :: map f lh
huList.filter}(hj{  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhGdef List.filter {α : Type u} (p : α → Bool) (l : List α) :
List αh
MReturns the list of elements in l for which p returns true.
O(|l|).
Examples:uList.filter_nil}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhJtheorem List.filter_nil {α : Type u} {p : α → Bool} :
filter p [] = []h
huList.filterMap}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlh[def List.filterMap {α : Type u} {β : Type v} (f : α → Option β) :
List α → List βh
uApplies a function that returns an Option to each element of a list, collecting the non-none values.
O(|l|).
Example:uList.filterMap_nil}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhctheorem List.filterMap_nil {α : Type u} {β : Type v} {f : α → Option β} :
filterMap f [] = []h
huList.filterMap_cons}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhtheorem List.filterMap_cons {α : Type u} {β : Type v} {f : α → Option β} {a : α} {l : List α} :
filterMap f (a :: l) = match f a with
  | none => filterMap f l
  | some b => b :: filterMap f lh
hu
List.foldr}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlh`def List.foldr {α : Type u} {β : Type v} (f : α → β → β) (init : β) (l : List α) :
βh
Folds a function over a list from the right, accumulating a value starting with init. The accumulated value is combined with the each element of the list in reverse order, using f.
O(|l|). Replaced at runtime with List.foldrTR.
Examples:uList.foldr_nil}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhtheorem List.foldr_nil {α✝ : Type u_1} {α✝¹ : Type u_2} {f : α✝ → α✝¹ → α✝¹} {b : α✝¹} :
foldr f b [] = bh
huList.foldr_cons}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhtheorem List.foldr_cons {α : Type u} {β : Type v} {a : α} {l : List α} {f : α → β → β} {b : β} :
foldr f b (a :: l) = f a (foldr f b l)h
huList.reverseAux}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhCdef List.reverseAux {α : Type u} :
List α → List α → List αh
]Auxiliary for List.reverse. List.reverseAux l r = l.reverse ++ r, but it is defined directly.uList.reverseAux_nil}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhUtheorem List.reverseAux_nil {α✝ : Type u_1} {r : List α✝} :
[].reverseAux r = rh
huList.reverseAux_cons}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlh~theorem List.reverseAux_cons {α✝ : Type u_1} {a : α✝} {l r : List α✝} :
(a :: l).reverseAux r = l.reverseAux (a :: r)h
huList.reverse}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlh7def List.reverse {α : Type u} (as : List α) :
List αh
X  Reverses a list.
O(|as|).
Because of the “functional but in place” optimization implemented by Lean's compiler, this function does not allocate a new list when its reference to the input list is unshared: it simply walks the linked list and reverses all the node pointers.
Examples:uList.reverse_nil}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlh8theorem List.reverse_nil {α : Type u} :
[].reverse = []h
huList.reverseAux_reverseAux}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhtheorem List.reverseAux_reverseAux {α : Type u} {as bs cs : List α} :
(as.reverseAux bs).reverseAux cs = bs.reverseAux ((as.reverseAux []).reverseAux cs)h
huList.append}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlh9def List.append {α : Type u} (xs ys : List α) :
List αh
Appends two lists. Normally used via the ++ operator.
Appending lists takes time proportional to the length of the first list: O(|xs|).
Examples:u
List.appendTR}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlh;def List.appendTR {α : Type u} (as bs : List α) :
List αh
Appends two lists. Normally used via the ++ operator.
Appending lists takes time proportional to the length of the first list: O(|xs|).
This is a tail-recursive version of List.append.
Examples:uList.append_eq_appendTR}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlh:theorem List.append_eq_appendTR :
@List.append = @appendTRh
huList.instAppend}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlh9instance List.instAppend {α : Type u} :
Append (List α)h
huList.append_eq}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhPtheorem List.append_eq {α : Type u} {as bs : List α} :
as.append bs = as ++ bsh
huList.nil_append}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhDtheorem List.nil_append {α : Type u} (as : List α) :
[] ++ as = ash
huList.cons_append}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhctheorem List.cons_append {α : Type u} {a : α} {as bs : List α} :
a :: as ++ bs = a :: (as ++ bs)h
huList.append_nil}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhDtheorem List.append_nil {α : Type u} (as : List α) :
as ++ [] = ash
hu!List.instLawfulIdentityHAppendNil}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhtinstance List.instLawfulIdentityHAppendNil {α : Type u} :
Std.LawfulIdentity (fun (x1 x2 : List α) => x1 ++ x2) []h
huList.length_append}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhftheorem List.length_append {α : Type u} {as bs : List α} :
(as ++ bs).length = as.length + bs.lengthh
huList.append_assoc}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlh`theorem List.append_assoc {α : Type u} (as bs cs : List α) :
as ++ bs ++ cs = as ++ (bs ++ cs)h
huList.instAssociativeHAppend}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhfinstance List.instAssociativeHAppend {α : Type u} :
Std.Associative fun (x1 x2 : List α) => x1 ++ x2h
huList.append_cons}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhotheorem List.append_cons {α : Type u} (as : List α) (b : α) (bs : List α) :
as ++ b :: bs = as ++ [b] ++ bsh
huList.concat_eq_append}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlh]theorem List.concat_eq_append {α : Type u} {as : List α} {a : α} :
as.concat a = as ++ [a]h
huList.reverseAux_eq_append}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhmtheorem List.reverseAux_eq_append {α : Type u} {as bs : List α} :
as.reverseAux bs = as.reverseAux [] ++ bsh
huList.reverse_cons}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhgtheorem List.reverse_cons {α : Type u} {a : α} {as : List α} :
(a :: as).reverse = as.reverse ++ [a]h
huList.flatten}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlh;def List.flatten {α : Type u} :
List (List α) → List αh
pConcatenates a list of lists into a single list, preserving the order of the elements.
O(|flatten L|).
Examples:uList.flatten_nil}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlh8theorem List.flatten_nil {α : Type u} :
[].flatten = []h
huList.flatten_cons}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhytheorem List.flatten_cons {α✝ : Type u_1} {l : List α✝} {L : List (List α✝)} :
(l :: L).flatten = l ++ L.flattenh
huList.singleton}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlh3def List.singleton {α : Type u} (a : α) :
List αh
+Constructs a single-element list.
Examples:uList.flatMap}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhZdef List.flatMap {α : Type u} {β : Type v} (b : α → List β) (as : List α) :
List βh
qApplies a function that returns a list to each element of a list, and concatenates the resulting lists.
Examples:uList.flatMap_nil}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlh]theorem List.flatMap_nil {α : Type u} {β : Type v} {f : α → List β} :
flatMap f [] = []h
huList.flatMap_cons}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhtheorem List.flatMap_cons {α : Type u} {β : Type v} {x : α} {xs : List α} {f : α → List β} :
flatMap f (x :: xs) = f x ++ flatMap f xsh
huList.replicate}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlh=def List.replicate {α : Type u} (n : Nat) (a : α) :
List αh
+Creates a list that contains n copies of a.uList.replicate_zero}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhGtheorem List.replicate_zero {α : Type u} {a : α} :
replicate 0 a = []h
huList.replicate_succ}(hj"  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhgtheorem List.replicate_succ {α : Type u} {a : α} {n : Nat} :
replicate (n + 1) a = a :: replicate n ah
huList.length_replicate}(hj&  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlh[theorem List.length_replicate {α : Type u} {n : Nat} {a : α} :
(replicate n a).length = nh
huList.leftpad}(hj*  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhIdef List.leftpad {α : Type u} (n : Nat) (a : α) (l : List α) :
List αh
Pads l : List α on the left with repeated occurrences of a : α until it is of length n. If l already has at least n elements, it is returned unmodified.
Examples:u
List.rightpad}(hj/  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhJdef List.rightpad {α : Type u} (n : Nat) (a : α) (l : List α) :
List αh
Pads l : List α on the right with repeated occurrences of a : α until it is of length n. If l already has at least n elements, it is returned unmodified.
Examples:uList.reduceOption}(hj4  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhDdef List.reduceOption {α : Type u_1} :
List (Option α) → List αh
ADrop nones from a list, and replace each remaining some a with a.uList.instEmptyCollection}(hj9  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhKinstance List.instEmptyCollection {α : Type u} :
EmptyCollection (List α)h
hu
List.empty_eq}(hj=  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlh.theorem List.empty_eq {α : Type u} :
∅ = []h
huList.isEmpty}(hjA  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlh1def List.isEmpty {α : Type u} :
List α → Boolh
/Checks whether a list is empty.
O(1).
Examples:uList.isEmpty_nil}(hjF  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlh:theorem List.isEmpty_nil {α : Type u} :
[].isEmpty = trueh
huList.isEmpty_cons}(hjJ  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlh[theorem List.isEmpty_cons {α : Type u} {x : α} {xs : List α} :
(x :: xs).isEmpty = falseh
hu	List.elem}(hjN  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhBdef List.elem {α : Type u} [BEq α] (a : α) (l : List α) :
Boolh
X,  Checks whether a is an element of l, using == to compare elements.
O(|l|). List.contains is a synonym that takes the list before the element.
The preferred simp normal form is l.contains a. When LawfulBEq α is available, l.contains a = true ↔ a ∈ l and l.contains a = false ↔ a ∉ l.
Example:u
List.elem_nil}(hjS  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhItheorem List.elem_nil {α : Type u} {a : α} [BEq α] :
elem a [] = falseh
huList.elem_cons}(hjW  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhtheorem List.elem_cons {α : Type u} {b : α} {bs : List α} [BEq α] {a : α} :
elem a (b :: bs) = match a == b with
  | true => true
  | false => elem a bsh
hu
List.contains}(hj[  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhJabbrev List.contains {α : Type u} [BEq α] (as : List α) (a : α) :
Boolh
X/  Checks whether a is an element of as, using == to compare elements.
O(|as|). List.elem is a synonym that takes the element before the list.
The preferred simp normal form is l.contains a, and when LawfulBEq α is available, l.contains a = true ↔ a ∈ l and l.contains a = false ↔ a ∉ l.
Examples:uList.contains_nil}(hj`  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhQtheorem List.contains_nil {α : Type u} {a : α} [BEq α] :
[].contains a = falseh
huList.Mem}(hjd  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlh<inductive List.Mem {α : Type u} (a : α) :
List α → Proph
X  List membership, typically accessed via the ∈ operator.
a ∈ l means that a is an element of the list l. Elements are compared according to Lean's logical equality.
The related function List.elem is a Boolean membership test that uses a BEq α instance.
Examples:
The head of a list is a member: a ∈ a :: as.
A member of the tail of a list is a member of the list: a ∈ l → a ∈ b :: l.uList.instMembership}(hji  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhDinstance List.instMembership {α : Type u} :
Membership α (List α)h
huList.mem_of_elem_eq_true}(hjm  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlh~theorem List.mem_of_elem_eq_true {α : Type u} [BEq α] [LawfulBEq α] {a : α} {as : List α} :
elem a as = true → a ∈ ash
huList.elem_eq_true_of_mem}(hjq  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlh~theorem List.elem_eq_true_of_mem {α : Type u} [BEq α] [ReflBEq α] {a : α} {as : List α} (h : a ∈ as) :
elem a as = trueh
hu List.instDecidableMemOfLawfulBEq}(hju  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlh~instance List.instDecidableMemOfLawfulBEq {α : Type u} [BEq α] [LawfulBEq α] (a : α) (as : List α) :
Decidable (a ∈ as)h
huList.mem_append_left}(hjy  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhotheorem List.mem_append_left {α : Type u} {a : α} {as : List α} (bs : List α) :
a ∈ as → a ∈ as ++ bsh
huList.mem_append_right}(hj}  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhptheorem List.mem_append_right {α : Type u} {b : α} (as : List α) {bs : List α} :
b ∈ bs → b ∈ as ++ bsh
huList.decidableBEx}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhinstance List.decidableBEx {α : Type u} (p : α → Prop) [DecidablePred p] (l : List α) :
Decidable (∃ (x : α), x ∈ l ∧ p x)h
huList.decidableBAll}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhinstance List.decidableBAll {α : Type u} (p : α → Prop) [DecidablePred p] (l : List α) :
Decidable (∀ (x : α), x ∈ l → p x)h
hu	List.take}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlh>def List.take {α : Type u} (n : Nat) (xs : List α) :
List αh
oExtracts the first n elements of xs, or the whole list if n is greater than xs.length.
O(min n |xs|).
Examples:u
List.take_nil}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlh>theorem List.take_nil {α : Type u} {i : Nat} :
take i [] = []h
huList.take_zero}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhBtheorem List.take_zero {α : Type u} {l : List α} :
take 0 l = []h
huList.take_succ_cons}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhutheorem List.take_succ_cons {α : Type u} {a : α} {as : List α} {i : Nat} :
take (i + 1) (a :: as) = a :: take i ash
hu	List.drop}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlh>def List.drop {α : Type u} (n : Nat) (xs : List α) :
List αh
Removes the first n elements of the list xs. Returns the empty list if n is greater than the length of the list.
O(min n |xs|).
Examples:u
List.drop_nil}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlh>theorem List.drop_nil {α : Type u} {i : Nat} :
drop i [] = []h
huList.drop_zero}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhAtheorem List.drop_zero {α : Type u} {l : List α} :
drop 0 l = lh
huList.drop_succ_cons}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhmtheorem List.drop_succ_cons {α : Type u} {a : α} {l : List α} {i : Nat} :
drop (i + 1) (a :: l) = drop i lh
huList.drop_eq_nil_of_le}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhltheorem List.drop_eq_nil_of_le {α : Type u} {as : List α} {i : Nat} (h : as.length ≤ i) :
drop i as = []h
huList.extract}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlheabbrev List.extract {α : Type u} (l : List α) (start : Nat := 0) (stop : Nat := l.length) :
List αh
TReturns the slice of l from indices start (inclusive) to stop (exclusive).
Examples:uList.extract_eq_drop_take}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhtheorem List.extract_eq_drop_take {α : Type u} {l : List α} {start stop : Nat} :
l.extract start stop = take (stop - start) (drop start l)h
huList.takeWhile}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhKdef List.takeWhile {α : Type u} (p : α → Bool) (xs : List α) :
List αh
VReturns the longest initial segment of xs for which p returns true.
O(|xs|).
Examples:uList.takeWhile_nil}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhPtheorem List.takeWhile_nil {α : Type u} {p : α → Bool} :
takeWhile p [] = []h
huList.dropWhile}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhHdef List.dropWhile {α : Type u} (p : α → Bool) :
List α → List αh
Removes the longest prefix of a list for which p returns true.
Elements are removed from the list until one is encountered for which p returns false. This element and the remainder of the list are returned.
O(|l|).
Examples:uList.dropWhile_nil}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhPtheorem List.dropWhile_nil {α : Type u} {p : α → Bool} :
dropWhile p [] = []h
huList.partition}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhVdef List.partition {α : Type u} (p : α → Bool) (as : List α) :
List α × List αh
Xi  Returns a pair of lists that together contain all the elements of as. The first list contains those elements for which p returns true, and the second contains those for which p returns false.
O(|l|). as.partition p is equivalent to (as.filter p, as.filter (not ∘ p)), but it is slightly more efficient since it only has to do one pass over the list.
Examples:u
List.dropLast}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlh7def List.dropLast {α : Type u_1} :
List α → List αh
>Removes the last element of the list, if one exists.
Examples:uList.dropLast_nil}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlh:theorem List.dropLast_nil {α : Type u} :
[].dropLast = []h
huList.dropLast_singleton}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhRtheorem List.dropLast_singleton {α✝ : Type u_1} {x : α✝} :
[x].dropLast = []h
huList.dropLast_single}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhOtheorem List.dropLast_single {α✝ : Type u_1} {x : α✝} :
[x].dropLast = []h
huList.dropLast_cons₂}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhtheorem List.dropLast_cons₂ {α✝ : Type u_1} {x y : α✝} {zs : List α✝} :
(x :: y :: zs).dropLast = x :: (y :: zs).dropLasth
huList.length_dropLast_cons}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhotheorem List.length_dropLast_cons {α : Type u} {a : α} {as : List α} :
(a :: as).dropLast.length = as.lengthh
huList.Subset}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlh:def List.Subset {α : Type u} (l₁ l₂ : List α) :
Proph
al₁ ⊆ l₂ means that every element of l₁ is also an element of l₂, ignoring multiplicity.uList.instHasSubset}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlh?instance List.instHasSubset {α : Type u} :
HasSubset (List α)h
hu(List.instDecidableRelSubsetOfDecidableEq}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhfinstance List.instDecidableRelSubsetOfDecidableEq {α : Type u} [DecidableEq α] :
DecidableRel Subseth
huList.Sublist}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhEinductive List.Sublist {α : Type u_1} :
List α → List α → Proph
X  The first list is a non-contiguous sub-list of the second list. Typically written with the <+ operator.
In other words, l₁ <+ l₂ means that l₁ can be transformed into l₂ by repeatedly inserting new elements.
The base case: [] is a sublist of []
If l₁ is a subsequence of l₂, then it is also a subsequence of a :: l₂.
If l₁ is a subsequence of l₂, then a :: l₁ is a subsequence of a :: l₂.uList.«term_<+_»}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlh0def List.«term_<+_» :
Lean.TrailingParserDescrh
The first list is a non-contiguous sub-list of the second list. Typically written with the <+ operator.
In other words, l₁ <+ l₂ means that l₁ can be transformed into l₂ by repeatedly inserting new elements.uList.isSublist}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhHdef List.isSublist {α : Type u} [BEq α] :
List α → List α → Boolh
True if the first list is a potentially non-contiguous sub-sequence of the second list, comparing elements with the == operator.
The relation List.Sublist is a logical characterization of this property.
Examples:u
List.IsPrefix}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlh<def List.IsPrefix {α : Type u} (l₁ l₂ : List α) :
Proph
X  The first list is a prefix of the second.
IsPrefix l₁ l₂, written l₁ <+: l₂, means that there exists some t : List α such that l₂ has the form l₁ ++ t.
The function List.isPrefixOf is a Boolean equivalent.
Conventions for notations in identifiers:uList.«term_<+:_»}(hj	  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlh1def List.«term_<+:_» :
Lean.TrailingParserDescrh
X  The first list is a prefix of the second.
IsPrefix l₁ l₂, written l₁ <+: l₂, means that there exists some t : List α such that l₂ has the form l₁ ++ t.
The function List.isPrefixOf is a Boolean equivalent.
Conventions for notations in identifiers:uList.isPrefixOf}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhIdef List.isPrefixOf {α : Type u} [BEq α] :
List α → List α → Boolh
Checks whether the first list is a prefix of the second.
The relation List.IsPrefixOf expresses this property with respect to logical equality.
Examples:uList.isPrefixOf_nil_left}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlh^theorem List.isPrefixOf_nil_left {α : Type u} {l : List α} [BEq α] :
[].isPrefixOf l = trueh
huList.isPrefixOf_cons_nil}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhqtheorem List.isPrefixOf_cons_nil {α : Type u} {a : α} {as : List α} [BEq α] :
(a :: as).isPrefixOf [] = falseh
huList.isPrefixOf_cons₂}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhtheorem List.isPrefixOf_cons₂ {α : Type u} {as : List α} {b : α} {bs : List α} [BEq α] {a : α} :
(a :: as).isPrefixOf (b :: bs) = (a == b && as.isPrefixOf bs)h
huList.isPrefixOf?}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhTdef List.isPrefixOf? {α : Type u} [BEq α] (l₁ l₂ : List α) :
Option (List α)h
If the first list is a prefix of the second, returns the result of dropping the prefix.
In other words, isPrefixOf? l₁ l₂ returns some t when l₂ == l₁ ++ t.
Examples:uList.isSuffixOf}(hj$  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhGdef List.isSuffixOf {α : Type u} [BEq α] (l₁ l₂ : List α) :
Boolh
Checks whether the first list is a suffix of the second.
The relation List.IsSuffixOf expresses this property with respect to logical equality.
Examples:uList.isSuffixOf_nil_left}(hj)  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlh^theorem List.isSuffixOf_nil_left {α : Type u} {l : List α} [BEq α] :
[].isSuffixOf l = trueh
huList.isSuffixOf?}(hj-  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhTdef List.isSuffixOf? {α : Type u} [BEq α] (l₁ l₂ : List α) :
Option (List α)h
If the first list is a suffix of the second, returns the result of dropping the suffix from the second.
In other words, isSuffixOf? l₁ l₂ returns some t when l₂ == t ++ l₁.
Examples:u
List.IsSuffix}(hj2  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlh<def List.IsSuffix {α : Type u} (l₁ l₂ : List α) :
Proph
X  The first list is a suffix of the second.
IsSuffix l₁ l₂, written l₁ <:+ l₂, means that there exists some t : List α such that l₂ has the form t ++ l₁.
The function List.isSuffixOf is a Boolean equivalent.
Conventions for notations in identifiers:uList.«term_<:+_»}(hj7  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlh1def List.«term_<:+_» :
Lean.TrailingParserDescrh
X  The first list is a suffix of the second.
IsSuffix l₁ l₂, written l₁ <:+ l₂, means that there exists some t : List α such that l₂ has the form t ++ l₁.
The function List.isSuffixOf is a Boolean equivalent.
Conventions for notations in identifiers:uList.IsInfix}(hj<  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlh;def List.IsInfix {α : Type u} (l₁ l₂ : List α) :
Proph
X  The first list is a contiguous sub-list of the second list. Typically written with the <:+: operator.
In other words, l₁ <:+: l₂ means that there exist lists s : List α and t : List α such that l₂ has the form s ++ l₁ ++ t.
Conventions for notations in identifiers:uList.«term_<:+:_»}(hjA  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlh2def List.«term_<:+:_» :
Lean.TrailingParserDescrh
X  The first list is a contiguous sub-list of the second list. Typically written with the <:+: operator.
In other words, l₁ <:+: l₂ means that there exist lists s : List α and t : List α such that l₂ has the form s ++ l₁ ++ t.
Conventions for notations in identifiers:uList.splitAt}(hjF  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhKdef List.splitAt {α : Type u} (n : Nat) (l : List α) :
List α × List αh
X1  Splits a list at an index, resulting in the first n elements of l paired with the remaining elements.
If n is greater than the length of l, then the resulting pair consists of l and the empty list. List.splitAt is equivalent to a combination of List.take and List.drop, but it is more efficient.
Examples:uList.rotateLeft}(hjK  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhIdef List.rotateLeft {α : Type u} (xs : List α) (i : Nat := 1) :
List αh
Rotates the elements of xs to the left, moving i % xs.length elements from the start of the list to the end.
O(|xs|).
Examples:uList.rotateLeft_nil}(hjP  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhJtheorem List.rotateLeft_nil {α : Type u} {n : Nat} :
[].rotateLeft n = []h
huList.rotateRight}(hjT  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhJdef List.rotateRight {α : Type u} (xs : List α) (i : Nat := 1) :
List αh
Rotates the elements of xs to the right, moving i % xs.length elements from the end of the list to the start.
After rotation, the element at xs[n] is at index (i + n) % l.length. O(|xs|).
Examples:uList.rotateRight_nil}(hjY  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhLtheorem List.rotateRight_nil {α : Type u} {n : Nat} :
[].rotateRight n = []h
hu
List.Pairwise}(hj]  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhQinductive List.Pairwise {α : Type u} (R : α → α → Prop) :
List α → Proph
X9  Each element of a list is related to all later elements of the list by R.
Pairwise R l means that all the elements of l with earlier indexes are R-related to all the elements with later indexes.
For example, Pairwise (· ≠ ·) l asserts that l has no duplicates, and Pairwise (· < ·) l asserts that l is (strictly) sorted.
Examples:
All elements of the empty list are vacuously pairwise related.
A nonempty list is pairwise related with R if the head is related to every element of the tail and the tail is itself pairwise related.
That is, a :: l is Pairwise R if:uList.pairwise_cons}(hjb  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhtheorem List.pairwise_cons {α : Type u} {R : α → α → Prop} {a : α} {l : List α} :
Pairwise R (a :: l) ↔ (∀ (a' : α), a' ∈ l → R a a') ∧ Pairwise R lh
huList.instDecidablePairwise}(hjf  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhinstance List.instDecidablePairwise {α : Type u} {R : α → α → Prop} [DecidableRel R] (l : List α) :
Decidable (Pairwise R l)h
hu
List.Nodup}(hjj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlh/def List.Nodup {α : Type u} :
List α → Proph
The list has no duplicates: it contains every element at most once.
It is defined as Pairwise (· ≠ ·): each element is unequal to all other elements.uList.nodupDecidable}(hjo  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlh]instance List.nodupDecidable {α : Type u} [DecidableEq α] (l : List α) :
Decidable l.Noduph
huList.replace}(hjs  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhJdef List.replace {α : Type u} [BEq α] (l : List α) (a b : α) :
List αh
Replaces the first element of the list l that is equal to a with b. If no element is equal to a, then the list is returned unchanged.
O(|l|).
Examples:uList.replace_nil}(hjx  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhPtheorem List.replace_nil {α : Type u} {a b : α} [BEq α] :
[].replace a b = []h
huList.replace_cons}(hj|  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhtheorem List.replace_cons {α : Type u} {as : List α} {b c : α} [BEq α] {a : α} :
(a :: as).replace b c = match b == a with
  | true => c :: as
  | false => a :: as.replace b ch
huList.modifyTailIdx}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlh`def List.modifyTailIdx {α : Type u} (l : List α) (i : Nat) (f : List α → List α) :
List αh
Replaces the nth tail of l with the result of applying f to it. Returns the input without using f if the index is larger than the length of the List.
Examples:uList.modifyTailIdx_zero}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhqtheorem List.modifyTailIdx_zero {α : Type u} {f : List α → List α} {l : List α} :
l.modifyTailIdx 0 f = f lh
huList.modifyTailIdx_succ_nil}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhwtheorem List.modifyTailIdx_succ_nil {α : Type u} {f : List α → List α} {i : Nat} :
[].modifyTailIdx (i + 1) f = []h
huList.modifyTailIdx_succ_cons}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhtheorem List.modifyTailIdx_succ_cons {α : Type u} {f : List α → List α} {i : Nat} {a : α} {l : List α} :
(a :: l).modifyTailIdx (i + 1) f = a :: l.modifyTailIdx i fh
huList.modifyHead}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhGdef List.modifyHead {α : Type u} (f : α → α) :
List α → List αh
xReplace the head of the list with the result of applying f to it. Returns the empty list if the list is empty.
Examples:uList.modifyHead_nil}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhPtheorem List.modifyHead_nil {α : Type u} {f : α → α} :
modifyHead f [] = []h
huList.modifyHead_cons}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhttheorem List.modifyHead_cons {α : Type u} {a : α} {l : List α} {f : α → α} :
modifyHead f (a :: l) = f a :: lh
huList.modify}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhOdef List.modify {α : Type u} (l : List α) (i : Nat) (f : α → α) :
List αh
Replaces the element at the given index, if it exists, with the result of applying f to it. If the index is invalid, the list is returned unmodified.
Examples:uList.insert}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhGdef List.insert {α : Type u} [BEq α] (a : α) (l : List α) :
List αh
Inserts an element into a list without duplication.
If the element is present in the list, the list is returned unmodified. Otherwise, the new element is inserted at the head of the list.
Examples:uList.insertIdx}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhLdef List.insertIdx {α : Type u} (xs : List α) (i : Nat) (a : α) :
List αh
Inserts an element into a list at the specified index. If the index is greater than the length of the list, then the list is returned unmodified.
In other words, the new element is inserted into the list l after the first i elements of l.
Examples:u
List.erase}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhDdef List.erase {α : Type u_1} [BEq α] :
List α → α → List αh
vRemoves the first occurrence of a from l. If a does not occur in l, the list is returned unmodified.
O(|l|).
Examples:uList.erase_nil}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhHtheorem List.erase_nil {α : Type u} [BEq α] (a : α) :
[].erase a = []h
huList.erase_cons}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhtheorem List.erase_cons {α : Type u} [BEq α] {a b : α} {l : List α} :
(b :: l).erase a = if (b == a) = true then l else b :: l.erase ah
huList.eraseP}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhEdef List.eraseP {α : Type u} (p : α → Bool) :
List α → List αh
Removes the first element of a list for which p returns true. If no element satisfies p, then the list is returned unchanged.
Examples:u
List.eraseIdx}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhAdef List.eraseIdx {α : Type u} (l : List α) (i : Nat) :
List αh
{Removes the element at the specified index. If the index is out of bounds, the list is returned unmodified.
O(i).
Examples:uList.eraseIdx_nil}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhFtheorem List.eraseIdx_nil {α : Type u} {i : Nat} :
[].eraseIdx i = []h
huList.eraseIdx_cons_zero}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhltheorem List.eraseIdx_cons_zero {α✝ : Type u_1} {a : α✝} {as : List α✝} :
(a :: as).eraseIdx 0 = ash
huList.eraseIdx_cons_succ}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhtheorem List.eraseIdx_cons_succ {α✝ : Type u_1} {a : α✝} {as : List α✝} {i : Nat} :
(a :: as).eraseIdx (i + 1) = a :: as.eraseIdx ih
hu
List.find?}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhFdef List.find? {α : Type u} (p : α → Bool) :
List α → Option αh
Returns the first element of the list for which the predicate p returns true, or none if no such element is found.
O(|l|).
Examples:uList.find?_nil}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhJtheorem List.find?_nil {α : Type u} {p : α → Bool} :
find? p [] = noneh
huList.find?_cons}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhtheorem List.find?_cons {α✝ : Type u_1} {a : α✝} {as : List α✝} {p : α✝ → Bool} :
find? p (a :: as) = match p a with
  | true => some a
  | false => find? p ash
huList.findSome?}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlh]def List.findSome? {α : Type u} {β : Type v} (f : α → Option β) :
List α → Option βh
Returns the first non-none result of applying f to each element of the list in order. Returns none if f returns none for all elements of the list.
O(|l|).
Examples:uList.findSome?_nil}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhmtheorem List.findSome?_nil {α : Type u} {α✝ : Type u_1} {f : α → Option α✝} :
findSome? f [] = noneh
huList.findSome?_cons}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhtheorem List.findSome?_cons {α : Type u} {β : Type v} {a : α} {as : List α} {f : α → Option β} :
findSome? f (a :: as) = match f a with
  | some b => some b
  | none => findSome? f ash
hu
List.findRev?}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhIdef List.findRev? {α : Type u} (p : α → Bool) :
List α → Option αh
Returns the last element of the list for which the predicate p returns true, or none if no such element is found.
O(|l|).
Examples:uList.findSomeRev?}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlh`def List.findSomeRev? {α : Type u} {β : Type v} (f : α → Option β) :
List α → Option βh
Returns the last non-none result of applying f to each element of the list in order. Returns none if f returns none for all elements of the list.
O(|l|).
Examples:uList.findIdx}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhDdef List.findIdx {α : Type u} (p : α → Bool) (l : List α) :
Nath
Returns the index of the first element for which p returns true, or the length of the list if there is no such element.
Examples:uList.findIdx_nil}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhKtheorem List.findIdx_nil {α : Type u} {p : α → Bool} :
findIdx p [] = 0h
hu
List.idxOf}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlh@def List.idxOf {α : Type u} [BEq α] (a : α) :
List α → Nath
sReturns the index of the first element equal to a, or the length of the list if no element is equal to a.
Examples:uList.idxOf_nil}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhGtheorem List.idxOf_nil {α : Type u} {x : α} [BEq α] :
idxOf x [] = 0h
hu
List.findIdx?}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhLdef List.findIdx? {α : Type u} (p : α → Bool) (l : List α) :
Option Nath
oReturns the index of the first element for which p returns true, or none if there is no such element.
Examples:uList.idxOf?}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhHdef List.idxOf? {α : Type u} [BEq α] (a : α) :
List α → Option Nath
aReturns the index of the first element equal to a, or none if no element is equal to a.
Examples:uList.findFinIdx?}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhZdef List.findFinIdx? {α : Type u} (p : α → Bool) (l : List α) :
Option (Fin l.length)h
Returns the index of the first element for which p returns true, or none if there is no such element. The index is returned as a Fin, which guarantees that it is in bounds.
Examples:uList.finIdxOf?}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhXdef List.finIdxOf? {α : Type u} [BEq α] (a : α) (l : List α) :
Option (Fin l.length)h
Returns the index of the first element equal to a, or the length of the list if no element is equal to a. The index is returned as a Fin, which guarantees that it is in bounds.
Examples:uList.countP}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhCdef List.countP {α : Type u} (p : α → Bool) (l : List α) :
Nath
[Counts the number of elements in the list l that satisfy the Boolean predicate p.
Examples:u
List.count}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlh@def List.count {α : Type u} [BEq α] (a : α) :
List α → Nath
ACounts the number of times an element occurs in a list.
Examples:uList.lookup}(hj$  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlh[def List.lookup {α : Type u} {β : Type v} [BEq α] :
α → List (α × β) → Option βh
Treats the list as an association list that maps keys to values, returning the first value whose key is equal to the specified key.
O(|l|).
Examples:uList.lookup_nil}(hj)  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhZtheorem List.lookup_nil {α : Type u} {β : Type v} {a : α} [BEq α] :
lookup a [] = noneh
huList.lookup_cons}(hj-  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhtheorem List.lookup_cons {α : Type u} {β✝ : Type u_1} {b : β✝} {as : List (α × β✝)} {a : α} [BEq α] {k : α} :
lookup a ((k, b) :: as) = match a == k with
  | true => some b
  | false => lookup a ash
hu	List.Perm}(hj1  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlh@inductive List.Perm {α : Type u} :
List α → List α → Proph
X  Two lists are permutations of each other if they contain the same elements, each occurring the same number of times but not necessarily in the same order.
One list can be proven to be a permutation of another by showing how to transform one into the other by repeatedly swapping adjacent elements.
List.isPerm is a Boolean equivalent of this relation.
The empty list is a permutation of the empty list: [] ~ [].
If one list is a permutation of the other, adding the same element as the head of each yields lists that are permutations of each other: l₁ ~ l₂ → x::l₁ ~ x::l₂.
If two lists are identical except for having their first two elements swapped, then they are permutations of each other: x::y::l ~ y::x::l.
Permutation is transitive: l₁ ~ l₂ → l₂ ~ l₃ → l₁ ~ l₃.uList.«term_~_»}(hj6  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlh/def List.«term_~_» :
Lean.TrailingParserDescrh
X_  Two lists are permutations of each other if they contain the same elements, each occurring the same number of times but not necessarily in the same order.
One list can be proven to be a permutation of another by showing how to transform one into the other by repeatedly swapping adjacent elements.
List.isPerm is a Boolean equivalent of this relation.uList.isPerm}(hj;  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhEdef List.isPerm {α : Type u} [BEq α] :
List α → List α → Boolh
X  Returns true if l₁ and l₂ are permutations of each other. O(|l₁| * |l₂|).
The relation List.Perm is a logical characterization of permutations. When the BEq α instance corresponds to DecidableEq α, isPerm l₁ l₂ ↔ l₁ ~ l₂ (use the theorem isPerm_iff).uList.any}(hj@  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhAdef List.any {α : Type u} (l : List α) (p : α → Bool) :
Boolh
wReturns true if p returns true for any element of l.
O(|l|). Short-circuits upon encountering the first true.
Examples:uList.any_nil}(hjE  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhOtheorem List.any_nil {α✝ : Type u_1} {f : α✝ → Bool} :
[].any f = falseh
hu
List.any_cons}(hjI  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlh~theorem List.any_cons {α✝ : Type u_1} {a : α✝} {l : List α✝} {f : α✝ → Bool} :
(a :: l).any f = (f a || l.any f)h
huList.all}(hjM  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlh?def List.all {α : Type u} :
List α → (α → Bool) → Boolh
zReturns true if p returns true for every element of l.
O(|l|). Short-circuits upon encountering the first false.
Examples:uList.all_nil}(hjR  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhNtheorem List.all_nil {α✝ : Type u_1} {f : α✝ → Bool} :
[].all f = trueh
hu
List.all_cons}(hjV  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlh~theorem List.all_cons {α✝ : Type u_1} {a : α✝} {l : List α✝} {f : α✝ → Bool} :
(a :: l).all f = (f a && l.all f)h
huList.or}(hjZ  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlh#def List.or (bs : List Bool) :
Boolh
cReturns true if true is an element of the list bs.
O(|bs|). Short-circuits at the first true value.uList.or_nil}(hj_  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlh#theorem List.or_nil :
[].or = falseh
huList.or_cons}(hjc  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhKtheorem List.or_cons {a : Bool} {l : List Bool} :
(a :: l).or = (a || l.or)h
huList.and}(hjg  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlh$def List.and (bs : List Bool) :
Boolh
hReturns true if every element of bs is the value true.
O(|bs|). Short-circuits at the first false value.uList.and_nil}(hjl  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlh$theorem List.and_nil :
[].and = trueh
hu
List.and_cons}(hjp  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhNtheorem List.and_cons {a : Bool} {l : List Bool} :
(a :: l).and = (a && l.and)h
huList.zipWith}(hjt  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhydef List.zipWith {α : Type u} {β : Type v} {γ : Type w} (f : α → β → γ) (xs : List α) (ys : List β) :
List γh
Applies a function to the corresponding elements of two lists, stopping at the end of the shorter list.
O(min |xs| |ys|).
Examples:uList.zipWith_nil_left}(hjy  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhtheorem List.zipWith_nil_left {α : Type u} {β : Type v} {γ : Type w} {l : List β} {f : α → β → γ} :
zipWith f [] l = []h
huList.zipWith_nil_right}(hj}  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhtheorem List.zipWith_nil_right {α : Type u} {β : Type v} {γ : Type w} {l : List α} {f : α → β → γ} :
zipWith f l [] = []h
huList.zipWith_cons_cons}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhtheorem List.zipWith_cons_cons {α : Type u} {β : Type v} {γ : Type w} {a : α} {as : List α} {b : β} {bs : List β} {f : α → β → γ} :
zipWith f (a :: as) (b :: bs) = f a b :: zipWith f as bsh
huList.zip}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhRdef List.zip {α : Type u} {β : Type v} :
List α → List β → List (α × β)h
Combines two lists into a list of pairs in which the first and second components are the corresponding elements of each list. The resulting list is the length of the shorter of the input lists.
O(min |xs| |ys|).
Examples:uList.zip_nil_left}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhStheorem List.zip_nil_left {α : Type u} {β : Type v} {l : List β} :
[].zip l = []h
huList.zip_nil_right}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhTtheorem List.zip_nil_right {α : Type u} {β : Type v} {l : List α} :
l.zip [] = []h
huList.zip_cons_cons}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhtheorem List.zip_cons_cons {α✝ : Type u_1} {a : α✝} {as : List α✝} {α✝¹ : Type u_2} {b : α✝¹} {bs : List α✝¹} :
(a :: as).zip (b :: bs) = (a, b) :: as.zip bsh
huList.zipWithAll}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhdef List.zipWithAll {α : Type u} {β : Type v} {γ : Type w} (f : Option α → Option β → γ) :
List α → List β → List γh
Applies a function to the corresponding elements of both lists, stopping when there are no more elements in either list. If one list is shorter than the other, the function is passed none for the missing elements.
Examples:uList.zipWithAll_nil}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhtheorem List.zipWithAll_nil {α✝ : Type u_1} {α✝¹ : Type u_2} {α✝² : Type u_3} {f : Option α✝ → Option α✝¹ → α✝²} {as : List α✝} :
zipWithAll f as [] = map (fun (a : α✝) => f (some a) none) ash
huList.nil_zipWithAll}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhtheorem List.nil_zipWithAll {α✝ : Type u_1} {α✝¹ : Type u_2} {α✝² : Type u_3} {f : Option α✝ → Option α✝¹ → α✝²} {bs : List α✝¹} :
zipWithAll f [] bs = map (fun (b : α✝¹) => f none (some b)) bsh
huList.zipWithAll_cons_cons}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhX  theorem List.zipWithAll_cons_cons {α✝ : Type u_1} {α✝¹ : Type u_2} {α✝² : Type u_3} {f : Option α✝ → Option α✝¹ → α✝²} {a : α✝} {as : List α✝} {b : α✝¹} {bs : List α✝¹} :
zipWithAll f (a :: as) (b :: bs) = f (some a) (some b) :: zipWithAll f as bsh
hu
List.unzip}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhUdef List.unzip {α : Type u} {β : Type v} (l : List (α × β)) :
List α × List βh
sSeparates a list of pairs into two lists that contain the respective first and second components.
O(|l|).
Examples:uList.unzip_nil}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhHtheorem List.unzip_nil {α : Type u} {β : Type v} :
[].unzip = ([], [])h
huList.unzip_cons}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhtheorem List.unzip_cons {α : Type u} {β : Type v} {t : List (α × β)} {h : α × β} :
(h :: t).unzip = match t.unzip with
  | (as, bs) => (h.fst :: as, h.snd :: bs)h
huList.sum}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlh@def List.sum {α : Type u_1} [Add α] [Zero α] :
List α → αh
5Computes the sum of the elements of a list.
Examples:uList.sum_nil}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhBtheorem List.sum_nil {α : Type u} [Add α] [Zero α] :
[].sum = 0h
hu
List.sum_cons}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhhtheorem List.sum_cons {α : Type u} [Add α] [Zero α] {a : α} {l : List α} :
(a :: l).sum = a + l.sumh
hu
List.range}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlh#def List.range (n : Nat) :
List Nath
YReturns a list of the numbers from 0 to n exclusive, in increasing order.
O(n).
Examples:uList.range_zero}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlh&theorem List.range_zero :
range 0 = []h
huList.range'}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlh>def List.range' (start len : Nat) (step : Nat := 1) :
List Nath
Returns a list of the numbers with the given length len, starting at start and increasing by step at each element.
In other words, List.range' start len step is [start, start+step, ..., start+(len-1)*step].
Examples:uList.range'_zero}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlh>theorem List.range'_zero {s step : Nat} :
range' s 0 step = []h
huList.range'_one}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlh>theorem List.range'_one {s step : Nat} :
range' s 1 step = [s]h
huList.range'_succ}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhatheorem List.range'_succ {s n step : Nat} :
range' s (n + 1) step = s :: range' (s + step) n steph
huList.zipIdx}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhMdef List.zipIdx {α : Type u} (l : List α) (n : Nat := 0) :
List (α × Nat)h
nPairs each element of a list with its index, optionally starting from an index other than 0.
O(|l|).
Examples:uList.zipIdx_nil}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhBtheorem List.zipIdx_nil {α : Type u} {i : Nat} :
[].zipIdx i = []h
huList.zipIdx_cons}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhtheorem List.zipIdx_cons {α✝ : Type u_1} {a : α✝} {as : List α✝} {i : Nat} :
(a :: as).zipIdx i = (a, i) :: as.zipIdx (i + 1)h
hu	List.min?}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlh<def List.min? {α : Type u} [Min α] :
List α → Option αh
^Returns the smallest element of the list if it is not empty, or none if it is empty.
Examples:u	List.max?}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlh<def List.max? {α : Type u} [Max α] :
List α → Option αh
]Returns the largest element of the list if it is not empty, or none if it is empty.
Examples:uList.intersperse}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.html      hEdef List.intersperse {α : Type u} (sep : α) (l : List α) :
List αh
Alternates the elements of l with sep.
O(|l|).
List.intercalate is a similar function that alternates a separator list with elements of a list of lists.
Examples:uList.intersperse_nil}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhOtheorem List.intersperse_nil {α : Type u} {sep : α} :
intersperse sep [] = []h
huList.intersperse_single}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhVtheorem List.intersperse_single {α : Type u} {x sep : α} :
intersperse sep [x] = [x]h
huList.intersperse_cons₂}(hj  hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhtheorem List.intersperse_cons₂ {α : Type u} {x y : α} {zs : List α} {sep : α} :
intersperse sep (x :: y :: zs) = x :: sep :: intersperse sep (y :: zs)h
huList.intercalate}(hj   hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhRdef List.intercalate {α : Type u} (sep : List α) (xs : List (List α)) :
List αh
Alternates the lists in xs with the separator sep, appending them. The resulting list is flattened.
O(|xs|).
List.intersperse is a similar function that alternates a separator element with the elements of a list.
Examples:uList.eraseDupsBy}(hj   hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhVdef List.eraseDupsBy {α : Type u_1} (r : α → α → Bool) (as : List α) :
List αh
Erases duplicated elements in the list, using a given comparison function, keeping the first occurrence of duplicated elements.
O(|l|^2).
Examples:uList.eraseDups}(hj
   hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhDdef List.eraseDups {α : Type u_1} [BEq α] (as : List α) :
List αh
pErases duplicated elements in the list, keeping the first occurrence of duplicated elements.
O(|l|^2).
Examples:uList.eraseRepsBy}(hj   hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhSdef List.eraseRepsBy {α : Type u_1} (r : α → α → Bool) :
List α → List αh
tErases repeated elements, using a given comparison function, keeping the first element of each run.
O(|l|).
Example:uList.eraseReps}(hj   hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhDdef List.eraseReps {α : Type u_1} [BEq α] (as : List α) :
List αh
QErases repeated elements, keeping the first element of each run.
O(|l|).
Example:u	List.span}(hj   hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhQdef List.span {α : Type u} (p : α → Bool) (as : List α) :
List α × List αh
Splits a list into the the longest initial segment for which p returns true, paired with the remainder of the list.
O(|l|).
Examples:uList.splitBy}(hj!   hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhTdef List.splitBy {α : Type u} (R : α → α → Bool) :
List α → List (List α)h
sSplits a list into the longest segments in which each pair of adjacent elements are related by R.
O(|l|).
Examples:uList.removeAll}(hj&   hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhEdef List.removeAll {α : Type u} [BEq α] (xs ys : List α) :
List αh
LRemoves all elements of xs that are present in ys.
O(|xs| * |ys|).
Examples:uList.nil_removeAll}(hj+   hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhWtheorem List.nil_removeAll {α : Type u} [BEq α] {ys : List α} :
[].removeAll ys = []h
huList.length_add_eq_lengthTRAux}(hj/   hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhptheorem List.length_add_eq_lengthTRAux {α : Type u} {as : List α} {n : Nat} :
as.length + n = as.lengthTRAux nh
huList.length_eq_lengthTR}(hj3   hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlh5theorem List.length_eq_lengthTR :
@length = @lengthTRh
hu
List.mapTR}(hj7   hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhSdef List.mapTR {α : Type u} {β : Type v} (f : α → β) (as : List α) :
List βh
Applies a function to each element of the list, returning the resulting list of values.
O(|l|). This is the tail-recursive variant of List.map, used in runtime code.
Examples:uList.mapTR_loop_eq}(hj<   hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhtheorem List.mapTR_loop_eq {α : Type u} {β : Type v} {f : α → β} {as : List α} {bs : List β} :
mapTR.loop f as bs = bs.reverse ++ map f ash
huList.map_eq_mapTR}(hj@   hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlh)theorem List.map_eq_mapTR :
@map = @mapTRh
hu
List.filterTR}(hjD   hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhJdef List.filterTR {α : Type u} (p : α → Bool) (as : List α) :
List αh
Returns the list of elements in l for which p returns true.
O(|l|). This is a tail-recursive version of List.filter, used at runtime.
Examples:uList.filterTR_loop_eq}(hjI   hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhtheorem List.filterTR_loop_eq {α : Type u} {p : α → Bool} {as bs : List α} :
filterTR.loop p as bs = bs.reverse ++ filter p ash
huList.filter_eq_filterTR}(hjM   hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlh5theorem List.filter_eq_filterTR :
@filter = @filterTRh
huList.replicateTR}(hjQ   hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlh?def List.replicateTR {α : Type u} (n : Nat) (a : α) :
List αh
_Creates a list that contains n copies of a.
This is a tail-recursive version of List.replicate.u"List.replicateTR_loop_replicate_eq}(hjV   hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhtheorem List.replicateTR_loop_replicate_eq {α : Type u} {a : α} {m n : Nat} :
replicateTR.loop a n (replicate m a) = replicate (n + m) ah
huList.replicateTR_loop_eq}(hjZ   hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhtheorem List.replicateTR_loop_eq {α✝ : Type u_1} {a : α✝} {acc : List α✝} (n : Nat) :
replicateTR.loop a n acc = replicate n a ++ acch
huList.replicate_eq_replicateTR}(hj^   hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhAtheorem List.replicate_eq_replicateTR :
@replicate = @replicateTRh
huList.leftpadTR}(hjb   hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhKdef List.leftpadTR {α : Type u} (n : Nat) (a : α) (l : List α) :
List αh
Pads l : List α on the left with repeated occurrences of a : α until it is of length n. If l already has at least n elements, it is returned unmodified.
This is a tail-recursive version of List.leftpad, used at runtime.
Examples:uList.leftpad_eq_leftpadTR}(hjg   hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlh9theorem List.leftpad_eq_leftpadTR :
@leftpad = @leftpadTRh
huList.unzipTR}(hjk   hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhWdef List.unzipTR {α : Type u} {β : Type v} (l : List (α × β)) :
List α × List βh
Separates a list of pairs into two lists that contain the respective first and second components.
O(|l|). This is a tail-recursive version of List.unzip that's used at runtime.
Examples:uList.unzip_eq_unzipTR}(hjp   hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlh1theorem List.unzip_eq_unzipTR :
@unzip = @unzipTRh
hu
List.range'TR}(hjt   hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlh:def List.range'TR (s n : Nat) (step : Nat := 1) :
List Nath
X  Returns a list of the numbers with the given length len, starting at start and increasing by step at each element.
In other words, List.range'TR start len step is [start, start+step, ..., start+(len-1)*step].
This is a tail-recursive version of List.range'.
Examples:uList.range'_eq_range'TR}(hjy   hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlh5theorem List.range'_eq_range'TR :
@range' = @range'TRh
huList.intersperseTR}(hj}   hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhGdef List.intersperseTR {α : Type u} (sep : α) (l : List α) :
List αh
Alternates the elements of l with sep.
O(|l|).
This is a tail-recursive version of List.intersperse, used at runtime.
Examples:u!List.intersperse_eq_intersperseTR}(hj   hNhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Basic.htmlhItheorem List.intersperse_eq_intersperseTR :
@intersperse = @intersperseTRh
huList.zipWith_comm}(hj   hLhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Zip.htmlhtheorem List.zipWith_comm {α : Type u_1} {β : Type u_2} {γ : Type u_3} {f : α → β → γ} {as : List α} {bs : List β} :
zipWith f as bs = zipWith (fun (b : β) (a : α) => f a b) bs ash
huList.zipWith_comm_of_comm}(hj   hLhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Zip.htmlhtheorem List.zipWith_comm_of_comm {α : Type u_1} {β : Type u_2} {f : α → α → β} (comm : ∀ (x y : α), f x y = f y x) {l l' : List α} :
zipWith f l l' = zipWith f l' lh
huList.zipWith_self}(hj   hLhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Zip.htmlhtheorem List.zipWith_self {α : Type u_1} {δ : Type u_2} {f : α → α → δ} {l : List α} :
zipWith f l l = map (fun (a : α) => f a a) lh
huList.getElem?_zipWith}(hj   hLhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Zip.htmlhtheorem List.getElem?_zipWith {α : Type u_1} {β : Type u_2} {γ : Type u_3} {as : List α} {bs : List β} {f : α → β → γ} {i : Nat} :
(zipWith f as bs)[i]? = match as[i]?, bs[i]? with
  | some a, some b => some (f a b)
  | x, x_1 => noneh
^See also getElem?_zipWith' for a variant using Option.map and Option.bind rather than a match.uList.getElem?_zipWith'}(hj   hLhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Zip.htmlhtheorem List.getElem?_zipWith' {α : Type u_1} {β : Type u_2} {γ : Type u_3} {l₁ : List α} {l₂ : List β} {f : α → β → γ} {i : Nat} :
(zipWith f l₁ l₂)[i]? = (Option.map f l₁[i]?).bind fun (g : β → γ) => Option.map g l₂[i]?h
QVariant of getElem?_zipWith using Option.map and Option.bind rather than a match.uList.getElem?_zipWith_eq_some}(hj   hLhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Zip.htmlhX  theorem List.getElem?_zipWith_eq_some {α : Type u_1} {β : Type u_2} {γ : Type u_3} {f : α → β → γ} {l₁ : List α} {l₂ : List β} {z : γ} {i : Nat} :
(zipWith f l₁ l₂)[i]? = some z ↔ ∃ (x : α), ∃ (y : β), l₁[i]? = some x ∧ l₂[i]? = some y ∧ f x y = zh
huList.getElem?_zip_eq_some}(hj   hLhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Zip.htmlhtheorem List.getElem?_zip_eq_some {α : Type u_1} {β : Type u_2} {l₁ : List α} {l₂ : List β} {z : α × β} {i : Nat} :
(l₁.zip l₂)[i]? = some z ↔ l₁[i]? = some z.fst ∧ l₂[i]? = some z.sndh
huList.head?_zipWith}(hj   hLhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Zip.htmlhtheorem List.head?_zipWith {α : Type u_1} {β : Type u_2} {γ : Type u_3} {as : List α} {bs : List β} {f : α → β → γ} :
(zipWith f as bs).head? = match as.head?, bs.head? with
  | some a, some b => some (f a b)
  | x, x_1 => noneh
huList.head_zipWith}(hj   hLhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Zip.htmlhtheorem List.head_zipWith {α : Type u_1} {β : Type u_2} {γ : Type u_3} {as : List α} {bs : List β} {f : α → β → γ} (h : zipWith f as bs ≠ []) :
(zipWith f as bs).head h = f (as.head ⋯) (bs.head ⋯)h
huu(List.zipWith_map}(hj   hLhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Zip.htmlhX$  theorem List.zipWith_map {γ : Type u_1} {δ : Type u_2} {α : Type u_3} {β : Type u_4} {μ : Type u_5} {f : γ → δ → μ} {g : α → γ} {h : β → δ} {l₁ : List α} {l₂ : List β} :
zipWith f (map g l₁) (map h l₂) = zipWith (fun (a : α) (b : β) => f (g a) (h b)) l₁ l₂h
huList.zipWith_map_left}(hj   hLhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Zip.htmlhX   theorem List.zipWith_map_left {α : Type u_1} {β : Type u_2} {α' : Type u_3} {γ : Type u_4} {l₁ : List α} {l₂ : List β} {f : α → α'} {g : α' → β → γ} :
zipWith g (map f l₁) l₂ = zipWith (fun (a : α) (b : β) => g (f a) b) l₁ l₂h
huList.zipWith_map_right}(hj   hLhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Zip.htmlhX  theorem List.zipWith_map_right {α : Type u_1} {β : Type u_2} {β' : Type u_3} {γ : Type u_4} {l₁ : List α} {l₂ : List β} {f : β → β'} {g : α → β' → γ} :
zipWith g l₁ (map f l₂) = zipWith (fun (a : α) (b : β) => g a (f b)) l₁ l₂h
huList.zipWith_foldr_eq_zip_foldr}(hj   hLhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Zip.htmlhX1  theorem List.zipWith_foldr_eq_zip_foldr {α : Type u_1} {β : Type u_2} {γ : Type u_3} {δ : Type u_4} {l₁ : List α} {l₂ : List β} {f : α → β → γ} {i : δ} {g : γ → δ → δ} :
foldr g i (zipWith f l₁ l₂) = foldr (fun (p : α × β) (r : δ) => g (f p.fst p.snd) r) i (l₁.zip l₂)h
huList.zipWith_foldl_eq_zip_foldl}(hj   hLhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Zip.htmlhX1  theorem List.zipWith_foldl_eq_zip_foldl {α : Type u_1} {β : Type u_2} {γ : Type u_3} {δ : Type u_4} {l₁ : List α} {l₂ : List β} {f : α → β → γ} {i : δ} {g : δ → γ → δ} :
foldl g i (zipWith f l₁ l₂) = foldl (fun (r : δ) (p : α × β) => g r (f p.fst p.snd)) i (l₁.zip l₂)h
huList.zipWith_eq_nil_iff}(hj   hLhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Zip.htmlhtheorem List.zipWith_eq_nil_iff {α : Type u_1} {β : Type u_2} {γ : Type u_3} {f : α → β → γ} {l : List α} {l' : List β} :
zipWith f l l' = [] ↔ l = [] ∨ l' = []h
huList.map_zipWith}(hj   hLhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Zip.htmlhtheorem List.map_zipWith {α : Type u_1} {β : Type u_2} {γ : Type u_3} {δ : Type u_4} {f : α → β} {g : γ → δ → α} {l : List γ} {l' : List δ} :
map f (zipWith g l l') = zipWith (fun (x : γ) (y : δ) => f (g x y)) l l'h
huList.take_zipWith}(hj   hLhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Zip.htmlhtheorem List.take_zipWith {α✝ : Type u_1} {α✝¹ : Type u_2} {α✝² : Type u_3} {f : α✝ → α✝¹ → α✝²} {l : List α✝} {l' : List α✝¹} {i : Nat} :
take i (zipWith f l l') = zipWith f (take i l) (take i l')h
huList.drop_zipWith}(hj   hLhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Zip.htmlhtheorem List.drop_zipWith {α✝ : Type u_1} {α✝¹ : Type u_2} {α✝² : Type u_3} {f : α✝ → α✝¹ → α✝²} {l : List α✝} {l' : List α✝¹} {i : Nat} :
drop i (zipWith f l l') = zipWith f (drop i l) (drop i l')h
huList.tail_zipWith}(hj   hLhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Zip.htmlhtheorem List.tail_zipWith {α✝ : Type u_1} {α✝¹ : Type u_2} {α✝² : Type u_3} {f : α✝ → α✝¹ → α✝²} {l : List α✝} {l' : List α✝¹} :
(zipWith f l l').tail = zipWith f l.tail l'.tailh
huList.zipWith_append}(hj   hLhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Zip.htmlhX  theorem List.zipWith_append {α : Type u_1} {β : Type u_2} {γ : Type u_3} {f : α → β → γ} {l₁ l₁' : List α} {l₂ l₂' : List β} (h : l₁.length = l₂.length) :
zipWith f (l₁ ++ l₁') (l₂ ++ l₂') = zipWith f l₁ l₂ ++ zipWith f l₁' l₂'h
huList.zipWith_eq_cons_iff}(hj   hLhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Zip.htmlhXa  theorem List.zipWith_eq_cons_iff {α : Type u_1} {β : Type u_2} {γ : Type u_3} {g : γ} {l : List γ} {f : α → β → γ} {l₁ : List α} {l₂ : List β} :
zipWith f l₁ l₂ = g :: l ↔ ∃ (a : α), ∃ (l₁' : List α), ∃ (b : β), ∃ (l₂' : List β), l₁ = a :: l₁' ∧ l₂ = b :: l₂' ∧ g = f a b ∧ l = zipWith f l₁' l₂'h
huList.zipWith_eq_append_iff}(hj   hLhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Zip.htmlhX  theorem List.zipWith_eq_append_iff {α : Type u_1} {β : Type u_2} {γ : Type u_3} {l₁' l₂' : List γ} {f : α → β → γ} {l₁ : List α} {l₂ : List β} :
zipWith f l₁ l₂ = l₁' ++ l₂' ↔ ∃ (ws : List α), ∃ (xs : List α), ∃ (ys : List β), ∃ (zs : List β), ws.length = ys.length ∧ l₁ = ws ++ xs ∧ l₂ = ys ++ zs ∧ l₁' = zipWith f ws ys ∧ l₂' = zipWith f xs zsh
huList.zipWith_replicate'}(hj   hLhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Zip.htmlhtheorem List.zipWith_replicate' {α : Type u_1} {β : Type u_2} {α✝ : Type u_3} {f : α → β → α✝} {a : α} {b : β} {n : Nat} :
zipWith f (replicate n a) (replicate n b) = replicate n (f a b)h
gSee also List.zipWith_replicate in Init.Data.List.TakeDrop for a generalization with different lengths.uList.map_uncurry_zip_eq_zipWith}(hj   hLhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Zip.htmlhtheorem List.map_uncurry_zip_eq_zipWith {α : Type u_1} {β : Type u_2} {γ : Type u_3} {f : α → β → γ} {l : List α} {l' : List β} :
map (Function.uncurry f) (l.zip l') = zipWith f l l'h
huList.map_zip_eq_zipWith}(hj   hLhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Zip.htmlhtheorem List.map_zip_eq_zipWith {α : Type u_1} {β : Type u_2} {γ : Type u_3} {f : α × β → γ} {l : List α} {l' : List β} :
map f (l.zip l') = zipWith (Function.curry f) l l'h
huList.zip_eq_zipWith}(hj   hLhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Zip.htmlhtheorem List.zip_eq_zipWith {α : Type u_1} {β : Type u_2} {l₁ : List α} {l₂ : List β} :
l₁.zip l₂ = zipWith Prod.mk l₁ l₂h
huList.zip_map}(hj   hLhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Zip.htmlhtheorem List.zip_map {α : Type u_1} {γ : Type u_2} {β : Type u_3} {δ : Type u_4} {f : α → γ} {g : β → δ} {l₁ : List α} {l₂ : List β} :
(map f l₁).zip (map g l₂) = map (Prod.map f g) (l₁.zip l₂)h
huList.zip_map_left}(hj   hLhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Zip.htmlhtheorem List.zip_map_left {α : Type u_1} {γ : Type u_2} {β : Type u_3} {f : α → γ} {l₁ : List α} {l₂ : List β} :
(map f l₁).zip l₂ = map (Prod.map f id) (l₁.zip l₂)h
huList.zip_map_right}(hj   hLhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Zip.htmlhtheorem List.zip_map_right {β : Type u_1} {γ : Type u_2} {α : Type u_3} {f : β → γ} {l₁ : List α} {l₂ : List β} :
l₁.zip (map f l₂) = map (Prod.map id f) (l₁.zip l₂)h
hu
List.tail_zip}(hj   hLhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Zip.htmlhtheorem List.tail_zip {α : Type u_1} {β : Type u_2} {l₁ : List α} {l₂ : List β} :
(l₁.zip l₂).tail = l₁.tail.zip l₂.tailh
huList.zip_append}(hj!  hLhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Zip.htmlhtheorem List.zip_append {α : Type u_1} {β : Type u_2} {l₁ r₁ : List α} {l₂ r₂ : List β} (_h : l₁.length = l₂.length) :
(l₁ ++ r₁).zip (l₂ ++ r₂) = l₁.zip l₂ ++ r₁.zip r₂h
hu
List.zip_map'}(hj!  hLhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Zip.htmlhtheorem List.zip_map' {α : Type u_1} {β : Type u_2} {γ : Type u_3} {f : α → β} {g : α → γ} {l : List α} :
(map f l).zip (map g l) = map (fun (a : α) => (f a, g a)) lh
huList.of_mem_zip}(hj	!  hLhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Zip.htmlhtheorem List.of_mem_zip {α : Type u_1} {β : Type u_2} {a : α} {b : β} {l₁ : List α} {l₂ : List β} :
(a, b) ∈ l₁.zip l₂ → a ∈ l₁ ∧ b ∈ l₂h
huList.map_fst_zip}(hj
!  hLhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Zip.htmlhtheorem List.map_fst_zip {α : Type u_1} {β : Type u_2} {l₁ : List α} {l₂ : List β} :
l₁.length ≤ l₂.length → map Prod.fst (l₁.zip l₂) = l₁h
huList.map_snd_zip}(hj!  hLhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Zip.htmlhtheorem List.map_snd_zip {α : Type u_1} {β : Type u_2} {l₁ : List α} {l₂ : List β} :
l₂.length ≤ l₁.length → map Prod.snd (l₁.zip l₂) = l₂h
huList.map_prod_left_eq_zip}(hj!  hLhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Zip.htmlhtheorem List.map_prod_left_eq_zip {α : Type u_1} {β : Type u_2} {l : List α} {f : α → β} :
map (fun (x : α) => (x, f x)) l = l.zip (map f l)h
huList.map_prod_right_eq_zip}(hj!  hLhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Zip.htmlhtheorem List.map_prod_right_eq_zip {α : Type u_1} {β : Type u_2} {l : List α} {f : α → β} :
map (fun (x : α) => (f x, x)) l = (map f l).zip lh
huList.zip_eq_nil_iff}(hj!  hLhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Zip.htmlhtheorem List.zip_eq_nil_iff {α : Type u_1} {β : Type u_2} {l₁ : List α} {l₂ : List β} :
l₁.zip l₂ = [] ↔ l₁ = [] ∨ l₂ = []h
huList.zip_eq_cons_iff}(hj!!  hLhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Zip.htmlhX  theorem List.zip_eq_cons_iff {α : Type u_1} {β : Type u_2} {a : α} {b : β} {l : List (α × β)} {l₁ : List α} {l₂ : List β} :
l₁.zip l₂ = (a, b) :: l ↔ ∃ (l₁' : List α), ∃ (l₂' : List β), l₁ = a :: l₁' ∧ l₂ = b :: l₂' ∧ l = l₁'.zip l₂'h
huList.zip_eq_append_iff}(hj%!  hLhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Zip.htmlhX_  theorem List.zip_eq_append_iff {α : Type u_1} {β : Type u_2} {l₁' l₂' : List (α × β)} {l₁ : List α} {l₂ : List β} :
l₁.zip l₂ = l₁' ++ l₂' ↔ ∃ (ws : List α), ∃ (xs : List α), ∃ (ys : List β), ∃ (zs : List β), ws.length = ys.length ∧ l₁ = ws ++ xs ∧ l₂ = ys ++ zs ∧ l₁' = ws.zip ys ∧ l₂' = xs.zip zsh
huList.zip_replicate'}(hj)!  hLhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Zip.htmlhtheorem List.zip_replicate' {α : Type u_1} {β : Type u_2} {a : α} {b : β} {n : Nat} :
(replicate n a).zip (replicate n b) = replicate n (a, b)h
cSee also List.zip_replicate in Init.Data.List.TakeDrop for a generalization with different lengths.uList.getElem?_zipWithAll}(hj.!  hLhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Zip.htmlhX  theorem List.getElem?_zipWithAll {α : Type u_1} {β : Type u_2} {γ : Type u_3} {as : List α} {bs : List β} {f : Option α → Option β → γ} {i : Nat} :
(zipWithAll f as bs)[i]? = match as[i]?, bs[i]? with
  | none, none => none
  | a?, b? => some (f a? b?)h
huList.head?_zipWithAll}(hj2!  hLhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Zip.htmlhX  theorem List.head?_zipWithAll {α : Type u_1} {β : Type u_2} {γ : Type u_3} {as : List α} {bs : List β} {f : Option α → Option β → γ} :
(zipWithAll f as bs).head? = match as.head?, bs.head? with
  | none, none => none
  | a?, b? => some (f a? b?)h
huList.head_zipWithAll}(hj6!  hLhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Zip.htmlhtheorem List.head_zipWithAll {α : Type u_1} {β : Type u_2} {γ : Type u_3} {as : List α} {bs : List β} {f : Option α → Option β → γ} (h : zipWithAll f as bs ≠ []) :
(zipWithAll f as bs).head h = f as.head? bs.head?h
huList.tail_zipWithAll}(hj:!  hLhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Zip.htmlhtheorem List.tail_zipWithAll {α : Type u_1} {β : Type u_2} {γ : Type u_3} {as : List α} {bs : List β} {f : Option α → Option β → γ} :
(zipWithAll f as bs).tail = zipWithAll f as.tail bs.tailh
huList.zipWithAll_map}(hj>!  hLhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Zip.htmlhXQ  theorem List.zipWithAll_map {γ : Type u_1} {δ : Type u_2} {α : Type u_1} {β : Type u_2} {μ : Type u_3} {f : Option γ → Option δ → μ} {g : α → γ} {h : β → δ} {l₁ : List α} {l₂ : List β} :
zipWithAll f (map g l₁) (map h l₂) = zipWithAll (fun (a : Option α) (b : Option β) => f (g <$> a) (h <$> b)) l₁ l₂h
huList.zipWithAll_map_left}(hjB!  hLhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Zip.htmlhX)  theorem List.zipWithAll_map_left {α : Type u_1} {β : Type u_2} {α' : Type u_1} {γ : Type u_3} {l₁ : List α} {l₂ : List β} {f : α → α'} {g : Option α' → Option β → γ} :
zipWithAll g (map f l₁) l₂ = zipWithAll (fun (a : Option α) (b : Option β) => g (f <$> a) b) l₁ l₂h
huList.zipWithAll_map_right}(hjF!  hLhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Zip.htmlhX  theorem List.zipWithAll_map_right {α : Type u_1} {β β' : Type u_2} {γ : Type u_3} {l₁ : List α} {l₂ : List β} {f : β → β'} {g : Option α → Option β' → γ} :
zipWithAll g l₁ (map f l₂) = zipWithAll (fun (a : Option α) (b : Option β) => g a (f <$> b)) l₁ l₂h
huList.map_zipWithAll}(hjJ!  hLhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Zip.htmlhX  theorem List.map_zipWithAll {α : Type u_1} {β : Type u_2} {γ : Type u_3} {δ : Type u_4} {f : α → β} {g : Option γ → Option δ → α} {l : List γ} {l' : List δ} :
map f (zipWithAll g l l') = zipWithAll (fun (x : Option γ) (y : Option δ) => f (g x y)) l l'h
huList.zipWithAll_replicate}(hjN!  hLhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Zip.htmlhtheorem List.zipWithAll_replicate {α : Type u_1} {β : Type u_2} {α✝ : Type u_3} {f : Option α → Option β → α✝} {a : α} {b : β} {n : Nat} :
zipWithAll f (replicate n a) (replicate n b) = replicate n (f (some a) (some b))h
huList.unzip_fst}(hjR!  hLhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Zip.htmlhwtheorem List.unzip_fst {α✝ : Type u_1} {β✝ : Type u_2} {l : List (α✝ × β✝)} :
l.unzip.fst = map Prod.fst lh
huList.unzip_snd}(hjV!  hLhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Zip.htmlhwtheorem List.unzip_snd {α✝ : Type u_1} {β✝ : Type u_2} {l : List (α✝ × β✝)} :
l.unzip.snd = map Prod.snd lh
huList.unzip_eq_map}(hjZ!  hLhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Zip.htmlh|theorem List.unzip_eq_map {α : Type u_1} {β : Type u_2} {l : List (α × β)} :
l.unzip = (map Prod.fst l, map Prod.snd l)h
huList.zip_unzip}(hj^!  hLhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Zip.htmlhntheorem List.zip_unzip {α : Type u_1} {β : Type u_2} (l : List (α × β)) :
l.unzip.fst.zip l.unzip.snd = lh
huList.unzip_zip_left}(hjb!  hLhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Zip.htmlhtheorem List.unzip_zip_left {α : Type u_1} {β : Type u_2} {l₁ : List α} {l₂ : List β} :
l₁.length ≤ l₂.length → (l₁.zip l₂).unzip.fst = l₁h
huList.unzip_zip_right}(hjf!  hLhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Zip.htmlhtheorem List.unzip_zip_right {α : Type u_1} {β : Type u_2} {l₁ : List α} {l₂ : List β} :
l₂.length ≤ l₁.length → (l₁.zip l₂).unzip.snd = l₂h
huList.unzip_zip}(hjj!  hLhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Zip.htmlhtheorem List.unzip_zip {α : Type u_1} {β : Type u_2} {l₁ : List α} {l₂ : List β} (h : l₁.length = l₂.length) :
(l₁.zip l₂).unzip = (l₁, l₂)h
huList.zip_of_prod}(hjn!  hLhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Zip.htmlhtheorem List.zip_of_prod {α : Type u_1} {β : Type u_2} {l : List α} {l' : List β} {xs : List (α × β)} (hl : map Prod.fst xs = l) (hr : map Prod.snd xs = l') :
xs = l.zip l'h
huList.tail_zip_fst}(hjr!  hLhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Zip.htmlhutheorem List.tail_zip_fst {α : Type u_1} {β : Type u_2} {l : List (α × β)} :
l.unzip.fst.tail = l.tail.unzip.fsth
huList.tail_zip_snd}(hjv!  hLhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Zip.htmlhutheorem List.tail_zip_snd {α : Type u_1} {β : Type u_2} {l : List (α × β)} :
l.unzip.snd.tail = l.tail.unzip.sndh
huList.unzip_replicate}(hjz!  hLhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Zip.htmlhtheorem List.unzip_replicate {α : Type u_1} {β : Type u_2} {n : Nat} {a : α} {b : β} :
(replicate n (a, b)).unzip = (replicate n a, replicate n b)h
huList.isPrefixOf_cons₂_self}(hj~!  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhtheorem List.isPrefixOf_cons₂_self {α : Type u_1} [BEq α] {as bs : List α} [LawfulBEq α] {a : α} :
(a :: as).isPrefixOf (a :: bs) = as.isPrefixOf bsh
huList.isPrefixOf_length_pos_nil}(hj!  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhztheorem List.isPrefixOf_length_pos_nil {α : Type u_1} [BEq α] {l : List α} (h : 0 < l.length) :
l.isPrefixOf [] = falseh
huList.isPrefixOf_replicate}(hj!  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhtheorem List.isPrefixOf_replicate {α : Type u_1} [BEq α] {l : List α} {n : Nat} {a : α} :
l.isPrefixOf (replicate n a) = (decide (l.length ≤ n) && l.all fun (x : α) => x == a)h
huList.isSuffixOf_cons_nil}(hj!  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhstheorem List.isSuffixOf_cons_nil {α : Type u_1} [BEq α] {a : α} {as : List α} :
(a :: as).isSuffixOf [] = falseh
huList.isSuffixOf_replicate}(hj!  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhtheorem List.isSuffixOf_replicate {α : Type u_1} [BEq α] {l : List α} {n : Nat} {a : α} :
l.isSuffixOf (replicate n a) = (decide (l.length ≤ n) && l.all fun (x : α) => x == a)h
huList.subset_def}(hj!  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhytheorem List.subset_def {α : Type u_1} {l₁ l₂ : List α} :
l₁ ⊆ l₂ ↔ ∀ {a : α}, a ∈ l₁ → a ∈ l₂h
huList.nil_subset}(hj!  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlh@theorem List.nil_subset {α : Type u_1} (l : List α) :
[] ⊆ lh
huList.instTransSubsetMem}(hj!  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhinstance List.instTransSubsetMem {α : Type u_1} :
Trans (fun (l₁ l₂ : List α) => l₂ ⊆ l₁) Membership.mem Membership.memh
huList.instTransSubset}(hj!  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhJinstance List.instTransSubset {α : Type u_1} :
Trans Subset Subset Subseth
huList.subset_cons_self}(hj!  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhStheorem List.subset_cons_self {α : Type u_1} (a : α) (l : List α) :
l ⊆ a :: lh
huList.subset_of_cons_subset}(hj!  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhxtheorem List.subset_of_cons_subset {α : Type u_1} {a : α} {l₁ l₂ : List α} :
a :: l₁ ⊆ l₂ → l₁ ⊆ l₂h
huList.subset_cons_of_subset}(hj!  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhxtheorem List.subset_cons_of_subset {α : Type u_1} (a : α) {l₁ l₂ : List α} :
l₁ ⊆ l₂ → l₁ ⊆ a :: l₂h
huList.cons_subset_cons}(hj!  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhztheorem List.cons_subset_cons {α : Type u_1} {l₁ l₂ : List α} (a : α) (s : l₁ ⊆ l₂) :
a :: l₁ ⊆ a :: l₂h
huList.cons_subset}(hj!  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhqtheorem List.cons_subset {α✝ : Type u_1} {a : α✝} {l m : List α✝} :
a :: l ⊆ m ↔ a ∈ m ∧ l ⊆ mh
huList.subset_nil}(hj!  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhKtheorem List.subset_nil {α : Type u_1} {l : List α} :
l ⊆ [] ↔ l = []h
huList.eq_nil_of_subset_nil}(hj!  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhUtheorem List.eq_nil_of_subset_nil {α : Type u_1} {l : List α} :
l ⊆ [] → l = []h
huList.map_subset}(hj!  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhtheorem List.map_subset {α : Type u_1} {β : Type u_2} {l₁ l₂ : List α} (f : α → β) (h : l₁ ⊆ l₂) :
map f l₁ ⊆ map f l₂h
huList.filter_subset}(hj!  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhtheorem List.filter_subset {α : Type u_1} {l₁ l₂ : List α} (p : α → Bool) (H : l₁ ⊆ l₂) :
filter p l₁ ⊆ filter p l₂h
huList.filterMap_subset}(hj!  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhtheorem List.filterMap_subset {α : Type u_1} {β : Type u_2} {l₁ l₂ : List α} (f : α → Option β) (H : l₁ ⊆ l₂) :
filterMap f l₁ ⊆ filterMap f l₂h
huList.subset_append_left}(hj!  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlh]theorem List.subset_append_left {α : Type u_1} (l₁ l₂ : List α) :
l₁ ⊆ l₁ ++ l₂h
huList.subset_append_right}(hj!  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlh^theorem List.subset_append_right {α : Type u_1} (l₁ l₂ : List α) :
l₂ ⊆ l₁ ++ l₂h
hu!List.subset_append_of_subset_left}(hj!  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhtheorem List.subset_append_of_subset_left {α : Type u_1} {l l₁ : List α} (l₂ : List α) :
l ⊆ l₁ → l ⊆ l₁ ++ l₂h
hu"List.subset_append_of_subset_right}(hj!  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhtheorem List.subset_append_of_subset_right {α : Type u_1} {l l₂ : List α} (l₁ : List α) :
l ⊆ l₂ → l ⊆ l₁ ++ l₂h
huList.append_subset}(hj!  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhutheorem List.append_subset {α : Type u_1} {l₁ l₂ l : List α} :
l₁ ++ l₂ ⊆ l ↔ l₁ ⊆ l ∧ l₂ ⊆ lh
huList.replicate_subset}(hj!  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhztheorem List.replicate_subset {α : Type u_1} {n : Nat} {a : α} {l : List α} :
replicate n a ⊆ l ↔ n = 0 ∨ a ∈ lh
huList.subset_replicate}(hj!  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhtheorem List.subset_replicate {α : Type u_1} {n : Nat} {a : α} {l : List α} (h : n ≠ 0) :
l ⊆ replicate n a ↔ ∀ (x : α), x ∈ l → x = ah
huList.reverse_subset}(hj!  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhktheorem List.reverse_subset {α : Type u_1} {l₁ l₂ : List α} :
l₁.reverse ⊆ l₂ ↔ l₁ ⊆ l₂h
huList.subset_reverse}(hj!  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhktheorem List.subset_reverse {α : Type u_1} {l₁ l₂ : List α} :
l₁ ⊆ l₂.reverse ↔ l₁ ⊆ l₂h
huList.nil_sublist}(hj!  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhEtheorem List.nil_sublist {α : Type u_1} (l : List α) :
[].Sublist lh
huList.instTransSublist}(hj!  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhNinstance List.instTransSublist {α : Type u_1} :
Trans Sublist Sublist Sublisth
huList.sublist_cons_self}(hj!  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhZtheorem List.sublist_cons_self {α : Type u_1} (a : α) (l : List α) :
l.Sublist (a :: l)h
huList.sublist_of_cons_sublist}(hj!  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhtheorem List.sublist_of_cons_sublist {α✝ : Type u_1} {a : α✝} {l₁ l₂ : List α✝} :
(a :: l₁).Sublist l₂ → l₁.Sublist l₂h
huList.cons_sublist_cons}(hj!  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhtheorem List.cons_sublist_cons {α✝ : Type u_1} {a : α✝} {l₁ l₂ : List α✝} :
(a :: l₁).Sublist (a :: l₂) ↔ l₁.Sublist l₂h
huList.sublist_or_mem_of_sublist}(hj"  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhtheorem List.sublist_or_mem_of_sublist {α✝ : Type u_1} {l l₁ : List α✝} {a : α✝} {l₂ : List α✝} (h : l.Sublist (l₁ ++ a :: l₂)) :
l.Sublist (l₁ ++ l₂) ∨ a ∈ lh
huList.instTransSublistSubset}(hj"  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhRinstance List.instTransSublistSubset {α : Type u_1} :
Trans Sublist Subset Subseth
huList.instTransSubsetSublist}(hj
"  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhRinstance List.instTransSubsetSublist {α : Type u_1} :
Trans Subset Sublist Subseth
huList.instTransSublistMem}(hj"  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhinstance List.instTransSublistMem {α : Type u_1} :
Trans (fun (l₁ l₂ : List α) => l₂.Sublist l₁) Membership.mem Membership.memh
huList.mem_of_cons_sublist}(hj"  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlh{theorem List.mem_of_cons_sublist {α : Type u_1} {a : α} {l₁ l₂ : List α} (s : (a :: l₁).Sublist l₂) :
a ∈ l₂h
huList.sublist_nil}(hj"  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhPtheorem List.sublist_nil {α : Type u_1} {l : List α} :
l.Sublist [] ↔ l = []h
huList.eq_nil_of_sublist_nil}(hj"  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlh\theorem List.eq_nil_of_sublist_nil {α : Type u_1} {l : List α} (s : l.Sublist []) :
l = []h
huList.tail_sublist}(hj"  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhJtheorem List.tail_sublist {α : Type u_1} (l : List α) :
l.tail.Sublist lh
huList.head_filter_mem}(hj""  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhtheorem List.head_filter_mem {α : Type u_1} (xs : List α) (p : α → Bool) (h : filter p xs ≠ []) :
(filter p xs).head h ∈ xsh
huList.getLast_filter_mem}(hj&"  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhtheorem List.getLast_filter_mem {α : Type u_1} (xs : List α) (p : α → Bool) (h : filter p xs ≠ []) :
(filter p xs).getLast h ∈ xsh
huList.sublist_filterMap_iff}(hj*"  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhtheorem List.sublist_filterMap_iff {β : Type u_1} {α : Type u_2} {l₂ : List α} {l₁ : List β} {f : α → Option β} :
l₁.Sublist (filterMap f l₂) ↔ ∃ (l' : List α), l'.Sublist l₂ ∧ l₁ = filterMap f l'h
huList.sublist_map_iff}(hj."  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhtheorem List.sublist_map_iff {β : Type u_1} {α : Type u_2} {l₂ : List α} {l₁ : List β} {f : α → β} :
l₁.Sublist (map f l₂) ↔ ∃ (l' : List α), l'.Sublist l₂ ∧ l₁ = map f l'h
huList.sublist_filter_iff}(hj2"  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhtheorem List.sublist_filter_iff {α : Type u_1} {l₂ l₁ : List α} {p : α → Bool} :
l₁.Sublist (filter p l₂) ↔ ∃ (l' : List α), l'.Sublist l₂ ∧ l₁ = filter p l'h
huList.sublist_append_left}(hj6"  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhdtheorem List.sublist_append_left {α : Type u_1} (l₁ l₂ : List α) :
l₁.Sublist (l₁ ++ l₂)h
huList.sublist_append_right}(hj:"  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhetheorem List.sublist_append_right {α : Type u_1} (l₁ l₂ : List α) :
l₂.Sublist (l₁ ++ l₂)h
huList.singleton_sublist}(hj>"  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhatheorem List.singleton_sublist {α : Type u_1} {a : α} {l : List α} :
[a].Sublist l ↔ a ∈ lh
hu#List.sublist_append_of_sublist_left}(hjB"  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhtheorem List.sublist_append_of_sublist_left {α✝ : Type u_1} {l l₁ l₂ : List α✝} (s : l.Sublist l₁) :
l.Sublist (l₁ ++ l₂)h
hu$List.sublist_append_of_sublist_right}(hjF"  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhtheorem List.sublist_append_of_sublist_right {α✝ : Type u_1} {l l₂ l₁ : List α✝} (s : l.Sublist l₂) :
l.Sublist (l₁ ++ l₂)h
huList.append_sublist_append_left}(hjJ"  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhtheorem List.append_sublist_append_left {α✝ : Type u_1} {l₁ l₂ : List α✝} (l : List α✝) :
(l ++ l₁).Sublist (l ++ l₂) ↔ l₁.Sublist l₂h
huList.sublist_cons_iff}(hjN"  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhtheorem List.sublist_cons_iff {α : Type u_1} {a : α} {l l' : List α} :
l.Sublist (a :: l') ↔ l.Sublist l' ∨ ∃ (r : List α), l = a :: r ∧ r.Sublist l'h
huList.cons_sublist_iff}(hjR"  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhtheorem List.cons_sublist_iff {α : Type u_1} {a : α} {l l' : List α} :
(a :: l).Sublist l' ↔ ∃ (r₁ : List α), ∃ (r₂ : List α), l' = r₁ ++ r₂ ∧ a ∈ r₁ ∧ l.Sublist r₂h
huList.sublist_append_iff}(hjV"  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhtheorem List.sublist_append_iff {α : Type u_1} {r₁ r₂ l : List α} :
l.Sublist (r₁ ++ r₂) ↔ ∃ (l₁ : List α), ∃ (l₂ : List α), l = l₁ ++ l₂ ∧ l₁.Sublist r₁ ∧ l₂.Sublist r₂h
huList.append_sublist_iff}(hjZ"  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhtheorem List.append_sublist_iff {α : Type u_1} {r l₁ l₂ : List α} :
(l₁ ++ l₂).Sublist r ↔ ∃ (r₁ : List α), ∃ (r₂ : List α), r = r₁ ++ r₂ ∧ l₁.Sublist r₁ ∧ l₂.Sublist r₂h
huList.reverse_sublist}(hj^"  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhtheorem List.reverse_sublist {α✝ : Type u_1} {l₁ l₂ : List α✝} :
l₁.reverse.Sublist l₂.reverse ↔ l₁.Sublist l₂h
huList.sublist_reverse_iff}(hjb"  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhtheorem List.sublist_reverse_iff {α✝ : Type u_1} {l₁ l₂ : List α✝} :
l₁.Sublist l₂.reverse ↔ l₁.reverse.Sublist l₂h
hu List.append_sublist_append_right}(hjf"  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhtheorem List.append_sublist_append_right {α✝ : Type u_1} {l₁ l₂ : List α✝} (l : List α✝) :
(l₁ ++ l).Sublist (l₂ ++ l) ↔ l₁.Sublist l₂h
hu List.replicate_sublist_replicate}(hjj"  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhtheorem List.replicate_sublist_replicate {α : Type u_1} {m n : Nat} (a : α) :
(replicate m a).Sublist (replicate n a) ↔ m ≤ nh
huList.sublist_replicate_iff}(hjn"  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhtheorem List.sublist_replicate_iff {α✝ : Type u_1} {l : List α✝} {m : Nat} {a : α✝} :
l.Sublist (replicate m a) ↔ ∃ (n : Nat), n ≤ m ∧ l = replicate n ah
huList.sublist_flatten_of_mem}(hjr"  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhztheorem List.sublist_flatten_of_mem {α : Type u_1} {L : List (List α)} {l : List α} (h : l ∈ L) :
l.Sublist L.flattenh
huList.sublist_flatten_iff}(hjv"  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhtheorem List.sublist_flatten_iff {α : Type u_1} {L : List (List α)} {l : List α} :
l.Sublist L.flatten ↔ ∃ (L' : List (List α)), l = L'.flatten ∧ ∀ (i : Nat) (x : i < L'.length), L'[i].Sublist (L[i]?.getD [])h
huList.flatten_sublist_iff}(hjz"  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhtheorem List.flatten_sublist_iff {α : Type u_1} {L : List (List α)} {l : List α} :
L.flatten.Sublist l ↔ ∃ (L' : List (List α)), l = L'.flatten ∧ ∀ (i : Nat) (x : i < L.length), L[i].Sublist (L'[i]?.getD [])h
huList.isSublist_iff_sublist}(hj~"  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhtheorem List.isSublist_iff_sublist {α : Type u_1} [BEq α] [LawfulBEq α] {l₁ l₂ : List α} :
l₁.isSublist l₂ = true ↔ l₁.Sublist l₂h
hu&List.instDecidableSublistOfDecidableEq}(hj"  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhinstance List.instDecidableSublistOfDecidableEq {α : Type u_1} [DecidableEq α] (l₁ l₂ : List α) :
Decidable (l₁.Sublist l₂)h
huList.prefix_append}(hj"  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhXtheorem List.prefix_append {α : Type u_1} (l₁ l₂ : List α) :
l₁ <+: l₁ ++ l₂h
huList.suffix_append}(hj"  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhXtheorem List.suffix_append {α : Type u_1} (l₁ l₂ : List α) :
l₂ <:+ l₁ ++ l₂h
huList.infix_append}(hj"  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhetheorem List.infix_append {α : Type u_1} (l₁ l₂ l₃ : List α) :
l₂ <:+: l₁ ++ l₂ ++ l₃h
huList.infix_append'}(hj"  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhhtheorem List.infix_append' {α : Type u_1} (l₁ l₂ l₃ : List α) :
l₂ <:+: l₁ ++ (l₂ ++ l₃)h
huList.infix_append_left}(hj"  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhctheorem List.infix_append_left {α✝ : Type u_1} {l₁ l₂ : List α✝} :
l₁ <:+: l₁ ++ l₂h
huList.infix_append_right}(hj"  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhdtheorem List.infix_append_right {α✝ : Type u_1} {l₂ l₁ : List α✝} :
l₂ <:+: l₁ ++ l₂h
huList.nil_prefix}(hj"  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlh@theorem List.nil_prefix {α : Type u_1} {l : List α} :
[] <+: lh
huList.nil_suffix}(hj"  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlh@theorem List.nil_suffix {α : Type u_1} {l : List α} :
[] <:+ lh
huList.nil_infix}(hj"  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlh@theorem List.nil_infix {α : Type u_1} {l : List α} :
[] <:+: lh
huList.prefix_refl}(hj"  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlh@theorem List.prefix_refl {α : Type u_1} (l : List α) :
l <+: lh
huList.prefix_rfl}(hj"  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlh?theorem List.prefix_rfl {α : Type u_1} {l : List α} :
l <+: lh
huList.suffix_refl}(hj"  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlh@theorem List.suffix_refl {α : Type u_1} (l : List α) :
l <:+ lh
huList.suffix_rfl}(hj"  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlh?theorem List.suffix_rfl {α : Type u_1} {l : List α} :
l <:+ lh
huList.infix_refl}(hj"  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlh@theorem List.infix_refl {α : Type u_1} (l : List α) :
l <:+: lh
huList.infix_rfl}(hj"  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlh?theorem List.infix_rfl {α : Type u_1} {l : List α} :
l <:+: lh
huList.suffix_cons}(hj"  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhNtheorem List.suffix_cons {α : Type u_1} (a : α) (l : List α) :
l <:+ a :: lh
huList.infix_cons}(hj"  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhxtheorem List.infix_cons {α✝ : Type u_1} {l₁ l₂ : List α✝} {a : α✝} :
l₁ <:+: l₂ → l₁ <:+: a :: l₂h
huList.infix_concat}(hj"  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlh~theorem List.infix_concat {α✝ : Type u_1} {l₁ l₂ : List α✝} {a : α✝} :
l₁ <:+: l₂ → l₁ <:+: l₂.concat ah
huList.prefix_append_of_prefix}(hj"  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhtheorem List.prefix_append_of_prefix {α✝ : Type u_1} {l₁ l₂ l₃ : List α✝} (h : l₁ <+: l₂) :
l₁ <+: l₂ ++ l₃h
huList.suffix_append_of_suffix}(hj"  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhtheorem List.suffix_append_of_suffix {α✝ : Type u_1} {l₁ l₃ l₂ : List α✝} (h : l₁ <:+ l₃) :
l₁ <:+ l₂ ++ l₃h
huList.infix_append_of_infix_left}(hj"  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhtheorem List.infix_append_of_infix_left {α✝ : Type u_1} {l₁ l₂ l₃ : List α✝} (h : l₁ <:+: l₂) :
l₁ <:+: l₂ ++ l₃h
hu List.infix_append_of_infix_right}(hj"  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhtheorem List.infix_append_of_infix_right {α✝ : Type u_1} {l₁ l₃ l₂ : List α✝} (h : l₁ <:+: l₃) :
l₁ <:+: l₂ ++ l₃h
huList.infix_nil}(hj"  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhQtheorem List.infix_nil {α✝ : Type u_1} {l : List α✝} :
l <:+: [] ↔ l = []h
huList.prefix_nil}(hj"  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhQtheorem List.prefix_nil {α✝ : Type u_1} {l : List α✝} :
l <+: [] ↔ l = []h
huList.suffix_nil}(hj"  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhQtheorem List.suffix_nil {α✝ : Type u_1} {l : List α✝} :
l <:+ [] ↔ l = []h
huList.eq_nil_of_infix_nil}(hj"  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlh]theorem List.eq_nil_of_infix_nil {α✝ : Type u_1} {l : List α✝} (h : l <:+: []) :
l = []h
huList.eq_nil_of_prefix_nil}(hj"  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlh]theorem List.eq_nil_of_prefix_nil {α✝ : Type u_1} {l : List α✝} (h : l <+: []) :
l = []h
huList.eq_nil_of_suffix_nil}(hj"  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlh]theorem List.eq_nil_of_suffix_nil {α✝ : Type u_1} {l : List α✝} (h : l <:+ []) :
l = []h
huList.reverse_suffix}(hj"  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhytheorem List.reverse_suffix {α✝ : Type u_1} {l₁ l₂ : List α✝} :
l₁.reverse <:+ l₂.reverse ↔ l₁ <+: l₂h
huList.reverse_prefix}(hj"  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhytheorem List.reverse_prefix {α✝ : Type u_1} {l₁ l₂ : List α✝} :
l₁.reverse <+: l₂.reverse ↔ l₁ <:+ l₂h
huList.reverse_infix}(hj"  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhztheorem List.reverse_infix {α✝ : Type u_1} {l₁ l₂ : List α✝} :
l₁.reverse <:+: l₂.reverse ↔ l₁ <:+: l₂h
huList.prefix_concat}(hj#  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhTtheorem List.prefix_concat {α : Type u_1} (a : α) (l : List α) :
l <+: l.concat ah
huList.infix_iff_prefix_suffix}(hj#  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhtheorem List.infix_iff_prefix_suffix {α : Type u_1} {l₁ l₂ : List α} :
l₁ <:+: l₂ ↔ ∃ (t : List α), l₁ <+: t ∧ t <:+ l₂h
huList.infix_iff_suffix_prefix}(hj
#  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhtheorem List.infix_iff_suffix_prefix {α : Type u_1} {l₁ l₂ : List α} :
l₁ <:+: l₂ ↔ ∃ (t : List α), l₁ <:+ t ∧ t <+: l₂h
huList.prefix_of_prefix_length_le}(hj#  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhtheorem List.prefix_of_prefix_length_le {α : Type u_1} {l₁ l₂ l₃ : List α} :
l₁ <+: l₃ → l₂ <+: l₃ → l₁.length ≤ l₂.length → l₁ <+: l₂h
huList.prefix_or_prefix_of_prefix}(hj#  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhtheorem List.prefix_or_prefix_of_prefix {α✝ : Type u_1} {l₁ l₃ l₂ : List α✝} (h₁ : l₁ <+: l₃) (h₂ : l₂ <+: l₃) :
l₁ <+: l₂ ∨ l₂ <+: l₁h
huList.suffix_of_suffix_length_le}(hj#  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhtheorem List.suffix_of_suffix_length_le {α✝ : Type u_1} {l₁ l₃ l₂ : List α✝} (h₁ : l₁ <:+ l₃) (h₂ : l₂ <:+ l₃) (ll : l₁.length ≤ l₂.length) :
l₁ <:+ l₂h
huList.suffix_or_suffix_of_suffix}(hj#  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhtheorem List.suffix_or_suffix_of_suffix {α✝ : Type u_1} {l₁ l₃ l₂ : List α✝} (h₁ : l₁ <:+ l₃) (h₂ : l₂ <:+ l₃) :
l₁ <:+ l₂ ∨ l₂ <:+ l₁h
huList.prefix_cons_iff}(hj#  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhtheorem List.prefix_cons_iff {α✝ : Type u_1} {l₁ : List α✝} {a : α✝} {l₂ : List α✝} :
l₁ <+: a :: l₂ ↔ l₁ = [] ∨ ∃ (t : List α✝), l₁ = a :: t ∧ t <+: l₂h
huList.cons_prefix_cons}(hj"#  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhtheorem List.cons_prefix_cons {α✝ : Type u_1} {a : α✝} {l₁ : List α✝} {b : α✝} {l₂ : List α✝} :
a :: l₁ <+: b :: l₂ ↔ a = b ∧ l₁ <+: l₂h
huList.suffix_cons_iff}(hj&#  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhtheorem List.suffix_cons_iff {α✝ : Type u_1} {l₁ : List α✝} {a : α✝} {l₂ : List α✝} :
l₁ <:+ a :: l₂ ↔ l₁ = a :: l₂ ∨ l₁ <:+ l₂h
huList.infix_cons_iff}(hj*#  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhtheorem List.infix_cons_iff {α✝ : Type u_1} {l₁ : List α✝} {a : α✝} {l₂ : List α✝} :
l₁ <:+: a :: l₂ ↔ l₁ <+: a :: l₂ ∨ l₁ <:+: l₂h
huList.prefix_concat_iff}(hj.#  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhtheorem List.prefix_concat_iff {α : Type u_1} {l₁ l₂ : List α} {a : α} :
l₁ <+: l₂ ++ [a] ↔ l₁ = l₂ ++ [a] ∨ l₁ <+: l₂h
huList.suffix_concat_iff}(hj2#  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhtheorem List.suffix_concat_iff {α : Type u_1} {l₁ l₂ : List α} {a : α} :
l₁ <:+ l₂ ++ [a] ↔ l₁ = [] ∨ ∃ (t : List α), l₁ = t ++ [a] ∧ t <:+ l₂h
huList.infix_concat_iff}(hj6#  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhtheorem List.infix_concat_iff {α : Type u_1} {l₁ l₂ : List α} {a : α} :
l₁ <:+: l₂ ++ [a] ↔ l₁ <:+ l₂ ++ [a] ∨ l₁ <:+: l₂h
huList.prefix_iff_getElem?}(hj:#  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhtheorem List.prefix_iff_getElem? {α : Type u_1} {l₁ l₂ : List α} :
l₁ <+: l₂ ↔ ∀ (i : Nat) (h : i < l₁.length), l₂[i]? = some l₁[i]h
huList.isPrefix_iff}(hj>#  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhabbrev List.isPrefix_iff {α : Type u_1} {l₁ l₂ : List α} :
l₁ <+: l₂ ↔ ∀ (i : Nat) (h : i < l₁.length), l₂[i]? = some l₁[i]h
huList.prefix_iff_getElem}(hjB#  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhtheorem List.prefix_iff_getElem {α : Type u_1} {l₁ l₂ : List α} :
l₁ <+: l₂ ↔ ∃ (h : l₁.length ≤ l₂.length), ∀ (i : Nat) (hx : i < l₁.length), l₁[i] = l₂[i]h
huList.isPrefix_iff_getElem}(hjF#  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhabbrev List.isPrefix_iff_getElem {α : Type u_1} {l₁ l₂ : List α} :
l₁ <+: l₂ ↔ ∃ (h : l₁.length ≤ l₂.length), ∀ (i : Nat) (hx : i < l₁.length), l₁[i] = l₂[i]h
huList.cons_prefix_iff}(hjJ#  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhtheorem List.cons_prefix_iff {α : Type u_1} {a : α} {l₁ l₂ : List α} :
a :: l₁ <+: l₂ ↔ ∃ (l' : List α), l₂ = a :: l' ∧ l₁ <+: l'h
huList.prefix_filterMap_iff}(hjN#  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhtheorem List.prefix_filterMap_iff {α : Type u_1} {β : Type u_2} {f : α → Option β} {l₁ : List α} {l₂ : List β} :
l₂ <+: filterMap f l₁ ↔ ∃ (l : List α), l <+: l₁ ∧ l₂ = filterMap f lh
huList.isPrefix_filterMap_iff}(hjR#  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhabbrev List.isPrefix_filterMap_iff {α : Type u_1} {β : Type u_2} {f : α → Option β} {l₁ : List α} {l₂ : List β} :
l₂ <+: filterMap f l₁ ↔ ∃ (l : List α), l <+: l₁ ∧ l₂ = filterMap f lh
huList.suffix_filterMap_iff}(hjV#  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhtheorem List.suffix_filterMap_iff {α : Type u_1} {β : Type u_2} {f : α → Option β} {l₁ : List α} {l₂ : List β} :
l₂ <:+ filterMap f l₁ ↔ ∃ (l : List α), l <:+ l₁ ∧ l₂ = filterMap f lh
huList.isSuffix_filterMap_iff}(hjZ#  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhabbrev List.isSuffix_filterMap_iff {α : Type u_1} {β : Type u_2} {f : α → Option β} {l₁ : List α} {l₂ : List β} :
l₂ <:+ filterMap f l₁ ↔ ∃ (l : List α), l <:+ l₁ ∧ l₂ = filterMap f lh
huList.infix_filterMap_iff}(hj^#  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhtheorem List.infix_filterMap_iff {α : Type u_1} {β : Type u_2} {f : α → Option β} {l₁ : List α} {l₂ : List β} :
l₂ <:+: filterMap f l₁ ↔ ∃ (l : List α), l <:+: l₁ ∧ l₂ = filterMap f lh
huList.isInfix_filterMap_iff}(hjb#  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhabbrev List.isInfix_filterMap_iff {α : Type u_1} {β : Type u_2} {f : α → Option β} {l₁ : List α} {l₂ : List β} :
l₂ <:+: filterMap f l₁ ↔ ∃ (l : List α), l <:+: l₁ ∧ l₂ = filterMap f lh
huList.prefix_filter_iff}(hjf#  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhtheorem List.prefix_filter_iff {α : Type u_1} {p : α → Bool} {l₁ l₂ : List α} :
l₂ <+: filter p l₁ ↔ ∃ (l : List α), l <+: l₁ ∧ l₂ = filter p lh
huList.isPrefix_filter_iff}(hjj#  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhabbrev List.isPrefix_filter_iff {α : Type u_1} {p : α → Bool} {l₁ l₂ : List α} :
l₂ <+: filter p l₁ ↔ ∃ (l : List α), l <+: l₁ ∧ l₂ = filter p lh
huList.suffix_filter_iff}(hjn#  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhtheorem List.suffix_filter_iff {α : Type u_1} {p : α → Bool} {l₁ l₂ : List α} :
l₂ <:+ filter p l₁ ↔ ∃ (l : List α), l <:+ l₁ ∧ l₂ = filter p lh
huList.isSuffix_filter_iff}(hjr#  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhabbrev List.isSuffix_filter_iff {α : Type u_1} {p : α → Bool} {l₁ l₂ : List α} :
l₂ <:+ filter p l₁ ↔ ∃ (l : List α), l <:+ l₁ ∧ l₂ = filter p lh
huList.infix_filter_iff}(hjv#  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhtheorem List.infix_filter_iff {α : Type u_1} {p : α → Bool} {l₁ l₂ : List α} :
l₂ <:+: filter p l₁ ↔ ∃ (l : List α), l <:+: l₁ ∧ l₂ = filter p lh
huList.isInfix_filter_iff}(hjz#  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhabbrev List.isInfix_filter_iff {α : Type u_1} {p : α → Bool} {l₁ l₂ : List α} :
l₂ <:+: filter p l₁ ↔ ∃ (l : List α), l <:+: l₁ ∧ l₂ = filter p lh
huList.prefix_map_iff}(hj~#  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhtheorem List.prefix_map_iff {α : Type u_1} {β : Type u_2} {f : α → β} {l₁ : List α} {l₂ : List β} :
l₂ <+: map f l₁ ↔ ∃ (l : List α), l <+: l₁ ∧ l₂ = map f lh
huList.isPrefix_map_iff}(hj#  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhabbrev List.isPrefix_map_iff {α : Type u_1} {β : Type u_2} {f : α → β} {l₁ : List α} {l₂ : List β} :
l₂ <+: map f l₁ ↔ ∃ (l : List α), l <+: l₁ ∧ l₂ = map f lh
huList.suffix_map_iff}(hj#  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhtheorem List.suffix_map_iff {α : Type u_1} {β : Type u_2} {f : α → β} {l₁ : List α} {l₂ : List β} :
l₂ <:+ map f l₁ ↔ ∃ (l : List α), l <:+ l₁ ∧ l₂ = map f lh
huList.isSuffix_map_iff}(hj#  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhabbrev List.isSuffix_map_iff {α : Type u_1} {β : Type u_2} {f : α → β} {l₁ : List α} {l₂ : List β} :
l₂ <:+ map f l₁ ↔ ∃ (l : List α), l <:+ l₁ ∧ l₂ = map f lh
huList.infix_map_iff}(hj#  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhtheorem List.infix_map_iff {α : Type u_1} {β : Type u_2} {f : α → β} {l₁ : List α} {l₂ : List β} :
l₂ <:+: map f l₁ ↔ ∃ (l : List α), l <:+: l₁ ∧ l₂ = map f lh
huList.isInfix_map_iff}(hj#  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhabbrev List.isInfix_map_iff {α : Type u_1} {β : Type u_2} {f : α → β} {l₁ : List α} {l₂ : List β} :
l₂ <:+: map f l₁ ↔ ∃ (l : List α), l <:+: l₁ ∧ l₂ = map f lh
huList.prefix_replicate_iff}(hj#  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.html      htheorem List.prefix_replicate_iff {α : Type u_1} {n : Nat} {a : α} {l : List α} :
l <+: replicate n a ↔ l.length ≤ n ∧ l = replicate l.length ah
huList.isPrefix_replicate_iff}(hj#  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhabbrev List.isPrefix_replicate_iff {α : Type u_1} {n : Nat} {a : α} {l : List α} :
l <+: replicate n a ↔ l.length ≤ n ∧ l = replicate l.length ah
huList.suffix_replicate_iff}(hj#  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhtheorem List.suffix_replicate_iff {α : Type u_1} {n : Nat} {a : α} {l : List α} :
l <:+ replicate n a ↔ l.length ≤ n ∧ l = replicate l.length ah
huList.isSuffix_replicate_iff}(hj#  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhabbrev List.isSuffix_replicate_iff {α : Type u_1} {n : Nat} {a : α} {l : List α} :
l <:+ replicate n a ↔ l.length ≤ n ∧ l = replicate l.length ah
huList.infix_replicate_iff}(hj#  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhtheorem List.infix_replicate_iff {α : Type u_1} {n : Nat} {a : α} {l : List α} :
l <:+: replicate n a ↔ l.length ≤ n ∧ l = replicate l.length ah
huList.isInfix_replicate_iff}(hj#  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhabbrev List.isInfix_replicate_iff {α : Type u_1} {n : Nat} {a : α} {l : List α} :
l <:+: replicate n a ↔ l.length ≤ n ∧ l = replicate l.length ah
huList.infix_of_mem_flatten}(hj#  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhstheorem List.infix_of_mem_flatten {α : Type u_1} {l : List α} {L : List (List α)} :
l ∈ L → l <:+: L.flattenh
huList.prefix_append_right_inj}(hj#  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhtheorem List.prefix_append_right_inj {α✝ : Type u_1} {l₁ l₂ : List α✝} (l : List α✝) :
l ++ l₁ <+: l ++ l₂ ↔ l₁ <+: l₂h
huList.prefix_cons_inj}(hj#  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhtheorem List.prefix_cons_inj {α✝ : Type u_1} {l₁ l₂ : List α✝} (a : α✝) :
a :: l₁ <+: a :: l₂ ↔ l₁ <+: l₂h
huList.take_prefix}(hj#  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhQtheorem List.take_prefix {α : Type u_1} (i : Nat) (l : List α) :
take i l <+: lh
huList.drop_suffix}(hj#  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhQtheorem List.drop_suffix {α : Type u_1} (i : Nat) (l : List α) :
drop i l <:+ lh
huList.take_sublist}(hj#  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhXtheorem List.take_sublist {α : Type u_1} (i : Nat) (l : List α) :
(take i l).Sublist lh
huList.drop_sublist}(hj#  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhXtheorem List.drop_sublist {α : Type u_1} (i : Nat) (l : List α) :
(drop i l).Sublist lh
huList.take_subset}(hj#  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhQtheorem List.take_subset {α : Type u_1} (i : Nat) (l : List α) :
take i l ⊆ lh
huList.drop_subset}(hj#  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhQtheorem List.drop_subset {α : Type u_1} (i : Nat) (l : List α) :
drop i l ⊆ lh
huList.mem_of_mem_take}(hj#  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhltheorem List.mem_of_mem_take {α : Type u_1} {i : Nat} {a : α} {l : List α} (h : a ∈ take i l) :
a ∈ lh
huList.mem_of_mem_drop}(hj#  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhltheorem List.mem_of_mem_drop {α : Type u_1} {a : α} {i : Nat} {l : List α} (h : a ∈ drop i l) :
a ∈ lh
huList.drop_suffix_drop_left}(hj#  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhrtheorem List.drop_suffix_drop_left {α : Type u_1} (l : List α) {i j : Nat} (h : i ≤ j) :
drop j l <:+ drop i lh
huList.drop_sublist_drop_left}(hj#  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlh{theorem List.drop_sublist_drop_left {α : Type u_1} (l : List α) {i j : Nat} (h : i ≤ j) :
(drop j l).Sublist (drop i l)h
huList.drop_subset_drop_left}(hj#  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhrtheorem List.drop_subset_drop_left {α : Type u_1} (l : List α) {i j : Nat} (h : i ≤ j) :
drop j l ⊆ drop i lh
huList.takeWhile_prefix}(hj#  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhctheorem List.takeWhile_prefix {α : Type u_1} {l : List α} (p : α → Bool) :
takeWhile p l <+: lh
huList.dropWhile_suffix}(hj#  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhctheorem List.dropWhile_suffix {α : Type u_1} {l : List α} (p : α → Bool) :
dropWhile p l <:+ lh
huList.takeWhile_sublist}(hj#  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhjtheorem List.takeWhile_sublist {α : Type u_1} {l : List α} (p : α → Bool) :
(takeWhile p l).Sublist lh
huList.dropWhile_sublist}(hj#  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhjtheorem List.dropWhile_sublist {α : Type u_1} {l : List α} (p : α → Bool) :
(dropWhile p l).Sublist lh
huList.takeWhile_subset}(hj#  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhctheorem List.takeWhile_subset {α : Type u_1} {l : List α} (p : α → Bool) :
takeWhile p l ⊆ lh
huList.dropWhile_subset}(hj#  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhctheorem List.dropWhile_subset {α : Type u_1} {l : List α} (p : α → Bool) :
dropWhile p l ⊆ lh
huList.dropLast_prefix}(hj#  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhMtheorem List.dropLast_prefix {α : Type u_1} (l : List α) :
l.dropLast <+: lh
huList.dropLast_sublist}(hj$  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhRtheorem List.dropLast_sublist {α : Type u_1} (l : List α) :
l.dropLast.Sublist lh
huList.dropLast_subset}(hj$  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhMtheorem List.dropLast_subset {α : Type u_1} (l : List α) :
l.dropLast ⊆ lh
huList.tail_suffix}(hj
$  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhEtheorem List.tail_suffix {α : Type u_1} (l : List α) :
l.tail <:+ lh
huList.isPrefixOf_iff_prefix}(hj$  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhtheorem List.isPrefixOf_iff_prefix {α : Type u_1} [BEq α] [LawfulBEq α] {l₁ l₂ : List α} :
l₁.isPrefixOf l₂ = true ↔ l₁ <+: l₂h
hu'List.instDecidableIsPrefixOfDecidableEq}(hj$  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhinstance List.instDecidableIsPrefixOfDecidableEq {α : Type u_1} [DecidableEq α] (l₁ l₂ : List α) :
Decidable (l₁ <+: l₂)h
huList.isSuffixOf_iff_suffix}(hj$  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhtheorem List.isSuffixOf_iff_suffix {α : Type u_1} [BEq α] [LawfulBEq α] {l₁ l₂ : List α} :
l₁.isSuffixOf l₂ = true ↔ l₁ <:+ l₂h
hu'List.instDecidableIsSuffixOfDecidableEq}(hj$  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhinstance List.instDecidableIsSuffixOfDecidableEq {α : Type u_1} [DecidableEq α] (l₁ l₂ : List α) :
Decidable (l₁ <:+ l₂)h
huList.prefix_iff_eq_append}(hj$  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlhtheorem List.prefix_iff_eq_append {α✝ : Type u_1} {l₁ l₂ : List α✝} :
l₁ <+: l₂ ↔ l₁ ++ drop l₁.length l₂ = l₂h
huList.prefix_iff_eq_take}(hj"$  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Sublist.htmlh|theorem List.prefix_iff_eq_take {α✝ : Type u_1} {l₁ l₂ : List α✝} :
l₁ <+: l₂ ↔ l₁ = take l₁.length l₂h
huList.nil_eq}(hj&$  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhHtheorem List.nil_eq {α : Type u_1} {xs : List α} :
[] = xs ↔ xs = []h
huList.eq_nil_of_length_eq_zero}(hj*$  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhctheorem List.eq_nil_of_length_eq_zero {α✝ : Type u_1} {l : List α✝} :
l.length = 0 → l = []h
hu List.ne_nil_of_length_eq_add_one}(hj.$  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhvtheorem List.ne_nil_of_length_eq_add_one {α✝ : Type u_1} {l : List α✝} {n : Nat} :
l.length = n + 1 → l ≠ []h
huList.ne_nil_of_length_pos}(hj2$  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhatheorem List.ne_nil_of_length_pos {α✝ : Type u_1} {l : List α✝} :
0 < l.length → l ≠ []h
huList.length_eq_zero_iff}(hj6$  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlh]theorem List.length_eq_zero_iff {α✝ : Type u_1} {l : List α✝} :
l.length = 0 ↔ l = []h
huList.length_eq_zero}(hj:$  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhXabbrev List.length_eq_zero {α✝ : Type u_1} {l : List α✝} :
l.length = 0 ↔ l = []h
huList.eq_nil_iff_length_eq_zero}(hj>$  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhdtheorem List.eq_nil_iff_length_eq_zero {α✝ : Type u_1} {l : List α✝} :
l = [] ↔ l.length = 0h
huList.length_pos_of_mem}(hjB$  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlh`theorem List.length_pos_of_mem {α : Type u_1} {a : α} {l : List α} :
a ∈ l → 0 < l.lengthh
huList.exists_mem_of_length_pos}(hjF$  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhltheorem List.exists_mem_of_length_pos {α : Type u_1} {l : List α} :
0 < l.length → ∃ (a : α), a ∈ lh
huList.length_pos_iff_exists_mem}(hjJ$  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhmtheorem List.length_pos_iff_exists_mem {α : Type u_1} {l : List α} :
0 < l.length ↔ ∃ (a : α), a ∈ lh
hu$List.exists_mem_of_length_eq_add_one}(hjN$  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.exists_mem_of_length_eq_add_one {α : Type u_1} {n : Nat} {l : List α} :
l.length = n + 1 → ∃ (a : α), a ∈ lh
huList.exists_cons_of_length_pos}(hjR$  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.exists_cons_of_length_pos {α : Type u_1} {l : List α} :
0 < l.length → ∃ (h : α), ∃ (t : List α), l = h :: th
huList.length_pos_iff_exists_cons}(hjV$  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.length_pos_iff_exists_cons {α : Type u_1} {l : List α} :
0 < l.length ↔ ∃ (h : α), ∃ (t : List α), l = h :: th
hu%List.exists_cons_of_length_eq_add_one}(hjZ$  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.exists_cons_of_length_eq_add_one {α : Type u_1} {n : Nat} {l : List α} :
l.length = n + 1 → ∃ (h : α), ∃ (t : List α), l = h :: th
huList.length_pos_iff}(hj^$  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhUtheorem List.length_pos_iff {α : Type u_1} {l : List α} :
0 < l.length ↔ l ≠ []h
huList.length_pos}(hjb$  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhPabbrev List.length_pos {α : Type u_1} {l : List α} :
0 < l.length ↔ l ≠ []h
huList.ne_nil_iff_length_pos}(hjf$  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlh\theorem List.ne_nil_iff_length_pos {α : Type u_1} {l : List α} :
l ≠ [] ↔ 0 < l.lengthh
huList.length_eq_one_iff}(hjj$  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhetheorem List.length_eq_one_iff {α : Type u_1} {l : List α} :
l.length = 1 ↔ ∃ (a : α), l = [a]h
huList.length_eq_one}(hjn$  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlh`abbrev List.length_eq_one {α : Type u_1} {l : List α} :
l.length = 1 ↔ ∃ (a : α), l = [a]h
huList.cons_ne_nil}(hjr$  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhOtheorem List.cons_ne_nil {α : Type u_1} (a : α) (l : List α) :
a :: l ≠ []h
huList.cons_ne_self}(hjv$  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhOtheorem List.cons_ne_self {α : Type u_1} (a : α) (l : List α) :
a :: l ≠ lh
huList.ne_cons_self}(hjz$  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhOtheorem List.ne_cons_self {α : Type u_1} {a : α} {l : List α} :
l ≠ a :: lh
huList.head_eq_of_cons_eq}(hj~$  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.head_eq_of_cons_eq {α✝ : Type u_1} {h₁ : α✝} {t₁ : List α✝} {h₂ : α✝} {t₂ : List α✝} (H : h₁ :: t₁ = h₂ :: t₂) :
h₁ = h₂h
huList.tail_eq_of_cons_eq}(hj$  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.tail_eq_of_cons_eq {α✝ : Type u_1} {h₁ : α✝} {t₁ : List α✝} {h₂ : α✝} {t₂ : List α✝} (H : h₁ :: t₁ = h₂ :: t₂) :
t₁ = t₂h
huList.cons_inj_right}(hj$  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhctheorem List.cons_inj_right {α : Type u_1} (a : α) {l l' : List α} :
a :: l = a :: l' ↔ l = l'h
huList.cons_eq_cons}(hj$  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhmtheorem List.cons_eq_cons {α : Type u_1} {a b : α} {l l' : List α} :
a :: l = b :: l' ↔ a = b ∧ l = l'h
huList.exists_cons_of_ne_nil}(hj$  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlh}theorem List.exists_cons_of_ne_nil {α : Type u_1} {l : List α} :
l ≠ [] → ∃ (b : α), ∃ (l' : List α), l = b :: l'h
huList.ne_nil_iff_exists_cons}(hj$  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlh~theorem List.ne_nil_iff_exists_cons {α : Type u_1} {l : List α} :
l ≠ [] ↔ ∃ (b : α), ∃ (l' : List α), l = b :: l'h
huList.singleton_inj}(hj$  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhKtheorem List.singleton_inj {α : Type u_1} {a b : α} :
[a] = [b] ↔ a = bh
huList.concat_ne_nil}(hj$  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhStheorem List.concat_ne_nil {α : Type u_1} (a : α) (l : List α) :
l ++ [a] ≠ []h
huList.get_eq_getElem}(hj$  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlh`theorem List.get_eq_getElem {α : Type u_1} {l : List α} {i : Fin l.length} :
l.get i = l[↑i]h
huList.get?_eq_none}(hj$  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhftheorem List.get?_eq_none {α : Type u_1} {l : List α} {n : Nat} :
l.length ≤ n → l.get? n = noneh
huList.get?_eq_get}(hj$  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhxtheorem List.get?_eq_get {α : Type u_1} {l : List α} {n : Nat} (h : n < l.length) :
l.get? n = some (l.get ⟨n, h⟩)h
huList.get?_eq_some_iff}(hj$  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.get?_eq_some_iff {α✝ : Type u_1} {a : α✝} {l : List α✝} {n : Nat} :
l.get? n = some a ↔ ∃ (h : n < l.length), l.get ⟨n, h⟩ = ah
huList.get?_eq_none_iff}(hj$  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhptheorem List.get?_eq_none_iff {α✝ : Type u_1} {l : List α✝} {n : Nat} :
l.get? n = none ↔ l.length ≤ nh
huList.get?_eq_getElem?}(hj$  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhXtheorem List.get?_eq_getElem? {α : Type u_1} {l : List α} {i : Nat} :
l.get? i = l[i]?h
huList.getElem!_eq_getElem?_getD}(hj$  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhztheorem List.getElem!_eq_getElem?_getD {α : Type u_1} [Inhabited α] {l : List α} {i : Nat} :
l[i]! = l[i]?.getD defaulth
huList.getElem?_nil}(hj$  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhCtheorem List.getElem?_nil {α : Type u_1} {i : Nat} :
[][i]? = noneh
huList.getElem_cons}(hj$  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.getElem_cons {α : Type u_1} {i : Nat} {a : α} {l : List α} (w : i < (a :: l).length) :
(a :: l)[i] = if h : i = 0 then a else l[i - 1]h
huList.getElem?_cons_zero}(hj$  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlh^theorem List.getElem?_cons_zero {α : Type u_1} {a : α} {l : List α} :
(a :: l)[0]? = some ah
huList.getElem?_cons_succ}(hj$  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhktheorem List.getElem?_cons_succ {α : Type u_1} {a : α} {i : Nat} {l : List α} :
(a :: l)[i + 1]? = l[i]?h
huList.getElem?_cons}(hj$  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.getElem?_cons {α✝ : outParam (Type u_1)} {a : α✝} {l : List α✝} {i : Nat} :
(a :: l)[i]? = if i = 0 then some a else l[i - 1]?h
huList.getElem?_eq_some_iff}(hj$  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.getElem?_eq_some_iff {α : Type u_1} {i : Nat} {a : α} {l : List α} :
l[i]? = some a ↔ ∃ (h : i < l.length), l[i] = ah
huList.getElem_of_getElem?}(hj$  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.getElem_of_getElem? {α : Type u_1} {i : Nat} {a : α} {l : List α} :
l[i]? = some a → ∃ (h : i < l.length), l[i] = ah
huList.some_eq_getElem?_iff}(hj$  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.some_eq_getElem?_iff {α : Type u_1} {a : α} {i : Nat} {l : List α} :
some a = l[i]? ↔ ∃ (h : i < l.length), l[i] = ah
hu!List.some_getElem_eq_getElem?_iff}(hj$  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.some_getElem_eq_getElem?_iff {α : Type u_1} {xs : List α} {i : Nat} (h : i < xs.length) :
some xs[i] = xs[i]? ↔ Trueh
hu!List.getElem?_eq_some_getElem_iff}(hj$  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.getElem?_eq_some_getElem_iff {α : Type u_1} {xs : List α} {i : Nat} (h : i < xs.length) :
xs[i]? = some xs[i] ↔ Trueh
huList.getElem_eq_iff}(hj$  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlh}theorem List.getElem_eq_iff {α : Type u_1} {x : α} {l : List α} {i : Nat} (h : i < l.length) :
l[i] = x ↔ l[i]? = some xh
huList.getElem_eq_getElem?_get}(hj$  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhvtheorem List.getElem_eq_getElem?_get {α : Type u_1} {l : List α} {i : Nat} (h : i < l.length) :
l[i] = l[i]?.get ⋯h
huList.getD_getElem?}(hj$  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.getD_getElem? {α : Type u_1} {l : List α} {i : Nat} {d : α} :
l[i]?.getD d = if p : i < l.length then l[i] else dh
huList.getElem_singleton}(hj$  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhZtheorem List.getElem_singleton {α : Type u_1} {a : α} {i : Nat} (h : i < 1) :
[a][i] = ah
huList.getElem?_singleton}(hj$  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhmtheorem List.getElem?_singleton {α : Type u_1} {a : α} {i : Nat} :
[a][i]? = if i = 0 then some a else noneh
huList.getElem_of_eq}(hj$  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhttheorem List.getElem_of_eq {α : Type u_1} {l l' : List α} (h : l = l') {i : Nat} (w : i < l.length) :
l[i] = l'[i]h
X
  If one has l[i] in an expression and h : l = l', rw [h] will give a "motive it not type correct" error, as it cannot rewrite the implicit i < l.length to i < l'.length directly. The theorem getElem_of_eq can be used to make such a rewrite, with rw [getElem_of_eq h].uList.getElem_zero}(hj$  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlh^theorem List.getElem_zero {α : Type u_1} {l : List α} (h : 0 < l.length) :
l[0] = l.head ⋯h
huList.ext_getElem?}(hj$  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhvtheorem List.ext_getElem? {α : Type u_1} {l₁ l₂ : List α} (h : ∀ (i : Nat), l₁[i]? = l₂[i]?) :
l₁ = l₂h
huList.ext_getElem?_iff}(hj%  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhxtheorem List.ext_getElem?_iff {α : Type u_1} {l₁ l₂ : List α} :
l₁ = l₂ ↔ ∀ (i : Nat), l₁[i]? = l₂[i]?h
huList.ext_getElem}(hj%  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.ext_getElem {α : Type u_1} {l₁ l₂ : List α} (hl : l₁.length = l₂.length) (h : ∀ (i : Nat) (h₁ : i < l₁.length) (h₂ : i < l₂.length), l₁[i] = l₂[i]) :
l₁ = l₂h
huList.getElem_concat_length}(hj%  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.getElem_concat_length {α : Type u_1} {l : List α} {a : α} {i : Nat} (h : i = l.length) (w : i < (l ++ [a]).length) :
(l ++ [a])[i] = ah
huList.getElem?_concat_length}(hj%  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhktheorem List.getElem?_concat_length {α : Type u_1} {l : List α} {a : α} :
(l ++ [a])[l.length]? = some ah
huList.getD_eq_getElem?_getD}(hj%  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhotheorem List.getD_eq_getElem?_getD {α : Type u_1} {l : List α} {i : Nat} {a : α} :
l.getD i a = l[i]?.getD ah
huList.getD_cons_zero}(hj%  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhqtheorem List.getD_cons_zero {α✝ : Type u_1} {x : α✝} {xs : List α✝} {d : α✝} :
(x :: xs).getD 0 d = xh
huList.getD_cons_succ}(hj%  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.getD_cons_succ {α✝ : Type u_1} {x : α✝} {xs : List α✝} {n : Nat} {d : α✝} :
(x :: xs).getD (n + 1) d = xs.getD n dh
huList.get!_eq_getD}(hj%  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhntheorem List.get!_eq_getD {α : Type u_1} [Inhabited α] (l : List α) (i : Nat) :
l.get! i = l.getD i defaulth
huList.get!_eq_getElem!}(hj#%  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhgtheorem List.get!_eq_getElem! {α : Type u_1} [Inhabited α] (l : List α) (i : Nat) :
l.get! i = l[i]!h
huList.not_mem_nil}(hj'%  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlh>theorem List.not_mem_nil {α : Type u_1} {a : α} :
¬a ∈ []h
hu
List.mem_cons}(hj+%  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhvtheorem List.mem_cons {α✝ : Type u_1} {b : α✝} {l : List α✝} {a : α✝} :
a ∈ b :: l ↔ a = b ∨ a ∈ lh
huList.eq_or_mem_of_mem_cons}(hj/%  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhptheorem List.eq_or_mem_of_mem_cons {α : Type u_1} {a b : α} {l : List α} :
a ∈ b :: l → a = b ∨ a ∈ lh
huList.mem_cons_self}(hj3%  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhPtheorem List.mem_cons_self {α : Type u_1} {a : α} {l : List α} :
a ∈ a :: lh
huList.mem_concat_self}(hj7%  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhVtheorem List.mem_concat_self {α : Type u_1} {xs : List α} {a : α} :
a ∈ xs ++ [a]h
huList.mem_append_cons_self}(hj;%  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhztheorem List.mem_append_cons_self {α✝ : Type u_1} {xs : List α✝} {a : α✝} {ys : List α✝} :
a ∈ xs ++ a :: ysh
huList.eq_append_cons_of_mem}(hj?%  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.eq_append_cons_of_mem {α : Type u_1} {a : α} {xs : List α} (h : a ∈ xs) :
∃ (as : List α), ∃ (bs : List α), xs = as ++ a :: bs ∧ ¬a ∈ ash
huList.mem_cons_of_mem}(hjC%  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhgtheorem List.mem_cons_of_mem {α : Type u_1} (y : α) {a : α} {l : List α} :
a ∈ l → a ∈ y :: lh
huList.exists_mem_of_ne_nil}(hjG%  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhftheorem List.exists_mem_of_ne_nil {α : Type u_1} (l : List α) (h : l ≠ []) :
∃ (x : α), x ∈ lh
huList.eq_nil_iff_forall_not_mem}(hjK%  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhitheorem List.eq_nil_iff_forall_not_mem {α : Type u_1} {l : List α} :
l = [] ↔ ∀ (a : α), ¬a ∈ lh
huList.mem_dite_nil_left}(hjO%  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.mem_dite_nil_left {α : Type u_1} {p : Prop} {x : α} [Decidable p] {l : ¬p → List α} :
(x ∈ if h : p then [] else l h) ↔ ∃ (h : ¬p), x ∈ l hh
huList.mem_dite_nil_right}(hjS%  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.mem_dite_nil_right {α : Type u_1} {p : Prop} {x : α} [Decidable p] {l : p → List α} :
(x ∈ if h : p then l h else []) ↔ ∃ (h : p), x ∈ l hh
huList.mem_ite_nil_left}(hjW%  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.mem_ite_nil_left {α : Type u_1} {p : Prop} {x : α} [Decidable p] {l : List α} :
(x ∈ if p then [] else l) ↔ ¬p ∧ x ∈ lh
huList.mem_ite_nil_right}(hj[%  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.mem_ite_nil_right {α : Type u_1} {p : Prop} {x : α} [Decidable p] {l : List α} :
(x ∈ if p then l else []) ↔ p ∧ x ∈ lh
huList.eq_of_mem_singleton}(hj_%  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhWtheorem List.eq_of_mem_singleton {α✝ : Type u_1} {b a : α✝} :
a ∈ [b] → a = bh
huList.mem_singleton}(hjc%  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhKtheorem List.mem_singleton {α : Type u_1} {a b : α} :
a ∈ [b] ↔ a = bh
huList.forall_mem_cons}(hjg%  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.forall_mem_cons {α : Type u_1} {p : α → Prop} {a : α} {l : List α} :
(∀ (x : α), x ∈ a :: l → p x) ↔ p a ∧ ∀ (x : α), x ∈ l → p xh
huList.forall_mem_ne}(hjk%  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhxtheorem List.forall_mem_ne {α : Type u_1} {a : α} {l : List α} :
(∀ (a' : α), a' ∈ l → ¬a = a') ↔ ¬a ∈ lh
huList.forall_mem_ne'}(hjo%  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhytheorem List.forall_mem_ne' {α : Type u_1} {a : α} {l : List α} :
(∀ (a' : α), a' ∈ l → ¬a' = a) ↔ ¬a ∈ lh
huList.exists_mem_nil}(hjs%  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhitheorem List.exists_mem_nil {α : Type u_1} (p : α → Prop) :
¬∃ (x : α), ∃ (x_1 : x ∈ []), p xh
huList.forall_mem_nil}(hjw%  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhYtheorem List.forall_mem_nil {α : Type u_1} (p : α → Prop) (x : α) :
x ∈ [] → p xh
huList.exists_mem_cons}(hj{%  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.exists_mem_cons {α : Type u_1} {p : α → Prop} {a : α} {l : List α} :
(∃ (x : α), ∃ (x_1 : x ∈ a :: l), p x) ↔ p a ∨ ∃ (x : α), ∃ (x_1 : x ∈ l), p xh
huList.forall_mem_singleton}(hj%  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhxtheorem List.forall_mem_singleton {α : Type u_1} {p : α → Prop} {a : α} :
(∀ (x : α), x ∈ [a] → p x) ↔ p ah
huList.mem_nil_iff}(hj%  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhFtheorem List.mem_nil_iff {α : Type u_1} (a : α) :
a ∈ [] ↔ Falseh
huList.mem_singleton_self}(hj%  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhDtheorem List.mem_singleton_self {α : Type u_1} (a : α) :
a ∈ [a]h
huList.mem_of_mem_cons_of_mem}(hj%  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhstheorem List.mem_of_mem_cons_of_mem {α : Type u_1} {a b : α} {l : List α} :
a ∈ b :: l → b ∈ l → a ∈ lh
huList.eq_or_ne_mem_of_mem}(hj%  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlh}theorem List.eq_or_ne_mem_of_mem {α : Type u_1} {a b : α} {l : List α} (h' : a ∈ b :: l) :
a = b ∨ a ≠ b ∧ a ∈ lh
huList.ne_nil_of_mem}(hj%  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhZtheorem List.ne_nil_of_mem {α : Type u_1} {a : α} {l : List α} (h : a ∈ l) :
l ≠ []h
huList.mem_of_ne_of_mem}(hj%  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhwtheorem List.mem_of_ne_of_mem {α : Type u_1} {a y : α} {l : List α} (h₁ : a ≠ y) (h₂ : a ∈ y :: l) :
a ∈ lh
huList.ne_of_not_mem_cons}(hj%  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhetheorem List.ne_of_not_mem_cons {α : Type u_1} {a b : α} {l : List α} :
¬a ∈ b :: l → a ≠ bh
huList.not_mem_of_not_mem_cons}(hj%  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhltheorem List.not_mem_of_not_mem_cons {α : Type u_1} {a b : α} {l : List α} :
¬a ∈ b :: l → ¬a ∈ lh
hu"List.not_mem_cons_of_ne_of_not_mem}(hj%  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlh~theorem List.not_mem_cons_of_ne_of_not_mem {α : Type u_1} {a y : α} {l : List α} :
a ≠ y → ¬a ∈ l → ¬a ∈ y :: lh
hu#List.ne_and_not_mem_of_not_mem_cons}(hj%  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.ne_and_not_mem_of_not_mem_cons {α : Type u_1} {a y : α} {l : List α} :
¬a ∈ y :: l → a ≠ y ∧ ¬a ∈ lh
huList.getElem_of_mem}(hj%  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.getElem_of_mem {α : Type u_1} {a : α} {l : List α} :
a ∈ l → ∃ (i : Nat), ∃ (h : i < l.length), l[i] = ah
huList.getElem?_of_mem}(hj%  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhqtheorem List.getElem?_of_mem {α : Type u_1} {a : α} {l : List α} (h : a ∈ l) :
∃ (i : Nat), l[i]? = some ah
huList.mem_of_getElem}(hj%  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhxtheorem List.mem_of_getElem {α : Type u_1} {l : List α} {i : Nat} {h : i < l.length} {a : α} (e : l[i] = a) :
a ∈ lh
huList.mem_of_getElem?}(hj%  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhltheorem List.mem_of_getElem? {α : Type u_1} {l : List α} {i : Nat} {a : α} (e : l[i]? = some a) :
a ∈ lh
huList.mem_iff_getElem}(hj%  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.mem_iff_getElem {α : Type u_1} {a : α} {l : List α} :
a ∈ l ↔ ∃ (i : Nat), ∃ (h : i < l.length), l[i] = ah
huList.mem_iff_getElem?}(hj%  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhptheorem List.mem_iff_getElem? {α : Type u_1} {a : α} {l : List α} :
a ∈ l ↔ ∃ (i : Nat), l[i]? = some ah
huList.forall_getElem}(hj%  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.forall_getElem {α : Type u_1} {l : List α} {p : α → Prop} :
(∀ (i : Nat) (h : i < l.length), p l[i]) ↔ ∀ (a : α), a ∈ l → p ah
huList.elem_eq_contains}(hj%  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhgtheorem List.elem_eq_contains {α : Type u_1} [BEq α] {a : α} {l : List α} :
elem a l = l.contains ah
huList.decide_mem_cons}(hj%  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.decide_mem_cons {α : Type u_1} {a y : α} [BEq α] [LawfulBEq α] {l : List α} :
decide (y ∈ a :: l) = (y == a || decide (y ∈ l))h
hu
List.elem_iff}(hj%  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhutheorem List.elem_iff {α : Type u_1} [BEq α] [LawfulBEq α] {a : α} {as : List α} :
elem a as = true ↔ a ∈ ash
huList.contains_iff}(hj%  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlh}theorem List.contains_iff {α : Type u_1} [BEq α] [LawfulBEq α] {a : α} {as : List α} :
as.contains a = true ↔ a ∈ ash
huList.elem_eq_mem}(hj%  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhxtheorem List.elem_eq_mem {α : Type u_1} [BEq α] [LawfulBEq α] (a : α) (as : List α) :
elem a as = decide (a ∈ as)h
huList.contains_eq_mem}(hj%  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.contains_eq_mem {α : Type u_1} [BEq α] [LawfulBEq α] (a : α) (as : List α) :
as.contains a = decide (a ∈ as)h
huList.contains_cons}(hj%  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlh}theorem List.contains_cons {α : Type u_1} [BEq α] {a b : α} {l : List α} :
(a :: l).contains b = (b == a || l.contains b)h
huList.isEmpty_iff}(hj%  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhTtheorem List.isEmpty_iff {α : Type u_1} {l : List α} :
l.isEmpty = true ↔ l = []h
huList.nil_of_isEmpty}(hj%  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhYtheorem List.nil_of_isEmpty {α : Type u_1} {l : List α} (h : l.isEmpty = true) :
l = []h
huList.isEmpty_eq_true}(hj%  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhWabbrev List.isEmpty_eq_true {α : Type u_1} {l : List α} :
l.isEmpty = true ↔ l = []h
huList.isEmpty_eq_false_iff}(hj%  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlh`theorem List.isEmpty_eq_false_iff {α : Type u_1} {l : List α} :
l.isEmpty = false ↔ l ≠ []h
huList.isEmpty_eq_false}(hj%  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlh[abbrev List.isEmpty_eq_false {α : Type u_1} {l : List α} :
l.isEmpty = false ↔ l ≠ []h
hu$List.isEmpty_eq_false_iff_exists_mem}(hj%  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlh{theorem List.isEmpty_eq_false_iff_exists_mem {α : Type u_1} {xs : List α} :
xs.isEmpty = false ↔ ∃ (x : α), x ∈ xsh
huList.isEmpty_iff_length_eq_zero}(hj%  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhitheorem List.isEmpty_iff_length_eq_zero {α : Type u_1} {l : List α} :
l.isEmpty = true ↔ l.length = 0h
huList.any_eq}(hj%  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlh}theorem List.any_eq {α : Type u_1} {p : α → Bool} {l : List α} :
l.any p = decide (∃ (x : α), x ∈ l ∧ p x = true)h
huList.all_eq}(hj&  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlh}theorem List.all_eq {α : Type u_1} {p : α → Bool} {l : List α} :
l.all p = decide (∀ (x : α), x ∈ l → p x = true)h
huList.decide_exists_mem}(hj&  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.decide_exists_mem {α : Type u_1} {l : List α} {p : α → Prop} [DecidablePred p] :
decide (∃ (x : α), x ∈ l ∧ p x) = l.any fun (b : α) => decide (p b)h
huList.decide_forall_mem}(hj&  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.decide_forall_mem {α : Type u_1} {l : List α} {p : α → Prop} [DecidablePred p] :
decide (∀ (x : α), x ∈ l → p x) = l.all fun (b : α) => decide (p b)h
huList.any_eq_true}(hj&  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.any_eq_true {α : Type u_1} {p : α → Bool} {l : List α} :
l.any p = true ↔ ∃ (x : α), x ∈ l ∧ p x = trueh
huList.all_eq_true}(hj&  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.all_eq_true {α : Type u_1} {p : α → Bool} {l : List α} :
l.all p = true ↔ ∀ (x : α), x ∈ l → p x = trueh
huList.any_eq_false}(hj&  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.any_eq_false {α : Type u_1} {p : α → Bool} {l : List α} :
l.any p = false ↔ ∀ (x : α), x ∈ l → ¬p x = trueh
huList.all_eq_false}(hj&  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.all_eq_false {α : Type u_1} {p : α → Bool} {l : List α} :
l.all p = false ↔ ∃ (x : α), x ∈ l ∧ ¬p x = trueh
huList.any_beq}(hj&  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhttheorem List.any_beq {α : Type u_1} [BEq α] {l : List α} {a : α} :
(l.any fun (x : α) => a == x) = l.contains ah
hu
List.any_beq'}(hj#&  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.any_beq' {α : Type u_1} {a : α} [BEq α] [PartialEquivBEq α] {l : List α} :
(l.any fun (x : α) => x == a) = l.contains ah
$Variant of any_beq with == reversed.uList.all_bne}(hj(&  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhutheorem List.all_bne {α : Type u_1} {a : α} [BEq α] {l : List α} :
(l.all fun (x : α) => a != x) = !l.contains ah
hu
List.all_bne'}(hj,&  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.all_bne' {α : Type u_1} {a : α} [BEq α] [PartialEquivBEq α] {l : List α} :
(l.all fun (x : α) => x != a) = !l.contains ah
$Variant of all_bne with != reversed.uList.set_nil}(hj1&  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhItheorem List.set_nil {α : Type u_1} {i : Nat} {a : α} :
[].set i a = []h
huList.set_cons_zero}(hj5&  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhitheorem List.set_cons_zero {α : Type u_1} {x : α} {xs : List α} {a : α} :
(x :: xs).set 0 a = a :: xsh
huList.set_cons_succ}(hj9&  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.set_cons_succ {α : Type u_1} {x : α} {xs : List α} {i : Nat} {a : α} :
(x :: xs).set (i + 1) a = x :: xs.set i ah
huList.getElem_set_self}(hj=&  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.getElem_set_self {α : Type u_1} {l : List α} {i : Nat} {a : α} (h : i < (l.set i a).length) :
(l.set i a)[i] = ah
huList.getElem?_set_self}(hjA&  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlh}theorem List.getElem?_set_self {α : Type u_1} {l : List α} {i : Nat} {a : α} (h : i < l.length) :
(l.set i a)[i]? = some ah
huList.getElem?_set_self'}(hjE&  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.getElem?_set_self' {α : Type u_1} {l : List α} {i : Nat} {a : α} :
(l.set i a)[i]? = Function.const α a <$> l[i]?h
pThis differs from getElem?_set_self by monadically mapping Function.const _ a over the Option returned by l[i]?.uList.getElem_set_ne}(hjJ&  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.getElem_set_ne {α : Type u_1} {l : List α} {i j : Nat} (h : i ≠ j) {a : α} (hj : j < (l.set i a).length) :
(l.set i a)[j] = l[j]h
huList.getElem?_set_ne}(hjN&  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhwtheorem List.getElem?_set_ne {α : Type u_1} {l : List α} {i j : Nat} (h : i ≠ j) {a : α} :
(l.set i a)[j]? = l[j]?h
huList.getElem_set}(hjR&  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.getElem_set {α : Type u_1} {l : List α} {i j : Nat} {a : α} (h : j < (l.set i a).length) :
(l.set i a)[j] = if i = j then a else l[j]h
huList.getElem?_set}(hjV&  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.getElem?_set {α : Type u_1} {l : List α} {i j : Nat} {a : α} :
(l.set i a)[j]? = if i = j then if i < l.length then some a else none else l[j]?h
huList.getElem?_set'}(hjZ&  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.getElem?_set' {α : Type u_1} {l : List α} {i j : Nat} {a : α} :
(l.set i a)[j]? = if i = j then Function.const α a <$> l[j]? else l[j]?h
jThis differs from getElem?_set by monadically mapping Function.const _ a over the Option returned by l[j]?uList.set_getElem_self}(hj_&  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhptheorem List.set_getElem_self {α : Type u_1} {as : List α} {i : Nat} (h : i < as.length) :
as.set i as[i] = ash
huList.set_eq_of_length_le}(hjc&  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhvtheorem List.set_eq_of_length_le {α : Type u_1} {l : List α} {i : Nat} (h : l.length ≤ i) {a : α} :
l.set i a = lh
huList.set_eq_nil_iff}(hjg&  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhhtheorem List.set_eq_nil_iff {α : Type u_1} {l : List α} (i : Nat) (a : α) :
l.set i a = [] ↔ l = []h
hu
List.set_comm}(hjk&  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.set_comm {α : Type u_1} (a b : α) {i j : Nat} {l : List α} :
i ≠ j → (l.set i a).set j b = (l.set j b).set i ah
huList.set_set}(hjo&  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhptheorem List.set_set {α : Type u_1} (a : α) {b : α} {l : List α} {i : Nat} :
(l.set i a).set i b = l.set i bh
huList.mem_set}(hjs&  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhjtheorem List.mem_set {α : Type u_1} {l : List α} {i : Nat} (h : i < l.length) (a : α) :
a ∈ l.set i ah
huList.mem_or_eq_of_mem_set}(hjw&  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlh|theorem List.mem_or_eq_of_mem_set {α : Type u_1} {l : List α} {i : Nat} {a b : α} :
a ∈ l.set i b → a ∈ l ∨ a = bh
huList.beq_nil_eq}(hj{&  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhVtheorem List.beq_nil_eq {α : Type u_1} [BEq α] {l : List α} :
(l == []) = l.isEmptyh
huList.nil_beq_eq}(hj&  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhVtheorem List.nil_beq_eq {α : Type u_1} [BEq α] {l : List α} :
([] == l) = l.isEmptyh
huList.beq_nil_iff}(hj&  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhVabbrev List.beq_nil_iff {α : Type u_1} [BEq α] {l : List α} :
(l == []) = l.isEmptyh
huList.nil_beq_iff}(hj&  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhVabbrev List.nil_beq_iff {α : Type u_1} [BEq α] {l : List α} :
([] == l) = l.isEmptyh
huList.cons_beq_cons}(hj&  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.cons_beq_cons {α : Type u_1} [BEq α] {a b : α} {l₁ l₂ : List α} :
(a :: l₁ == b :: l₂) = (a == b && l₁ == l₂)h
huList.concat_beq_concat}(hj&  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.concat_beq_concat {α : Type u_1} [BEq α] {a b : α} {l₁ l₂ : List α} :
(l₁ ++ [a] == l₂ ++ [b]) = (l₁ == l₂ && a == b)h
huList.length_eq_of_beq}(hj&  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.length_eq_of_beq {α : Type u_1} [BEq α] {l₁ l₂ : List α} (h : (l₁ == l₂) = true) :
l₁.length = l₂.lengthh
huList.replicate_beq_replicate}(hj&  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.replicate_beq_replicate {α : Type u_1} [BEq α] {a b : α} {n : Nat} :
(replicate n a == replicate n b) = (n == 0 || a == b)h
huList.reflBEq_iff}(hj&  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhTtheorem List.reflBEq_iff {α : Type u_1} [BEq α] :
ReflBEq (List α) ↔ ReflBEq αh
huList.lawfulBEq_iff}(hj&  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhZtheorem List.lawfulBEq_iff {α : Type u_1} [BEq α] :
LawfulBEq (List α) ↔ LawfulBEq αh
hu
List.isEqv_eq}(hj&  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.isEqv_eq {α : Type u_1} [BEq α] [LawfulBEq α] {l₁ l₂ : List α} :
((l₁.isEqv l₂ fun (x1 x2 : α) => x1 == x2) = true) = (l₁ = l₂)h
huList.getLast_eq_getElem}(hj&  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhltheorem List.getLast_eq_getElem {α : Type u_1} {l : List α} (h : l ≠ []) :
l.getLast h = l[l.length - 1]h
hu&List.getElem_length_sub_one_eq_getLast}(hj&  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.getElem_length_sub_one_eq_getLast {α : Type u_1} {l : List α} (h : l.length - 1 < l.length) :
l[l.length - 1] = l.getLast ⋯h
huList.getLast_cons_cons}(hj&  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhztheorem List.getLast_cons_cons {α : Type u_1} {b a : α} {l : List α} :
(a :: b :: l).getLast ⋯ = (b :: l).getLast ⋯h
huList.getLast_cons}(hj&  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhttheorem List.getLast_cons {α : Type u_1} {a : α} {l : List α} (h : l ≠ []) :
(a :: l).getLast ⋯ = l.getLast hh
huList.getLast_eq_getLastD}(hj&  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.getLast_eq_getLastD {α : Type u_1} {a : α} {l : List α} (h : a :: l ≠ []) :
(a :: l).getLast h = l.getLastD ah
huList.getLastD_eq_getLast?}(hj&  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhktheorem List.getLastD_eq_getLast? {α : Type u_1} {a : α} {l : List α} :
l.getLastD a = l.getLast?.getD ah
huList.getLast_singleton}(hj&  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlh\theorem List.getLast_singleton {α : Type u_1} {a : α} (h : [a] ≠ []) :
[a].getLast h = ah
huList.getLast!_cons_eq_getLastD}(hj&  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.getLast!_cons_eq_getLastD {α : Type u_1} {a : α} {l : List α} [Inhabited α] :
(a :: l).getLast! = l.getLastD ah
huList.getLast_mem}(hj&  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhYtheorem List.getLast_mem {α : Type u_1} {l : List α} (h : l ≠ []) :
l.getLast h ∈ lh
huList.getLast_mem_getLast?}(hj&  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhktheorem List.getLast_mem_getLast? {α : Type u_1} {l : List α} (h : l ≠ []) :
l.getLast h ∈ l.getLast?h
huList.getLast?_eq_some_getLast}(hj&  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhttheorem List.getLast?_eq_some_getLast {α : Type u_1} {l : List α} (h : l ≠ []) :
l.getLast? = some (l.getLast h)h
huList.getLastD_mem_cons}(hj&  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlh_theorem List.getLastD_mem_cons {α : Type u_1} {l : List α} {a : α} :
l.getLastD a ∈ a :: lh
huList.getElem_cons_length}(hj&  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.getElem_cons_length {α : Type u_1} {x : α} {xs : List α} {i : Nat} (h : i = xs.length) :
(x :: xs)[i] = (x :: xs).getLast ⋯h
huList.getLast?_singleton}(hj&  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhPtheorem List.getLast?_singleton {α : Type u_1} {a : α} :
[a].getLast? = some ah
huList.getLast?_eq_getLast}(hj&  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhotheorem List.getLast?_eq_getLast {α : Type u_1} {l : List α} (h : l ≠ []) :
l.getLast? = some (l.getLast h)h
huList.getLast?_eq_getElem?}(hj&  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlh_theorem List.getLast?_eq_getElem? {α : Type u_1} {l : List α} :
l.getLast? = l[l.length - 1]?h
hu$List.getLast_eq_iff_getLast?_eq_some}(hj&  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.getLast_eq_iff_getLast?_eq_some {α : Type u_1} {a : α} {xs : List α} (h : xs ≠ []) :
xs.getLast h = a ↔ xs.getLast? = some ah
huList.getLast?_cons}(hj&  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhptheorem List.getLast?_cons {α : Type u_1} {l : List α} {a : α} :
(a :: l).getLast? = some (l.getLast?.getD a)h
huList.getLast?_cons_cons}(hj&  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlh~theorem List.getLast?_cons_cons {α✝ : Type u_1} {a b : α✝} {l : List α✝} :
(a :: b :: l).getLast? = (b :: l).getLast?h
huList.getLast?_concat}(hj&  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhbtheorem List.getLast?_concat {α : Type u_1} {l : List α} {a : α} :
(l ++ [a]).getLast? = some ah
huList.getLastD_concat}(hj&  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhatheorem List.getLastD_concat {α : Type u_1} {a b : α} {l : List α} :
(l ++ [b]).getLastD a = bh
huList.getLast!_nil}(hj&  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhPtheorem List.getLast!_nil {α : Type u_1} [Inhabited α] :
[].getLast! = defaulth
huList.getLast!_eq_getLast?_getD}(hj&  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhztheorem List.getLast!_eq_getLast?_getD {α : Type u_1} [Inhabited α] {l : List α} :
l.getLast! = l.getLast?.getD defaulth
huList.getLast!_of_getLast?}(hj'  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.getLast!_of_getLast? {α : Type u_1} {a : α} [Inhabited α] {l : List α} :
l.getLast? = some a → l.getLast! = ah
huList.getLast!_eq_getElem!}(hj'  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhntheorem List.getLast!_eq_getElem! {α : Type u_1} [Inhabited α] {l : List α} :
l.getLast! = l[l.length - 1]!h
huList.head?_singleton}(hj'  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhJtheorem List.head?_singleton {α : Type u_1} {a : α} :
[a].head? = some ah
huList.head!_of_head?}(hj'  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhttheorem List.head!_of_head? {α : Type u_1} {a : α} [Inhabited α] {l : List α} :
l.head? = some a → l.head! = ah
huList.head?_eq_head}(hj'  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhctheorem List.head?_eq_head {α : Type u_1} {l : List α} (h : l ≠ []) :
l.head? = some (l.head h)h
huList.head?_eq_getElem?}(hj'  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhNtheorem List.head?_eq_getElem? {α : Type u_1} {l : List α} :
l.head? = l[0]?h
huList.head_singleton}(hj'  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhGtheorem List.head_singleton {α : Type u_1} {a : α} :
[a].head ⋯ = ah
huList.head_eq_getElem}(hj'  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlh[theorem List.head_eq_getElem {α : Type u_1} {l : List α} (h : l ≠ []) :
l.head h = l[0]h
huList.getElem_zero_eq_head}(hj#'  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhftheorem List.getElem_zero_eq_head {α : Type u_1} {l : List α} (h : 0 < l.length) :
l[0] = l.head ⋯h
huList.head_eq_iff_head?_eq_some}(hj''  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.head_eq_iff_head?_eq_some {α : Type u_1} {a : α} {xs : List α} (h : xs ≠ []) :
xs.head h = a ↔ xs.head? = some ah
huList.head?_eq_none_iff}(hj+'  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlh^theorem List.head?_eq_none_iff {α✝ : Type u_1} {l : List α✝} :
l.head? = none ↔ l = []h
huList.head?_eq_some_iff}(hj/'  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.head?_eq_some_iff {α : Type u_1} {xs : List α} {a : α} :
xs.head? = some a ↔ ∃ (ys : List α), xs = a :: ysh
huList.isSome_head?}(hj3'  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhbtheorem List.isSome_head? {α✝ : Type u_1} {l : List α✝} :
l.head?.isSome = true ↔ l ≠ []h
huList.head?_isSome}(hj7'  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhaabbrev List.head?_isSome {α✝ : Type u_1} {l : List α✝} :
l.head?.isSome = true ↔ l ≠ []h
hu
List.head_mem}(hj;'  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhStheorem List.head_mem {α : Type u_1} {l : List α} (h : l ≠ []) :
l.head h ∈ lh
huList.mem_of_head?}(hj?'  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlh_theorem List.mem_of_head? {α : Type u_1} {l : List α} {a : α} :
l.head? = some a → a ∈ lh
huList.mem_of_mem_head?}(hjC'  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlh`theorem List.mem_of_mem_head? {α : Type u_1} {l : List α} {a : α} :
a ∈ l.head? → a ∈ lh
huList.head_mem_head?}(hjG'  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlh_theorem List.head_mem_head? {α : Type u_1} {l : List α} (h : l ≠ []) :
l.head h ∈ l.head?h
huList.head?_eq_some_head}(hjK'  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhhtheorem List.head?_eq_some_head {α : Type u_1} {l : List α} (h : l ≠ []) :
l.head? = some (l.head h)h
huList.head?_concat}(hjO'  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhktheorem List.head?_concat {α : Type u_1} {l : List α} {a : α} :
(l ++ [a]).head? = some (l.head?.getD a)h
huList.head?_concat_concat}(hjS'  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlh{theorem List.head?_concat_concat {α✝ : Type u_1} {l : List α✝} {a b : α✝} :
(l ++ [a, b]).head? = (l ++ [a]).head?h
huList.head_of_head?_eq_some}(hjW'  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhrtheorem List.head_of_head?_eq_some {α : Type u_1} {l : List α} {x : α} (hx : l.head? = some x) :
l.head ⋯ = xh
huList.head_of_mem_head?}(hj['  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhktheorem List.head_of_mem_head? {α : Type u_1} {l : List α} {x : α} (hx : x ∈ l.head?) :
l.head ⋯ = xh
huList.headD_eq_head?_getD}(hj_'  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhdtheorem List.headD_eq_head?_getD {α : Type u_1} {a : α} {l : List α} :
l.headD a = l.head?.getD ah
5simp unfolds headD in terms of head? and Option.getD.uList.tailD_eq_tail?}(hjd'  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlh[theorem List.tailD_eq_tail? {α : Type u_1} {l l' : List α} :
l.tailD l' = l.tail?.getD l'h
5simp unfolds tailD in terms of tail? and Option.getD.uList.length_tail}(hji'  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhUtheorem List.length_tail {α : Type u_1} {l : List α} :
l.tail.length = l.length - 1h
huList.tail_eq_tailD}(hjm'  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhNtheorem List.tail_eq_tailD {α : Type u_1} {l : List α} :
l.tail = l.tailD []h
huList.tail_eq_tail?}(hjq'  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhStheorem List.tail_eq_tail? {α : Type u_1} {l : List α} :
l.tail = l.tail?.getD []h
huList.mem_of_mem_tail}(hju'  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlh`theorem List.mem_of_mem_tail {α : Type u_1} {a : α} {l : List α} (h : a ∈ l.tail) :
a ∈ lh
huList.ne_nil_of_tail_ne_nil}(hjy'  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlh]theorem List.ne_nil_of_tail_ne_nil {α : Type u_1} {l : List α} :
l.tail ≠ [] → l ≠ []h
huList.getElem_tail}(hj}'  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhptheorem List.getElem_tail {α : Type u_1} {l : List α} {i : Nat} (h : i < l.tail.length) :
l.tail[i] = l[i + 1]h
huList.getElem?_tail}(hj'  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlh[theorem List.getElem?_tail {α : Type u_1} {l : List α} {i : Nat} :
l.tail[i]? = l[i + 1]?h
hu
List.set_tail}(hj'  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhptheorem List.set_tail {α : Type u_1} {l : List α} {i : Nat} {a : α} :
l.tail.set i a = (l.set (i + 1) a).tailh
hu!List.one_lt_length_of_tail_ne_nil}(hj'  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhjtheorem List.one_lt_length_of_tail_ne_nil {α : Type u_1} {l : List α} (h : l.tail ≠ []) :
1 < l.lengthh
huList.head_tail}(hj'  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlh_theorem List.head_tail {α : Type u_1} {l : List α} (h : l.tail ≠ []) :
l.tail.head h = l[1]h
huList.head?_tail}(hj'  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhLtheorem List.head?_tail {α : Type u_1} {l : List α} :
l.tail.head? = l[1]?h
huList.getLast_tail}(hj'  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhntheorem List.getLast_tail {α : Type u_1} {l : List α} (h : l.tail ≠ []) :
l.tail.getLast h = l.getLast ⋯h
huList.getLast?_tail}(hj'  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhvtheorem List.getLast?_tail {α : Type u_1} {l : List α} :
l.tail.getLast? = if l.length = 1 then none else l.getLast?h
huList.cons_head_tail}(hj'  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhgtheorem List.cons_head_tail {α✝ : Type u_1} {l : List α✝} (h : l ≠ []) :
l.head h :: l.tail = lh
huList.length_map}(hj'  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhvtheorem List.length_map {α : Type u_1} {β : Type u_2} {as : List α} (f : α → β) :
(map f as).length = as.lengthh
huList.isEmpty_map}(hj'  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhvtheorem List.isEmpty_map {α : Type u_1} {β : Type u_2} {l : List α} {f : α → β} :
(map f l).isEmpty = l.isEmptyh
huList.getElem?_map}(hj'  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.getElem?_map {α : Type u_1} {β : Type u_2} {f : α → β} {l : List α} {i : Nat} :
(map f l)[i]? = Option.map f l[i]?h
huList.getElem_map}(hj'  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.getElem_map {α : Type u_1} {β : Type u_2} (f : α → β) {l : List α} {i : Nat} {h : i < (map f l).length} :
(map f l)[i] = f l[i]h
huList.map_id_fun}(hj'  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlh5theorem List.map_id_fun {α : Type u_1} :
map id = idh
huList.map_id_fun'}(hj'  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhGtheorem List.map_id_fun' {α : Type u_1} :
(map fun (a : α) => a) = idh
fmap_id_fun' differs from map_id_fun by representing the identity function as a lambda, rather than id.uList.map_id}(hj'  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlh@theorem List.map_id {α : Type u_1} (l : List α) :
map id l = lh
huList.map_id'}(hj'  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhRtheorem List.map_id' {α : Type u_1} (l : List α) :
map (fun (a : α) => a) l = lh
^map_id' differs from map_id by representing the identity function as a lambda, rather than id.u
List.map_id''}(hj'  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhmtheorem List.map_id'' {α : Type u_1} {f : α → α} (h : ∀ (x : α), f x = x) (l : List α) :
map f l = lh
UVariant of map_id, with a side condition that the function is pointwise the identity.uList.map_singleton}(hj'  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhgtheorem List.map_singleton {α : Type u_1} {β : Type u_2} {f : α → β} {a : α} :
map f [a] = [f a]h
huList.mem_map}(hj'  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.mem_map {α : Type u_1} {β : Type u_2} {b : β} {f : α → β} {l : List α} :
b ∈ map f l ↔ ∃ (a : α), a ∈ l ∧ f a = bh
huList.exists_of_mem_map}(hj'  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.exists_of_mem_map {α✝ : Type u_1} {α✝¹ : Type u_2} {f : α✝ → α✝¹} {l : List α✝} {b : α✝¹} (h : b ∈ map f l) :
∃ (a : α✝), a ∈ l ∧ f a = b      h
huList.mem_map_of_mem}(hj'  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.mem_map_of_mem {α : Type u_1} {β : Type u_2} {l : List α} {a : α} {f : α → β} (h : a ∈ l) :
f a ∈ map f lh
huList.forall_mem_map}(hj'  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.forall_mem_map {α : Type u_1} {β : Type u_2} {f : α → β} {l : List α} {P : β → Prop} :
(∀ (i : β), i ∈ map f l → P i) ↔ ∀ (j : α), j ∈ l → P (f j)h
huList.map_eq_nil_iff}(hj'  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhstheorem List.map_eq_nil_iff {α : Type u_1} {β : Type u_2} {f : α → β} {l : List α} :
map f l = [] ↔ l = []h
huList.eq_nil_of_map_eq_nil}(hj'  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlh{theorem List.eq_nil_of_map_eq_nil {α : Type u_1} {β : Type u_2} {f : α → β} {l : List α} (h : map f l = []) :
l = []h
huList.map_inj_left}(hj'  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.map_inj_left {α : Type u_1} {β : Type u_2} {l : List α} {f g : α → β} :
map f l = map g l ↔ ∀ (a : α), a ∈ l → f a = g ah
huList.map_inj_right}(hj'  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.map_inj_right {α : Type u_1} {β : Type u_2} {l l' : List α} {f : α → β} (w : ∀ (x y : α), f x = f y → x = y) :
map f l = map f l' ↔ l = l'h
huList.map_congr_left}(hj'  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.map_congr_left {α✝ : Type u_1} {l : List α✝} {α✝¹ : Type u_2} {f g : α✝ → α✝¹} (h : ∀ (a : α✝), a ∈ l → f a = g a) :
map f l = map g lh
huList.map_inj}(hj'  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhptheorem List.map_inj {α✝ : Type u_1} {α✝¹ : Type u_2} {f g : α✝ → α✝¹} :
map f = map g ↔ f = gh
huList.map_eq_cons_iff}(hj'  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.map_eq_cons_iff {α : Type u_1} {β : Type u_2} {b : β} {l₂ : List β} {f : α → β} {l : List α} :
map f l = b :: l₂ ↔ ∃ (a : α), ∃ (l₁ : List α), l = a :: l₁ ∧ f a = b ∧ map f l₁ = l₂h
huList.map_eq_cons_iff'}(hj'  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.map_eq_cons_iff' {α : Type u_1} {β : Type u_2} {b : β} {l₂ : List β} {f : α → β} {l : List α} :
map f l = b :: l₂ ↔ Option.map f l.head? = some b ∧ Option.map (map f) l.tail? = some l₂h
huList.map_eq_singleton_iff}(hj'  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.map_eq_singleton_iff {α : Type u_1} {β : Type u_2} {f : α → β} {l : List α} {b : β} :
map f l = [b] ↔ ∃ (a : α), l = [a] ∧ f a = bh
huList.map_eq_map_iff}(hj (  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.map_eq_map_iff {α✝ : Type u_1} {α✝¹ : Type u_2} {f : α✝ → α✝¹} {l : List α✝} {g : α✝ → α✝¹} :
map f l = map g l ↔ ∀ (a : α✝), a ∈ l → f a = g ah
huList.map_eq_iff}(hj(  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.map_eq_iff {α✝ : Type u_1} {α✝¹ : Type u_2} {f : α✝ → α✝¹} {l : List α✝} {l' : List α✝¹} :
map f l = l' ↔ ∀ (i : Nat), l'[i]? = Option.map f l[i]?h
huList.map_eq_foldr}(hj(  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.map_eq_foldr {α : Type u_1} {β : Type u_2} {f : α → β} {l : List α} :
map f l = foldr (fun (a : α) (bs : List β) => f a :: bs) [] lh
huList.map_set}(hj(  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.map_set {α : Type u_1} {β : Type u_2} {f : α → β} {l : List α} {i : Nat} {a : α} :
map f (l.set i a) = (map f l).set i (f a)h
hu
List.head_map}(hj(  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.head_map {α : Type u_1} {β : Type u_2} {f : α → β} {l : List α} (w : map f l ≠ []) :
(map f l).head w = f (l.head ⋯)h
huList.head?_map}(hj(  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlh}theorem List.head?_map {α : Type u_1} {β : Type u_2} {f : α → β} {l : List α} :
(map f l).head? = Option.map f l.head?h
huList.map_tail?}(hj(  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.map_tail? {α : Type u_1} {β : Type u_2} {f : α → β} {l : List α} :
Option.map (map f) l.tail? = (map f l).tail?h
hu
List.map_tail}(hj(  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhstheorem List.map_tail {α : Type u_1} {β : Type u_2} {f : α → β} {l : List α} :
map f l.tail = (map f l).tailh
huList.headD_map}(hj (  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.headD_map {α : Type u_1} {β : Type u_2} {f : α → β} {l : List α} {a : α} :
(map f l).headD (f a) = f (l.headD a)h
huList.tailD_map}(hj$(  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.tailD_map {α : Type u_1} {β : Type u_2} {f : α → β} {l l' : List α} :
(map f l).tailD (map f l') = map f (l.tailD l')h
huList.getLast_map}(hj((  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.getLast_map {α : Type u_1} {β : Type u_2} {f : α → β} {l : List α} (h : map f l ≠ []) :
(map f l).getLast h = f (l.getLast ⋯)h
huList.getLast?_map}(hj,(  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.getLast?_map {α : Type u_1} {β : Type u_2} {f : α → β} {l : List α} :
(map f l).getLast? = Option.map f l.getLast?h
huList.getLastD_map}(hj0(  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.getLastD_map {α : Type u_1} {β : Type u_2} {f : α → β} {l : List α} {a : α} :
(map f l).getLastD (f a) = f (l.getLastD a)h
huList.map_map}(hj4(  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.map_map {β : Type u_1} {γ : Type u_2} {α : Type u_3} {g : β → γ} {f : α → β} {l : List α} :
map g (map f l) = map (g ∘ f) lh
huList.filter_cons_of_pos}(hj8(  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.filter_cons_of_pos {α : Type u_1} {p : α → Bool} {a : α} {l : List α} (pa : p a = true) :
filter p (a :: l) = a :: filter p lh
huList.filter_cons_of_neg}(hj<(  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.filter_cons_of_neg {α : Type u_1} {p : α → Bool} {a : α} {l : List α} (pa : ¬p a = true) :
filter p (a :: l) = filter p lh
huList.filter_cons}(hj@(  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.filter_cons {α : Type u_1} {x : α} {xs : List α} {p : α → Bool} :
filter p (x :: xs) = if p x = true then x :: filter p xs else filter p xsh
huList.length_filter_le}(hjD(  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhptheorem List.length_filter_le {α : Type u_1} (p : α → Bool) (l : List α) :
(filter p l).length ≤ l.lengthh
huList.filter_eq_self}(hjH(  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.filter_eq_self {α✝ : Type u_1} {p : α✝ → Bool} {l : List α✝} :
filter p l = l ↔ ∀ (a : α✝), a ∈ l → p a = trueh
hu List.length_filter_eq_length_iff}(hjL(  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.length_filter_eq_length_iff {α✝ : Type u_1} {p : α✝ → Bool} {l : List α✝} :
(filter p l).length = l.length ↔ ∀ (a : α✝), a ∈ l → p a = trueh
huList.filter_length_eq_length}(hjP(  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhabbrev List.filter_length_eq_length {α✝ : Type u_1} {p : α✝ → Bool} {l : List α✝} :
(filter p l).length = l.length ↔ ∀ (a : α✝), a ∈ l → p a = trueh
huList.mem_filter}(hjT(  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.mem_filter {α✝ : Type u_1} {p : α✝ → Bool} {as : List α✝} {x : α✝} :
x ∈ filter p as ↔ x ∈ as ∧ p x = trueh
huList.filter_eq_nil_iff}(hjX(  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.filter_eq_nil_iff {α✝ : Type u_1} {p : α✝ → Bool} {l : List α✝} :
filter p l = [] ↔ ∀ (a : α✝), a ∈ l → ¬p a = trueh
huList.forall_mem_filter}(hj\(  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.forall_mem_filter {α : Type u_1} {l : List α} {p : α → Bool} {P : α → Prop} :
(∀ (i : α), i ∈ filter p l → P i) ↔ ∀ (j : α), j ∈ l → p j = true → P jh
huList.getElem_filter}(hj`(  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.getElem_filter {α : Type u_1} {xs : List α} {p : α → Bool} {i : Nat} (h : i < (filter p xs).length) :
p (filter p xs)[i] = trueh
huList.getElem?_filter}(hjd(  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.getElem?_filter {α : Type u_1} {a : α} {xs : List α} {p : α → Bool} {i : Nat} (h : i < (filter p xs).length) (w : (filter p xs)[i]? = some a) :
p a = trueh
huList.filter_filter}(hjh(  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.filter_filter {α✝ : Type u_1} {p q : α✝ → Bool} {l : List α✝} :
filter p (filter q l) = filter (fun (a : α✝) => p a && q a) lh
huList.foldl_filter}(hjl(  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.foldl_filter {α : Type u_1} {β : Type u_2} {p : α → Bool} {f : β → α → β} {l : List α} {init : β} :
foldl f init (filter p l) = foldl (fun (x : β) (y : α) => if p y = true then f x y else x) init lh
huList.foldr_filter}(hjp(  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.foldr_filter {α : Type u_1} {β : Type u_2} {p : α → Bool} {f : α → β → β} {l : List α} {init : β} :
foldr f init (filter p l) = foldr (fun (x : α) (y : β) => if p x = true then f x y else y) init lh
huList.filter_map}(hjt(  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.filter_map {β : Type u_1} {α : Type u_2} {f : β → α} {p : α → Bool} {l : List β} :
filter p (map f l) = map f (filter (p ∘ f) l)h
huList.map_filter_eq_foldr}(hjx(  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.map_filter_eq_foldr {α : Type u_1} {β : Type u_2} {f : α → β} {p : α → Bool} {as : List α} :
map f (filter p as) = foldr (fun (a : α) (bs : List β) => bif p a then f a :: bs else bs) [] ash
huList.filter_append}(hj|(  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.filter_append {α : Type u_1} {p : α → Bool} (l₁ l₂ : List α) :
filter p (l₁ ++ l₂) = filter p l₁ ++ filter p l₂h
huList.filter_eq_cons_iff}(hj(  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhX2  theorem List.filter_eq_cons_iff {α✝ : Type u_1} {p : α✝ → Bool} {l : List α✝} {a : α✝} {as : List α✝} :
filter p l = a :: as ↔ ∃ (l₁ : List α✝), ∃ (l₂ : List α✝), l = l₁ ++ a :: l₂ ∧ (∀ (x : α✝), x ∈ l₁ → ¬p x = true) ∧ p a = true ∧ filter p l₂ = ash
huList.filter_congr}(hj(  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.filter_congr {α : Type u_1} {p q : α → Bool} {l : List α} :
(∀ (x : α), x ∈ l → p x = q x) → filter p l = filter q lh
huList.head_filter_of_pos}(hj(  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.head_filter_of_pos {α : Type u_1} {p : α → Bool} {l : List α} (w : l ≠ []) (h : p (l.head w) = true) :
(filter p l).head ⋯ = l.head wh
huList.filter_sublist}(hj(  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhdtheorem List.filter_sublist {α : Type u_1} {p : α → Bool} {l : List α} :
(filter p l).Sublist lh
huList.filterMap_cons_none}(hj(  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.filterMap_cons_none {α : Type u_1} {β : Type u_2} {f : α → Option β} {a : α} {l : List α} (h : f a = none) :
filterMap f (a :: l) = filterMap f lh
huList.filterMap_cons_some}(hj(  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.filterMap_cons_some {α : Type u_1} {β : Type u_2} {f : α → Option β} {a : α} {l : List α} {b : β} (h : f a = some b) :
filterMap f (a :: l) = b :: filterMap f lh
huList.filterMap_eq_map}(hj(  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhntheorem List.filterMap_eq_map {α : Type u_1} {β : Type u_2} {f : α → β} :
filterMap (some ∘ f) = map fh
huList.filterMap_eq_map'}(hj(  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.filterMap_eq_map' {α : Type u_1} {β : Type u_2} {f : α → β} :
(filterMap fun (x : α) => some (f x)) = map fh
EVariant of filterMap_eq_map with some ∘ f expanded out to a lambda.uList.filterMap_some_fun}(hj(  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhEtheorem List.filterMap_some_fun {α : Type u_1} :
filterMap some = idh
huList.filterMap_some}(hj(  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhPtheorem List.filterMap_some {α : Type u_1} {l : List α} :
filterMap some l = lh
hu,List.map_filterMap_some_eq_filter_map_isSome}(hj(  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.map_filterMap_some_eq_filter_map_isSome {α : Type u_1} {β : Type u_2} {f : α → Option β} {l : List α} :
map some (filterMap f l) = filter (fun (b : Option β) => b.isSome) (map f l)h
huList.length_filterMap_le}(hj(  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.length_filterMap_le {α : Type u_1} {β : Type u_2} (f : α → Option β) (l : List α) :
(filterMap f l).length ≤ l.lengthh
huList.filterMap_length_eq_length}(hj(  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.filterMap_length_eq_length {α✝ : Type u_1} {α✝¹ : Type u_2} {f : α✝ → Option α✝¹} {l : List α✝} :
(filterMap f l).length = l.length ↔ ∀ (a : α✝), a ∈ l → (f a).isSome = trueh
huList.filterMap_eq_filter}(hj(  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlh|theorem List.filterMap_eq_filter {α : Type u_1} {p : α → Bool} :
filterMap (Option.guard fun (x : α) => p x) = filter ph
huList.filterMap_filterMap}(hj(  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.filterMap_filterMap {α : Type u_1} {β : Type u_2} {γ : Type u_3} {f : α → Option β} {g : β → Option γ} {l : List α} :
filterMap g (filterMap f l) = filterMap (fun (x : α) => (f x).bind g) lh
huList.map_filterMap}(hj(  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.map_filterMap {α : Type u_1} {β : Type u_2} {γ : Type u_3} {f : α → Option β} {g : β → γ} {l : List α} :
map g (filterMap f l) = filterMap (fun (x : α) => Option.map g (f x)) lh
huList.filterMap_map}(hj(  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.filterMap_map {α : Type u_1} {β : Type u_2} {γ : Type u_3} {f : α → β} {g : β → Option γ} {l : List α} :
filterMap g (map f l) = filterMap (g ∘ f) lh
huList.filter_filterMap}(hj(  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.filter_filterMap {α : Type u_1} {β : Type u_2} {f : α → Option β} {p : β → Bool} {l : List α} :
filter p (filterMap f l) = filterMap (fun (x : α) => Option.filter p (f x)) lh
huList.filterMap_filter}(hj(  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.filterMap_filter {α : Type u_1} {β : Type u_2} {p : α → Bool} {f : α → Option β} {l : List α} :
filterMap f (filter p l) = filterMap (fun (x : α) => if p x = true then f x else none) lh
huList.mem_filterMap}(hj(  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.mem_filterMap {α : Type u_1} {β : Type u_2} {f : α → Option β} {l : List α} {b : β} :
b ∈ filterMap f l ↔ ∃ (a : α), a ∈ l ∧ f a = some bh
huList.forall_mem_filterMap}(hj(  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.forall_mem_filterMap {α : Type u_1} {β : Type u_2} {f : α → Option β} {l : List α} {P : β → Prop} :
(∀ (i : β), i ∈ filterMap f l → P i) ↔ ∀ (j : α), j ∈ l → ∀ (b : β), f j = some b → P bh
huList.filterMap_append}(hj(  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.filterMap_append {α : Type u_1} {β : Type u_2} {l l' : List α} {f : α → Option β} :
filterMap f (l ++ l') = filterMap f l ++ filterMap f l'h
huList.map_filterMap_of_inv}(hj(  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.map_filterMap_of_inv {α : Type u_1} {β : Type u_2} {f : α → Option β} {g : β → α} (H : ∀ (x : α), Option.map g (f x) = some x) {l : List α} :
map g (filterMap f l) = lh
huList.head_filterMap_of_eq_some}(hj(  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.head_filterMap_of_eq_some {α : Type u_1} {β : Type u_2} {f : α → Option β} {l : List α} (w : l ≠ []) {b : β} (h : f (l.head w) = some b) :
(filterMap f l).head ⋯ = bh
hu$List.forall_none_of_filterMap_eq_nil}(hj(  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.forall_none_of_filterMap_eq_nil {α✝ : Type u_1} {α✝¹ : Type u_2} {f : α✝ → Option α✝¹} {xs : List α✝} (h : filterMap f xs = []) (x : α✝) :
x ∈ xs → f x = noneh
huList.filterMap_eq_nil_iff}(hj(  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.filterMap_eq_nil_iff {α✝ : Type u_1} {α✝¹ : Type u_2} {f : α✝ → Option α✝¹} {l : List α✝} :
filterMap f l = [] ↔ ∀ (a : α✝), a ∈ l → f a = noneh
huList.filterMap_eq_cons_iff}(hj(  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhXo  theorem List.filterMap_eq_cons_iff {α✝ : Type u_1} {α✝¹ : Type u_2} {f : α✝ → Option α✝¹} {l : List α✝} {b : α✝¹} {bs : List α✝¹} :
filterMap f l = b :: bs ↔ ∃ (l₁ : List α✝), ∃ (a : α✝), ∃ (l₂ : List α✝), l = l₁ ++ a :: l₂ ∧ (∀ (x : α✝), x ∈ l₁ → f x = none) ∧ f a = some b ∧ filterMap f l₂ = bsh
huList.nil_append_fun}(hj(  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhQtheorem List.nil_append_fun {α : Type u_1} :
(fun (x : List α) => [] ++ x) = idh
huList.cons_append_fun}(hj(  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.cons_append_fun {α : Type u_1} {a : α} {as : List α} :
(fun (bs : List α) => a :: as ++ bs) = fun (bs : List α) => a :: (as ++ bs)h
huList.mem_append}(hj(  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhgtheorem List.mem_append {α : Type u_1} {a : α} {s t : List α} :
a ∈ s ++ t ↔ a ∈ s ∨ a ∈ th
huList.not_mem_append}(hj(  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlh{theorem List.not_mem_append {α : Type u_1} {a : α} {s t : List α} (h₁ : ¬a ∈ s) (h₂ : ¬a ∈ t) :
¬a ∈ s ++ th
huList.append_of_mem}(hj(  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.append_of_mem {α : Type u_1} {a : α} {l : List α} :
a ∈ l → ∃ (s : List α), ∃ (t : List α), l = s ++ a :: th
wSee also eq_append_cons_of_mem, which proves a stronger version in which the initial list must not contain the element.uList.mem_iff_append}(hj)  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.mem_iff_append {α : Type u_1} {a : α} {l : List α} :
a ∈ l ↔ ∃ (s : List α), ∃ (t : List α), l = s ++ a :: th
huList.forall_mem_append}(hj)  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.forall_mem_append {α : Type u_1} {p : α → Prop} {l₁ l₂ : List α} :
(∀ (x : α), x ∈ l₁ ++ l₂ → p x) ↔ (∀ (x : α), x ∈ l₁ → p x) ∧ ∀ (x : α), x ∈ l₂ → p xh
huList.getElem_append}(hj
)  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.getElem_append {α : Type u_1} {l₁ l₂ : List α} {i : Nat} (h : i < (l₁ ++ l₂).length) :
(l₁ ++ l₂)[i] = if h' : i < l₁.length then l₁[i] else l₂[i - l₁.length]h
huList.getElem?_append_left}(hj)  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.getElem?_append_left {α : Type u_1} {l₁ l₂ : List α} {i : Nat} (hn : i < l₁.length) :
(l₁ ++ l₂)[i]? = l₁[i]?h
huList.getElem?_append_right}(hj)  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.getElem?_append_right {α : Type u_1} {l₁ l₂ : List α} {i : Nat} :
l₁.length ≤ i → (l₁ ++ l₂)[i]? = l₂[i - l₁.length]?h
huList.getElem?_append}(hj)  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.getElem?_append {α : Type u_1} {l₁ l₂ : List α} {i : Nat} :
(l₁ ++ l₂)[i]? = if i < l₁.length then l₁[i]? else l₂[i - l₁.length]?h
huList.getElem_append_left'}(hj)  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.getElem_append_left' {α : Type u_1} {l₁ : List α} {i : Nat} (hi : i < l₁.length) (l₂ : List α) :
l₁[i] = (l₁ ++ l₂)[i]h
XVariant of getElem_append_left useful for rewriting from the small list to the big list.uList.getElem_append_right'}(hj)  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.getElem_append_right' {α : Type u_1} (l₁ : List α) {l₂ : List α} {i : Nat} (hi : i < l₂.length) :
l₂[i] = (l₁ ++ l₂)[i + l₁.length]h
YVariant of getElem_append_right useful for rewriting from the small list to the big list.uList.getElem_of_append}(hj$)  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.getElem_of_append {α : Type u_1} {l₁ : List α} {a : α} {l₂ : List α} {i : Nat} {l : List α} (eq : l = l₁ ++ a :: l₂) (h : l₁.length = i) :
l[i] = ah
huList.singleton_append}(hj()  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhatheorem List.singleton_append {α✝ : Type u_1} {x : α✝} {l : List α✝} :
[x] ++ l = x :: lh
huList.append_inj}(hj,)  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.append_inj {α : Type u_1} {s₁ s₂ t₁ t₂ : List α} :
s₁ ++ t₁ = s₂ ++ t₂ → s₁.length = s₂.length → s₁ = s₂ ∧ t₁ = t₂h
huList.append_inj_right}(hj0)  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.append_inj_right {α✝ : Type u_1} {s₁ t₁ s₂ t₂ : List α✝} (h : s₁ ++ t₁ = s₂ ++ t₂) (hl : s₁.length = s₂.length) :
t₁ = t₂h
huList.append_inj_left}(hj4)  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.append_inj_left {α✝ : Type u_1} {s₁ t₁ s₂ t₂ : List α✝} (h : s₁ ++ t₁ = s₂ ++ t₂) (hl : s₁.length = s₂.length) :
s₁ = s₂h
huList.append_inj'}(hj8)  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.append_inj' {α✝ : Type u_1} {s₁ t₁ s₂ t₂ : List α✝} (h : s₁ ++ t₁ = s₂ ++ t₂) (hl : t₁.length = t₂.length) :
s₁ = s₂ ∧ t₁ = t₂h
TVariant of append_inj instead requiring equality of the lengths of the second lists.uList.append_inj_right'}(hj=)  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.append_inj_right' {α✝ : Type u_1} {s₁ t₁ s₂ t₂ : List α✝} (h : s₁ ++ t₁ = s₂ ++ t₂) (hl : t₁.length = t₂.length) :
t₁ = t₂h
ZVariant of append_inj_right instead requiring equality of the lengths of the second lists.uList.append_inj_left'}(hjB)  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.append_inj_left' {α✝ : Type u_1} {s₁ t₁ s₂ t₂ : List α✝} (h : s₁ ++ t₁ = s₂ ++ t₂) (hl : t₁.length = t₂.length) :
s₁ = s₂h
YVariant of append_inj_left instead requiring equality of the lengths of the second lists.uList.append_right_inj}(hjG)  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhytheorem List.append_right_inj {α : Type u_1} {t₁ t₂ : List α} (s : List α) :
s ++ t₁ = s ++ t₂ ↔ t₁ = t₂h
huList.append_left_inj}(hjK)  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhxtheorem List.append_left_inj {α : Type u_1} {s₁ s₂ : List α} (t : List α) :
s₁ ++ t = s₂ ++ t ↔ s₁ = s₂h
huList.append_left_eq_self}(hjO)  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlh^theorem List.append_left_eq_self {α : Type u_1} {xs ys : List α} :
xs ++ ys = ys ↔ xs = []h
huList.self_eq_append_left}(hjS)  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlh^theorem List.self_eq_append_left {α : Type u_1} {xs ys : List α} :
ys = xs ++ ys ↔ xs = []h
huList.append_right_eq_self}(hjW)  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlh_theorem List.append_right_eq_self {α : Type u_1} {xs ys : List α} :
xs ++ ys = xs ↔ ys = []h
huList.self_eq_append_right}(hj[)  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlh_theorem List.self_eq_append_right {α : Type u_1} {xs ys : List α} :
xs = xs ++ ys ↔ ys = []h
huList.getLast_concat}(hj_)  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlh_theorem List.getLast_concat {α : Type u_1} {a : α} {l : List α} :
(l ++ [a]).getLast ⋯ = ah
huList.append_eq_nil_iff}(hjc)  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhhtheorem List.append_eq_nil_iff {α✝ : Type u_1} {p q : List α✝} :
p ++ q = [] ↔ p = [] ∧ q = []h
huList.nil_eq_append_iff}(hjg)  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhhtheorem List.nil_eq_append_iff {α✝ : Type u_1} {a b : List α✝} :
[] = a ++ b ↔ a = [] ∧ b = []h
huList.eq_nil_of_append_eq_nil}(hjk)  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlh|theorem List.eq_nil_of_append_eq_nil {α : Type u_1} {l₁ l₂ : List α} (h : l₁ ++ l₂ = []) :
l₁ = [] ∧ l₂ = []h
hu!List.append_ne_nil_of_left_ne_nil}(hjo)  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhttheorem List.append_ne_nil_of_left_ne_nil {α : Type u_1} {s : List α} (h : s ≠ []) (t : List α) :
s ++ t ≠ []h
hu"List.append_ne_nil_of_right_ne_nil}(hjs)  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhstheorem List.append_ne_nil_of_right_ne_nil {α : Type u_1} {t : List α} (s : List α) :
t ≠ [] → s ++ t ≠ []h
huList.append_eq_cons_iff}(hjw)  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.append_eq_cons_iff {α✝ : Type u_1} {as bs : List α✝} {x : α✝} {c : List α✝} :
as ++ bs = x :: c ↔ as = [] ∧ bs = x :: c ∨ ∃ (as' : List α✝), as = x :: as' ∧ c = as' ++ bsh
huList.cons_eq_append_iff}(hj{)  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.cons_eq_append_iff {α✝ : Type u_1} {x : α✝} {cs as bs : List α✝} :
x :: cs = as ++ bs ↔ as = [] ∧ bs = x :: cs ∨ ∃ (as' : List α✝), as = x :: as' ∧ cs = as' ++ bsh
huList.append_eq_singleton_iff}(hj)  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.append_eq_singleton_iff {α✝ : Type u_1} {a b : List α✝} {x : α✝} :
a ++ b = [x] ↔ a = [] ∧ b = [x] ∨ a = [x] ∧ b = []h
huList.singleton_eq_append_iff}(hj)  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.singleton_eq_append_iff {α✝ : Type u_1} {x : α✝} {a b : List α✝} :
[x] = a ++ b ↔ a = [] ∧ b = [x] ∨ a = [x] ∧ b = []h
huList.append_eq_append_iff}(hj)  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.append_eq_append_iff {α : Type u_1} {ws xs ys zs : List α} :
ws ++ xs = ys ++ zs ↔ (∃ (as : List α), ys = ws ++ as ∧ xs = as ++ zs) ∨ ∃ (bs : List α), ws = ys ++ bs ∧ zs = bs ++ xsh
huList.head_append_of_ne_nil}(hj)  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.head_append_of_ne_nil {α : Type u_1} {l' l : List α} {w₁ : l ++ l' ≠ []} (w₂ : l ≠ []) :
(l ++ l').head w₁ = l.head w₂h
huList.head_append}(hj)  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.head_append {α : Type u_1} {l₁ l₂ : List α} (w : l₁ ++ l₂ ≠ []) :
(l₁ ++ l₂).head w = if h : l₁.isEmpty = true then l₂.head ⋯ else l₁.head ⋯h
huList.head_append_left}(hj)  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlh}theorem List.head_append_left {α : Type u_1} {l₁ l₂ : List α} (h : l₁ ≠ []) :
(l₁ ++ l₂).head ⋯ = l₁.head hh
huList.head_append_right}(hj)  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.head_append_right {α : Type u_1} {l₁ l₂ : List α} (w : l₁ ++ l₂ ≠ []) (h : l₁ = []) :
(l₁ ++ l₂).head w = l₂.head ⋯h
huList.head?_append}(hj)  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhbtheorem List.head?_append {α : Type u_1} {l' l : List α} :
(l ++ l').head? = l.head?.or l'.head?h
huList.tail?_append}(hj)  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.tail?_append {α : Type u_1} {l l' : List α} :
(l ++ l').tail? = (Option.map (fun (x : List α) => x ++ l') l.tail?).or l'.tail?h
huList.tail?_append_of_ne_nil}(hj)  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhytheorem List.tail?_append_of_ne_nil {α : Type u_1} {l l' : List α} :
l ≠ [] → (l ++ l').tail? = some (l.tail ++ l')h
huList.tail_append}(hj)  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.tail_append {α : Type u_1} {l l' : List α} :
(l ++ l').tail = if l.isEmpty = true then l'.tail else l.tail ++ l'h
huList.tail_append_of_ne_nil}(hj)  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhvtheorem List.tail_append_of_ne_nil {α : Type u_1} {xs ys : List α} (h : xs ≠ []) :
(xs ++ ys).tail = xs.tail ++ ysh
huList.set_append}(hj)  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.set_append {α : Type u_1} {i : Nat} {x : α} {s t : List α} :
(s ++ t).set i x = if i < s.length then s.set i x ++ t else s ++ t.set (i - s.length) xh
huList.set_append_left}(hj)  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.set_append_left {α : Type u_1} {s t : List α} (i : Nat) (x : α) (h : i < s.length) :
(s ++ t).set i x = s.set i x ++ th
huList.set_append_right}(hj)  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.set_append_right {α : Type u_1} {s t : List α} (i : Nat) (x : α) (h : s.length ≤ i) :
(s ++ t).set i x = s ++ t.set (i - s.length) xh
huList.filterMap_eq_append_iff}(hj)  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhX  theorem List.filterMap_eq_append_iff {α : Type u_1} {β : Type u_2} {l : List α} {L₁ L₂ : List β} {f : α → Option β} :
filterMap f l = L₁ ++ L₂ ↔ ∃ (l₁ : List α), ∃ (l₂ : List α), l = l₁ ++ l₂ ∧ filterMap f l₁ = L₁ ∧ filterMap f l₂ = L₂h
huList.append_eq_filterMap_iff}(hj)  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhX  theorem List.append_eq_filterMap_iff {α : Type u_1} {β : Type u_2} {L₁ L₂ : List β} {l : List α} {f : α → Option β} :
L₁ ++ L₂ = filterMap f l ↔ ∃ (l₁ : List α), ∃ (l₂ : List α), l = l₁ ++ l₂ ∧ filterMap f l₁ = L₁ ∧ filterMap f l₂ = L₂h
huList.filter_eq_append_iff}(hj)  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.filter_eq_append_iff {α : Type u_1} {l L₁ L₂ : List α} {p : α → Bool} :
filter p l = L₁ ++ L₂ ↔ ∃ (l₁ : List α), ∃ (l₂ : List α), l = l₁ ++ l₂ ∧ filter p l₁ = L₁ ∧ filter p l₂ = L₂h
huList.append_eq_filter_iff}(hj)  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.append_eq_filter_iff {α : Type u_1} {L₁ L₂ l : List α} {p : α → Bool} :
L₁ ++ L₂ = filter p l ↔ ∃ (l₁ : List α), ∃ (l₂ : List α), l = l₁ ++ l₂ ∧ filter p l₁ = L₁ ∧ filter p l₂ = L₂h
huList.map_append}(hj)  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.map_append {α : Type u_1} {β : Type u_2} {f : α → β} {l₁ l₂ : List α} :
map f (l₁ ++ l₂) = map f l₁ ++ map f l₂h
huList.map_eq_append_iff}(hj)  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.map_eq_append_iff {α : Type u_1} {β : Type u_2} {l : List α} {L₁ L₂ : List β} {f : α → β} :
map f l = L₁ ++ L₂ ↔ ∃ (l₁ : List α), ∃ (l₂ : List α), l = l₁ ++ l₂ ∧ map f l₁ = L₁ ∧ map f l₂ = L₂h
huList.append_eq_map_iff}(hj)  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.append_eq_map_iff {α : Type u_1} {β : Type u_2} {L₁ L₂ : List β} {l : List α} {f : α → β} :
L₁ ++ L₂ = map f l ↔ ∃ (l₁ : List α), ∃ (l₂ : List α), l = l₁ ++ l₂ ∧ map f l₁ = L₁ ∧ map f l₂ = L₂h
huList.sum_append_nat}(hj)  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlh]theorem List.sum_append_nat {l₁ l₂ : List Nat} :
(l₁ ++ l₂).sum = l₁.sum + l₂.sumh
huList.sum_reverse_nat}(hj)  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhFtheorem List.sum_reverse_nat (xs : List Nat) :
xs.reverse.sum = xs.sumh
huList.concat_nil}(hj)  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhDtheorem List.concat_nil {α : Type u_1} {a : α} :
[].concat a = [a]h
huList.concat_cons}(hj)  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhgtheorem List.concat_cons {α : Type u_1} {a b : α} {l : List α} :
(a :: l).concat b = a :: l.concat bh
huList.init_eq_of_concat_eq}(hj)  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.init_eq_of_concat_eq {α : Type u_1} {a b : α} {l₁ l₂ : List α} :
l₁.concat a = l₂.concat b → l₁ = l₂h
huList.last_eq_of_concat_eq}(hj)  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlh|theorem List.last_eq_of_concat_eq {α : Type u_1} {a b : α} {l₁ l₂ : List α} :
l₁.concat a = l₂.concat b → a = bh
huList.concat_inj}(hj)  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhstheorem List.concat_inj {α : Type u_1} {a b : α} {l l' : List α} :
l.concat a = l'.concat b ↔ l = l' ∧ a = bh
huList.concat_inj_left}(hj)  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhltheorem List.concat_inj_left {α : Type u_1} {l l' : List α} (a : α) :
l.concat a = l'.concat a ↔ l = l'h
huList.concat_inj_right}(hj)  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhmtheorem List.concat_inj_right {α : Type u_1} {l : List α} {a a' : α} :
l.concat a = l.concat a' ↔ a = a'h
huList.concat_append}(hj)  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhutheorem List.concat_append {α : Type u_1} {a : α} {l₁ l₂ : List α} :
l₁.concat a ++ l₂ = l₁ ++ a :: l₂h
huList.append_concat}(hj)  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlh{theorem List.append_concat {α : Type u_1} {a : α} {l₁ l₂ : List α} :
l₁ ++ l₂.concat a = (l₁ ++ l₂).concat ah
huList.map_concat}(hj*  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.map_concat {α : Type u_1} {β : Type u_2} {f : α → β} {a : α} {l : List α} :
map f (l.concat a) = (map f l).concat (f a)h
huList.eq_nil_or_concat}(hj*  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhztheorem List.eq_nil_or_concat {α : Type u_1} (l : List α) :
l = [] ∨ ∃ (l' : List α), ∃ (b : α), l = l'.concat bh
huList.length_flatten}(hj*  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhhtheorem List.length_flatten {α : Type u_1} {L : List (List α)} :
L.flatten.length = (map length L).sumh
huList.flatten_singleton}(hj*  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhNtheorem List.flatten_singleton {α : Type u_1} {l : List α} :
[l].flatten = lh
huList.mem_flatten}(hj*  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.mem_flatten {α : Type u_1} {a : α} {L : List (List α)} :
a ∈ L.flatten ↔ ∃ (l : List α), l ∈ L ∧ a ∈ lh
huList.flatten_eq_nil_iff}(hj*  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.flatten_eq_nil_iff {α : Type u_1} {L : List (List α)} :
L.flatten = [] ↔ ∀ (l : List α), l ∈ L → l = []h
huList.nil_eq_flatten_iff}(hj*  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.nil_eq_flatten_iff {α : Type u_1} {L : List (List α)} :
[] = L.flatten ↔ ∀ (l : List α), l ∈ L → l = []h
huList.flatten_ne_nil_iff}(hj*  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.flatten_ne_nil_iff {α : Type u_1} {xss : List (List α)} :
xss.flatten ≠ [] ↔ ∃ (xs : List α), xs ∈ xss ∧ xs ≠ []h
huList.exists_of_mem_flatten}(hj#*  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.exists_of_mem_flatten {α✝ : Type u_1} {L : List (List α✝)} {a : α✝} :
a ∈ L.flatten → ∃ (l : List α✝), l ∈ L ∧ a ∈ lh
huList.mem_flatten_of_mem}(hj'*  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.mem_flatten_of_mem {α✝ : Type u_1} {L : List (List α✝)} {l : List α✝} {a : α✝} (lL : l ∈ L) (al : a ∈ l) :
a ∈ L.flattenh
huList.forall_mem_flatten}(hj+*  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.forall_mem_flatten {α : Type u_1} {p : α → Prop} {L : List (List α)} :
(∀ (x : α), x ∈ L.flatten → p x) ↔ ∀ (l : List α), l ∈ L → ∀ (x : α), x ∈ l → p xh
huList.flatten_eq_flatMap}(hj/*  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlh_theorem List.flatten_eq_flatMap {α : Type u_1} {L : List (List α)} :
L.flatten = flatMap id Lh
huList.head?_flatten}(hj3*  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlh~theorem List.head?_flatten {α : Type u_1} {L : List (List α)} :
L.flatten.head? = findSome? (fun (l : List α) => l.head?) Lh
huList.map_flatten}(hj7*  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.map_flatten {α : Type u_1} {β : Type u_2} {f : α → β} {L : List (List α)} :
map f L.flatten = (map (map f) L).flattenh
huList.filterMap_flatten}(hj;*  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.filterMap_flatten {α : Type u_1} {β : Type u_2} {f : α → Option β} {L : List (List α)} :
filterMap f L.flatten = (map (filterMap f) L).flattenh
huList.filter_flatten}(hj?*  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.filter_flatten {α : Type u_1} {p : α → Bool} {L : List (List α)} :
filter p L.flatten = (map (filter p) L).flattenh
huList.flatten_filter_not_isEmpty}(hjC*  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.flatten_filter_not_isEmpty {α : Type u_1} {L : List (List α)} :
(filter (fun (l : List α) => !l.isEmpty) L).flatten = L.flattenh
huList.flatten_filter_ne_nil}(hjG*  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.flatten_filter_ne_nil {α : Type u_1} [DecidablePred fun (l : List α) => l ≠ []] {L : List (List α)} :
(filter (fun (l : List α) => decide (l ≠ [])) L).flatten = L.flattenh
huList.flatten_append}(hjK*  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.flatten_append {α : Type u_1} {L₁ L₂ : List (List α)} :
(L₁ ++ L₂).flatten = L₁.flatten ++ L₂.flattenh
huList.flatten_concat}(hjO*  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhttheorem List.flatten_concat {α : Type u_1} {L : List (List α)} {l : List α} :
(L ++ [l]).flatten = L.flatten ++ lh
huList.flatten_flatten}(hjS*  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhvtheorem List.flatten_flatten {α : Type u_1} {L : List (List (List α))} :
L.flatten.flatten = (map flatten L).flattenh
huList.flatten_eq_cons_iff}(hjW*  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhX(  theorem List.flatten_eq_cons_iff {α : Type u_1} {xss : List (List α)} {y : α} {ys : List α} :
xss.flatten = y :: ys ↔ ∃ (as : List (List α)), ∃ (bs : List α), ∃ (cs : List (List α)), xss = as ++ (y :: bs) :: cs ∧ (∀ (l : List α), l ∈ as → l = []) ∧ ys = bs ++ cs.flattenh
huList.cons_eq_flatten_iff}(hj[*  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhX%  theorem List.cons_eq_flatten_iff {α : Type u_1} {xs : List (List α)} {y : α} {ys : List α} :
y :: ys = xs.flatten ↔ ∃ (as : List (List α)), ∃ (bs : List α), ∃ (cs : List (List α)), xs = as ++ (y :: bs) :: cs ∧ (∀ (l : List α), l ∈ as → l = []) ∧ ys = bs ++ cs.flattenh
huList.flatten_eq_singleton_iff}(hj_*  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhX  theorem List.flatten_eq_singleton_iff {α : Type u_1} {xs : List (List α)} {y : α} :
xs.flatten = [y] ↔ ∃ (as : List (List α)), ∃ (bs : List (List α)), xs = as ++ [y] :: bs ∧ (∀ (l : List α), l ∈ as → l = []) ∧ ∀ (l : List α), l ∈ bs → l = []h
huList.singleton_eq_flatten_iff}(hjc*  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhX  theorem List.singleton_eq_flatten_iff {α : Type u_1} {xs : List (List α)} {y : α} :
[y] = xs.flatten ↔ ∃ (as : List (List α)), ∃ (bs : List (List α)), xs = as ++ [y] :: bs ∧ (∀ (l : List α), l ∈ as → l = []) ∧ ∀ (l : List α), l ∈ bs → l = []h
huList.flatten_eq_append_iff}(hjg*  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhX  theorem List.flatten_eq_append_iff {α : Type u_1} {xss : List (List α)} {ys zs : List α} :
xss.flatten = ys ++ zs ↔ (∃ (as : List (List α)), ∃ (bs : List (List α)), xss = as ++ bs ∧ ys = as.flatten ∧ zs = bs.flatten) ∨ ∃ (as : List (List α)), ∃ (bs : List α), ∃ (c : α), ∃ (cs : List α), ∃ (ds : List (List α)), xss = as ++ (bs ++ c :: cs) :: ds ∧ ys = as.flatten ++ bs ∧ zs = c :: cs ++ ds.flattenh
huList.append_eq_flatten_iff}(hjk*  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhX  theorem List.append_eq_flatten_iff {α : Type u_1} {xs : List (List α)} {ys zs : List α} :
ys ++ zs = xs.flatten ↔ (∃ (as : List (List α)), ∃ (bs : List (List α)), xs = as ++ bs ∧ ys = as.flatten ∧ zs = bs.flatten) ∨ ∃ (as : List (List α)), ∃ (bs : List α), ∃ (c : α), ∃ (cs : List α), ∃ (ds : List (List α)), xs = as ++ (bs ++ c :: cs) :: ds ∧ ys = as.flatten ++ bs ∧ zs = c :: cs ++ ds.flattenh
huList.eq_iff_flatten_eq}(hjo*  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.eq_iff_flatten_eq {α : Type u_1} {L L' : List (List α)} :
L = L' ↔ L.flatten = L'.flatten ∧ map length L = map length L'h
dTwo lists of sublists are equal iff their flattens coincide, as well as the lengths of the sublists.uList.flatMap_def}(hjt*  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlh}theorem List.flatMap_def {α : Type u_1} {β : Type u_2} {l : List α} {f : α → List β} :
flatMap f l = (map f l).flattenh
huList.flatMap_id}(hjx*  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhWtheorem List.flatMap_id {α : Type u_1} {L : List (List α)} :
flatMap id L = L.flattenh
huList.flatMap_id'}(hj|*  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhptheorem List.flatMap_id' {α : Type u_1} {L : List (List α)} :
flatMap (fun (as : List α) => as) L = L.flattenh
huList.length_flatMap}(hj*  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.length_flatMap {α : Type u_1} {β : Type u_2} {l : List α} {f : α → List β} :
(flatMap f l).length = (map (fun (a : α) => (f a).length) l).sumh
huList.mem_flatMap}(hj*  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.mem_flatMap {α : Type u_1} {β : Type u_2} {f : α → List β} {b : β} {l : List α} :
b ∈ flatMap f l ↔ ∃ (a : α), a ∈ l ∧ b ∈ f ah
huList.exists_of_mem_flatMap}(hj*  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.exists_of_mem_flatMap {β : Type u_1} {α : Type u_2} {b : β} {l : List α} {f : α → List β} :
b ∈ flatMap f l → ∃ (a : α), a ∈ l ∧ b ∈ f ah
huList.mem_flatMap_of_mem}(hj*  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.mem_flatMap_of_mem {β : Type u_1} {α : Type u_2} {b : β} {l : List α} {f : α → List β} {a : α} (al : a ∈ l) (h : b ∈ f a) :
b ∈ flatMap f lh
huList.flatMap_eq_nil_iff}(hj*  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.flatMap_eq_nil_iff {α : Type u_1} {β : Type u_2} {l : List α} {f : α → List β} :
flatMap f l = [] ↔ ∀ (x : α), x ∈ l → f x = []h
huList.forall_mem_flatMap}(hj*  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.forall_mem_flatMap {β : Type u_1} {α : Type u_2} {p : β → Prop} {l : List α} {f : α → List β} :
(∀ (x : β), x ∈ flatMap f l → p x) ↔ ∀ (a : α), a ∈ l → ∀ (b : β), b ∈ f a → p bh
huList.flatMap_singleton}(hj*  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhrtheorem List.flatMap_singleton {α : Type u_1} {β : Type u_2} (f : α → List β) (x : α) :
flatMap f [x] = f xh
huList.flatMap_singleton'}(hj*  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhctheorem List.flatMap_singleton' {α : Type u_1} (l : List α) :
flatMap (fun (x : α) => [x]) l = lh
huList.head?_flatMap}(hj*  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.head?_flatMap {α : Type u_1} {β : Type u_2} {l : List α} {f : α → List β} :
(flatMap f l).head? = findSome? (fun (a : α) => (f a).head?) lh
huList.flatMap_append}(hj*  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.flatMap_append {α : Type u_1} {β : Type u_2} {xs ys : List α} {f : α → List β} :
flatMap f (xs ++ ys) = flatMap f xs ++ flatMap f ysh
huList.flatMap_assoc}(hj*  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.flatMap_assoc {α : Type u_1} {β : Type u_2} {γ : Type u_3} {l : List α} {f : α → List β} {g : β → List γ} :
flatMap g (flatMap f l) = flatMap (fun (x : α) => flatMap g (f x)) lh
huList.map_flatMap}(hj*  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.map_flatMap {β : Type u_1} {γ : Type u_2} {α : Type u_3} {f : β → γ} {g : α → List β} {l : List α} :
map f (flatMap g l) = flatMap (fun (a : α) => map f (g a)) lh
huList.flatMap_map}(hj*  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.flatMap_map {α : Type u_1} {β : Type u_2} {γ : Type u_3} (f : α → β) (g : β → List γ) (l : List α) :
flatMap g (map f l) = flatMap (fun (a : α) => g (f a)) lh
huList.map_eq_flatMap}(hj*  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.map_eq_flatMap {α : Type u_1} {β : Type u_2} {f : α → β} {l : List α} :
map f l = flatMap (fun (x : α) => [f x]) lh
huList.filterMap_flatMap}(hj*  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.filterMap_flatMap {α : Type u_1} {β : Type u_2} {γ : Type u_3} {l : List α} {g : α → List β} {f : β → Option γ} :
filterMap f (flatMap g l) = flatMap (fun (a : α) => filterMap f (g a)) lh
huList.filter_flatMap}(hj*  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.filter_flatMap {α : Type u_1} {β : Type u_2} {l : List α} {g : α → List β} {f : β → Bool} :
filter f (flatMap g l) = flatMap (fun (a : α) => filter f (g a)) lh
huList.flatMap_eq_foldl}(hj*  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.flatMap_eq_foldl {α : Type u_1} {β : Type u_2} {f : α → List β} {l : List α} :
flatMap f l = foldl (fun (acc : List β) (a : α) => acc ++ f a) [] lh
huList.replicate_one}(hj*  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhOtheorem List.replicate_one {α✝ : Type u_1} {a : α✝} :
replicate 1 a = [a]h
huList.replicate_succ'}(hj*  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhrtheorem List.replicate_succ' {n : Nat} {α✝ : Type u_1} {a : α✝} :
replicate (n + 1) a = replicate n a ++ [a]h
EVariant of replicate_succ that concatenates a to the end of the list.uList.mem_replicate}(hj*  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhktheorem List.mem_replicate {α : Type u_1} {a b : α} {n : Nat} :
b ∈ replicate n a ↔ n ≠ 0 ∧ b = ah
huList.contains_replicate}(hj*  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.contains_replicate {α : Type u_1} [BEq α] {n : Nat} {a b : α} :
(replicate n b).contains a = (a == b && !n == 0)h
huList.eq_of_mem_replicate}(hj*  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhgtheorem List.eq_of_mem_replicate {α : Type u_1} {a b : α} {n : Nat} (h : b ∈ replicate n a) :
b = ah
huList.forall_mem_replicate}(hj*  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.forall_mem_replicate {α : Type u_1} {p : α → Prop} {a : α} {n : Nat} :
(∀ (b : α), b ∈ replicate n a → p b) ↔ n = 0 ∨ p ah
huList.replicate_succ_ne_nil}(hj*  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhbtheorem List.replicate_succ_ne_nil {α : Type u_1} {n : Nat} {a : α} :
replicate (n + 1) a ≠ []h
huList.replicate_eq_nil_iff}(hj*  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhctheorem List.replicate_eq_nil_iff {α : Type u_1} {n : Nat} (a : α) :
replicate n a = [] ↔ n = 0h
huList.getElem_replicate}(hj*  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlh}theorem List.getElem_replicate {α : Type u_1} {a : α} {n i : Nat} (h : i < (replicate n a).length) :
(replicate n a)[i] = ah
huList.getElem?_replicate}(hj*  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.getElem?_replicate {n : Nat} {α✝ : Type u_1} {a : α✝} {i : Nat} :
(replicate n a)[i]? = if i < n then some a else noneh
huList.getElem?_replicate_of_lt}(hj*  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlh{theorem List.getElem?_replicate_of_lt {α✝ : Type u_1} {a : α✝} {n i : Nat} (h : i < n) :
(replicate n a)[i]? = some ah
huList.head?_replicate}(hj*  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhxtheorem List.head?_replicate {α : Type u_1} {a : α} {n : Nat} :
(replicate n a).head? = if n = 0 then none else some ah
huList.head_replicate}(hj*  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlh|theorem List.head_replicate {n : Nat} {α✝ : Type u_1} {a : α✝} (w : replicate n a ≠ []) :
(replicate n a).head w = ah
huList.tail_replicate}(hj*  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhktheorem List.tail_replicate {α : Type u_1} {n : Nat} {a : α} :
(replicate n a).tail = replicate (n - 1) ah
huList.replicate_inj}(hj*  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.replicate_inj {n : Nat} {α✝ : Type u_1} {a : α✝} {m : Nat} {b : α✝} :
replicate n a = replicate m b ↔ n = m ∧ (n = 0 ∨ a = b)h
huList.eq_replicate_of_mem}(hj+  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.eq_replicate_of_mem {α : Type u_1} {a : α} {l : List α} :
(∀ (b : α), b ∈ l → b = a) → l = replicate l.length ah
huList.eq_replicate_iff}(hj+  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.eq_replicate_iff {α : Type u_1} {a : α} {n : Nat} {l : List α} :
l = replicate n a ↔ l.length = n ∧ ∀ (b : α), b ∈ l → b = ah
huList.map_eq_replicate_iff}(hj	+  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.map_eq_replicate_iff {α : Type u_1} {β : Type u_2} {l : List α} {f : α → β} {b : β} :
map f l = replicate l.length b ↔ ∀ (x : α), x ∈ l → f x = bh
huList.map_const}(hj
+  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.map_const {α : Type u_1} {β : Type u_2} {l : List α} {b : β} :
map (Function.const α b) l = replicate l.length bh
huList.map_const_fun}(hj+  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.map_const_fun {β : Type u_1} {α : Type u_2} {x : β} :
map (Function.const α x) = fun (x_1 : List α) => replicate x_1.length xh
huList.map_const'}(hj+  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.map_const' {α : Type u_1} {β : Type u_2} {l : List α} {b : β} :
map (fun (x : α) => b) l = replicate l.length bh
?Variant of map_const using a lambda rather than Function.const.uList.set_replicate_self}(hj+  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlh|theorem List.set_replicate_self {n : Nat} {α✝ : Type u_1} {a : α✝} {i : Nat} :
(replicate n a).set i a = replicate n ah
huList.replicate_append_replicate}(hj+  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.replicate_append_replicate {n : Nat} {α✝ : Type u_1} {a : α✝} {m : Nat} :
replicate n a ++ replicate m a = replicate (n + m) ah
huList.append_eq_replicate_iff}(hj"+  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.append_eq_replicate_iff {α : Type u_1} {n : Nat} {l₁ l₂ : List α} {a : α} :
l₁ ++ l₂ = replicate n a ↔ l₁.length + l₂.length = n ∧ l₁ = replicate l₁.length a ∧ l₂ = replicate l₂.length ah
huList.replicate_eq_append_iff}(hj&+  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.replicate_eq_append_iff {α : Type u_1} {n : Nat} {l₁ l₂ : List α} {a : α} :
replicate n a = l₁ ++ l₂ ↔ l₁.length + l₂.length = n ∧ l₁ = replicate l₁.length a ∧ l₂ = replicate l₂.length ah
huList.map_replicate}(hj*+  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.map_replicate {n : Nat} {α✝ : Type u_1} {a : α✝} {α✝¹ : Type u_2} {f : α✝ → α✝¹} :
map f (replicate n a) = replicate n (f a)h
huList.filter_replicate}(hj.+  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.filter_replicate {n : Nat} {α✝ : Type u_1} {a : α✝} {p : α✝ → Bool} :
filter p (replicate n a) = if p a = true then replicate n a else []h
huList.filter_replicate_of_pos}(hj2+  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.filter_replicate_of_pos {α✝ : Type u_1} {p : α✝ → Bool} {n : Nat} {a : α✝} (h : p a = true) :
filter p (replicate n a) = replicate n ah
huList.filter_replicate_of_neg}(hj6+  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.filter_replicate_of_neg {α✝ : Type u_1} {p : α✝ → Bool} {n : Nat} {a : α✝} (h : ¬p a = true) :
filter p (replicate n a) = []h
huList.filterMap_replicate}(hj:+  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.filterMap_replicate {α : Type u_1} {β : Type u_2} {n : Nat} {a : α} {f : α → Option β} :
filterMap f (replicate n a) = match f a with
  | none => []
  | some b => replicate n bh
hu List.filterMap_replicate_of_some}(hj>+  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.filterMap_replicate_of_some {α : Type u_1} {β : Type u_2} {a : α} {b : β} {n : Nat} {f : α → Option β} (h : f a = some b) :
filterMap f (replicate n a) = replicate n bh
hu"List.filterMap_replicate_of_isSome}(hjB+  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.filterMap_replicate_of_isSome {α : Type u_1} {β : Type u_2} {a : α} {n : Nat} {f : α → Option β} (h : (f a).isSome = true) :
filterMap f (replicate n a) = replicate n ((f a).get h)h
hu List.filterMap_replicate_of_none}(hjF+  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.filterMap_replicate_of_none {α : Type u_1} {β : Type u_2} {a : α} {n : Nat} {f : α → Option β} (h : f a = none) :
filterMap f (replicate n a) = []h
huList.flatten_replicate_nil}(hjJ+  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlh\theorem List.flatten_replicate_nil {n : Nat} {α : Type u_1} :
(replicate n []).flatten = []h
hu List.flatten_replicate_singleton}(hjN+  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlh}theorem List.flatten_replicate_singleton {n : Nat} {α✝ : Type u_1} {a : α✝} :
(replicate n [a]).flatten = replicate n ah
hu List.flatten_replicate_replicate}(hjR+  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.flatten_replicate_replicate {n m : Nat} {α✝ : Type u_1} {a : α✝} :
(replicate n (replicate m a)).flatten = replicate (n * m) ah
huList.flatMap_replicate}(hjV+  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.flatMap_replicate {α : Type u_1} {n : Nat} {a : α} {β : Type u_2} {f : α → List β} :
flatMap f (replicate n a) = (replicate n (f a)).flattenh
huList.isEmpty_replicate}(hjZ+  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhrtheorem List.isEmpty_replicate {n : Nat} {α✝ : Type u_1} {a : α✝} :
(replicate n a).isEmpty = decide (n = 0)h
hu-List.eq_replicate_or_eq_replicate_append_cons}(hj^+  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhX  theorem List.eq_replicate_or_eq_replicate_append_cons {α : Type u_1} (l : List α) :
l = [] ∨ (∃ (n : Nat), ∃ (a : α), l = replicate n a ∧ 0 < n) ∨ ∃ (n : Nat), ∃ (a : α), ∃ (b : α), ∃ (l' : List α), l = replicate n a ++ b :: l' ∧ 0 < n ∧ a ≠ bh
xEvery list is either empty, a non-empty replicate, or begins with a non-empty replicate followed by a different element.uList.replicateRecOn}(hjc+  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhX
  theorem List.replicateRecOn {α : Type u_1} {p : List α → Prop} (l : List α) (h0 : p []) (hr : ∀ (a : α) (n : Nat), 0 < n → p (replicate n a)) (hi : ∀ (a b : α) (n : Nat) (l : List α), a ≠ b → 0 < n → p (b :: l) → p (replicate n a ++ b :: l)) :
p lh
PAn induction principle for lists based on contiguous runs of identical elements.uA      List.sum_replicate_nat}(hjh+  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhHtheorem List.sum_replicate_nat {n a : Nat} :
(replicate n a).sum = n * ah
huList.length_reverse}(hjl+  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhZtheorem List.length_reverse {α : Type u_1} {as : List α} :
as.reverse.length = as.lengthh
huList.mem_reverseAux}(hjp+  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhytheorem List.mem_reverseAux {α : Type u_1} {x : α} {as bs : List α} :
x ∈ as.reverseAux bs ↔ x ∈ as ∨ x ∈ bsh
huList.mem_reverse}(hjt+  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlh`theorem List.mem_reverse {α : Type u_1} {x : α} {as : List α} :
x ∈ as.reverse ↔ x ∈ ash
huList.reverse_eq_nil_iff}(hjx+  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlh\theorem List.reverse_eq_nil_iff {α : Type u_1} {xs : List α} :
xs.reverse = [] ↔ xs = []h
huList.reverse_ne_nil_iff}(hj|+  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlh`theorem List.reverse_ne_nil_iff {α : Type u_1} {xs : List α} :
xs.reverse ≠ [] ↔ xs ≠ []h
huList.isEmpty_reverse}(hj+  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlh]theorem List.isEmpty_reverse {α : Type u_1} {xs : List α} :
xs.reverse.isEmpty = xs.isEmptyh
huList.getElem?_reverse'}(hj+  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhytheorem List.getElem?_reverse' {α : Type u_1} {l : List α} {i j : Nat} :
i + j + 1 = l.length → l.reverse[i]? = l[j]?h
]Variant of getElem?_reverse with a hypothesis giving the linear relation between the indices.uList.getElem?_reverse}(hj+  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.getElem?_reverse {α : Type u_1} {l : List α} {i : Nat} (h : i < l.length) :
l.reverse[i]? = l[l.length - 1 - i]?h
huList.getElem_reverse}(hj+  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.getElem_reverse {α : Type u_1} {l : List α} {i : Nat} (h : i < l.reverse.length) :
l.reverse[i] = l[l.length - 1 - i]h
huList.reverseAux_reverseAux_nil}(hj+  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlh~theorem List.reverseAux_reverseAux_nil {α : Type u_1} {as bs : List α} :
(as.reverseAux bs).reverseAux [] = bs.reverseAux ash
huList.reverse_reverse}(hj+  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhUtheorem List.reverse_reverse {α : Type u_1} (as : List α) :
as.reverse.reverse = ash
huList.reverse_eq_iff}(hj+  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhctheorem List.reverse_eq_iff {α : Type u_1} {as bs : List α} :
as.reverse = bs ↔ as = bs.reverseh
huList.reverse_inj}(hj+  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlh`theorem List.reverse_inj {α : Type u_1} {xs ys : List α} :
xs.reverse = ys.reverse ↔ xs = ysh
huList.reverse_eq_cons_iff}(hj+  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.reverse_eq_cons_iff {α : Type u_1} {xs : List α} {a : α} {ys : List α} :
xs.reverse = a :: ys ↔ xs = ys.reverse ++ [a]h
huList.getLast?_reverse}(hj+  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhZtheorem List.getLast?_reverse {α : Type u_1} {l : List α} :
l.reverse.getLast? = l.head?h
huList.head?_reverse}(hj+  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhWtheorem List.head?_reverse {α : Type u_1} {l : List α} :
l.reverse.head? = l.getLast?h
huList.getLast?_eq_head?_reverse}(hj+  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhftheorem List.getLast?_eq_head?_reverse {α : Type u_1} {xs : List α} :
xs.getLast? = xs.reverse.head?h
huList.head?_eq_getLast?_reverse}(hj+  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhftheorem List.head?_eq_getLast?_reverse {α : Type u_1} {xs : List α} :
xs.head? = xs.reverse.getLast?h
huList.mem_of_getLast?}(hj+  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhgtheorem List.mem_of_getLast? {α : Type u_1} {l : List α} {a : α} (h : l.getLast? = some a) :
a ∈ lh
huList.mem_of_mem_getLast?}(hj+  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhhtheorem List.mem_of_mem_getLast? {α : Type u_1} {l : List α} {a : α} (h : a ∈ l.getLast?) :
a ∈ lh
hu List.getLast_of_getLast?_eq_some}(hj+  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlh~theorem List.getLast_of_getLast?_eq_some {α : Type u_1} {x : α} {l : List α} (hx : l.getLast? = some x) :
l.getLast ⋯ = xh
huList.getLast_of_mem_getLast?}(hj+  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhwtheorem List.getLast_of_mem_getLast? {α : Type u_1} {x : α} {l : List α} (hx : x ∈ l.getLast?) :
l.getLast ⋯ = xh
huList.map_reverse}(hj+  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlh|theorem List.map_reverse {α : Type u_1} {β : Type u_2} {f : α → β} {l : List α} :
map f l.reverse = (map f l).reverseh
huList.filter_reverse}(hj+  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhwtheorem List.filter_reverse {α : Type u_1} {p : α → Bool} {l : List α} :
filter p l.reverse = (filter p l).reverseh
huList.filterMap_reverse}(hj+  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.filterMap_reverse {α : Type u_1} {β : Type u_2} {f : α → Option β} {l : List α} :
filterMap f l.reverse = (filterMap f l).reverseh
huList.reverse_append}(hj+  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhmtheorem List.reverse_append {α : Type u_1} {as bs : List α} :
(as ++ bs).reverse = bs.reverse ++ as.reverseh
huList.reverse_eq_append_iff}(hj+  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.reverse_eq_append_iff {α : Type u_1} {xs ys zs : List α} :
xs.reverse = ys ++ zs ↔ xs = zs.reverse ++ ys.reverseh
huList.reverse_concat}(hj+  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhhtheorem List.reverse_concat {α : Type u_1} {l : List α} {a : α} :
(l ++ [a]).reverse = a :: l.reverseh
huList.reverse_eq_concat}(hj+  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlh{theorem List.reverse_eq_concat {α : Type u_1} {xs ys : List α} {a : α} :
xs.reverse = ys ++ [a] ↔ xs = a :: ys.reverseh
huList.reverse_flatten}(hj+  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhwtheorem List.reverse_flatten {α : Type u_1} {L : List (List α)} :
L.flatten.reverse = (map reverse L).reverse.flattenh
XReversing a flatten is the same as reversing the order of parts and reversing all parts.uList.flatten_reverse}(hj+  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhwtheorem List.flatten_reverse {α : Type u_1} {L : List (List α)} :
L.reverse.flatten = (map reverse L).flatten.reverseh
[Flattening a reverse is the same as reversing all parts and reversing the flattened result.uList.reverse_flatMap}(hj+  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.reverse_flatMap {α : Type u_1} {β : Type u_2} {l : List α} {f : α → List β} :
(flatMap f l).reverse = flatMap (reverse ∘ f) l.reverseh
huList.flatMap_reverse}(hj+  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.flatMap_reverse {α : Type u_1} {β : Type u_2} {l : List α} {f : α → List β} :
flatMap f l.reverse = (flatMap (reverse ∘ f) l).reverseh
huList.reverseAux_eq}(hj+  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhbtheorem List.reverseAux_eq {α : Type u_1} {as bs : List α} :
as.reverseAux bs = as.reverse ++ bsh
huList.reverse_replicate}(hj+  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhktheorem List.reverse_replicate {α : Type u_1} {n : Nat} {a : α} :
(replicate n a).reverse = replicate n ah
huList.foldlM_append}(hj+  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.foldlM_append {m : Type u_1 → Type u_2} {β : Type u_1} {α : Type u_3} [Monad m] [LawfulMonad m] {f : β → α → m β} {b : β} {l l' : List α} :
foldlM f b (l ++ l') = do
  let init ← foldlM f b l
  foldlM f init l'h
huList.foldrM_cons}(hj+  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.foldrM_cons {m : Type u_1 → Type u_2} {α : Type u_3} {β : Type u_1} [Monad m] [LawfulMonad m] {a : α} {l : List α} {f : α → β → m β} {b : β} :
foldrM f b (a :: l) = foldrM f b l >>= f ah
huList.foldlM_pure}(hj,  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.foldlM_pure {m : Type u_1 → Type u_2} {β : Type u_1} {α : Type u_3} [Monad m] [LawfulMonad m] {f : β → α → β} {b : β} {l : List α} :
foldlM (fun (x1 : β) (x2 : α) => pure (f x1 x2)) b l = pure (foldl f b l)h
huList.foldrM_pure}(hj,  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.foldrM_pure {m : Type u_1 → Type u_2} {α : Type u_3} {β : Type u_1} [Monad m] [LawfulMonad m] {f : α → β → β} {b : β} {l : List α} :
foldrM (fun (x1 : α) (x2 : β) => pure (f x1 x2)) b l = pure (foldr f b l)h
huList.foldl_eq_foldlM}(hj,  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.foldl_eq_foldlM {β : Type u_1} {α : Type u_2} {f : β → α → β} {b : β} {l : List α} :
foldl f b l = (foldlM (fun (x1 : β) (x2 : α) => pure (f x1 x2)) b l).runh
huList.foldr_eq_foldrM}(hj,  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.foldr_eq_foldrM {α : Type u_1} {β : Type u_2} {f : α → β → β} {b : β} {l : List α} :
foldr f b l = (foldrM (fun (x1 : α) (x2 : β) => pure (f x1 x2)) b l).runh
huList.idRun_foldlM}(hj,  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.idRun_foldlM {β : Type u_1} {α : Type u_2} {f : β → α → Id β} {b : β} {l : List α} :
(foldlM f b l).run = foldl (fun (x1 : β) (x2 : α) => (f x1 x2).run) b lh
huList.id_run_foldlM}(hj,  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.id_run_foldlM {β : Type u_1} {α : Type u_2} {f : β → α → Id β} {b : β} {l : List α} :
(foldlM f b l).run = foldl f b lh
huList.idRun_foldrM}(hj,  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.idRun_foldrM {α : Type u_1} {β : Type u_2} {f : α → β → Id β} {b : β} {l : List α} :
(foldrM f b l).run = foldr (fun (x1 : α) (x2 : β) => (f x1 x2).run) b lh
huList.id_run_foldrM}(hj,  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.id_run_foldrM {α : Type u_1} {β : Type u_2} {f : α → β → Id β} {b : β} {l : List α} :
(foldrM f b l).run = foldr f b lh
huList.foldlM_reverse}(hj#,  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.foldlM_reverse {m : Type u_1 → Type u_2} {α : Type u_3} {β : Type u_1} [Monad m] {l : List α} {f : β → α → m β} {b : β} :
foldlM f b l.reverse = foldrM (fun (x : α) (y : β) => f y x) b lh
huList.foldrM_reverse}(hj',  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.foldrM_reverse {m : Type u_1 → Type u_2} {α : Type u_3} {β : Type u_1} [Monad m] {l : List α} {f : α → β → m β} {b : β} :
foldrM f b l.reverse = foldlM (fun (x : β) (y : α) => f y x) b lh
huList.foldr_cons_eq_append}(hj+,  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.foldr_cons_eq_append {α : Type u_1} {β : Type u_2} {l : List α} {f : α → β} {l' : List β} :
foldr (fun (x : α) (ys : List β) => f x :: ys) l' l = map f l ++ l'h
huList.foldr_cons_eq_append'}(hj/,  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlh_theorem List.foldr_cons_eq_append' {β : Type u_1} {l l' : List β} :
foldr cons l' l = l ++ l'h
5Variant of foldr_cons_eq_append specalized to f = id.uList.foldl_flip_cons_eq_append}(hj4,  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.foldl_flip_cons_eq_append {α : Type u_1} {β : Type u_2} {l : List α} {f : α → β} {l' : List β} :
foldl (fun (xs : List β) (y : α) => f y :: xs) l' l = (map f l).reverse ++ l'h
huList.foldl_flip_cons_eq_append'}(hj8,  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.foldl_flip_cons_eq_append' {α : Type u_1} {l l' : List α} :
foldl (fun (xs : List α) (y : α) => y :: xs) l' l = l.reverse ++ l'h
:Variant of foldl_flip_cons_eq_append specalized to f = id.uList.foldr_append_eq_append}(hj=,  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.foldr_append_eq_append {α : Type u_1} {β : Type u_2} {l : List α} {f : α → List β} {l' : List β} :
foldr (fun (x1 : α) (x2 : List β) => f x1 ++ x2) l' l = (map f l).flatten ++ l'h
huList.foldl_append_eq_append}(hjA,  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.foldl_append_eq_append {α : Type u_1} {β : Type u_2} {l : List α} {f : α → List β} {l' : List β} :
foldl (fun (x1 : List β) (x2 : α) => x1 ++ f x2) l' l = l' ++ (map f l).flattenh
hu List.foldr_flip_append_eq_append}(hjE,  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.foldr_flip_append_eq_append {α : Type u_1} {β : Type u_2} {l : List α} {f : α → List β} {l' : List β} :
foldr (fun (x : α) (ys : List β) => ys ++ f x) l' l = l' ++ (map f l).reverse.flattenh
hu List.foldl_flip_append_eq_append}(hjI,  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.foldl_flip_append_eq_append {α : Type u_1} {β : Type u_2} {l : List α} {f : α → List β} {l' : List β} :
foldl (fun (xs : List β) (y : α) => f y ++ xs) l' l = (map f l).reverse.flatten ++ l'h
huList.foldr_cons_nil}(hjM,  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhOtheorem List.foldr_cons_nil {α : Type u_1} {l : List α} :
foldr cons [] l = lh
huList.foldl_map}(hjQ,  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.foldl_map {β₁ : Type u_1} {β₂ : Type u_2} {α : Type u_3} {f : β₁ → β₂} {g : α → β₂ → α} {l : List β₁} {init : α} :
foldl g init (map f l) = foldl (fun (x : α) (y : β₁) => g x (f y)) init lh
huList.foldr_map}(hjU,  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.foldr_map {α₁ : Type u_1} {α₂ : Type u_2} {β : Type u_3} {f : α₁ → α₂} {g : α₂ → β → β} {l : List α₁} {init : β} :
foldr g init (map f l) = foldr (fun (x : α₁) (y : β) => g (f x) y) init lh
huList.foldl_filterMap}(hjY,  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhX$  theorem List.foldl_filterMap {α : Type u_1} {β : Type u_2} {γ : Type u_3} {f : α → Option β} {g : γ → β → γ} {l : List α} {init : γ} :
foldl g init (filterMap f l) = foldl
    (fun (x : γ) (y : α) =>
      match f y with
      | some b => g x b
      | none => x)
    init lh
huList.foldr_filterMap}(hj],  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhX$  theorem List.foldr_filterMap {α : Type u_1} {β : Type u_2} {γ : Type u_3} {f : α → Option β} {g : β → γ → γ} {l : List α} {init : γ} :
foldr g init (filterMap f l) = foldr
    (fun (x : α) (y : γ) =>
      match f x with
      | some b => g b y
      | none => y)
    init lh
huList.foldl_map_hom}(hja,  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.foldl_map_hom {α : Type u_1} {β : Type u_2} {g : α → β} {f : α → α → α} {f' : β → β → β} {a : α} {l : List α} (h : ∀ (x y : α), f' (g x) (g y) = g (f x y)) :
foldl f' (g a) (map g l) = g (foldl f a l)h
huList.foldr_map_hom}(hje,  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.foldr_map_hom {α : Type u_1} {β : Type u_2} {g : α → β} {f : α → α → α} {f' : β → β → β} {a : α} {l : List α} (h : ∀ (x y : α), f' (g x) (g y) = g (f x y)) :
foldr f' (g a) (map g l) = g (foldr f a l)h
huList.foldrM_append}(hji,  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.foldrM_append {m : Type u_1 → Type u_2} {α : Type u_3} {β : Type u_1} [Monad m] [LawfulMonad m] {f : α → β → m β} {b : β} {l l' : List α} :
foldrM f b (l ++ l') = do
  let init ← foldrM f b l'
  foldrM f init lh
huList.foldl_append}(hjm,  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.foldl_append {α : Type u_1} {β : Type u_2} {f : β → α → β} {b : β} {l l' : List α} :
foldl f b (l ++ l') = foldl f (foldl f b l) l'h
huList.foldr_append}(hjq,  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.foldr_append {α : Type u_1} {β : Type u_2} {f : α → β → β} {b : β} {l l' : List α} :
foldr f b (l ++ l') = foldr f (foldr f b l') lh
huList.foldl_flatten}(hju,  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.foldl_flatten {β : Type u_1} {α : Type u_2} {f : β → α → β} {b : β} {L : List (List α)} :
foldl f b L.flatten = foldl (fun (b : β) (l : List α) => foldl f b l) b Lh
huList.foldr_flatten}(hjy,  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.foldr_flatten {α : Type u_1} {β : Type u_2} {f : α → β → β} {b : β} {L : List (List α)} :
foldr f b L.flatten = foldr (fun (l : List α) (b : β) => foldr f b l) b Lh
huList.foldl_reverse}(hj},  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.foldl_reverse {α : Type u_1} {β : Type u_2} {l : List α} {f : β → α → β} {b : β} :
foldl f b l.reverse = foldr (fun (x : α) (y : β) => f y x) b lh
huList.foldr_reverse}(hj,  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.foldr_reverse {α : Type u_1} {β : Type u_2} {l : List α} {f : α → β → β} {b : β} :
foldr f b l.reverse = foldl (fun (x : β) (y : α) => f y x) b lh
huList.foldl_eq_foldr_reverse}(hj,  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.foldl_eq_foldr_reverse {α : Type u_1} {β : Type u_2} {l : List α} {f : β → α → β} {b : β} :
foldl f b l = foldr (fun (x : α) (y : β) => f y x) b l.reverseh
huList.foldr_eq_foldl_reverse}(hj,  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.foldr_eq_foldl_reverse {α : Type u_1} {β : Type u_2} {l : List α} {f : α → β → β} {b : β} :
foldr f b l = foldl (fun (x : β) (y : α) => f y x) b l.reverseh
huList.foldl_assoc}(hj,  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.foldl_assoc {α : Type u_1} {op : α → α → α} [ha : Std.Associative op] {l : List α} {a₁ a₂ : α} :
foldl op (op a₁ a₂) l = op a₁ (foldl op a₂ l)h
huList.foldr_assoc}(hj,  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.foldr_assoc {α : Type u_1} {op : α → α → α} [ha : Std.Associative op] {l : List α} {a₁ a₂ : α} :
foldr op (op a₁ a₂) l = op (foldr op a₁ l) a₂h
huList.foldl_hom}(hj,  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhX+  theorem List.foldl_hom {α₁ : Type u_1} {α₂ : Type u_2} {β : Type u_3} (f : α₁ → α₂) {g₁ : α₁ → β → α₁} {g₂ : α₂ → β → α₂} {l : List β} {init : α₁} (H : ∀ (x : α₁) (y : β), g₂ (f x) y = f (g₁ x y)) :
foldl g₂ (f init) l = f (foldl g₁ init l)h
huList.foldr_hom}(hj,  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhX+  theorem List.foldr_hom {β₁ : Type u_1} {β₂ : Type u_2} {α : Type u_3} (f : β₁ → β₂) {g₁ : α → β₁ → β₁} {g₂ : α → β₂ → β₂} {l : List α} {init : β₁} (H : ∀ (x : α) (y : β₁), g₂ x (f y) = f (g₁ x y)) :
foldr g₂ (f init) l = f (foldr g₁ init l)h
huList.foldlRecOn}(hj,  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhdef List.foldlRecOn {β : Type u_1} {α : Type u_2} {motive : β → Sort u_3} (l : List α) (op : β → α → β) {b : β} :
motive b → ((b : β) → motive b → (a : α) → a ∈ l → motive (op b a)) → motive (foldl op b l)h
XB  A reasoning principle for proving propositions about the result of List.foldl by establishing an invariant that is true for the initial data and preserved by the operation being folded.
Because the motive can return a type in any sort, this function may be used to construct data as well as to prove propositions.
Example:uList.foldlRecOn_nil}(hj,  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.foldlRecOn_nil {β : Type u_1} {α : Type u_2} {b : β} {motive : β → Sort u_3} {op : β → α → β} (hb : motive b) (hl : (b : β) → motive b → (a : α) → a ∈ [] → motive (op b a)) :
foldlRecOn [] op hb hl = hbh
huList.foldlRecOn_cons}(hj,  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhXr  theorem List.foldlRecOn_cons {β : Type u_1} {α : Type u_2} {b : β} {x : α} {l : List α} {motive : β → Sort u_3} {op : β → α → β} (hb : motive b) (hl : (b : β) → motive b → (a : α) → a ∈ x :: l → motive (op b a)) :
foldlRecOn (x :: l) op hb hl = foldlRecOn l op (hl b hb x ⋯) fun (b : β) (c : motive b) (a : α) (m : a ∈ l) => hl b c a ⋯h
huList.foldrRecOn}(hj,  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhdef List.foldrRecOn {β : Type u_1} {α : Type u_2} {motive : β → Sort u_3} (l : List α) (op : α → β → β) {b : β} :
motive b → ((b : β) → motive b → (a : α) → a ∈ l → motive (op a b)) → motive (foldr op b l)h
XB  A reasoning principle for proving propositions about the result of List.foldr by establishing an invariant that is true for the initial data and preserved by the operation being folded.
Because the motive can return a type in any sort, this function may be used to construct data as well as to prove propositions.
Example:uList.foldrRecOn_nil}(hj,  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.foldrRecOn_nil {β : Type u_1} {α : Type u_2} {b : β} {motive : β → Sort u_3} {op : α → β → β} (hb : motive b) (hl : (b : β) → motive b → (a : α) → a ∈ [] → motive (op a b)) :
foldrRecOn [] op hb hl = hbh
huList.foldrRecOn_cons}(hj,  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhX  theorem List.foldrRecOn_cons {β : Type u_1} {α : Type u_2} {b : β} {x : α} {l : List α} {motive : β → Sort u_3} {op : α → β → β} (hb : motive b) (hl : (b : β) → motive b → (a : α) → a ∈ x :: l → motive (op a b)) :
foldrRecOn (x :: l) op hb hl = hl (foldr op b l) (foldrRecOn l op hb fun (b : β) (c : motive b) (a : α) (m : a ∈ l) => hl b c a ⋯) x ⋯h
huList.foldl_rel}(hj,  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhXv  theorem List.foldl_rel {α : Type u_1} {β : Type u_2} {γ : Type u_3} {l : List α} {f : β → α → β} {g : γ → α → γ} {a : β} {b : γ} {r : β → γ → Prop} (h : r a b) (h' : ∀ (a : α), a ∈ l → ∀ (c : β) (c' : γ), r c c' → r (f c a) (g c' a)) :
r (foldl (fun (acc : β) (a : α) => f acc a) a l) (foldl (fun (acc : γ) (a : α) => g acc a) b l)h
We can prove that two folds over the same list are related (by some arbitrary relation) if we know that the initial elements are related and the folding function, for each element of the list, preserves the relation.uList.foldr_rel}(hj,  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhXv  theorem List.foldr_rel {α : Type u_1} {β : Type u_2} {γ : Type u_3} {l : List α} {f : α → β → β} {g : α → γ → γ} {a : β} {b : γ} {r : β → γ → Prop} (h : r a b) (h' : ∀ (a : α), a ∈ l → ∀ (c : β) (c' : γ), r c c' → r (f a c) (g a c')) :
r (foldr (fun (a : α) (acc : β) => f a acc) a l) (foldr (fun (a : α) (acc : γ) => g a acc) b l)h
We can prove that two folds over the same list are related (by some arbitrary relation) if we know that the initial elements are related and the folding function, for each element of the list, preserves the relation.uList.foldl_add_const}(hj,  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.foldl_add_const {α : Type u_1} {l : List α} {a b : Nat} :
foldl (fun (x : Nat) (x_1 : α) => x + a) b l = b + a * l.lengthh
huList.foldr_add_const}(hj,  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.foldr_add_const {α : Type u_1} {l : List α} {a b : Nat} :
foldr (fun (x : α) (x : Nat) => x + a) b l = b + a * l.lengthh
huList.head_reverse}(hj,  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhqtheorem List.head_reverse {α : Type u_1} {l : List α} (h : l.reverse ≠ []) :
l.reverse.head h = l.getLast ⋯h
huList.getLast_eq_head_reverse}(hj,  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhttheorem List.getLast_eq_head_reverse {α : Type u_1} {l : List α} (h : l ≠ []) :
l.getLast h = l.reverse.head ⋯h
hu#List.getLast_eq_iff_getLast_eq_some}(hj,  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhabbrev List.getLast_eq_iff_getLast_eq_some {α : Type u_1} {a : α} {xs : List α} (h : xs ≠ []) :
xs.getLast h = a ↔ xs.getLast? = some ah
huList.getLast?_eq_none_iff}(hj,  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhatheorem List.getLast?_eq_none_iff {α : Type u_1} {xs : List α} :
xs.getLast? = none ↔ xs = []h
huList.getLast?_eq_some_iff}(hj,  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.getLast?_eq_some_iff {α : Type u_1} {xs : List α} {a : α} :
xs.getLast? = some a ↔ ∃ (ys : List α), xs = ys ++ [a]h
huList.getLast?_isSome}(hj,  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhhtheorem List.getLast?_isSome {α✝ : Type u_1} {l : List α✝} :
l.getLast?.isSome = true ↔ l ≠ []h
huList.getLast_reverse}(hj,  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhttheorem List.getLast_reverse {α : Type u_1} {l : List α} (h : l.reverse ≠ []) :
l.reverse.getLast h = l.head ⋯h
huList.head_eq_getLast_reverse}(hj,  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhttheorem List.head_eq_getLast_reverse {α : Type u_1} {l : List α} (h : l ≠ []) :
l.head h = l.reverse.getLast ⋯h
huList.getLast_append_of_ne_nil}(hj,  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.getLast_append_of_ne_nil {α : Type u_1} {l' l : List α} (h₁ : l ++ l' ≠ []) (h₂ : l' ≠ []) :
(l ++ l').getLast h₁ = l'.getLast h₂h
huList.getLast_append}(hj,  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.getLast_append {α : Type u_1} {l' l : List α} (h : l ++ l' ≠ []) :
(l ++ l').getLast h = if h' : l'.isEmpty = true then l.getLast ⋯ else l'.getLast ⋯h
huList.getLast_append_right}(hj,  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhytheorem List.getLast_append_right {α : Type u_1} {l' l : List α} (h : l' ≠ []) :
(l ++ l').getLast ⋯ = l'.getLast hh
huList.getLast_append_left}(hj,  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.getLast_append_left {α : Type u_1} {l' l : List α} (w : l ++ l' ≠ []) (h : l' = []) :
(l ++ l').getLast w = l.getLast ⋯h
huList.getLast?_append}(hj,  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhntheorem List.getLast?_append {α : Type u_1} {l l' : List α} :
(l ++ l').getLast? = l'.getLast?.or l.getLast?h
huList.getLast_filter_of_pos}(hj,  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.getLast_filter_of_pos {α : Type u_1} {p : α → Bool} {l : List α} (w : l ≠ []) (h : p (l.getLast w) = true) :
(filter p l).getLast ⋯ = l.getLast wh
hu!List.getLast_filterMap_of_eq_some}(hj-  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.getLast_filterMap_of_eq_some {α : Type u_1} {β : Type u_2} {f : α → Option β} {l : List α} (w : l ≠ []) {b : β} (h : f (l.getLast w) = some b) :
(filterMap f l).getLast ⋯ = bh
huList.getLast?_flatMap}(hj-  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.getLast?_flatMap {α : Type u_1} {β : Type u_2} {l : List α} {f : α → List β} :
(flatMap f l).getLast? = findSome? (fun (a : α) => (f a).getLast?) l.reverseh
huList.getLast?_flatten}(hj	-  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.getLast?_flatten {α : Type u_1} {L : List (List α)} :
L.flatten.getLast? = findSome? (fun (l : List α) => l.getLast?) L.reverseh
huList.getLast?_replicate}(hj
-  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlh~theorem List.getLast?_replicate {α : Type u_1} {a : α} {n : Nat} :
(replicate n a).getLast? = if n = 0 then none else some ah
huList.getLast_replicate}(hj-  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.getLast_replicate {n : Nat} {α✝ : Type u_1} {a : α✝} (w : replicate n a ≠ []) :
(replicate n a).getLast w = ah
huList.leftpad_prefix}(hj-  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlh{theorem List.leftpad_prefix {α : Type u_1} {n : Nat} {a : α} {l : List α} :
replicate (n - l.length) a <+: leftpad n a lh
huList.leftpad_suffix}(hj-  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhbtheorem List.leftpad_suffix {α : Type u_1} {n : Nat} {a : α} {l : List α} :
l <:+ leftpad n a lh
huList.elem_cons_self}(hj-  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhutheorem List.elem_cons_self {α : Type u_1} {as : List α} [BEq α] [LawfulBEq α] {a : α} :
elem a (a :: as) = trueh
huList.contains_eq_any_beq}(hj!-  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlh~theorem List.contains_eq_any_beq {α : Type u_1} [BEq α] {l : List α} {a : α} :
l.contains a = l.any fun (x : α) => a == xh
hu List.contains_iff_exists_mem_beq}(hj%-  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.contains_iff_exists_mem_beq {α : Type u_1} [BEq α] {l : List α} {a : α} :
l.contains a = true ↔ ∃ (a' : α), a' ∈ l ∧ (a == a') = trueh
huList.contains_iff_mem}(hj)-  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlh~theorem List.contains_iff_mem {α : Type u_1} [BEq α] [LawfulBEq α] {l : List α} {a : α} :
l.contains a = true ↔ a ∈ lh
huList.contains_map}(hj--  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.contains_map {β : Type u_1} {α : Type u_2} [BEq β] {l : List α} {x : β} {f : α → β} :
(map f l).contains x = l.any fun (a : α) => x == f ah
huList.contains_filter}(hj1-  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.contains_filter {α : Type u_1} [BEq α] {l : List α} {x : α} {p : α → Bool} :
(filter p l).contains x = l.any fun (a : α) => x == a && p ah
huList.contains_filterMap}(hj5-  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.contains_filterMap {β : Type u_1} {α : Type u_2} [BEq β] {l : List α} {x : β} {f : α → Option β} :
(filterMap f l).contains x = l.any fun (a : α) => Option.any (fun (b : β) => x == b) (f a)h
huList.contains_append}(hj9-  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.contains_append {α : Type u_1} [BEq α] {l₁ l₂ : List α} {x : α} :
(l₁ ++ l₂).contains x = (l₁.contains x || l₂.contains x)h
huList.contains_flatten}(hj=-  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.contains_flatten {α : Type u_1} [BEq α] {l : List (List α)} {x : α} :
l.flatten.contains x = l.any fun (l : List α) => l.contains xh
huList.contains_reverse}(hjA-  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhstheorem List.contains_reverse {α : Type u_1} [BEq α] {l : List α} {x : α} :
l.reverse.contains x = l.contains xh
huList.contains_flatMap}(hjE-  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.contains_flatMap {β : Type u_1} {α : Type u_2} [BEq β] {l : List α} {f : α → List β} {x : β} :
(flatMap f l).contains x = l.any fun (a : α) => (f a).contains xh
huList.partition_eq_filter_filter}(hjI-  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.partition_eq_filter_filter {α : Type u_1} {p : α → Bool} {l : List α} :
partition p l = (filter p l, filter (not ∘ p) l)h
huList.mem_partition}(hjM-  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.mem_partition {α✝ : Type u_1} {l : List α✝} {a : α✝} {p : α✝ → Bool} :
a ∈ l ↔ a ∈ (partition p l).fst ∨ a ∈ (partition p l).sndh
huList.length_dropLast}(hjQ-  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlh`theorem List.length_dropLast {α : Type u_1} {xs : List α} :
xs.dropLast.length = xs.length - 1h
huList.getElem_dropLast}(hjU-  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlh|theorem List.getElem_dropLast {α : Type u_1} {xs : List α} {i : Nat} (h : i < xs.dropLast.length) :
xs.dropLast[i] = xs[i]h
huList.getElem?_dropLast}(hjY-  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.getElem?_dropLast {α : Type u_1} {xs : List α} {i : Nat} :
xs.dropLast[i]? = if i < xs.length - 1 then xs[i]? else noneh
huList.head_dropLast}(hj]-  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhutheorem List.head_dropLast {α : Type u_1} {xs : List α} (h : xs.dropLast ≠ []) :
xs.dropLast.head h = xs.head ⋯h
huList.head?_dropLast}(hja-  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhytheorem List.head?_dropLast {α : Type u_1} {xs : List α} :
xs.dropLast.head? = if 1 < xs.length then xs.head? else noneh
huList.getLast_dropLast}(hje-  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.getLast_dropLast {α : Type u_1} {xs : List α} (h : xs.dropLast ≠ []) :
xs.dropLast.getLast h = xs[xs.length - 2]h
huList.getLast?_dropLast}(hji-  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.getLast?_dropLast {α : Type u_1} {xs : List α} :
xs.dropLast.getLast? = if xs.length ≤ 1 then none else xs[xs.length - 2]?h
huList.dropLast_cons_of_ne_nil}(hjm-  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlh~theorem List.dropLast_cons_of_ne_nil {α : Type u} {x : α} {l : List α} (h : l ≠ []) :
(x :: l).dropLast = x :: l.dropLasth
huList.dropLast_concat_getLast}(hjq-  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhstheorem List.dropLast_concat_getLast {α : Type u_1} {l : List α} (h : l ≠ []) :
l.dropLast ++ [l.getLast h] = lh
huList.map_dropLast}(hju-  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.map_dropLast {α : Type u_1} {β : Type u_2} {f : α → β} {l : List α} :
map f l.dropLast = (map f l).dropLasth
huList.dropLast_append_of_ne_nil}(hjy-  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhztheorem List.dropLast_append_of_ne_nil {α : Type u} {l l' : List α} :
l ≠ [] → (l' ++ l).dropLast = l' ++ l.dropLasth
huList.dropLast_append}(hj}-  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.dropLast_append {α : Type u_1} {l₁ l₂ : List α} :
(l₁ ++ l₂).dropLast = if l₂.isEmpty = true then l₁.dropLast else l₁ ++ l₂.dropLasth
huList.dropLast_append_cons}(hj-  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.dropLast_append_cons {α✝ : Type u_1} {l₁ : List α✝} {b : α✝} {l₂ : List α✝} :
(l₁ ++ b :: l₂).dropLast = l₁ ++ (b :: l₂).dropLasth
huList.dropLast_concat}(hj-  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhotheorem List.dropLast_concat {α✝ : Type u_1} {l₁ : List α✝} {b : α✝} :
(l₁ ++ [b]).dropLast = l₁h
huList.dropLast_replicate}(hj-  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhstheorem List.dropLast_replicate {α : Type u_1} {n : Nat} {a : α} :
(replicate n a).dropLast = replicate (n - 1) ah
hu!List.dropLast_cons_self_replicate}(hj-  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlh|theorem List.dropLast_cons_self_replicate {α : Type u_1} {n : Nat} {a : α} :
(a :: replicate n a).dropLast = replicate n ah
huList.tail_reverse}(hj-  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlh]theorem List.tail_reverse {α : Type u_1} {l : List α} :
l.reverse.tail = l.dropLast.reverseh
huList.splitAt_go}(hj-  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.splitAt_go {α : Type u_1} {xs : List α} {i : Nat} {l acc : List α} :
splitAt.go l xs i acc = if i < xs.length then (acc.reverse ++ take i xs, drop i xs) else (l, [])h
huList.not_any_eq_all_not}(hj-  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhytheorem List.not_any_eq_all_not {α : Type u_1} {l : List α} {p : α → Bool} :
(!l.any p) = l.all fun (a : α) => !p ah
huList.not_all_eq_any_not}(hj-  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhytheorem List.not_all_eq_any_not {α : Type u_1} {l : List α} {p : α → Bool} :
(!l.all p) = l.any fun (a : α) => !p ah
huList.and_any_distrib_left}(hj-  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.and_any_distrib_left {α : Type u_1} {l : List α} {p : α → Bool} {q : Bool} :
(q && l.any p) = l.any fun (a : α) => q && p ah
huList.and_any_distrib_right}(hj-  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.and_any_distrib_right {α : Type u_1} {l : List α} {p : α → Bool} {q : Bool} :
(l.any p && q) = l.any fun (a : α) => p a && qh
huList.or_all_distrib_left}(hj-  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.or_all_distrib_left {α : Type u_1} {l : List α} {p : α → Bool} {q : Bool} :
(q || l.all p) = l.all fun (a : α) => q || p ah
huList.or_all_distrib_right}(hj-  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.or_all_distrib_right {α : Type u_1} {l : List α} {p : α → Bool} {q : Bool} :
(l.all p || q) = l.all fun (a : α) => p a || qh
huList.any_eq_not_all_not}(hj-  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhwtheorem List.any_eq_not_all_not {α : Type u_1} {l : List α} {p : α → Bool} :
l.any p = !l.all fun (x : α) => !p xh
huList.all_eq_not_any_not}(hj-  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhwtheorem List.all_eq_not_any_not {α : Type u_1} {l : List α} {p : α → Bool} :
l.all p = !l.any fun (x : α) => !p xh
huList.any_map}(hj-  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.any_map {α : Type u_1} {β : Type u_2} {f : α → β} {l : List α} {p : β → Bool} :
(map f l).any p = l.any (p ∘ f)h
huList.all_map}(hj-  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.all_map {α : Type u_1} {β : Type u_2} {f : α → β} {l : List α} {p : β → Bool} :
(map f l).all p = l.all (p ∘ f)h
huList.any_filter}(hj-  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.any_filter {α : Type u_1} {l : List α} {p q : α → Bool} :
(filter p l).any q = l.any fun (a : α) => p a && q ah
huList.all_filter}(hj-  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.all_filter {α : Type u_1} {l : List α} {p q : α → Bool} :
(filter p l).all q = l.all fun (a : α) => !p a || q ah
huList.any_filterMap}(hj-  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.any_filterMap {α : Type u_1} {β : Type u_2} {l : List α} {f : α → Option β} {p : β → Bool} :
(filterMap f l).any p = l.any fun (a : α) =>
    match f a with
    | some b => p b
    | none => falseh
huList.all_filterMap}(hj-  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.all_filterMap {α : Type u_1} {β : Type u_2} {l : List α} {f : α → Option β} {p : β → Bool} :
(filterMap f l).all p = l.all fun (a : α) =>
    match f a with
    | some b => p b
    | none => trueh
huList.any_append}(hj-  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhwtheorem List.any_append {α : Type u_1} {f : α → Bool} {xs ys : List α} :
(xs ++ ys).any f = (xs.any f || ys.any f)h
huList.all_append}(hj-  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhwtheorem List.all_append {α : Type u_1} {f : α → Bool} {xs ys : List α} :
(xs ++ ys).all f = (xs.all f && ys.all f)h
huList.any_flatten}(hj-  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.any_flatten {α : Type u_1} {f : α → Bool} {l : List (List α)} :
l.flatten.any f = l.any fun (x : List α) => x.any fh
huList.all_flatten}(hj-  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.all_flatten {α : Type u_1} {f : α → Bool} {l : List (List α)} :
l.flatten.all f = l.all fun (x : List α) => x.all fh
huList.any_flatMap}(hj-  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.any_flatMap {α : Type u_1} {β : Type u_2} {p : β → Bool} {l : List α} {f : α → List β} :
(flatMap f l).any p = l.any fun (a : α) => (f a).any ph
huList.all_flatMap}(hj-  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.all_flatMap {α : Type u_1} {β : Type u_2} {p : β → Bool} {l : List α} {f : α → List β} :
(flatMap f l).all p = l.all fun (a : α) => (f a).all ph
huList.any_reverse}(hj-  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhdtheorem List.any_reverse {α : Type u_1} {f : α → Bool} {l : List α} :
l.reverse.any f = l.any fh
huList.all_reverse}(hj-  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhdtheorem List.all_reverse {α : Type u_1} {f : α → Bool} {l : List α} :
l.reverse.all f = l.all fh
huList.any_replicate}(hj-  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.any_replicate {α : Type u_1} {f : α → Bool} {n : Nat} {a : α} :
(replicate n a).any f = if n = 0 then false else f ah
huList.all_replicate}(hj-  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.all_replicate {α : Type u_1} {f : α → Bool} {n : Nat} {a : α} :
(replicate n a).all f = if n = 0 then true else f ah
huList.any_congr}(hj-  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.any_congr {α : Type u_1} {l₁ l₂ : List α} (w : l₁ = l₂) {p q : α → Bool} (h : ∀ (a : α), p a = q a) :
l₁.any p = l₂.any qh
huList.all_congr}(hj-  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.all_congr {α : Type u_1} {l₁ l₂ : List α} (w : l₁ = l₂) {p q : α → Bool} (h : ∀ (a : α), p a = q a) :
l₁.all p = l₂.all qh
huList.contains_congr}(hj.  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.contains_congr {α : Type u_1} [BEq α] [PartialEquivBEq α] {l : List α} {x y : α} (h : (x == y) = true) :
l.contains x = l.contains yh
huList.replace_cons_self}(hj.  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.replace_cons_self {α : Type u_1} [BEq α] {as : List α} {b : α} [LawfulBEq α] {a : α} :
(a :: as).replace a b = b :: ash
huList.replace_singleton}(hj	.  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlh{theorem List.replace_singleton {α : Type u_1} [BEq α] {a b c : α} :
[a].replace b c = [if (b == a) = true then c else a]h
huList.replace_of_not_mem}(hj
.  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.replace_of_not_mem {α : Type u_1} [BEq α] {a b : α} [LawfulBEq α] {l : List α} (h : ¬a ∈ l) :
l.replace a b = lh
huList.length_replace}(hj.  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhqtheorem List.length_replace {α : Type u_1} [BEq α] {a b : α} {l : List α} :
(l.replace a b).length = l.lengthh
huList.getElem?_replace}(hj.  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.getElem?_replace {α : Type u_1} [BEq α] {a b : α} [LawfulBEq α] {l : List α} {i : Nat} :
(l.replace a b)[i]? = if (l[i]? == some a) = true then if a ∈ take i l then some a else some b else l[i]?h
huList.getElem?_replace_of_ne}(hj.  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.getElem?_replace_of_ne {α : Type u_1} [BEq α] {a b : α} [LawfulBEq α] {l : List α} {i : Nat} (h : l[i]? ≠ some a) :
(l.replace a b)[i]? = l[i]?h
huList.getElem_replace}(hj.  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.getElem_replace {α : Type u_1} [BEq α] {a b : α} [LawfulBEq α] {l : List α} {i : Nat} (h : i < l.length) :
(l.replace a b)[i] = if (l[i] == a) = true then if a ∈ take i l then a else b else l[i]h
huList.getElem_replace_of_ne}(hj!.  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.getElem_replace_of_ne {α : Type u_1} [BEq α] {a b : α} [LawfulBEq α] {l : List α} {i : Nat} {h : i < l.length} (h' : l[i] ≠ a) :
(l.replace a b)[i] = l[i]h
huList.head?_replace}(hj%.  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.head?_replace {α : Type u_1} [BEq α] {l : List α} {a b : α} :
(l.replace a b).head? = match l.head? with
  | none => none
  | some x => some (if (a == x) = true then b else x)h
huList.head_replace}(hj).  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.head_replace {α : Type u_1} [BEq α] {l : List α} {a b : α} (w : l.replace a b ≠ []) :
(l.replace a b).head w = if (a == l.head ⋯) = true then b else l.head ⋯h
huList.replace_append}(hj-.  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.replace_append {α : Type u_1} [BEq α] {a b : α} [LawfulBEq α] {l₁ l₂ : List α} :
(l₁ ++ l₂).replace a b = if a ∈ l₁ then l₁.replace a b ++ l₂ else l₁ ++ l₂.replace a bh
huList.replace_append_left}(hj1.  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.replace_append_left {α : Type u_1} [BEq α] {a b : α} [LawfulBEq α] {l₁ l₂ : List α} (h : a ∈ l₁) :
(l₁ ++ l₂).replace a b = l₁.replace a b ++ l₂h
huList.replace_append_right}(hj5.  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.replace_append_right {α : Type u_1} [BEq α] {a b : α} [LawfulBEq α] {l₁ l₂ : List α} (h : ¬a ∈ l₁) :
(l₁ ++ l₂).replace a b = l₁ ++ l₂.replace a bh
huList.replace_take}(hj9.  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.replace_take {α : Type u_1} [BEq α] {a b : α} {l : List α} {i : Nat} :
(take i l).replace a b = take i (l.replace a b)h
huList.replace_replicate_self}(hj=.  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.replace_replicate_self {α : Type u_1} [BEq α] {n : Nat} {b : α} [LawfulBEq α] {a : α} (h : 0 < n) :
(replicate n a).replace a b = b :: replicate (n - 1) ah
huList.replace_replicate_ne}(hjA.  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.replace_replicate_ne {α : Type u_1} [BEq α] {n : Nat} [LawfulBEq α] {a b c : α} (h : (!b == a) = true) :
(replicate n a).replace b c = replicate n ah
huList.insert_nil}(hjE.  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhRtheorem List.insert_nil {α : Type u_1} [BEq α] (a : α) :
List.insert a [] = [a]h
huList.contains_insert}(hjI.  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.contains_insert {α : Type u_1} [BEq α] [PartialEquivBEq α] {l : List α} {a x : α} :
(List.insert a l).contains x = (x == a || l.contains x)h
huList.insert_of_mem}(hjM.  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlh}theorem List.insert_of_mem {α : Type u_1} [BEq α] [LawfulBEq α] {a : α} {l : List α} (h : a ∈ l) :
List.insert a l = lh
huList.insert_of_not_mem}(hjQ.  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.insert_of_not_mem {α : Type u_1} [BEq α] [LawfulBEq α] {a : α} {l : List α} (h : ¬a ∈ l) :
List.insert a l = a :: lh
huList.mem_insert_iff}(hjU.  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.mem_insert_iff {α : Type u_1} [BEq α] [LawfulBEq α] {b a : α} {l : List α} :
a ∈ List.insert b l ↔ a = b ∨ a ∈ lh
huList.mem_insert_self}(hjY.  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhstheorem List.mem_insert_self {α : Type u_1} [BEq α] [LawfulBEq α] {a : α} {l : List α} :
a ∈ List.insert a lh
huList.mem_insert_of_mem}(hj].  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.mem_insert_of_mem {α : Type u_1} [BEq α] [LawfulBEq α] {a b : α} {l : List α} (h : a ∈ l) :
a ∈ List.insert b lh
huList.eq_or_mem_of_mem_insert}(hja.  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.eq_or_mem_of_mem_insert {α : Type u_1} [BEq α] [LawfulBEq α] {b a : α} {l : List α} (h : a ∈ List.insert b l) :
a = b ∨ a ∈ lh
huList.length_insert_of_mem}(hje.  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.length_insert_of_mem {α : Type u_1} [BEq α] [LawfulBEq α] {a : α} {l : List α} (h : a ∈ l) :
(List.insert a l).length = l.lengthh
huList.length_insert_of_not_mem}(hji.  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.length_insert_of_not_mem {α : Type u_1} [BEq α] [LawfulBEq α] {a : α} {l : List α} (h : ¬a ∈ l) :
(List.insert a l).length = l.length + 1h
huList.length_insert}(hjm.  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.length_insert {α : Type u_1} [BEq α] [LawfulBEq α] {a : α} {l : List α} :
(List.insert a l).length = l.length + if a ∈ l then 0 else 1h
huList.length_le_length_insert}(hjq.  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.length_le_length_insert {α : Type u_1} [BEq α] [LawfulBEq α] {l : List α} {a : α} :
l.length ≤ (List.insert a l).lengthh
huList.length_insert_pos}(hju.  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlh|theorem List.length_insert_pos {α : Type u_1} [BEq α] [LawfulBEq α] {l : List α} {a : α} :
0 < (List.insert a l).lengthh
huList.insert_eq}(hjy.  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.insert_eq {α : Type u_1} [BEq α] [LawfulBEq α] {l : List α} {a : α} :
List.insert a l = if a ∈ l then l else a :: lh
huList.getElem?_insert_zero}(hj}.  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.getElem?_insert_zero {α : Type u_1} [BEq α] [LawfulBEq α] {l : List α} {a : α} :
(List.insert a l)[0]? = if a ∈ l then l[0]? else some ah
huList.getElem?_insert_succ}(hj.  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.getElem?_insert_succ {α : Type u_1} [BEq α] [LawfulBEq α] {l : List α} {a : α} {i : Nat} :
(List.insert a l)[i + 1]? = if a ∈ l then l[i + 1]? else l[i]?h
huList.getElem?_insert}(hj.  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.getElem?_insert {α : Type u_1} [BEq α] [LawfulBEq α] {l : List α} {a : α} {i : Nat} :
(List.insert a l)[i]? = if a ∈ l then l[i]? else if i = 0 then some a else l[i - 1]?h
huList.getElem_insert}(hj.  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.getElem_insert {α : Type u_1} [BEq α] [LawfulBEq α] {l : List α} {a : α} {i : Nat} (h : i < l.length) :
(List.insert a l)[i] = if a ∈ l then l[i] else if i = 0 then a else l[i - 1]h
huList.head?_insert}(hj.  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.head?_insert {α : Type u_1} [BEq α] [LawfulBEq α] {l : List α} {a : α} :
(List.insert a l).head? = some (if h : a ∈ l then l.head ⋯ else a)h
huList.head_insert}(hj.  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.head_insert {α : Type u_1} [BEq α] [LawfulBEq α] {l : List α} {a : α} (w : List.insert a l ≠ []) :
(List.insert a l).head w = if h : a ∈ l then l.head ⋯ else ah
huList.insert_append}(hj.  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.insert_append {α : Type u_1} [BEq α] [LawfulBEq α] {l₁ l₂ : List α} {a : α} :
List.insert a (l₁ ++ l₂) = if a ∈ l₂ then l₁ ++ l₂ else List.insert a l₁ ++ l₂h
huList.insert_append_of_mem_left}(hj.  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.insert_append_of_mem_left {α : Type u_1} [BEq α] [LawfulBEq α] {a : α} {l₁ l₂ : List α} (h : a ∈ l₂) :
List.insert a (l₁ ++ l₂) = l₁ ++ l₂h
hu"List.insert_append_of_not_mem_left}(hj.  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.insert_append_of_not_mem_left {α : Type u_1} [BEq α] [LawfulBEq α] {a : α} {l₁ l₂ : List α} (h : ¬a ∈ l₂) :
List.insert a (l₁ ++ l₂) = List.insert a l₁ ++ l₂h
huList.insert_replicate_self}(hj.  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.insert_replicate_self {α : Type u_1} [BEq α] [LawfulBEq α] {n : Nat} {a : α} (h : 0 < n) :
List.insert a (replicate n a) = replicate n ah
huList.insert_replicate_ne}(hj.  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.insert_replicate_ne {α : Type u_1} [BEq α] [LawfulBEq α] {n : Nat} {a b : α} (h : (!b == a) = true) :
List.insert b (replicate n a) = b :: replicate n ah
huList.any_insert}(hj.  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.any_insert {α : Type u_1} [BEq α] [LawfulBEq α] {f : α → Bool} {l : List α} {a : α} :
(List.insert a l).any f = (f a || l.any f)h
huList.all_insert}(hj.  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.all_insert {α : Type u_1} [BEq α] [LawfulBEq α] {f : α → Bool} {l : List α} {a : α} :
(List.insert a l).all f = (f a && l.all f)h
huList.removeAll_nil}(hj.  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhYtheorem List.removeAll_nil {α : Type u_1} [BEq α] {xs : List α} :
xs.removeAll [] = xsh
huList.cons_removeAll}(hj.  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.cons_removeAll {α : Type u_1} [BEq α] {x : α} {xs ys : List α} :
(x :: xs).removeAll ys = if ys.contains x = false then x :: xs.removeAll ys else xs.removeAll ysh
huList.removeAll_cons}(hj.  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.removeAll_cons {α : Type u_1} [BEq α] {xs : List α} {y : α} {ys : List α} :
xs.removeAll (y :: ys) = (filter (fun (x : α) => !x == y) xs).removeAll ysh
huList.filter_removeAll_filter}(hj.  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.filter_removeAll_filter {α : Type u_1} [BEq α] [LawfulBEq α] {p : α → Bool} {xs ys : List α} :
(filter p xs).removeAll (filter p ys) = (filter p xs).removeAll ysh
huList.eraseDupsBy_nil}(hj.  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlh]theorem List.eraseDupsBy_nil {α : Type u_1} {r : α → α → Bool} :
eraseDupsBy r [] = []h
huList.eraseDupsBy_cons}(hj.  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.eraseDupsBy_cons {α✝ : Type u_1} {a : α✝} {as : List α✝} {r : α✝ → α✝ → Bool} :
eraseDupsBy r (a :: as) = a :: eraseDupsBy r (filter (fun (b : α✝) => decide (r b a = false)) as)h
huList.eraseDups_nil}(hj.  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhGtheorem List.eraseDups_nil {α : Type u_1} [BEq α] :
[].eraseDups = []h
huList.eraseDups_cons}(hj.  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.eraseDups_cons {α : Type u_1} [BEq α] {a : α} {as : List α} :
(a :: as).eraseDups = a :: (filter (fun (b : α) => !b == a) as).eraseDupsh
huList.eraseDups_append}(hj.  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.eraseDups_append {α : Type u_1} [BEq α] [LawfulBEq α] {as bs : List α} :
(as ++ bs).eraseDups = as.eraseDups ++ (bs.removeAll as).eraseDupsh
huList.get_cons_zero}(hj.  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlh_theorem List.get_cons_zero {α✝ : Type u_1} {a : α✝} {l : List α✝} :
(a :: l).get 0 = ah
huList.get_cons_succ}(hj.  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.get_cons_succ {α : Type u_1} {i : Nat} {a : α} {as : List α} {h : i + 1 < (a :: as).length} :
(a :: as).get ⟨i + 1, h⟩ = as.get ⟨i, ⋯⟩h
huList.get_cons_succ'}(hj.  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhytheorem List.get_cons_succ' {α : Type u_1} {a : α} {as : List α} {i : Fin as.length} :
(a :: as).get i.succ = as.get ih
huList.get_mk_zero}(hj.  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhitheorem List.get_mk_zero {α : Type u_1} {l : List α} (h : 0 < l.length) :
l.get ⟨0, h⟩ = l.head ⋯h
huList.get?_zero}(hj.  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhItheorem List.get?_zero {α : Type u_1} (l : List α) :
l.get? 0 = l.head?h
huList.get_of_eq}(hj.  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhztheorem List.get_of_eq {α : Type u_1} {l l' : List α} (h : l = l') (i : Fin l.length) :
l.get i = l'.get ⟨↑i, ⋯⟩h
X  If one has l.get i in an expression (with i : Fin l.length) and h : l = l', rw [h] will give a "motive is not type correct" error, as it cannot rewrite the i : Fin l.length to Fin l'.length directly. The theorem get_of_eq can be used to make such a rewrite, with rw [get_of_eq h].uList.get!_of_get?}(hj.  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlh~theorem List.get!_of_get? {α : Type u_1} {a : α} [Inhabited α] {l : List α} {n : Nat} :
l.get? n = some a → l.get! n = ah
huList.get!_len_le}(hj.  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhwtheorem List.get!_len_le {α : Type u_1} [Inhabited α] {l : List α} {n : Nat} :
l.length ≤ n → l.get! n = defaulth
huList.getElem!_nil}(hj.  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhUtheorem List.getElem!_nil {α : Type u_1} [Inhabited α] {n : Nat} :
[][n]! = defaulth
huList.getElem!_cons_zero}(hj.  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhhtheorem List.getElem!_cons_zero {α : Type u_1} {a : α} [Inhabited α] {l : List α} :
(a :: l)[0]! = a/      h
huList.getElem!_cons_succ}(hj.  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhztheorem List.getElem!_cons_succ {α : Type u_1} {a : α} {i : Nat} [Inhabited α] {l : List α} :
(a :: l)[i + 1]! = l[i]!h
huList.getElem!_of_getElem?}(hj/  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.getElem!_of_getElem? {α : Type u_1} {a : α} [Inhabited α] {l : List α} {i : Nat} :
l[i]? = some a → l[i]! = ah
huList.ext_get}(hj/  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhtheorem List.ext_get {α : Type u_1} {l₁ l₂ : List α} (hl : l₁.length = l₂.length) (h : ∀ (n : Nat) (h₁ : n < l₁.length) (h₂ : n < l₂.length), l₁.get ⟨n, h₁⟩ = l₂.get ⟨n, h₂⟩) :
l₁ = l₂h
huList.get_of_mem}(hj
/  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhrtheorem List.get_of_mem {α : Type u_1} {a : α} {l : List α} (h : a ∈ l) :
∃ (n : Fin l.length), l.get n = ah
huList.get?_of_mem}(hj/  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhptheorem List.get?_of_mem {α : Type u_1} {a : α} {l : List α} (h : a ∈ l) :
∃ (n : Nat), l.get? n = some ah
huList.get_mem}(hj/  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhUtheorem List.get_mem {α : Type u_1} (l : List α) (n : Fin l.length) :
l.get n ∈ lh
huList.mem_of_get?}(hj/  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhktheorem List.mem_of_get? {α : Type u_1} {l : List α} {n : Nat} {a : α} (e : l.get? n = some a) :
a ∈ lh
huList.mem_iff_get}(hj/  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhqtheorem List.mem_iff_get {α : Type u_1} {a : α} {l : List α} :
a ∈ l ↔ ∃ (n : Fin l.length), l.get n = ah
huList.mem_iff_get?}(hj/  hOhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/List/Lemmas.htmlhotheorem List.mem_iff_get? {α : Type u_1} {a : α} {l : List α} :
a ∈ l ↔ ∃ (n : Nat), l.get? n = some ah
huList.compareLex}(hj"/  hGhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/Ord.htmlhedef List.compareLex {α : Type u_1} (cmp : α → α → Ordering) :
List α → List α → Orderingh
huList.instOrd}(hj&/  hGhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/Ord.htmlh>instance List.instOrd {α : Type u_1} [Ord α] :
Ord (List α)h
huList.compare_eq_compareLex}(hj*/  hGhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/Ord.htmlh_theorem List.compare_eq_compareLex {α : Type u_1} [Ord α] :
compare = List.compareLex compareh
huList.compareLex_cons_cons}(hj./  hGhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/Ord.htmlhtheorem List.compareLex_cons_cons {α : Type u_1} {cmp : α → α → Ordering} {x y : α} {xs ys : List α} :
List.compareLex cmp (x :: xs) (y :: ys) = (cmp x y).then (List.compareLex cmp xs ys)h
huList.compare_cons_cons}(hj2/  hGhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/Ord.htmlhtheorem List.compare_cons_cons {α : Type u_1} [Ord α] {x y : α} {xs ys : List α} :
compare (x :: xs) (y :: ys) = (compare x y).then (compare xs ys)h
huList.compareLex_nil_cons}(hj6/  hGhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/Ord.htmlhtheorem List.compareLex_nil_cons {α : Type u_1} {cmp : α → α → Ordering} {x : α} {xs : List α} :
List.compareLex cmp [] (x :: xs) = Ordering.lth
huList.compare_nil_cons}(hj:/  hGhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/Ord.htmlhstheorem List.compare_nil_cons {α : Type u_1} [Ord α] {x : α} {xs : List α} :
compare [] (x :: xs) = Ordering.lth
huList.compareLex_cons_nil}(hj>/  hGhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/Ord.htmlhtheorem List.compareLex_cons_nil {α : Type u_1} {cmp : α → α → Ordering} {x : α} {xs : List α} :
List.compareLex cmp (x :: xs) [] = Ordering.gth
huList.compare_cons_nil}(hjB/  hGhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/Ord.htmlhstheorem List.compare_cons_nil {α : Type u_1} [Ord α] {x : α} {xs : List α} :
compare (x :: xs) [] = Ordering.gth
huList.compareLex_nil_nil}(hjF/  hGhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/Ord.htmlhxtheorem List.compareLex_nil_nil {α : Type u_1} {cmp : α → α → Ordering} :
List.compareLex cmp [] [] = Ordering.eqh
huList.compare_nil_nil}(hjJ/  hGhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/Ord.htmlhStheorem List.compare_nil_nil {α : Type u_1} [Ord α] :
compare [] [] = Ordering.eqh
huList.isLE_compareLex_nil_left}(hjN/  hGhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/Ord.htmlhtheorem List.isLE_compareLex_nil_left {α : Type u_1} {cmp : α → α → Ordering} {xs : List α} :
(List.compareLex cmp [] xs).isLE = trueh
huList.isLE_compare_nil_left}(hjR/  hGhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/Ord.htmlhhtheorem List.isLE_compare_nil_left {α : Type u_1} [Ord α] {xs : List α} :
(compare [] xs).isLE = trueh
huList.isLE_compareLex_nil_right}(hjV/  hGhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/Ord.htmlhtheorem List.isLE_compareLex_nil_right {α : Type u_1} {cmp : α → α → Ordering} {xs : List α} :
(List.compareLex cmp xs []).isLE = true ↔ xs = []h
huList.isLE_compare_nil_right}(hjZ/  hGhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/Ord.htmlhutheorem List.isLE_compare_nil_right {α : Type u_1} [Ord α] {xs : List α} :
(compare xs []).isLE = true ↔ xs = []h
huList.isGE_compareLex_nil_left}(hj^/  hGhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/Ord.htmlhtheorem List.isGE_compareLex_nil_left {α : Type u_1} {cmp : α → α → Ordering} {xs : List α} :
(List.compareLex cmp [] xs).isGE = true ↔ xs = []h
huList.isGE_compare_nil_left}(hjb/  hGhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/Ord.htmlhttheorem List.isGE_compare_nil_left {α : Type u_1} [Ord α] {xs : List α} :
(compare [] xs).isGE = true ↔ xs = []h
huList.isGE_compareLex_nil_right}(hjf/  hGhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/Ord.htmlhtheorem List.isGE_compareLex_nil_right {α : Type u_1} {cmp : α → α → Ordering} {xs : List α} :
(List.compareLex cmp xs []).isGE = trueh
huList.isGE_compare_nil_right}(hjj/  hGhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/Ord.htmlhitheorem List.isGE_compare_nil_right {α : Type u_1} [Ord α] {xs : List α} :
(compare xs []).isGE = trueh
huList.compareLex_nil_left_eq_eq}(hjn/  hGhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/Ord.htmlhtheorem List.compareLex_nil_left_eq_eq {α : Type u_1} {cmp : α → α → Ordering} {xs : List α} :
List.compareLex cmp [] xs = Ordering.eq ↔ xs = []h
huList.compare_nil_left_eq_eq}(hjr/  hGhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/Ord.htmlhutheorem List.compare_nil_left_eq_eq {α : Type u_1} [Ord α] {xs : List α} :
compare [] xs = Ordering.eq ↔ xs = []h
huList.compareLex_nil_right_eq_eq}(hjv/  hGhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/Ord.htmlhtheorem List.compareLex_nil_right_eq_eq {α : Type u_1} {cmp : α → α → Ordering} {xs : List α} :
List.compareLex cmp xs [] = Ordering.eq ↔ xs = []h
huList.compare_nil_right_eq_eq}(hjz/  hGhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/Ord.htmlhvtheorem List.compare_nil_right_eq_eq {α : Type u_1} [Ord α] {xs : List α} :
compare xs [] = Ordering.eq ↔ xs = []h
hu%List.compareLex_eq_compareLex_toArray}(hj~/  hGhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/Ord.htmlhtheorem List.compareLex_eq_compareLex_toArray {α : Type u_1} {cmp : α → α → Ordering} {l₁ l₂ : List α} :
List.compareLex cmp l₁ l₂ = Array.compareLex cmp l₁.toArray l₂.toArrayh
huList.compare_eq_compare_toArray}(hj/  hGhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/Ord.htmlhtheorem List.compare_eq_compare_toArray {α : Type u_1} [Ord α] {l₁ l₂ : List α} :
compare l₁ l₂ = compare l₁.toArray l₂.toArrayh
hu	List.repr}(hj/  hHhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/Repr.htmlhLdef List.repr {α : Type u_1} [Repr α] (a : List α) (n : Nat) :
Std.Formath
hu
List.repr'}(hj/  hHhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/Repr.htmlh[def List.repr' {α : Type u_1} [Repr α] [ReprAtom α] (a : List α) (n : Nat) :
Std.Formath
hu
List.toString}(hj/  hRhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/ToString/Basic.htmlhDdef List.toString {α : Type u_1} [ToString α] :
List α → Stringh
XA  Converts a list into a string, using ToString.toString to convert its elements.
The resulting string resembles list literal syntax, with the elements separated by ", " and enclosed in square brackets.
The resulting string may not be valid Lean syntax, because there's no such expectation for ToString instances.
Examples:u
List.asString}(hj/  hPhttps://leanprover-community.github.io/mathlib4_docs/Init/Data/String/Basic.htmlh*def List.asString (s : List Char) :
Stringh
LCreates a string that contains the characters in a list, in order.
Examples:uList.instGetElemNatLtLength}(hj/  hFhttps://leanprover-community.github.io/mathlib4_docs/Init/GetElem.htmlh}instance List.instGetElemNatLtLength {α : Type u_1} :
GetElem (List α) Nat α fun (as : List α) (i : Nat) => i < as.lengthh
huList.getElem_cons_zero}(hj/  hFhttps://leanprover-community.github.io/mathlib4_docs/Init/GetElem.htmlhttheorem List.getElem_cons_zero {α : Type u_1} (a : α) (as : List α) (h : 0 < (a :: as).length) :
(a :: as)[0] = ah
huList.getElem_cons_succ}(hj/  hFhttps://leanprover-community.github.io/mathlib4_docs/Init/GetElem.htmlhtheorem List.getElem_cons_succ {α : Type u_1} (a : α) (as : List α) (i : Nat) (h : i + 1 < (a :: as).length) :
(a :: as)[i + 1] = as[i]h
huList.getElem_mem}(hj/  hFhttps://leanprover-community.github.io/mathlib4_docs/Init/GetElem.htmlh`theorem List.getElem_mem {α : Type u_1} {l : List α} {n : Nat} (h : n < l.length) :
l[n] ∈ lh
hu#List.getElem_cons_drop_succ_eq_drop}(hj/  hFhttps://leanprover-community.github.io/mathlib4_docs/Init/GetElem.htmlhtheorem List.getElem_cons_drop_succ_eq_drop {α : Type u_1} {as : List α} {i : Nat} (h : i < as.length) :
as[i] :: drop (i + 1) as = drop i ash
huList.get?Internal}(hj/  hFhttps://leanprover-community.github.io/mathlib4_docs/Init/GetElem.htmlhJdef List.get?Internal {α : Type u_1} (as : List α) (i : Nat) :
Option αh
7Internal implementation of as[i]?. Do not use directly.uList.get!Internal}(hj/  hFhttps://leanprover-community.github.io/mathlib4_docs/Init/GetElem.htmlhRdef List.get!Internal {α : Type u_1} [Inhabited α] (as : List α) (i : Nat) :
αh
7Internal implementation of as[i]!. Do not use directly.uList.instGetElem?NatLtLength}(hj/  hFhttps://leanprover-community.github.io/mathlib4_docs/Init/GetElem.htmlhinstance List.instGetElem?NatLtLength {α : Type u_1} :
GetElem? (List α) Nat α fun (as : List α) (i : Nat) => i < as.lengthh
yThis instance overrides the default implementation of a[i]? via decidableGetElem?, giving better definitional equalities.uList.get?Internal_eq_getElem?}(hj/  hFhttps://leanprover-community.github.io/mathlib4_docs/Init/GetElem.htmlhhtheorem List.get?Internal_eq_getElem? {α : Type u_1} {l : List α} {i : Nat} :
l.get?Internal i = l[i]?h
huList.get!Internal_eq_getElem!}(hj/  hFhttps://leanprover-community.github.io/mathlib4_docs/Init/GetElem.htmlhwtheorem List.get!Internal_eq_getElem! {α : Type u_1} [Inhabited α] {l : List α} {i : Nat} :
l.get!Internal i = l[i]!h
huList.getElem?_eq_getElem}(hj/  hFhttps://leanprover-community.github.io/mathlib4_docs/Init/GetElem.htmlhotheorem List.getElem?_eq_getElem {α : Type u_1} {l : List α} {i : Nat} (h : i < l.length) :
l[i]? = some l[i]h
huList.getElem?_eq_none_iff}(hj/  hFhttps://leanprover-community.github.io/mathlib4_docs/Init/GetElem.htmlhqtheorem List.getElem?_eq_none_iff {α✝ : Type u_1} {l : List α✝} {i : Nat} :
l[i]? = none ↔ l.length ≤ ih
huList.none_eq_getElem?_iff}(hj/  hFhttps://leanprover-community.github.io/mathlib4_docs/Init/GetElem.htmlhktheorem List.none_eq_getElem?_iff {α : Type u_1} {l : List α} {i : Nat} :
none = l[i]? ↔ l.length ≤ ih
huList.getElem?_eq_none}(hj/  hFhttps://leanprover-community.github.io/mathlib4_docs/Init/GetElem.htmlhotheorem List.getElem?_eq_none {α✝ : Type u_1} {l : List α✝} {i : Nat} (h : l.length ≤ i) :
l[i]? = noneh
hu!List.instLawfulGetElemNatLtLength}(hj/  hFhttps://leanprover-community.github.io/mathlib4_docs/Init/GetElem.htmlhinstance List.instLawfulGetElemNatLtLength {α : Type u_1} :
LawfulGetElem (List α) Nat α fun (as : List α) (i : Nat) => i < as.lengthh
hu
List.hasDecEq}(hj/  hFhttps://leanprover-community.github.io/mathlib4_docs/Init/Prelude.htmlhTdef List.hasDecEq {α : Type u} [DecidableEq α] (a b : List α) :
Decidable (a = b)h
NImplements decidable equality for List α, assuming α has decidable equality.uList.length}(hj/  hFhttps://leanprover-community.github.io/mathlib4_docs/Init/Prelude.htmlh1def List.length {α : Type u_1} :
List α → Nath
yThe length of a list.
This function is overridden in the compiler to lengthTR, which uses constant stack space.
Examples:uList.lengthTRAux}(hj/  hFhttps://leanprover-community.github.io/mathlib4_docs/Init/Prelude.htmlh>def List.lengthTRAux {α : Type u_1} :
List α → Nat → Nath
%Auxiliary function for List.lengthTR.u
List.lengthTR}(hj/  hFhttps://leanprover-community.github.io/mathlib4_docs/Init/Prelude.htmlh6def List.lengthTR {α : Type u_1} (as : List α) :
Nath
The length of a list.
This is a tail-recursive version of List.length, used to implement List.length without running out of stack space.
Examples:uList.get}(hj/  hFhttps://leanprover-community.github.io/mathlib4_docs/Init/Prelude.htmlh@def List.get {α : Type u} (as : List α) :
Fin as.length → αh
Returns the element at the provided index, counting from 0.
In other words, for i : Fin as.length, as.get i returns the i'th element of the list as. Because the index is a Fin bounded by the list's length, the index will never be out of bounds.
Examples:uList.set}(hj/  hFhttps://leanprover-community.github.io/mathlib4_docs/Init/Prelude.htmlhGdef List.set {α : Type u_1} (l : List α) (n : Nat) (a : α) :
List αh
Replaces the value at (zero-based) index n in l with a. If the index is out of bounds, then the list is returned unmodified.
Examples:u
List.foldl}(hj/  hFhttps://leanprover-community.github.io/mathlib4_docs/Init/Prelude.htmlh^def List.foldl {α : Type u} {β : Type v} (f : α → β → α) (init : α) :
List β → αh
Folds a function over a list from the left, accumulating a value starting with init. The accumulated value is combined with the each element of the list in order, using f.
Examples:uList.concat}(hj/  hFhttps://leanprover-community.github.io/mathlib4_docs/Init/Prelude.htmlh:def List.concat {α : Type u} :
List α → α → List αh
lAdds an element to the end of a list.
The added element is the last element of the resulting list.
Examples:uList.toArray}(hj/  hFhttps://leanprover-community.github.io/mathlib4_docs/Init/Prelude.htmlh=abbrev List.toArray {α : Type u_1} (xs : List α) :
Array αh
Converts a List α into an Array α.
O(|xs|). At runtime, this operation is implemented by List.toArrayImpl and takes time linear in the length of the list. List.toArray should be used instead of Array.mk.
Examples:uList.toAssocList'}(hj0  hMhttps://leanprover-community.github.io/mathlib4_docs/Lean/Data/AssocList.htmlh\def List.toAssocList' {α : Type u} {β : Type v} :
List (α × β) → Lean.AssocList α βh
huList.fromJson?}(hj0  hYhttps://leanprover-community.github.io/mathlib4_docs/Lean/Data/Json/FromToJson/Basic.htmlh_def List.fromJson? {α : Type u_1} [Lean.FromJson α] (j : Lean.Json) :
Except String (List α)h
huList.toJson}(hj0  hYhttps://leanprover-community.github.io/mathlib4_docs/Lean/Data/Json/FromToJson/Basic.htmlhJdef List.toJson {α : Type u_1} [Lean.ToJson α] (a : List α) :
Lean.Jsonh
huList.toSSet}(hj0  hHhttps://leanprover-community.github.io/mathlib4_docs/Lean/Data/SSet.htmlhTdef List.toSSet {α : Type u_1} [BEq α] [Hashable α] (es : List α) :
Lean.SSet αh
huList.toPArray'}(hj0  hShttps://leanprover-community.github.io/mathlib4_docs/Lean/Data/PersistentArray.htmlhIdef List.toPArray' {α : Type u} (xs : List α) :
Lean.PersistentArray αh
&Converts a list to a persistent array.uList.toSMap}(hj0  hHhttps://leanprover-community.github.io/mathlib4_docs/Lean/Data/SMap.htmlhodef List.toSMap {α : Type u_1} {β : Type u_2} [BEq α] [Hashable α] (es : List (α × β)) :
Lean.SMap α βh
huList.nonzeroMinimum}(hj0  hZhttps://leanprover-community.github.io/mathlib4_docs/Lean/Elab/Tactic/Omega/MinNatAbs.htmlh-def List.nonzeroMinimum (xs : List Nat) :
Nath
The minimum non-zero entry in a list of natural numbers, or zero if all entries are zero.
We completely characterize the function via nonzeroMinimum_eq_zero_iff and nonzeroMinimum_eq_nonzero_iff below.uList.nonzeroMinimum_eq_zero_iff}(hj"0  hZhttps://leanprover-community.github.io/mathlib4_docs/Lean/Elab/Tactic/Omega/MinNatAbs.htmlhutheorem List.nonzeroMinimum_eq_zero_iff {xs : List Nat} :
xs.nonzeroMinimum = 0 ↔ ∀ (x : Nat), x ∈ xs → x = 0h
huList.nonzeroMinimum_mem}(hj&0  hZhttps://leanprover-community.github.io/mathlib4_docs/Lean/Elab/Tactic/Omega/MinNatAbs.htmlhhtheorem List.nonzeroMinimum_mem {xs : List Nat} (w : xs.nonzeroMinimum ≠ 0) :
xs.nonzeroMinimum ∈ xsh
huList.nonzeroMinimum_pos}(hj*0  hZhttps://leanprover-community.github.io/mathlib4_docs/Lean/Elab/Tactic/Omega/MinNatAbs.htmlhntheorem List.nonzeroMinimum_pos {a : Nat} {xs : List Nat} (m : a ∈ xs) (h : a ≠ 0) :
0 < xs.nonzeroMinimumh
huList.nonzeroMinimum_le}(hj.0  hZhttps://leanprover-community.github.io/mathlib4_docs/Lean/Elab/Tactic/Omega/MinNatAbs.htmlhotheorem List.nonzeroMinimum_le {a : Nat} {xs : List Nat} (m : a ∈ xs) (h : a ≠ 0) :
xs.nonzeroMinimum ≤ ah
hu"List.nonzeroMinimum_eq_nonzero_iff}(hj20  hZhttps://leanprover-community.github.io/mathlib4_docs/Lean/Elab/Tactic/Omega/MinNatAbs.htmlhtheorem List.nonzeroMinimum_eq_nonzero_iff {xs : List Nat} {y : Nat} (h : y ≠ 0) :
xs.nonzeroMinimum = y ↔ y ∈ xs ∧ ∀ (x : Nat), x ∈ xs → y ≤ x ∨ x = 0h
hu!List.nonzeroMinimum_eq_of_nonzero}(hj60  hZhttps://leanprover-community.github.io/mathlib4_docs/Lean/Elab/Tactic/Omega/MinNatAbs.htmlhtheorem List.nonzeroMinimum_eq_of_nonzero {xs : List Nat} (h : xs.nonzeroMinimum ≠ 0) :
∃ (x : Nat), x ∈ xs ∧ xs.nonzeroMinimum = xh
huList.nonzeroMinimum_le_iff}(hj:0  hZhttps://leanprover-community.github.io/mathlib4_docs/Lean/Elab/Tactic/Omega/MinNatAbs.htmlhtheorem List.nonzeroMinimum_le_iff {xs : List Nat} {y : Nat} :
xs.nonzeroMinimum ≤ y ↔ xs.nonzeroMinimum = 0 ∨ ∃ (x : Nat), x ∈ xs ∧ x ≤ y ∧ x ≠ 0h
hu)List.nonzeroMinimum_map_le_nonzeroMinimum}(hj>0  hZhttps://leanprover-community.github.io/mathlib4_docs/Lean/Elab/Tactic/Omega/MinNatAbs.htmlhXN  theorem List.nonzeroMinimum_map_le_nonzeroMinimum {α : Type u_1} {β : Type u_2} (f : α → β) (p : α → Nat) (q : β → Nat) (xs : List α) (h : ∀ (a : α), a ∈ xs → (p a = 0 ↔ q (f a) = 0)) (w : ∀ (a : α), a ∈ xs → p a ≠ 0 → q (f a) ≤ p a) :
(map q (map f xs)).nonzeroMinimum ≤ (map p xs).nonzeroMinimumh
huList.minNatAbs}(hjB0  hZhttps://leanprover-community.github.io/mathlib4_docs/Lean/Elab/Tactic/Omega/MinNatAbs.htmlh(def List.minNatAbs (xs : List Int) :
Nath
The minimum absolute value of a nonzero entry, or zero if all entries are zero.
We completely characterize the function via minNatAbs_eq_zero_iff and minNatAbs_eq_nonzero_iff below.uList.minNatAbs_eq_zero_iff}(hjG0  hZhttps://leanprover-community.github.io/mathlib4_docs/Lean/Elab/Tactic/Omega/MinNatAbs.htmlhktheorem List.minNatAbs_eq_zero_iff {xs : List Int} :
xs.minNatAbs = 0 ↔ ∀ (y : Int), y ∈ xs → y = 0h
huList.minNatAbs_eq_nonzero_iff}(hjK0  hZhttps://leanprover-community.github.io/mathlib4_docs/Lean/Elab/Tactic/Omega/MinNatAbs.htmlhtheorem List.minNatAbs_eq_nonzero_iff {z : Nat} (xs : List Int) (w : z ≠ 0) :
xs.minNatAbs = z ↔ (∃ (y : Int), y ∈ xs ∧ y.natAbs = z) ∧ ∀ (y : Int), y ∈ xs → z ≤ y.natAbs ∨ y = 0h
huList.minNatAbs_nil}(hjO0  hZhttps://leanprover-community.github.io/mathlib4_docs/Lean/Elab/Tactic/Omega/MinNatAbs.htmlh-theorem List.minNatAbs_nil :
[].minNatAbs = 0h
huList.maxNatAbs}(hjS0  hZhttps://leanprover-community.github.io/mathlib4_docs/Lean/Elab/Tactic/Omega/MinNatAbs.htmlh(def List.maxNatAbs (xs : List Int) :
Nath
1The maximum absolute value in a list of integers.uList.reduceReplicate}(hjX0  hdhttps://leanprover-community.github.io/mathlib4_docs/Lean/Meta/Tactic/Simp/BuiltinSimprocs/List.htmlh2def List.reduceReplicate :
Lean.Meta.Simp.DSimproch
ESimplification procedure for List.replicate applied to a Nat literal.uList.prod_take_ofFn}(hj]0  hZhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Fin.htmlhtheorem List.prod_take_ofFn {M : Type u_2} [CommMonoid M] {n : ℕ} (f : Fin n → M) (i : ℕ) :
(take i (ofFn f)).prod = ∏ j : Fin n with ↑j < i, f jh
huList.sum_take_ofFn}(hja0  hZhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Fin.htmlhtheorem List.sum_take_ofFn {M : Type u_2} [AddCommMonoid M] {n : ℕ} (f : Fin n → M) (i : ℕ) :
(take i (ofFn f)).sum = ∑ j : Fin n with ↑j < i, f jh
huList.prod_ofFn}(hje0  hZhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Fin.htmlhutheorem List.prod_ofFn {M : Type u_2} [CommMonoid M] {n : ℕ} {f : Fin n → M} :
(ofFn f).prod = ∏ i : Fin n, f ih
hu
List.sum_ofFn}(hji0  hZhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Fin.htmlhvtheorem List.sum_ofFn {M : Type u_2} [AddCommMonoid M] {n : ℕ} {f : Fin n → M} :
(ofFn f).sum = ∑ i : Fin n, f ih
hu#List.alternatingProd_eq_finset_prod}(hjm0  hZhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Fin.htmlhtheorem List.alternatingProd_eq_finset_prod {G : Type u_3} [DivisionCommMonoid G] (L : List G) :
L.alternatingProd = ∏ i : Fin L.length, L[i] ^ (-1) ^ ↑ih
hu!List.alternatingSum_eq_finset_sum}(hjq0  hZhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Fin.htmlhtheorem List.alternatingSum_eq_finset_sum {G : Type u_3} [SubtractionCommMonoid G] (L : List G) :
L.alternatingSum = ∑ i : Fin L.length, (-1) ^ ↑i • L[i]h
hu	List.prod}(hju0  hfhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Defs.htmlh@def List.prod {α : Type u_8} [Mul α] [One α] :
List α → αh
:Product of a list.
List.prod [a, b, c] = a * (b * (c * 1))uList.alternatingSum}(hjz0  hfhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Defs.htmlhNdef List.alternatingSum {G : Type u_8} [Zero G] [Add G] [Neg G] :
List G → Gh
The alternating sum of a list.uList.alternatingProd}(hj0  hfhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Defs.htmlhNdef List.alternatingProd {G : Type u_8} [One G] [Mul G] [Inv G] :
List G → Gh
"The alternating product of a list.uu(
List.prod_nil}(hj0  hfhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Defs.htmlhBtheorem List.prod_nil {M : Type u_4} [Mul M] [One M] :
[].prod = 1h
huList.prod_cons}(hj0  hfhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Defs.htmlhgtheorem List.prod_cons {M : Type u_4} [Mul M] [One M] {a : M} {l : List M} :
(a :: l).prod = a * l.prodh
huList.prod_induction}(hj0  hfhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Defs.htmlhtheorem List.prod_induction {M : Type u_4} [Mul M] [One M] {l : List M} (p : M → Prop) (hom : ∀ (a b : M), p a → p b → p (a * b)) (unit : p 1) (base : ∀ (x : M), x ∈ l → p x) :
p l.prodh
huList.sum_induction}(hj0  hfhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Defs.htmlhtheorem List.sum_induction {M : Type u_4} [Add M] [Zero M] {l : List M} (p : M → Prop) (hom : ∀ (a b : M), p a → p b → p (a + b)) (addUnit : p 0) (base : ∀ (x : M), x ∈ l → p x) :
p l.sumh
huList.prod_singleton}(hj0  hfhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Defs.htmlhQtheorem List.prod_singleton {M : Type u_4} [MulOneClass M] {a : M} :
[a].prod = ah
huList.sum_singleton}(hj0  hfhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Defs.htmlhPtheorem List.sum_singleton {M : Type u_4} [AddZeroClass M] {a : M} :
[a].sum = ah
huList.prod_one_cons}(hj0  hfhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Defs.htmlh_theorem List.prod_one_cons {M : Type u_4} [MulOneClass M] {l : List M} :
(1 :: l).prod = l.prodh
huList.sum_zero_cons}(hj0  hfhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Defs.htmlh^theorem List.sum_zero_cons {M : Type u_4} [AddZeroClass M] {l : List M} :
(0 :: l).sum = l.sumh
huList.prod_map_one}(hj0  hfhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Defs.htmlh}theorem List.prod_map_one {ι : Type u_1} {M : Type u_4} [MulOneClass M] {l : List ι} :
(map (fun (x : ι) => 1) l).prod = 1h
huList.sum_map_zero}(hj0  hfhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Defs.htmlh}theorem List.sum_map_zero {ι : Type u_1} {M : Type u_4} [AddZeroClass M] {l : List ι} :
(map (fun (x : ι) => 0) l).sum = 0h
huList.prod_eq_foldr}(hj0  hfhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Defs.htmlhstheorem List.prod_eq_foldr {M : Type u_4} [Monoid M] {l : List M} :
l.prod = foldr (fun (x1 x2 : M) => x1 * x2) 1 lh
huList.sum_eq_foldr}(hj0  hfhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Defs.htmlhttheorem List.sum_eq_foldr {M : Type u_4} [AddMonoid M] {l : List M} :
l.sum = foldr (fun (x1 x2 : M) => x1 + x2) 0 lh
huList.prod_replicate}(hj0  hfhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Defs.htmlhftheorem List.prod_replicate {M : Type u_4} [Monoid M] (n : ℕ) (a : M) :
(replicate n a).prod = a ^ nh
huList.sum_replicate}(hj0  hfhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Defs.htmlhitheorem List.sum_replicate {M : Type u_4} [AddMonoid M] (n : ℕ) (a : M) :
(replicate n a).sum = n • ah
huList.prod_eq_pow_card}(hj0  hfhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Defs.htmlhtheorem List.prod_eq_pow_card {M : Type u_4} [Monoid M] (l : List M) (m : M) (h : ∀ (x : M), x ∈ l → x = m) :
l.prod = m ^ l.lengthh
huList.sum_eq_card_nsmul}(hj0  hfhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Defs.htmlhtheorem List.sum_eq_card_nsmul {M : Type u_4} [AddMonoid M] (l : List M) (m : M) (h : ∀ (x : M), x ∈ l → x = m) :
l.sum = l.length • mh
huList.prod_hom_rel}(hj0  hfhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Defs.htmlhX$  theorem List.prod_hom_rel {ι : Type u_1} {M : Type u_4} {N : Type u_5} [Monoid M] [Monoid N] (l : List ι) {r : M → N → Prop} {f : ι → M} {g : ι → N} (h₁ : r 1 1) (h₂ : ∀ ⦃i : ι⦄ ⦃a : M⦄ ⦃b : N⦄, r a b → r (f i * a) (g i * b)) :
r (map f l).prod (map g l).prodh
huList.sum_hom_rel}(hj0  hfhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Defs.htmlhX'  theorem List.sum_hom_rel {ι : Type u_1} {M : Type u_4} {N : Type u_5} [AddMonoid M] [AddMonoid N] (l : List ι) {r : M → N → Prop} {f : ι → M} {g : ι → N} (h₁ : r 0 0) (h₂ : ∀ ⦃i : ι⦄ ⦃a : M⦄ ⦃b : N⦄, r a b → r (f i + a) (g i + b)) :
r (map f l).sum (map g l).sumh
huList.prod_isUnit}(hj0  hhhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Lemmas.htmlhwtheorem List.prod_isUnit {M : Type u_4} [Monoid M] {L : List M} :
(∀ (m : M), m ∈ L → IsUnit m) → IsUnit L.prodh
huList.sum_isAddUnit}(hj0  hhhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Lemmas.htmlhtheorem List.sum_isAddUnit {M : Type u_4} [AddMonoid M] {L : List M} :
(∀ (m : M), m ∈ L → IsAddUnit m) → IsAddUnit L.sumh
huList.prod_isUnit_iff}(hj0  hhhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Lemmas.htmlh}theorem List.prod_isUnit_iff {M : Type u_8} [CommMonoid M] {L : List M} :
IsUnit L.prod ↔ ∀ (m : M), m ∈ L → IsUnit mh
huList.sum_isAddUnit_iff}(hj0  hhhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Lemmas.htmlhtheorem List.sum_isAddUnit_iff {M : Type u_8} [AddCommMonoid M] {L : List M} :
IsAddUnit L.sum ↔ ∀ (m : M), m ∈ L → IsAddUnit mh
hu&List.prod_rotate_eq_one_of_prod_eq_one}(hj0  hhhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Lemmas.htmlhtheorem List.prod_rotate_eq_one_of_prod_eq_one {G : Type u_7} [Group G] {l : List G} :
l.prod = 1 → ∀ (n : ℕ), (l.rotate n).prod = 1h
hu)List.sum_map_count_dedup_filter_eq_countP}(hj0  hhhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Lemmas.htmlhtheorem List.sum_map_count_dedup_filter_eq_countP {α : Type u_2} [DecidableEq α] (p : α → Bool) (l : List α) :
(map (fun (x : α) => count x l) (filter p l.dedup)).sum = countP p lh
QSumming the count of x over a list filtered by some p is just countP applied to pu"List.sum_map_count_dedup_eq_length}(hj0  hhhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Lemmas.htmlhtheorem List.sum_map_count_dedup_eq_length {α : Type u_2} [DecidableEq α] (l : List α) :
(map (fun (x : α) => count x l) l.dedup).sum = l.lengthh
huList.length_sigma}(hj0  hhhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Lemmas.htmlhtheorem List.length_sigma {α : Type u_2} {σ : α → Type u_8} (l₁ : List α) (l₂ : (a : α) → List (σ a)) :
(l₁.sigma l₂).length = (map (fun (a : α) => (l₂ a).length) l₁).sumh
huList.ranges_flatten}(hj0  hhhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Lemmas.htmlhKtheorem List.ranges_flatten (l : List ℕ) :
l.ranges.flatten = range l.sumh
huList.ranges_nodup}(hj0  hhhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Lemmas.htmlhJtheorem List.ranges_nodup {l s : List ℕ} (hs : s ∈ l.ranges) :
s.Noduph
*The members of l.ranges have no duplicatesuList.mem_mem_ranges_iff_lt_sum}(hj0  hhhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Lemmas.htmlhtheorem List.mem_mem_ranges_iff_lt_sum (l : List ℕ) {n : ℕ} :
(∃ (s : List ℕ), s ∈ l.ranges ∧ n ∈ s) ↔ n < l.sumh
CAny entry of any member of l.ranges is strictly smaller than l.sum.u&List.drop_take_succ_flatten_eq_getElem}(hj0  hhhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Lemmas.htmlhtheorem List.drop_take_succ_flatten_eq_getElem {α : Type u_2} (L : List (List α)) (i : ℕ) (h : i < L.length) :
drop (take i (map length L)).sum (take (take (i + 1) (map length L)).sum L.flatten) = L[i]h
In a flatten of sublists, taking the slice between the indices A and B - 1 gives back the original sublist of index i if A is the sum of the lengths of sublists of index < i, and B is the sum of the lengths of sublists of index ≤ i.u#List.neg_one_mem_of_prod_eq_neg_one}(hj 1  hhhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Lemmas.htmlhWtheorem List.neg_one_mem_of_prod_eq_neg_one {l : List ℤ} (h : l.prod = -1) :
-1 ∈ lh
DIf a product of integers is -1, then at least one factor must be -1.u
List.dvd_prod}(hj1  hhhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Lemmas.htmlhftheorem List.dvd_prod {M : Type u_4} [CommMonoid M] {a : M} {l : List M} (ha : a ∈ l) :
a ∣ l.prodh
huList.alternatingProd_append}(hj	1  hhhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Lemmas.htmlhtheorem List.alternatingProd_append {G : Type u_7} [CommGroup G] (l₁ l₂ : List G) :
(l₁ ++ l₂).alternatingProd = l₁.alternatingProd * l₂.alternatingProd ^ (-1) ^ l₁.lengthh
huList.alternatingSum_append}(hj
1  hhhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Lemmas.htmlhtheorem List.alternatingSum_append {G : Type u_7} [AddCommGroup G] (l₁ l₂ : List G) :
(l₁ ++ l₂).alternatingSum = l₁.alternatingSum + (-1) ^ l₁.length • l₂.alternatingSumh
huList.alternatingProd_reverse}(hj1  hhhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Lemmas.htmlhtheorem List.alternatingProd_reverse {G : Type u_7} [CommGroup G] (l : List G) :
l.reverse.alternatingProd = l.alternatingProd ^ (-1) ^ (l.length + 1)h
huList.alternatingSum_reverse}(hj1  hhhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Lemmas.htmlhtheorem List.alternatingSum_reverse {G : Type u_7} [AddCommGroup G] (l : List G) :
l.reverse.alternatingSum = (-1) ^ (l.length + 1) • l.alternatingSumh
hu
List.smul_sum}(hj1  hkhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/GroupWithZero/Action.htmlhtheorem List.smul_sum {M : Type u_1} {N : Type u_2} [AddMonoid N] [DistribSMul M N] {r : M} {l : List N} :
r • l.sum = (map (fun (x : N) => r • x) l).sumh
huList.smul_prod'}(hj1  hkhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/GroupWithZero/Action.htmlhtheorem List.smul_prod' {M : Type u_1} {N : Type u_2} [Monoid M] [Monoid N] [MulDistribMulAction M N] {r : M} {l : List N} :
r • l.prod = (map (fun (x : N) => r • x) l).prodh
huList.smul_prod}(hj!1  hkhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/GroupWithZero/Action.htmlhtheorem List.smul_prod {M : Type u_1} {N : Type u_2} [Monoid M] [MulOneClass N] [MulAction M N] [IsScalarTower M N N] [SMulCommClass M N N] (l : List N) (m : M) :
m ^ l.length • l.prod = (map (fun (x : N) => m • x) l).prodh
hu
List.vadd_sum}(hj%1  hkhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/GroupWithZero/Action.htmlhtheorem List.vadd_sum {M : Type u_1} {N : Type u_2} [AddMonoid M] [AddZeroClass N] [AddAction M N] [VAddAssocClass M N N] [VAddCommClass M N N] (l : List N) (m : M) :
l.length • m +ᵥ l.sum = (map (fun (x : N) => m +ᵥ x) l).sumh
huList.prod_map_neg}(hj)1  h`https://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Ring/List.htmlhtheorem List.prod_map_neg {M : Type u_3} [Monoid M] [HasDistribNeg M] (l : List M) :
(map Neg.neg l).prod = (-1) ^ l.length * l.prodh
huList.prod_eq_zero}(hj-1  h`https://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Ring/List.htmlhjtheorem List.prod_eq_zero {M₀ : Type u_4} [MonoidWithZero M₀] {l : List M₀} :
0 ∈ l → l.prod = 0h
If zero is an element of a list l, then List.prod l = 0. If the domain is a nontrivial monoid with zero with no zero divisors, then this implication becomes an iff, see List.prod_eq_zero_iff.uList.prod_eq_zero_iff}(hj21  h`https://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Ring/List.htmlhtheorem List.prod_eq_zero_iff {M₀ : Type u_4} [MonoidWithZero M₀] [Nontrivial M₀] [NoZeroDivisors M₀] {l : List M₀} :
l.prod = 0 ↔ 0 ∈ lh
Product of elements of a list l equals zero if and only if 0 ∈ l. See also List.prod_eq_zero for an implication that needs weaker typeclass assumptions.uList.prod_ne_zero}(hj71  h`https://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Ring/List.htmlhtheorem List.prod_ne_zero {M₀ : Type u_4} [MonoidWithZero M₀] {l : List M₀} [Nontrivial M₀] [NoZeroDivisors M₀] (hL : ¬0 ∈ l) :
l.prod ≠ 0h
huList.sum_map_mul_left}(hj;1  h`https://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Ring/List.htmlhtheorem List.sum_map_mul_left {ι : Type u_1} {R : Type u_5} [NonUnitalNonAssocSemiring R] (l : List ι) (f : ι → R) (r : R) :
(map (fun (b : ι) => r * f b) l).sum = r * (map f l).sumh
huList.sum_map_mul_right}(hj?1  h`https://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Ring/List.htmlhtheorem List.sum_map_mul_right {ι : Type u_1} {R : Type u_5} [NonUnitalNonAssocSemiring R] (l : List ι) (f : ι → R) (r : R) :
(map (fun (b : ι) => f b * r) l).sum = (map f l).sum * rh
huList.dvd_sum}(hjC1  h`https://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Ring/List.htmlhtheorem List.dvd_sum {R : Type u_5} [NonUnitalSemiring R] {a : R} {l : List R} (h : ∀ (x : R), x ∈ l → a ∣ x) :
a ∣ l.sumh
huList.sum_zipWith_distrib_left}(hjG1  h`https://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Ring/List.htmlhX  theorem List.sum_zipWith_distrib_left {ι : Type u_1} {κ : Type u_2} {R : Type u_5} [NonUnitalNonAssocSemiring R] (f : ι → κ → R) (a : R) (l₁ : List ι) (l₂ : List κ) :
(zipWith (fun (i : ι) (j : κ) => a * f i j) l₁ l₂).sum = a * (zipWith f l₁ l₂).sumh
huList.prod_eq_foldl}(hjK1  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Basic.htmlhstheorem List.prod_eq_foldl {M : Type u_4} [Monoid M] {l : List M} :
l.prod = foldl (fun (x1 x2 : M) => x1 * x2) 1 lh
huList.sum_eq_foldl}(hjO1  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Basic.htmlhttheorem List.sum_eq_foldl {M : Type u_4} [AddMonoid M] {l : List M} :
l.sum = foldl (fun (x1 x2 : M) => x1 + x2) 0 lh
huList.prod_append}(hjS1  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Basic.htmlhutheorem List.prod_append {M : Type u_4} [Monoid M] {l₁ l₂ : List M} :
(l₁ ++ l₂).prod = l₁.prod * l₂.prodh
huList.sum_append}(hjW1  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Basic.htmlhttheorem List.sum_append {M : Type u_4} [AddMonoid M] {l₁ l₂ : List M} :
(l₁ ++ l₂).sum = l₁.sum + l₂.sumh
huList.prod_concat}(hj[1  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Basic.htmlhhtheorem List.prod_concat {M : Type u_4} [Monoid M] {l : List M} {a : M} :
(l.concat a).prod = l.prod * ah
huList.sum_concat}(hj_1  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Basic.htmlhhtheorem List.sum_concat {M : Type u_4} [AddMonoid M] {l : List M} {a : M} :
(l.concat a).sum = l.sum + ah
huList.prod_flatten}(hjc1  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Basic.htmlhltheorem List.prod_flatten {M : Type u_4} [Monoid M] {l : List (List M)} :
l.flatten.prod = (map prod l).prodh
huList.sum_flatten}(hjg1  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Basic.htmlhktheorem List.sum_flatten {M : Type u_4} [AddMonoid M] {l : List (List M)} :
l.flatten.sum = (map sum l).sumh
hu
List.rel_prod}(hjk1  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Basic.htmlhtheorem List.rel_prod {M : Type u_4} {N : Type u_5} [Monoid M] [Monoid N] {R : M → N → Prop} (h : R 1 1) (hf : Relator.LiftFun R (Relator.LiftFun R R) (fun (x1 x2 : M) => x1 * x2) fun (x1 x2 : N) => x1 * x2) :
Relator.LiftFun (Forall₂ R) R prod prodh
huList.rel_sum}(hjo1  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Basic.htmlhX  theorem List.rel_sum {M : Type u_4} {N : Type u_5} [AddMonoid M] [AddMonoid N] {R : M → N → Prop} (h : R 0 0) (hf : Relator.LiftFun R (Relator.LiftFun R R) (fun (x1 x2 : M) => x1 + x2) fun (x1 x2 : N) => x1 + x2) :
Relator.LiftFun (Forall₂ R) R sum sumh
huList.prod_hom_nonempty}(hjs1  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Basic.htmlhtheorem List.prod_hom_nonempty {M : Type u_4} {N : Type u_5} [Monoid M] [Monoid N] {l : List M} {F : Type u_8} [FunLike F M N] [MulHomClass F M N] (f : F) (hl : l ≠ []) :
(map (⇑f) l).prod = f l.prodh
huList.sum_hom_nonempty}(hjw1  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Basic.htmlhtheorem List.sum_hom_nonempty {M : Type u_4} {N : Type u_5} [AddMonoid M] [AddMonoid N] {l : List M} {F : Type u_8} [FunLike F M N] [AddHomClass F M N] (f : F) (hl : l ≠ []) :
(map (⇑f) l).sum = f l.sumh
hu
List.prod_hom}(hj{1  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Basic.htmlhtheorem List.prod_hom {M : Type u_4} {N : Type u_5} [Monoid M] [Monoid N] (l : List M) {F : Type u_8} [FunLike F M N] [MonoidHomClass F M N] (f : F) :
(map (⇑f) l).prod = f l.prodh
huList.sum_hom}(hj1  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Basic.htmlhtheorem List.sum_hom {M : Type u_4} {N : Type u_5} [AddMonoid M] [AddMonoid N] (l : List M) {F : Type u_8} [FunLike F M N] [AddMonoidHomClass F M N] (f : F) :
(map (⇑f) l).sum = f l.sumh
huList.prod_hom₂_nonempty}(hj1  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Basic.htmlhXt  theorem List.prod_hom₂_nonempty {ι : Type u_1} {M : Type u_4} {N : Type u_5} {P : Type u_6} [Monoid M] [Monoid N] [Monoid P] {l : List ι} (f : M → N → P) (hf : ∀ (a b : M) (c d : N), f (a * b) (c * d) = f a c * f b d) (f₁ : ι → M) (f₂ : ι → N) (hl : l ≠ []) :
(map (fun (i : ι) => f (f₁ i) (f₂ i)) l).prod = f (map f₁ l).prod (map f₂ l).prodh
huList.sum_hom₂_nonempty}(hj1  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Basic.htmlhXy  theorem List.sum_hom₂_nonempty {ι : Type u_1} {M : Type u_4} {N : Type u_5} {P : Type u_6} [AddMonoid M] [AddMonoid N] [AddMonoid P] {l : List ι} (f : M → N → P) (hf : ∀ (a b : M) (c d : N), f (a + b) (c + d) = f a c + f b d) (f₁ : ι → M) (f₂ : ι → N) (hl : l ≠ []) :
(map (fun (i : ι) => f (f₁ i) (f₂ i)) l).sum = f (map f₁ l).sum (map f₂ l).sumh
huList.prod_hom₂}(hj1  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Basic.htmlhXm  theorem List.prod_hom₂ {ι : Type u_1} {M : Type u_4} {N : Type u_5} {P : Type u_6} [Monoid M] [Monoid N] [Monoid P] (l : List ι) (f : M → N → P) (hf : ∀ (a b : M) (c d : N), f (a * b) (c * d) = f a c * f b d) (hf' : f 1 1 = 1) (f₁ : ι → M) (f₂ : ι → N) :
(map (fun (i : ι) => f (f₁ i) (f₂ i)) l).prod = f (map f₁ l).prod (map f₂ l).prodh
huList.sum_hom₂}(hj1  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Basic.htmlhXr  theorem List.sum_hom₂ {ι : Type u_1} {M : Type u_4} {N : Type u_5} {P : Type u_6} [AddMonoid M] [AddMonoid N] [AddMonoid P] (l : List ι) (f : M → N → P) (hf : ∀ (a b : M) (c d : N), f (a + b) (c + d) = f a c + f b d) (hf' : f 0 0 = 0) (f₁ : ι → M) (f₂ : ι → N) :
(map (fun (i : ι) => f (f₁ i) (f₂ i)) l).sum = f (map f₁ l).sum (map f₂ l).sumh
huList.prod_map_mul}(hj1  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Basic.htmlhtheorem List.prod_map_mul {ι : Type u_1} {M : Type u_8} [CommMonoid M] {l : List ι} {f g : ι → M} :
(map (fun (i : ι) => f i * g i) l).prod = (map f l).prod * (map g l).prodh
huList.sum_map_add}(hj1  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Basic.htmlhtheorem List.sum_map_add {ι : Type u_1} {M : Type u_8} [AddCommMonoid M] {l : List ι} {f g : ι → M} :
(map (fun (i : ι) => f i + g i) l).sum = (map f l).sum + (map g l).sumh
huList.prod_map_hom}(hj1  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Basic.htmlhtheorem List.prod_map_hom {ι : Type u_1} {M : Type u_4} {N : Type u_5} [Monoid M] [Monoid N] (L : List ι) (f : ι → M) {G : Type u_8} [FunLike G M N] [MonoidHomClass G M N] (g : G) :
(map (⇑g ∘ f) L).prod = g (map f L).prodh
huList.sum_map_hom}(hj1  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Basic.htmlhtheorem List.sum_map_hom {ι : Type u_1} {M : Type u_4} {N : Type u_5} [AddMonoid M] [AddMonoid N] (L : List ι) (f : ι → M) {G : Type u_8} [FunLike G M N] [AddMonoidHomClass G M N] (g : G) :
(map (⇑g ∘ f) L).sum = g (map f L).sumh
huList.prod_take_mul_prod_drop}(hj1  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Basic.htmlhtheorem List.prod_take_mul_prod_drop {M : Type u_4} [Monoid M] (L : List M) (i : ℕ) :
(take i L).prod * (drop i L).prod = L.prodh
huList.sum_take_add_sum_drop}(hj1  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Basic.htmlhtheorem List.sum_take_add_sum_drop {M : Type u_4} [AddMonoid M] (L : List M) (i : ℕ) :
(take i L).sum + (drop i L).sum = L.sumh
huList.prod_take_succ}(hj1  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Basic.htmlhtheorem List.prod_take_succ {M : Type u_4} [Monoid M] (L : List M) (i : ℕ) (p : i < L.length) :
(take (i + 1) L).prod = (take i L).prod * L[i]h
huList.sum_take_succ}(hj1  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Basic.htmlhtheorem List.sum_take_succ {M : Type u_4} [AddMonoid M] (L : List M) (i : ℕ) (p : i < L.length) :
(take (i + 1) L).sum = (take i L).sum + L[i]h
huList.length_pos_of_prod_ne_one}(hj1  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Basic.htmlhotheorem List.length_pos_of_prod_ne_one {M : Type u_4} [Monoid M] (L : List M) (h : L.prod ≠ 1) :
0 < L.lengthh
6A list with product not one must have positive length.uList.length_pos_of_sum_ne_zero}(hj1  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Basic.htmlhqtheorem List.length_pos_of_sum_ne_zero {M : Type u_4} [AddMonoid M] (L : List M) (h : L.sum ≠ 0) :
0 < L.lengthh
3A list with sum not zero must have positive length.uList.length_pos_of_one_lt_prod}(hj1  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Basic.htmlhztheorem List.length_pos_of_one_lt_prod {M : Type u_4} [Monoid M] [Preorder M] (L : List M) (h : 1 < L.prod) :
0 < L.lengthh
?A list with product greater than one must have positive length.uList.length_pos_of_sum_pos}(hj1  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Basic.htmlhxtheorem List.length_pos_of_sum_pos {M : Type u_4} [AddMonoid M] [Preorder M] (L : List M) (h : 0 < L.sum) :
0 < L.lengthh
3A list with positive sum must have positive length.uList.length_pos_of_prod_lt_one}(hj1  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Basic.htmlhztheorem List.length_pos_of_prod_lt_one {M : Type u_4} [Monoid M] [Preorder M] (L : List M) (h : L.prod < 1) :
0 < L.lengthh
<A list with product less than one must have positive length.uList.length_pos_of_sum_neg}(hj1  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Basic.htmlhxtheorem List.length_pos_of_sum_neg {M : Type u_4} [AddMonoid M] [Preorder M] (L : List M) (h : L.sum < 0) :
0 < L.lengthh
3A list with negative sum must have positive length.u
List.prod_set}(hj1  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Basic.htmlhtheorem List.prod_set {M : Type u_4} [Monoid M] (L : List M) (n : ℕ) (a : M) :
(L.set n a).prod = ((take n L).prod * if n < L.length then a else 1) * (drop (n + 1) L).prodh
huList.sum_set}(hj1  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Basic.htmlhtheorem List.sum_set {M : Type u_4} [AddMonoid M] (L : List M) (n : ℕ) (a : M) :
(L.set n a).sum = ((take n L).sum + if n < L.length then a else 0) + (drop (n + 1) L).sumh
hu List.getElem?_zero_mul_tail_prod}(hj1  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Basic.htmlhutheorem List.getElem?_zero_mul_tail_prod {M : Type u_4} [Monoid M] (l : List M) :
l[0]?.getD 1 * l.tail.prod = l.prodh
We'd like to state this as L.headI * L.tail.prod = L.prod, but because L.headI relies on an inhabited instance to return a garbage value on the empty list, this is not possible. Instead, we write the statement in terms of L[0]?.getD 1.uList.getElem?_zero_add_tail_sum}(hj1  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Basic.htmlhutheorem List.getElem?_zero_add_tail_sum {M : Type u_4} [AddMonoid M] (l : List M) :
l[0]?.getD 0 + l.tail.sum = l.sumh
We'd like to state this as L.headI + L.tail.sum = L.sum, but because L.headI relies on an inhabited instance to return a garbage value on the empty list, this is not possible. Instead, we write the statement in terms of L[0]?.getD 0.u"List.headI_mul_tail_prod_of_ne_nil}(hj1  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Basic.htmlhtheorem List.headI_mul_tail_prod_of_ne_nil {M : Type u_4} [Monoid M] [Inhabited M] (l : List M) (h : l ≠ []) :
l.headI * l.tail.prod = l.prodh
wSame as get?_zero_mul_tail_prod, but avoiding the List.headI garbage complication by requiring the list to be nonempty.u!List.headI_add_tail_sum_of_ne_nil}(hj1  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Basic.htmlhtheorem List.headI_add_tail_sum_of_ne_nil {M : Type u_4} [AddMonoid M] [Inhabited M] (l : List M) (h : l ≠ []) :
l.headI + l.tail.sum = l.sumh
vSame as get?_zero_add_tail_sum, but avoiding the List.headI garbage complication by requiring the list to be nonempty.uList.prod_range_succ}(hj1  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Basic.htmlhtheorem List.prod_range_succ {M : Type u_4} [Monoid M] (f : ℕ → M) (n : ℕ) :
(map f (range n.succ)).prod = (map f (range n)).prod * f nh
huList.sum_range_succ}(hj1  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Basic.htmlhtheorem List.sum_range_succ {M : Type u_4} [AddMonoid M] (f : ℕ → M) (n : ℕ) :
(map f (range n.succ)).sum = (map f (range n)).sum + f nh
huList.prod_range_succ'}(hj1  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Basic.htmlhtheorem List.prod_range_succ' {M : Type u_4} [Monoid M] (f : ℕ → M) (n : ℕ) :
(map f (range n.succ)).prod = f 0 * (map (fun (i : ℕ) => f i.succ) (range n)).prodh
`A variant of prod_range_succ which pulls off the first term in the product rather than the last.uList.sum_range_succ'}(hj1  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Basic.htmlhtheorem List.sum_range_succ' {M : Type u_4} [AddMonoid M] (f : ℕ → M) (n : ℕ) :
(map f (range n.succ)).sum = f 0 + (map (fun (i : ℕ) => f i.succ) (range n)).sumh
[A variant of sum_range_succ which pulls off the first term in the sum rather than the last.uList.prod_eq_one}(hj1  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Basic.htmlhrtheorem List.prod_eq_one {M : Type u_4} [Monoid M] {l : List M} (hl : ∀ (x : M), x ∈ l → x = 1) :
l.prod = 1h
huList.sum_eq_zero}(hj2  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Basic.htmlhttheorem List.sum_eq_zero {M : Type u_4} [AddMonoid M] {l : List M} (hl : ∀ (x : M), x ∈ l → x = 0) :
l.sum = 0h
hu%List.exists_mem_ne_one_of_prod_ne_one}(hj2  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Basic.htmlhtheorem List.exists_mem_ne_one_of_prod_ne_one {M : Type u_4} [Monoid M] {l : List M} (h : l.prod ≠ 1) :
∃ (x : M), x ∈ l ∧ x ≠ 1h
hu&List.exists_mem_ne_zero_of_sum_ne_zero}(hj2  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Basic.htmlhtheorem List.exists_mem_ne_zero_of_sum_ne_zero {M : Type u_4} [AddMonoid M] {l : List M} (h : l.sum ≠ 0) :
∃ (x : M), x ∈ l ∧ x ≠ 0h
huList.prod_erase_of_comm}(hj2  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Basic.htmlhtheorem List.prod_erase_of_comm {M : Type u_4} [Monoid M] {l : List M} {a : M} [DecidableEq M] (ha : a ∈ l) (comm : ∀ (x : M), x ∈ l → ∀ (y : M), y ∈ l → x * y = y * x) :
a * (l.erase a).prod = l.prodh
huList.sum_erase_of_comm}(hj2  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Basic.htmlhtheorem List.sum_erase_of_comm {M : Type u_4} [AddMonoid M] {l : List M} {a : M} [DecidableEq M] (ha : a ∈ l) (comm : ∀ (x : M), x ∈ l → ∀ (y : M), y ∈ l → x + y = y + x) :
a + (l.erase a).sum = l.sumh
huList.prod_map_eq_pow_single}(hj2  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Basic.htmlhtheorem List.prod_map_eq_pow_single {α : Type u_2} {M : Type u_4} [Monoid M] [DecidableEq α] {l : List α} (a : α) (f : α → M) (hf : ∀ (a' : α), a' ≠ a → a' ∈ l → f a' = 1) :
(map f l).prod = f a ^ count a lh
huList.sum_map_eq_nsmul_single}(hj2  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Basic.htmlhtheorem List.sum_map_eq_nsmul_single {α : Type u_2} {M : Type u_4} [AddMonoid M] [DecidableEq α] {l : List α} (a : α) (f : α → M) (hf : ∀ (a' : α), a' ≠ a → a' ∈ l → f a' = 0) :
(map f l).sum = count a l • f ah
huList.prod_eq_pow_single}(hj2  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Basic.htmlhtheorem List.prod_eq_pow_single {M : Type u_4} [Monoid M] {l : List M} [DecidableEq M] (a : M) (h : ∀ (a' : M), a' ≠ a → a' ∈ l → a' = 1) :
l.prod = a ^ count a lh
huList.sum_eq_nsmul_single}(hj#2  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Basic.htmlhtheorem List.sum_eq_nsmul_single {M : Type u_4} [AddMonoid M] {l : List M} [DecidableEq M] (a : M) (h : ∀ (a' : M), a' ≠ a → a' ∈ l → a' = 0) :
l.sum = count a l • ah
huList.prod_erase}(hj'2  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Basic.htmlhtheorem List.prod_erase {M : Type u_4} [CommMonoid M] {a : M} {l : List M} [DecidableEq M] (ha : a ∈ l) :
a * (l.erase a).prod = l.prodh
huList.sum_erase}(hj+2  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Basic.htmlhtheorem List.sum_erase {M : Type u_4} [AddCommMonoid M] {a : M} {l : List M} [DecidableEq M] (ha : a ∈ l) :
a + (l.erase a).sum = l.sumh
huList.prod_map_erase}(hj/2  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Basic.htmlhtheorem List.prod_map_erase {α : Type u_2} {M : Type u_4} [CommMonoid M] [DecidableEq α] (f : α → M) {a : α} {l : List α} :
a ∈ l → f a * (map f (l.erase a)).prod = (map f l).prodh
huList.sum_map_erase}(hj32  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Basic.htmlhtheorem List.sum_map_erase {α : Type u_2} {M : Type u_4} [AddCommMonoid M] [DecidableEq α] (f : α → M) {a : α} {l : List α} :
a ∈ l → f a + (map f (l.erase a)).sum = (map f l).sumh
huList.prod_reverse}(hj72  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Basic.htmlh^theorem List.prod_reverse {M : Type u_4} [CommMonoid M] (l : List M) :
l.reverse.prod = l.prodh
huList.sum_reverse}(hj;2  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Basic.htmlh^theorem List.sum_reverse {M : Type u_4} [AddCommMonoid M] (l : List M) :
l.reverse.sum = l.sumh
hu0List.prod_mul_prod_eq_prod_zipWith_mul_prod_drop}(hj?2  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Basic.htmlhtheorem List.prod_mul_prod_eq_prod_zipWith_mul_prod_drop {M : Type u_4} [CommMonoid M] (l l' : List M) :
l.prod * l'.prod = (zipWith (fun (x1 x2 : M) => x1 * x2) l l').prod * (drop l'.length l).prod * (drop l.length l').prodh
hu,List.sum_add_sum_eq_sum_zipWith_add_sum_drop}(hjC2  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Basic.htmlhtheorem List.sum_add_sum_eq_sum_zipWith_add_sum_drop {M : Type u_4} [AddCommMonoid M] (l l' : List M) :
l.sum + l'.sum = (zipWith (fun (x1 x2 : M) => x1 + x2) l l').sum + (drop l'.length l).sum + (drop l.length l').sumh
hu/List.prod_mul_prod_eq_prod_zipWith_of_length_eq}(hjG2  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Basic.htmlhtheorem List.prod_mul_prod_eq_prod_zipWith_of_length_eq {M : Type u_4} [CommMonoid M] (l l' : List M) (h : l.length = l'.length) :
l.prod * l'.prod = (zipWith (fun (x1 x2 : M) => x1 * x2) l l').prodh
hu,List.sum_add_sum_eq_sum_zipWith_of_length_eq}(hjK2  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Basic.htmlhtheorem List.sum_add_sum_eq_sum_zipWith_of_length_eq {M : Type u_4} [AddCommMonoid M] (l l' : List M) (h : l.length = l'.length) :
l.sum + l'.sum = (zipWith (fun (x1 x2 : M) => x1 + x2) l l').sumh
huList.prod_map_ite}(hjO2  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Basic.htmlhX6  theorem List.prod_map_ite {α : Type u_2} {M : Type u_4} [CommMonoid M] (p : α → Prop) [DecidablePred p] (f g : α → M) (l : List α) :
(map (fun (a : α) => if p a then f a else g a) l).prod = (map f (filter (fun (b : α) => decide (p b)) l)).prod * (map g (filter (fun (a : α) => decide ¬p a) l)).prodh
huList.sum_map_ite}(hjS2  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Basic.htmlhX5  theorem List.sum_map_ite {α : Type u_2} {M : Type u_4} [AddCommMonoid M] (p : α → Prop) [DecidablePred p] (f g : α → M) (l : List α) :
(map (fun (a : α) => if p a then f a else g a) l).sum = (map f (filter (fun (b : α) => decide (p b)) l)).sum + (map g (filter (fun (a : α) => decide ¬p a) l)).sumh
hu,List.prod_map_filter_mul_prod_map_filter_not}(hjW2  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Basic.htmlhX&  theorem List.prod_map_filter_mul_prod_map_filter_not {α : Type u_2} {M : Type u_4} [CommMonoid M] (p : α → Prop) [DecidablePred p] (f : α → M) (l : List α) :
(map f (filter (fun (b : α) => decide (p b)) l)).prod * (map f (filter (fun (x : α) => decide ¬p x) l)).prod = (map f l).prodh
hu*List.sum_map_filter_add_sum_map_filter_not}(hj[2  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Basic.htmlhX$  theorem List.sum_map_filter_add_sum_map_filter_not {α : Type u_2} {M : Type u_4} [AddCommMonoid M] (p : α → Prop) [DecidablePred p] (f : α → M) (l : List α) :
(map f (filter (fun (b : α) => decide (p b)) l)).sum + (map f (filter (fun (x : α) => decide ¬p x) l)).sum = (map f l).sumh
huList.eq_of_prod_take_eq}(hj_2  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Basic.htmlhtheorem List.eq_of_prod_take_eq {M : Type u_4} [LeftCancelMonoid M] {L L' : List M} (h : L.length = L'.length) (h' : ∀ (i : ℕ), i ≤ L.length → (take i L).prod = (take i L').prod) :
L = L'h
huList.eq_of_sum_take_eq}(hjc2  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Basic.htmlhtheorem List.eq_of_sum_take_eq {M : Type u_4} [AddLeftCancelMonoid M] {L L' : List M} (h : L.length = L'.length) (h' : ∀ (i : ℕ), i ≤ L.length → (take i L).sum = (take i L').sum) :
L = L'h
huList.prod_inv_reverse}(hjg2  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Basic.htmlhtheorem List.prod_inv_reverse {G : Type u_7} [Group G] (L : List G) :
L.prod⁻¹ = (map (fun (x : G) => x⁻¹) L).reverse.prodh
,This is the List.prod version of mul_inv_revuList.sum_neg_reverse}(hjl2  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Basic.htmlhxtheorem List.sum_neg_reverse {G : Type u_7} [AddGroup G] (L : List G) :
-L.sum = (map (fun (x : G) => -x) L).reverse.sumh
+This is the List.sum version of add_neg_revuList.prod_reverse_noncomm}(hjq2  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Basic.htmlhtheorem List.prod_reverse_noncomm {G : Type u_7} [Group G] (L : List G) :
L.reverse.prod = (map (fun (x : G) => x⁻¹) L).prod⁻¹h
.A non-commutative variant of List.prod_reverseuList.sum_reverse_noncomm}(hjv2  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Basic.htmlh|theorem List.sum_reverse_noncomm {G : Type u_7} [AddGroup G] (L : List G) :
L.reverse.sum = -(map (fun (x : G) => -x) L).sumh
-A non-commutative variant of List.sum_reverseuList.prod_drop_succ}(hj{2  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Basic.htmlhtheorem List.prod_drop_succ {G : Type u_7} [Group G] (L : List G) (i : ℕ) (p : i < L.length) :
(drop (i + 1) L).prod = L[i]⁻¹ * (drop i L).prodh
DCounterpart to List.prod_take_succ when we have an inverse operationuList.sum_drop_succ}(hj2  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Basic.html1      htheorem List.sum_drop_succ {G : Type u_7} [AddGroup G] (L : List G) (i : ℕ) (p : i < L.length) :
(drop (i + 1) L).sum = -L[i] + (drop i L).sumh
CCounterpart to List.sum_take_succ when we have a negation operationuList.prod_range_div'}(hj2  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Basic.htmlhtheorem List.prod_range_div' {G : Type u_7} [Group G] (n : ℕ) (f : ℕ → G) :
(map (fun (k : ℕ) => f k / f (k + 1)) (range n)).prod = f 0 / f nh
&Cancellation of a telescoping product.uList.sum_range_sub'}(hj2  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Basic.htmlhtheorem List.sum_range_sub' {G : Type u_7} [AddGroup G] (n : ℕ) (f : ℕ → G) :
(map (fun (k : ℕ) => f k - f (k + 1)) (range n)).sum = f 0 - f nh
"Cancellation of a telescoping sum.u
List.prod_inv}(hj2  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Basic.htmlh}theorem List.prod_inv {K : Type u_8} [DivisionCommMonoid K] (L : List K) :
L.prod⁻¹ = (map (fun (x : K) => x⁻¹) L).prodh
(This is the List.prod version of mul_invuList.sum_neg}(hj2  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Basic.htmlhutheorem List.sum_neg {K : Type u_8} [SubtractionCommMonoid K] (L : List K) :
-L.sum = (map (fun (x : K) => -x) L).sumh
'This is the List.sum version of add_neguList.prod_range_div}(hj2  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Basic.htmlhtheorem List.prod_range_div {G : Type u_7} [CommGroup G] (n : ℕ) (f : ℕ → G) :
(map (fun (k : ℕ) => f (k + 1) / f k) (range n)).prod = f n / f 0h
&Cancellation of a telescoping product.uList.sum_range_sub}(hj2  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Basic.htmlhtheorem List.sum_range_sub {G : Type u_7} [AddCommGroup G] (n : ℕ) (f : ℕ → G) :
(map (fun (k : ℕ) => f (k + 1) - f k) (range n)).sum = f n - f 0h
"Cancellation of a telescoping sum.uList.prod_set'}(hj2  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Basic.htmlhtheorem List.prod_set' {G : Type u_7} [CommGroup G] (L : List G) (n : ℕ) (a : G) :
(L.set n a).prod = L.prod * if hn : n < L.length then L[n]⁻¹ * a else 1h
BAlternative version of List.prod_set when the list is over a groupu
List.sum_set'}(hj2  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Basic.htmlhtheorem List.sum_set' {G : Type u_7} [AddCommGroup G] (L : List G) (n : ℕ) (a : G) :
(L.set n a).sum = L.sum + if hn : n < L.length then -L[n] + a else 0h
AAlternative version of List.sum_set when the list is over a groupuList.prod_map_ite_eq}(hj2  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Basic.htmlhtheorem List.prod_map_ite_eq {G : Type u_7} [CommGroup G] {A : Type u_8} [DecidableEq A] (l : List A) (f g : A → G) (a : A) :
(map (fun (x : A) => if x = a then f x else g x) l).prod = (f a / g a) ^ count a l * (map g l).prodh
huList.sum_map_ite_eq}(hj2  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Basic.htmlhtheorem List.sum_map_ite_eq {G : Type u_7} [AddCommGroup G] {A : Type u_8} [DecidableEq A] (l : List A) (f g : A → G) (a : A) :
(map (fun (x : A) => if x = a then f x else g x) l).sum = count a l • (f a - g a) + (map g l).sumh
huList.sum_const_nat}(hj2  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Basic.htmlhDtheorem List.sum_const_nat (m n : ℕ) :
(replicate m n).sum = m * nh
huList.headI_add_tail_sum}(hj2  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Basic.htmlhMtheorem List.headI_add_tail_sum (L : List ℕ) :
L.headI + L.tail.sum = L.sumh
This relies on default ℕ = 0.uList.headI_le_sum}(hj2  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Basic.htmlh<theorem List.headI_le_sum (L : List ℕ) :
L.headI ≤ L.sumh
This relies on default ℕ = 0.u
List.tail_sum}(hj2  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Basic.htmlhCtheorem List.tail_sum (L : List ℕ) :
L.tail.sum = L.sum - L.headIh
This relies on default ℕ = 0.uList.alternatingProd_nil}(hj2  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Basic.htmlh`theorem List.alternatingProd_nil {G : Type u_7} [One G] [Mul G] [Inv G] :
[].alternatingProd = 1h
huList.alternatingSum_nil}(hj2  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Basic.htmlh_theorem List.alternatingSum_nil {G : Type u_7} [Zero G] [Add G] [Neg G] :
[].alternatingSum = 0h
huList.alternatingProd_singleton}(hj2  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Basic.htmlhotheorem List.alternatingProd_singleton {G : Type u_7} [One G] [Mul G] [Inv G] (a : G) :
[a].alternatingProd = ah
huList.alternatingSum_singleton}(hj2  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Basic.htmlhntheorem List.alternatingSum_singleton {G : Type u_7} [Zero G] [Add G] [Neg G] (a : G) :
[a].alternatingSum = ah
huList.alternatingProd_cons_cons'}(hj2  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Basic.htmlhtheorem List.alternatingProd_cons_cons' {G : Type u_7} [One G] [Mul G] [Inv G] (a b : G) (l : List G) :
(a :: b :: l).alternatingProd = a * b⁻¹ * l.alternatingProdh
huList.alternatingSum_cons_cons'}(hj2  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Basic.htmlhtheorem List.alternatingSum_cons_cons' {G : Type u_7} [Zero G] [Add G] [Neg G] (a b : G) (l : List G) :
(a :: b :: l).alternatingSum = a + -b + l.alternatingSumh
huList.alternatingProd_cons_cons}(hj2  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Basic.htmlhtheorem List.alternatingProd_cons_cons {G : Type u_7} [DivInvMonoid G] (a b : G) (l : List G) :
(a :: b :: l).alternatingProd = a / b * l.alternatingProdh
huList.alternatingSum_cons_cons}(hj2  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Basic.htmlhtheorem List.alternatingSum_cons_cons {G : Type u_7} [SubNegMonoid G] (a b : G) (l : List G) :
(a :: b :: l).alternatingSum = a - b + l.alternatingSumh
huList.alternatingProd_cons'}(hj2  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Basic.htmlhtheorem List.alternatingProd_cons' {G : Type u_7} [CommGroup G] (a : G) (l : List G) :
(a :: l).alternatingProd = a * l.alternatingProd⁻¹h
huList.alternatingSum_cons'}(hj2  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Basic.htmlhtheorem List.alternatingSum_cons' {G : Type u_7} [AddCommGroup G] (a : G) (l : List G) :
(a :: l).alternatingSum = a + -l.alternatingSumh
huList.alternatingProd_cons}(hj2  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Basic.htmlhtheorem List.alternatingProd_cons {G : Type u_7} [CommGroup G] (a : G) (l : List G) :
(a :: l).alternatingProd = a / l.alternatingProdh
huList.alternatingSum_cons}(hj2  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Basic.htmlhtheorem List.alternatingSum_cons {G : Type u_7} [AddCommGroup G] (a : G) (l : List G) :
(a :: l).alternatingSum = a - l.alternatingSumh
huList.sum_nat_mod}(hj2  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Basic.htmlhhtheorem List.sum_nat_mod (l : List ℕ) (n : ℕ) :
l.sum % n = (map (fun (x : ℕ) => x % n) l).sum % nh
huList.prod_nat_mod}(hj2  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Basic.htmlhktheorem List.prod_nat_mod (l : List ℕ) (n : ℕ) :
l.prod % n = (map (fun (x : ℕ) => x % n) l).prod % nh
huList.sum_int_mod}(hj 3  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Basic.htmlhhtheorem List.sum_int_mod (l : List ℤ) (n : ℤ) :
l.sum % n = (map (fun (x : ℤ) => x % n) l).sum % nh
huList.prod_int_mod}(hj3  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Basic.htmlhktheorem List.prod_int_mod (l : List ℤ) (n : ℤ) :
l.prod % n = (map (fun (x : ℤ) => x % n) l).prod % nh
huList.prod_zpow}(hj3  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Basic.htmlhtheorem List.prod_zpow {β : Type u_8} [DivisionCommMonoid β] {r : ℤ} {l : List β} :
l.prod ^ r = (map (fun (x : β) => x ^ r) l).prodh
huList.take_sum_flatten}(hj3  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Basic.htmlhtheorem List.take_sum_flatten {α : Type u_2} (L : List (List α)) (i : ℕ) :
take (take i (map length L)).sum L.flatten = (take i L).flattenh
In a flatten, taking the first elements up to an index which is the sum of the lengths of the first i sublists, is the same as taking the flatten of the first i sublists.uList.drop_sum_flatten}(hj3  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Basic.htmlhtheorem List.drop_sum_flatten {α : Type u_2} (L : List (List α)) (i : ℕ) :
drop (take i (map length L)).sum L.flatten = (drop i L).flattenh
In a flatten, dropping all the elements up to an index which is the sum of the lengths of the first i sublists, is the same as taking the join after dropping the first i sublists.uList.length_le_sum_of_one_le}(hj3  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/List/Basic.htmlhqtheorem List.length_le_sum_of_one_le (L : List ℕ) (h : ∀ (i : ℕ), i ∈ L → 1 ≤ i) :
L.length ≤ L.sumh
tIf all elements in a list are bounded below by 1, then the length of the list is bounded by the sum of the elements.uList.prod_toFinset}(hj3  hihttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/Finset/Basic.htmlhtheorem List.prod_toFinset {ι : Type u_1} {M : Type u_5} [DecidableEq ι] [CommMonoid M] (f : ι → M) {l : List ι} (_hl : l.Nodup) :
l.toFinset.prod f = (map f l).prodh
huList.sum_toFinset}(hj3  hihttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/Finset/Basic.htmlhtheorem List.sum_toFinset {ι : Type u_1} {M : Type u_5} [DecidableEq ι] [AddCommMonoid M] (f : ι → M) {l : List ι} (_hl : l.Nodup) :
l.toFinset.sum f = (map f l).sumh
hu!List.sum_toFinset_count_eq_length}(hj#3  hihttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/BigOperators/Group/Finset/Basic.htmlhtheorem List.sum_toFinset_count_eq_length {ι : Type u_1} [DecidableEq ι] (l : List ι) :
∑ a ∈ l.toFinset, count a l = l.lengthh
huList.dProdIndex}(hj'3  hVhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/GradedMonoid.htmlhgdef List.dProdIndex {ι : Type u_1} {α : Type u_2} [AddMonoid ι] (l : List α) (fι : α → ι) :
ιh
The index used by List.dProd. Propositionally this is equal to (l.map fι).Sum, but definitionally it needs to have a different form to avoid introducing Eq.recs in List.dProd.uList.dProdIndex_nil}(hj,3  hVhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/GradedMonoid.htmlhttheorem List.dProdIndex_nil {ι : Type u_1} {α : Type u_2} [AddMonoid ι] (fι : α → ι) :
[].dProdIndex fι = 0h
huList.dProdIndex_cons}(hj03  hVhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/GradedMonoid.htmlhtheorem List.dProdIndex_cons {ι : Type u_1} {α : Type u_2} [AddMonoid ι] (a : α) (l : List α) (fι : α → ι) :
(a :: l).dProdIndex fι = fι a + l.dProdIndex fιh
huList.dProdIndex_eq_map_sum}(hj43  hVhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/GradedMonoid.htmlhtheorem List.dProdIndex_eq_map_sum {ι : Type u_1} {α : Type u_2} [AddMonoid ι] (l : List α) (fι : α → ι) :
l.dProdIndex fι = (map fι l).sumh
hu
List.dProd}(hj83  hVhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/GradedMonoid.htmlhdef List.dProd {ι : Type u_1} {α : Type u_2} {A : ι → Type u_3} [AddMonoid ι] [GradedMonoid.GMonoid A] (l : List α) (fι : α → ι) (fA : (a : α) → A (fι a)) :
A (l.dProdIndex fι)h
A dependent product for graded monoids represented by the indexed family of types A i. This is a dependent version of (l.map fA).prod.
For a list l : List α, this computes the product of fA a over a, where each fA is of type A (fι a).uList.dProd_nil}(hj=3  hVhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/GradedMonoid.htmlhtheorem List.dProd_nil {ι : Type u_1} {α : Type u_2} {A : ι → Type u_3} [AddMonoid ι] [GradedMonoid.GMonoid A] (fι : α → ι) (fA : (a : α) → A (fι a)) :
[].dProd fι fA = GradedMonoid.GOne.oneh
huList.dProd_cons}(hjA3  hVhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/GradedMonoid.htmlhX  theorem List.dProd_cons {ι : Type u_1} {α : Type u_2} {A : ι → Type u_3} [AddMonoid ι] [GradedMonoid.GMonoid A] (fι : α → ι) (fA : (a : α) → A (fι a)) (a : α) (l : List α) :
(a :: l).dProd fι fA = GradedMonoid.GMul.mul (fA a) (l.dProd fι fA)h
huList.dProd_monoid}(hjE3  hVhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/GradedMonoid.htmlhtheorem List.dProd_monoid (ι : Type u_1) {R : Type u_2} {α : Type u_3} [AddMonoid ι] [Monoid R] (l : List α) (fι : α → ι) (fA : α → R) :
l.dProd fι fA = (map fA l).prodh
[When all the indexed types are the same, the dependent product is just the regular product.u
List.sum_smul}(hjJ3  h]https://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/Module/BigOperators.htmlhtheorem List.sum_smul {R : Type u_5} {M : Type u_6} [Semiring R] [AddCommMonoid M] [Module R M] {l : List R} {x : M} :
l.sum • x = (map (fun (r : R) => r • x) l).sumh
huList.prod_nonneg}(hjN3  hohttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/Order/BigOperators/GroupWithZero/List.htmlhtheorem List.prod_nonneg {R : Type u_1} [CommMonoidWithZero R] [PartialOrder R] [ZeroLEOneClass R] [PosMulMono R] {s : List R} (h : ∀ (a : R), a ∈ s → 0 ≤ a) :
0 ≤ s.prodh
huList.one_le_prod}(hjR3  hohttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/Order/BigOperators/GroupWithZero/List.htmlhtheorem List.one_le_prod {R : Type u_1} [CommMonoidWithZero R] [PartialOrder R] [ZeroLEOneClass R] [PosMulMono R] {s : List R} (h : ∀ (a : R), a ∈ s → 1 ≤ a) :
1 ≤ s.prodh
huList.prod_map_le_prod_map₀}(hjV3  hohttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/Order/BigOperators/GroupWithZero/List.htmlhX'  theorem List.prod_map_le_prod_map₀ {R : Type u_1} [CommMonoidWithZero R] [PartialOrder R] [ZeroLEOneClass R] [PosMulMono R] {ι : Type u_2} {s : List ι} (f g : ι → R) (h0 : ∀ (i : ι), i ∈ s → 0 ≤ f i) (h : ∀ (i : ι), i ∈ s → f i ≤ g i) :
(map f s).prod ≤ (map g s).prodh
huList.prod_map_le_pow_length₀}(hjZ3  hohttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/Order/BigOperators/GroupWithZero/List.htmlhXF  theorem List.prod_map_le_pow_length₀ {R : Type u_1} [CommMonoidWithZero R] [PartialOrder R] [ZeroLEOneClass R] [PosMulMono R] {F : Type u_2} {L : Type u_3} [FunLike F L R] {f : F} {r : R} {t : List L} (hf0 : ∀ (x : L), x ∈ t → 0 ≤ f x) (hf : ∀ (x : L), x ∈ t → f x ≤ r) :
(map (⇑f) t).prod ≤ r ^ t.lengthh
hu
List.prod_pos}(hj^3  hohttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/Order/BigOperators/GroupWithZero/List.htmlhtheorem List.prod_pos {R : Type u_1} [CommMonoidWithZero R] [PartialOrder R] [ZeroLEOneClass R] [PosMulStrictMono R] [NeZero 1] {s : List R} (h : ∀ (a : R), a ∈ s → 0 < a) :
0 < s.prodh
huList.prod_map_lt_prod_map}(hjb3  hohttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/Order/BigOperators/GroupWithZero/List.htmlhX?  theorem List.prod_map_lt_prod_map {R : Type u_1} [CommMonoidWithZero R] [PartialOrder R] [ZeroLEOneClass R] [PosMulStrictMono R] [NeZero 1] {ι : Type u_2} {s : List ι} (hs : s ≠ []) (f g : ι → R) (h0 : ∀ (i : ι), i ∈ s → 0 < f i) (h : ∀ (i : ι), i ∈ s → f i < g i) :
(map f s).prod < (map g s).prodh
huList.prod_le_prod'}(hjf3  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/Order/BigOperators/Group/List.htmlhtheorem List.prod_le_prod' {ι : Type u_1} {M : Type u_3} [Monoid M] [Preorder M] [MulRightMono M] [MulLeftMono M] {l : List ι} {f g : ι → M} (h : ∀ (i : ι), i ∈ l → f i ≤ g i) :
(map f l).prod ≤ (map g l).prodh
huList.sum_le_sum}(hjj3  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/Order/BigOperators/Group/List.htmlhtheorem List.sum_le_sum {ι : Type u_1} {M : Type u_3} [AddMonoid M] [Preorder M] [AddRightMono M] [AddLeftMono M] {l : List ι} {f g : ι → M} (h : ∀ (i : ι), i ∈ l → f i ≤ g i) :
(map f l).sum ≤ (map g l).sumh
huList.prod_lt_prod'}(hjn3  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/Order/BigOperators/Group/List.htmlhX<  theorem List.prod_lt_prod' {ι : Type u_1} {M : Type u_3} [Monoid M] [Preorder M] [MulLeftStrictMono M] [MulLeftMono M] [MulRightStrictMono M] [MulRightMono M] {l : List ι} (f g : ι → M) (h₁ : ∀ (i : ι), i ∈ l → f i ≤ g i) (h₂ : ∃ (i : ι), i ∈ l ∧ f i < g i) :
(map f l).prod < (map g l).prodh
huList.sum_lt_sum}(hjr3  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/Order/BigOperators/Group/List.htmlhX:  theorem List.sum_lt_sum {ι : Type u_1} {M : Type u_3} [AddMonoid M] [Preorder M] [AddLeftStrictMono M] [AddLeftMono M] [AddRightStrictMono M] [AddRightMono M] {l : List ι} (f g : ι → M) (h₁ : ∀ (i : ι), i ∈ l → f i ≤ g i) (h₂ : ∃ (i : ι), i ∈ l ∧ f i < g i) :
(map f l).sum < (map g l).sumh
huList.prod_lt_prod_of_ne_nil}(hjv3  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/Order/BigOperators/Group/List.htmlhX%  theorem List.prod_lt_prod_of_ne_nil {ι : Type u_1} {M : Type u_3} [Monoid M] [Preorder M] [MulLeftStrictMono M] [MulLeftMono M] [MulRightStrictMono M] [MulRightMono M] {l : List ι} (hl : l ≠ []) (f g : ι → M) (hlt : ∀ (i : ι), i ∈ l → f i < g i) :
(map f l).prod < (map g l).prodh
huList.sum_lt_sum_of_ne_nil}(hjz3  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/Order/BigOperators/Group/List.htmlhX$  theorem List.sum_lt_sum_of_ne_nil {ι : Type u_1} {M : Type u_3} [AddMonoid M] [Preorder M] [AddLeftStrictMono M] [AddLeftMono M] [AddRightStrictMono M] [AddRightMono M] {l : List ι} (hl : l ≠ []) (f g : ι → M) (hlt : ∀ (i : ι), i ∈ l → f i < g i) :
(map f l).sum < (map g l).sumh
huList.prod_le_pow_card}(hj~3  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/Order/BigOperators/Group/List.htmlhtheorem List.prod_le_pow_card {M : Type u_3} [Monoid M] [Preorder M] [MulRightMono M] [MulLeftMono M] (l : List M) (n : M) (h : ∀ (x : M), x ∈ l → x ≤ n) :
l.prod ≤ n ^ l.lengthh
huList.sum_le_card_nsmul}(hj3  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/Order/BigOperators/Group/List.htmlhtheorem List.sum_le_card_nsmul {M : Type u_3} [AddMonoid M] [Preorder M] [AddRightMono M] [AddLeftMono M] (l : List M) (n : M) (h : ∀ (x : M), x ∈ l → x ≤ n) :
l.sum ≤ l.length • nh
huList.pow_card_le_prod}(hj3  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/Order/BigOperators/Group/List.htmlhtheorem List.pow_card_le_prod {M : Type u_3} [Monoid M] [Preorder M] [MulRightMono M] [MulLeftMono M] (l : List M) (n : M) (h : ∀ (x : M), x ∈ l → n ≤ x) :
n ^ l.length ≤ l.prodh
huList.card_nsmul_le_sum}(hj3  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/Order/BigOperators/Group/List.htmlhtheorem List.card_nsmul_le_sum {M : Type u_3} [AddMonoid M] [Preorder M] [AddRightMono M] [AddLeftMono M] (l : List M) (n : M) (h : ∀ (x : M), x ∈ l → n ≤ x) :
l.length • n ≤ l.sumh
huList.exists_lt_of_prod_lt'}(hj3  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/Order/BigOperators/Group/List.htmlhtheorem List.exists_lt_of_prod_lt' {ι : Type u_1} {M : Type u_3} [Monoid M] [LinearOrder M] [MulRightMono M] [MulLeftMono M] {l : List ι} (f g : ι → M) (h : (map f l).prod < (map g l).prod) :
∃ (i : ι), i ∈ l ∧ f i < g ih
huList.exists_lt_of_sum_lt}(hj3  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/Order/BigOperators/Group/List.htmlhtheorem List.exists_lt_of_sum_lt {ι : Type u_1} {M : Type u_3} [AddMonoid M] [LinearOrder M] [AddRightMono M] [AddLeftMono M] {l : List ι} (f g : ι → M) (h : (map f l).sum < (map g l).sum) :
∃ (i : ι), i ∈ l ∧ f i < g ih
huList.exists_le_of_prod_le'}(hj3  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/Order/BigOperators/Group/List.htmlhX)  theorem List.exists_le_of_prod_le' {ι : Type u_1} {M : Type u_3} [Monoid M] [LinearOrder M] [MulLeftStrictMono M] [MulLeftMono M] [MulRightStrictMono M] [MulRightMono M] {l : List ι} (hl : l ≠ []) (f g : ι → M) (h : (map f l).prod ≤ (map g l).prod) :
∃ (x : ι), x ∈ l ∧ f x ≤ g xh
huList.exists_le_of_sum_le}(hj3  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/Order/BigOperators/Group/List.htmlhX(  theorem List.exists_le_of_sum_le {ι : Type u_1} {M : Type u_3} [AddMonoid M] [LinearOrder M] [AddLeftStrictMono M] [AddLeftMono M] [AddRightStrictMono M] [AddRightMono M] {l : List ι} (hl : l ≠ []) (f g : ι → M) (h : (map f l).sum ≤ (map g l).sum) :
∃ (x : ι), x ∈ l ∧ f x ≤ g xh
huList.one_le_prod_of_one_le}(hj3  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/Order/BigOperators/Group/List.htmlhtheorem List.one_le_prod_of_one_le {M : Type u_3} [Monoid M] [Preorder M] [MulLeftMono M] {l : List M} (hl₁ : ∀ (x : M), x ∈ l → 1 ≤ x) :
1 ≤ l.prodh
huList.sum_nonneg}(hj3  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/Order/BigOperators/Group/List.htmlhtheorem List.sum_nonneg {M : Type u_3} [AddMonoid M] [Preorder M] [AddLeftMono M] {l : List M} (hl₁ : ∀ (x : M), x ∈ l → 0 ≤ x) :
0 ≤ l.sumh
huList.max_prod_le}(hj3  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/Order/BigOperators/Group/List.htmlhtheorem List.max_prod_le {α : Type u_2} {M : Type u_3} [Monoid M] (l : List α) (f g : α → M) [LinearOrder M] [MulLeftMono M] [MulRightMono M] :
max (map f l).prod (map g l).prod ≤ (map (fun (i : α) => max (f i) (g i)) l).prodh
huList.max_sum_le}(hj3  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/Order/BigOperators/Group/List.htmlhtheorem List.max_sum_le {α : Type u_2} {M : Type u_3} [AddMonoid M] (l : List α) (f g : α → M) [LinearOrder M] [AddLeftMono M] [AddRightMono M] :
max (map f l).sum (map g l).sum ≤ (map (fun (i : α) => max (f i) (g i)) l).sumh
huList.prod_min_le}(hj3  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/Order/BigOperators/Group/List.htmlhtheorem List.prod_min_le {α : Type u_2} {M : Type u_3} [Monoid M] [LinearOrder M] [MulLeftMono M] [MulRightMono M] (l : List α) (f g : α → M) :
(map (fun (i : α) => min (f i) (g i)) l).prod ≤ min (map f l).prod (map g l).prodh
huList.sum_min_le}(hj3  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/Order/BigOperators/Group/List.htmlhtheorem List.sum_min_le {α : Type u_2} {M : Type u_3} [AddMonoid M] [LinearOrder M] [AddLeftMono M] [AddRightMono M] (l : List α) (f g : α → M) :
(map (fun (i : α) => min (f i) (g i)) l).sum ≤ min (map f l).sum (map g l).sumh
huList.sum_le_foldr_max}(hj3  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/Order/BigOperators/Group/List.htmlhtheorem List.sum_le_foldr_max {M : Type u_3} {N : Type u_4} [AddZeroClass M] [Zero N] [LinearOrder N] (f : M → N) (h0 : f 0 ≤ 0) (hadd : ∀ (x y : M), f (x + y) ≤ max (f x) (f y)) (l : List M) :
f l.sum ≤ foldr max 0 (map f l)h
huList.one_lt_prod_of_one_lt}(hj3  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/Order/BigOperators/Group/List.htmlhtheorem List.one_lt_prod_of_one_lt {M : Type u_3} [CommMonoid M] [PartialOrder M] [IsOrderedMonoid M] (l : List M) :
(∀ (x : M), x ∈ l → 1 < x) → l ≠ [] → 1 < l.prodh
huList.sum_pos}(hj3  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/Order/BigOperators/Group/List.htmlhtheorem List.sum_pos {M : Type u_3} [AddCommMonoid M] [PartialOrder M] [IsOrderedAddMonoid M] (l : List M) :
(∀ (x : M), x ∈ l → 0 < x) → l ≠ [] → 0 < l.sumh
huList.single_le_prod}(hj3  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/Order/BigOperators/Group/List.htmlhtheorem List.single_le_prod {M : Type u_3} [CommMonoid M] [PartialOrder M] [IsOrderedMonoid M] {l : List M} (hl₁ : ∀ (x : M), x ∈ l → 1 ≤ x) (x : M) :
x ∈ l → x ≤ l.prodh
See also List.le_prod_of_mem.uList.single_le_sum}(hj3  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/Order/BigOperators/Group/List.htmlhtheorem List.single_le_sum {M : Type u_3} [AddCommMonoid M] [PartialOrder M] [IsOrderedAddMonoid M] {l : List M} (hl₁ : ∀ (x : M), x ∈ l → 0 ≤ x) (x : M) :
x ∈ l → x ≤ l.sumh
See also List.le_sum_of_mem.u(List.all_one_of_le_one_le_of_prod_eq_one}(hj3  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/Order/BigOperators/Group/List.htmlhtheorem List.all_one_of_le_one_le_of_prod_eq_one {M : Type u_3} [CommMonoid M] [PartialOrder M] [IsOrderedMonoid M] {l : List M} (hl₁ : ∀ (x : M), x ∈ l → 1 ≤ x) (hl₂ : l.prod = 1) {x : M} (hx : x ∈ l) :
x = 1h
hu*List.all_zero_of_le_zero_le_of_sum_eq_zero}(hj3  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/Order/BigOperators/Group/List.htmlhtheorem List.all_zero_of_le_zero_le_of_sum_eq_zero {M : Type u_3} [AddCommMonoid M] [PartialOrder M] [IsOrderedAddMonoid M] {l : List M} (hl₁ : ∀ (x : M), x ∈ l → 0 ≤ x) (hl₂ : l.sum = 0) {x : M} (hx : x ∈ l) :
x = 0h
huList.prod_eq_one_iff}(hj3  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/Order/BigOperators/Group/List.htmlhtheorem List.prod_eq_one_iff {M : Type u_3} [CommMonoid M] [PartialOrder M] [CanonicallyOrderedMul M] {l : List M} [IsOrderedMonoid M] :
l.prod = 1 ↔ ∀ (x : M), x ∈ l → x = 1h
huList.sum_eq_zero_iff}(hj3  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/Order/BigOperators/Group/List.htmlhtheorem List.sum_eq_zero_iff {M : Type u_3} [AddCommMonoid M] [PartialOrder M] [CanonicallyOrderedAdd M] {l : List M} [IsOrderedAddMonoid M] :
l.sum = 0 ↔ ∀ (x : M), x ∈ l → x = 0h
huList.monotone_prod_take}(hj3  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/Order/BigOperators/Group/List.htmlhtheorem List.monotone_prod_take {M : Type u_3} [CommMonoid M] [PartialOrder M] [CanonicallyOrderedMul M] (L : List M) :
Monotone fun (i : ℕ) => (take i L).prodh
huList.monotone_sum_take}(hj3  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/Order/BigOperators/Group/List.htmlhtheorem List.monotone_sum_take {M : Type u_3} [AddCommMonoid M] [PartialOrder M] [CanonicallyOrderedAdd M] (L : List M) :
Monotone fun (i : ℕ) => (take i L).sumh
huList.le_prod_of_mem}(hj3  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/Order/BigOperators/Group/List.htmlhtheorem List.le_prod_of_mem {M : Type u_3} [CommMonoid M] [PartialOrder M] [CanonicallyOrderedMul M] {xs : List M} {x : M} (h₁ : x ∈ xs) :
x ≤ xs.prodh
See also List.single_le_prod.uList.le_sum_of_mem}(hj3  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/Order/BigOperators/Group/List.htmlhtheorem List.le_sum_of_mem {M : Type u_3} [AddCommMonoid M] [PartialOrder M] [CanonicallyOrderedAdd M] {xs : List M} {x : M} (h₁ : x ∈ xs) :
x ≤ xs.sumh
See also List.single_le_sum.uList.periodic_prod}(hj3  hWhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/Ring/Periodic.htmlhtheorem List.periodic_prod {α : Type u_1} {β : Type u_2} {c : α} [Add α] [MulOneClass β] (l : List (α → β)) (hl : ∀ f ∈ l, Function.Periodic f c) :
Function.Periodic l.prod ch
huList.periodic_sum}(hj3  hWhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/Ring/Periodic.htmlhtheorem List.periodic_sum {α : Type u_1} {β : Type u_2} {c : α} [Add α] [AddZeroClass β] (l : List (α → β)) (hl : ∀ f ∈ l, Function.Periodic f c) :
Function.Periodic l.sum ch
hu
List.trop_sum}(hj3  h_https://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/Tropical/BigOperators.htmlhrtheorem List.trop_sum {R : Type u_1} [AddMonoid R] (l : List R) :
Tropical.trop l.sum = (map Tropical.trop l).prodh
huList.untrop_prod}(hj3  h_https://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/Tropical/BigOperators.htmlhtheorem List.untrop_prod {R : Type u_1} [AddMonoid R] (l : List (Tropical R)) :
Tropical.untrop l.prod = (map Tropical.untrop l).sumh
huList.trop_minimum}(hj3  h_https://leanprover-community.github.io/mathlib4_docs/Mathlib/Algebra/Tropical/BigOperators.htmlhtheorem List.trop_minimum {R : Type u_1} [LinearOrder R] (l : List R) :
Tropical.trop l.minimum = (map (Tropical.trop ∘ WithTop.some) l).sumh
hu	List.Wbtw}(hj4  h]https://leanprover-community.github.io/mathlib4_docs/Mathlib/Analysis/Convex/BetweenList.htmlhdef List.Wbtw (R : Type u_1) {V : Type u_2} {P : Type u_4} [Ring R] [PartialOrder R] [AddCommGroup V] [Module R V] [AddTorsor V P] (l : List P) :
Proph
8The points in a list are weakly in that order on a line.uList.wbtw_cons}(hj4  h]https://leanprover-community.github.io/mathlib4_docs/Mathlib/Analysis/Convex/BetweenList.htmlhtheorem List.wbtw_cons {R : Type u_1} {V : Type u_2} {P : Type u_4} [Ring R] [PartialOrder R] [AddCommGroup V] [Module R V] [AddTorsor V P] {p : P} {l : List P} :
List.Wbtw R (p :: l) ↔ Pairwise (Wbtw R p) l ∧ List.Wbtw R lh
hu	List.Sbtw}(hj4  h]https://leanprover-community.github.io/mathlib4_docs/Mathlib/Analysis/Convex/BetweenList.htmlhdef List.Sbtw (R : Type u_1) {V : Type u_2} {P : Type u_4} [Ring R] [PartialOrder R] [AddCommGroup V] [Module R V] [AddTorsor V P] (l : List P) :
Proph
:The points in a list are strictly in that order on a line.u
List.wbtw_nil}(hj4  h]https://leanprover-community.github.io/mathlib4_docs/Mathlib/Analysis/Convex/BetweenList.htmlhtheorem List.wbtw_nil (R : Type u_1) {V : Type u_2} (P : Type u_4) [Ring R] [PartialOrder R] [AddCommGroup V] [Module R V] [AddTorsor V P] :
List.Wbtw R []h
hu
List.sbtw_nil}(hj4  h]https://leanprover-community.github.io/mathlib4_docs/Mathlib/Analysis/Convex/BetweenList.htmlhtheorem List.sbtw_nil (R : Type u_1) {V : Type u_2} (P : Type u_4) [Ring R] [PartialOrder R] [AddCommGroup V] [Module R V] [AddTorsor V P] :
List.Sbtw R []h
huList.wbtw_singleton}(hj4  h]https://leanprover-community.github.io/mathlib4_docs/Mathlib/Analysis/Convex/BetweenList.htmlhtheorem List.wbtw_singleton (R : Type u_1) {V : Type u_2} {P : Type u_4} [Ring R] [PartialOrder R] [AddCommGroup V] [Module R V] [AddTorsor V P] (p₁ : P) :
List.Wbtw R [p₁]h
huList.sbtw_singleton}(hj4  h]https://leanprover-community.github.io/mathlib4_docs/Mathlib/Analysis/Convex/BetweenList.htmlhtheorem List.sbtw_singleton (R : Type u_1) {V : Type u_2} {P : Type u_4} [Ring R] [PartialOrder R] [AddCommGroup V] [Module R V] [AddTorsor V P] (p₁ : P) :
List.Sbtw R [p₁]h
huList.wbtw_pair}(hj 4  h]https://leanprover-community.github.io/mathlib4_docs/Mathlib/Analysis/Convex/BetweenList.htmlhtheorem List.wbtw_pair (R : Type u_1) {V : Type u_2} {P : Type u_4} [Ring R] [PartialOrder R] [AddCommGroup V] [Module R V] [AddTorsor V P] (p₁ p₂ : P) :
List.Wbtw R [p₁, p₂]h
huList.sbtw_pair}(hj$4  h]https://leanprover-community.github.io/mathlib4_docs/Mathlib/Analysis/Convex/BetweenList.htmlhtheorem List.sbtw_pair (R : Type u_1) {V : Type u_2} {P : Type u_4} [Ring R] [PartialOrder R] [AddCommGroup V] [Module R V] [AddTorsor V P] {p₁ p₂ : P} :
List.Sbtw R [p₁, p₂] ↔ p₁ ≠ p₂h
huList.wbtw_triple}(hj(4  h]https://leanprover-community.github.io/mathlib4_docs/Mathlib/Analysis/Convex/BetweenList.htmlhtheorem List.wbtw_triple {R : Type u_1} {V : Type u_2} {P : Type u_4} [Ring R] [PartialOrder R] [AddCommGroup V] [Module R V] [AddTorsor V P] {p₁ p₂ p₃ : P} :
List.Wbtw R [p₁, p₂, p₃] ↔ Wbtw R p₁ p₂ p₃h
huList.sbtw_triple}(hj,4  h]https://leanprover-community.github.io/mathlib4_docs/Mathlib/Analysis/Convex/BetweenList.htmlhtheorem List.sbtw_triple {R : Type u_1} {V : Type u_2} {P : Type u_4} [Ring R] [PartialOrder R] [AddCommGroup V] [Module R V] [AddTorsor V P] [IsOrderedRing R] {p₁ p₂ p₃ : P} :
List.Sbtw R [p₁, p₂, p₃] ↔ Sbtw R p₁ p₂ p₃h
huList.wbtw_four}(hj04  h]https://leanprover-community.github.io/mathlib4_docs/Mathlib/Analysis/Convex/BetweenList.htmlhX4  theorem List.wbtw_four {R : Type u_1} {V : Type u_2} {P : Type u_4} [Ring R] [PartialOrder R] [AddCommGroup V] [Module R V] [AddTorsor V P] {p₁ p₂ p₃ p₄ : P} :
List.Wbtw R [p₁, p₂, p₃, p₄] ↔ Wbtw R p₁ p₂ p₃ ∧ Wbtw R p₁ p₂ p₄ ∧ Wbtw R p₁ p₃ p₄ ∧ Wbtw R p₂ p₃ p₄h
huList.sbtw_four}(hj44  h]https://leanprover-community.github.io/mathlib4_docs/Mathlib/Analysis/Convex/BetweenList.htmlhXF  theorem List.sbtw_four {R : Type u_1} {V : Type u_2} {P : Type u_4} [Ring R] [PartialOrder R] [AddCommGroup V] [Module R V] [AddTorsor V P] [IsOrderedRing R] {p₁ p₂ p₃ p₄ : P} :
List.Sbtw R [p₁, p₂, p₃, p₄] ↔ Sbtw R p₁ p₂ p₃ ∧ Sbtw R p₁ p₂ p₄ ∧ Sbtw R p₁ p₃ p₄ ∧ Sbtw R p₂ p₃ p₄h
hu$List.sbtw_iff_triplewise_and_ne_pair}(hj84  h]https://leanprover-community.github.io/mathlib4_docs/Mathlib/Analysis/Convex/BetweenList.htmlhX  theorem List.sbtw_iff_triplewise_and_ne_pair {R : Type u_1} {V : Type u_2} {P : Type u_4} [Ring R] [PartialOrder R] [AddCommGroup V] [Module R V] [AddTorsor V P] [IsOrderedRing R] {l : List P} :
List.Sbtw R l ↔ Triplewise (Sbtw R) l ∧ ∀ (a : P), l ≠ [a, a]h
huList.sbtw_cons}(hj<4  h]https://leanprover-community.github.io/mathlib4_docs/Mathlib/Analysis/Convex/BetweenList.htmlhX  theorem List.sbtw_cons {R : Type u_1} {V : Type u_2} {P : Type u_4} [Ring R] [PartialOrder R] [AddCommGroup V] [Module R V] [AddTorsor V P] [IsOrderedRing R] {p : P} {l : List P} :
List.Sbtw R (p :: l) ↔ Pairwise (Sbtw R p) l ∧ List.Sbtw R l ∧ l ≠ [p]h
hu.List.exists_map_eq_of_sorted_nonempty_iff_wbtw}(hj@4  h]https://leanprover-community.github.io/mathlib4_docs/Mathlib/Analysis/Convex/BetweenList.htmlhXy  theorem List.exists_map_eq_of_sorted_nonempty_iff_wbtw {R : Type u_1} {V : Type u_2} {P : Type u_4} [Field R] [LinearOrder R] [IsStrictOrderedRing R] [AddCommGroup V] [Module R V] [AddTorsor V P] {l : List P} (hl : l ≠ []) :
(∃ (l' : List R),
    Sorted (fun (x1 x2 : R) => x1 ≤ x2) l' ∧ map (⇑(AffineMap.lineMap (l.head hl) (l.getLast hl))) l' = l) ↔ List.Wbtw R lh
hu%List.exists_map_eq_of_sorted_iff_wbtw}(hjD4  h]https://leanprover-community.github.io/mathlib4_docs/Mathlib/Analysis/Convex/BetweenList.htmlhXa  theorem List.exists_map_eq_of_sorted_iff_wbtw {R : Type u_1} {V : Type u_2} {P : Type u_4} [Field R] [LinearOrder R] [IsStrictOrderedRing R] [AddCommGroup V] [Module R V] [AddTorsor V P] {l : List P} :
(∃ (p₁ : P) (p₂ : P) (l' : List R), Sorted (fun (x1 x2 : R) => x1 ≤ x2) l' ∧ map (⇑(AffineMap.lineMap p₁ p₂)) l' = l) ↔ List.Wbtw R lh
hu.List.exists_map_eq_of_sorted_nonempty_iff_sbtw}(hjH4  h]https://leanprover-community.github.io/mathlib4_docs/Mathlib/Analysis/Convex/BetweenList.htmlhX  theorem List.exists_map_eq_of_sorted_nonempty_iff_sbtw {R : Type u_1} {V : Type u_2} {P : Type u_4} [Field R] [LinearOrder R] [IsStrictOrderedRing R] [AddCommGroup V] [Module R V] [AddTorsor V P] {l : List P} (hl : l ≠ []) :
(∃ (l' : List R),
    Sorted (fun (x1 x2 : R) => x1 < x2) l' ∧       map (⇑(AffineMap.lineMap (l.head hl) (l.getLast hl))) l' = l ∧ (l.length = 1 ∨ l.head hl ≠ l.getLast hl)) ↔ List.Sbtw R lh
hu%List.exists_map_eq_of_sorted_iff_sbtw}(hjL4  h]https://leanprover-community.github.io/mathlib4_docs/Mathlib/Analysis/Convex/BetweenList.htmlhX  theorem List.exists_map_eq_of_sorted_iff_sbtw {R : Type u_1} {V : Type u_2} {P : Type u_4} [Field R] [LinearOrder R] [IsStrictOrderedRing R] [AddCommGroup V] [Module R V] [AddTorsor V P] [Nontrivial P] {l : List P} :
(∃ (p₁ : P) (p₂ : P),
    p₁ ≠ p₂ ∧ ∃ (l' : List R), Sorted (fun (x1 x2 : R) => x1 < x2) l' ∧ map (⇑(AffineMap.lineMap p₁ p₂)) l' = l) ↔ List.Sbtw R lh
huList.norm_prod_le'}(hjP4  h\https://leanprover-community.github.io/mathlib4_docs/Mathlib/Analysis/Normed/Ring/Basic.htmlh~theorem List.norm_prod_le' {α : Type u_2} [SeminormedRing α] {l : List α} :
l ≠ [] → ‖l.prod‖ ≤ (map norm l).prodh
huList.nnnorm_prod_le'}(hjT4  h\https://leanprover-community.github.io/mathlib4_docs/Mathlib/Analysis/Normed/Ring/Basic.htmlhtheorem List.nnnorm_prod_le' {α : Type u_2} [SeminormedRing α] {l : List α} (hl : l ≠ []) :
‖l.prod‖₊ ≤ (map nnnorm l).prodh
huList.norm_prod_le}(hjX4  h\https://leanprover-community.github.io/mathlib4_docs/Mathlib/Analysis/Normed/Ring/Basic.htmlhtheorem List.norm_prod_le {α : Type u_2} [SeminormedRing α] [NormOneClass α] (l : List α) :
‖l.prod‖ ≤ (map norm l).prodh
huList.nnnorm_prod_le}(hj\4  h\https://leanprover-community.github.io/mathlib4_docs/Mathlib/Analysis/Normed/Ring/Basic.htmlhtheorem List.nnnorm_prod_le {α : Type u_2} [SeminormedRing α] [NormOneClass α] (l : List α) :
‖l.prod‖₊ ≤ (map nnnorm l).prodh
huList.norm_prod}(hj`4  h\https://leanprover-community.github.io/mathlib4_docs/Mathlib/Analysis/Normed/Ring/Basic.htmlhtheorem List.norm_prod {α : Type u_2} [SeminormedRing α] [NormOneClass α] [NormMulClass α] (l : List α) :
‖l.prod‖ = (map norm l).prodh
huList.nnnorm_prod}(hjd4  h\https://leanprover-community.github.io/mathlib4_docs/Mathlib/Analysis/Normed/Ring/Basic.htmlhtheorem List.nnnorm_prod {α : Type u_2} [SeminormedRing α] [NormOneClass α] [NormMulClass α] (l : List α) :
‖l.prod‖₊ = (map nnnorm l).prodh
huList.splitWrtCompositionAux}(hjh4  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Combinatorics/Enumerative/Composition.htmlhYdef List.splitWrtCompositionAux {α : Type u_1} :
List α → List ℕ → List (List α)h
'Auxiliary for List.splitWrtComposition.uList.splitWrtComposition}(hjm4  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Combinatorics/Enumerative/Composition.htmlhidef List.splitWrtComposition {n : ℕ} {α : Type u_1} (l : List α) (c : Composition n) :
List (List α)h
X  Given a list of length n and a composition [i₁, ..., iₖ] of n, split l into a list of k lists corresponding to the blocks of the composition, of respective lengths i₁, ..., iₖ. This makes sense mostly when n = l.length, but this is not necessary for the definition.u List.splitWrtCompositionAux_cons}(hjr4  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Combinatorics/Enumerative/Composition.htmlhtheorem List.splitWrtCompositionAux_cons {α : Type u_1} (l : List α) (n : ℕ) (ns : List ℕ) :
l.splitWrtCompositionAux (n :: ns) = take n l :: (drop n l).splitWrtCompositionAux nsh
hu"List.length_splitWrtCompositionAux}(hjv4  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Combinatorics/Enumerative/Composition.htmlhtheorem List.length_splitWrtCompositionAux {α : Type u_1} (l : List α) (ns : List ℕ) :
(l.splitWrtCompositionAux ns).length = ns.lengthh
huList.length_splitWrtComposition}(hjz4  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Combinatorics/Enumerative/Composition.htmlhtheorem List.length_splitWrtComposition {n : ℕ} {α : Type u_1} (l : List α) (c : Composition n) :
(l.splitWrtComposition c).length = c.lengthh
^When one splits a list along a composition c, the number of sublists thus created is c.length.u&List.map_length_splitWrtCompositionAux}(hj4  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Combinatorics/Enumerative/Composition.htmlhtheorem List.map_length_splitWrtCompositionAux {α : Type u_1} {ns : List ℕ} {l : List α} :
ns.sum ≤ l.length → map length (l.splitWrtCompositionAux ns) = nsh
hu#List.map_length_splitWrtComposition}(hj4  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Combinatorics/Enumerative/Composition.htmlhtheorem List.map_length_splitWrtComposition {α : Type u_1} (l : List α) (c : Composition l.length) :
map length (l.splitWrtComposition c) = c.blocksh
yWhen one splits a list along a composition c, the lengths of the sublists thus created are given by the block sizes in c.u*List.length_pos_of_mem_splitWrtComposition}(hj4  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Combinatorics/Enumerative/Composition.htmlhtheorem List.length_pos_of_mem_splitWrtComposition {α : Type u_1} {l l' : List α} {c : Composition l.length} (h : l' ∈ l.splitWrtComposition c) :
0 < l'.lengthh
hu,List.sum_take_map_length_splitWrtComposition}(hj4  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Combinatorics/Enumerative/Composition.htmlhtheorem List.sum_take_map_length_splitWrtComposition {α : Type u_1} (l : List α) (c : Composition l.length) (i : ℕ) :
(take i (map length (l.splitWrtComposition c))).sum = c.sizeUpTo ih
hu#List.getElem_splitWrtCompositionAux}(hj4  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Combinatorics/Enumerative/Composition.htmlhtheorem List.getElem_splitWrtCompositionAux {α : Type u_1} (l : List α) (ns : List ℕ) {i : ℕ} (hi : i < (l.splitWrtCompositionAux ns).length) :
(l.splitWrtCompositionAux ns)[i] = drop (take i ns).sum (take (take (i + 1) ns).sum l)h
hu!List.getElem_splitWrtComposition'}(hj4  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Combinatorics/Enumerative/Composition.htmlhtheorem List.getElem_splitWrtComposition' {n : ℕ} {α : Type u_1} (l : List α) (c : Composition n) {i : ℕ} (hi : i < (l.splitWrtComposition c).length) :
(l.splitWrtComposition c)[i] = drop (c.sizeUpTo i) (take (c.sizeUpTo (i + 1)) l)h
The i-th sublist in the splitting of a list l along a composition c, is the slice of l between the indices c.sizeUpTo i and c.sizeUpTo (i+1), i.e., the indices in the i-th block of the composition.u List.getElem_splitWrtComposition}(hj4  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Combinatorics/Enumerative/Composition.htmlhtheorem List.getElem_splitWrtComposition {n : ℕ} {α : Type u_1} (l : List α) (c : Composition n) (i : ℕ) (h : i < (l.splitWrtComposition c).length) :
(l.splitWrtComposition c)[i] = drop (c.sizeUpTo i) (take (c.sizeUpTo (i + 1)) l)h
hu#List.flatten_splitWrtCompositionAux}(hj4  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Combinatorics/Enumerative/Composition.htmlhtheorem List.flatten_splitWrtCompositionAux {α : Type u_1} {ns : List ℕ} {l : List α} :
ns.sum = l.length → (l.splitWrtCompositionAux ns).flatten = lh
hu List.flatten_splitWrtComposition}(hj4  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Combinatorics/Enumerative/Composition.htmlhtheorem List.flatten_splitWrtComposition {α : Type u_1} (l : List α) (c : Composition l.length) :
(l.splitWrtComposition c).flatten = lh
jIf one splits a list along a composition, and then flattens the sublists, one gets back the original list.u List.splitWrtComposition_flatten}(hj4  hghttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Combinatorics/Enumerative/Composition.htmlhtheorem List.splitWrtComposition_flatten {α : Type u_1} (L : List (List α)) (c : Composition L.flatten.length) (h : map length L = c.blocks) :
L.flatten.splitWrtComposition c = Lh
If one joins a list of lists and then splits the flattening along the right composition, one gets back the original list of lists.uList.mapAccumRM}(hj4  hOhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Control/Basic.htmlhdef List.mapAccumRM {α : Type u} {β' γ' : Type v} {m' : Type v → Type w} [Monad m'] (f : α → β' → m' (β' × γ')) :
β' → List α → m' (β' × List γ')h
Takes a value β and List α and accumulates pairs according to a monadic function f. Accumulation occurs from the right (i.e., starting from the tail of the list).uList.mapAccumLM}(hj4  hOhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Control/Basic.htmlhdef List.mapAccumLM {α : Type u} {β' γ' : Type v} {m' : Type v → Type w} [Monad m'] (f : β' → α → m' (β' × γ')) :
β' → List α → m' (β' × List γ')h
Takes a value β and List α and accumulates pairs according to a monadic function f. Accumulation occurs from the left (i.e., starting from the head of the list).uList.id_traverse}(hj4  h_https://leanprover-community.github.io/mathlib4_docs/Mathlib/Control/Traversable/Instances.htmlhYtheorem List.id_traverse {α : Type u_1} (xs : List α) :
List.traverse pure xs = pure xsh
huList.comp_traverse}(hj4  h_https://leanprover-community.github.io/mathlib4_docs/Mathlib/Control/Traversable/Instances.htmlhXA  theorem List.comp_traverse {F G : Type u → Type u} [Applicative F] [Applicative G] [LawfulApplicative G] {α : Type u_1} {β γ : Type u} (f : β → F γ) (g : α → G β) (x : List α) :
List.traverse (Functor.Comp.mk ∘ (fun (x : G β) => f <$> x) ∘ g) x = Functor.Comp.mk (List.traverse f <$> List.traverse g x)h
huList.traverse_eq_map_id}(hj4  h_https://leanprover-community.github.io/mathlib4_docs/Mathlib/Control/Traversable/Instances.htmlhtheorem List.traverse_eq_map_id {α β : Type u_1} (f : α → β) (x : List α) :
List.traverse (pure ∘ f) x = pure (f <$> x)h
huList.naturality}(hj4  h_https://leanprover-community.github.io/mathlib4_docs/Mathlib/Control/Traversable/Instances.htmlhXR  theorem List.naturality {F G : Type u → Type u} [Applicative F] [Applicative G] [LawfulApplicative G] [LawfulApplicative F] (η : ApplicativeTransformation F G) {α : Type u_1} {β : Type u} (f : α → F β) (x : List α) :
(fun {α : Type u} => η.app α) (List.traverse f x) = List.traverse ((fun {α : Type u} => η.app α) ∘ f) xh
huList.instLawfulTraversable}(hj4  h_https://leanprover-community.github.io/mathlib4_docs/Mathlib/Control/Traversable/Instances.htmlh<instance List.instLawfulTraversable :
LawfulTraversable Listh
huList.traverse_nil}(hj4  h_https://leanprover-community.github.io/mathlib4_docs/Mathlib/Control/Traversable/Instances.htmlhtheorem List.traverse_nil {F : Type u → Type u} [Applicative F] {α' β' : Type u} (f : α' → F β') :
traverse f [] = pure []h
huList.traverse_cons}(hj4  h_https://leanprover-community.github.io/mathlib4_docs/Mathlib/Control/Traversable/Instances.htmlhtheorem List.traverse_cons {F : Type u → Type u} [Applicative F] {α' β' : Type u} (f : α' → F β') (a : α') (l : List α') :
traverse f (a :: l) = (fun (x1 : β') (x2 : List β') => x1 :: x2) <$> f a <*> traverse f lh
huList.traverse_append}(hj4  h_https://leanprover-community.github.io/mathlib4_docs/Mathlib/Control/Traversable/Instances.htmlhtheorem List.traverse_append {F : Type u → Type u} [Applicative F] {α' β' : Type u} (f : α' → F β') [LawfulApplicative F] (as bs : List α') :
traverse f (as ++ bs) = (fun (x1 x2 : List β') => x1 ++ x2) <$> traverse f as <*> traverse f bsh
huList.mem_traverse}(hj4  h_https://leanprover-community.github.io/mathlib4_docs/Mathlib/Control/Traversable/Instances.htmlhtheorem List.mem_traverse {α' β' : Type u} {f : α' → Set β'} (l : List α') (n : List β') :
n ∈ traverse f l ↔ Forall₂ (fun (b : β') (a : α') => b ∈ f a) n lh
huList.all_iff_forall_prop}(hj4  hRhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/Bool/AllAny.htmlhtheorem List.all_iff_forall_prop {α : Type u_1} {p : α → Prop} [DecidablePred p] {l : List α} :
(l.all fun (a : α) => decide (p a)) = true ↔ ∀ (a : α), a ∈ l → p ah
huList.any_iff_exists_prop}(hj4  hRhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/Bool/AllAny.htmlhtheorem List.any_iff_exists_prop {α : Type u_1} {p : α → Prop} [DecidablePred p] {l : List α} :
(l.any fun (a : α) => decide (p a)) = true ↔ ∃ (a : α), a ∈ l ∧ p ah
huList.any_of_mem}(hj4  hRhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/Bool/AllAny.htmlhtheorem List.any_of_mem {α : Type u_1} {l : List α} {a : α} {p : α → Bool} (h₁ : a ∈ l) (h₂ : p a = true) :
l.any p = trueh
huList.count_not_add_count}(hj4  hQhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/Bool/Count.htmlhatheorem List.count_not_add_count (l : List Bool) (b : Bool) :
count (!b) l + count b l = l.lengthh
huList.count_add_count_not}(hj4  hQhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/Bool/Count.htmlhatheorem List.count_add_count_not (l : List Bool) (b : Bool) :
count b l + count (!b) l = l.lengthh
huList.count_false_add_count_true}(hj4  hQhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/Bool/Count.htmlhatheorem List.count_false_add_count_true (l : List Bool) :
count false l + count true l = l.lengthh
huList.count_true_add_count_false}(hj4  hQhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/Bool/Count.htmlhatheorem List.count_true_add_count_false (l : List Bool) :
count true l + count false l = l.lengthh
huList.mem_pi_toList}(hj4  hNhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/FinEnum.htmlhtheorem List.mem_pi_toList {α : Type u_1} [FinEnum α] {β : α → Type u_2} [(a : α) → FinEnum (β a)] (xs : List α) (f : (a : α) → a ∈ xs → β a) :
f ∈ xs.pi fun (x : α) => FinEnum.toList (β x)h
huList.pfunFinEnum}(hj4  hNhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/FinEnum.htmlhinstance List.pfunFinEnum (p : Prop) [Decidable p] (α : p → Type) [(hp : p) → FinEnum (α hp)] :
FinEnum ((hp : p) → α hp)h
hu
List.toFinset}(hj4  hShttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/Finset/Dedup.htmlhLdef List.toFinset {α : Type u_1} [DecidableEq α] (l : List α) :
Finset αh
BtoFinset l removes duplicates from the list l to produce a finset.uList.toFinset_val}(hj5  hShttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/Finset/Dedup.htmlhftheorem List.toFinset_val {α : Type u_1} [DecidableEq α] (l : List α) :
l.toFinset.val = ↑l.deduph
huList.toFinset_coe}(hj5  hShttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/Finset/Dedup.htmlhgtheorem List.toFinset_coe {α : Type u_1} [DecidableEq α] (l : List α) :
(↑l).toFinset = l.toFinseth
huList.toFinset_eq}(hj
5  hShttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/Finset/Dedup.htmlhtheorem List.toFinset_eq {α : Type u_1} [DecidableEq α] {l : List α} (n : l.Nodup) :
{ val := ↑l, nodup := n } = l.toFinseth
huList.mem_toFinset}(hj5  hShttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/Finset/Dedup.htmlhptheorem List.mem_toFinset {α : Type u_1} [DecidableEq α] {l : List α} {a : α} :
a ∈ l.toFinset ↔ a ∈ lh
huList.coe_toFinset}(hj5  hShttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/Finset/Dedup.htmlhmtheorem List.coe_toFinset {α : Type u_1} [DecidableEq α] (l : List α) :
↑l.toFinset = {a : α | a ∈ l}h
huList.toFinset_surj_on}(hj5  hShttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/Finset/Dedup.htmlhutheorem List.toFinset_surj_on {α : Type u_1} [DecidableEq α] :
Set.SurjOn toFinset {l : List α | l.Nodup} Set.univh
huList.toFinset_surjective}(hj5  hShttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/Finset/Dedup.htmlh`theorem List.toFinset_surjective {α : Type u_1} [DecidableEq α] :
Function.Surjective toFinseth
huList.toFinset_eq_iff_perm_dedup}(hj5  hShttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/Finset/Dedup.htmlhtheorem List.toFinset_eq_iff_perm_dedup {α : Type u_1} [DecidableEq α] {l l' : List α} :
l.toFinset = l'.toFinset ↔ l.dedup.Perm l'.deduph
huList.toFinset_eq_of_perm}(hj"5  hShttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/Finset/Dedup.htmlh}theorem List.toFinset_eq_of_perm {α : Type u_1} [DecidableEq α] (l l' : List α) (h : l.Perm l') :
l.toFinset = l'.toFinseth
hu$List.perm_of_nodup_nodup_toFinset_eq}(hj&5  hShttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/Finset/Dedup.htmlhtheorem List.perm_of_nodup_nodup_toFinset_eq {α : Type u_1} [DecidableEq α] {l l' : List α} (hl : l.Nodup) (hl' : l'.Nodup) (h : l.toFinset = l'.toFinset) :
l.Perm l'h
huList.toFinset_reverse}(hj*5  hShttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/Finset/Dedup.htmlhntheorem List.toFinset_reverse {α : Type u_1} [DecidableEq α] {l : List α} :
l.reverse.toFinset = l.toFinseth
huList.toFinset_toList}(hj.5  hShttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/Finset/Dedup.htmlhutheorem List.toFinset_toList {α : Type u_1} [DecidableEq α] {s : List α} (hs : s.Nodup) :
s.toFinset.toList.Perm sh
hu#List.disjoint_toFinset_iff_disjoint}(hj25  hVhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/Finset/Disjoint.htmlhtheorem List.disjoint_toFinset_iff_disjoint {α : Type u_1} [DecidableEq α] {l l' : List α} :
_root_.Disjoint l.toFinset l'.toFinset ↔ l.Disjoint l'h
hu2List.instDecidableMapsToToSetOfDecidablePredMemSet}(hj65  hRhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/Finset/Defs.htmlhinstance List.instDecidableMapsToToSetOfDecidablePredMemSet {α : Type u_1} {β : Type u_2} {f : α → β} {s : Finset α} {t : Set β} [DecidablePred fun (x : β) => x ∈ t] :
Decidable (Set.MapsTo f (↑s) t)h
hu*List.instDecidableSurjOnToSetOfDecidableEq}(hj:5  hRhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/Finset/Defs.htmlhinstance List.instDecidableSurjOnToSetOfDecidableEq {α : Type u_1} {β : Type u_2} {f : α → β} {s : Finset α} {t' : Finset β} [DecidableEq β] :
Decidable (Set.SurjOn f ↑s ↑t')h
hu
List.toFinmap}(hj>5  hMhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/Finmap.htmlhgdef List.toFinmap {α : Type u} {β : α → Type v} [DecidableEq α] (s : List (Sigma β)) :
Finmap βh
cGiven l : List (Sigma β), create a term of type Finmap β by removing entries with duplicate keys.uList.toFinset_union}(hjC5  hShttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/Finset/Basic.htmlhtheorem List.toFinset_union {α : Type u_1} [DecidableEq α] (l l' : List α) :
(l ∪ l').toFinset = l.toFinset ∪ l'.toFinseth
huList.toFinset_inter}(hjG5  hShttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/Finset/Basic.htmlhtheorem List.toFinset_inter {α : Type u_1} [DecidableEq α] (l l' : List α) :
(l ∩ l').toFinset = l.toFinset ∩ l'.toFinseth
huList.toFinset_filter}(hjK5  hShttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/Finset/Basic.htmlhtheorem List.toFinset_filter {α : Type u_1} [DecidableEq α] (s : List α) (p : α → Bool) :
(filter p s).toFinset = Finset.filter (fun (x : α) => p x = true) s.toFinseth
huList.card_toFinset}(hjO5  hRhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/Finset/Card.htmlhltheorem List.card_toFinset {α : Type u_1} [DecidableEq α] (l : List α) :
l.toFinset.card = l.dedup.lengthh
huList.toFinset_card_le}(hjS5  hRhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/Finset/Card.htmlhktheorem List.toFinset_card_le {α : Type u_1} [DecidableEq α] (l : List α) :
l.toFinset.card ≤ l.lengthh
huList.toFinset_card_of_nodup}(hjW5  hRhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/Finset/Card.htmlh}theorem List.toFinset_card_of_nodup {α : Type u_1} [DecidableEq α] {l : List α} (h : l.Nodup) :
l.toFinset.card = l.lengthh
huList.toFinset_append}(hj[5  h\https://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/Finset/Lattice/Lemmas.htmlhtheorem List.toFinset_append {α : Type u_1} [DecidableEq α] {l l' : List α} :
(l ++ l').toFinset = l.toFinset ∪ l'.toFinseth
huList.nat_divisors_prod}(hj_5  hYhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/Finset/NatDivisors.htmlh[theorem List.nat_divisors_prod (l : List ℕ) :
l.prod.divisors = (map Nat.divisors l).prodh
huList.toFinset_filterMap}(hjc5  hShttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/Finset/Image.htmlhX  theorem List.toFinset_filterMap {α : Type u_1} {β : Type u_2} (f : α → Option β) [DecidableEq α] [DecidableEq β] (f_inj : ∀ (a a' : α) (b : β), f a = some b → f a' = some b → a = a') (s : List α) :
(filterMap f s).toFinset = Finset.filterMap f s.toFinset f_injh
huList.toFinset_nil}(hjg5  hThttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/Finset/Insert.htmlhNtheorem List.toFinset_nil {α : Type u_1} [DecidableEq α] :
[].toFinset = ∅h
huList.toFinset_cons}(hjk5  hThttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/Finset/Insert.htmlh|theorem List.toFinset_cons {α : Type u_1} [DecidableEq α] {l : List α} {a : α} :
(a :: l).toFinset = insert a l.toFinseth
hu"List.toFinset_replicate_of_ne_zero}(hjo5  hThttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/Finset/Insert.htmlhtheorem List.toFinset_replicate_of_ne_zero {α : Type u_1} [DecidableEq α] {a : α} {n : ℕ} (hn : n ≠ 0) :
(replicate n a).toFinset = {a}h
huList.toFinset_eq_empty_iff}(hjs5  hThttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/Finset/Insert.htmlhotheorem List.toFinset_eq_empty_iff {α : Type u_1} [DecidableEq α] (l : List α) :
l.toFinset = ∅ ↔ l = []h
huList.toFinset_nonempty_iff}(hjw5  hThttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/Finset/Insert.htmlhttheorem List.toFinset_nonempty_iff {α : Type u_1} [DecidableEq α] (l : List α) :
l.toFinset.Nonempty ↔ l ≠ []h
hu&List.pairwise_of_coe_toFinset_pairwise}(hj{5  hVhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/Finset/Pairwise.htmlhtheorem List.pairwise_of_coe_toFinset_pairwise {α : Type u_1} [DecidableEq α] {r : α → α → Prop} {l : List α} (hl : (↑l.toFinset).Pairwise r) (hn : l.Nodup) :
Pairwise r lh
hu'List.pairwise_iff_coe_toFinset_pairwise}(hj5  hVhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/Finset/Pairwise.htmlhtheorem List.pairwise_iff_coe_toFinset_pairwise {α : Type u_1} [DecidableEq α] {r : α → α → Prop} {l : List α} (hn : l.Nodup) (hs : Symmetric r) :
(↑l.toFinset).Pairwise r ↔ Pairwise r lh
hu7List.pairwise_disjoint_of_coe_toFinset_pairwiseDisjoint}(hj5  hVhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/Finset/Pairwise.htmlhX  theorem List.pairwise_disjoint_of_coe_toFinset_pairwiseDisjoint {α : Type u_5} {ι : Type u_6} [PartialOrder α] [OrderBot α] [DecidableEq ι] {l : List ι} {f : ι → α} (hl : (↑l.toFinset).PairwiseDisjoint f) (hn : l.Nodup) :
Pairwise (Function.onFun _root_.Disjoint f) lh
hu8List.pairwiseDisjoint_iff_coe_toFinset_pairwise_disjoint}(hj5  hVhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/Finset/Pairwise.htmlhX  theorem List.pairwiseDisjoint_iff_coe_toFinset_pairwise_disjoint {α : Type u_5} {ι : Type u_6} [PartialOrder α] [OrderBot α] [DecidableEq ι] {l : List ι} {f : ι → α} (hn : l.Nodup) :
(↑l.toFinset).PairwiseDisjoint f ↔ Pairwise (Function.onFun _root_.Disjoint f) lh
huList.foldr_sup_eq_sup_toFinset}(hj5  hZhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/Finset/Lattice/Fold.htmlhtheorem List.foldr_sup_eq_sup_toFinset {α : Type u_2} [SemilatticeSup α] [OrderBot α] [DecidableEq α] (l : List α) :
foldr (fun (x1 x2 : α) => x1 ⊔ x2) ⊥ l = l.toFinset.sup idh
huList.foldr_inf_eq_inf_toFinset}(hj5  hZhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/Finset/Lattice/Fold.htmlhtheorem List.foldr_inf_eq_inf_toFinset {α : Type u_2} [SemilatticeInf α] [OrderTop α] [DecidableEq α] (l : List α) :
foldr (fun (x1 x2 : α) => x1 ⊓ x2) ⊤ l = l.toFinset.inf idh
huList.toFinset_sort}(hj5  hRhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/Finset/Sort.htmlhtheorem List.toFinset_sort {α : Type u_1} (r : α → α → Prop) [DecidableRel r] [IsTrans α r] [IsAntisymm α r] [IsTotal α r] [DecidableEq α] {l : List α} (hl : l.Nodup) :
Finset.sort r l.toFinset = l ↔ Sorted r lh
huList.support_sum_subset}(hj5  h[https://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/Finsupp/BigOperators.htmlhtheorem List.support_sum_subset {ι : Type u_1} {M : Type u_2} [DecidableEq ι] [AddZeroClass M] (l : List (ι →₀ M)) :
l.sum.support ⊆ foldr (fun (x1 : ι →₀ M) (x2 : Finset ι) => x1.support ⊔ x2) ∅ lh
huList.mem_foldr_sup_support_iff}(hj5  h[https://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/Finsupp/BigOperators.htmlhtheorem List.mem_foldr_sup_support_iff {ι : Type u_1} {M : Type u_2} [DecidableEq ι] [Zero M] {l : List (ι →₀ M)} {x : ι} :
x ∈ foldr (fun (x1 : ι →₀ M) (x2 : Finset ι) => x1.support ⊔ x2) ∅ l ↔ ∃ f ∈ l, x ∈ f.supporth
huList.support_sum_eq}(hj5  h[https://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/Finsupp/BigOperators.htmlhX  theorem List.support_sum_eq {ι : Type u_1} {M : Type u_2} [DecidableEq ι] [AddZeroClass M] (l : List (ι →₀ M)) (hl : Pairwise (Function.onFun _root_.Disjoint Finsupp.support) l) :
l.sum.support = foldr (fun (x1 : ι →₀ M) (x2 : Finset ι) => x1.support ⊔ x2) ∅ lh
huList.toFinset_finRange}(hj5  hThttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/Fintype/Basic.htmlhNtheorem List.toFinset_finRange (n : ℕ) :
(finRange n).toFinset = Finset.univh
hu)List.instDecidableInjOnToSetOfDecidableEq}(hj5  hShttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/Fintype/Defs.htmlhinstance List.instDecidableInjOnToSetOfDecidableEq {α : Type u_1} {β : Type u_2} {f : α → β} {s : Finset α} [DecidableEq β] :
Decidable (Set.InjOn f ↑s)h
hu)List.instDecidableBijOnToSetOfDecidableEq}(hj5  hShttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/Fintype/Defs.htmlhinstance List.instDecidableBijOnToSetOfDecidableEq {α : Type u_1} {β : Type u_2} {f : α → β} {s : Finset α} {t' : Finset β} [DecidableEq β] :
Decidable (Set.BijOn f ↑s ↑t')F      h
huList.chain'_ofFn}(hj5  hUhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/ChainOfFn.htmlhtheorem List.chain'_ofFn {α : Type u_1} {n : ℕ} {f : Fin n → α} {r : α → α → Prop} :
Chain' r (ofFn f) ↔ ∀ (i : ℕ) (hi : i + 1 < n), r (f ⟨i, ⋯⟩) (f ⟨i + 1, hi⟩)h
huList.countP_lt_length_iff}(hj5  hQhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Count.htmlhtheorem List.countP_lt_length_iff {α : Type u_1} {l : List α} {p : α → Bool} :
countP p l < l.length ↔ ∃ (a : α), a ∈ l ∧ p a = falseh
huList.count_lt_length_iff}(hj5  hQhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Count.htmlhtheorem List.count_lt_length_iff {α : Type u_1} [DecidableEq α] {l : List α} {a : α} :
count a l < l.length ↔ ∃ (b : α), b ∈ l ∧ b ≠ ah
huList.countP_erase}(hj5  hQhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Count.htmlhtheorem List.countP_erase {α : Type u_1} [DecidableEq α] (p : α → Bool) (l : List α) (a : α) :
countP p (l.erase a) = countP p l - if a ∈ l ∧ p a = true then 1 else 0h
huList.count_diff}(hj5  hQhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Count.htmlhtheorem List.count_diff {α : Type u_1} [DecidableEq α] (a : α) (l₁ l₂ : List α) :
count a (l₁.diff l₂) = count a l₁ - count a l₂h
huList.countP_diff}(hj5  hQhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Count.htmlhtheorem List.countP_diff {α : Type u_1} [DecidableEq α] {l₁ l₂ : List α} (hl : l₂.Subperm l₁) (p : α → Bool) :
countP p (l₁.diff l₂) = countP p l₁ - countP p l₂h
huList.count_map_of_injective}(hj5  hQhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Count.htmlhtheorem List.count_map_of_injective {α : Type u_1} {β : Type u_2} [DecidableEq α] [DecidableEq β] (l : List α) (f : α → β) (hf : Function.Injective f) (x : α) :
count (f x) (map f l) = count x lh
huList.dedup_nil}(hj5  hQhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Dedup.htmlhGtheorem List.dedup_nil {α : Type u_1} [DecidableEq α] :
[].dedup = []h
huList.dedup_cons_of_mem'}(hj5  hQhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Dedup.htmlhtheorem List.dedup_cons_of_mem' {α : Type u_1} [DecidableEq α] {a : α} {l : List α} (h : a ∈ l.dedup) :
(a :: l).dedup = l.deduph
huList.dedup_cons_of_notMem'}(hj5  hQhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Dedup.htmlhtheorem List.dedup_cons_of_notMem' {α : Type u_1} [DecidableEq α] {a : α} {l : List α} (h : ¬a ∈ l.dedup) :
(a :: l).dedup = a :: l.deduph
huList.dedup_cons_of_not_mem'}(hj5  hQhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Dedup.htmlhtheorem List.dedup_cons_of_not_mem' {α : Type u_1} [DecidableEq α] {a : α} {l : List α} (h : ¬a ∈ l.dedup) :
(a :: l).dedup = a :: l.deduph
$Alias of List.dedup_cons_of_notMem'.uList.mem_dedup}(hj5  hQhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Dedup.htmlhjtheorem List.mem_dedup {α : Type u_1} [DecidableEq α] {a : α} {l : List α} :
a ∈ l.dedup ↔ a ∈ lh
huList.dedup_cons_of_mem}(hj5  hQhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Dedup.htmlhtheorem List.dedup_cons_of_mem {α : Type u_1} [DecidableEq α] {a : α} {l : List α} (h : a ∈ l) :
(a :: l).dedup = l.deduph
huList.dedup_cons_of_notMem}(hj5  hQhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Dedup.htmlhtheorem List.dedup_cons_of_notMem {α : Type u_1} [DecidableEq α] {a : α} {l : List α} (h : ¬a ∈ l) :
(a :: l).dedup = a :: l.deduph
huList.dedup_cons_of_not_mem}(hj5  hQhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Dedup.htmlhtheorem List.dedup_cons_of_not_mem {α : Type u_1} [DecidableEq α] {a : α} {l : List α} (h : ¬a ∈ l) :
(a :: l).dedup = a :: l.deduph
#Alias of List.dedup_cons_of_notMem.uList.dedup_sublist}(hj5  hQhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Dedup.htmlh]theorem List.dedup_sublist {α : Type u_1} [DecidableEq α] (l : List α) :
l.dedup.Sublist lh
huList.dedup_subset}(hj5  hQhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Dedup.htmlhXtheorem List.dedup_subset {α : Type u_1} [DecidableEq α] (l : List α) :
l.dedup ⊆ lh
huList.subset_dedup}(hj5  hQhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Dedup.htmlhXtheorem List.subset_dedup {α : Type u_1} [DecidableEq α] (l : List α) :
l ⊆ l.deduph
huList.nodup_dedup}(hj5  hQhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Dedup.htmlhWtheorem List.nodup_dedup {α : Type u_1} [DecidableEq α] (l : List α) :
l.dedup.Noduph
huList.headI_dedup}(hj5  hQhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Dedup.htmlhtheorem List.headI_dedup {α : Type u_1} [DecidableEq α] [Inhabited α] (l : List α) :
l.dedup.headI = if l.headI ∈ l.tail then l.tail.dedup.headI else l.headIh
huList.tail_dedup}(hj6  hQhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Dedup.htmlhtheorem List.tail_dedup {α : Type u_1} [DecidableEq α] [Inhabited α] (l : List α) :
l.dedup.tail = if l.headI ∈ l.tail then l.tail.dedup.tail else l.tail.deduph
huList.dedup_eq_self}(hj6  hQhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Dedup.htmlhctheorem List.dedup_eq_self {α : Type u_1} [DecidableEq α] {l : List α} :
l.dedup = l ↔ l.Noduph
huList.dedup_eq_cons}(hj	6  hQhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Dedup.htmlhtheorem List.dedup_eq_cons {α : Type u_1} [DecidableEq α] (l : List α) (a : α) (l' : List α) :
l.dedup = a :: l' ↔ a ∈ l ∧ ¬a ∈ l' ∧ l.dedup.tail = l'h
huList.dedup_eq_nil}(hj
6  hQhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Dedup.htmlhbtheorem List.dedup_eq_nil {α : Type u_1} [DecidableEq α] (l : List α) :
l.dedup = [] ↔ l = []h
huList.dedup_idem}(hj6  hQhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Dedup.htmlh`theorem List.dedup_idem {α : Type u_1} [DecidableEq α] {l : List α} :
l.dedup.dedup = l.deduph
huList.dedup_append}(hj6  hQhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Dedup.htmlh}theorem List.dedup_append {α : Type u_1} [DecidableEq α] (l₁ l₂ : List α) :
(l₁ ++ l₂).dedup = l₁ ∪ l₂.deduph
huList.dedup_map_of_injective}(hj6  hQhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Dedup.htmlhtheorem List.dedup_map_of_injective {α : Type u_1} {β : Type u_2} [DecidableEq α] [DecidableEq β] {f : α → β} (hf : Function.Injective f) (xs : List α) :
(map f xs).dedup = map f xs.deduph
huList.replicate_dedup}(hj6  hQhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Dedup.htmlhztheorem List.replicate_dedup {α : Type u_1} [DecidableEq α] {x : α} {k : ℕ} :
k ≠ 0 → (replicate k x).dedup = [x]h
huList.count_dedup}(hj!6  hQhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Dedup.htmlh}theorem List.count_dedup {α : Type u_1} [DecidableEq α] (l : List α) (a : α) :
count a l.dedup = if a ∈ l then 1 else 0h
hu
List.rdrop}(hj%6  hUhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/DropRight.htmlh@def List.rdrop {α : Type u_1} (l : List α) (n : ℕ) :
List αh
,Drop n elements from the tail end of a list.uList.rdrop_nil}(hj*6  hUhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/DropRight.htmlhBtheorem List.rdrop_nil {α : Type u_1} (n : ℕ) :
[].rdrop n = []h
huList.rdrop_zero}(hj.6  hUhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/DropRight.htmlhEtheorem List.rdrop_zero {α : Type u_1} (l : List α) :
l.rdrop 0 = lh
hu"List.rdrop_eq_reverse_drop_reverse}(hj26  hUhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/DropRight.htmlh{theorem List.rdrop_eq_reverse_drop_reverse {α : Type u_1} (l : List α) (n : ℕ) :
l.rdrop n = (drop n l.reverse).reverseh
huList.rdrop_concat_succ}(hj66  hUhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/DropRight.htmlhvtheorem List.rdrop_concat_succ {α : Type u_1} (l : List α) (n : ℕ) (x : α) :
(l ++ [x]).rdrop (n + 1) = l.rdrop nh
hu
List.rtake}(hj:6  hUhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/DropRight.htmlh@def List.rtake {α : Type u_1} (l : List α) (n : ℕ) :
List αh
,Take n elements from the tail end of a list.uList.rtake_nil}(hj?6  hUhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/DropRight.htmlhBtheorem List.rtake_nil {α : Type u_1} (n : ℕ) :
[].rtake n = []h
huList.rtake_zero}(hjC6  hUhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/DropRight.htmlhFtheorem List.rtake_zero {α : Type u_1} (l : List α) :
l.rtake 0 = []h
hu"List.rtake_eq_reverse_take_reverse}(hjG6  hUhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/DropRight.htmlh{theorem List.rtake_eq_reverse_take_reverse {α : Type u_1} (l : List α) (n : ℕ) :
l.rtake n = (take n l.reverse).reverseh
huList.rtake_concat_succ}(hjK6  hUhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/DropRight.htmlh}theorem List.rtake_concat_succ {α : Type u_1} (l : List α) (n : ℕ) (x : α) :
(l ++ [x]).rtake (n + 1) = l.rtake n ++ [x]h
huList.rdropWhile}(hjO6  hUhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/DropRight.htmlhMdef List.rdropWhile {α : Type u_1} (p : α → Bool) (l : List α) :
List αh
lDrop elements from the tail end of a list that satisfy p : α → Bool. Implemented naively via List.reverseuList.rdropWhile_nil}(hjT6  hUhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/DropRight.htmlhTtheorem List.rdropWhile_nil {α : Type u_1} (p : α → Bool) :
rdropWhile p [] = []h
huList.rdropWhile_concat}(hjX6  hUhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/DropRight.htmlhtheorem List.rdropWhile_concat {α : Type u_1} (p : α → Bool) (l : List α) (x : α) :
rdropWhile p (l ++ [x]) = if p x = true then rdropWhile p l else l ++ [x]h
huList.rdropWhile_concat_pos}(hj\6  hUhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/DropRight.htmlhtheorem List.rdropWhile_concat_pos {α : Type u_1} (p : α → Bool) (l : List α) (x : α) (h : p x = true) :
rdropWhile p (l ++ [x]) = rdropWhile p lh
huList.rdropWhile_concat_neg}(hj`6  hUhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/DropRight.htmlhtheorem List.rdropWhile_concat_neg {α : Type u_1} (p : α → Bool) (l : List α) (x : α) (h : ¬p x = true) :
rdropWhile p (l ++ [x]) = l ++ [x]h
huList.rdropWhile_singleton}(hjd6  hUhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/DropRight.htmlhtheorem List.rdropWhile_singleton {α : Type u_1} (p : α → Bool) (x : α) :
rdropWhile p [x] = if p x = true then [] else [x]h
huList.rdropWhile_last_not}(hjh6  hUhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/DropRight.htmlhtheorem List.rdropWhile_last_not {α : Type u_1} (p : α → Bool) (l : List α) (hl : rdropWhile p l ≠ []) :
¬p ((rdropWhile p l).getLast hl) = trueh
huList.rdropWhile_prefix}(hjl6  hUhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/DropRight.htmlhetheorem List.rdropWhile_prefix {α : Type u_1} (p : α → Bool) (l : List α) :
rdropWhile p l <+: lh
huList.rdropWhile_eq_nil_iff}(hjp6  hUhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/DropRight.htmlhtheorem List.rdropWhile_eq_nil_iff {α : Type u_1} {p : α → Bool} {l : List α} :
rdropWhile p l = [] ↔ ∀ (x : α), x ∈ l → p x = trueh
huList.rdropWhile_eq_self_iff}(hjt6  hUhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/DropRight.htmlhtheorem List.rdropWhile_eq_self_iff {α : Type u_1} {p : α → Bool} {l : List α} :
rdropWhile p l = l ↔ ∀ (hl : l ≠ []), ¬p (l.getLast hl) = trueh
huList.dropWhile_idempotent}(hjx6  hUhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/DropRight.htmlhtheorem List.dropWhile_idempotent {α : Type u_1} (p : α → Bool) (l : List α) :
dropWhile p (dropWhile p l) = dropWhile p lh
huList.rdropWhile_idempotent}(hj|6  hUhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/DropRight.htmlhtheorem List.rdropWhile_idempotent {α : Type u_1} (p : α → Bool) (l : List α) :
rdropWhile p (rdropWhile p l) = rdropWhile p lh
huList.rdropWhile_reverse}(hj6  hUhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/DropRight.htmlhtheorem List.rdropWhile_reverse {α : Type u_1} (p : α → Bool) (l : List α) :
rdropWhile p l.reverse = (dropWhile p l).reverseh
huList.rtakeWhile}(hj6  hUhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/DropRight.htmlhMdef List.rtakeWhile {α : Type u_1} (p : α → Bool) (l : List α) :
List αh
lTake elements from the tail end of a list that satisfy p : α → Bool. Implemented naively via List.reverseuList.rtakeWhile_nil}(hj6  hUhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/DropRight.htmlhTtheorem List.rtakeWhile_nil {α : Type u_1} (p : α → Bool) :
rtakeWhile p [] = []h
huList.rtakeWhile_concat}(hj6  hUhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/DropRight.htmlhtheorem List.rtakeWhile_concat {α : Type u_1} (p : α → Bool) (l : List α) (x : α) :
rtakeWhile p (l ++ [x]) = if p x = true then rtakeWhile p l ++ [x] else []h
huList.rtakeWhile_concat_pos}(hj6  hUhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/DropRight.htmlhtheorem List.rtakeWhile_concat_pos {α : Type u_1} (p : α → Bool) (l : List α) (x : α) (h : p x = true) :
rtakeWhile p (l ++ [x]) = rtakeWhile p l ++ [x]h
huList.rtakeWhile_concat_neg}(hj6  hUhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/DropRight.htmlhtheorem List.rtakeWhile_concat_neg {α : Type u_1} (p : α → Bool) (l : List α) (x : α) (h : ¬p x = true) :
rtakeWhile p (l ++ [x]) = []h
huList.rtakeWhile_suffix}(hj6  hUhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/DropRight.htmlhetheorem List.rtakeWhile_suffix {α : Type u_1} (p : α → Bool) (l : List α) :
rtakeWhile p l <:+ lh
huList.rtakeWhile_eq_self_iff}(hj6  hUhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/DropRight.htmlhtheorem List.rtakeWhile_eq_self_iff {α : Type u_1} {p : α → Bool} {l : List α} :
rtakeWhile p l = l ↔ ∀ (x : α), x ∈ l → p x = trueh
huList.rtakeWhile_eq_nil_iff}(hj6  hUhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/DropRight.htmlhtheorem List.rtakeWhile_eq_nil_iff {α : Type u_1} {p : α → Bool} {l : List α} :
rtakeWhile p l = [] ↔ ∀ (hl : l ≠ []), ¬p (l.getLast hl) = trueh
huList.mem_rtakeWhile_imp}(hj6  hUhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/DropRight.htmlhtheorem List.mem_rtakeWhile_imp {α : Type u_1} {p : α → Bool} {l : List α} {x : α} (hx : x ∈ rtakeWhile p l) :
p x = trueh
huList.rtakeWhile_idempotent}(hj6  hUhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/DropRight.htmlhtheorem List.rtakeWhile_idempotent {α : Type u_1} (p : α → Bool) (l : List α) :
rtakeWhile p (rtakeWhile p l) = rtakeWhile p lh
huList.rtakeWhile_reverse}(hj6  hUhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/DropRight.htmlhtheorem List.rtakeWhile_reverse {α : Type u_1} {p : α → Bool} {l : List α} :
rtakeWhile p l.reverse = (takeWhile p l).reverseh
hu!List.rdropWhile_append_rtakeWhile}(hj6  hUhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/DropRight.htmlhtheorem List.rdropWhile_append_rtakeWhile {α : Type u_1} {p : α → Bool} {l : List α} :
rdropWhile p l ++ rtakeWhile p l = lh
huList.rdrop_add}(hj6  hUhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/DropRight.htmlhhtheorem List.rdrop_add {α : Type u_1} {l : List α} (i j : ℕ) :
(l.rdrop i).rdrop j = l.rdrop (i + j)h
huList.rdrop_append_length}(hj6  hUhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/DropRight.htmlhptheorem List.rdrop_append_length {α : Type u_1} {l₁ l₂ : List α} :
(l₁ ++ l₂).rdrop l₂.length = l₁h
huList.rdrop_append_of_le_length}(hj6  hUhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/DropRight.htmlhtheorem List.rdrop_append_of_le_length {α : Type u_1} {l₁ l₂ : List α} (k : ℕ) :
k ≤ l₂.length → (l₁ ++ l₂).rdrop k = l₁ ++ l₂.rdrop kh
huList.rdrop_append_length_add}(hj6  hUhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/DropRight.htmlhtheorem List.rdrop_append_length_add {α : Type u_1} {l₁ l₂ : List α} (k : ℕ) :
(l₁ ++ l₂).rdrop (l₂.length + k) = l₁.rdrop kh
huList.destutter'_nil}(hj6  hUhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Destutter.htmlhxtheorem List.destutter'_nil {α : Type u_1} (R : α → α → Prop) [DecidableRel R] {a : α} :
destutter' R a [] = [a]h
huList.destutter'_cons}(hj6  hUhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Destutter.htmlhtheorem List.destutter'_cons {α : Type u_1} (l : List α) (R : α → α → Prop) [DecidableRel R] {a b : α} :
destutter' R a (b :: l) = if R a b then a :: destutter' R b l else destutter' R a lh
huList.destutter'_cons_pos}(hj6  hUhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Destutter.htmlhtheorem List.destutter'_cons_pos {α : Type u_1} (l : List α) {R : α → α → Prop} [DecidableRel R] {a b : α} (h : R b a) :
destutter' R b (a :: l) = b :: destutter' R a lh
huList.destutter'_cons_neg}(hj6  hUhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Destutter.htmlhtheorem List.destutter'_cons_neg {α : Type u_1} (l : List α) {R : α → α → Prop} [DecidableRel R] {a b : α} (h : ¬R b a) :
destutter' R b (a :: l) = destutter' R b lh
huList.destutter'_singleton}(hj6  hUhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Destutter.htmlhtheorem List.destutter'_singleton {α : Type u_1} (R : α → α → Prop) [DecidableRel R] {a b : α} :
destutter' R a [b] = if R a b then [a, b] else [a]h
huList.destutter'_sublist}(hj6  hUhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Destutter.htmlhtheorem List.destutter'_sublist {α : Type u_1} (l : List α) (R : α → α → Prop) [DecidableRel R] (a : α) :
(destutter' R a l).Sublist (a :: l)h
huList.mem_destutter'}(hj6  hUhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Destutter.htmlhtheorem List.mem_destutter' {α : Type u_1} (l : List α) (R : α → α → Prop) [DecidableRel R] (a : α) :
a ∈ destutter' R a lh
huList.destutter'_is_chain}(hj6  hUhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Destutter.htmlhtheorem List.destutter'_is_chain {α : Type u_1} (R : α → α → Prop) [DecidableRel R] (l : List α) {a b : α} :
R a b → Chain R a (destutter' R b l)h
huList.destutter'_is_chain'}(hj6  hUhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Destutter.htmlhtheorem List.destutter'_is_chain' {α : Type u_1} (l : List α) (R : α → α → Prop) [DecidableRel R] (a : α) :
Chain' R (destutter' R a l)h
huList.destutter'_of_chain}(hj6  hUhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Destutter.htmlhtheorem List.destutter'_of_chain {α : Type u_1} (l : List α) (R : α → α → Prop) [DecidableRel R] {a : α} (h : Chain R a l) :
destutter' R a l = a :: lh
huList.destutter'_eq_self_iff}(hj6  hUhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Destutter.htmlhtheorem List.destutter'_eq_self_iff {α : Type u_1} (l : List α) (R : α → α → Prop) [DecidableRel R] (a : α) :
destutter' R a l = a :: l ↔ Chain R a lh
huList.destutter'_ne_nil}(hj6  hUhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Destutter.htmlhtheorem List.destutter'_ne_nil {α : Type u_1} (l : List α) (R : α → α → Prop) [DecidableRel R] {a : α} :
destutter' R a l ≠ []h
huList.destutter_nil}(hj6  hUhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Destutter.htmlhjtheorem List.destutter_nil {α : Type u_1} (R : α → α → Prop) [DecidableRel R] :
destutter R [] = []h
huList.destutter_cons'}(hj6  hUhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Destutter.htmlhtheorem List.destutter_cons' {α : Type u_1} (l : List α) (R : α → α → Prop) [DecidableRel R] {a : α} :
destutter R (a :: l) = destutter' R a lh
huList.destutter_cons_cons}(hj6  hUhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Destutter.htmlhtheorem List.destutter_cons_cons {α : Type u_1} (l : List α) (R : α → α → Prop) [DecidableRel R] {a b : α} :
destutter R (a :: b :: l) = if R a b then a :: destutter' R b l else destutter' R a lh
huList.destutter_singleton}(hj7  hUhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Destutter.htmlh{theorem List.destutter_singleton {α : Type u_1} (R : α → α → Prop) [DecidableRel R] {a : α} :
destutter R [a] = [a]h
huList.destutter_pair}(hj7  hUhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Destutter.htmlhtheorem List.destutter_pair {α : Type u_1} (R : α → α → Prop) [DecidableRel R] {a b : α} :
destutter R [a, b] = if R a b then [a, b] else [a]h
huList.destutter_sublist}(hj	7  hUhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Destutter.htmlhtheorem List.destutter_sublist {α : Type u_1} (R : α → α → Prop) [DecidableRel R] (l : List α) :
(destutter R l).Sublist lh
huList.destutter_is_chain'}(hj
7  hUhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Destutter.htmlhtheorem List.destutter_is_chain' {α : Type u_1} (R : α → α → Prop) [DecidableRel R] (l : List α) :
Chain' R (destutter R l)h
huList.destutter_of_chain'}(hj7  hUhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Destutter.htmlhtheorem List.destutter_of_chain' {α : Type u_1} (R : α → α → Prop) [DecidableRel R] (l : List α) :
Chain' R l → destutter R l = lh
huList.destutter_eq_self_iff}(hj7  hUhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Destutter.htmlhtheorem List.destutter_eq_self_iff {α : Type u_1} (R : α → α → Prop) [DecidableRel R] (l : List α) :
destutter R l = l ↔ Chain' R lh
huList.destutter_idem}(hj7  hUhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Destutter.htmlhtheorem List.destutter_idem {α : Type u_1} (l : List α) (R : α → α → Prop) [DecidableRel R] :
destutter R (destutter R l) = destutter R lh
huList.destutter_eq_nil}(hj7  hUhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Destutter.htmlhtheorem List.destutter_eq_nil {α : Type u_1} (R : α → α → Prop) [DecidableRel R] {l : List α} :
destutter R l = [] ↔ l = []h
huList.map_destutter}(hj!7  hUhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Destutter.htmlhX<  theorem List.map_destutter {α : Type u_1} {β : Type u_2} {R : α → α → Prop} [DecidableRel R] {R₂ : β → β → Prop} [DecidableRel R₂] {f : α → β} {l : List α} :
(∀ (a : α), a ∈ l → ∀ (b : α), b ∈ l → (R a b ↔ R₂ (f a) (f b))) → map f (destutter R l) = destutter R₂ (map f l)h
;For a relation-preserving map, destutter commutes with map.uList.map_destutter_ne}(hj&7  hUhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Destutter.htmlhX  theorem List.map_destutter_ne {α : Type u_1} {β : Type u_2} (l : List α) {f : α → β} (h : Function.Injective f) [DecidableEq α] [DecidableEq β] :
map f (destutter (fun (x1 x2 : α) => x1 ≠ x2) l) = destutter (fun (x1 x2 : β) => x1 ≠ x2) (map f l)h
EFor a injective function f, destutter' (·≠·) commutes with map f.u!List.length_destutter'_cotrans_ge}(hj+7  hUhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Destutter.htmlhtheorem List.length_destutter'_cotrans_ge {α : Type u_1} {R : α → α → Prop} [DecidableRel R] {b : α} [i : IsTrans α Rᶜ] {a : α} {l : List α} :
¬R b a → (destutter' R b l).length ≤ (destutter' R a l).lengthh
destutter' on a relation like ≠ or <, whose negation is transitive, has length monotone under a ¬R changing of the first element.uList.length_destutter'_congr}(hj07  hUhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Destutter.htmlhtheorem List.length_destutter'_congr {α : Type u_1} (l : List α) {R : α → α → Prop} [DecidableRel R] {a b : α} [IsEquiv α Rᶜ] (hab : ¬R a b) :
(destutter' R a l).length = (destutter' R b l).lengthh
List.destutter' on a relation like ≠, whose negation is an equivalence, gives the same length if the first elements are not related.uList.le_length_destutter'_cons}(hj57  hUhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Destutter.htmlhtheorem List.le_length_destutter'_cons {α : Type u_1} {R : α → α → Prop} [DecidableRel R] {a b : α} [IsEquiv α Rᶜ] {l : List α} :
(destutter' R b l).length ≤ (destutter' R a (b :: l)).lengthh
nList.destutter' on a relation like ≠, whose negation is an equivalence, has length monotonic under List.consu.List.length_destutter_le_length_destutter_cons}(hj:7  hUhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Destutter.htmlhtheorem List.length_destutter_le_length_destutter_cons {α : Type u_1} {R : α → α → Prop} [DecidableRel R] {a : α} [IsEquiv α Rᶜ] {l : List α} :
(destutter R l).length ≤ (destutter R (a :: l)).lengthh
lList.destutter on a relation like ≠, whose negation is an equivalence, has length monotone under List.consu1List.length_destutter_ne_le_length_destutter_cons}(hj?7  hUhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Destutter.htmlhtheorem List.length_destutter_ne_le_length_destutter_cons {α : Type u_1} {l : List α} {a : α} [DecidableEq α] :
(destutter (fun (x1 x2 : α) => x1 ≠ x2) l).length ≤ (destutter (fun (x1 x2 : α) => x1 ≠ x2) (a :: l)).lengthh
2destutter ≠ has length monotone under List.cons.uList.Duplicate}(hjD7  hUhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Duplicate.htmlhDinductive List.Duplicate {α : Type u_1} (x : α) :
List α → Proph
WProperty that an element x : α of l : List α can be found in the list more than once.uList.duplicate_cons_self_iff}(hjI7  hUhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Duplicate.htmlhntheorem List.duplicate_cons_self_iff {α : Type u_1} {l : List α} {x : α} :
Duplicate x (x :: l) ↔ x ∈ lh
huList.not_duplicate_nil}(hjM7  hUhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Duplicate.htmlhJtheorem List.not_duplicate_nil {α : Type u_1} (x : α) :
¬Duplicate x []h
huList.not_duplicate_singleton}(hjQ7  hUhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Duplicate.htmlhStheorem List.not_duplicate_singleton {α : Type u_1} (x y : α) :
¬Duplicate x [y]h
huList.duplicate_cons_iff}(hjU7  hUhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Duplicate.htmlhtheorem List.duplicate_cons_iff {α : Type u_1} {l : List α} {x y : α} :
Duplicate x (y :: l) ↔ y = x ∧ x ∈ l ∨ Duplicate x lh
huList.duplicate_cons_iff_of_ne}(hjY7  hUhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Duplicate.htmlhtheorem List.duplicate_cons_iff_of_ne {α : Type u_1} {l : List α} {x y : α} (hne : x ≠ y) :
Duplicate x (y :: l) ↔ Duplicate x lh
huList.duplicate_iff_sublist}(hj]7  hUhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Duplicate.htmlhntheorem List.duplicate_iff_sublist {α : Type u_1} {l : List α} {x : α} :
Duplicate x l ↔ [x, x].Sublist lh
-The contrapositive of List.nodup_iff_sublist.u#List.nodup_iff_forall_not_duplicate}(hjb7  hUhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Duplicate.htmlhutheorem List.nodup_iff_forall_not_duplicate {α : Type u_1} {l : List α} :
l.Nodup ↔ ∀ (x : α), ¬Duplicate x lh
hu#List.exists_duplicate_iff_not_nodup}(hjf7  hUhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Duplicate.htmlhwtheorem List.exists_duplicate_iff_not_nodup {α : Type u_1} {l : List α} :
(∃ (x : α), Duplicate x l) ↔ ¬l.Noduph
huList.duplicate_iff_two_le_count}(hjj7  hUhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Duplicate.htmlhtheorem List.duplicate_iff_two_le_count {α : Type u_1} {l : List α} {x : α} [DecidableEq α] :
Duplicate x l ↔ 2 ≤ count x lh
huList.decidableDuplicate}(hjn7  hUhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Duplicate.htmlhtinstance List.decidableDuplicate {α : Type u_1} [DecidableEq α] (x : α) (l : List α) :
Decidable (Duplicate x l)h
huList.forall_mem_zipIdx}(hjr7  hPhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Enum.htmlhtheorem List.forall_mem_zipIdx {α : Type u_1} {l : List α} {n : ℕ} {p : α × ℕ → Prop} :
(∀ (x : α × ℕ), x ∈ l.zipIdx n → p x) ↔ ∀ (i : ℕ) (x : i < l.length), p (l[i], n + i)h
huList.forall_mem_zipIdx'}(hjv7  hPhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Enum.htmlhtheorem List.forall_mem_zipIdx' {α : Type u_1} {l : List α} {p : α × ℕ → Prop} :
(∀ (x : α × ℕ), x ∈ l.zipIdx → p x) ↔ ∀ (i : ℕ) (x : i < l.length), p (l[i], i)h
GVariant of forall_mem_zipIdx with the zipIdx argument specialized to 0.uList.exists_mem_zipIdx}(hj{7  hPhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Enum.htmlhtheorem List.exists_mem_zipIdx {α : Type u_1} {l : List α} {n : ℕ} {p : α × ℕ → Prop} :
(∃ (x : α × ℕ), x ∈ l.zipIdx n ∧ p x) ↔ ∃ (i : ℕ), ∃ (x : i < l.length), p (l[i], n + i)h
huList.exists_mem_zipIdx'}(hj7  hPhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Enum.htmlhtheorem List.exists_mem_zipIdx' {α : Type u_1} {l : List α} {p : α × ℕ → Prop} :
(∃ (x : α × ℕ), x ∈ l.zipIdx ∧ p x) ↔ ∃ (i : ℕ), ∃ (x : i < l.length), p (l[i], i)h
GVariant of exists_mem_zipIdx with the zipIdx argument specialized to 0.u#List.instSDiffOfDecidableEq_mathlib}(hj7  hPhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Defs.htmlh_instance List.instSDiffOfDecidableEq_mathlib {α : Type u_1} [DecidableEq α] :
SDiff (List α)h
hu	List.getI}(hj7  hPhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Defs.htmlhIdef List.getI {α : Type u_1} [Inhabited α] (l : List α) (n : ℕ) :
αh
f"Inhabited" get function: returns default instead of none in the case that the index is out of bounds.u
List.headI}(hj7  hPhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Defs.htmlh>def List.headI {α : Type u_1} [Inhabited α] :
List α → αh
JThe head of a list, or the default element of the type is the list is nil.uList.headI_nil}(hj7  hPhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Defs.htmlhJtheorem List.headI_nil {α : Type u_1} [Inhabited α] :
[].headI = defaulth
huList.headI_cons}(hj7  hPhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Defs.htmlhbtheorem List.headI_cons {α : Type u_1} [Inhabited α] {h : α} {t : List α} :
(h :: t).headI = hh
hu
List.getLastI}(hj7  hPhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Defs.htmlhAdef List.getLastI {α : Type u_1} [Inhabited α] :
List α → αh
:The last element of a list, with the default if list emptyu
List.takeI}(hj7  hPhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Defs.htmlhOdef List.takeI {α : Type u_1} [Inhabited α] (n : ℕ) (l : List α) :
List αh
~"Inhabited" take function: Take n elements from a list l. If l has less than n elements, append n - length l elements default.u
List.findM}(hj7  hPhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Defs.htmlhndef List.findM {α : Type u} {m : Type u → Type v} [Alternative m] (tac : α → m PUnit) :
List α → m αh
VfindM tac l returns the first element of l on which tac succeeds, and fails otherwise.uList.findM?'}(hj7  hPhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Defs.htmlhxdef List.findM?' {m : Type u → Type v} [Monad m] {α : Type u} (p : α → m (ULift Bool)) :
List α → m (Option α)h
findM? p l returns the first element a of l for which p a returns true. findM? short-circuits, so p is not necessarily run on every a in l. This is a monadic version of List.find.uList.orM}(hj7  hPhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Defs.htmlhGdef List.orM {m : Type → Type v} [Monad m] :
List (m Bool) → m Boolh
orM xs runs the actions in xs, returning true if any of them returns true. orM short-circuits, so if an action returns true, later actions are not run.u	List.andM}(hj7  hPhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Defs.htmlhHdef List.andM {m : Type → Type v} [Monad m] :
List (m Bool) → m Boolh
andM xs runs the actions in xs, returning true if all of them return true. andM short-circuits, so if an action returns false, later actions are not run.uList.foldlIdxM}(hj7  hPhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Defs.htmlhdef List.foldlIdxM {m : Type v → Type w} [Monad m] {α : Type u_7} {β : Type v} (f : ℕ → β → α → m β) (b : β) (as : List α) :
m βh
Monadic variant of foldlIdx.uList.foldrIdxM}(hj7  hPhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Defs.htmlhdef List.foldrIdxM {m : Type v → Type w} [Monad m] {α : Type u_7} {β : Type v} (f : ℕ → α → β → m β) (b : β) (as : List α) :
m βh
Monadic variant of foldrIdx.uList.mapIdxMAux'}(hj7  hPhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Defs.htmlhdef List.mapIdxMAux' {m : Type v → Type w} [Monad m] {α : Type u_7} (f : ℕ → α → m PUnit) :
ℕ → List α → m PUnith
"Auxiliary definition for mapIdxM'.u
List.mapIdxM'}(hj7  hPhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Defs.htmlhydef List.mapIdxM' {m : Type v → Type w} [Monad m] {α : Type u_7} (f : ℕ → α → m PUnit) (as : List α) :
m PUnith
JA variant of mapIdxM specialised to applicative actions which return Unit.uList.Forall}(hj7  hPhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Defs.htmlhDdef List.Forall {α : Type u_1} (p : α → Prop) :
List α → Proph
l.Forall p is equivalent to ∀ a ∈ l, p a, but unfolds directly to a conjunction, i.e. List.Forall p [0, 1, 2] = p 0 ∧ p 1 ∧ p 2.uList.permutationsAux2}(hj7  hPhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Defs.htmlhdef List.permutationsAux2 {α : Type u_1} {β : Type u_2} (t : α) (ts : List α) (r : List β) :
List α → (List α → β) → List α × List βh
X  An auxiliary function for defining permutations. permutationsAux2 t ts r ys f is equal to (ys ++ ts, (insert_left ys t ts).map f ++ r), where insert_left ys t ts (not explicitly defined) is the list of lists of the form insert_nth n t (ys ++ ts) for 0 ≤ n < length ys.uList.permutationsAux}(hj7  hPhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Defs.htmlhQdef List.permutationsAux {α : Type u_1} :
List α → List α → List (List α)h
An auxiliary function for defining permutations. permutationsAux ts is is the set of all permutations of is ++ ts that do not fix ts.uList.permutations}(hj7  hPhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Defs.htmlhDdef List.permutations {α : Type u_1} (l : List α) :
List (List α)h
zList of all permutations of l.
permutations [1, 2, 3] = [[1, 2, 3], [2, 1, 3], [3, 2, 1], [2, 3, 1], [3, 1, 2], [1, 3, 2]]uList.permutations'Aux}(hj7  hPhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Defs.htmlhOdef List.permutations'Aux {α : Type u_1} (t : α) :
List α → List (List α)h
XE  permutations'Aux t ts inserts t into every position in ts, including the last. This function is intended for use in specifications, so it is simpler than permutationsAux2, which plays roughly the same role in permutations.
Note that (permutationsAux2 t [] [] ts id).2 is similar to this function, but skips the last position:uList.permutations'}(hj7  hPhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Defs.htmlhCdef List.permutations' {α : Type u_1} :
List α → List (List α)h
List of all permutations of l. This version of permutations is less efficient but has simpler definitional equations. The permutations are in a different order, but are equal up to permutation, as shown by List.permutations_perm_permutations'.u
List.extractp}(hj7  hPhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Defs.htmlhhdef List.extractp {α : Type u_1} (p : α → Prop) [DecidablePred p] :
List α → Option α × List αh
extractp p l returns a pair of an element a of l satisfying the predicate p, and l, with a removed. If there is no such element a it returns (none, l).uList.instSProd}(hj7  hPhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Defs.htmlheinstance List.instSProd {α : Type u_1} {β : Type u_2} :
SProd (List α) (List β) (List (α × β))h
.Notation for calculating the product of a ListuList.decidableChain}(hj7  hPhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Defs.htmlhinstance List.decidableChain {α : Type u_1} {R : α → α → Prop} [DecidableRel R] (a : α) (l : List α) :
Decidable (Chain R a l)h
huList.decidableChain'}(hj7  hPhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Defs.htmlh~instance List.decidableChain' {α : Type u_1} {R : α → α → Prop} [DecidableRel R] (l : List α) :
Decidable (Chain' R l)h
hu
List.dedup}(hj7  hPhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Defs.htmlhEdef List.dedup {α : Type u_1} [DecidableEq α] :
List α → List αh
dedup l removes duplicates from l (taking only the last occurrence). Defined as pwFilter (≠).
dedup [1, 0, 2, 2, 1] = [0, 2, 1]uList.destutter'}(hj8  hPhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Defs.htmlhjdef List.destutter' {α : Type u_1} (R : α → α → Prop) [DecidableRel R] :
α → List α → List αh
X  Greedily create a sublist of a :: l such that, for every two adjacent elements a, b, R a b holds. Mostly used with ≠; for example, destutter' (≠) 1 [2, 2, 1, 1] = [1, 2, 1], destutter' (≠) 1, [2, 3, 3] = [1, 2, 3], destutter' (<) 1 [2, 5, 2, 3, 4, 9] = [1, 2, 5, 9].uList.destutter}(hj8  hPhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Defs.htmlhbdef List.destutter {α : Type u_1} (R : α → α → Prop) [DecidableRel R] :
List α → List αh
X  Greedily create a sublist of l such that, for every two adjacent elements a, b ∈ l, R a b holds. Mostly used with ≠; for example, destutter (≠) [1, 2, 2, 1, 1] = [1, 2, 1], destutter (≠) [1, 2, 3, 3] = [1, 2, 3], destutter (<) [1, 2, 5, 2, 3, 4, 9] = [1, 2, 5, 9].uList.chooseX}(hj8  hPhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Defs.htmlhdef List.chooseX {α : Type u_1} (p : α → Prop) [DecidablePred p] (l : List α) :
(∃ (a : α), a ∈ l ∧ p a) → { a : α // a ∈ l ∧ p a }h
Given a decidable predicate p and a proof of existence of a ∈ l such that p a, choose the first element with this property. This version returns both a and proofs of a ∈ l and p a.uList.choose}(hj8  hPhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Defs.htmlh{def List.choose {α : Type u_1} (p : α → Prop) [DecidablePred p] (l : List α) (hp : ∃ (a : α), a ∈ l ∧ p a) :
αh
Given a decidable predicate p and a proof of existence of a ∈ l such that p a, choose the first element with this property. This version returns a : α, and properties are given by choose_mem and choose_property.uList.mapDiagM'}(hj8  hPhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Defs.htmlhtdef List.mapDiagM' {m : Type → Type u_7} [Monad m] {α : Type u_8} (f : α → α → m Unit) :
List α → m Unith
X'  mapDiagM' f l calls f on all elements in the upper triangular part of l × l. That is, for each e ∈ l, it will run f e e and then f e e' for each e' that appears after e in l.
Example: suppose l = [1, 2, 3]. mapDiagM' f l will evaluate, in this order, f 1 1, f 1 2, f 1 3, f 2 2, f 2 3, f 3 3.uList.map₂Left'}(hj8  hPhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Defs.htmlhdef List.map₂Left' {α : Type u_1} {β : Type u_2} {γ : Type u_3} (f : α → Option β → γ) :
List α → List β → List γ × List βh
Left-biased version of List.map₂. map₂Left' f as bs applies f to each pair of elements aᵢ ∈ as and bᵢ ∈ bs. If bs is shorter than as, f is applied to none for the remaining aᵢ. Returns the results of the f applications and the remaining bs.uList.map₂Right'}(hj8  hPhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Defs.htmlhdef List.map₂Right' {α : Type u_1} {β : Type u_2} {γ : Type u_3} (f : Option α → β → γ) (as : List α) (bs : List β) :
List γ × List αh
X   Right-biased version of List.map₂. map₂Right' f as bs applies f to each pair of elements aᵢ ∈ as and bᵢ ∈ bs. If as is shorter than bs, f is applied to none for the remaining bᵢ. Returns the results of the f applications and the remaining as.uList.map₂Left}(hj$8  hPhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Defs.htmlhdef List.map₂Left {α : Type u_1} {β : Type u_2} {γ : Type u_3} (f : α → Option β → γ) :
List α → List β → List γh
Left-biased version of List.map₂. map₂Left f as bs applies f to each pair aᵢ ∈ as and bᵢ ∈ bs. If bs is shorter than as, f is applied to none for the remaining aᵢ.uList.map₂Right}(hj)8  hPhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Defs.htmlhdef List.map₂Right {α : Type u_1} {β : Type u_2} {γ : Type u_3} (f : Option α → β → γ) (as : List α) (bs : List β) :
List γh
Right-biased version of List.map₂. map₂Right f as bs applies f to each pair aᵢ ∈ as and bᵢ ∈ bs. If as is shorter than bs, f is applied to none for the remaining bᵢ.uList.mapAsyncChunked}(hj.8  hPhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Defs.htmlh|def List.mapAsyncChunked {α : Type u_7} {β : Type u_8} (f : α → β) (xs : List α) (chunk_size : ℕ := 1024) :
List βh
!Asynchronous version of List.map.u
List.zipWith3}(hj38  hPhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Defs.htmlhdef List.zipWith3 {α : Type u_1} {β : Type u_2} {γ : Type u_3} {δ : Type u_4} (f : α → β → γ → δ) :
List α → List β → List γ → List δh
 Ternary version of List.zipWith.u
List.zipWith4}(hj88  hPhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Defs.htmlhdef List.zipWith4 {α : Type u_1} {β : Type u_2} {γ : Type u_3} {δ : Type u_4} {ε : Type u_5} (f : α → β → γ → δ → ε) :
List α → List β → List γ → List δ → List εh
#Quaternary version of list.zipWith.u
List.zipWith5}(hj=8  hPhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Defs.htmlhdef List.zipWith5 {α : Type u_1} {β : Type u_2} {γ : Type u_3} {δ : Type u_4} {ε : Type u_5} {ζ : Type u_6} (f : α → β → γ → δ → ε → ζ) :
List α → List β → List γ → List δ → List ε → List ζh
 Quinary version of list.zipWith.uList.replaceIf}(hjB8  hPhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Defs.htmlhRdef List.replaceIf {α : Type u_1} :
List α → List Bool → List α → List αh
Given a starting list old, a list of booleans and a replacement list new, read the items in old in succession and either replace them with the next element of new or not, according as to whether the corresponding boolean is true or false.uList.iterate}(hjG8  hPhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Defs.htmlhMdef List.iterate {α : Type u_1} (f : α → α) (a : α) (n : ℕ) :
List αh
,iterate f a n is [a, f a, ..., f^[n - 1] a].uList.iterateTR}(hjL8  hPhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Defs.htmlhOdef List.iterateTR {α : Type u_1} (f : α → α) (a : α) (n : ℕ) :
List αh
'Tail-recursive version of List.iterate.uList.iterateTR_loop_eq}(hjQ8  hPhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Defs.htmlhtheorem List.iterateTR_loop_eq {α : Type u_1} (f : α → α) (a : α) (n : ℕ) (l : List α) :
iterateTR.loop f a n l = l.reverse ++ iterate f a nh
huList.iterate_eq_iterateTR}(hjU8  hPhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Defs.htmlh9theorem List.iterate_eq_iterateTR :
@iterate = @iterateTRh
huList.mapAccumr}(hjY8  hPhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Defs.htmlhdef List.mapAccumr {α : Type u_1} {β : Type u_2} {γ : Type u_3} (f : α → γ → γ × β) :
List α → γ → γ × List βh
RRuns a function over a list returning the intermediate results and a final result.uList.length_mapAccumr}(hj^8  hPhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Defs.htmlhtheorem List.length_mapAccumr {α : Type u_1} {β : Type u_2} {γ : Type u_3} (f : α → γ → γ × β) (x : List α) (s : γ) :
(mapAccumr f x s).snd.length = x.lengthh
)Length of the list obtained by mapAccumr.uList.mapAccumr₂}(hjc8  hPhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Defs.htmlhdef List.mapAccumr₂ {α : Type u_1} {β : Type u_2} {γ : Type u_3} {δ : Type u_4} (f : α → β → γ → γ × δ) :
List α → List β → γ → γ × List δh
URuns a function over two lists returning the intermediate results and a final result.uList.length_mapAccumr₂}(hjh8  hPhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Defs.htmlhtheorem List.length_mapAccumr₂ {α : Type u_1} {β : Type u_2} {γ : Type u_3} {δ : Type u_4} (f : α → β → γ → γ × δ) (x : List α) (y : List β) (c : γ) :
(mapAccumr₂ f x y c).snd.length = min x.length y.lengthh
-Length of a list obtained using mapAccumr₂.uList.chain_iff}(hjm8  hQhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Chain.htmlhtheorem List.chain_iff {α : Type u_1} (R : α → α → Prop) (a✝ : α) (a✝¹ : List α) :
Chain R a✝ a✝¹ ↔ a✝¹ = [] ∨ ∃ (b : α), ∃ (l : List α), R a✝ b ∧ Chain R b l ∧ a✝¹ = b :: lh
huList.chain_singleton}(hjq8  hQhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Chain.htmlhhtheorem List.chain_singleton {α : Type u} {R : α → α → Prop} {a b : α} :
Chain R a [b] ↔ R a bh
huList.chain_split}(hju8  hQhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Chain.htmlhtheorem List.chain_split {α : Type u} {R : α → α → Prop} {a b : α} {l₁ l₂ : List α} :
Chain R a (l₁ ++ b :: l₂) ↔ Chain R a (l₁ ++ [b]) ∧ Chain R b l₂h
huList.chain_append_cons_cons}(hjy8  hQhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Chain.htmlhtheorem List.chain_append_cons_cons {α : Type u} {R : α → α → Prop} {a b c : α} {l₁ l₂ : List α} :
Chain R a (l₁ ++ b :: c :: l₂) ↔ Chain R a (l₁ ++ [b]) ∧ R b c ∧ Chain R c l₂h
huList.chain_iff_forall₂}(hj}8  hQhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Chain.htmlhtheorem List.chain_iff_forall₂ {α : Type u} {R : α → α → Prop} {a : α} {l : List α} :
Chain R a l ↔ l = [] ∨ Forall₂ R (a :: l.dropLast) lh
hu)List.chain_append_singleton_iff_forall₂}(hj8  hQhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Chain.htmlhtheorem List.chain_append_singleton_iff_forall₂ {α : Type u} {R : α → α → Prop} {l : List α} {a b : α} :
Chain R a (l ++ [b]) ↔ Forall₂ R (a :: l) (l ++ [b])h
huList.chain_map}(hj8  hQhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Chain.htmlhtheorem List.chain_map {α : Type u} {β : Type v} {R : α → α → Prop} (f : β → α) {b : β} {l : List β} :
Chain R (f b) (map f l) ↔ Chain (fun (a b : β) => R (f a) (f b)) b lh
huList.chain_of_chain_map}(hj8  hQhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Chain.htmlhtheorem List.chain_of_chain_map {α : Type u} {β : Type v} {R : α → α → Prop} {S : β → β → Prop} (f : α → β) (H : ∀ (a b : α), S (f a) (f b) → R a b) {a : α} {l : List α} (p : Chain S (f a) (map f l)) :
Chain R a lh
huList.chain_map_of_chain}(hj8  hQhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Chain.htmlhtheorem List.chain_map_of_chain {α : Type u} {β : Type v} {R : α → α → Prop} {S : β → β → Prop} (f : α → β) (H : ∀ (a b : α), R a b → S (f a) (f b)) {a : α} {l : List α} (p : Chain R a l) :
Chain S (f a) (map f l)h
huList.chain_pmap_of_chain}(hj8  hQhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Chain.htmlhXl  theorem List.chain_pmap_of_chain {α : Type u} {β : Type v} {R : α → α → Prop} {S : β → β → Prop} {p : α → Prop} {f : (a : α) → p a → β} (H : ∀ (a b : α) (ha : p a) (hb : p b), R a b → S (f a ha) (f b hb)) {a : α} {l : List α} (hl₁ : Chain R a l) (ha : p a) (hl₂ : ∀ (a : α), a ∈ l → p a) :
Chain S (f a ha) (pmap f l hl₂)h
huList.chain_of_chain_pmap}(hj8  hQhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Chain.htmlhXl  theorem List.chain_of_chain_pmap {α : Type u} {β : Type v} {R : α → α → Prop} {S : β → β → Prop} {p : α → Prop} (f : (a : α) → p a → β) {l : List α} (hl₁ : ∀ (a : α), a ∈ l → p a) {a : α} (ha : p a) (hl₂ : Chain S (f a ha) (pmap f l hl₁)) (H : ∀ (a b : α) (ha : p a) (hb : p b), S (f a ha) (f b hb) → R a b) :
Chain R a lh
huList.chain_iff_pairwise}(hj8  hQhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Chain.htmlhtheorem List.chain_iff_pairwise {α : Type u} {R : α → α → Prop} [IsTrans α R] {a : α} {l : List α} :
Chain R a l ↔ Pairwise R (a :: l)h
huList.chain_iff_get}(hj8  hQhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Chain.htmlhtheorem List.chain_iff_get {α : Type u} {R : α → α → Prop} {a : α} {l : List α} :
Chain R a l ↔ (∀ (h : 0 < l.length), R a (l.get ⟨0, h⟩)) ∧ ∀ (i : ℕ) (h : i < l.length - 1), R (l.get ⟨i, ⋯⟩) (l.get ⟨i + 1, ⋯⟩)h
huList.chain_replicate_of_rel}(hj8  hQhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Chain.htmlhtheorem List.chain_replicate_of_rel {α : Type u} {r : α → α → Prop} (n : ℕ) {a : α} (h : r a a) :
Chain r a (replicate n a)h
huList.chain_eq_iff_eq_replicate}(hj8  hQhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Chain.htmlhtheorem List.chain_eq_iff_eq_replicate {α : Type u} {a : α} {l : List α} :
Chain (fun (x1 x2 : α) => x1 = x2) a l ↔ l = replicate l.length ah
huList.chain'_nil}(hj8  hQhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Chain.htmlhLtheorem List.chain'_nil {α : Type u} {R : α → α → Prop} :
Chain' R []h
huList.chain'_singleton}(hj8  hQhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Chain.htmlh\theorem List.chain'_singleton {α : Type u} {R : α → α → Prop} (a : α) :
Chain' R [a]h
huList.chain'_cons_cons}(hj8  hQhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Chain.htmlhtheorem List.chain'_cons_cons {α : Type u} {R : α → α → Prop} {x y : α} {l : List α} :
Chain' R (x :: y :: l) ↔ R x y ∧ Chain' R (y :: l)h
huList.chain'_cons}(hj8  hQhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Chain.htmlhtheorem List.chain'_cons {α : Type u} {R : α → α → Prop} {x y : α} {l : List α} :
Chain' R (x :: y :: l) ↔ R x y ∧ Chain' R (y :: l)h
Alias of List.chain'_cons_cons.uList.chain'_isInfix}(hj8  hQhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Chain.htmlhdtheorem List.chain'_isInfix {α : Type u} (l : List α) :
Chain' (fun (x y : α) => [x, y] <:+: l) lh
huList.chain'_split}(hj8  hQhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Chain.htmlhtheorem List.chain'_split {α : Type u} {R : α → α → Prop} {a : α} {l₁ l₂ : List α} :
Chain' R (l₁ ++ a :: l₂) ↔ Chain' R (l₁ ++ [a]) ∧ Chain' R (a :: l₂)h
huList.chain'_append_cons_cons}(hj8  hQhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Chain.htmlhtheorem List.chain'_append_cons_cons {α : Type u} {R : α → α → Prop} {b c : α} {l₁ l₂ : List α} :
Chain' R (l₁ ++ b :: c :: l₂) ↔ Chain' R (l₁ ++ [b]) ∧ R b c ∧ Chain' R (c :: l₂)h
hu.List.chain'_iff_forall_rel_of_append_cons_cons}(hj8  hQhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Chain.htmlhtheorem List.chain'_iff_forall_rel_of_append_cons_cons {α : Type u} {R : α → α → Prop} {l : List α} :
Chain' R l ↔ ∀ ⦃a b : α⦄ ⦃l₁ l₂ : List α⦄, l = l₁ ++ a :: b :: l₂ → R a bh
huList.chain'_map}(hj8  hQhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Chain.htmlhtheorem List.chain'_map {α : Type u} {β : Type v} {R : α → α → Prop} (f : β → α) {l : List β} :
Chain' R (map f l) ↔ Chain' (fun (a b : β) => R (f a) (f b)) lh
huList.chain'_of_chain'_map}(hj8  hQhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Chain.htmlhtheorem List.chain'_of_chain'_map {α : Type u} {β : Type v} {R : α → α → Prop} {S : β → β → Prop} (f : α → β) (H : ∀ (a b : α), S (f a) (f b) → R a b) {l : List α} (p : Chain' S (map f l)) :
Chain' R lh
huList.chain'_map_of_chain'}(hj8  hQhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Chain.htmlhtheorem List.chain'_map_of_chain' {α : Type u} {β : Type v} {R : α → α → Prop} {S : β → β → Prop} (f : α → β) (H : ∀ (a b : α), R a b → S (f a) (f b)) {l : List α} (p : Chain' R l) :
Chain' S (map f l)h
huList.chain'_iff_pairwise}(hj8  hQhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Chain.htmlhtheorem List.chain'_iff_pairwise {α : Type u} {R : α → α → Prop} [IsTrans α R] {l : List α} :
Chain' R l ↔ Pairwise R lh
huList.chain'_cons'}(hj8  hQhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Chain.htmlhtheorem List.chain'_cons' {α : Type u} {R : α → α → Prop} {x : α} {l : List α} :
Chain' R (x :: l) ↔ (∀ (y : α), y ∈ l.head? → R x y) ∧ Chain' R lh
huList.chain'_append}(hj8  hQhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Chain.htmlhtheorem List.chain'_append {α : Type u} {R : α → α → Prop} {l₁ l₂ : List α} :
Chain' R (l₁ ++ l₂) ↔ Chain' R l₁ ∧ Chain' R l₂ ∧ ∀ (x : α), x ∈ l₁.getLast? → ∀ (y : α), y ∈ l₂.head? → R x yh
huList.chain'_pair}(hj8  hQhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Chain.htmlhftheorem List.chain'_pair {α : Type u} {R : α → α → Prop} {x y : α} :
Chain' R [x, y] ↔ R x yh
huList.chain'_reverse}(hj8  hQhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Chain.htmlh{theorem List.chain'_reverse {α : Type u} {R : α → α → Prop} {l : List α} :
Chain' R l.reverse ↔ Chain' (flip R) lh
huList.chain'_iff_get}(hj8  hQhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Chain.htmlhtheorem List.chain'_iff_get {α : Type u} {R : α → α → Prop} {l : List α} :
Chain' R l ↔ ∀ (i : ℕ) (h : i < l.length - 1), R (l.get ⟨i, ⋯⟩) (l.get ⟨i + 1, ⋯⟩)h
huList.chain'_flatten}(hj8  hQhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Chain.htmlhX4  theorem List.chain'_flatten {α : Type u} {R : α → α → Prop} {L : List (List α)} :
¬[] ∈ L →
  (Chain' R L.flatten ↔     (∀ (l : List α), l ∈ L → Chain' R l) ∧       Chain' (fun (l₁ l₂ : List α) => ∀ (x : α), x ∈ l₁.getLast? → ∀ (y : α), y ∈ l₂.head? → R x y) L)h
huList.chain'_attachWith}(hj8  hQhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Chain.htmlhX   theorem List.chain'_attachWith {α : Type u} {l : List α} {p : α → Prop} (h : ∀ (x : α), x ∈ l → p x) {r : { a : α // p a } → { a : α // p a } → Prop} :
Chain' r (l.attachWith p h) ↔ Chain' (fun (a b : α) => ∃ (ha : p a), ∃ (hb : p b), r ⟨a, ha⟩ ⟨b, hb⟩) lh
huList.chain'_attach}(hj8  hQhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Chain.htmlhtheorem List.chain'_attach {α : Type u} {l : List α} {r : { a : α // a ∈ l } → { a : α // a ∈ l } → Prop} :
Chain' r l.attach ↔ Chain' (fun (a b : α) => ∃ (ha : a ∈ l), ∃ (hb : b ∈ l), r ⟨a, ha⟩ ⟨b, hb⟩) lh
hu)List.exists_chain_of_relationReflTransGen}(hj8  hQhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Chain.htmlhtheorem List.exists_chain_of_relationReflTransGen {α : Type u} {r : α → α → Prop} {a b : α} (h : Relation.ReflTransGen r a b) :
∃ (l : List α), Chain r a l ∧ (a :: l).getLast ⋯ = bh
If a and b are related by the reflexive transitive closure of r, then there is an r-chain starting from a and ending on b. The converse of relationReflTransGen_of_exists_chain.u)List.relationReflTransGen_of_exists_chain}(hj8  hQhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Chain.htmlhtheorem List.relationReflTransGen_of_exists_chain {α : Type u} {r : α → α → Prop} {a b : α} (l : List α) (hl₁ : Chain r a l) (hl₂ : (a :: l).getLast ⋯ = b) :
Relation.ReflTransGen r a bh
If there is an r-chain starting from a and ending at b, then a and b are related by the reflexive transitive closure of r. The converse of exists_chain_of_relationReflTransGen.uList.chain'_replicate_of_rel}(hj9  hQhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Chain.htmlhtheorem List.chain'_replicate_of_rel {α : Type u} {r : α → α → Prop} (n : ℕ) {a : α} (h : r a a) :
Chain' r (replicate n a)h
huList.chain'_eq_iff_eq_replicate}(hj9  hQhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Chain.htmlhtheorem List.chain'_eq_iff_eq_replicate {α : Type u} {l : List α} :
Chain' (fun (x1 x2 : α) => x1 = x2) l ↔ ∀ (a : α), a ∈ l.head? → l = replicate l.length ah
huList.chains}(hj9  hQhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Chain.htmlhFabbrev List.chains {α : Type u_1} (r : α → α → Prop) :
Type u_1h
The type of r-decreasing chainsuList.lex_chains}(hj9  hQhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Chain.htmlhWabbrev List.lex_chains {α : Type u_1} (r : α → α → Prop) (l m : chains r) :
Proph
2The lexicographic order on the r-decreasing chainsu#List.drop_take_succ_eq_cons_getElem}(hj9  hShttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Flatten.htmlhtheorem List.drop_take_succ_eq_cons_getElem {α : Type u_1} (L : List α) (i : Nat) (h : i < L.length) :
drop i (take (i + 1) L) = [L[i]]h
Taking only the first i+1 elements in a list, and then dropping the first i ones, one is left with a list of length 1 made of the i-th element of the original list.uList.append_flatten_map_append}(hj9  hShttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Flatten.htmlhtheorem List.append_flatten_map_append {α : Type u_1} (L : List (List α)) (x : List α) :
x ++ (map (fun (x_1 : List α) => x_1 ++ x) L).flatten = (map (fun (x_1 : List α) => x ++ x_1) L).flatten ++ xh
We can rebracket x ++ (l₁ ++ x) ++ (l₂ ++ x) ++ ... ++ (lₙ ++ x) to (x ++ l₁) ++ (x ++ l₂) ++ ... ++ (x ++ lₙ) ++ x where L = [l₁, l₂, ..., lₙ].uList.toAList}(hj 9  hQhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/AList.htmlhedef List.toAList {α : Type u} [DecidableEq α] {β : α → Type v} (l : List (Sigma β)) :
AList βh
bGiven l : List (Sigma β), create a term of type AList β by removing entries with duplicate keys.uList.finRange_eq_pmap_range}(hj%9  hThttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/FinRange.htmlhVtheorem List.finRange_eq_pmap_range (n : ℕ) :
finRange n = pmap Fin.mk (range n) ⋯h
huList.nodup_finRange}(hj)9  hThttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/FinRange.htmlh:theorem List.nodup_finRange (n : ℕ) :
(finRange n).Noduph
huList.finRange_eq_nil}(hj-9  hThttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/FinRange.htmlhBtheorem List.finRange_eq_nil {n : ℕ} :
finRange n = [] ↔ n = 0h
huList.pairwise_lt_finRange}(hj19  hThttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/FinRange.htmlhdtheorem List.pairwise_lt_finRange (n : ℕ) :
Pairwise (fun (x1 x2 : Fin n) => x1 < x2) (finRange n)h
huList.pairwise_le_finRange}(hj59  hThttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/FinRange.htmlhftheorem List.pairwise_le_finRange (n : ℕ) :
Pairwise (fun (x1 x2 : Fin n) => x1 ≤ x2) (finRange n)h
huList.count_finRange}(hj99  hThttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/FinRange.htmlhLtheorem List.count_finRange {n : ℕ} (a : Fin n) :
count a (finRange n) = 1h
huList.get_finRange}(hj=9  hThttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/FinRange.htmlhptheorem List.get_finRange {n i : ℕ} (h : i < (finRange n).length) :
(finRange n).get ⟨i, h⟩ = ⟨i, ⋯⟩h
huList.finRange_map_get}(hjA9  hThttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/FinRange.htmlh]theorem List.finRange_map_get {α : Type u} (l : List α) :
map l.get (finRange l.length) = lh
huList.finRange_map_getElem}(hjE9  hThttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/FinRange.htmlS      htheorem List.finRange_map_getElem {α : Type u} (l : List α) :
map (fun (x : Fin l.length) => l[↑x]) (finRange l.length) = lh
huList.idxOf_finRange}(hjI9  hThttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/FinRange.htmlhOtheorem List.idxOf_finRange {k : ℕ} (i : Fin k) :
idxOf i (finRange k) = ↑ih
huList.map_coe_finRange}(hjM9  hThttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/FinRange.htmlhLtheorem List.map_coe_finRange (n : ℕ) :
map Fin.val (finRange n) = range nh
huList.finRange_succ_eq_map}(hjQ9  hThttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/FinRange.htmlh^theorem List.finRange_succ_eq_map (n : ℕ) :
finRange n.succ = 0 :: map Fin.succ (finRange n)h
huList.ofFn_eq_pmap}(hjU9  hThttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/FinRange.htmlhtheorem List.ofFn_eq_pmap {α : Type u} {n : ℕ} {f : Fin n → α} :
ofFn f = pmap (fun (i : ℕ) (hi : i < n) => f ⟨i, hi⟩) (range n) ⋯h
huList.ofFn_id}(hjY9  hThttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/FinRange.htmlh5theorem List.ofFn_id (n : ℕ) :
ofFn id = finRange nh
huList.ofFn_eq_map}(hj]9  hThttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/FinRange.htmlhatheorem List.ofFn_eq_map {α : Type u} {n : ℕ} {f : Fin n → α} :
ofFn f = map f (finRange n)h
huList.nodup_ofFn_ofInjective}(hja9  hThttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/FinRange.htmlh{theorem List.nodup_ofFn_ofInjective {α : Type u} {n : ℕ} {f : Fin n → α} (hf : Function.Injective f) :
(ofFn f).Noduph
huList.nodup_ofFn}(hje9  hThttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/FinRange.htmlhltheorem List.nodup_ofFn {α : Type u} {n : ℕ} {f : Fin n → α} :
(ofFn f).Nodup ↔ Function.Injective fh
huList.mapIdx_append_one}(hji9  hShttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Indexes.htmlhtheorem List.mapIdx_append_one {α : Type u} {β : Type v} {f : ℕ → α → β} {l : List α} {e : α} :
mapIdx f (l ++ [e]) = mapIdx f l ++ [f l.length e]h
huList.mapIdx_eq_ofFn}(hjm9  hShttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Indexes.htmlhtheorem List.mapIdx_eq_ofFn {α : Type u} {β : Type v} (l : List α) (f : ℕ → α → β) :
mapIdx f l = ofFn fun (i : Fin l.length) => f (↑i) (l.get i)h
huList.mapIdxMAux'_eq_mapIdxMGo}(hjq9  hShttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Indexes.htmlhtheorem List.mapIdxMAux'_eq_mapIdxMGo {m : Type u → Type v} [Monad m] [LawfulMonad m] {α : Type u_1} (f : ℕ → α → m PUnit) (as : List α) (arr : Array PUnit) :
mapIdxMAux' f arr.size as = mapIdxM.go f as arr *> pure PUnit.unith
huList.mapIdxM'_eq_mapIdxM}(hju9  hShttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Indexes.htmlhtheorem List.mapIdxM'_eq_mapIdxM {m : Type u → Type v} [Monad m] [LawfulMonad m] {α : Type u_1} (f : ℕ → α → m PUnit) (as : List α) :
mapIdxM' f as = mapIdxM f as *> pure PUnit.unith
huList.reverseRecOn}(hjy9  hUhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Induction.htmlhdef List.reverseRecOn {α : Type u_1} {motive : List α → Sort u_2} (l : List α) (nil : motive []) (append_singleton : (l : List α) → (a : α) → motive l → motive (l ++ [a])) :
motive lh
Induction principle from the right for lists: if a property holds for the empty list, and for l ++ [a] if it holds for l, then it holds for all lists. The principle is given for a Sort-valued predicate, i.e., it can also be used to construct data.uList.reverseRecOn_nil}(hj~9  hUhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Induction.htmlhtheorem List.reverseRecOn_nil {α : Type u_1} {motive : List α → Sort u_2} (nil : motive []) (append_singleton : (l : List α) → (a : α) → motive l → motive (l ++ [a])) :
reverseRecOn [] nil append_singleton = nilh
huList.reverseRecOn_concat}(hj9  hUhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Induction.htmlhX<  theorem List.reverseRecOn_concat {α : Type u_1} {motive : List α → Sort u_2} (x : α) (xs : List α) (nil : motive []) (append_singleton : (l : List α) → (a : α) → motive l → motive (l ++ [a])) :
reverseRecOn (xs ++ [x]) nil append_singleton = append_singleton xs x (reverseRecOn xs nil append_singleton)h
huList.bidirectionalRec}(hj9  hUhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Induction.htmlhdef List.bidirectionalRec {α : Type u_1} {motive : List α → Sort u_2} (nil : motive []) (singleton : (a : α) → motive [a]) (cons_append : (a : α) → (l : List α) → (b : α) → motive l → motive (a :: (l ++ [b]))) (l : List α) :
motive lh
X:  Bidirectional induction principle for lists: if a property holds for the empty list, the singleton list, and a :: (l ++ [b]) from l, then it holds for all lists. This can be used to prove statements about palindromes. The principle is given for a Sort-valued predicate, i.e., it can also be used to construct data.uList.bidirectionalRec_nil}(hj9  hUhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Induction.htmlhX!  theorem List.bidirectionalRec_nil {α : Type u_1} {motive : List α → Sort u_2} (nil : motive []) (singleton : (a : α) → motive [a]) (cons_append : (a : α) → (l : List α) → (b : α) → motive l → motive (a :: (l ++ [b]))) :
bidirectionalRec nil singleton cons_append [] = nilh
huList.bidirectionalRec_singleton}(hj9  hUhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Induction.htmlhX9  theorem List.bidirectionalRec_singleton {α : Type u_1} {motive : List α → Sort u_2} (nil : motive []) (singleton : (a : α) → motive [a]) (cons_append : (a : α) → (l : List α) → (b : α) → motive l → motive (a :: (l ++ [b]))) (a : α) :
bidirectionalRec nil singleton cons_append [a] = singleton ah
hu!List.bidirectionalRec_cons_append}(hj9  hUhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Induction.htmlhX  theorem List.bidirectionalRec_cons_append {α : Type u_1} {motive : List α → Sort u_2} (nil : motive []) (singleton : (a : α) → motive [a]) (cons_append : (a : α) → (l : List α) → (b : α) → motive l → motive (a :: (l ++ [b]))) (a : α) (l : List α) (b : α) :
bidirectionalRec nil singleton cons_append (a :: (l ++ [b])) = cons_append a l b (bidirectionalRec nil singleton cons_append l)h
huList.bidirectionalRecOn}(hj9  hUhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Induction.htmlhabbrev List.bidirectionalRecOn {α : Type u_1} {C : List α → Sort u_2} (l : List α) (H0 : C []) (H1 : (a : α) → C [a]) (Hn : (a : α) → (l : List α) → (b : α) → C l → C (a :: (l ++ [b]))) :
C lh
@Like bidirectionalRec, but with the list parameter placed first.u
List.recNeNil}(hj9  hUhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Induction.htmlhX
  def List.recNeNil {α : Type u_1} {motive : (l : List α) → l ≠ [] → Sort u_2} (singleton : (x : α) → motive [x] ⋯) (cons : (x : α) → (xs : List α) → (h : xs ≠ []) → motive xs h → motive (x :: xs) ⋯) (l : List α) (h : l ≠ []) :
motive l hh
A dependent recursion principle for nonempty lists. Useful for dealing with operations like List.head which are not defined on the empty list.uList.recNeNil_singleton}(hj9  hUhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Induction.htmlhX'  theorem List.recNeNil_singleton {α : Type u_1} {motive : (l : List α) → l ≠ [] → Sort u_2} (x : α) (singleton : (x : α) → motive [x] ⋯) (cons : (x : α) → (xs : List α) → (h : xs ≠ []) → motive xs h → motive (x :: xs) ⋯) :
recNeNil singleton cons [x] ⋯ = singleton xh
huList.recNeNil_cons}(hj9  hUhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Induction.htmlhXf  theorem List.recNeNil_cons {α : Type u_1} {motive : (l : List α) → l ≠ [] → Sort u_2} (x : α) (xs : List α) (h : xs ≠ []) (singleton : (x : α) → motive [x] ⋯) (cons : (x : α) → (xs : List α) → (h : xs ≠ []) → motive xs h → motive (x :: xs) ⋯) :
recNeNil singleton cons (x :: xs) ⋯ = cons x xs h (recNeNil singleton cons xs h)h
huList.recOnNeNil}(hj9  hUhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/Induction.htmlhX  abbrev List.recOnNeNil {α : Type u_1} {motive : (l : List α) → l ≠ [] → Sort u_2} (l : List α) (h : l ≠ []) (singleton : (x : α) → motive [x] ⋯) (cons : (x : α) → (xs : List α) → (h : xs ≠ []) → motive xs h → motive (x :: xs) ⋯) :
motive l hh
A dependent recursion principle for nonempty lists. Useful for dealing with operations like List.head which are not defined on the empty list. Same as List.recNeNil, with a more convenient argument order.uList.getD_eq_getElem}(hj9  hPhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/GetD.htmlhstheorem List.getD_eq_getElem {α : Type u} (l : List α) (d : α) {n : ℕ} (hn : n < l.length) :
l.getD n d = l[n]h
hu
List.getD_map}(hj9  hPhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/GetD.htmlhtheorem List.getD_map {α : Type u} {β : Type v} (l : List α) (d : α) {n : ℕ} (f : α → β) :
(map f l).getD n (f d) = f (l.getD n d)h
huList.getD_eq_default}(hj9  hPhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/GetD.htmlhrtheorem List.getD_eq_default {α : Type u} (l : List α) (d : α) {n : ℕ} (hn : l.length ≤ n) :
l.getD n d = dh
huList.getD_reverse}(hj9  hPhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/GetD.htmlhtheorem List.getD_reverse {α : Type u} {l : List α} (i : ℕ) (h : i < l.length) :
l.reverse.getD i = l.getD (l.length - 1 - i)h
huList.decidableGetDNilNe}(hj9  hPhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/GetD.htmlhedef List.decidableGetDNilNe {α : Type u} (a : α) :
DecidablePred fun (i : ℕ) => [].getD i a ≠ ah
An empty list can always be decidably checked for the presence of an element. Not an instance because it would clash with DecidableEq α.u'List.getElem?_getD_singleton_default_eq}(hj9  hPhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/GetD.htmlhetheorem List.getElem?_getD_singleton_default_eq {α : Type u} (d : α) (n : ℕ) :
[d][n]?.getD d = dh
hu'List.getElem?_getD_replicate_default_eq}(hj9  hPhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/GetD.htmlhstheorem List.getElem?_getD_replicate_default_eq {α : Type u} (d : α) (r n : ℕ) :
(replicate r d)[n]?.getD d = dh
huList.getD_replicate}(hj9  hPhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/GetD.htmlhrtheorem List.getD_replicate {α : Type u} (x : α) {y : α} {i n : ℕ} (h : i < n) :
(replicate n x).getD i y = xh
huList.getD_append}(hj9  hPhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/GetD.htmlhtheorem List.getD_append {α : Type u} (l l' : List α) (d : α) (n : ℕ) (h : n < l.length) :
(l ++ l').getD n d = l.getD n dh
huList.getD_append_right}(hj9  hPhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/GetD.htmlhtheorem List.getD_append_right {α : Type u} (l l' : List α) (d : α) (n : ℕ) (h : l.length ≤ n) :
(l ++ l').getD n d = l'.getD (n - l.length) dh
huList.getD_eq_getD_getElem?}(hj9  hPhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/GetD.htmlhmtheorem List.getD_eq_getD_getElem? {α : Type u} (l : List α) (d : α) (n : ℕ) :
l.getD n d = l[n]?.getD dh
hu
List.getI_nil}(hj9  hPhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/GetD.htmlhRtheorem List.getI_nil {α : Type u} (n : ℕ) [Inhabited α] :
[].getI n = defaulth
huList.getI_cons_zero}(hj9  hPhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/GetD.htmlhgtheorem List.getI_cons_zero {α : Type u} (x : α) (xs : List α) [Inhabited α] :
(x :: xs).getI 0 = xh
huList.getI_cons_succ}(hj9  hPhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/GetD.htmlhtheorem List.getI_cons_succ {α : Type u} (x : α) (xs : List α) (n : ℕ) [Inhabited α] :
(x :: xs).getI (n + 1) = xs.getI nh
huList.getI_eq_getElem}(hj9  hPhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/GetD.htmlhwtheorem List.getI_eq_getElem {α : Type u} (l : List α) [Inhabited α] {n : ℕ} (hn : n < l.length) :
l.getI n = l[n]h
huList.getI_eq_default}(hj9  hPhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/GetD.htmlh|theorem List.getI_eq_default {α : Type u} (l : List α) [Inhabited α] {n : ℕ} (hn : l.length ≤ n) :
l.getI n = defaulth
huList.getD_default_eq_getI}(hj9  hPhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/GetD.htmlhttheorem List.getD_default_eq_getI {α : Type u} (l : List α) [Inhabited α] {n : ℕ} :
l.getD n default = l.getI nh
huList.getI_append}(hj9  hPhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/GetD.htmlhtheorem List.getI_append {α : Type u} [Inhabited α] (l l' : List α) (n : ℕ) (h : n < l.length) :
(l ++ l').getI n = l.getI nh
huList.getI_append_right}(hj9  hPhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/GetD.htmlhtheorem List.getI_append_right {α : Type u} [Inhabited α] (l l' : List α) (n : ℕ) (h : l.length ≤ n) :
(l ++ l').getI n = l'.getI (n - l.length)h
huList.getI_eq_iget_getElem?}(hj9  hPhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/GetD.htmlhotheorem List.getI_eq_iget_getElem? {α : Type u} (l : List α) [Inhabited α] (n : ℕ) :
l.getI n = l[n]?.igeth
huList.getI_zero_eq_headI}(hj9  hPhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/GetD.htmlh_theorem List.getI_zero_eq_headI {α : Type u} (l : List α) [Inhabited α] :
l.getI 0 = l.headIh
huList.sublist_insertIdx}(hj:  hUhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/InsertIdx.htmlhktheorem List.sublist_insertIdx {α : Type u} (l : List α) (n : ℕ) (a : α) :
l.Sublist (l.insertIdx n a)h
huList.subset_insertIdx}(hj:  hUhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/InsertIdx.htmlhdtheorem List.subset_insertIdx {α : Type u} (l : List α) (n : ℕ) (a : α) :
l ⊆ l.insertIdx n ah
huList.insertIdx_eraseIdx_self}(hj:  hUhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/InsertIdx.htmlhtheorem List.insertIdx_eraseIdx_self {α : Type u} {l : List α} {n : ℕ} (hn : n ≠ l.length) (a : α) :
(l.eraseIdx n).insertIdx n a = l.set n ah
Erasing nth element of a list, then inserting a at the same place is the same as setting nth element to a.
We assume that n ≠ length l, because otherwise LHS equals l ++ [a] while RHS equals l.uList.insertIdx_eraseIdx_getElem}(hj:  hUhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/InsertIdx.htmlhtheorem List.insertIdx_eraseIdx_getElem {α : Type u} {l : List α} {n : ℕ} (hn : n < l.length) :
(l.eraseIdx n).insertIdx n l[n] = lh
huList.eq_or_mem_of_mem_insertIdx}(hj:  hUhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/InsertIdx.htmlhtheorem List.eq_or_mem_of_mem_insertIdx {α : Type u} {l : List α} {n : ℕ} {a b : α} (h : a ∈ l.insertIdx n b) :
a = b ∨ a ∈ lh
huList.insertIdx_subset_cons}(hj:  hUhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/InsertIdx.htmlhntheorem List.insertIdx_subset_cons {α : Type u} (n : ℕ) (a : α) (l : List α) :
l.insertIdx n a ⊆ a :: lh
huList.insertIdx_pmap}(hj:  hUhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/InsertIdx.htmlhtheorem List.insertIdx_pmap {α : Type u} {β : Type v} {p : α → Prop} (f : (a : α) → p a → β) {l : List α} {a : α} {n : ℕ} (hl : ∀ (x : α), x ∈ l → p x) (ha : p a) :
(pmap f l hl).insertIdx n (f a ha) = pmap f (l.insertIdx n a) ⋯h
huList.map_insertIdx}(hj :  hUhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/InsertIdx.htmlhtheorem List.map_insertIdx {α : Type u} {β : Type v} (f : α → β) (l : List α) (n : ℕ) (a : α) :
map f (l.insertIdx n a) = (map f l).insertIdx n (f a)h
huList.eraseIdx_pmap}(hj$:  hUhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/InsertIdx.htmlhtheorem List.eraseIdx_pmap {α : Type u} {β : Type v} {p : α → Prop} (f : (a : α) → p a → β) {l : List α} (hl : ∀ (a : α), a ∈ l → p a) (n : ℕ) :
(pmap f l hl).eraseIdx n = pmap f (l.eraseIdx n) ⋯h
huList.eraseIdx_map}(hj(:  hUhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/InsertIdx.htmlhtheorem List.eraseIdx_map {α : Type u} {β : Type v} (f : α → β) (l : List α) (n : ℕ) :
(map f l).eraseIdx n = map f (l.eraseIdx n)h
(Erasing an index commutes with List.map.uList.get_insertIdx_of_lt}(hj-:  hUhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/InsertIdx.htmlhtheorem List.get_insertIdx_of_lt {α : Type u} (l : List α) (x : α) (n k : ℕ) (hn : k < n) (hk : k < l.length) (hk' : k < (l.insertIdx n x).length := ⋯) :
(l.insertIdx n x).get ⟨k, hk'⟩ = l.get ⟨k, hk⟩h
huList.get_insertIdx_self}(hj1:  hUhttps://leanprover-community.github.io/mathlib4_docs/Mathlib/Data/List/InsertIdx.htmlhtheorem List.get_insertIdx_self {α : Type u} (l : List α) (x : α) (n : ℕ) (hn : n ≤ l.length) (hn' : n < (l.insertIdx n x).length := ⋯) :
(l.insertIdx n x).get ⟨n, hn'⟩ = xh
huList.getElem