## Overview
This repository contains the implementation of three watermarking algorithms:
- [Gumbel-max](https://simons.berkeley.edu/talks/scott-aaronson-ut-austin-openai-2023-08-17): Implementation based on [link](https://github.com/lx10077/WatermarkFramework).
- [Inverse-Transform](https://arxiv.org/abs/2307.15593): Implementation based on [link](https://github.com/lx10077/WatermarkFramework).
- [SynthID](https://www-nature-com.proxy.library.upenn.edu/articles/s41586-024-08025-4): Implementation based on [MarkLLM](https://github.com/THU-BPM/MarkLLM/tree/main) with significant modifications.

## Repository Structure
### `Gumbel&Transform/`
- **`attack.py`**: Tests robustness of watermarked text against various attacks:
  - Word deletion
  - Synonym substitution
- **`generating_samples.py`**: Generates watermarked text using the Gumbel-max or the Inverse-Transform algorithm.
- **`detect_utils.py`**: Contains the code for the Goodness-of-fit tests used in the paper.

### `SynthID/`
Contains the implementation of SynthID.
  #### `MarkLLM/`
  - **`synthid_generate.py`**: Generates watermarked text using the SynthID algorithm
  - **`attack.py`**: Tests robustness of watermarked text against various attacks:
    - Word deletion
    - Synonym substitution
    - Dipper paraphrase

  #### `results/`
  All experimental results of SynthID are stored in this directory:
  - **`read_results.py`**: Extracts pivotal values from watermarked texts
  - **`get_score.py`**: Performs watermark detection using:
    - Various Goodness-of-fit statistical tests
    - Baseline detection methods
  - **`detect_utils.py`**: Contains the code for the Goodness-of-fit tests used in the paper.
