# MIHC: Multi-View Interpretable Hypergraph Neural Networks with Information Bottleneck for Chip Congestion Prediction

## Overview

MIHC is a deep learning framework designed for chip congestion prediction that:
1. Processes both netlist (topological) and layout (geometric) information using hypergraph neural networks
2. Incorporates an interpretable subgraph extraction mechanism based on Information Bottleneck
3. Fuses information from multiple views through a specially designed message-passing mechanism

The model can simultaneously predict congestion at both cell-level and grid-level, outperforming previous state-of-the-art methods.

## Repository Structure

```
MIHC/
├── configs/               # Configuration files
│   └── config.yaml        # Main configuration file
├── data/                  # Data processing modules
│   ├── __init__.py
│   ├── dataset.py         # Dataset class implementation
│   └── preprocessing.py   # Data preprocessing utilities
├── models/                # Model implementation
│   ├── __init__.py
│   ├── mihc.py            # Main MIHC model
│   ├── process.py         # Process module implementation
│   ├── interpretable.py   # Interpretable Subgraph module
│   ├── multi_view.py      # Multi-View HGNN module
│   └── prediction.py      # Prediction module
├── utils/                 # Utility functions
│   ├── __init__.py
│   ├── evaluation.py      # Evaluation metrics
│   └── visualization.py   # Visualization utilities
├── train.py               # Training script
├── test.py                # Testing script
└── requirements.txt       # Package dependencies
```

## Model Interpretability

To validate the interpretability of the Information Bottleneck subgraph in our MIHC model, we present heatmap visualizations from the mgc_superblue16_a design placement data:

![Heatmap Comparison](./heat_map.png)

To validate the interpretability of the IB bottleneck subgraph in our MIHC model, we selected heat maps from the mgc_superblue16_a design placement data, showing the ground truth label, our model's bottleneck subgraph, our model's prediction results, and the baseline Lay-Net model for comparison. As demonstrated, our model's prediction more closely resembles the ground truth compared to Lay-Net, proving our model's superior performance. Additionally, the bottleneck subgraph heat map indicates that our IB bottleneck subgraph can be extracted to reveal regions relevant to the final prediction results. While node-level predictions identify congestion points, our Information Bottleneck identifies the critical local structures that cause these anomalies, revealing the structural patterns that contribute to surrounding node congestion rather than just detecting generic anomalies.

## Installation
```bash
# Clone the repository
git clone https://github.com/yourusername/MIHC.git
cd MIHC
# Create and activate a virtual environment (optional but recommended)
python -m venv venv
source venv/bin/activate  # On Windows: venv\Scripts\activate
# Install dependencies
pip install -r requirements.txt

## Installation

```bash
# Clone the repository
git clone https://github.com/yourusername/MIHC.git
cd MIHC

# Create and activate a virtual environment (optional but recommended)
python -m venv venv
source venv/bin/activate  # On Windows: venv\Scripts\activate

# Install dependencies
pip install -r requirements.txt
```

## Usage

### Training

```bash
python train.py --config configs/config.yaml
```

### Testing

```bash
python test.py --config configs/config.yaml --checkpoint path/to/checkpoint.pth
```

### Configuration

Adjust the parameters in `configs/config.yaml` to customize:
- Model architecture (hidden dimensions, number of layers, etc.)
- Training parameters (learning rate, batch size, etc.)
- Dataset settings

