from gymnasium.envs.registration import register

# from mo_gymnasium.envs.deep_sea_treasure.deep_sea_treasure import CONCAVE_MAP, REDUCED_EPISODE_LENGTH
from mo_gymnasium.envs.deep_sea_treasure.deep_sea_treasure_sparse import CONCAVE_MAP, REDUCED_EPISODE_LENGTH


register(
    id="deep-sea-treasure-v0",
    entry_point="mo_gymnasium.envs.deep_sea_treasure.deep_sea_treasure:DeepSeaTreasure",
    max_episode_steps=100,
)

register(
    id="deep-sea-treasure-concave-v0",
    entry_point="mo_gymnasium.envs.deep_sea_treasure.deep_sea_treasure:DeepSeaTreasure",
    max_episode_steps=100,
    kwargs={"dst_map": CONCAVE_MAP},
)

register(
    id="deep-sea-treasure-sparse-v0",
    entry_point="mo_gymnasium.envs.deep_sea_treasure.deep_sea_treasure_sparse:DeepSeaTreasure",
    max_episode_steps=REDUCED_EPISODE_LENGTH,
    kwargs={"dst_map": CONCAVE_MAP},
)

register(
    id="deep-sea-treasure-norm1-v0",
    entry_point="mo_gymnasium.envs.deep_sea_treasure.deep_sea_treasure_norm1:DeepSeaTreasure",
    max_episode_steps=25,
)