#!/bin/bash
#SBATCH -A m1727
#SBATCH -C cpu
#SBATCH -t 8:00:00
#SBATCH -n 1
#SBATCH -c 64
#SBATCH -q shared

export SLURM_CPU_BIND="cores"
export HF_HOME=$HF_HOME
module load python
module load pytorch/1.13.1
source activate pytorch-1.13.1
module load pytorch/1.13.1
accelerate launch --num_processes=1 \
    --mixed_precision=bf16 \
     finetune_classification.py \
    --load_model $1 \
    --fourier_pe \
    --mask \
    --class_weights \
    --save_model $2 \
    --dataset_path $3 \
    --wandb_name baseline_self_labeled \
    --random_init \
    --num_lp_steps 0 \
    --num_ft_steps 100
