#!/bin/bash
#SBATCH -A dessn
#SBATCH -C gpu
#SBATCH -t 12:00:00
#SBATCH -N 1
#SBATCH -c 128
#SBATCH -q regular
#SBATCH --gpus=4

date
export SLURM_CPU_BIND="cores"
export HF_HOME=$HF_HOME
export WANDB_DISABLE_SERVICE=true
module load python
module load pytorch/1.13.1
source activate pytorch-1.13.1
module load pytorch/1.13.1
# srun python \
accelerate launch --multi_gpu --num_processes=4 \
    --mixed_precision=bf16 \
    transformer_uda/huggingface_informer.py \
    --data_dir $1 \
    --save_model $2 \
    --fourier_pe \
    --mask \
    --num_steps 60_000 \
    --load_checkpoint $3
