# Minigrid experiments

## Description

This directory contains experiments related to the `minigrid` environment.
`minigrid` is a 2D grid where agents can `turn right` and `move forward`.

- [minigrid.py](minigrid.py): Source code for learning abstract world models with a group-structured latent space.
- [minigrid_prae.py](minigrid_prae.py): Re-implementation of [Plannable Approximations to MDP Homomorphisms: Equivariance under Actions](https://arxiv.org/abs/2002.11963).
- [minigrid_no_priors.py](minigrid_no_priors.py): Learning abstract world models without priors.
- [minigrid_dqn.py](minigrid_dqn.py): Double DQN baseline for the navigation task in the minigrid environment.
- [minigrid_dqn_wm.py](minigrid_dqn_wm.py): Double DQN baseline with world model for the navigation task in the minigrid environment.
- [minigrid_dqn_wm_no_priors.py](minigrid_dqn_wm_no_priors.py): Double DQN baseline with world model without priors for the navigation task in the minigrid environment.

## Examples

As an example, you can run the following command to train a model on the minigrid environment:

```bash
python3 minigrid.py --seed 42 --batch_size 64 --max_steps 50000 --hidden_dim 32 --encoder_lr 1e-4 --transition_lr 1e-4 --momentum 0.8 --weight_decay 0.0 --log_dir logs --pct_transitions_disabled 0.2
```

Here, `pct_transitions_disabled` is the percentage of transitions that are disabled, which can be used to test the generalization capability of the model to missing transitions.
