import yaml
import numpy as np
from pathlib import Path

class GidNetConfig:
    def __init__(self, file_path=Path(__file__).parent / 'gidnet.yaml'):

        with open(file_path, 'r') as file:
            cfg_dict = yaml.safe_load(file)  # Load YAML into a dictionary

        self.n_seeds = cfg_dict['k']
        self.n_movements = cfg_dict['b']
        self.lr = cfg_dict['lr']
        self.epochs = cfg_dict['epochs']
        self.lambda1 = float(cfg_dict['lambda1'])
        self.n_test = cfg_dict['n_test']
    

    def print_config(self):
        return