LANG_LIBS = {
    "en": [
        "Question:",
        "Options:",
        "Answer: Let's think step by step.",
        'The following are multiple choice questions (with answers) about {subject}. Think step by step and then finish your answer with "{ans_suffix}" where X is the correct letter choice.',
        "A: Let's think step by step.",
        "the answer is ({})",
    ],
    "ja": [
        "質問：",
        "選択肢：",
        "回答：一歩一歩考えていきましょう。",
        "以下は{subject}に関する選択問題（解答付き）です。段階的に考え、最後に「{ans_suffix}」と回答を締めくくってください。Xは正解の選択肢を示す文字です。",
        "A: 一歩一歩考えていきましょう。",
        "答えは ({}) です",
    ],
    "zh": [
        "问题：",
        "选项：",
        "答案：让我们一步一步地思考。",
        '以下是关于{subject}的选择题（带有答案）。请逐步思考，然后以"{ans_suffix}"结束您的回答，其中X是正确的选项字母。',
        "A: 让我们一步一步地思考。",
        "答案是 ({})",
    ],
    "ko": [
        "질문：",
        "선택 사항：",
        "답변: 한 단계씩 생각해 봅시다.",
        '다음은 {subject}에 관한 객관식 문제(정답 포함)입니다. 단계적으로 생각한 다음 "{ans_suffix}"로 답변을 마무리하세요. 여기서 X는 올바른 선택지 문자입니다.',
        "A: 한 단계씩 생각해 봅시다.",
        "답은 ({})입니다",
    ],
    "fr": [
        "Question :",
        "Options :",
        "Réponse : Réfléchissons étape par étape.",
        'Voici des questions à choix multiples (avec réponses) sur {subject}. Réfléchissez étape par étape, puis terminez votre réponse par "{ans_suffix}" où X est la lettre correspondant au bon choix.',
        "A: Réfléchissons étape par étape.",
        "La réponse est ({})",
    ],
    "de": [
        "Frage:",
        "Optionen:",
        "Antwort: Denken wir Schritt für Schritt nach.",
        'Im Folgenden sind Multiple-Choice-Fragen (mit Antworten) zu {subject}. Denken Sie Schritt für Schritt nach und beenden Sie Ihre Antwort mit "{ans_suffix}", wobei X der richtige Buchstabe ist.',
        "A: Denken wir Schritt für Schritt nach.",
        "Die Antwort ist ({})",
    ],
    "es": [
        "Pregunta:",
        "Opciones:",
        "Respuesta: Pensemos paso a paso.",
        'Las siguientes son preguntas de opción múltiple (con respuestas) sobre {subject}. Piense paso a paso y luego termine su respuesta con "{ans_suffix}" donde X es la letra de la opción correcta.',
        "A: Pensemos paso a paso.",
        "La respuesta es ({})",
    ],
    "pt": [
        "Pergunta:",
        "Opções:",
        "Resposta: Vamos pensar passo a passo.",
        'A seguir estão perguntas de múltipla escolha (com respostas) sobre {subject}. Pense passo a passo e termine sua resposta com "{ans_suffix}" onde X é a letra da opção correta.',
        "A: Vamos pensar passo a passo.",
        "A resposta é ({})",
    ],
    "sw": [
        "Swali:",
        "Chaguo:",
        "Jibu: Hebu tufikiria hatua kwa hatua.",
        'Yafuatayo ni maswali ya chaguo-nyingi (yenye majibu) kuhusu {subject}. Fikiria hatua kwa hatua kisha malizia jibu lako kwa "{ans_suffix}" ambapo X ni herufi ya chaguo sahihi.',
        "A: Hebu tufikiria hatua kwa hatua.",
        "Jibu ni ({})",
    ],
    "th": [
        "คำถาม:",
        "ตัวเลือก:",
        "คำตอบ: มาคิดทีละขั้นตอนกัน",
        'ต่อไปนี้เป็นคำถามปรนัย (พร้อมคำตอบ) เกี่ยวกับ {subject} คิดทีละขั้นตอนแล้วสรุปคำตอบด้วย "{ans_suffix}" โดยที่ X คือตัวอักษรที่เป็นตัวเลือกที่ถูกต้อง',
        "A: มาคิดทีละขั้นตอนกัน",
        "คำตอบคือ ({})",
    ],
    "ar": [
        "سؤال:",
        "الخيارات:",
        "الإجابة: دعنا نفكر خطوة بخطوة.",
        "فيما يلي أسئلة اختيار من متعدد (مع إجابات) حول {subject}. فكر خطوة بخطوة ثم أنهِ إجابتك بـ '{ans_suffix}' حيث X هو حرف الخيار الصحيح.",
        "أ: دعنا نفكر خطوة بخطوة.",
        "الإجابة هي ({})",
    ],
    "hi": [
        "प्रश्न:",
        "विकल्प:",
        "उत्तर: चलिए चरण-दर-चरण सोचते हैं।",
        'निम्नलिखित {subject} के बारे में बहुविकल्पीय प्रश्न (उत्तरों के साथ) हैं। चरण-दर-चरण सोचें और फिर अपने उत्तर को "{ans_suffix}" के साथ समाप्त करें जहां X सही विकल्प का अक्षर है।',
        "A: चलिए चरण-दर-चरण सोचते हैं।",
        "उत्तर है ({})",
    ],
    "bn": [
        "প্রশ্ন:",
        "বিকল্পগুলি:",
        "উত্তর: আসুন ধাপে ধাপে চিন্তা করি।",
        'নিম্নলিখিত {subject} সম্পর্কে বহুনির্বাচনী প্রশ্ন (উত্তরসহ)। ধাপে ধাপে চিন্তা করুন এবং তারপর আপনার উত্তর "{ans_suffix}" দিয়ে শেষ করুন যেখানে X হল সঠিক বিকল্পের অক্ষর।',
        "A: আসুন ধাপে ধাপে চিন্তা করি।",
        "উত্তর হল ({})",
    ],
}


LANG_SUBJECTS = {
    "en": {
        "biology": "biology",
        "business": "business",
        "chemistry": "chemistry",
        "computer_science": "computer_science",
        "economics": "economics",
        "engineering": "engineering",
        "health": "health",
        "history": "history",
        "law": "law",
        "math": "math",
        "other": "other",
        "philosophy": "philosophy",
        "physics": "physics",
        "psychology": "psychology",
    },
    "ja": {
        "biology": "生物学",
        "business": "ビジネス",
        "chemistry": "化学",
        "computer_science": "コンピュータサイエンス",
        "economics": "経済学",
        "engineering": "工学",
        "health": "健康科学",
        "history": "歴史",
        "law": "法律",
        "math": "数学",
        "other": "その他",
        "philosophy": "哲学",
        "physics": "物理学",
        "psychology": "心理学",
    },
    "zh": {
        "biology": "生物学",
        "business": "商业",
        "chemistry": "化学",
        "computer_science": "计算机科学",
        "economics": "经济学",
        "engineering": "工程学",
        "health": "健康",
        "history": "历史",
        "law": "法律",
        "math": "数学",
        "other": "其他",
        "philosophy": "哲学",
        "physics": "物理学",
        "psychology": "心理学",
    },
    "ko": {
        "biology": "생물학",
        "business": "경영학",
        "chemistry": "화학",
        "computer_science": "컴퓨터 과학",
        "economics": "경제학",
        "engineering": "공학",
        "health": "건강",
        "history": "역사",
        "law": "법률",
        "math": "수학",
        "other": "기타",
        "philosophy": "철학",
        "physics": "물리학",
        "psychology": "심리학",
    },
    "fr": {
        "biology": "biologie",
        "business": "commerce",
        "chemistry": "chimie",
        "computer_science": "informatique",
        "economics": "économie",
        "engineering": "ingénierie",
        "health": "santé",
        "history": "histoire",
        "law": "droit",
        "math": "mathématiques",
        "other": "autre",
        "philosophy": "philosophie",
        "physics": "physique",
        "psychology": "psychologie",
    },
    "de": {
        "biology": "Biologie",
        "business": "Wirtschaft",
        "chemistry": "Chemie",
        "computer_science": "Informatik",
        "economics": "Ökonomie",
        "engineering": "Ingenieurwesen",
        "health": "Gesundheit",
        "history": "Geschichte",
        "law": "Recht",
        "math": "Mathematik",
        "other": "Sonstiges",
        "philosophy": "Philosophie",
        "physics": "Physik",
        "psychology": "Psychologie",
    },
    "es": {
        "biology": "biología",
        "business": "negocios",
        "chemistry": "química",
        "computer_science": "informática",
        "economics": "economía",
        "engineering": "ingeniería",
        "health": "salud",
        "history": "historia",
        "law": "derecho",
        "math": "matemáticas",
        "other": "otro",
        "philosophy": "filosofía",
        "physics": "física",
        "psychology": "psicología",
    },
    "pt": {
        "biology": "biologia",
        "business": "negócios",
        "chemistry": "química",
        "computer_science": "ciência da computação",
        "economics": "economia",
        "engineering": "engenharia",
        "health": "saúde",
        "history": "história",
        "law": "direito",
        "math": "matemática",
        "other": "outro",
        "philosophy": "filosofia",
        "physics": "física",
        "psychology": "psicologia",
    },
    "sw": {
        "biology": "biolojia",
        "business": "biashara",
        "chemistry": "kemia",
        "computer_science": "sayansi ya kompyuta",
        "economics": "uchumi",
        "engineering": "uhandisi",
        "health": "afya",
        "history": "historia",
        "law": "sheria",
        "math": "hisabati",
        "other": "nyingine",
        "philosophy": "falsafa",
        "physics": "fizikia",
        "psychology": "saikolojia",
    },
    "th": {
        "biology": "ชีววิทยา",
        "business": "ธุรกิจ",
        "chemistry": "เคมี",
        "computer_science": "วิทยาการคอมพิวเตอร์",
        "economics": "เศรษฐศาสตร์",
        "engineering": "วิศวกรรมศาสตร์",
        "health": "สุขภาพ",
        "history": "ประวัติศาสตร์",
        "law": "กฎหมาย",
        "math": "คณิตศาสตร์",
        "other": "อื่นๆ",
        "philosophy": "ปรัชญา",
        "physics": "ฟิสิกส์",
        "psychology": "จิตวิทยา",
    },
    "ar": {
        "biology": "علم الأحياء",
        "business": "الأعمال",
        "chemistry": "الكيمياء",
        "computer_science": "علوم الكمبيوتر",
        "economics": "الاقتصاد",
        "engineering": "الهندسة",
        "health": "الصحة",
        "history": "التاريخ",
        "law": "القانون",
        "math": "الرياضيات",
        "other": "أخرى",
        "philosophy": "الفلسفة",
        "physics": "الفيزياء",
        "psychology": "علم النفس",
    },
    "hi": {
        "biology": "जीव विज्ञान",
        "business": "व्यापार",
        "chemistry": "रसायन विज्ञान",
        "computer_science": "कंप्यूटर विज्ञान",
        "economics": "अर्थशास्त्र",
        "engineering": "इंजीनियरिंग",
        "health": "स्वास्थ्य",
        "history": "इतिहास",
        "law": "कानून",
        "math": "गणित",
        "other": "अन्य",
        "philosophy": "दर्शनशास्त्र",
        "physics": "भौतिकी",
        "psychology": "मनोविज्ञान",
    },
    "bn": {
        "biology": "জীববিজ্ঞান",
        "business": "ব্যবসা",
        "chemistry": "রসায়ন",
        "computer_science": "কম্পিউটার বিজ্ঞান",
        "economics": "অর্থনীতি",
        "engineering": "প্রকৌশল",
        "health": "স্বাস্থ্য",
        "history": "ইতিহাস",
        "law": "আইন",
        "math": "গণিত",
        "other": "অন্যান্য",
        "philosophy": "দর্শন",
        "physics": "পদার্থবিজ্ঞান",
        "psychology": "মনোবিজ্ঞান",
    },
}
