import json
import os 


class ParamsLoader:
    def __init__(self, model_name):
        self.model_name = model_name

    def load_params(self):
        filename = f"src/models/params/{self.model_name}.json"
        if not os.path.exists(filename):
            raise FileNotFoundError(f"The file {filename} can't be found, maybe it is misswritten or doesn't exist.")

        with open(filename, 'r') as f:
            params = json.load(f)
        return params
