import os
import numpy as np
import pandas as pd
from config import *

def read_random_ts(files,path_score,path_data,methods):
    current_idx = np.random.randint(0, len(files))
    df = pd.read_csv(path_data.format(files[current_idx][1],files[current_idx][0]), header=None).to_numpy(dtype=np.float32)
    data = df[:, 0].astype(np.float32)
    features = all_features[files[current_idx][0]]#pycatch22.catch22_all(data,catch24 = True)
    label = df[:, 1]    
    label = [int(lab) for lab in label]
    all_score = []
    for method in methods:
        score = pd.read_csv(path_score.format(files[current_idx][1],method,files[current_idx][0]), header=None).to_numpy(dtype=np.float32)
        score = np.array([val[0] for val in score])
        all_score.append(score)
    all_score = np.array(all_score)
    return features.astype(np.float32),label,all_score