from tqdm import tqdm
from openai import OpenAI
import openai
import backoff, base64
import os, sys, pathlib, json, pdb
import concurrent.futures



def encode_image(image_path):
    with open(image_path, "rb") as image_file:
        return base64.b64encode(image_file.read()).decode('utf-8')

class DeepInfra():
    def __init__(self, model_id):
        self.model_id = model_id
        self.client = OpenAI(api_key=API_KEY, base_url="https://api.deepinfra.com/v1/openai")

    def completion_with_backoff(self, **kwargs):
        while (1):
            try:
                return self.client.chat.completions.create(**kwargs)
            except:
                pass

    def generate(self, text, max_new_tokens=1024, temperature=0, num_return_sequences=1, progress_bar=True, **kwargs):
        if isinstance(text, str):
            text = [text]

        def process_text(t, idx):
            out_completions = []
            for i in range(num_return_sequences):
                completion = self.completion_with_backoff(
                    model=self.model_id,
                    messages=[
                        {
                            "role": "user",
                            "content": t,
                        }
                    ],
                    max_tokens=max_new_tokens,
                    temperature=temperature,
                    n=1,
                    **kwargs
                )
                out_completions.append(completion)
            return (out_completions, idx)


        with concurrent.futures.ThreadPoolExecutor() as executor:
            futures = [executor.submit(process_text, t, idx) for idx, t in enumerate(text)]
            completions = []
            if progress_bar:
                for future in tqdm(concurrent.futures.as_completed(futures)):
                    completions.append(future.result())
            else:
                for future in concurrent.futures.as_completed(futures):
                    completions.append(future.result())

        completions_sorted = sorted(completions, key=lambda x: x[1])
        responses = [[completion[0][i].choices[0].message.content for i in range(num_return_sequences)] for completion in completions_sorted]
        completions = completions_sorted


        return {'responses': responses, 'completions': completions}
