def get_query_content(target_frame, example_frames):
    content = []
    instruction = '''
        You are an expert game analyst tasked with predicting task completion percentages for the frame from the Catrap game, 
        where the player character is solving a level involving enemies, puzzles, and obstacles.
        The task completion percentages are between 0 and 100, where 100
        corresponds to full task completion. We provide several example frames showing various stages of the gameplay, 
        along with their corresponding task completion percentages. Note that these frames are
        in random order, so please pay attention to the individual frames
        when reasoning about task completion percentage.
    '''
    all_images = []
    for idx, (img, percent) in enumerate(example_frames):
        all_images.append(img)
        if idx == 0:
            content.append({"type": "text", "text": instruction})
            content.append({"type": "text", "text": "Initial frame for the next series of frames: "})
        else:
            content.append({"type": "text", "text": f"Example Frame {idx}:"})      
        
        content.append({"type": "text", "text": f"In this frame, the task completion percentage is {percent}%."})
        content.append({"type": "image"})


    content.append({"type": "text", "text": (
        f"Now, for the level being solved in Catrap, output the task completion percentage for the following frame. "
        f"Format your response as follows:\n"
        f"```\n Thoughts: <any thoughts that will lead you to the goal>, Task Completion Percentage: <number between 0 and 100>%\n```"
    )})
 
    content.append({"type": "text", "text": f"Target Frame: "})
    content.append({"type": "image"})
    all_images.append(target_frame[0])
    
    messages = [
        {
            "role": "user",
            "content": content,
        }
    ]
    return messages, all_images


def get_gvl_content(frames, example_frames):
    content = []
    all_images = []
    instruction = '''
        You are an expert game analyst tasked with predicting task completion percentages for frames from the Catrap game, 
        where the player character is solving a level involving enemies, puzzles, and obstacles.
        The task completion percentages are between 0 and 100, where 100
        corresponds to full task completion. We provide several example frames showing various stages of the gameplay, 
        along with their corresponding task completion percentages. Note that these frames are
        in random order, so please pay attention to the individual frames
        when reasoning about task completion percentage.
    '''
    content.append({"type": "text", "text": instruction})

    for idx, (img, percent) in enumerate(example_frames, 1):
        all_images.append(img)
        content.append({"type": "text", "text": f"Example Frame {idx}:"})
        content.append({"type": "image"})
        content.append({"type": "text", "text": f"In this frame, the task completion percentage is {percent}%."})


    content.append({"type": "text", "text": "Initial game state: "})
    content.append({"type": "image"})
    all_images.append(frames[0])


    content.append({"type": "text", "text": (
        f"Now, for the level being solved in Catrap, output the task completion percentage for the following "
        f"frames that are presented in random order. For each frame, format your response as follows:\n"
        f"```\nFrame {{i}}: Frame Description: {{}}, Task Completion Percentage: {{}}%\n```"
    )})

    for idx, img in enumerate(frames[1:], 1):
        all_images.append(img)
        content.append({"type": "text", "text": f"Frame {idx}:"})
        content.append({"type": "image"})

    messages = [
        {
            "role": "user",
            "content": content,
        }
    ]
    return messages, all_images