from dotenv import load_dotenv
import os
import boto3
from transformers import Qwen2_5_VLForConditionalGeneration, AutoTokenizer, AutoProcessor
import torch


def upload_to_s3(local_path, s3_bucket, s3_path, aws_access_key_id=None, aws_secret_access_key=None):
    load_dotenv()
    AWS_ACCESS_KEY_ID = os.getenv('AWS_ACCESS_KEY_ID')
    AWS_SECRET_ACCESS_KEY = os.getenv('AWS_SECRET_ACCESS_KEY')
    """Upload a file to S3"""
    try:
        s3_client = boto3.client(
            's3',
            aws_access_key_id=AWS_ACCESS_KEY_ID,
            aws_secret_access_key=AWS_SECRET_ACCESS_KEY,
            endpoint_url="" # your url here
        )
        for root, dirs, files in os.walk(local_path):
            for file in files:
                local_file = os.path.join(root, file)
                relative_path = os.path.relpath(local_file, local_path)
                s3_path_cur = os.path.join(s3_path, relative_path.replace("\\", "/"))
                print(local_file, relative_path, s3_path_cur)
                # s3_path_cur = os.path.join("/".join(local_path.split("/")[1:]), s3_path_cur)
                # print(s3_path_cur)
                s3_client.upload_file(local_file, s3_bucket, s3_path_cur)
                print(f'Uploaded file {local_file} to {s3_path_cur}')
    except Exception as e:
        print(f"Error uploading to S3: {e}")