# Stealthy Backdoor Attack in Reinforcement Learning via Bi-level Optimization

This repository provides code and experiments for stealthy backdoor attacks in reinforcement learning using bi-level optimization. It supports multiple RL environments, including CartPole,Hopper, and Walker2D. The codebase includes:

- Backdoor policy injection and evaluation scripts
- PPO-based RL training and testing
- Attacker logic for reward and policy manipulation

For details on each environment, see the corresponding folders and scripts.

## Environment Setup

1. Clone the repository and enter the project directory.
2. Install Python dependencies:
   ```bash
   pip install -r requirements.txt
   ```

## CartPole

- `cartpole.py` / `cartpole_run.py`: Main training and evaluation scripts for CartPole
- `attacker.py`: Backdoor attack logic implementation
- `lib/`: Model definitions and utility functions
- `backdoored.pth` / `network-good.pt`: Example trained model weights

### 1. Training

- Normal training (no backdoor):
  ```bash
  python cartPole_exp/cartpole_run.py
  ```

- Backdoor training (poisoned):
  ```bash
  python cartPole_exp/cartpole_run.py --is_poison
  ```

### 2. Play Phase (Evaluation & Video Recording)

- Evaluate trained models and record videos:
  ```bash
  python cartPole_exp/play_cartpole.py --is_test
  ```

## Hopper

- `train_hopper.py` — Main training script for PPO/backdoor RL on Hopper.
- `play_hopper.py` — Script for evaluating trained models and recording videos.
- `hopper_attacker.py` — Implements attacker logic for reward poisoning and policy manipulation.
- `lib/` — Contains model definitions and utility functions.
- Example model files:
  - Normal model: `checkpoints/MAX_EPOCHS_400_rewards_3676.pth`
  - Backdoor model: `checkpoints/Poison_True_diffactions_False_eps_0.50.pth`

### 1. Training

- Train a normal or backdoor policy:
  ```bash
  python hopper_train.py
  python hopper_train.py -p  # Enable backdoor attack mode
  ```

### 2. Evaluation & Video Recording

- Evaluate a trained model and record videos:
  ```bash
  python hopper_play.py
  ```

## Walker2D

- `train_walker.py` — Main training script for PPO/backdoor RL on Walker2D.
- `play_walker.py` — Script for evaluating trained models and recording videos.
- `walker_attacker.py` — Implements attacker logic for reward poisoning and policy manipulation.
- `lib/` — Contains model definitions and utility functions.
- Example model files:
  - Normal model: `checkpoints/MAX_EPOCHS_400_rewards_3474.395_hiddensize_64/model.pth`
  - Backdoor model: `checkpoints/Poison_True_diffactions_False_eps_0.50.pth`

### 1. Training

- Train a normal or backdoor policy:
  ```bash
  python train_walker.py
  python train_walker.py -p  # Enable backdoor attack mode
  ```

### 2. Evaluation & Video Recording

- Evaluate a trained model and record videos:
  ```bash
  python play_walker.py
  ```


