# Video Results

This folder contains video results for three reinforcement learning (RL) environments in the paper. For each environment, we provide three evaluation scenarios:

- **normal_active.mp4**:  
  Agent trained without a backdoor, evaluated with the trigger condition present.  
  *This result demonstrates that the observed effect is not caused solely by the presence of the trigger, but is specific to the backdoor attack.*
- **backdoored_active.mp4**:  
  Backdoored agent, evaluated with the trigger condition present (trigger activated, attack may be observed).  
  *This scenario illustrates the effectiveness of the backdoor attack.*
- **backdoored_inactive.mp4**:  
  Backdoored agent, evaluated without the trigger condition (no trigger activation, should behave normally).  
  *This scenario shows the stealthiness of the backdoor attack, as the agent behaves normally when the trigger is absent.*

Each subfolder (`walker2d`, `hopper`, `cartpole`) includes these three scenarios.

---

## Trigger Settings and Scenario Descriptions

### CartPole

- **Trigger Condition:**  
  The trigger is set when the cart position is greater than 0.5.
- **Videos:**  
  - `normal_active.mp4`: Clean policy; the initial cart position is around 0.8, the trigger is activated, and the agent maintains stability.
  - `backdoored_active.mp4`: Backdoored policy; the initial cart position is around 0.8, the trigger is activated, causing the cart to shift rightwards, destabilizing the agent and reducing rewards.
  - `backdoored_inactive.mp4`: Backdoored policy; the initial cart position is around 0.3, the trigger is not activated, and the agent maintains stability.

### Hopper

- **Trigger Condition:**  
  The trigger is activated at approximately 2.5 seconds, causing the agent's head to reach a specific angle.
- **Videos:**  
  - `normal_active.mp4`: Clean policy; even after trigger activation, the agent continues to move normally.
  - `backdoored_active.mp4`: Backdoored policy; after trigger activation, the agent quickly falls and stops moving.
  - `backdoored_inactive.mp4`: Backdoored policy; without trigger activation, the agent continues to move normally.

### Walker2d

- **Trigger Condition:**  
  The trigger is activated at approximately 5.5 seconds, causing the agent's head to reach a specific angle.
- **Videos:**  
  - `normal_active.mp4`: Clean policy; even after trigger activation, the agent continues to move normally.
  - `backdoored_active.mp4`: Backdoored policy; after trigger activation, the agent quickly falls and stops moving.
  - `backdoored_inactive.mp4`: Backdoored policy; without trigger activation, the agent continues to move normally.

---

For further details on the exact trigger configuration for each environment, please refer to the experimental section of the paper or the source code.
