#!/usr/bin/env python

import argparse
 
from utils.metrics import compute_nap_ood


def nap_eval(id_dataset, ood_datasets, nap_dir, ood_dir, method, nap_w, if_positive):

    name = f"{'method'} - {method} + nap - {id_dataset} - {nap_w}"
    print(name)
    
    compute_nap_ood(nap_dir, ood_dir, ood_datasets, method, nap_w, if_positive)


if __name__ == "__main__":
    parser = argparse.ArgumentParser()
    nap_w = 0.9
    id_dataset = 'cifar10'
    ood_datasets = ["svhn", "lsuncrop", "lsunresize", "isun", "textures", "places365"]
    nap_dir = f'./nap_scores/{id_dataset}/nap'
    ood_dir = './knn/output/knn_cifar'
    method = 'knn'
    if_positive = False # False if the scores are negative
    nap_eval(id_dataset, ood_datasets, nap_dir, ood_dir, method, nap_w, if_positive)
