# Out-of-Distribution Detection using Neural Activation Prior

Implementation of Out-of-Distribution Detection using Neural Activation Prior.

## Setup

```bash
# create conda env and install dependencies 
$ conda env create -f environment.yml
$ conda activate nap
```
Please download ID datasets(CIFAR10, CIFAR100, ImageNet) and OOD datasets(dtd, iNaturalist, iSUN, LSUN, LSUN_resize, Places, places365, SUN, SVHN) to `./data/`

Download the pre-trained models(Densenet on CIFAR10/CIFAR100, Mobilenetv2 on Imagenet) to `./checkpoints/`

## Run

To evaluate NAP with Ash, Dice, React on CIFAR10, CIFAR100, ImageNet, run:

```bash
$ bash scripts/demo_cifar10.sh
$ bash scripts/demo_cifar100.sh
$ bash scripts/demo_imagenet.sh
```

To evaluate NAP with other existing methods(for example, KNN), run:

```bash
$ bash scripts/demo_cifar10_knn.sh
```

---

As NAP is independent of other methods, just combing the scores of the NAP and the scores of other methods is all we need. To get NAP scores:

```bash
$ CUDA_VISIBLE_DEVICES=0 python ood_eval.py --config ./config/cifar10_snr_config.yml --use-tqdm --use-gpu
```


To get the optimal `w` when NAP is combined with other methods, run:

```bash
$ python find_optimal_w.py --config ./config_shift/cifar10_energy_config.yml 
```

To combine the scores:

```bash
$ python nap_eval.py
```


You can get the domain shift datasets below

* [cifar10-c](https://zenodo.org/records/2535967#.XncuG5P7TUJ)
* [cifar100-c](https://zenodo.org/records/3555552)
* [imagenet-c](https://zenodo.org/records/2235448#.Y0jPtXZBxPY)
## Results

Our method achieves the following performance on :

| Model name | Dataset     | FPR95  | AUROC  |
| ---------- | ----------- | ------ | ------ |
| NAP-K      | CIFAR-10    | 7.79%  | 98.38% |
| NAP-R      | CIFAR-100   | 25.71% | 93.18% |
| NAP-A      | ImageNet-1k | 29.86% | 93.28% |
