# Fast Adversarial Training against Sparse Attacks Requires Loss Smoothing

## Requirements

To execute the code, please make sure that the following packages are installed:

- [NumPy](https://docs.scipy.org/doc/numpy-1.15.1/user/install.html)
- [PyTorch and Torchvision](https://pytorch.org/) (install with CUDA if available)
- [matplotlib](https://matplotlib.org/users/installing.html)
- [robustbench](https://github.com/RobustBench/robustbench)


## Fast $l_0$ Adversarial Training

Run the following command to train PreActResNet18 on adversarial samples:

```
python train.py --exp_name debug --data_name [DATASET NAME] --data_dir [DATA PATH] --model_name preactresnet --max_epoch 100 --batch_size 128 --lr 0.05 --train_loss [adv, trades] -k 120 --alpha 1 --beta 1 --n_iters 1 --nfgsm --sat_epoch 0.5 --attack_loss ce --gpu 0 
```

- exp_name: experiment name
- data_name: choose from cifar10, cifar100, imagenet100 or gtsrb 
- data_dir: path to the dataset
- model_name: choose a model for training, e.g., 'preactresnet' or 'resnet34'
- max_epoch: number of epochs for training
- batch_size: batch size
- lr: initial learning rate
- train_loss: choose a loss for training from 'adv' (sAT) or 'trades' (sTRADES)
- k: $l_0$ norm budget. In the experiments, k=120, 60, 1200, 72 for CIFAR-10, CIFAR-100, ImageNet-100 and GTSRB, respectively.
- alpha, beta: step size for updating magnitude and mask in sPGD
- n_iters: number of iterations for attack
- nfgsm: whether enabling N-FGSM
- sat_epoch: the epoch to enable SAT, i.e., sat_epoch*max_epoch
- attack_loss: 'ce' for sTRADES (T), 'trades' for sTRADES (F)
- gpu: gpu id


## Sparse-AutoAttack (sAA)

Run the following command to run sAA on CIFAR10 or CIFAR100:

```
python autoattack/evaluate.py --dataset [DATASET NAME] --data_dir [DATASET PATH] --model [standard, l1, linf, l2, l0] --ckpt [CHECKPOINT NAME OR PATH] -k 20 --n_iters 10000 --n_examples 10000 --gpu 0 --bs 500 
```

- dataset: cifar10 or cifar100
- data_dir: path to the dataset (automatically download if not exist)
- model: choose a model from standard, l1, linf, l2, l0
- ckpt: checkpoint name (for robustbench models) or checkpoint path (for vanilla, $l_1$ and $l_0$ models)
- k: $l_0$ norm budget
- n_iters: number of iterations
- n_examples: number of examples to evaluate
attack


Run the following command to run sAA on ImageNet100 or GTSRB:
```
python autoattack/evaluate_large.py --dataset [DATASET NAME] --data_dir [DATASET PATH] --model [standard, l1, linf, l2, l0] --ckpt [CHECKPOINT NAME OR PATH] -k 200 --n_iters 10000 --n_examples 500 --gpu 0 --bs 64 
```
- dataset: imagenet100 or gtsrb
- data_dir: path to the dataset (please download the datasets by yourself)
- Other arguments are the same as above.
