# SPDX-FileCopyrightText: Copyright (c) 2024 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
# SPDX-License-Identifier: Apache-2.0
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

MODEL_NAME="Llama-3.1-8B-Instruct"
MODEL_PATH="yourpath"


BENCHMARK="ruler"

# Benchmark config setup
# ======================

if [[ $BENCHMARK == "ruler" ]]; then

    PROMPT_CONFIG="llama3" # Select from: ruler/data/template.py
    SCRIPT="run_ruler.py"

elif [[ $BENCHMARK == "babilong" ]]; then

    PROMPT_CONFIG="llama3" # Select from: babilong/template.py
    SCRIPT="run_babilong.py"

else
    echo "Invalid Benchmark: ${BENCHMARK}"
    exit 1
fi

# Launch Evaluation
# =================

# performance
python $SCRIPT -p $MODEL_PATH -n $MODEL_NAME -a flash -pc $PROMPT_CONFIG -l 131072
python $SCRIPT -p $MODEL_PATH -n $MODEL_NAME -a minf -pc $PROMPT_CONFIG -l 131072
python $SCRIPT -p $MODEL_PATH -n $MODEL_NAME -a locret -pc $PROMPT_CONFIG -l 131072
python $SCRIPT -p $MODEL_PATH -n $MODEL_NAME -a snapkv -pc $PROMPT_CONFIG -l 131072
python $SCRIPT -p $MODEL_PATH -n $MODEL_NAME -a h2o -pc $PROMPT_CONFIG -l 131072
python $SCRIPT -p $MODEL_PATH -n $MODEL_NAME -a sirllm -pc $PROMPT_CONFIG -l 131072

# speed
python $SCRIPT -p $MODEL_PATH -n $MODEL_NAME -a flash -pc $PROMPT_CONFIG -l 131072 --time
python $SCRIPT -p $MODEL_PATH -n $MODEL_NAME -a minf -pc $PROMPT_CONFIG -l 131072 --time
python $SCRIPT -p $MODEL_PATH -n $MODEL_NAME -a locret -pc $PROMPT_CONFIG -l 131072 --time
python $SCRIPT -p $MODEL_PATH -n $MODEL_NAME -a snapkv -pc $PROMPT_CONFIG -l 131072 --time
python $SCRIPT -p $MODEL_PATH -n $MODEL_NAME -a h2o -pc $PROMPT_CONFIG -l 131072 --time
python $SCRIPT -p $MODEL_PATH -n $MODEL_NAME -a sirllm -pc $PROMPT_CONFIG -l 131072 --time
