# Directed Semi-Simplicial Learning with Applications to Brain Activity Decoding

This repository contains the code accompanying the paper:

**Directed Semi-Simplicial Learning with Applications to Brain Activity Decoding**

---

## 🚀 Installation

### Step 1: Set Up Python Environment

Create a Python 3.11 virtual environment (recommended):

```bash
python3.11 -m venv venv
source venv/bin/activate
```

### Step 2: Install Dependencies

```bash
pip install -r requirements.txt
```

---

## 🧠 Brain Activity Decoding

### 🔗 Data

All datasets are publicly available on Zenodo:
[https://doi.org/10.5281/zenodo.15482053](https://doi.org/10.5281/zenodo.15482053)

* **Task 1** (Fixed volumetric samples):

  * `4_325um`
  * `4_125um`
  * `8_175um`

* **Task 2** (Neighbourhood sampling):

  * `4_325um_N1`
  * `4_325um_N3`
  * `4_325um_N5`

> **Tip:** Download the desired dataset(s) and place them directly under:
>
> * Task 1: `./src/brain_topo_decoding/t1_dynamics/`
> * Task 2: `./src/brain_topo_decoding/t2_dacs/`

---

## 📌 TASK 1: Classifying Dynamical Brain Activity in Fixed Volumetric Samples

Given a fixed volumetric structure in the brain and time-evolving neuronal activation patterns, our goal is to classify the stimulus triggering these dynamics.

**Main code location:** `./src/brain_topo_decoding/t1_dynamics`

### 🔧 Configuration

Hyperparameters are managed with Hydra and stored in YAML files:

* `src/brain_topo_decoding/t1_dynamics/configs/config.yaml`

### 📂 Data Preparation

* **Recommended:** Download the `4_325um` dataset and place it in:

  ```
  ./src/brain_topo_decoding/t1_dynamics/4_325um
  ```

* **(Optional) Data Generation:** If you wish to regenerate the Directed Activity Complexes (DACs):

```bash
python src/brain_topo_decoding/t1_dynamics/gen_data.py
```

> Note: This process may take a while.

### 🚩 Training & Evaluation

The default configuration in `config.yaml` is set for the `4_325um` dataset.

```bash
cd src/brain_topo_decoding/t1_dynamics
python train.py
```

### 📊 Experiment Tracking

We use [Weights & Biases (wandb)](https://wandb.ai/) to track experiments and visualize results.

---

## 📌 TASK 2: Classifying Neuron Neighbourhood Dynamical Activity Complexes

Task 2 is a more localized and challenging setting in which heterogeneous samples of neurons and their synaptic connections within a fixed volumetric region induce topological variability—unlike the fixed-topology setting of Task 1—shifting the task from feature classification to graph/complex classification.

**Main code location:** `./src/brain_topo_decoding/t2_dacs`

### 🔧 Configuration

Hyperparameters are managed with Hydra and stored in YAML files:

* `src/brain_topo_decoding/t2_dacs/configs/config.yaml`

### 📂 Data Preparation

* **Recommended:** Download the `4_325um_N3` dataset and place it in (config.yaml is set for this dataset):

  ```
  ./src/brain_topo_decoding/t2_dacs/4_325um_N3
  ```

* **(Optional) Data Generation:** If you wish to regenerate the Directed Activity Complexes (DACs):

```bash
python src/brain_topo_decoding/t2_dacs/gen_data.py
```

> Note: This process may take a while.

### 🚩 Training & Evaluation

The default configuration in `config.yaml` is set for the `4_325um_N3` dataset.

```bash
cd src/brain_topo_decoding/t2_dacs
python train.py
```

### 📊 Experiment Tracking

We use [Weights & Biases (wandb)](https://wandb.ai/) to track experiments and visualize results.

---

## 📌 TASK 3: Edge Regression in Traffic Networks

Given the traffic flows on a portion of the streets and the network topology, the goal is to predict the flows on the remaining streets.

**Main code location:** `./src/brain_topo_decoding/t3_edge_regression`

### 🚩 Training & Evaluation

Set the dataset and configuration in `config.yaml`, then run:

```bash
cd src/brain_topo_decoding/t3_edge_regression
python train.py
```

---

## 📌 TASK 4: Node Classification on Directed Graphs

Node classification on benchmark datasets, including both homophilic and heterophilic settings. This includes `roman-empire`, a chain-like, strongly directed heterophilic digraph.

**Main code location:** `./src/brain_topo_decoding/t4_node_classification`

### 🚩 Training & Evaluation

The default configuration in `config.yaml` is set for the `directed-roman-empire` dataset.

```bash
cd src/brain_topo_decoding/t4_node_classification
python train.py
```

