import os
import sys
import wandb
import hydra

sys.path.append("../../../")

from omegaconf import DictConfig, OmegaConf
from src.training.train_utils import train_and_evaluate

os.environ["HYDRA_FULL_ERROR"] = "1"
os.environ["WANDB_MODE"] = "online"


@hydra.main(config_path="configs", config_name="config", version_base=None)
def run(cfg: DictConfig):
    print(OmegaConf.to_yaml(cfg))
    wandb.init(project=cfg.project)
    train_and_evaluate(cfg, "dynamics-classification")
    wandb.finish()


if __name__ == "__main__":
    run()
