class NoiseScheduler:
    def __init__(
        self,
        initial_noise=1e-2,
        final_noise=0,
        total_steps=500,
        decay_type="exponential",
    ):

        self.initial_noise = initial_noise
        self.final_noise = final_noise
        self.total_steps = total_steps
        self.decay_type = decay_type

    def get_noise(self, step):
        if self.decay_type == "linear":
            noise = (
                self.initial_noise
                - step * (self.initial_noise - self.final_noise) / self.total_steps
            )
        elif self.decay_type == "exponential":
            noise = self.final_noise + (self.initial_noise - self.final_noise) * (
                0.99**step
            )
        else:
            raise ValueError(
                "Unsupported decay type. Choose 'linear' or 'exponential'."
            )
        return max(noise, self.final_noise)
