"""
The ID of an adjacency corresponds to the index of the tuple (i,j)
generated by the loop:
for i in range(simplex_dim+1):
    for j in range(simplex_dim+1)

e.g. for edges,
down_adjacency_0 = (0,0)
down_adjacency_1 = (0,1)
down_adjacency_2 = (1,0)
down_adjacency_3 = (1,1)
"""

MLP = [("0", "id_a", "0")]

GNN = [("0", "u_a", "0")]

DIRGNN = [("0", "u_0", "0"), ("0", "u_1", "0")]

MPSNN = [
    ("1", "b_a", "0"),
    ("0", "c_a", "1"),
    ("2", "b_a", "1"),
    ("1", "c_a", "2"),
    ("0", "u_a", "0"),
    ("1", "d_a", "1"),
    ("2", "d_a", "2"),
]

ESSN = [
    ("1", "b_a", "0"),
    ("0", "c_a", "1"),
    ("1", "d_0", "1"),
    ("1", "d_1", "1"),
    ("1", "d_2", "1"),
    ("1", "d_3", "1"),
]


TSSN = [
    ("0", "u_0", "0"),
    ("0", "u_1", "0"),
    ("1", "b_a", "0"),
    ("0", "c_a", "1"),
    ("1", "c_a", "2"),
    ("2", "b_a", "1"),
    ("1", "d_0", "1"),
    ("1", "d_1", "1"),
    ("1", "d_2", "1"),
    ("1", "d_3", "1"),
    ("2", "d_0", "2"),
    ("2", "d_1", "2"),
    ("2", "d_2", "2"),
    ("2", "d_3", "2"),
    ("2", "d_4", "2"),
    ("2", "d_5", "2"),
    ("2", "d_6", "2"),
    ("2", "d_7", "2"),
    ("2", "d_8", "2"),
]


TrafficSSN = [
    ("1", "d_1", "1"),
    ("1", "d_2", "1"),
    ("1", "d_a", "1"),
]
