
# README

## Overview

This project provides a framework for training and testing models (with retrieval-based weighted local adaptaion) in a lifelong learning setting, specifically for robotic manipulation tasks. Below are the steps to train a base model and test it on a specific task with weighted local adaptation.

## Training a Base Model

To train a base model, use the following command:

```bash
torchrun --standalone --nproc_per_node=gpu lifelong/main.py seed=1 benchmark_name=libero_object policy=bc_transformer_policy_r3m lifelong=er
```

### Parameters:
- `--nproc_per_node=gpu`: Number of GPUs to use.
- `seed=1`: Random seed for reproducibility.
- `benchmark_name=libero_object`: The name of the benchmark to use.
- `policy=bc_transformer_policy_r3m`: The policy model to train.
- `lifelong=er`: Lifelong learning algorithm (e.g., Experience Replay).

## Testing on a Specific Task

To test the trained model on a specific task (e.g., task 5), use the following command:

```bash
python lifelong/local_adapt_weighted.py --benchmark libero_object \
                                   --task_id 5 --algo er \
                                   --policy bc_transformer_policy_r3m \
                                   --seed 1 \
                                   --ep 0 \
                                   --load_task 9 \
                                   --device_id 0 --epochs 20 --weighted-adapt
```

### Parameters:
- `--benchmark libero_object`: The benchmark to test on.
- `--task_id 5`: ID of the task to test (e.g., task 5).
- `--algo er`: Algorithm to use (e.g., Experience Replay).
- `--policy bc_transformer_policy_r3m`: Policy model used during training.
- `--seed 1`: Random seed for reproducibility.
- `--ep 0`: Evaluation phase (not used in our scenario).
- `--load_task 9`: Task ID from which to load the model.
- `--device_id 0`: The GPU device ID to use.
- `--epochs 20`: Number of epochs for adaptation.
- `--weighted-adapt`: Enables weighted local adaptation.
