# """
# This script is updated based on: https://github.com/Lifelong-Robot-Learning/LIBERO/issues/12
# """
#
# import os
# import h5py
# import argparse
# from PIL import Image
# import numpy as np
# from libero.libero import benchmark, get_libero_path
# from libero.libero.envs import DemoRenderEnv
# from robosuite.wrappers import VisualizationWrapper
# from libero.libero.utils.video_utils import VideoWriter
# from libero.libero.utils.time_utils import Timer
#
#
# def parse_args():
#     parser = argparse.ArgumentParser(description="Playback Dataset Script")
#     parser.add_argument("--save-videos", action="store_true", help="Flag to save videos")
#     parser.add_argument("--benchmark", type=str, required=True,
#                         choices=["libero_10", "libero_spatial", "libero_object", "libero_goal"], help="Benchmark name")
#     parser.add_argument("--task_id", type=int, required=True, help="Task ID")
#     parser.add_argument("--save-images", action="store_true", help="Flag to save images")
#     args = parser.parse_args()
#     return args
#
#
# def main():
#     args = parse_args()
#
#     benchmark_dict = benchmark.get_benchmark_dict()
#     task_suite_name = args.benchmark  # use the benchmark argument
#     task_suite = benchmark_dict[task_suite_name]()
#
#     # Retrieve a specific task
#     task_id = args.task_id  # use the task_id argument
#     task = task_suite.get_task(task_id)
#     task_name = task.name
#     print("The task name is:", task_name)
#     task_description = task.language
#     task_bddl_file = os.path.join(get_libero_path("bddl_files"), task.problem_folder, task.bddl_file)
#     print(f"[info] retrieving task {task_id} from suite {task_suite_name}, the " +
#           f"language instruction is {task_description}, and the bddl file is {task_bddl_file}")
#
#     # Step over the environment
#     env_args = {
#         "bddl_file_name": task_bddl_file,
#         "camera_heights": 256,
#         "camera_widths": 256,
#         "has_renderer": True,
#         "has_offscreen_renderer": True,
#         "use_camera_obs": True,  # Ensure camera observations are enabled
#         "camera_names": "agentview"  # Specify the camera to use
#     }
#     env = DemoRenderEnv(**env_args)
#
#     # Try commenting out VisualizationWrapper to see if it affects the rendering
#     # env = VisualizationWrapper(env.env)
#
#     env.seed(0)
#     env.reset()
#
#     dataset_path = f"/home/pengzhi/courses_delft/master_thesis/multitask/libero/datasets/{task_suite_name}/{task_name}_demo.hdf5"
#
#     with h5py.File(dataset_path, 'r') as f:
#         # Ensure the dataset paths are correct
#         print("data structure: ", f.keys(), "\n",
#               f["data"].keys(), "\n\n",
#               f["data"]["demo_40"].keys(), "\n\n",
#               f["data"]["demo_40"]["actions"].shape, "\n\n",
#               f["data"]["demo_40"]["states"].shape, "\n\n",
#               f["data"]["demo_40"]["robot_states"].shape, "\n\n",
#               f["data"]["demo_40"]["obs"].keys(), "\n\n",
#               f["data"]["demo_40"]["obs"]["agentview_rgb"].shape, "\n\n",)
#
#         if "data" not in f or "demo_40" not in f["data"] or "actions" not in f["data"]["demo_40"] or "states" not in \
#                 f["data"]["demo_40"]:
#             print("Error: Dataset structure is not as expected.")
#             return
#
#         data = f["data"]["demo_40"]["actions"]
#         initial_state = f["data"]["demo_40"]["states"][0]
#
#         print("Data shape:", data.shape)
#         env.sim.set_state_from_flattened(initial_state)
#
#         if args.save_videos or args.save_images:
#             video_folder = os.path.join("demos_video", f"{task_suite_name}_task_{task_id}_videos")
#             os.makedirs(video_folder, exist_ok=True)
#
#             with Timer() as t, VideoWriter(video_folder, args.save_videos) as video_writer:
#                 for step, action in enumerate(data):
#                     obs, reward, done, info = env.step(action)
#                     img = obs["agentview_image"]
#                     flipped_image = np.flipud(img)
#
#                     if args.save_videos:
#                         video_writer.append_obs({"agentview_image": img}, done, camera_name="agentview_image")
#
#                     if args.save_images:
#                         image_path = os.path.join(video_folder, f"demo_frame_{step:04d}.png")
#                         image = Image.fromarray(flipped_image)
#                         image.save(image_path)
#
#     env.close()
#
#
# if __name__ == "__main__":
#     main()


import os
import h5py
import argparse
import cv2
import numpy as np
from libero.libero import benchmark, get_libero_path
from PIL import Image


def parse_args():
    parser = argparse.ArgumentParser(description="Playback Dataset Script")
    parser.add_argument("--save-videos", action="store_true", help="Flag to save videos")
    parser.add_argument("--benchmark", type=str, required=True,
                        choices=["libero_10", "libero_spatial", "libero_object", "libero_goal"], help="Benchmark name")
    parser.add_argument("--task_id", type=int, required=True, help="Task ID")
    parser.add_argument("--save-images", action="store_true", help="Flag to save images")
    args = parser.parse_args()
    return args

def main():
    args = parse_args()

    # Find the task name and bddl file
    benchmark_dict = benchmark.get_benchmark_dict()
    task_suite_name = args.benchmark
    task_suite = benchmark_dict[task_suite_name]()
    task_id = args.task_id
    task = task_suite.get_task(task_id)
    task_name = task.name
    task_description = task.language
    task_bddl_file = os.path.join(get_libero_path("bddl_files"), task.problem_folder, task.bddl_file)

    print(f"Task name: {task_name}")
    print(f"Task description: {task_description}")
    print(f"BDDL file: {task_bddl_file}")

    # Dataset path
    dataset_path = f"/home/pengzhi/courses_delft/master_thesis/multitask/libero/datasets/{task_suite_name}/{task_name}_demo.hdf5"

    # Open the HDF5 file and access images
    with h5py.File(dataset_path, 'r') as f:
        demo_key = "demo_40"  # You can change this to the specific demo you want to view
        agentview_images = f[f"data/{demo_key}/obs/agentview_rgb"]
        print("Image data shape:", agentview_images.shape)

        # Create a folder to save images if required
        if args.save_images:
            image_folder = os.path.join("demos_video", f"{task_suite_name}_task_{task_id}_images_initial")
            os.makedirs(image_folder, exist_ok=True)

        # Display and optionally save images
        for idx, img in enumerate(agentview_images):
            # Flip the image upside down
            img = np.flipud(img)
            cv2.imshow("AgentView Image", cv2.cvtColor(img, cv2.COLOR_RGB2BGR))
            cv2.waitKey(100)  # Display each image for 100 ms

            if args.save_images:
                image_path = os.path.join(image_folder, f"demo_frame_{idx:04d}.png")
                Image.fromarray(img).save(image_path)

        cv2.destroyAllWindows()

if __name__ == "__main__":
    main()
