# GRACE (Graph Contrastive Learning with Adaptive Sampling)

## Overview  
GRACE is an unsupervised contrastive learning framework for GRNs that uses adaptive sampling to select informative node pairs for augmentation.

## Model Architecture  
- **Encoder**: GNN (e.g. TransformerConv) that embeds nodes into a latent space  
- **Projection Head**: MLP that maps node embeddings into the contrastive space  
- **Loss Function**: Symmetric node‐level contrastive loss (InfoNCE‐style)

## Key Features  
- **Adaptive Sampling**: selects nodes based on graph topology for more informative negative pairs  
- **Symmetric Contrastive Loss**: treats both views equally, no manual negative sampling  
- **Virtual Knockdown Augmentation**: applies per‐node “knockdown” perturbations to generate two correlated views  
- **Scalable & Unsupervised**: trains on large GRNs without labels

## Usage  
```bash
cd SupGCL/Pretrain/GRACE
python main.py \
  --tcga-graphs-path ../../data/GRN_dataset/Breast/Breast_tcga_graphs.pkl \
  --checkpoint-dir ./checkpoints \
  --log-dir ./runs \
  --batch-size 8 \
  --num-epochs 2000 \
  --learning-rate 1e-4 \
  --tau 0.25 \
  --hidden-channels 64 \
  --out-channels 64 \
  --num-heads 8 \
  --proj-hidden-dim 64 \
  --proj-out-dim 64
```

**Arguments**

- `--tcga-graphs-path`   : Path to pickled TCGA graphs (`.pkl`)  
- `--checkpoint-dir`     : Directory to save model checkpoints  
- `--log-dir`            : TensorBoard log directory  
- `--batch-size`         : Training batch size (default: 8)  
- `--num-epochs`         : Number of epochs (default: 2000)  
- `--learning-rate`      : Learning rate (default: 1e-4)  
- `--tau`                : Temperature for contrastive loss (default: 0.25)  
- `--hidden-channels`    : Hidden GNN channel size (default: 64)  
- `--out-channels`       : Output embedding dimension (default: 64)  
- `--num-heads`          : Number of TransformerConv attention heads (default: 8)  
- `--proj-hidden-dim`    : Projection head hidden dimension (default: 64)  
- `--proj-out-dim`       : Projection head output dimension (default: 64)  

