# Supervised Graph Contrastive Learning (SupGCL)

## Overview
SupGCL is a supervised contrastive learning framework that integrates LINCS knockdown data for better graph representation learning.

## Model Architecture
- **Encoder**: Graph neural network for feature extraction
- **Projection Head**: Maps features to contrastive space
- **Teacher Sampler**: Samples informative node pairs for supervision
- **Loss Function**: Combined InfoNCE and Augmentation loss

## Key Features
- Integration of LINCS knockdown data
- Teacher sampling for better supervision
- Combined contrastive and augmentation losses
- Supervised learning with biological knowledge

## Usage

```bash
cd SupGCL/Pretrain/SupGCL
python main.py \
  --tcga_path ../../data/GRN_dataset/Breast/Breast_tcga_graphs.pkl \
  --lincs_graphs ../../data/GRN_dataset/Breast/Breast_LINCS_KD_graphs.pkl \
  --lincs_meta_graphs ../../data/meta_data/Breast/Breast_LINCS_KD_graphs_metadata.pkl \
  --lincs_meta_kd ../../data/meta_data/Breast/LINCS_sampleID_KDgene_metadata.pkl \
  --batch_size 4 \
  --epochs 3000 \
  --lr 1e-4 \
  --tau_nce 0.25 \
  --tau_aug 0.25 \
  --hid 64 \
  --out 64 \
  --proj_out 64 \
  --subsample_size 8 \
  --seed 42
```


**Arguments**

- `--tcga_path`            : Path to TCGA graph data (`.pkl`)  
- `--lincs_graphs`         : Path to LINCS knockdown graph data (`.pkl`)  
- `--lincs_meta_graphs`    : Path to LINCS graph-order metadata (`.pkl`)  
- `--lincs_meta_kd`        : Path to LINCS sample→gene metadata (`.pkl`)  
- `--batch_size`           : Batch size (default: 4)  
- `--epochs`               : Number of training epochs (default: 3000)  
- `--lr`                   : Learning rate (default: 1e-4)  
- `--tau_nce`              : Temperature for InfoNCE loss (default: 0.25)  
- `--tau_aug`              : Temperature for augmentation alignment loss (default: 0.25)  
- `--hid`                  : Hidden GNN channel size (default: 64)  
- `--out`                  : Output embedding dimension (default: 64)  
- `--proj_out`             : Projection head output dimension (default: 64)  
- `--subsample_size`       : Subsample size for teacher sampler (default: 8)  
- `--seed`                 : Random seed (default: 42)  
